import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RedisEnterpriseDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#client_protocol RedisEnterpriseDatabase#client_protocol}.
     *
     * @stability stable
     */
    readonly clientProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#cluster_id RedisEnterpriseDatabase#cluster_id}.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#clustering_policy RedisEnterpriseDatabase#clustering_policy}.
     *
     * @stability stable
     */
    readonly clusteringPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#eviction_policy RedisEnterpriseDatabase#eviction_policy}.
     *
     * @stability stable
     */
    readonly evictionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#name RedisEnterpriseDatabase#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#port RedisEnterpriseDatabase#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#resource_group_name RedisEnterpriseDatabase#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * module block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#module RedisEnterpriseDatabase#module}
     *
     * @stability stable
     */
    readonly module?: RedisEnterpriseDatabaseModule[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#timeouts RedisEnterpriseDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RedisEnterpriseDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface RedisEnterpriseDatabaseModule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#args RedisEnterpriseDatabase#args}.
     *
     * @stability stable
     */
    readonly args?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#name RedisEnterpriseDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function redisEnterpriseDatabaseModuleToTerraform(struct?: RedisEnterpriseDatabaseModule | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface RedisEnterpriseDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#create RedisEnterpriseDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#delete RedisEnterpriseDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database#read RedisEnterpriseDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function redisEnterpriseDatabaseTimeoutsToTerraform(struct?: RedisEnterpriseDatabaseTimeoutsOutputReference | RedisEnterpriseDatabaseTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class RedisEnterpriseDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RedisEnterpriseDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RedisEnterpriseDatabaseTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database azurerm_redis_enterprise_database}.
 *
 * @stability stable
 */
export declare class RedisEnterpriseDatabase extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/redis_enterprise_database azurerm_redis_enterprise_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RedisEnterpriseDatabaseConfig);
    private _clientProtocol?;
    /**
     * @stability stable
     */
    get clientProtocol(): string;
    /**
     * @stability stable
     */
    set clientProtocol(value: string);
    /**
     * @stability stable
     */
    resetClientProtocol(): void;
    /**
     * @stability stable
     */
    get clientProtocolInput(): string | undefined;
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
    private _clusteringPolicy?;
    /**
     * @stability stable
     */
    get clusteringPolicy(): string;
    /**
     * @stability stable
     */
    set clusteringPolicy(value: string);
    /**
     * @stability stable
     */
    resetClusteringPolicy(): void;
    /**
     * @stability stable
     */
    get clusteringPolicyInput(): string | undefined;
    private _evictionPolicy?;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    set evictionPolicy(value: string);
    /**
     * @stability stable
     */
    resetEvictionPolicy(): void;
    /**
     * @stability stable
     */
    get evictionPolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    private _module?;
    /**
     * @stability stable
     */
    get module(): RedisEnterpriseDatabaseModule[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set module(value: RedisEnterpriseDatabaseModule[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetModule(): void;
    /**
     * @stability stable
     */
    get moduleInput(): cdktf.IResolvable | RedisEnterpriseDatabaseModule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): RedisEnterpriseDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RedisEnterpriseDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RedisEnterpriseDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
