import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RouteConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#address_prefix Route#address_prefix}.
     *
     * @stability stable
     */
    readonly addressPrefix: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#name Route#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#next_hop_in_ip_address Route#next_hop_in_ip_address}.
     *
     * @stability stable
     */
    readonly nextHopInIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#next_hop_type Route#next_hop_type}.
     *
     * @stability stable
     */
    readonly nextHopType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#resource_group_name Route#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#route_table_name Route#route_table_name}.
     *
     * @stability stable
     */
    readonly routeTableName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#timeouts Route#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RouteTimeouts;
}
/**
 * @stability stable
 */
export interface RouteTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#create Route#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#delete Route#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#read Route#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route#update Route#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function routeTimeoutsToTerraform(struct?: RouteTimeoutsOutputReference | RouteTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class RouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RouteTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RouteTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/route azurerm_route}.
 *
 * @stability stable
 */
export declare class Route extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/route azurerm_route} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RouteConfig);
    private _addressPrefix?;
    /**
     * @stability stable
     */
    get addressPrefix(): string;
    /**
     * @stability stable
     */
    set addressPrefix(value: string);
    /**
     * @stability stable
     */
    get addressPrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nextHopInIpAddress?;
    /**
     * @stability stable
     */
    get nextHopInIpAddress(): string;
    /**
     * @stability stable
     */
    set nextHopInIpAddress(value: string);
    /**
     * @stability stable
     */
    resetNextHopInIpAddress(): void;
    /**
     * @stability stable
     */
    get nextHopInIpAddressInput(): string | undefined;
    private _nextHopType?;
    /**
     * @stability stable
     */
    get nextHopType(): string;
    /**
     * @stability stable
     */
    set nextHopType(value: string);
    /**
     * @stability stable
     */
    get nextHopTypeInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _routeTableName?;
    /**
     * @stability stable
     */
    get routeTableName(): string;
    /**
     * @stability stable
     */
    set routeTableName(value: string);
    /**
     * @stability stable
     */
    get routeTableNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): RouteTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RouteTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RouteTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
