import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#create_option Snapshot#create_option}.
     *
     * @stability stable
     */
    readonly createOption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#disk_size_gb Snapshot#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#location Snapshot#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#name Snapshot#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#resource_group_name Snapshot#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#source_resource_id Snapshot#source_resource_id}.
     *
     * @stability stable
     */
    readonly sourceResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#source_uri Snapshot#source_uri}.
     *
     * @stability stable
     */
    readonly sourceUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#storage_account_id Snapshot#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#tags Snapshot#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * encryption_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#encryption_settings Snapshot#encryption_settings}
     *
     * @stability stable
     */
    readonly encryptionSettings?: SnapshotEncryptionSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#timeouts Snapshot#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SnapshotTimeouts;
}
/**
 * @stability stable
 */
export interface SnapshotEncryptionSettingsDiskEncryptionKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#secret_url Snapshot#secret_url}.
     *
     * @stability stable
     */
    readonly secretUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#source_vault_id Snapshot#source_vault_id}.
     *
     * @stability stable
     */
    readonly sourceVaultId: string;
}
export declare function snapshotEncryptionSettingsDiskEncryptionKeyToTerraform(struct?: SnapshotEncryptionSettingsDiskEncryptionKeyOutputReference | SnapshotEncryptionSettingsDiskEncryptionKey): any;
/**
 * @stability stable
 */
export declare class SnapshotEncryptionSettingsDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SnapshotEncryptionSettingsDiskEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SnapshotEncryptionSettingsDiskEncryptionKey | undefined);
    private _secretUrl?;
    /**
     * @stability stable
     */
    get secretUrl(): string;
    /**
     * @stability stable
     */
    set secretUrl(value: string);
    /**
     * @stability stable
     */
    get secretUrlInput(): string | undefined;
    private _sourceVaultId?;
    /**
     * @stability stable
     */
    get sourceVaultId(): string;
    /**
     * @stability stable
     */
    set sourceVaultId(value: string);
    /**
     * @stability stable
     */
    get sourceVaultIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SnapshotEncryptionSettingsKeyEncryptionKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#key_url Snapshot#key_url}.
     *
     * @stability stable
     */
    readonly keyUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#source_vault_id Snapshot#source_vault_id}.
     *
     * @stability stable
     */
    readonly sourceVaultId: string;
}
export declare function snapshotEncryptionSettingsKeyEncryptionKeyToTerraform(struct?: SnapshotEncryptionSettingsKeyEncryptionKeyOutputReference | SnapshotEncryptionSettingsKeyEncryptionKey): any;
/**
 * @stability stable
 */
export declare class SnapshotEncryptionSettingsKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SnapshotEncryptionSettingsKeyEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SnapshotEncryptionSettingsKeyEncryptionKey | undefined);
    private _keyUrl?;
    /**
     * @stability stable
     */
    get keyUrl(): string;
    /**
     * @stability stable
     */
    set keyUrl(value: string);
    /**
     * @stability stable
     */
    get keyUrlInput(): string | undefined;
    private _sourceVaultId?;
    /**
     * @stability stable
     */
    get sourceVaultId(): string;
    /**
     * @stability stable
     */
    set sourceVaultId(value: string);
    /**
     * @stability stable
     */
    get sourceVaultIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SnapshotEncryptionSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#enabled Snapshot#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#disk_encryption_key Snapshot#disk_encryption_key}
     *
     * @stability stable
     */
    readonly diskEncryptionKey?: SnapshotEncryptionSettingsDiskEncryptionKey;
    /**
     * key_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#key_encryption_key Snapshot#key_encryption_key}
     *
     * @stability stable
     */
    readonly keyEncryptionKey?: SnapshotEncryptionSettingsKeyEncryptionKey;
}
export declare function snapshotEncryptionSettingsToTerraform(struct?: SnapshotEncryptionSettingsOutputReference | SnapshotEncryptionSettings): any;
/**
 * @stability stable
 */
export declare class SnapshotEncryptionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SnapshotEncryptionSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SnapshotEncryptionSettings | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskEncryptionKey;
    /**
     * @stability stable
     */
    get diskEncryptionKey(): SnapshotEncryptionSettingsDiskEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putDiskEncryptionKey(value: SnapshotEncryptionSettingsDiskEncryptionKey): void;
    /**
     * @stability stable
     */
    resetDiskEncryptionKey(): void;
    /**
     * @stability stable
     */
    get diskEncryptionKeyInput(): SnapshotEncryptionSettingsDiskEncryptionKey | undefined;
    private _keyEncryptionKey;
    /**
     * @stability stable
     */
    get keyEncryptionKey(): SnapshotEncryptionSettingsKeyEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putKeyEncryptionKey(value: SnapshotEncryptionSettingsKeyEncryptionKey): void;
    /**
     * @stability stable
     */
    resetKeyEncryptionKey(): void;
    /**
     * @stability stable
     */
    get keyEncryptionKeyInput(): SnapshotEncryptionSettingsKeyEncryptionKey | undefined;
}
/**
 * @stability stable
 */
export interface SnapshotTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#create Snapshot#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#delete Snapshot#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#read Snapshot#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot#update Snapshot#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function snapshotTimeoutsToTerraform(struct?: SnapshotTimeoutsOutputReference | SnapshotTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SnapshotTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SnapshotTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot azurerm_snapshot}.
 *
 * @stability stable
 */
export declare class Snapshot extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/snapshot azurerm_snapshot} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SnapshotConfig);
    private _createOption?;
    /**
     * @stability stable
     */
    get createOption(): string;
    /**
     * @stability stable
     */
    set createOption(value: string);
    /**
     * @stability stable
     */
    get createOptionInput(): string | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sourceResourceId?;
    /**
     * @stability stable
     */
    get sourceResourceId(): string;
    /**
     * @stability stable
     */
    set sourceResourceId(value: string);
    /**
     * @stability stable
     */
    resetSourceResourceId(): void;
    /**
     * @stability stable
     */
    get sourceResourceIdInput(): string | undefined;
    private _sourceUri?;
    /**
     * @stability stable
     */
    get sourceUri(): string;
    /**
     * @stability stable
     */
    set sourceUri(value: string);
    /**
     * @stability stable
     */
    resetSourceUri(): void;
    /**
     * @stability stable
     */
    get sourceUriInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _encryptionSettings;
    /**
     * @stability stable
     */
    get encryptionSettings(): SnapshotEncryptionSettingsOutputReference;
    /**
     * @stability stable
     */
    putEncryptionSettings(value: SnapshotEncryptionSettings): void;
    /**
     * @stability stable
     */
    resetEncryptionSettings(): void;
    /**
     * @stability stable
     */
    get encryptionSettingsInput(): SnapshotEncryptionSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SnapshotTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SnapshotTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SnapshotTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
