import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageAccountNetworkRulesAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#bypass StorageAccountNetworkRulesA#bypass}.
     *
     * @stability stable
     */
    readonly bypass?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#default_action StorageAccountNetworkRulesA#default_action}.
     *
     * @stability stable
     */
    readonly defaultAction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#ip_rules StorageAccountNetworkRulesA#ip_rules}.
     *
     * @stability stable
     */
    readonly ipRules?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#resource_group_name StorageAccountNetworkRulesA#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#storage_account_id StorageAccountNetworkRulesA#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#storage_account_name StorageAccountNetworkRulesA#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#virtual_network_subnet_ids StorageAccountNetworkRulesA#virtual_network_subnet_ids}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetIds?: string[];
    /**
     * private_link_access block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#private_link_access StorageAccountNetworkRulesA#private_link_access}
     *
     * @stability stable
     */
    readonly privateLinkAccess?: StorageAccountNetworkRulesPrivateLinkAccessA[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#timeouts StorageAccountNetworkRulesA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageAccountNetworkRulesTimeouts;
}
/**
 * @stability stable
 */
export interface StorageAccountNetworkRulesPrivateLinkAccessA {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#endpoint_resource_id StorageAccountNetworkRulesA#endpoint_resource_id}.
     *
     * @stability stable
     */
    readonly endpointResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#endpoint_tenant_id StorageAccountNetworkRulesA#endpoint_tenant_id}.
     *
     * @stability stable
     */
    readonly endpointTenantId?: string;
}
export declare function storageAccountNetworkRulesPrivateLinkAccessAToTerraform(struct?: StorageAccountNetworkRulesPrivateLinkAccessA | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface StorageAccountNetworkRulesTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#create StorageAccountNetworkRulesA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#delete StorageAccountNetworkRulesA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#read StorageAccountNetworkRulesA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules#update StorageAccountNetworkRulesA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageAccountNetworkRulesTimeoutsToTerraform(struct?: StorageAccountNetworkRulesTimeoutsOutputReference | StorageAccountNetworkRulesTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class StorageAccountNetworkRulesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageAccountNetworkRulesTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageAccountNetworkRulesTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules azurerm_storage_account_network_rules}.
 *
 * @stability stable
 */
export declare class StorageAccountNetworkRulesA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account_network_rules azurerm_storage_account_network_rules} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageAccountNetworkRulesAConfig);
    private _bypass?;
    /**
     * @stability stable
     */
    get bypass(): string[];
    /**
     * @stability stable
     */
    set bypass(value: string[]);
    /**
     * @stability stable
     */
    resetBypass(): void;
    /**
     * @stability stable
     */
    get bypassInput(): string[] | undefined;
    private _defaultAction?;
    /**
     * @stability stable
     */
    get defaultAction(): string;
    /**
     * @stability stable
     */
    set defaultAction(value: string);
    /**
     * @stability stable
     */
    get defaultActionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipRules?;
    /**
     * @stability stable
     */
    get ipRules(): string[];
    /**
     * @stability stable
     */
    set ipRules(value: string[]);
    /**
     * @stability stable
     */
    resetIpRules(): void;
    /**
     * @stability stable
     */
    get ipRulesInput(): string[] | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetResourceGroupName(): void;
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountName(): void;
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _virtualNetworkSubnetIds?;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIds(): string[];
    /**
     * @stability stable
     */
    set virtualNetworkSubnetIds(value: string[]);
    /**
     * @stability stable
     */
    resetVirtualNetworkSubnetIds(): void;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
    private _privateLinkAccess?;
    /**
     * @stability stable
     */
    get privateLinkAccess(): StorageAccountNetworkRulesPrivateLinkAccessA[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateLinkAccess(value: StorageAccountNetworkRulesPrivateLinkAccessA[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateLinkAccess(): void;
    /**
     * @stability stable
     */
    get privateLinkAccessInput(): cdktf.IResolvable | StorageAccountNetworkRulesPrivateLinkAccessA[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageAccountNetworkRulesTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageAccountNetworkRulesTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageAccountNetworkRulesTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
