import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageManagementPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#storage_account_id StorageManagementPolicy#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#rule StorageManagementPolicy#rule}
     *
     * @stability stable
     */
    readonly rule?: StorageManagementPolicyRule[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#timeouts StorageManagementPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageManagementPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface StorageManagementPolicyRuleActionsBaseBlob {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete_after_days_since_modification_greater_than StorageManagementPolicy#delete_after_days_since_modification_greater_than}.
     *
     * @stability stable
     */
    readonly deleteAfterDaysSinceModificationGreaterThan?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_archive_after_days_since_modification_greater_than StorageManagementPolicy#tier_to_archive_after_days_since_modification_greater_than}.
     *
     * @stability stable
     */
    readonly tierToArchiveAfterDaysSinceModificationGreaterThan?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_cool_after_days_since_modification_greater_than StorageManagementPolicy#tier_to_cool_after_days_since_modification_greater_than}.
     *
     * @stability stable
     */
    readonly tierToCoolAfterDaysSinceModificationGreaterThan?: number;
}
export declare function storageManagementPolicyRuleActionsBaseBlobToTerraform(struct?: StorageManagementPolicyRuleActionsBaseBlobOutputReference | StorageManagementPolicyRuleActionsBaseBlob): any;
/**
 * @stability stable
 */
export declare class StorageManagementPolicyRuleActionsBaseBlobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageManagementPolicyRuleActionsBaseBlob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageManagementPolicyRuleActionsBaseBlob | undefined);
    private _deleteAfterDaysSinceModificationGreaterThan?;
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceModificationGreaterThan(): number;
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceModificationGreaterThan(value: number);
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceModificationGreaterThan(): void;
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceModificationGreaterThanInput(): number | undefined;
    private _tierToArchiveAfterDaysSinceModificationGreaterThan?;
    /**
     * @stability stable
     */
    get tierToArchiveAfterDaysSinceModificationGreaterThan(): number;
    /**
     * @stability stable
     */
    set tierToArchiveAfterDaysSinceModificationGreaterThan(value: number);
    /**
     * @stability stable
     */
    resetTierToArchiveAfterDaysSinceModificationGreaterThan(): void;
    /**
     * @stability stable
     */
    get tierToArchiveAfterDaysSinceModificationGreaterThanInput(): number | undefined;
    private _tierToCoolAfterDaysSinceModificationGreaterThan?;
    /**
     * @stability stable
     */
    get tierToCoolAfterDaysSinceModificationGreaterThan(): number;
    /**
     * @stability stable
     */
    set tierToCoolAfterDaysSinceModificationGreaterThan(value: number);
    /**
     * @stability stable
     */
    resetTierToCoolAfterDaysSinceModificationGreaterThan(): void;
    /**
     * @stability stable
     */
    get tierToCoolAfterDaysSinceModificationGreaterThanInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageManagementPolicyRuleActionsSnapshot {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#change_tier_to_archive_after_days_since_creation StorageManagementPolicy#change_tier_to_archive_after_days_since_creation}.
     *
     * @stability stable
     */
    readonly changeTierToArchiveAfterDaysSinceCreation?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#change_tier_to_cool_after_days_since_creation StorageManagementPolicy#change_tier_to_cool_after_days_since_creation}.
     *
     * @stability stable
     */
    readonly changeTierToCoolAfterDaysSinceCreation?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete_after_days_since_creation_greater_than StorageManagementPolicy#delete_after_days_since_creation_greater_than}.
     *
     * @stability stable
     */
    readonly deleteAfterDaysSinceCreationGreaterThan?: number;
}
export declare function storageManagementPolicyRuleActionsSnapshotToTerraform(struct?: StorageManagementPolicyRuleActionsSnapshotOutputReference | StorageManagementPolicyRuleActionsSnapshot): any;
/**
 * @stability stable
 */
export declare class StorageManagementPolicyRuleActionsSnapshotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageManagementPolicyRuleActionsSnapshot | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageManagementPolicyRuleActionsSnapshot | undefined);
    private _changeTierToArchiveAfterDaysSinceCreation?;
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    set changeTierToArchiveAfterDaysSinceCreation(value: number);
    /**
     * @stability stable
     */
    resetChangeTierToArchiveAfterDaysSinceCreation(): void;
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreationInput(): number | undefined;
    private _changeTierToCoolAfterDaysSinceCreation?;
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    set changeTierToCoolAfterDaysSinceCreation(value: number);
    /**
     * @stability stable
     */
    resetChangeTierToCoolAfterDaysSinceCreation(): void;
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreationInput(): number | undefined;
    private _deleteAfterDaysSinceCreationGreaterThan?;
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationGreaterThan(): number;
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceCreationGreaterThan(value: number);
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceCreationGreaterThan(): void;
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationGreaterThanInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageManagementPolicyRuleActionsVersion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#change_tier_to_archive_after_days_since_creation StorageManagementPolicy#change_tier_to_archive_after_days_since_creation}.
     *
     * @stability stable
     */
    readonly changeTierToArchiveAfterDaysSinceCreation?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#change_tier_to_cool_after_days_since_creation StorageManagementPolicy#change_tier_to_cool_after_days_since_creation}.
     *
     * @stability stable
     */
    readonly changeTierToCoolAfterDaysSinceCreation?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete_after_days_since_creation StorageManagementPolicy#delete_after_days_since_creation}.
     *
     * @stability stable
     */
    readonly deleteAfterDaysSinceCreation?: number;
}
export declare function storageManagementPolicyRuleActionsVersionToTerraform(struct?: StorageManagementPolicyRuleActionsVersionOutputReference | StorageManagementPolicyRuleActionsVersion): any;
/**
 * @stability stable
 */
export declare class StorageManagementPolicyRuleActionsVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageManagementPolicyRuleActionsVersion | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageManagementPolicyRuleActionsVersion | undefined);
    private _changeTierToArchiveAfterDaysSinceCreation?;
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    set changeTierToArchiveAfterDaysSinceCreation(value: number);
    /**
     * @stability stable
     */
    resetChangeTierToArchiveAfterDaysSinceCreation(): void;
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreationInput(): number | undefined;
    private _changeTierToCoolAfterDaysSinceCreation?;
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    set changeTierToCoolAfterDaysSinceCreation(value: number);
    /**
     * @stability stable
     */
    resetChangeTierToCoolAfterDaysSinceCreation(): void;
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreationInput(): number | undefined;
    private _deleteAfterDaysSinceCreation?;
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceCreation(value: number);
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceCreation(): void;
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageManagementPolicyRuleActions {
    /**
     * base_blob block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#base_blob StorageManagementPolicy#base_blob}
     *
     * @stability stable
     */
    readonly baseBlob?: StorageManagementPolicyRuleActionsBaseBlob;
    /**
     * snapshot block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#snapshot StorageManagementPolicy#snapshot}
     *
     * @stability stable
     */
    readonly snapshot?: StorageManagementPolicyRuleActionsSnapshot;
    /**
     * version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#version StorageManagementPolicy#version}
     *
     * @stability stable
     */
    readonly version?: StorageManagementPolicyRuleActionsVersion;
}
export declare function storageManagementPolicyRuleActionsToTerraform(struct?: StorageManagementPolicyRuleActionsOutputReference | StorageManagementPolicyRuleActions): any;
/**
 * @stability stable
 */
export declare class StorageManagementPolicyRuleActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageManagementPolicyRuleActions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageManagementPolicyRuleActions | undefined);
    private _baseBlob;
    /**
     * @stability stable
     */
    get baseBlob(): StorageManagementPolicyRuleActionsBaseBlobOutputReference;
    /**
     * @stability stable
     */
    putBaseBlob(value: StorageManagementPolicyRuleActionsBaseBlob): void;
    /**
     * @stability stable
     */
    resetBaseBlob(): void;
    /**
     * @stability stable
     */
    get baseBlobInput(): StorageManagementPolicyRuleActionsBaseBlob | undefined;
    private _snapshot;
    /**
     * @stability stable
     */
    get snapshot(): StorageManagementPolicyRuleActionsSnapshotOutputReference;
    /**
     * @stability stable
     */
    putSnapshot(value: StorageManagementPolicyRuleActionsSnapshot): void;
    /**
     * @stability stable
     */
    resetSnapshot(): void;
    /**
     * @stability stable
     */
    get snapshotInput(): StorageManagementPolicyRuleActionsSnapshot | undefined;
    private _version;
    /**
     * @stability stable
     */
    get version(): StorageManagementPolicyRuleActionsVersionOutputReference;
    /**
     * @stability stable
     */
    putVersion(value: StorageManagementPolicyRuleActionsVersion): void;
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): StorageManagementPolicyRuleActionsVersion | undefined;
}
/**
 * @stability stable
 */
export interface StorageManagementPolicyRuleFiltersMatchBlobIndexTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#name StorageManagementPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#operation StorageManagementPolicy#operation}.
     *
     * @stability stable
     */
    readonly operation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#value StorageManagementPolicy#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform(struct?: StorageManagementPolicyRuleFiltersMatchBlobIndexTag | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface StorageManagementPolicyRuleFilters {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#blob_types StorageManagementPolicy#blob_types}.
     *
     * @stability stable
     */
    readonly blobTypes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#prefix_match StorageManagementPolicy#prefix_match}.
     *
     * @stability stable
     */
    readonly prefixMatch?: string[];
    /**
     * match_blob_index_tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#match_blob_index_tag StorageManagementPolicy#match_blob_index_tag}
     *
     * @stability stable
     */
    readonly matchBlobIndexTag?: StorageManagementPolicyRuleFiltersMatchBlobIndexTag[] | cdktf.IResolvable;
}
export declare function storageManagementPolicyRuleFiltersToTerraform(struct?: StorageManagementPolicyRuleFiltersOutputReference | StorageManagementPolicyRuleFilters): any;
/**
 * @stability stable
 */
export declare class StorageManagementPolicyRuleFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageManagementPolicyRuleFilters | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageManagementPolicyRuleFilters | undefined);
    private _blobTypes?;
    /**
     * @stability stable
     */
    get blobTypes(): string[];
    /**
     * @stability stable
     */
    set blobTypes(value: string[]);
    /**
     * @stability stable
     */
    resetBlobTypes(): void;
    /**
     * @stability stable
     */
    get blobTypesInput(): string[] | undefined;
    private _prefixMatch?;
    /**
     * @stability stable
     */
    get prefixMatch(): string[];
    /**
     * @stability stable
     */
    set prefixMatch(value: string[]);
    /**
     * @stability stable
     */
    resetPrefixMatch(): void;
    /**
     * @stability stable
     */
    get prefixMatchInput(): string[] | undefined;
    private _matchBlobIndexTag?;
    /**
     * @stability stable
     */
    get matchBlobIndexTag(): StorageManagementPolicyRuleFiltersMatchBlobIndexTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set matchBlobIndexTag(value: StorageManagementPolicyRuleFiltersMatchBlobIndexTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMatchBlobIndexTag(): void;
    /**
     * @stability stable
     */
    get matchBlobIndexTagInput(): cdktf.IResolvable | StorageManagementPolicyRuleFiltersMatchBlobIndexTag[] | undefined;
}
/**
 * @stability stable
 */
export interface StorageManagementPolicyRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#enabled StorageManagementPolicy#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#name StorageManagementPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#actions StorageManagementPolicy#actions}
     *
     * @stability stable
     */
    readonly actions: StorageManagementPolicyRuleActions;
    /**
     * filters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#filters StorageManagementPolicy#filters}
     *
     * @stability stable
     */
    readonly filters?: StorageManagementPolicyRuleFilters;
}
export declare function storageManagementPolicyRuleToTerraform(struct?: StorageManagementPolicyRule | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface StorageManagementPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#create StorageManagementPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete StorageManagementPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#read StorageManagementPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#update StorageManagementPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageManagementPolicyTimeoutsToTerraform(struct?: StorageManagementPolicyTimeoutsOutputReference | StorageManagementPolicyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class StorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageManagementPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageManagementPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy}.
 *
 * @stability stable
 */
export declare class StorageManagementPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageManagementPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _rule?;
    /**
     * @stability stable
     */
    get rule(): StorageManagementPolicyRule[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rule(value: StorageManagementPolicyRule[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRule(): void;
    /**
     * @stability stable
     */
    get ruleInput(): cdktf.IResolvable | StorageManagementPolicyRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageManagementPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageManagementPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageManagementPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
