import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamAnalyticsJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#compatibility_level StreamAnalyticsJob#compatibility_level}.
     *
     * @stability stable
     */
    readonly compatibilityLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#data_locale StreamAnalyticsJob#data_locale}.
     *
     * @stability stable
     */
    readonly dataLocale?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#events_late_arrival_max_delay_in_seconds StreamAnalyticsJob#events_late_arrival_max_delay_in_seconds}.
     *
     * @stability stable
     */
    readonly eventsLateArrivalMaxDelayInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#events_out_of_order_max_delay_in_seconds StreamAnalyticsJob#events_out_of_order_max_delay_in_seconds}.
     *
     * @stability stable
     */
    readonly eventsOutOfOrderMaxDelayInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#events_out_of_order_policy StreamAnalyticsJob#events_out_of_order_policy}.
     *
     * @stability stable
     */
    readonly eventsOutOfOrderPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#location StreamAnalyticsJob#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#name StreamAnalyticsJob#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#output_error_policy StreamAnalyticsJob#output_error_policy}.
     *
     * @stability stable
     */
    readonly outputErrorPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#resource_group_name StreamAnalyticsJob#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#stream_analytics_cluster_id StreamAnalyticsJob#stream_analytics_cluster_id}.
     *
     * @stability stable
     */
    readonly streamAnalyticsClusterId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#streaming_units StreamAnalyticsJob#streaming_units}.
     *
     * @stability stable
     */
    readonly streamingUnits: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#tags StreamAnalyticsJob#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#transformation_query StreamAnalyticsJob#transformation_query}.
     *
     * @stability stable
     */
    readonly transformationQuery: string;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#identity StreamAnalyticsJob#identity}
     *
     * @stability stable
     */
    readonly identity?: StreamAnalyticsJobIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#timeouts StreamAnalyticsJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StreamAnalyticsJobTimeouts;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsJobIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#type StreamAnalyticsJob#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function streamAnalyticsJobIdentityToTerraform(struct?: StreamAnalyticsJobIdentityOutputReference | StreamAnalyticsJobIdentity): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsJobIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsJobIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsJobIdentity | undefined);
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#create StreamAnalyticsJob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#delete StreamAnalyticsJob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#read StreamAnalyticsJob#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job#update StreamAnalyticsJob#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function streamAnalyticsJobTimeoutsToTerraform(struct?: StreamAnalyticsJobTimeoutsOutputReference | StreamAnalyticsJobTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsJobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsJobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job azurerm_stream_analytics_job}.
 *
 * @stability stable
 */
export declare class StreamAnalyticsJob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_job azurerm_stream_analytics_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamAnalyticsJobConfig);
    private _compatibilityLevel?;
    /**
     * @stability stable
     */
    get compatibilityLevel(): string;
    /**
     * @stability stable
     */
    set compatibilityLevel(value: string);
    /**
     * @stability stable
     */
    resetCompatibilityLevel(): void;
    /**
     * @stability stable
     */
    get compatibilityLevelInput(): string | undefined;
    private _dataLocale?;
    /**
     * @stability stable
     */
    get dataLocale(): string;
    /**
     * @stability stable
     */
    set dataLocale(value: string);
    /**
     * @stability stable
     */
    resetDataLocale(): void;
    /**
     * @stability stable
     */
    get dataLocaleInput(): string | undefined;
    private _eventsLateArrivalMaxDelayInSeconds?;
    /**
     * @stability stable
     */
    get eventsLateArrivalMaxDelayInSeconds(): number;
    /**
     * @stability stable
     */
    set eventsLateArrivalMaxDelayInSeconds(value: number);
    /**
     * @stability stable
     */
    resetEventsLateArrivalMaxDelayInSeconds(): void;
    /**
     * @stability stable
     */
    get eventsLateArrivalMaxDelayInSecondsInput(): number | undefined;
    private _eventsOutOfOrderMaxDelayInSeconds?;
    /**
     * @stability stable
     */
    get eventsOutOfOrderMaxDelayInSeconds(): number;
    /**
     * @stability stable
     */
    set eventsOutOfOrderMaxDelayInSeconds(value: number);
    /**
     * @stability stable
     */
    resetEventsOutOfOrderMaxDelayInSeconds(): void;
    /**
     * @stability stable
     */
    get eventsOutOfOrderMaxDelayInSecondsInput(): number | undefined;
    private _eventsOutOfOrderPolicy?;
    /**
     * @stability stable
     */
    get eventsOutOfOrderPolicy(): string;
    /**
     * @stability stable
     */
    set eventsOutOfOrderPolicy(value: string);
    /**
     * @stability stable
     */
    resetEventsOutOfOrderPolicy(): void;
    /**
     * @stability stable
     */
    get eventsOutOfOrderPolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get jobId(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _outputErrorPolicy?;
    /**
     * @stability stable
     */
    get outputErrorPolicy(): string;
    /**
     * @stability stable
     */
    set outputErrorPolicy(value: string);
    /**
     * @stability stable
     */
    resetOutputErrorPolicy(): void;
    /**
     * @stability stable
     */
    get outputErrorPolicyInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _streamAnalyticsClusterId?;
    /**
     * @stability stable
     */
    get streamAnalyticsClusterId(): string;
    /**
     * @stability stable
     */
    set streamAnalyticsClusterId(value: string);
    /**
     * @stability stable
     */
    resetStreamAnalyticsClusterId(): void;
    /**
     * @stability stable
     */
    get streamAnalyticsClusterIdInput(): string | undefined;
    private _streamingUnits?;
    /**
     * @stability stable
     */
    get streamingUnits(): number;
    /**
     * @stability stable
     */
    set streamingUnits(value: number);
    /**
     * @stability stable
     */
    get streamingUnitsInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _transformationQuery?;
    /**
     * @stability stable
     */
    get transformationQuery(): string;
    /**
     * @stability stable
     */
    set transformationQuery(value: string);
    /**
     * @stability stable
     */
    get transformationQueryInput(): string | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): StreamAnalyticsJobIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: StreamAnalyticsJobIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): StreamAnalyticsJobIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StreamAnalyticsJobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StreamAnalyticsJobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StreamAnalyticsJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
