import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SubscriptionCostManagementExportConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#active SubscriptionCostManagementExport#active}.
     *
     * @stability stable
     */
    readonly active?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#name SubscriptionCostManagementExport#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#recurrence_period_end_date SubscriptionCostManagementExport#recurrence_period_end_date}.
     *
     * @stability stable
     */
    readonly recurrencePeriodEndDate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#recurrence_period_start_date SubscriptionCostManagementExport#recurrence_period_start_date}.
     *
     * @stability stable
     */
    readonly recurrencePeriodStartDate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#recurrence_type SubscriptionCostManagementExport#recurrence_type}.
     *
     * @stability stable
     */
    readonly recurrenceType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#subscription_id SubscriptionCostManagementExport#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId: string;
    /**
     * export_data_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#export_data_options SubscriptionCostManagementExport#export_data_options}
     *
     * @stability stable
     */
    readonly exportDataOptions: SubscriptionCostManagementExportExportDataOptions;
    /**
     * export_data_storage_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#export_data_storage_location SubscriptionCostManagementExport#export_data_storage_location}
     *
     * @stability stable
     */
    readonly exportDataStorageLocation: SubscriptionCostManagementExportExportDataStorageLocation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#timeouts SubscriptionCostManagementExport#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SubscriptionCostManagementExportTimeouts;
}
/**
 * @stability stable
 */
export interface SubscriptionCostManagementExportExportDataOptions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#time_frame SubscriptionCostManagementExport#time_frame}.
     *
     * @stability stable
     */
    readonly timeFrame: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#type SubscriptionCostManagementExport#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function subscriptionCostManagementExportExportDataOptionsToTerraform(struct?: SubscriptionCostManagementExportExportDataOptionsOutputReference | SubscriptionCostManagementExportExportDataOptions): any;
/**
 * @stability stable
 */
export declare class SubscriptionCostManagementExportExportDataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SubscriptionCostManagementExportExportDataOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SubscriptionCostManagementExportExportDataOptions | undefined);
    private _timeFrame?;
    /**
     * @stability stable
     */
    get timeFrame(): string;
    /**
     * @stability stable
     */
    set timeFrame(value: string);
    /**
     * @stability stable
     */
    get timeFrameInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SubscriptionCostManagementExportExportDataStorageLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#container_id SubscriptionCostManagementExport#container_id}.
     *
     * @stability stable
     */
    readonly containerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#root_folder_path SubscriptionCostManagementExport#root_folder_path}.
     *
     * @stability stable
     */
    readonly rootFolderPath: string;
}
export declare function subscriptionCostManagementExportExportDataStorageLocationToTerraform(struct?: SubscriptionCostManagementExportExportDataStorageLocationOutputReference | SubscriptionCostManagementExportExportDataStorageLocation): any;
/**
 * @stability stable
 */
export declare class SubscriptionCostManagementExportExportDataStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SubscriptionCostManagementExportExportDataStorageLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SubscriptionCostManagementExportExportDataStorageLocation | undefined);
    private _containerId?;
    /**
     * @stability stable
     */
    get containerId(): string;
    /**
     * @stability stable
     */
    set containerId(value: string);
    /**
     * @stability stable
     */
    get containerIdInput(): string | undefined;
    private _rootFolderPath?;
    /**
     * @stability stable
     */
    get rootFolderPath(): string;
    /**
     * @stability stable
     */
    set rootFolderPath(value: string);
    /**
     * @stability stable
     */
    get rootFolderPathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SubscriptionCostManagementExportTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#create SubscriptionCostManagementExport#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#delete SubscriptionCostManagementExport#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#read SubscriptionCostManagementExport#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#update SubscriptionCostManagementExport#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function subscriptionCostManagementExportTimeoutsToTerraform(struct?: SubscriptionCostManagementExportTimeoutsOutputReference | SubscriptionCostManagementExportTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SubscriptionCostManagementExportTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SubscriptionCostManagementExportTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SubscriptionCostManagementExportTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export azurerm_subscription_cost_management_export}.
 *
 * @stability stable
 */
export declare class SubscriptionCostManagementExport extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export azurerm_subscription_cost_management_export} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SubscriptionCostManagementExportConfig);
    private _active?;
    /**
     * @stability stable
     */
    get active(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set active(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActive(): void;
    /**
     * @stability stable
     */
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _recurrencePeriodEndDate?;
    /**
     * @stability stable
     */
    get recurrencePeriodEndDate(): string;
    /**
     * @stability stable
     */
    set recurrencePeriodEndDate(value: string);
    /**
     * @stability stable
     */
    get recurrencePeriodEndDateInput(): string | undefined;
    private _recurrencePeriodStartDate?;
    /**
     * @stability stable
     */
    get recurrencePeriodStartDate(): string;
    /**
     * @stability stable
     */
    set recurrencePeriodStartDate(value: string);
    /**
     * @stability stable
     */
    get recurrencePeriodStartDateInput(): string | undefined;
    private _recurrenceType?;
    /**
     * @stability stable
     */
    get recurrenceType(): string;
    /**
     * @stability stable
     */
    set recurrenceType(value: string);
    /**
     * @stability stable
     */
    get recurrenceTypeInput(): string | undefined;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    private _exportDataOptions;
    /**
     * @stability stable
     */
    get exportDataOptions(): SubscriptionCostManagementExportExportDataOptionsOutputReference;
    /**
     * @stability stable
     */
    putExportDataOptions(value: SubscriptionCostManagementExportExportDataOptions): void;
    /**
     * @stability stable
     */
    get exportDataOptionsInput(): SubscriptionCostManagementExportExportDataOptions | undefined;
    private _exportDataStorageLocation;
    /**
     * @stability stable
     */
    get exportDataStorageLocation(): SubscriptionCostManagementExportExportDataStorageLocationOutputReference;
    /**
     * @stability stable
     */
    putExportDataStorageLocation(value: SubscriptionCostManagementExportExportDataStorageLocation): void;
    /**
     * @stability stable
     */
    get exportDataStorageLocationInput(): SubscriptionCostManagementExportExportDataStorageLocation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SubscriptionCostManagementExportTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SubscriptionCostManagementExportTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SubscriptionCostManagementExportTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
