import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TrafficManagerEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#endpoint_location TrafficManagerEndpoint#endpoint_location}.
     *
     * @stability stable
     */
    readonly endpointLocation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#endpoint_status TrafficManagerEndpoint#endpoint_status}.
     *
     * @stability stable
     */
    readonly endpointStatus?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#geo_mappings TrafficManagerEndpoint#geo_mappings}.
     *
     * @stability stable
     */
    readonly geoMappings?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#min_child_endpoints TrafficManagerEndpoint#min_child_endpoints}.
     *
     * @stability stable
     */
    readonly minChildEndpoints?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#minimum_required_child_endpoints_ipv4 TrafficManagerEndpoint#minimum_required_child_endpoints_ipv4}.
     *
     * @stability stable
     */
    readonly minimumRequiredChildEndpointsIpv4?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#minimum_required_child_endpoints_ipv6 TrafficManagerEndpoint#minimum_required_child_endpoints_ipv6}.
     *
     * @stability stable
     */
    readonly minimumRequiredChildEndpointsIpv6?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#name TrafficManagerEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#priority TrafficManagerEndpoint#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#profile_name TrafficManagerEndpoint#profile_name}.
     *
     * @stability stable
     */
    readonly profileName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#resource_group_name TrafficManagerEndpoint#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#target TrafficManagerEndpoint#target}.
     *
     * @stability stable
     */
    readonly target?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#target_resource_id TrafficManagerEndpoint#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#type TrafficManagerEndpoint#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#weight TrafficManagerEndpoint#weight}.
     *
     * @stability stable
     */
    readonly weight?: number;
    /**
     * custom_header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#custom_header TrafficManagerEndpoint#custom_header}
     *
     * @stability stable
     */
    readonly customHeader?: TrafficManagerEndpointCustomHeader[] | cdktf.IResolvable;
    /**
     * subnet block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#subnet TrafficManagerEndpoint#subnet}
     *
     * @stability stable
     */
    readonly subnet?: TrafficManagerEndpointSubnet[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#timeouts TrafficManagerEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: TrafficManagerEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface TrafficManagerEndpointCustomHeader {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#name TrafficManagerEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#value TrafficManagerEndpoint#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function trafficManagerEndpointCustomHeaderToTerraform(struct?: TrafficManagerEndpointCustomHeader | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerEndpointSubnet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#first TrafficManagerEndpoint#first}.
     *
     * @stability stable
     */
    readonly first: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#last TrafficManagerEndpoint#last}.
     *
     * @stability stable
     */
    readonly last?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#scope TrafficManagerEndpoint#scope}.
     *
     * @stability stable
     */
    readonly scope?: number;
}
export declare function trafficManagerEndpointSubnetToTerraform(struct?: TrafficManagerEndpointSubnet | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#create TrafficManagerEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#delete TrafficManagerEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#read TrafficManagerEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint#update TrafficManagerEndpoint#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function trafficManagerEndpointTimeoutsToTerraform(struct?: TrafficManagerEndpointTimeoutsOutputReference | TrafficManagerEndpointTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class TrafficManagerEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TrafficManagerEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TrafficManagerEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint azurerm_traffic_manager_endpoint}.
 *
 * @stability stable
 */
export declare class TrafficManagerEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_endpoint azurerm_traffic_manager_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TrafficManagerEndpointConfig);
    private _endpointLocation?;
    /**
     * @stability stable
     */
    get endpointLocation(): string;
    /**
     * @stability stable
     */
    set endpointLocation(value: string);
    /**
     * @stability stable
     */
    resetEndpointLocation(): void;
    /**
     * @stability stable
     */
    get endpointLocationInput(): string | undefined;
    /**
     * @stability stable
     */
    get endpointMonitorStatus(): string;
    private _endpointStatus?;
    /**
     * @stability stable
     */
    get endpointStatus(): string;
    /**
     * @stability stable
     */
    set endpointStatus(value: string);
    /**
     * @stability stable
     */
    resetEndpointStatus(): void;
    /**
     * @stability stable
     */
    get endpointStatusInput(): string | undefined;
    private _geoMappings?;
    /**
     * @stability stable
     */
    get geoMappings(): string[];
    /**
     * @stability stable
     */
    set geoMappings(value: string[]);
    /**
     * @stability stable
     */
    resetGeoMappings(): void;
    /**
     * @stability stable
     */
    get geoMappingsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _minChildEndpoints?;
    /**
     * @stability stable
     */
    get minChildEndpoints(): number;
    /**
     * @stability stable
     */
    set minChildEndpoints(value: number);
    /**
     * @stability stable
     */
    resetMinChildEndpoints(): void;
    /**
     * @stability stable
     */
    get minChildEndpointsInput(): number | undefined;
    private _minimumRequiredChildEndpointsIpv4?;
    /**
     * @stability stable
     */
    get minimumRequiredChildEndpointsIpv4(): number;
    /**
     * @stability stable
     */
    set minimumRequiredChildEndpointsIpv4(value: number);
    /**
     * @stability stable
     */
    resetMinimumRequiredChildEndpointsIpv4(): void;
    /**
     * @stability stable
     */
    get minimumRequiredChildEndpointsIpv4Input(): number | undefined;
    private _minimumRequiredChildEndpointsIpv6?;
    /**
     * @stability stable
     */
    get minimumRequiredChildEndpointsIpv6(): number;
    /**
     * @stability stable
     */
    set minimumRequiredChildEndpointsIpv6(value: number);
    /**
     * @stability stable
     */
    resetMinimumRequiredChildEndpointsIpv6(): void;
    /**
     * @stability stable
     */
    get minimumRequiredChildEndpointsIpv6Input(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _profileName?;
    /**
     * @stability stable
     */
    get profileName(): string;
    /**
     * @stability stable
     */
    set profileName(value: string);
    /**
     * @stability stable
     */
    get profileNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    resetTarget(): void;
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    resetTargetResourceId(): void;
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _weight?;
    /**
     * @stability stable
     */
    get weight(): number;
    /**
     * @stability stable
     */
    set weight(value: number);
    /**
     * @stability stable
     */
    resetWeight(): void;
    /**
     * @stability stable
     */
    get weightInput(): number | undefined;
    private _customHeader?;
    /**
     * @stability stable
     */
    get customHeader(): TrafficManagerEndpointCustomHeader[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customHeader(value: TrafficManagerEndpointCustomHeader[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomHeader(): void;
    /**
     * @stability stable
     */
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerEndpointCustomHeader[] | undefined;
    private _subnet?;
    /**
     * @stability stable
     */
    get subnet(): TrafficManagerEndpointSubnet[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set subnet(value: TrafficManagerEndpointSubnet[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSubnet(): void;
    /**
     * @stability stable
     */
    get subnetInput(): cdktf.IResolvable | TrafficManagerEndpointSubnet[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): TrafficManagerEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: TrafficManagerEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): TrafficManagerEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
