import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualMachineDataDiskAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#caching VirtualMachineDataDiskAttachment#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#create_option VirtualMachineDataDiskAttachment#create_option}.
     *
     * @stability stable
     */
    readonly createOption?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#lun VirtualMachineDataDiskAttachment#lun}.
     *
     * @stability stable
     */
    readonly lun: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#managed_disk_id VirtualMachineDataDiskAttachment#managed_disk_id}.
     *
     * @stability stable
     */
    readonly managedDiskId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#virtual_machine_id VirtualMachineDataDiskAttachment#virtual_machine_id}.
     *
     * @stability stable
     */
    readonly virtualMachineId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#write_accelerator_enabled VirtualMachineDataDiskAttachment#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#timeouts VirtualMachineDataDiskAttachment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualMachineDataDiskAttachmentTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualMachineDataDiskAttachmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#create VirtualMachineDataDiskAttachment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#delete VirtualMachineDataDiskAttachment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#read VirtualMachineDataDiskAttachment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment#update VirtualMachineDataDiskAttachment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualMachineDataDiskAttachmentTimeoutsToTerraform(struct?: VirtualMachineDataDiskAttachmentTimeoutsOutputReference | VirtualMachineDataDiskAttachmentTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualMachineDataDiskAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineDataDiskAttachmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineDataDiskAttachmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment azurerm_virtual_machine_data_disk_attachment}.
 *
 * @stability stable
 */
export declare class VirtualMachineDataDiskAttachment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_data_disk_attachment azurerm_virtual_machine_data_disk_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualMachineDataDiskAttachmentConfig);
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _createOption?;
    /**
     * @stability stable
     */
    get createOption(): string;
    /**
     * @stability stable
     */
    set createOption(value: string);
    /**
     * @stability stable
     */
    resetCreateOption(): void;
    /**
     * @stability stable
     */
    get createOptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _lun?;
    /**
     * @stability stable
     */
    get lun(): number;
    /**
     * @stability stable
     */
    set lun(value: number);
    /**
     * @stability stable
     */
    get lunInput(): number | undefined;
    private _managedDiskId?;
    /**
     * @stability stable
     */
    get managedDiskId(): string;
    /**
     * @stability stable
     */
    set managedDiskId(value: string);
    /**
     * @stability stable
     */
    get managedDiskIdInput(): string | undefined;
    private _virtualMachineId?;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    /**
     * @stability stable
     */
    set virtualMachineId(value: string);
    /**
     * @stability stable
     */
    get virtualMachineIdInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWriteAcceleratorEnabled(): void;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualMachineDataDiskAttachmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualMachineDataDiskAttachmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualMachineDataDiskAttachmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
