import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetExtensionAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#auto_upgrade_minor_version VirtualMachineScaleSetExtensionA#auto_upgrade_minor_version}.
     *
     * @stability stable
     */
    readonly autoUpgradeMinorVersion?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#automatic_upgrade_enabled VirtualMachineScaleSetExtensionA#automatic_upgrade_enabled}.
     *
     * @stability stable
     */
    readonly automaticUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#force_update_tag VirtualMachineScaleSetExtensionA#force_update_tag}.
     *
     * @stability stable
     */
    readonly forceUpdateTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#name VirtualMachineScaleSetExtensionA#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#protected_settings VirtualMachineScaleSetExtensionA#protected_settings}.
     *
     * @stability stable
     */
    readonly protectedSettings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#provision_after_extensions VirtualMachineScaleSetExtensionA#provision_after_extensions}.
     *
     * @stability stable
     */
    readonly provisionAfterExtensions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#publisher VirtualMachineScaleSetExtensionA#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#settings VirtualMachineScaleSetExtensionA#settings}.
     *
     * @stability stable
     */
    readonly settings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#type VirtualMachineScaleSetExtensionA#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#type_handler_version VirtualMachineScaleSetExtensionA#type_handler_version}.
     *
     * @stability stable
     */
    readonly typeHandlerVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#virtual_machine_scale_set_id VirtualMachineScaleSetExtensionA#virtual_machine_scale_set_id}.
     *
     * @stability stable
     */
    readonly virtualMachineScaleSetId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#timeouts VirtualMachineScaleSetExtensionA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualMachineScaleSetExtensionTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetExtensionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#create VirtualMachineScaleSetExtensionA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#delete VirtualMachineScaleSetExtensionA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#read VirtualMachineScaleSetExtensionA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension#update VirtualMachineScaleSetExtensionA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualMachineScaleSetExtensionTimeoutsToTerraform(struct?: VirtualMachineScaleSetExtensionTimeoutsOutputReference | VirtualMachineScaleSetExtensionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetExtensionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetExtensionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetExtensionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension azurerm_virtual_machine_scale_set_extension}.
 *
 * @stability stable
 */
export declare class VirtualMachineScaleSetExtensionA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set_extension azurerm_virtual_machine_scale_set_extension} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualMachineScaleSetExtensionAConfig);
    private _autoUpgradeMinorVersion?;
    /**
     * @stability stable
     */
    get autoUpgradeMinorVersion(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoUpgradeMinorVersion(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoUpgradeMinorVersion(): void;
    /**
     * @stability stable
     */
    get autoUpgradeMinorVersionInput(): boolean | cdktf.IResolvable | undefined;
    private _automaticUpgradeEnabled?;
    /**
     * @stability stable
     */
    get automaticUpgradeEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set automaticUpgradeEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutomaticUpgradeEnabled(): void;
    /**
     * @stability stable
     */
    get automaticUpgradeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _forceUpdateTag?;
    /**
     * @stability stable
     */
    get forceUpdateTag(): string;
    /**
     * @stability stable
     */
    set forceUpdateTag(value: string);
    /**
     * @stability stable
     */
    resetForceUpdateTag(): void;
    /**
     * @stability stable
     */
    get forceUpdateTagInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protectedSettings?;
    /**
     * @stability stable
     */
    get protectedSettings(): string;
    /**
     * @stability stable
     */
    set protectedSettings(value: string);
    /**
     * @stability stable
     */
    resetProtectedSettings(): void;
    /**
     * @stability stable
     */
    get protectedSettingsInput(): string | undefined;
    private _provisionAfterExtensions?;
    /**
     * @stability stable
     */
    get provisionAfterExtensions(): string[];
    /**
     * @stability stable
     */
    set provisionAfterExtensions(value: string[]);
    /**
     * @stability stable
     */
    resetProvisionAfterExtensions(): void;
    /**
     * @stability stable
     */
    get provisionAfterExtensionsInput(): string[] | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _settings?;
    /**
     * @stability stable
     */
    get settings(): string;
    /**
     * @stability stable
     */
    set settings(value: string);
    /**
     * @stability stable
     */
    resetSettings(): void;
    /**
     * @stability stable
     */
    get settingsInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _typeHandlerVersion?;
    /**
     * @stability stable
     */
    get typeHandlerVersion(): string;
    /**
     * @stability stable
     */
    set typeHandlerVersion(value: string);
    /**
     * @stability stable
     */
    get typeHandlerVersionInput(): string | undefined;
    private _virtualMachineScaleSetId?;
    /**
     * @stability stable
     */
    get virtualMachineScaleSetId(): string;
    /**
     * @stability stable
     */
    set virtualMachineScaleSetId(value: string);
    /**
     * @stability stable
     */
    get virtualMachineScaleSetIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualMachineScaleSetExtensionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualMachineScaleSetExtensionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualMachineScaleSetExtensionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
