import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#automatic_os_upgrade VirtualMachineScaleSet#automatic_os_upgrade}.
     *
     * @stability stable
     */
    readonly automaticOsUpgrade?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#eviction_policy VirtualMachineScaleSet#eviction_policy}.
     *
     * @stability stable
     */
    readonly evictionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#health_probe_id VirtualMachineScaleSet#health_probe_id}.
     *
     * @stability stable
     */
    readonly healthProbeId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#license_type VirtualMachineScaleSet#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#location VirtualMachineScaleSet#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#overprovision VirtualMachineScaleSet#overprovision}.
     *
     * @stability stable
     */
    readonly overprovision?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#priority VirtualMachineScaleSet#priority}.
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#proximity_placement_group_id VirtualMachineScaleSet#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#resource_group_name VirtualMachineScaleSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#single_placement_group VirtualMachineScaleSet#single_placement_group}.
     *
     * @stability stable
     */
    readonly singlePlacementGroup?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#tags VirtualMachineScaleSet#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#upgrade_policy_mode VirtualMachineScaleSet#upgrade_policy_mode}.
     *
     * @stability stable
     */
    readonly upgradePolicyMode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#zones VirtualMachineScaleSet#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * boot_diagnostics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#boot_diagnostics VirtualMachineScaleSet#boot_diagnostics}
     *
     * @stability stable
     */
    readonly bootDiagnostics?: VirtualMachineScaleSetBootDiagnostics;
    /**
     * extension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#extension VirtualMachineScaleSet#extension}
     *
     * @stability stable
     */
    readonly extension?: VirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#identity VirtualMachineScaleSet#identity}
     *
     * @stability stable
     */
    readonly identity?: VirtualMachineScaleSetIdentity;
    /**
     * network_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#network_profile VirtualMachineScaleSet#network_profile}
     *
     * @stability stable
     */
    readonly networkProfile: VirtualMachineScaleSetNetworkProfile[] | cdktf.IResolvable;
    /**
     * os_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_profile VirtualMachineScaleSet#os_profile}
     *
     * @stability stable
     */
    readonly osProfile: VirtualMachineScaleSetOsProfile;
    /**
     * os_profile_linux_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_profile_linux_config VirtualMachineScaleSet#os_profile_linux_config}
     *
     * @stability stable
     */
    readonly osProfileLinuxConfig?: VirtualMachineScaleSetOsProfileLinuxConfig;
    /**
     * os_profile_secrets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_profile_secrets VirtualMachineScaleSet#os_profile_secrets}
     *
     * @stability stable
     */
    readonly osProfileSecrets?: VirtualMachineScaleSetOsProfileSecrets[] | cdktf.IResolvable;
    /**
     * os_profile_windows_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_profile_windows_config VirtualMachineScaleSet#os_profile_windows_config}
     *
     * @stability stable
     */
    readonly osProfileWindowsConfig?: VirtualMachineScaleSetOsProfileWindowsConfig;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#plan VirtualMachineScaleSet#plan}
     *
     * @stability stable
     */
    readonly plan?: VirtualMachineScaleSetPlan;
    /**
     * rolling_upgrade_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#rolling_upgrade_policy VirtualMachineScaleSet#rolling_upgrade_policy}
     *
     * @stability stable
     */
    readonly rollingUpgradePolicy?: VirtualMachineScaleSetRollingUpgradePolicy;
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#sku VirtualMachineScaleSet#sku}
     *
     * @stability stable
     */
    readonly sku: VirtualMachineScaleSetSku;
    /**
     * storage_profile_data_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#storage_profile_data_disk VirtualMachineScaleSet#storage_profile_data_disk}
     *
     * @stability stable
     */
    readonly storageProfileDataDisk?: VirtualMachineScaleSetStorageProfileDataDisk[] | cdktf.IResolvable;
    /**
     * storage_profile_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#storage_profile_image_reference VirtualMachineScaleSet#storage_profile_image_reference}
     *
     * @stability stable
     */
    readonly storageProfileImageReference?: VirtualMachineScaleSetStorageProfileImageReference;
    /**
     * storage_profile_os_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#storage_profile_os_disk VirtualMachineScaleSet#storage_profile_os_disk}
     *
     * @stability stable
     */
    readonly storageProfileOsDisk: VirtualMachineScaleSetStorageProfileOsDisk;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#timeouts VirtualMachineScaleSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualMachineScaleSetTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetBootDiagnostics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#enabled VirtualMachineScaleSet#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#storage_uri VirtualMachineScaleSet#storage_uri}.
     *
     * @stability stable
     */
    readonly storageUri: string;
}
export declare function virtualMachineScaleSetBootDiagnosticsToTerraform(struct?: VirtualMachineScaleSetBootDiagnosticsOutputReference | VirtualMachineScaleSetBootDiagnostics): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetBootDiagnostics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetBootDiagnostics | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUri?;
    /**
     * @stability stable
     */
    get storageUri(): string;
    /**
     * @stability stable
     */
    set storageUri(value: string);
    /**
     * @stability stable
     */
    get storageUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetExtension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#auto_upgrade_minor_version VirtualMachineScaleSet#auto_upgrade_minor_version}.
     *
     * @stability stable
     */
    readonly autoUpgradeMinorVersion?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#protected_settings VirtualMachineScaleSet#protected_settings}.
     *
     * @stability stable
     */
    readonly protectedSettings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#provision_after_extensions VirtualMachineScaleSet#provision_after_extensions}.
     *
     * @stability stable
     */
    readonly provisionAfterExtensions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#publisher VirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#settings VirtualMachineScaleSet#settings}.
     *
     * @stability stable
     */
    readonly settings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#type VirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#type_handler_version VirtualMachineScaleSet#type_handler_version}.
     *
     * @stability stable
     */
    readonly typeHandlerVersion: string;
}
export declare function virtualMachineScaleSetExtensionToTerraform(struct?: VirtualMachineScaleSetExtension | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#identity_ids VirtualMachineScaleSet#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#type VirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function virtualMachineScaleSetIdentityToTerraform(struct?: VirtualMachineScaleSetIdentityOutputReference | VirtualMachineScaleSetIdentity): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get principalId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetNetworkProfileDnsSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#dns_servers VirtualMachineScaleSet#dns_servers}.
     *
     * @stability stable
     */
    readonly dnsServers: string[];
}
export declare function virtualMachineScaleSetNetworkProfileDnsSettingsToTerraform(struct?: VirtualMachineScaleSetNetworkProfileDnsSettingsOutputReference | VirtualMachineScaleSetNetworkProfileDnsSettings): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetNetworkProfileDnsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetNetworkProfileDnsSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetNetworkProfileDnsSettings | undefined);
    private _dnsServers?;
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    set dnsServers(value: string[]);
    /**
     * @stability stable
     */
    get dnsServersInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#domain_name_label VirtualMachineScaleSet#domain_name_label}.
     *
     * @stability stable
     */
    readonly domainNameLabel: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#idle_timeout VirtualMachineScaleSet#idle_timeout}.
     *
     * @stability stable
     */
    readonly idleTimeout: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function virtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfigurationToTerraform(struct?: VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfigurationOutputReference | VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration | undefined);
    private _domainNameLabel?;
    /**
     * @stability stable
     */
    get domainNameLabel(): string;
    /**
     * @stability stable
     */
    set domainNameLabel(value: string);
    /**
     * @stability stable
     */
    get domainNameLabelInput(): string | undefined;
    private _idleTimeout?;
    /**
     * @stability stable
     */
    get idleTimeout(): number;
    /**
     * @stability stable
     */
    set idleTimeout(value: number);
    /**
     * @stability stable
     */
    get idleTimeoutInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetNetworkProfileIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#application_gateway_backend_address_pool_ids VirtualMachineScaleSet#application_gateway_backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly applicationGatewayBackendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#application_security_group_ids VirtualMachineScaleSet#application_security_group_ids}.
     *
     * @stability stable
     */
    readonly applicationSecurityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#load_balancer_backend_address_pool_ids VirtualMachineScaleSet#load_balancer_backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly loadBalancerBackendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#load_balancer_inbound_nat_rules_ids VirtualMachineScaleSet#load_balancer_inbound_nat_rules_ids}.
     *
     * @stability stable
     */
    readonly loadBalancerInboundNatRulesIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#primary VirtualMachineScaleSet#primary}.
     *
     * @stability stable
     */
    readonly primary: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#subnet_id VirtualMachineScaleSet#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * public_ip_address_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#public_ip_address_configuration VirtualMachineScaleSet#public_ip_address_configuration}
     *
     * @stability stable
     */
    readonly publicIpAddressConfiguration?: VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration;
}
export declare function virtualMachineScaleSetNetworkProfileIpConfigurationToTerraform(struct?: VirtualMachineScaleSetNetworkProfileIpConfiguration | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetNetworkProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#accelerated_networking VirtualMachineScaleSet#accelerated_networking}.
     *
     * @stability stable
     */
    readonly acceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#ip_forwarding VirtualMachineScaleSet#ip_forwarding}.
     *
     * @stability stable
     */
    readonly ipForwarding?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#network_security_group_id VirtualMachineScaleSet#network_security_group_id}.
     *
     * @stability stable
     */
    readonly networkSecurityGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#primary VirtualMachineScaleSet#primary}.
     *
     * @stability stable
     */
    readonly primary: boolean | cdktf.IResolvable;
    /**
     * dns_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#dns_settings VirtualMachineScaleSet#dns_settings}
     *
     * @stability stable
     */
    readonly dnsSettings?: VirtualMachineScaleSetNetworkProfileDnsSettings;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#ip_configuration VirtualMachineScaleSet#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration: VirtualMachineScaleSetNetworkProfileIpConfiguration[] | cdktf.IResolvable;
}
export declare function virtualMachineScaleSetNetworkProfileToTerraform(struct?: VirtualMachineScaleSetNetworkProfile | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetOsProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#admin_password VirtualMachineScaleSet#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#admin_username VirtualMachineScaleSet#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#computer_name_prefix VirtualMachineScaleSet#computer_name_prefix}.
     *
     * @stability stable
     */
    readonly computerNamePrefix: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#custom_data VirtualMachineScaleSet#custom_data}.
     *
     * @stability stable
     */
    readonly customData?: string;
}
export declare function virtualMachineScaleSetOsProfileToTerraform(struct?: VirtualMachineScaleSetOsProfileOutputReference | VirtualMachineScaleSetOsProfile): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetOsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetOsProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetOsProfile | undefined);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    resetAdminPassword(): void;
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    /**
     * @stability stable
     */
    get computerNamePrefix(): string;
    /**
     * @stability stable
     */
    set computerNamePrefix(value: string);
    /**
     * @stability stable
     */
    get computerNamePrefixInput(): string | undefined;
    private _customData?;
    /**
     * @stability stable
     */
    get customData(): string;
    /**
     * @stability stable
     */
    set customData(value: string);
    /**
     * @stability stable
     */
    resetCustomData(): void;
    /**
     * @stability stable
     */
    get customDataInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetOsProfileLinuxConfigSshKeys {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#key_data VirtualMachineScaleSet#key_data}.
     *
     * @stability stable
     */
    readonly keyData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#path VirtualMachineScaleSet#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function virtualMachineScaleSetOsProfileLinuxConfigSshKeysToTerraform(struct?: VirtualMachineScaleSetOsProfileLinuxConfigSshKeys | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetOsProfileLinuxConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#disable_password_authentication VirtualMachineScaleSet#disable_password_authentication}.
     *
     * @stability stable
     */
    readonly disablePasswordAuthentication?: boolean | cdktf.IResolvable;
    /**
     * ssh_keys block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#ssh_keys VirtualMachineScaleSet#ssh_keys}
     *
     * @stability stable
     */
    readonly sshKeys?: VirtualMachineScaleSetOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable;
}
export declare function virtualMachineScaleSetOsProfileLinuxConfigToTerraform(struct?: VirtualMachineScaleSetOsProfileLinuxConfigOutputReference | VirtualMachineScaleSetOsProfileLinuxConfig | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetOsProfileLinuxConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetOsProfileLinuxConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetOsProfileLinuxConfig | undefined);
    private _disablePasswordAuthentication?;
    /**
     * @stability stable
     */
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisablePasswordAuthentication(): void;
    /**
     * @stability stable
     */
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): VirtualMachineScaleSetOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sshKeys(value: VirtualMachineScaleSetOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): cdktf.IResolvable | VirtualMachineScaleSetOsProfileLinuxConfigSshKeys[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetOsProfileSecretsVaultCertificates {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#certificate_store VirtualMachineScaleSet#certificate_store}.
     *
     * @stability stable
     */
    readonly certificateStore?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#certificate_url VirtualMachineScaleSet#certificate_url}.
     *
     * @stability stable
     */
    readonly certificateUrl: string;
}
export declare function virtualMachineScaleSetOsProfileSecretsVaultCertificatesToTerraform(struct?: VirtualMachineScaleSetOsProfileSecretsVaultCertificates | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetOsProfileSecrets {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#source_vault_id VirtualMachineScaleSet#source_vault_id}.
     *
     * @stability stable
     */
    readonly sourceVaultId: string;
    /**
     * vault_certificates block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#vault_certificates VirtualMachineScaleSet#vault_certificates}
     *
     * @stability stable
     */
    readonly vaultCertificates?: VirtualMachineScaleSetOsProfileSecretsVaultCertificates[] | cdktf.IResolvable;
}
export declare function virtualMachineScaleSetOsProfileSecretsToTerraform(struct?: VirtualMachineScaleSetOsProfileSecrets | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#component VirtualMachineScaleSet#component}.
     *
     * @stability stable
     */
    readonly component: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#content VirtualMachineScaleSet#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#pass VirtualMachineScaleSet#pass}.
     *
     * @stability stable
     */
    readonly pass: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#setting_name VirtualMachineScaleSet#setting_name}.
     *
     * @stability stable
     */
    readonly settingName: string;
}
export declare function virtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfigToTerraform(struct?: VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetOsProfileWindowsConfigWinrm {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#certificate_url VirtualMachineScaleSet#certificate_url}.
     *
     * @stability stable
     */
    readonly certificateUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#protocol VirtualMachineScaleSet#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function virtualMachineScaleSetOsProfileWindowsConfigWinrmToTerraform(struct?: VirtualMachineScaleSetOsProfileWindowsConfigWinrm | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetOsProfileWindowsConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#enable_automatic_upgrades VirtualMachineScaleSet#enable_automatic_upgrades}.
     *
     * @stability stable
     */
    readonly enableAutomaticUpgrades?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#provision_vm_agent VirtualMachineScaleSet#provision_vm_agent}.
     *
     * @stability stable
     */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
     * additional_unattend_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#additional_unattend_config VirtualMachineScaleSet#additional_unattend_config}
     *
     * @stability stable
     */
    readonly additionalUnattendConfig?: VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable;
    /**
     * winrm block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#winrm VirtualMachineScaleSet#winrm}
     *
     * @stability stable
     */
    readonly winrm?: VirtualMachineScaleSetOsProfileWindowsConfigWinrm[] | cdktf.IResolvable;
}
export declare function virtualMachineScaleSetOsProfileWindowsConfigToTerraform(struct?: VirtualMachineScaleSetOsProfileWindowsConfigOutputReference | VirtualMachineScaleSetOsProfileWindowsConfig | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetOsProfileWindowsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetOsProfileWindowsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetOsProfileWindowsConfig | undefined);
    private _enableAutomaticUpgrades?;
    /**
     * @stability stable
     */
    get enableAutomaticUpgrades(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutomaticUpgrades(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutomaticUpgrades(): void;
    /**
     * @stability stable
     */
    get enableAutomaticUpgradesInput(): boolean | cdktf.IResolvable | undefined;
    private _provisionVmAgent?;
    /**
     * @stability stable
     */
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProvisionVmAgent(): void;
    /**
     * @stability stable
     */
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalUnattendConfig?;
    /**
     * @stability stable
     */
    get additionalUnattendConfig(): VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalUnattendConfig(value: VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalUnattendConfig(): void;
    /**
     * @stability stable
     */
    get additionalUnattendConfigInput(): cdktf.IResolvable | VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig[] | undefined;
    private _winrm?;
    /**
     * @stability stable
     */
    get winrm(): VirtualMachineScaleSetOsProfileWindowsConfigWinrm[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set winrm(value: VirtualMachineScaleSetOsProfileWindowsConfigWinrm[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWinrm(): void;
    /**
     * @stability stable
     */
    get winrmInput(): cdktf.IResolvable | VirtualMachineScaleSetOsProfileWindowsConfigWinrm[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetPlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#product VirtualMachineScaleSet#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#publisher VirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
}
export declare function virtualMachineScaleSetPlanToTerraform(struct?: VirtualMachineScaleSetPlanOutputReference | VirtualMachineScaleSetPlan | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetPlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetPlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetRollingUpgradePolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#max_batch_instance_percent VirtualMachineScaleSet#max_batch_instance_percent}.
     *
     * @stability stable
     */
    readonly maxBatchInstancePercent?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#max_unhealthy_instance_percent VirtualMachineScaleSet#max_unhealthy_instance_percent}.
     *
     * @stability stable
     */
    readonly maxUnhealthyInstancePercent?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#max_unhealthy_upgraded_instance_percent VirtualMachineScaleSet#max_unhealthy_upgraded_instance_percent}.
     *
     * @stability stable
     */
    readonly maxUnhealthyUpgradedInstancePercent?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#pause_time_between_batches VirtualMachineScaleSet#pause_time_between_batches}.
     *
     * @stability stable
     */
    readonly pauseTimeBetweenBatches?: string;
}
export declare function virtualMachineScaleSetRollingUpgradePolicyToTerraform(struct?: VirtualMachineScaleSetRollingUpgradePolicyOutputReference | VirtualMachineScaleSetRollingUpgradePolicy): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetRollingUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetRollingUpgradePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetRollingUpgradePolicy | undefined);
    private _maxBatchInstancePercent?;
    /**
     * @stability stable
     */
    get maxBatchInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxBatchInstancePercent(value: number);
    /**
     * @stability stable
     */
    resetMaxBatchInstancePercent(): void;
    /**
     * @stability stable
     */
    get maxBatchInstancePercentInput(): number | undefined;
    private _maxUnhealthyInstancePercent?;
    /**
     * @stability stable
     */
    get maxUnhealthyInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxUnhealthyInstancePercent(value: number);
    /**
     * @stability stable
     */
    resetMaxUnhealthyInstancePercent(): void;
    /**
     * @stability stable
     */
    get maxUnhealthyInstancePercentInput(): number | undefined;
    private _maxUnhealthyUpgradedInstancePercent?;
    /**
     * @stability stable
     */
    get maxUnhealthyUpgradedInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxUnhealthyUpgradedInstancePercent(value: number);
    /**
     * @stability stable
     */
    resetMaxUnhealthyUpgradedInstancePercent(): void;
    /**
     * @stability stable
     */
    get maxUnhealthyUpgradedInstancePercentInput(): number | undefined;
    private _pauseTimeBetweenBatches?;
    /**
     * @stability stable
     */
    get pauseTimeBetweenBatches(): string;
    /**
     * @stability stable
     */
    set pauseTimeBetweenBatches(value: string);
    /**
     * @stability stable
     */
    resetPauseTimeBetweenBatches(): void;
    /**
     * @stability stable
     */
    get pauseTimeBetweenBatchesInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetSku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#capacity VirtualMachineScaleSet#capacity}.
     *
     * @stability stable
     */
    readonly capacity: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#tier VirtualMachineScaleSet#tier}.
     *
     * @stability stable
     */
    readonly tier?: string;
}
export declare function virtualMachineScaleSetSkuToTerraform(struct?: VirtualMachineScaleSetSkuOutputReference | VirtualMachineScaleSetSku): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetSku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetSku | undefined);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    resetTier(): void;
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetStorageProfileDataDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#caching VirtualMachineScaleSet#caching}.
     *
     * @stability stable
     */
    readonly caching?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#create_option VirtualMachineScaleSet#create_option}.
     *
     * @stability stable
     */
    readonly createOption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#disk_size_gb VirtualMachineScaleSet#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#lun VirtualMachineScaleSet#lun}.
     *
     * @stability stable
     */
    readonly lun: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#managed_disk_type VirtualMachineScaleSet#managed_disk_type}.
     *
     * @stability stable
     */
    readonly managedDiskType?: string;
}
export declare function virtualMachineScaleSetStorageProfileDataDiskToTerraform(struct?: VirtualMachineScaleSetStorageProfileDataDisk | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetStorageProfileImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#id VirtualMachineScaleSet#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#offer VirtualMachineScaleSet#offer}.
     *
     * @stability stable
     */
    readonly offer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#publisher VirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#sku VirtualMachineScaleSet#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#version VirtualMachineScaleSet#version}.
     *
     * @stability stable
     */
    readonly version?: string;
}
export declare function virtualMachineScaleSetStorageProfileImageReferenceToTerraform(struct?: VirtualMachineScaleSetStorageProfileImageReferenceOutputReference | VirtualMachineScaleSetStorageProfileImageReference | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetStorageProfileImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetStorageProfileImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetStorageProfileImageReference | undefined);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    resetOffer(): void;
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    resetPublisher(): void;
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetStorageProfileOsDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#caching VirtualMachineScaleSet#caching}.
     *
     * @stability stable
     */
    readonly caching?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#create_option VirtualMachineScaleSet#create_option}.
     *
     * @stability stable
     */
    readonly createOption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#image VirtualMachineScaleSet#image}.
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#managed_disk_type VirtualMachineScaleSet#managed_disk_type}.
     *
     * @stability stable
     */
    readonly managedDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_type VirtualMachineScaleSet#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#vhd_containers VirtualMachineScaleSet#vhd_containers}.
     *
     * @stability stable
     */
    readonly vhdContainers?: string[];
}
export declare function virtualMachineScaleSetStorageProfileOsDiskToTerraform(struct?: VirtualMachineScaleSetStorageProfileOsDiskOutputReference | VirtualMachineScaleSetStorageProfileOsDisk | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetStorageProfileOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetStorageProfileOsDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetStorageProfileOsDisk | undefined);
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    resetCaching(): void;
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _createOption?;
    /**
     * @stability stable
     */
    get createOption(): string;
    /**
     * @stability stable
     */
    set createOption(value: string);
    /**
     * @stability stable
     */
    get createOptionInput(): string | undefined;
    private _image?;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    resetImage(): void;
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
    private _managedDiskType?;
    /**
     * @stability stable
     */
    get managedDiskType(): string;
    /**
     * @stability stable
     */
    set managedDiskType(value: string);
    /**
     * @stability stable
     */
    resetManagedDiskType(): void;
    /**
     * @stability stable
     */
    get managedDiskTypeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    resetOsType(): void;
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    private _vhdContainers?;
    /**
     * @stability stable
     */
    get vhdContainers(): string[];
    /**
     * @stability stable
     */
    set vhdContainers(value: string[]);
    /**
     * @stability stable
     */
    resetVhdContainers(): void;
    /**
     * @stability stable
     */
    get vhdContainersInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineScaleSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#create VirtualMachineScaleSet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#delete VirtualMachineScaleSet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#read VirtualMachineScaleSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#update VirtualMachineScaleSet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualMachineScaleSetTimeoutsToTerraform(struct?: VirtualMachineScaleSetTimeoutsOutputReference | VirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineScaleSetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set azurerm_virtual_machine_scale_set}.
 *
 * @stability stable
 */
export declare class VirtualMachineScaleSet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set azurerm_virtual_machine_scale_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualMachineScaleSetConfig);
    private _automaticOsUpgrade?;
    /**
     * @stability stable
     */
    get automaticOsUpgrade(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set automaticOsUpgrade(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutomaticOsUpgrade(): void;
    /**
     * @stability stable
     */
    get automaticOsUpgradeInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    set evictionPolicy(value: string);
    /**
     * @stability stable
     */
    resetEvictionPolicy(): void;
    /**
     * @stability stable
     */
    get evictionPolicyInput(): string | undefined;
    private _healthProbeId?;
    /**
     * @stability stable
     */
    get healthProbeId(): string;
    /**
     * @stability stable
     */
    set healthProbeId(value: string);
    /**
     * @stability stable
     */
    resetHealthProbeId(): void;
    /**
     * @stability stable
     */
    get healthProbeIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _overprovision?;
    /**
     * @stability stable
     */
    get overprovision(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set overprovision(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOverprovision(): void;
    /**
     * @stability stable
     */
    get overprovisionInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _singlePlacementGroup?;
    /**
     * @stability stable
     */
    get singlePlacementGroup(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set singlePlacementGroup(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSinglePlacementGroup(): void;
    /**
     * @stability stable
     */
    get singlePlacementGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _upgradePolicyMode?;
    /**
     * @stability stable
     */
    get upgradePolicyMode(): string;
    /**
     * @stability stable
     */
    set upgradePolicyMode(value: string);
    /**
     * @stability stable
     */
    get upgradePolicyModeInput(): string | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _bootDiagnostics;
    /**
     * @stability stable
     */
    get bootDiagnostics(): VirtualMachineScaleSetBootDiagnosticsOutputReference;
    /**
     * @stability stable
     */
    putBootDiagnostics(value: VirtualMachineScaleSetBootDiagnostics): void;
    /**
     * @stability stable
     */
    resetBootDiagnostics(): void;
    /**
     * @stability stable
     */
    get bootDiagnosticsInput(): VirtualMachineScaleSetBootDiagnostics | undefined;
    private _extension?;
    /**
     * @stability stable
     */
    get extension(): VirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set extension(value: VirtualMachineScaleSetExtension[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExtension(): void;
    /**
     * @stability stable
     */
    get extensionInput(): cdktf.IResolvable | VirtualMachineScaleSetExtension[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): VirtualMachineScaleSetIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: VirtualMachineScaleSetIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): VirtualMachineScaleSetIdentity | undefined;
    private _networkProfile?;
    /**
     * @stability stable
     */
    get networkProfile(): VirtualMachineScaleSetNetworkProfile[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set networkProfile(value: VirtualMachineScaleSetNetworkProfile[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get networkProfileInput(): cdktf.IResolvable | VirtualMachineScaleSetNetworkProfile[] | undefined;
    private _osProfile;
    /**
     * @stability stable
     */
    get osProfile(): VirtualMachineScaleSetOsProfileOutputReference;
    /**
     * @stability stable
     */
    putOsProfile(value: VirtualMachineScaleSetOsProfile): void;
    /**
     * @stability stable
     */
    get osProfileInput(): VirtualMachineScaleSetOsProfile | undefined;
    private _osProfileLinuxConfig;
    /**
     * @stability stable
     */
    get osProfileLinuxConfig(): VirtualMachineScaleSetOsProfileLinuxConfigOutputReference;
    /**
     * @stability stable
     */
    putOsProfileLinuxConfig(value: VirtualMachineScaleSetOsProfileLinuxConfig): void;
    /**
     * @stability stable
     */
    resetOsProfileLinuxConfig(): void;
    /**
     * @stability stable
     */
    get osProfileLinuxConfigInput(): VirtualMachineScaleSetOsProfileLinuxConfig | undefined;
    private _osProfileSecrets?;
    /**
     * @stability stable
     */
    get osProfileSecrets(): VirtualMachineScaleSetOsProfileSecrets[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set osProfileSecrets(value: VirtualMachineScaleSetOsProfileSecrets[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOsProfileSecrets(): void;
    /**
     * @stability stable
     */
    get osProfileSecretsInput(): cdktf.IResolvable | VirtualMachineScaleSetOsProfileSecrets[] | undefined;
    private _osProfileWindowsConfig;
    /**
     * @stability stable
     */
    get osProfileWindowsConfig(): VirtualMachineScaleSetOsProfileWindowsConfigOutputReference;
    /**
     * @stability stable
     */
    putOsProfileWindowsConfig(value: VirtualMachineScaleSetOsProfileWindowsConfig): void;
    /**
     * @stability stable
     */
    resetOsProfileWindowsConfig(): void;
    /**
     * @stability stable
     */
    get osProfileWindowsConfigInput(): VirtualMachineScaleSetOsProfileWindowsConfig | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): VirtualMachineScaleSetPlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: VirtualMachineScaleSetPlan): void;
    /**
     * @stability stable
     */
    resetPlan(): void;
    /**
     * @stability stable
     */
    get planInput(): VirtualMachineScaleSetPlan | undefined;
    private _rollingUpgradePolicy;
    /**
     * @stability stable
     */
    get rollingUpgradePolicy(): VirtualMachineScaleSetRollingUpgradePolicyOutputReference;
    /**
     * @stability stable
     */
    putRollingUpgradePolicy(value: VirtualMachineScaleSetRollingUpgradePolicy): void;
    /**
     * @stability stable
     */
    resetRollingUpgradePolicy(): void;
    /**
     * @stability stable
     */
    get rollingUpgradePolicyInput(): VirtualMachineScaleSetRollingUpgradePolicy | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): VirtualMachineScaleSetSkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: VirtualMachineScaleSetSku): void;
    /**
     * @stability stable
     */
    get skuInput(): VirtualMachineScaleSetSku | undefined;
    private _storageProfileDataDisk?;
    /**
     * @stability stable
     */
    get storageProfileDataDisk(): VirtualMachineScaleSetStorageProfileDataDisk[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set storageProfileDataDisk(value: VirtualMachineScaleSetStorageProfileDataDisk[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStorageProfileDataDisk(): void;
    /**
     * @stability stable
     */
    get storageProfileDataDiskInput(): cdktf.IResolvable | VirtualMachineScaleSetStorageProfileDataDisk[] | undefined;
    private _storageProfileImageReference;
    /**
     * @stability stable
     */
    get storageProfileImageReference(): VirtualMachineScaleSetStorageProfileImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putStorageProfileImageReference(value: VirtualMachineScaleSetStorageProfileImageReference): void;
    /**
     * @stability stable
     */
    resetStorageProfileImageReference(): void;
    /**
     * @stability stable
     */
    get storageProfileImageReferenceInput(): VirtualMachineScaleSetStorageProfileImageReference | undefined;
    private _storageProfileOsDisk;
    /**
     * @stability stable
     */
    get storageProfileOsDisk(): VirtualMachineScaleSetStorageProfileOsDiskOutputReference;
    /**
     * @stability stable
     */
    putStorageProfileOsDisk(value: VirtualMachineScaleSetStorageProfileOsDisk): void;
    /**
     * @stability stable
     */
    get storageProfileOsDiskInput(): VirtualMachineScaleSetStorageProfileOsDisk | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualMachineScaleSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualMachineScaleSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
