import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#location VpnGateway#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#name VpnGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#resource_group_name VpnGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#routing_preference VpnGateway#routing_preference}.
     *
     * @stability stable
     */
    readonly routingPreference?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#scale_unit VpnGateway#scale_unit}.
     *
     * @stability stable
     */
    readonly scaleUnit?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#tags VpnGateway#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#virtual_hub_id VpnGateway#virtual_hub_id}.
     *
     * @stability stable
     */
    readonly virtualHubId: string;
    /**
     * bgp_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#bgp_settings VpnGateway#bgp_settings}
     *
     * @stability stable
     */
    readonly bgpSettings?: VpnGatewayBgpSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#timeouts VpnGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnGatewayTimeouts;
}
/**
 * @stability stable
 */
export interface VpnGatewayBgpSettingsInstance0BgpPeeringAddress {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#custom_ips VpnGateway#custom_ips}.
     *
     * @stability stable
     */
    readonly customIps: string[];
}
export declare function vpnGatewayBgpSettingsInstance0BgpPeeringAddressToTerraform(struct?: VpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference | VpnGatewayBgpSettingsInstance0BgpPeeringAddress): any;
/**
 * @stability stable
 */
export declare class VpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnGatewayBgpSettingsInstance0BgpPeeringAddress | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnGatewayBgpSettingsInstance0BgpPeeringAddress | undefined);
    private _customIps?;
    /**
     * @stability stable
     */
    get customIps(): string[];
    /**
     * @stability stable
     */
    set customIps(value: string[]);
    /**
     * @stability stable
     */
    get customIpsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get defaultIps(): string[];
    /**
     * @stability stable
     */
    get ipConfigurationId(): string;
    /**
     * @stability stable
     */
    get tunnelIps(): string[];
}
/**
 * @stability stable
 */
export interface VpnGatewayBgpSettingsInstance1BgpPeeringAddress {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#custom_ips VpnGateway#custom_ips}.
     *
     * @stability stable
     */
    readonly customIps: string[];
}
export declare function vpnGatewayBgpSettingsInstance1BgpPeeringAddressToTerraform(struct?: VpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference | VpnGatewayBgpSettingsInstance1BgpPeeringAddress): any;
/**
 * @stability stable
 */
export declare class VpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnGatewayBgpSettingsInstance1BgpPeeringAddress | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnGatewayBgpSettingsInstance1BgpPeeringAddress | undefined);
    private _customIps?;
    /**
     * @stability stable
     */
    get customIps(): string[];
    /**
     * @stability stable
     */
    set customIps(value: string[]);
    /**
     * @stability stable
     */
    get customIpsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get defaultIps(): string[];
    /**
     * @stability stable
     */
    get ipConfigurationId(): string;
    /**
     * @stability stable
     */
    get tunnelIps(): string[];
}
/**
 * @stability stable
 */
export interface VpnGatewayBgpSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#asn VpnGateway#asn}.
     *
     * @stability stable
     */
    readonly asn: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#peer_weight VpnGateway#peer_weight}.
     *
     * @stability stable
     */
    readonly peerWeight: number;
    /**
     * instance_0_bgp_peering_address block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#instance_0_bgp_peering_address VpnGateway#instance_0_bgp_peering_address}
     *
     * @stability stable
     */
    readonly instance0BgpPeeringAddress?: VpnGatewayBgpSettingsInstance0BgpPeeringAddress;
    /**
     * instance_1_bgp_peering_address block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#instance_1_bgp_peering_address VpnGateway#instance_1_bgp_peering_address}
     *
     * @stability stable
     */
    readonly instance1BgpPeeringAddress?: VpnGatewayBgpSettingsInstance1BgpPeeringAddress;
}
export declare function vpnGatewayBgpSettingsToTerraform(struct?: VpnGatewayBgpSettingsOutputReference | VpnGatewayBgpSettings): any;
/**
 * @stability stable
 */
export declare class VpnGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnGatewayBgpSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnGatewayBgpSettings | undefined);
    private _asn?;
    /**
     * @stability stable
     */
    get asn(): number;
    /**
     * @stability stable
     */
    set asn(value: number);
    /**
     * @stability stable
     */
    get asnInput(): number | undefined;
    /**
     * @stability stable
     */
    get bgpPeeringAddress(): string;
    private _peerWeight?;
    /**
     * @stability stable
     */
    get peerWeight(): number;
    /**
     * @stability stable
     */
    set peerWeight(value: number);
    /**
     * @stability stable
     */
    get peerWeightInput(): number | undefined;
    private _instance0BgpPeeringAddress;
    /**
     * @stability stable
     */
    get instance0BgpPeeringAddress(): VpnGatewayBgpSettingsInstance0BgpPeeringAddressOutputReference;
    /**
     * @stability stable
     */
    putInstance0BgpPeeringAddress(value: VpnGatewayBgpSettingsInstance0BgpPeeringAddress): void;
    /**
     * @stability stable
     */
    resetInstance0BgpPeeringAddress(): void;
    /**
     * @stability stable
     */
    get instance0BgpPeeringAddressInput(): VpnGatewayBgpSettingsInstance0BgpPeeringAddress | undefined;
    private _instance1BgpPeeringAddress;
    /**
     * @stability stable
     */
    get instance1BgpPeeringAddress(): VpnGatewayBgpSettingsInstance1BgpPeeringAddressOutputReference;
    /**
     * @stability stable
     */
    putInstance1BgpPeeringAddress(value: VpnGatewayBgpSettingsInstance1BgpPeeringAddress): void;
    /**
     * @stability stable
     */
    resetInstance1BgpPeeringAddress(): void;
    /**
     * @stability stable
     */
    get instance1BgpPeeringAddressInput(): VpnGatewayBgpSettingsInstance1BgpPeeringAddress | undefined;
}
/**
 * @stability stable
 */
export interface VpnGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#create VpnGateway#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#delete VpnGateway#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#read VpnGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway#update VpnGateway#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function vpnGatewayTimeoutsToTerraform(struct?: VpnGatewayTimeoutsOutputReference | VpnGatewayTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnGatewayTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway azurerm_vpn_gateway}.
 *
 * @stability stable
 */
export declare class VpnGateway extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway azurerm_vpn_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpnGatewayConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _routingPreference?;
    /**
     * @stability stable
     */
    get routingPreference(): string;
    /**
     * @stability stable
     */
    set routingPreference(value: string);
    /**
     * @stability stable
     */
    resetRoutingPreference(): void;
    /**
     * @stability stable
     */
    get routingPreferenceInput(): string | undefined;
    private _scaleUnit?;
    /**
     * @stability stable
     */
    get scaleUnit(): number;
    /**
     * @stability stable
     */
    set scaleUnit(value: number);
    /**
     * @stability stable
     */
    resetScaleUnit(): void;
    /**
     * @stability stable
     */
    get scaleUnitInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualHubId?;
    /**
     * @stability stable
     */
    get virtualHubId(): string;
    /**
     * @stability stable
     */
    set virtualHubId(value: string);
    /**
     * @stability stable
     */
    get virtualHubIdInput(): string | undefined;
    private _bgpSettings;
    /**
     * @stability stable
     */
    get bgpSettings(): VpnGatewayBgpSettingsOutputReference;
    /**
     * @stability stable
     */
    putBgpSettings(value: VpnGatewayBgpSettings): void;
    /**
     * @stability stable
     */
    resetBgpSettings(): void;
    /**
     * @stability stable
     */
    get bgpSettingsInput(): VpnGatewayBgpSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VpnGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
