import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnServerConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#location VpnServerConfiguration#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#resource_group_name VpnServerConfiguration#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#tags VpnServerConfiguration#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#vpn_authentication_types VpnServerConfiguration#vpn_authentication_types}.
     *
     * @stability stable
     */
    readonly vpnAuthenticationTypes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#vpn_protocols VpnServerConfiguration#vpn_protocols}.
     *
     * @stability stable
     */
    readonly vpnProtocols?: string[];
    /**
     * azure_active_directory_authentication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#azure_active_directory_authentication VpnServerConfiguration#azure_active_directory_authentication}
     *
     * @stability stable
     */
    readonly azureActiveDirectoryAuthentication?: VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable;
    /**
     * client_revoked_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#client_revoked_certificate VpnServerConfiguration#client_revoked_certificate}
     *
     * @stability stable
     */
    readonly clientRevokedCertificate?: VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable;
    /**
     * client_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#client_root_certificate VpnServerConfiguration#client_root_certificate}
     *
     * @stability stable
     */
    readonly clientRootCertificate?: VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable;
    /**
     * ipsec_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ipsec_policy VpnServerConfiguration#ipsec_policy}
     *
     * @stability stable
     */
    readonly ipsecPolicy?: VpnServerConfigurationIpsecPolicy;
    /**
     * radius block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#radius VpnServerConfiguration#radius}
     *
     * @stability stable
     */
    readonly radius?: VpnServerConfigurationRadius;
    /**
     * radius_server block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#radius_server VpnServerConfiguration#radius_server}
     *
     * @stability stable
     */
    readonly radiusServer?: VpnServerConfigurationRadiusServerA;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#timeouts VpnServerConfiguration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnServerConfigurationTimeouts;
}
/**
 * @stability stable
 */
export interface VpnServerConfigurationAzureActiveDirectoryAuthentication {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#audience VpnServerConfiguration#audience}.
     *
     * @stability stable
     */
    readonly audience: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#issuer VpnServerConfiguration#issuer}.
     *
     * @stability stable
     */
    readonly issuer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#tenant VpnServerConfiguration#tenant}.
     *
     * @stability stable
     */
    readonly tenant: string;
}
export declare function vpnServerConfigurationAzureActiveDirectoryAuthenticationToTerraform(struct?: VpnServerConfigurationAzureActiveDirectoryAuthentication | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationClientRevokedCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#thumbprint VpnServerConfiguration#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationClientRevokedCertificateToTerraform(struct?: VpnServerConfigurationClientRevokedCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationClientRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#public_cert_data VpnServerConfiguration#public_cert_data}.
     *
     * @stability stable
     */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationClientRootCertificateToTerraform(struct?: VpnServerConfigurationClientRootCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationIpsecPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#dh_group VpnServerConfiguration#dh_group}.
     *
     * @stability stable
     */
    readonly dhGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ike_encryption VpnServerConfiguration#ike_encryption}.
     *
     * @stability stable
     */
    readonly ikeEncryption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ike_integrity VpnServerConfiguration#ike_integrity}.
     *
     * @stability stable
     */
    readonly ikeIntegrity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ipsec_encryption VpnServerConfiguration#ipsec_encryption}.
     *
     * @stability stable
     */
    readonly ipsecEncryption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ipsec_integrity VpnServerConfiguration#ipsec_integrity}.
     *
     * @stability stable
     */
    readonly ipsecIntegrity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#pfs_group VpnServerConfiguration#pfs_group}.
     *
     * @stability stable
     */
    readonly pfsGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#sa_data_size_kilobytes VpnServerConfiguration#sa_data_size_kilobytes}.
     *
     * @stability stable
     */
    readonly saDataSizeKilobytes: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#sa_lifetime_seconds VpnServerConfiguration#sa_lifetime_seconds}.
     *
     * @stability stable
     */
    readonly saLifetimeSeconds: number;
}
export declare function vpnServerConfigurationIpsecPolicyToTerraform(struct?: VpnServerConfigurationIpsecPolicyOutputReference | VpnServerConfigurationIpsecPolicy): any;
/**
 * @stability stable
 */
export declare class VpnServerConfigurationIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnServerConfigurationIpsecPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnServerConfigurationIpsecPolicy | undefined);
    private _dhGroup?;
    /**
     * @stability stable
     */
    get dhGroup(): string;
    /**
     * @stability stable
     */
    set dhGroup(value: string);
    /**
     * @stability stable
     */
    get dhGroupInput(): string | undefined;
    private _ikeEncryption?;
    /**
     * @stability stable
     */
    get ikeEncryption(): string;
    /**
     * @stability stable
     */
    set ikeEncryption(value: string);
    /**
     * @stability stable
     */
    get ikeEncryptionInput(): string | undefined;
    private _ikeIntegrity?;
    /**
     * @stability stable
     */
    get ikeIntegrity(): string;
    /**
     * @stability stable
     */
    set ikeIntegrity(value: string);
    /**
     * @stability stable
     */
    get ikeIntegrityInput(): string | undefined;
    private _ipsecEncryption?;
    /**
     * @stability stable
     */
    get ipsecEncryption(): string;
    /**
     * @stability stable
     */
    set ipsecEncryption(value: string);
    /**
     * @stability stable
     */
    get ipsecEncryptionInput(): string | undefined;
    private _ipsecIntegrity?;
    /**
     * @stability stable
     */
    get ipsecIntegrity(): string;
    /**
     * @stability stable
     */
    set ipsecIntegrity(value: string);
    /**
     * @stability stable
     */
    get ipsecIntegrityInput(): string | undefined;
    private _pfsGroup?;
    /**
     * @stability stable
     */
    get pfsGroup(): string;
    /**
     * @stability stable
     */
    set pfsGroup(value: string);
    /**
     * @stability stable
     */
    get pfsGroupInput(): string | undefined;
    private _saDataSizeKilobytes?;
    /**
     * @stability stable
     */
    get saDataSizeKilobytes(): number;
    /**
     * @stability stable
     */
    set saDataSizeKilobytes(value: number);
    /**
     * @stability stable
     */
    get saDataSizeKilobytesInput(): number | undefined;
    private _saLifetimeSeconds?;
    /**
     * @stability stable
     */
    get saLifetimeSeconds(): number;
    /**
     * @stability stable
     */
    set saLifetimeSeconds(value: number);
    /**
     * @stability stable
     */
    get saLifetimeSecondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusClientRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#thumbprint VpnServerConfiguration#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationRadiusClientRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusClientRootCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServer {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#address VpnServerConfiguration#address}.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#score VpnServerConfiguration#score}.
     *
     * @stability stable
     */
    readonly score: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#secret VpnServerConfiguration#secret}.
     *
     * @stability stable
     */
    readonly secret: string;
}
export declare function vpnServerConfigurationRadiusServerToTerraform(struct?: VpnServerConfigurationRadiusServer | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServerRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#public_cert_data VpnServerConfiguration#public_cert_data}.
     *
     * @stability stable
     */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationRadiusServerRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerRootCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadius {
    /**
     * client_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#client_root_certificate VpnServerConfiguration#client_root_certificate}
     *
     * @stability stable
     */
    readonly clientRootCertificate?: VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable;
    /**
     * server block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#server VpnServerConfiguration#server}
     *
     * @stability stable
     */
    readonly server?: VpnServerConfigurationRadiusServer[] | cdktf.IResolvable;
    /**
     * server_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#server_root_certificate VpnServerConfiguration#server_root_certificate}
     *
     * @stability stable
     */
    readonly serverRootCertificate: VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable;
}
export declare function vpnServerConfigurationRadiusToTerraform(struct?: VpnServerConfigurationRadiusOutputReference | VpnServerConfigurationRadius): any;
/**
 * @stability stable
 */
export declare class VpnServerConfigurationRadiusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnServerConfigurationRadius | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnServerConfigurationRadius | undefined);
    private _clientRootCertificate?;
    /**
     * @stability stable
     */
    get clientRootCertificate(): VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientRootCertificate(value: VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientRootCertificate(): void;
    /**
     * @stability stable
     */
    get clientRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusClientRootCertificate[] | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): VpnServerConfigurationRadiusServer[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set server(value: VpnServerConfigurationRadiusServer[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetServer(): void;
    /**
     * @stability stable
     */
    get serverInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServer[] | undefined;
    private _serverRootCertificate?;
    /**
     * @stability stable
     */
    get serverRootCertificate(): VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set serverRootCertificate(value: VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get serverRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServerRootCertificate[] | undefined;
}
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServerClientRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#thumbprint VpnServerConfiguration#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationRadiusServerClientRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerClientRootCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServerServerRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#public_cert_data VpnServerConfiguration#public_cert_data}.
     *
     * @stability stable
     */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationRadiusServerServerRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerServerRootCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServerA {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#address VpnServerConfiguration#address}.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#secret VpnServerConfiguration#secret}.
     *
     * @stability stable
     */
    readonly secret: string;
    /**
     * client_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#client_root_certificate VpnServerConfiguration#client_root_certificate}
     *
     * @stability stable
     */
    readonly clientRootCertificate?: VpnServerConfigurationRadiusServerClientRootCertificate[] | cdktf.IResolvable;
    /**
     * server_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#server_root_certificate VpnServerConfiguration#server_root_certificate}
     *
     * @stability stable
     */
    readonly serverRootCertificate: VpnServerConfigurationRadiusServerServerRootCertificate[] | cdktf.IResolvable;
}
export declare function vpnServerConfigurationRadiusServerAToTerraform(struct?: VpnServerConfigurationRadiusServerAOutputReference | VpnServerConfigurationRadiusServerA): any;
/**
 * @stability stable
 */
export declare class VpnServerConfigurationRadiusServerAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnServerConfigurationRadiusServerA | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnServerConfigurationRadiusServerA | undefined);
    private _address?;
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    set address(value: string);
    /**
     * @stability stable
     */
    get addressInput(): string | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): string;
    /**
     * @stability stable
     */
    set secret(value: string);
    /**
     * @stability stable
     */
    get secretInput(): string | undefined;
    private _clientRootCertificate?;
    /**
     * @stability stable
     */
    get clientRootCertificate(): VpnServerConfigurationRadiusServerClientRootCertificate[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientRootCertificate(value: VpnServerConfigurationRadiusServerClientRootCertificate[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientRootCertificate(): void;
    /**
     * @stability stable
     */
    get clientRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServerClientRootCertificate[] | undefined;
    private _serverRootCertificate?;
    /**
     * @stability stable
     */
    get serverRootCertificate(): VpnServerConfigurationRadiusServerServerRootCertificate[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set serverRootCertificate(value: VpnServerConfigurationRadiusServerServerRootCertificate[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get serverRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServerServerRootCertificate[] | undefined;
}
/**
 * @stability stable
 */
export interface VpnServerConfigurationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#create VpnServerConfiguration#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#delete VpnServerConfiguration#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#read VpnServerConfiguration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#update VpnServerConfiguration#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function vpnServerConfigurationTimeoutsToTerraform(struct?: VpnServerConfigurationTimeoutsOutputReference | VpnServerConfigurationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VpnServerConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnServerConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnServerConfigurationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration azurerm_vpn_server_configuration}.
 *
 * @stability stable
 */
export declare class VpnServerConfiguration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration azurerm_vpn_server_configuration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpnServerConfigurationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpnAuthenticationTypes?;
    /**
     * @stability stable
     */
    get vpnAuthenticationTypes(): string[];
    /**
     * @stability stable
     */
    set vpnAuthenticationTypes(value: string[]);
    /**
     * @stability stable
     */
    get vpnAuthenticationTypesInput(): string[] | undefined;
    private _vpnProtocols?;
    /**
     * @stability stable
     */
    get vpnProtocols(): string[];
    /**
     * @stability stable
     */
    set vpnProtocols(value: string[]);
    /**
     * @stability stable
     */
    resetVpnProtocols(): void;
    /**
     * @stability stable
     */
    get vpnProtocolsInput(): string[] | undefined;
    private _azureActiveDirectoryAuthentication?;
    /**
     * @stability stable
     */
    get azureActiveDirectoryAuthentication(): VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set azureActiveDirectoryAuthentication(value: VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAzureActiveDirectoryAuthentication(): void;
    /**
     * @stability stable
     */
    get azureActiveDirectoryAuthenticationInput(): cdktf.IResolvable | VpnServerConfigurationAzureActiveDirectoryAuthentication[] | undefined;
    private _clientRevokedCertificate?;
    /**
     * @stability stable
     */
    get clientRevokedCertificate(): VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientRevokedCertificate(value: VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientRevokedCertificate(): void;
    /**
     * @stability stable
     */
    get clientRevokedCertificateInput(): cdktf.IResolvable | VpnServerConfigurationClientRevokedCertificate[] | undefined;
    private _clientRootCertificate?;
    /**
     * @stability stable
     */
    get clientRootCertificate(): VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientRootCertificate(value: VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientRootCertificate(): void;
    /**
     * @stability stable
     */
    get clientRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationClientRootCertificate[] | undefined;
    private _ipsecPolicy;
    /**
     * @stability stable
     */
    get ipsecPolicy(): VpnServerConfigurationIpsecPolicyOutputReference;
    /**
     * @stability stable
     */
    putIpsecPolicy(value: VpnServerConfigurationIpsecPolicy): void;
    /**
     * @stability stable
     */
    resetIpsecPolicy(): void;
    /**
     * @stability stable
     */
    get ipsecPolicyInput(): VpnServerConfigurationIpsecPolicy | undefined;
    private _radius;
    /**
     * @stability stable
     */
    get radius(): VpnServerConfigurationRadiusOutputReference;
    /**
     * @stability stable
     */
    putRadius(value: VpnServerConfigurationRadius): void;
    /**
     * @stability stable
     */
    resetRadius(): void;
    /**
     * @stability stable
     */
    get radiusInput(): VpnServerConfigurationRadius | undefined;
    private _radiusServer;
    /**
     * @stability stable
     */
    get radiusServer(): VpnServerConfigurationRadiusServerAOutputReference;
    /**
     * @stability stable
     */
    putRadiusServer(value: VpnServerConfigurationRadiusServerA): void;
    /**
     * @stability stable
     */
    resetRadiusServer(): void;
    /**
     * @stability stable
     */
    get radiusServerInput(): VpnServerConfigurationRadiusServerA | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VpnServerConfigurationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnServerConfigurationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnServerConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
