import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnSiteConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#address_cidrs VpnSite#address_cidrs}.
     *
     * @stability stable
     */
    readonly addressCidrs?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#device_model VpnSite#device_model}.
     *
     * @stability stable
     */
    readonly deviceModel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#device_vendor VpnSite#device_vendor}.
     *
     * @stability stable
     */
    readonly deviceVendor?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#location VpnSite#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#name VpnSite#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#resource_group_name VpnSite#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#tags VpnSite#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#virtual_wan_id VpnSite#virtual_wan_id}.
     *
     * @stability stable
     */
    readonly virtualWanId: string;
    /**
     * link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#link VpnSite#link}
     *
     * @stability stable
     */
    readonly link?: VpnSiteLink[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#timeouts VpnSite#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnSiteTimeouts;
}
/**
 * @stability stable
 */
export interface VpnSiteLinkBgp {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#asn VpnSite#asn}.
     *
     * @stability stable
     */
    readonly asn: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#peering_address VpnSite#peering_address}.
     *
     * @stability stable
     */
    readonly peeringAddress: string;
}
export declare function vpnSiteLinkBgpToTerraform(struct?: VpnSiteLinkBgpOutputReference | VpnSiteLinkBgp): any;
/**
 * @stability stable
 */
export declare class VpnSiteLinkBgpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnSiteLinkBgp | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnSiteLinkBgp | undefined);
    private _asn?;
    /**
     * @stability stable
     */
    get asn(): number;
    /**
     * @stability stable
     */
    set asn(value: number);
    /**
     * @stability stable
     */
    get asnInput(): number | undefined;
    private _peeringAddress?;
    /**
     * @stability stable
     */
    get peeringAddress(): string;
    /**
     * @stability stable
     */
    set peeringAddress(value: string);
    /**
     * @stability stable
     */
    get peeringAddressInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VpnSiteLink {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#fqdn VpnSite#fqdn}.
     *
     * @stability stable
     */
    readonly fqdn?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#ip_address VpnSite#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#name VpnSite#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#provider_name VpnSite#provider_name}.
     *
     * @stability stable
     */
    readonly providerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#speed_in_mbps VpnSite#speed_in_mbps}.
     *
     * @stability stable
     */
    readonly speedInMbps?: number;
    /**
     * bgp block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#bgp VpnSite#bgp}
     *
     * @stability stable
     */
    readonly bgp?: VpnSiteLinkBgp;
}
export declare function vpnSiteLinkToTerraform(struct?: VpnSiteLink | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface VpnSiteTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#create VpnSite#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#delete VpnSite#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#read VpnSite#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site#update VpnSite#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function vpnSiteTimeoutsToTerraform(struct?: VpnSiteTimeoutsOutputReference | VpnSiteTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VpnSiteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnSiteTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnSiteTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site azurerm_vpn_site}.
 *
 * @stability stable
 */
export declare class VpnSite extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site azurerm_vpn_site} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpnSiteConfig);
    private _addressCidrs?;
    /**
     * @stability stable
     */
    get addressCidrs(): string[];
    /**
     * @stability stable
     */
    set addressCidrs(value: string[]);
    /**
     * @stability stable
     */
    resetAddressCidrs(): void;
    /**
     * @stability stable
     */
    get addressCidrsInput(): string[] | undefined;
    private _deviceModel?;
    /**
     * @stability stable
     */
    get deviceModel(): string;
    /**
     * @stability stable
     */
    set deviceModel(value: string);
    /**
     * @stability stable
     */
    resetDeviceModel(): void;
    /**
     * @stability stable
     */
    get deviceModelInput(): string | undefined;
    private _deviceVendor?;
    /**
     * @stability stable
     */
    get deviceVendor(): string;
    /**
     * @stability stable
     */
    set deviceVendor(value: string);
    /**
     * @stability stable
     */
    resetDeviceVendor(): void;
    /**
     * @stability stable
     */
    get deviceVendorInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualWanId?;
    /**
     * @stability stable
     */
    get virtualWanId(): string;
    /**
     * @stability stable
     */
    set virtualWanId(value: string);
    /**
     * @stability stable
     */
    get virtualWanIdInput(): string | undefined;
    private _link?;
    /**
     * @stability stable
     */
    get link(): VpnSiteLink[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set link(value: VpnSiteLink[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLink(): void;
    /**
     * @stability stable
     */
    get linkInput(): cdktf.IResolvable | VpnSiteLink[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VpnSiteTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnSiteTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnSiteTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
