import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#location WebApplicationFirewallPolicy#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#name WebApplicationFirewallPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#resource_group_name WebApplicationFirewallPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#tags WebApplicationFirewallPolicy#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * custom_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#custom_rules WebApplicationFirewallPolicy#custom_rules}
     *
     * @stability stable
     */
    readonly customRules?: WebApplicationFirewallPolicyCustomRules[] | cdktf.IResolvable;
    /**
     * managed_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#managed_rules WebApplicationFirewallPolicy#managed_rules}
     *
     * @stability stable
     */
    readonly managedRules: WebApplicationFirewallPolicyManagedRules;
    /**
     * policy_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#policy_settings WebApplicationFirewallPolicy#policy_settings}
     *
     * @stability stable
     */
    readonly policySettings?: WebApplicationFirewallPolicyPolicySettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#timeouts WebApplicationFirewallPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WebApplicationFirewallPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#selector WebApplicationFirewallPolicy#selector}.
     *
     * @stability stable
     */
    readonly selector?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#variable_name WebApplicationFirewallPolicy#variable_name}.
     *
     * @stability stable
     */
    readonly variableName: string;
}
export declare function webApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariablesToTerraform(struct?: WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyCustomRulesMatchConditions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#match_values WebApplicationFirewallPolicy#match_values}.
     *
     * @stability stable
     */
    readonly matchValues: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#negation_condition WebApplicationFirewallPolicy#negation_condition}.
     *
     * @stability stable
     */
    readonly negationCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#operator WebApplicationFirewallPolicy#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#transforms WebApplicationFirewallPolicy#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
    /**
     * match_variables block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#match_variables WebApplicationFirewallPolicy#match_variables}
     *
     * @stability stable
     */
    readonly matchVariables: WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables[] | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyCustomRulesMatchConditionsToTerraform(struct?: WebApplicationFirewallPolicyCustomRulesMatchConditions | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyCustomRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#action WebApplicationFirewallPolicy#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#name WebApplicationFirewallPolicy#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#priority WebApplicationFirewallPolicy#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#rule_type WebApplicationFirewallPolicy#rule_type}.
     *
     * @stability stable
     */
    readonly ruleType: string;
    /**
     * match_conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#match_conditions WebApplicationFirewallPolicy#match_conditions}
     *
     * @stability stable
     */
    readonly matchConditions: WebApplicationFirewallPolicyCustomRulesMatchConditions[] | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyCustomRulesToTerraform(struct?: WebApplicationFirewallPolicyCustomRules | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyManagedRulesExclusion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#match_variable WebApplicationFirewallPolicy#match_variable}.
     *
     * @stability stable
     */
    readonly matchVariable: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#selector WebApplicationFirewallPolicy#selector}.
     *
     * @stability stable
     */
    readonly selector: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#selector_match_operator WebApplicationFirewallPolicy#selector_match_operator}.
     *
     * @stability stable
     */
    readonly selectorMatchOperator: string;
}
export declare function webApplicationFirewallPolicyManagedRulesExclusionToTerraform(struct?: WebApplicationFirewallPolicyManagedRulesExclusion | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#disabled_rules WebApplicationFirewallPolicy#disabled_rules}.
     *
     * @stability stable
     */
    readonly disabledRules: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#rule_group_name WebApplicationFirewallPolicy#rule_group_name}.
     *
     * @stability stable
     */
    readonly ruleGroupName: string;
}
export declare function webApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverrideToTerraform(struct?: WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyManagedRulesManagedRuleSet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#type WebApplicationFirewallPolicy#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#version WebApplicationFirewallPolicy#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * rule_group_override block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#rule_group_override WebApplicationFirewallPolicy#rule_group_override}
     *
     * @stability stable
     */
    readonly ruleGroupOverride?: WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride[] | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyManagedRulesManagedRuleSetToTerraform(struct?: WebApplicationFirewallPolicyManagedRulesManagedRuleSet | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyManagedRules {
    /**
     * exclusion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#exclusion WebApplicationFirewallPolicy#exclusion}
     *
     * @stability stable
     */
    readonly exclusion?: WebApplicationFirewallPolicyManagedRulesExclusion[] | cdktf.IResolvable;
    /**
     * managed_rule_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#managed_rule_set WebApplicationFirewallPolicy#managed_rule_set}
     *
     * @stability stable
     */
    readonly managedRuleSet: WebApplicationFirewallPolicyManagedRulesManagedRuleSet[] | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyManagedRulesToTerraform(struct?: WebApplicationFirewallPolicyManagedRulesOutputReference | WebApplicationFirewallPolicyManagedRules): any;
/**
 * @stability stable
 */
export declare class WebApplicationFirewallPolicyManagedRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WebApplicationFirewallPolicyManagedRules | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WebApplicationFirewallPolicyManagedRules | undefined);
    private _exclusion?;
    /**
     * @stability stable
     */
    get exclusion(): WebApplicationFirewallPolicyManagedRulesExclusion[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set exclusion(value: WebApplicationFirewallPolicyManagedRulesExclusion[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExclusion(): void;
    /**
     * @stability stable
     */
    get exclusionInput(): cdktf.IResolvable | WebApplicationFirewallPolicyManagedRulesExclusion[] | undefined;
    private _managedRuleSet?;
    /**
     * @stability stable
     */
    get managedRuleSet(): WebApplicationFirewallPolicyManagedRulesManagedRuleSet[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set managedRuleSet(value: WebApplicationFirewallPolicyManagedRulesManagedRuleSet[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get managedRuleSetInput(): cdktf.IResolvable | WebApplicationFirewallPolicyManagedRulesManagedRuleSet[] | undefined;
}
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyPolicySettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#enabled WebApplicationFirewallPolicy#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#file_upload_limit_in_mb WebApplicationFirewallPolicy#file_upload_limit_in_mb}.
     *
     * @stability stable
     */
    readonly fileUploadLimitInMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#max_request_body_size_in_kb WebApplicationFirewallPolicy#max_request_body_size_in_kb}.
     *
     * @stability stable
     */
    readonly maxRequestBodySizeInKb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#mode WebApplicationFirewallPolicy#mode}.
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#request_body_check WebApplicationFirewallPolicy#request_body_check}.
     *
     * @stability stable
     */
    readonly requestBodyCheck?: boolean | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyPolicySettingsToTerraform(struct?: WebApplicationFirewallPolicyPolicySettingsOutputReference | WebApplicationFirewallPolicyPolicySettings): any;
/**
 * @stability stable
 */
export declare class WebApplicationFirewallPolicyPolicySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WebApplicationFirewallPolicyPolicySettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WebApplicationFirewallPolicyPolicySettings | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _fileUploadLimitInMb?;
    /**
     * @stability stable
     */
    get fileUploadLimitInMb(): number;
    /**
     * @stability stable
     */
    set fileUploadLimitInMb(value: number);
    /**
     * @stability stable
     */
    resetFileUploadLimitInMb(): void;
    /**
     * @stability stable
     */
    get fileUploadLimitInMbInput(): number | undefined;
    private _maxRequestBodySizeInKb?;
    /**
     * @stability stable
     */
    get maxRequestBodySizeInKb(): number;
    /**
     * @stability stable
     */
    set maxRequestBodySizeInKb(value: number);
    /**
     * @stability stable
     */
    resetMaxRequestBodySizeInKb(): void;
    /**
     * @stability stable
     */
    get maxRequestBodySizeInKbInput(): number | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _requestBodyCheck?;
    /**
     * @stability stable
     */
    get requestBodyCheck(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requestBodyCheck(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequestBodyCheck(): void;
    /**
     * @stability stable
     */
    get requestBodyCheckInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface WebApplicationFirewallPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#create WebApplicationFirewallPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#delete WebApplicationFirewallPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#read WebApplicationFirewallPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#update WebApplicationFirewallPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function webApplicationFirewallPolicyTimeoutsToTerraform(struct?: WebApplicationFirewallPolicyTimeoutsOutputReference | WebApplicationFirewallPolicyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class WebApplicationFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WebApplicationFirewallPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WebApplicationFirewallPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy azurerm_web_application_firewall_policy}.
 *
 * @stability stable
 */
export declare class WebApplicationFirewallPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy azurerm_web_application_firewall_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WebApplicationFirewallPolicyConfig);
    /**
     * @stability stable
     */
    get httpListenerIds(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get pathBasedRuleIds(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _customRules?;
    /**
     * @stability stable
     */
    get customRules(): WebApplicationFirewallPolicyCustomRules[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customRules(value: WebApplicationFirewallPolicyCustomRules[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomRules(): void;
    /**
     * @stability stable
     */
    get customRulesInput(): cdktf.IResolvable | WebApplicationFirewallPolicyCustomRules[] | undefined;
    private _managedRules;
    /**
     * @stability stable
     */
    get managedRules(): WebApplicationFirewallPolicyManagedRulesOutputReference;
    /**
     * @stability stable
     */
    putManagedRules(value: WebApplicationFirewallPolicyManagedRules): void;
    /**
     * @stability stable
     */
    get managedRulesInput(): WebApplicationFirewallPolicyManagedRules | undefined;
    private _policySettings;
    /**
     * @stability stable
     */
    get policySettings(): WebApplicationFirewallPolicyPolicySettingsOutputReference;
    /**
     * @stability stable
     */
    putPolicySettings(value: WebApplicationFirewallPolicyPolicySettings): void;
    /**
     * @stability stable
     */
    resetPolicySettings(): void;
    /**
     * @stability stable
     */
    get policySettingsInput(): WebApplicationFirewallPolicyPolicySettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): WebApplicationFirewallPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WebApplicationFirewallPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WebApplicationFirewallPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
