# Copyright (C) 2021-Today - Akretion (<http://www.akretion.com>).
# @author Raphaël Valyi <raphael.valyi@akretion.com.br>
# @author Magno Costa <magno.costa@akretion.com.br>
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo.tests import tagged

from odoo.addons.l10n_br_account_payment_brcobranca.tests.common import (
    TestBrAccountPaymentOderCommon,
)


@tagged("post_install", "-at_install")
class TestReturnImport(TestBrAccountPaymentOderCommon):
    @classmethod
    def setUpClass(cls):
        super().setUpClass()

        # Get Invoice for test
        cls.invoice_unicred_1 = cls.env.ref(
            "l10n_br_account_payment_order."
            "demo_invoice_payment_order_unicred_cnab400"
        )
        cls.invoice_unicred_2 = cls.env.ref(
            "l10n_br_account_payment_brcobranca."
            "demo_invoice_brcobranca_unicred_cnab400"
        )

        cls.invoice_ailos_1 = cls.env.ref(
            "l10n_br_account_payment_order." "demo_invoice_payment_order_ailos_cnab240"
        )
        # I validate invoice by creating on
        # UNICRED 1
        cls.invoice_unicred_1.action_post()
        payment_order_unicred_1 = cls.env["account.payment.order"].search(
            [
                ("payment_mode_id", "=", cls.invoice_unicred_1.payment_mode_id.id),
                ("state", "in", ("draft", "cancel")),
            ]
        )
        payment_order_unicred_1.draft2open()
        cls._check_mocked_method(
            cls,
            payment_order_unicred_1,
            "teste_remessa-unicred_400-1.REM",
            "open2generated",
        )
        payment_order_unicred_1.generated2uploaded()

        # UNICRED 2
        cls.invoice_unicred_2.action_post()
        payment_order_unicred_2 = cls.env["account.payment.order"].search(
            [
                ("payment_mode_id", "=", cls.invoice_unicred_2.payment_mode_id.id),
                ("state", "in", ("draft", "cancel")),
            ]
        )
        payment_order_unicred_2.draft2open()
        cls._check_mocked_method(
            cls,
            payment_order_unicred_2,
            "teste_remessa-unicred_400-1.REM",
            "open2generated",
        )
        payment_order_unicred_1.generated2uploaded()

        # AILOS 1
        cls.invoice_ailos_1.action_post()
        payment_order_ailos_1 = cls.env["account.payment.order"].search(
            [
                ("payment_mode_id", "=", cls.invoice_ailos_1.payment_mode_id.id),
                ("state", "in", ("draft", "cancel")),
            ]
        )
        payment_order_ailos_1.draft2open()
        cls._check_mocked_method(
            cls, payment_order_ailos_1, "teste_remessa_ailos240.REM", "open2generated"
        )
        payment_order_ailos_1.generated2uploaded()

        # Diários Contabéis usados na Importação
        cls.journal_unicred = cls.env.ref(
            "l10n_br_account_payment_order.unicred_journal"
        )
        cls.journal_ailos = cls.env.ref("l10n_br_account_payment_order.ailos_journal")

        # Para evitar erros nos testes de variação da Sequencia do
        # Nosso Numero/own_number quando se roda mais de uma vez ou
        # devido a diferença entre os comandos feitos pelo Travis
        cls.invoice_unicred_1_own_numbers = []
        for line in cls.invoice_unicred_1.financial_move_line_ids:
            # No arquivo de retorno vem o NOSSO NUMERO + Digito Verificador
            cls.invoice_unicred_1_own_numbers.append(line.own_number + "0")

        cls.invoice_unicred_2_own_numbers = []
        for line in cls.invoice_unicred_2.financial_move_line_ids:
            # No arquivo de retorno vem o NOSSO NUMERO + Digito Verificador
            cls.invoice_unicred_2_own_numbers.append(line.own_number + "0")

        cls.invoice_ailos_1_own_numbers = []
        for line in cls.invoice_ailos_1.financial_move_line_ids:
            cls.invoice_ailos_1_own_numbers.append(line.own_number)

    def test_valor_menor_1(self):
        mocked_response = [
            {
                "codigo_registro": "1",
                "codigo_ocorrencia": "02",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                # "nosso_numero": "00000000000000010",
                "nosso_numero": self.invoice_unicred_1_own_numbers[0],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000300",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "060720",
                "valor_titulo": "0000000030000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "060720",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000200",
                "desconto_concedito": None,
                "valor_recebido": "0000000029650",
                "juros_mora": "0000000000000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "1",
                "codigo_ocorrencia": "02",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                # "nosso_numero": "00000000000000029",
                "nosso_numero": self.invoice_unicred_1_own_numbers[1],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000300",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "060720",
                "valor_titulo": "0000000070000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "060720",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000200",
                "desconto_concedito": None,
                "valor_recebido": "0000000069650",
                "juros_mora": "0000000000000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "9",
                "codigo_ocorrencia": "00",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "0000",
                "cedente_com_dv": "000000000",
                "convenio": None,
                "nosso_numero": "00          00000",
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "000000",
                "valor_titulo": "0000000000000",
                "banco_recebedor": "00",
                "agencia_recebedora_com_dv": "",
                "especie_documento": None,
                "data_credito": "000000",
                "valor_tarifa": "",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "",
                "juros_mora": "",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "000016",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
        ]

        log = self._run_import_return_file(
            mocked_response, "CNAB400UNICRED_valor_menor_1.RET", self.journal_unicred
        )
        self.assertEqual("Banco UNICRED - Conta 371", log.name)

    def test_valor_menor_2(self):
        mocked_response = [
            {
                "codigo_registro": "1",
                "codigo_ocorrencia": "06",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                # "nosso_numero": "00000000000000090",
                "nosso_numero": self.invoice_unicred_1_own_numbers[0],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000300",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "060720",
                "valor_titulo": "0000000030000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "060720",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000200",
                "desconto_concedito": None,
                "valor_recebido": "0000000029500",
                "juros_mora": "0000000000000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "1",
                "codigo_ocorrencia": "06",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                # "nosso_numero": "00000000000000109",
                "nosso_numero": self.invoice_unicred_1_own_numbers[1],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000300",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "060720",
                "valor_titulo": "0000000070000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "060720",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000200",
                "desconto_concedito": None,
                "valor_recebido": "0000000069500",
                "juros_mora": "0000000000000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "9",
                "codigo_ocorrencia": "00",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "0000",
                "cedente_com_dv": "000000000",
                "convenio": None,
                "nosso_numero": "00          00000",
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "000000",
                "valor_titulo": "0000000000000",
                "banco_recebedor": "00",
                "agencia_recebedora_com_dv": "",
                "especie_documento": None,
                "data_credito": "000000",
                "valor_tarifa": "",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "",
                "juros_mora": "",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "000016",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
        ]

        moves = self._run_import_return_file(
            mocked_response, "CNAB400UNICRED_valor_menor_2.RET", self.journal_unicred
        )
        self.assertEqual("Retorno CNAB - Banco UNICRED - Conta 371", moves.ref)
        # I check that the invoice state is "Paid"
        self.assertEqual(self.invoice_unicred_1.payment_state, "paid")

    def test_valor_maior_3(self):
        mocked_response = [
            {
                "codigo_registro": "1",
                "codigo_ocorrencia": "02",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                # "nosso_numero": "00000000000000030",
                "nosso_numero": self.invoice_unicred_2_own_numbers[0],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "060720",
                "valor_titulo": "0000000030000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "060720",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "0000000031000",
                "juros_mora": "0000000001000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "1",
                "codigo_ocorrencia": "02",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                # "nosso_numero": "00000000000000049",
                "nosso_numero": self.invoice_unicred_2_own_numbers[1],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "060720",
                "valor_titulo": "0000000070000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "060720",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "0000000071000",
                "juros_mora": "0000000001000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "9",
                "codigo_ocorrencia": "00",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "0000",
                "cedente_com_dv": "000000000",
                "convenio": None,
                "nosso_numero": "00          00000",
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "000000",
                "valor_titulo": "0000000000000",
                "banco_recebedor": "00",
                "agencia_recebedora_com_dv": "",
                "especie_documento": None,
                "data_credito": "000000",
                "valor_tarifa": "",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "",
                "juros_mora": "",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "000016",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
        ]

        log = self._run_import_return_file(
            mocked_response, "CNAB400UNICRED_valor_maior_3.RET", self.journal_unicred
        )
        self.assertEqual("Banco UNICRED - Conta 371", log.name)

    def test_valor_maior_4(self):
        mocked_response = [
            {
                "codigo_registro": "1",
                "codigo_ocorrencia": "06",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                # "nosso_numero": "00000000000000110",
                "nosso_numero": self.invoice_unicred_2_own_numbers[0],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "060720",
                "valor_titulo": "0000000030000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "060720",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "0000000031000",
                "juros_mora": "0000000001000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "1",
                "codigo_ocorrencia": "06",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                # "nosso_numero": "00000000000000129",
                "nosso_numero": self.invoice_unicred_2_own_numbers[1],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "060720",
                "valor_titulo": "0000000070000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "060720",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "0000000071000",
                "juros_mora": "0000000001000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "9",
                "codigo_ocorrencia": "00",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "0000",
                "cedente_com_dv": "000000000",
                "convenio": None,
                "nosso_numero": "00          00000",
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "000000",
                "valor_titulo": "0000000000000",
                "banco_recebedor": "00",
                "agencia_recebedora_com_dv": "",
                "especie_documento": None,
                "data_credito": "000000",
                "valor_tarifa": "",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "",
                "juros_mora": "",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "000016",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
        ]

        moves = self._run_import_return_file(
            mocked_response, "CNAB400UNICRED_valor_maior_4.RET", self.journal_unicred
        )
        self.assertEqual("Retorno CNAB - Banco UNICRED - Conta 371", moves.ref)
        # I check that the invoice state is "Paid"
        self.assertEqual(self.invoice_unicred_2.payment_state, "paid")

    def test_ailos_return(self):
        mocked_response = [
            {
                "codigo_registro": "03",
                "codigo_ocorrencia": "06",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                "nosso_numero": "00000000000" + self.invoice_ailos_1_own_numbers[0],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "06072021",
                "valor_titulo": "0000000030000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "06072021",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "0000000030000",
                "juros_mora": "0000000000000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "03",
                "codigo_ocorrencia": "06",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "1234",
                "cedente_com_dv": "000003719",
                "convenio": None,
                "nosso_numero": "00000000000" + self.invoice_ailos_1_own_numbers[1],
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "06072021",
                "valor_titulo": "0000000070000",
                "banco_recebedor": "136",
                "agencia_recebedora_com_dv": "12343",
                "especie_documento": None,
                "data_credito": "06072021",
                "valor_tarifa": "0000180",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "0000000070000",
                "juros_mora": "0000000000000",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "00000",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
            {
                "codigo_registro": "9",
                "codigo_ocorrencia": "00",
                "data_ocorrencia": None,
                "agencia_com_dv": None,
                "agencia_sem_dv": "0000",
                "cedente_com_dv": "000000000",
                "convenio": None,
                "nosso_numero": "00          00000",
                "tipo_cobranca": None,
                "tipo_cobranca_anterior": None,
                "natureza_recebimento": None,
                "carteira_variacao": None,
                "desconto": "0000000",
                "iof": None,
                "carteira": None,
                "comando": None,
                "data_liquidacao": None,
                "data_vencimento": "00000000",
                "valor_titulo": "0000000000000",
                "banco_recebedor": "00",
                "agencia_recebedora_com_dv": "",
                "especie_documento": None,
                "data_credito": "00000000",
                "valor_tarifa": "",
                "outras_despesas": None,
                "juros_desconto": None,
                "iof_desconto": None,
                "valor_abatimento": "0000000000000",
                "desconto_concedito": None,
                "valor_recebido": "",
                "juros_mora": "",
                "outros_recebimento": None,
                "abatimento_nao_aproveitado": None,
                "valor_lancamento": None,
                "indicativo_lancamento": None,
                "indicador_valor": None,
                "valor_ajuste": None,
                "sequencial": "000016",
                "arquivo": None,
                "motivo_ocorrencia": [],
                "documento_numero": None,
            },
        ]

        moves = self._run_import_return_file(
            mocked_response, "CNAB240AILOS.RET", self.journal_ailos
        )
        self.assertEqual(
            "Retorno CNAB - Banco COOP CENTRAL AILOS - Conta 373", moves.ref
        )
        # I check that the invoice state is "Paid"
        self.assertEqual(self.invoice_ailos_1.payment_state, "paid")
