# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib import util
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.gpu_info import (  # noqa: F401,E501
    GpuInfo,
)


class RequiredResources(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        num_cpu: int = None,
        memory: int = None,
        storage: int = None,
        gpu: List[GpuInfo] = None,
    ):  # noqa: E501
        """RequiredResources - a model defined in Swagger

        :param num_cpu: The num_cpu of this RequiredResources.  # noqa: E501
        :type num_cpu: int
        :param memory: The memory of this RequiredResources.  # noqa: E501
        :type memory: int
        :param storage: The storage of this RequiredResources.  # noqa: E501
        :type storage: int
        :param gpu: The gpu of this RequiredResources.  # noqa: E501
        :type gpu: List[GpuInfo]
        """
        self.swagger_types = {
            "num_cpu": int,
            "memory": int,
            "storage": int,
            "gpu": List[GpuInfo],
        }

        self.attribute_map = {
            "num_cpu": "numCPU",
            "memory": "memory",
            "storage": "storage",
            "gpu": "gpu",
        }
        self._num_cpu = num_cpu
        self._memory = memory
        self._storage = storage
        self._gpu = gpu

    @classmethod
    def from_dict(cls, dikt) -> "RequiredResources":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RequiredResources of this RequiredResources.  # noqa: E501
        :rtype: RequiredResources
        """
        return util.deserialize_model(dikt, cls)

    @property
    def num_cpu(self) -> int:
        """Gets the num_cpu of this RequiredResources.

        Number of virtual CPUs  # noqa: E501

        :return: The num_cpu of this RequiredResources.
        :rtype: int
        """
        return self._num_cpu

    @num_cpu.setter
    def num_cpu(self, num_cpu: int):
        """Sets the num_cpu of this RequiredResources.

        Number of virtual CPUs  # noqa: E501

        :param num_cpu: The num_cpu of this RequiredResources.
        :type num_cpu: int
        """
        if num_cpu is None:
            raise ValueError(
                "Invalid value for `num_cpu`, must not be `None`"
            )  # noqa: E501

        self._num_cpu = num_cpu

    @property
    def memory(self) -> int:
        """Gets the memory of this RequiredResources.

        Memory in giga bytes  # noqa: E501

        :return: The memory of this RequiredResources.
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory: int):
        """Sets the memory of this RequiredResources.

        Memory in giga bytes  # noqa: E501

        :param memory: The memory of this RequiredResources.
        :type memory: int
        """
        if memory is None:
            raise ValueError(
                "Invalid value for `memory`, must not be `None`"
            )  # noqa: E501

        self._memory = memory

    @property
    def storage(self) -> int:
        """Gets the storage of this RequiredResources.

        Storage in giga bytes  # noqa: E501

        :return: The storage of this RequiredResources.
        :rtype: int
        """
        return self._storage

    @storage.setter
    def storage(self, storage: int):
        """Sets the storage of this RequiredResources.

        Storage in giga bytes  # noqa: E501

        :param storage: The storage of this RequiredResources.
        :type storage: int
        """
        if storage is None:
            raise ValueError(
                "Invalid value for `storage`, must not be `None`"
            )  # noqa: E501

        self._storage = storage

    @property
    def gpu(self) -> List[GpuInfo]:
        """Gets the gpu of this RequiredResources.

        Number of GPUs  # noqa: E501

        :return: The gpu of this RequiredResources.
        :rtype: List[GpuInfo]
        """
        return self._gpu

    @gpu.setter
    def gpu(self, gpu: List[GpuInfo]):
        """Sets the gpu of this RequiredResources.

        Number of GPUs  # noqa: E501

        :param gpu: The gpu of this RequiredResources.
        :type gpu: List[GpuInfo]
        """

        self._gpu = gpu
