"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apigw = require("@aws-cdk/aws-apigateway");
const core_1 = require("@aws-cdk/core");
class ApiEventSource {
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    bind(target) {
        const id = `${target.node.uniqueId}:ApiEventSourceA7A86A4F`;
        const stack = core_1.Stack.of(target);
        let api = stack.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(stack, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
exports.ApiEventSource = ApiEventSource;
//# sourceMappingURL=data:application/json;base64,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