"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use an stream as an event source for AWS Lambda.
 */
class StreamEventSource {
    constructor(props) {
        this.props = props;
    }
    enrichMappingOptions(options) {
        return {
            ...options,
            batchSize: this.props.batchSize || 100,
            bisectBatchOnError: this.props.bisectBatchOnError,
            startingPosition: this.props.startingPosition,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxRecordAge: this.props.maxRecordAge,
            retryAttempts: this.props.retryAttempts,
            parallelizationFactor: this.props.parallelizationFactor,
            onFailure: this.props.onFailure,
        };
    }
}
exports.StreamEventSource = StreamEventSource;
//# sourceMappingURL=data:application/json;base64,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