"use strict";
const assert_1 = require("@aws-cdk/assert");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const sources = require("../lib");
const test_function_1 = require("./test-function");
module.exports = {
    'sufficiently complex example'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const fn = new test_function_1.TestFunction(stack, 'Fn');
        const bucket = new s3.Bucket(stack, 'B');
        // WHEN
        fn.addEventSource(new sources.S3EventSource(bucket, {
            events: [s3.EventType.OBJECT_CREATED, s3.EventType.OBJECT_REMOVED],
            filters: [
                { prefix: 'prefix/' },
                { suffix: '.png' },
            ],
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('Custom::S3BucketNotifications', {
            'NotificationConfiguration': {
                'LambdaFunctionConfigurations': [
                    {
                        'Events': [
                            's3:ObjectCreated:*',
                        ],
                        'Filter': {
                            'Key': {
                                'FilterRules': [
                                    {
                                        'Name': 'prefix',
                                        'Value': 'prefix/',
                                    },
                                    {
                                        'Name': 'suffix',
                                        'Value': '.png',
                                    },
                                ],
                            },
                        },
                        'LambdaFunctionArn': {
                            'Fn::GetAtt': [
                                'Fn9270CBC0',
                                'Arn',
                            ],
                        },
                    },
                    {
                        'Events': [
                            's3:ObjectRemoved:*',
                        ],
                        'Filter': {
                            'Key': {
                                'FilterRules': [
                                    {
                                        'Name': 'prefix',
                                        'Value': 'prefix/',
                                    },
                                    {
                                        'Name': 'suffix',
                                        'Value': '.png',
                                    },
                                ],
                            },
                        },
                        'LambdaFunctionArn': {
                            'Fn::GetAtt': [
                                'Fn9270CBC0',
                                'Arn',
                            ],
                        },
                    },
                ],
            },
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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