# swagger-client
See API specification Resource Guide > Event API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitSearchRequest() # PermitSearchRequest | 

try:
    api_response = api_instance.get_permit_summaries(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_permit_summaries: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
exclude_events_from = 'exclude_events_from_example' # str |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
workstream_prefix = ['workstream_prefix_example'] # list[str] |  (optional)
update_id = 1.2 # float |  (optional)
page_size = 1.2 # float |  (optional)

try:
    api_response = api_instance.get_works_updates(start_date=start_date, end_date=end_date, exclude_events_from=exclude_events_from, swa_code=swa_code, workstream_prefix=workstream_prefix, update_id=update_id, page_size=page_size)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_works_updates: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.SubscriptionCreateRequest() # SubscriptionCreateRequest | 

try:
    api_response = api_instance.subscribe_to_event(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->subscribe_to_event: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.SubscriptionRemoveRequest() # SubscriptionRemoveRequest | 

try:
    api_instance.unsubscribe_to_event(body)
except ApiException as e:
    print("Exception when calling DefaultApi->unsubscribe_to_event: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://department-for-transport-streetmanager.github.io/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_permit_summaries**](docs/DefaultApi.md#get_permit_summaries) | **POST** /permits/search | 
*DefaultApi* | [**get_works_updates**](docs/DefaultApi.md#get_works_updates) | **GET** /works/updates | 
*DefaultApi* | [**subscribe_to_event**](docs/DefaultApi.md#subscribe_to_event) | **POST** /api-notifications/subscribe | 
*DefaultApi* | [**unsubscribe_to_event**](docs/DefaultApi.md#unsubscribe_to_event) | **POST** /api-notifications/unsubscribe | 

## Documentation For Models

 - [ActivityTypeResponse](docs/ActivityTypeResponse.md)
 - [AllOfPermitSummaryResponseAssessmentStatus](docs/AllOfPermitSummaryResponseAssessmentStatus.md)
 - [AllOfPermitSummaryResponseLaneRentalAssessmentOutcome](docs/AllOfPermitSummaryResponseLaneRentalAssessmentOutcome.md)
 - [AssessmentStatusResponse](docs/AssessmentStatusResponse.md)
 - [AuditEventType](docs/AuditEventType.md)
 - [AuditObjectTypeResponse](docs/AuditObjectTypeResponse.md)
 - [LaneRentalAssessmentOutcomeResponse](docs/LaneRentalAssessmentOutcomeResponse.md)
 - [PermitCondition](docs/PermitCondition.md)
 - [PermitConditionTypeResponse](docs/PermitConditionTypeResponse.md)
 - [PermitSearchReportingResponse](docs/PermitSearchReportingResponse.md)
 - [PermitSearchRequest](docs/PermitSearchRequest.md)
 - [PermitStatusResponse](docs/PermitStatusResponse.md)
 - [PermitSummaryResponse](docs/PermitSummaryResponse.md)
 - [SubscriptionCreateRequest](docs/SubscriptionCreateRequest.md)
 - [SubscriptionCreateResponse](docs/SubscriptionCreateResponse.md)
 - [SubscriptionRemoveRequest](docs/SubscriptionRemoveRequest.md)
 - [TrafficManagementTypeResponse](docs/TrafficManagementTypeResponse.md)
 - [WorkCategoryResponse](docs/WorkCategoryResponse.md)
 - [WorkStatusResponse](docs/WorkStatusResponse.md)
 - [WorkUpdateResponse](docs/WorkUpdateResponse.md)
 - [WorkUpdateSummaryResponse](docs/WorkUpdateSummaryResponse.md)

## Documentation For Authorization


## token

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header


## Author


