# swagger-client
See API specification Resource Guide > Data Export API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.CommentCSVExportRequest() # CommentCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_comments_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_comments_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ExpiringInterimReinstatementCSVExportRequest() # ExpiringInterimReinstatementCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_expiring_interim_reinstatements_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_expiring_interim_reinstatements_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.FeesCSVExportRequest() # FeesCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_fees_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_fees_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ForwardPlanCSVExportRequest() # ForwardPlanCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_forward_plans_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_forward_plans_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.FPNCSVExportRequest() # FPNCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_fpns_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_fpns_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.InspectionCSVExportRequest() # InspectionCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_inspection_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_inspection_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.InterestedPartyPermitsCSVExportRequest() # InterestedPartyPermitsCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_interested_party_permits(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_interested_party_permits: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.MaterialClassificationCSVExportRequest() # MaterialClassificationCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_material_classification_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_material_classification_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.NonComplianceCSVExportRequest() # NonComplianceCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_non_compliances_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_non_compliances_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PbiSampleInspectionTargetCSVExportRequest() # PbiSampleInspectionTargetCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_pbi_sample_inspection_targets_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_pbi_sample_inspection_targets_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PbiSampleInspectionsDueCSVExportRequest() # PbiSampleInspectionsDueCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_pbi_sample_inspections_due_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_pbi_sample_inspections_due_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitAlterationCSVExportRequest() # PermitAlterationCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_permit_alterations_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_permit_alterations_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermitCSVExportRequest() # PermitCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_permits_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_permits_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.PrivateStreetCSVExportRequest() # PrivateStreetCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_private_street_notices_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_private_street_notices_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ReinspectionCSVExportRequest() # ReinspectionCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_reinspection_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_reinspection_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ReinstatementCSVExportRequest() # ReinstatementCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_reinstatements_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_reinstatements_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.ReinstatementsDueCSVExportRequest() # ReinstatementsDueCSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_reinstatements_due_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_reinstatements_due_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section58CSVExportRequest() # Section58CSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_section58_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_section58_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section74CSVExportRequest() # Section74CSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_section74_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_section74_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.Section81CSVExportRequest() # Section81CSVExportRequest |  (optional)

try:
    api_response = api_instance.generate_section81_csv(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_section81_csv: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
csv_id = 1.2 # float | 

try:
    api_response = api_instance.get_csv(csv_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_csv: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://department-for-transport-streetmanager.github.io/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**generate_comments_csv**](docs/DefaultApi.md#generate_comments_csv) | **POST** /comments/csv | 
*DefaultApi* | [**generate_expiring_interim_reinstatements_csv**](docs/DefaultApi.md#generate_expiring_interim_reinstatements_csv) | **POST** /reinstatements/expiring-interims/csv | 
*DefaultApi* | [**generate_fees_csv**](docs/DefaultApi.md#generate_fees_csv) | **POST** /fees/csv | 
*DefaultApi* | [**generate_forward_plans_csv**](docs/DefaultApi.md#generate_forward_plans_csv) | **POST** /forward-plans/csv | 
*DefaultApi* | [**generate_fpns_csv**](docs/DefaultApi.md#generate_fpns_csv) | **POST** /fixed-penalty-notices/csv | 
*DefaultApi* | [**generate_inspection_csv**](docs/DefaultApi.md#generate_inspection_csv) | **POST** /inspections/csv | 
*DefaultApi* | [**generate_interested_party_permits**](docs/DefaultApi.md#generate_interested_party_permits) | **POST** /interested-party-permits/csv | 
*DefaultApi* | [**generate_material_classification_csv**](docs/DefaultApi.md#generate_material_classification_csv) | **POST** /material-classifications/csv | 
*DefaultApi* | [**generate_non_compliances_csv**](docs/DefaultApi.md#generate_non_compliances_csv) | **POST** /non-compliances/csv | 
*DefaultApi* | [**generate_pbi_sample_inspection_targets_csv**](docs/DefaultApi.md#generate_pbi_sample_inspection_targets_csv) | **POST** /pbi-sample-inspection-targets/csv | 
*DefaultApi* | [**generate_pbi_sample_inspections_due_csv**](docs/DefaultApi.md#generate_pbi_sample_inspections_due_csv) | **POST** /pbi-sample-inspections-due/csv | 
*DefaultApi* | [**generate_permit_alterations_csv**](docs/DefaultApi.md#generate_permit_alterations_csv) | **POST** /alterations/csv | 
*DefaultApi* | [**generate_permits_csv**](docs/DefaultApi.md#generate_permits_csv) | **POST** /permits/csv | 
*DefaultApi* | [**generate_private_street_notices_csv**](docs/DefaultApi.md#generate_private_street_notices_csv) | **POST** /private-street-notices/csv | 
*DefaultApi* | [**generate_reinspection_csv**](docs/DefaultApi.md#generate_reinspection_csv) | **POST** /reinspections/csv | 
*DefaultApi* | [**generate_reinstatements_csv**](docs/DefaultApi.md#generate_reinstatements_csv) | **POST** /reinstatements/csv | 
*DefaultApi* | [**generate_reinstatements_due_csv**](docs/DefaultApi.md#generate_reinstatements_due_csv) | **POST** /permits/reinstatements-due/csv | 
*DefaultApi* | [**generate_section58_csv**](docs/DefaultApi.md#generate_section58_csv) | **POST** /section-58s/csv | 
*DefaultApi* | [**generate_section74_csv**](docs/DefaultApi.md#generate_section74_csv) | **POST** /section-74s/csv | 
*DefaultApi* | [**generate_section81_csv**](docs/DefaultApi.md#generate_section81_csv) | **POST** /section-81s/csv | 
*DefaultApi* | [**get_csv**](docs/DefaultApi.md#get_csv) | **GET** /csv/{csvId} | 

## Documentation For Models

 - [AllOfFeesCSVExportRequestFeeReportFormat](docs/AllOfFeesCSVExportRequestFeeReportFormat.md)
 - [AllOfPermitCSVExportRequestCsvExportPrefix](docs/AllOfPermitCSVExportRequestCsvExportPrefix.md)
 - [AlterationStatus](docs/AlterationStatus.md)
 - [AlterationType](docs/AlterationType.md)
 - [CSVExportDetailsResponse](docs/CSVExportDetailsResponse.md)
 - [CSVExportResponse](docs/CSVExportResponse.md)
 - [CSVExportStatusResponse](docs/CSVExportStatusResponse.md)
 - [CSVExportTypeResponse](docs/CSVExportTypeResponse.md)
 - [CommentCSVExportRequest](docs/CommentCSVExportRequest.md)
 - [CommentTopic](docs/CommentTopic.md)
 - [ExpiringInterimReinstatementCSVExportRequest](docs/ExpiringInterimReinstatementCSVExportRequest.md)
 - [FPNCSVExportRequest](docs/FPNCSVExportRequest.md)
 - [FPNStatus](docs/FPNStatus.md)
 - [FPNsCreatedCSVExportRequest](docs/FPNsCreatedCSVExportRequest.md)
 - [FeeReportFormat](docs/FeeReportFormat.md)
 - [FeesCSVExportRequest](docs/FeesCSVExportRequest.md)
 - [ForwardPlanCSVExportRequest](docs/ForwardPlanCSVExportRequest.md)
 - [ForwardPlanStatus](docs/ForwardPlanStatus.md)
 - [HAInspectionOutcomeStatusType](docs/HAInspectionOutcomeStatusType.md)
 - [InspectionCSVExportRequest](docs/InspectionCSVExportRequest.md)
 - [InspectionCategory](docs/InspectionCategory.md)
 - [InspectionOutcome](docs/InspectionOutcome.md)
 - [InspectionOutcomesCSVExportRequest](docs/InspectionOutcomesCSVExportRequest.md)
 - [InspectionType](docs/InspectionType.md)
 - [InterestedPartyPermitsCSVExportRequest](docs/InterestedPartyPermitsCSVExportRequest.md)
 - [LaneRentalAssessmentOutcome](docs/LaneRentalAssessmentOutcome.md)
 - [MaterialClassificationCSVExportRequest](docs/MaterialClassificationCSVExportRequest.md)
 - [MaterialClassificationClassification](docs/MaterialClassificationClassification.md)
 - [NonComplianceCSVExportRequest](docs/NonComplianceCSVExportRequest.md)
 - [NonComplianceResponseStatus](docs/NonComplianceResponseStatus.md)
 - [NonComplianceStatus](docs/NonComplianceStatus.md)
 - [NumberOfInspectionUnitsCSVExportRequest](docs/NumberOfInspectionUnitsCSVExportRequest.md)
 - [OffenceCode](docs/OffenceCode.md)
 - [OrganisationDataCSVExportRequest](docs/OrganisationDataCSVExportRequest.md)
 - [PbiSampleInspectionPassFailRatesCSVExportRequest](docs/PbiSampleInspectionPassFailRatesCSVExportRequest.md)
 - [PbiSampleInspectionTargetCSVExportRequest](docs/PbiSampleInspectionTargetCSVExportRequest.md)
 - [PbiSampleInspectionsDueCSVExportRequest](docs/PbiSampleInspectionsDueCSVExportRequest.md)
 - [PermitAlterationCSVExportRequest](docs/PermitAlterationCSVExportRequest.md)
 - [PermitAlterationOutcomesCSVExportRequest](docs/PermitAlterationOutcomesCSVExportRequest.md)
 - [PermitAlterationsCreatedCSVExportRequest](docs/PermitAlterationsCreatedCSVExportRequest.md)
 - [PermitCSVExportRequest](docs/PermitCSVExportRequest.md)
 - [PermitCsvExportPrefix](docs/PermitCsvExportPrefix.md)
 - [PermitOutcomesCSVExportRequest](docs/PermitOutcomesCSVExportRequest.md)
 - [PermitStatus](docs/PermitStatus.md)
 - [PermitsCreatedCSVExportRequest](docs/PermitsCreatedCSVExportRequest.md)
 - [PrivateStreetCSVExportRequest](docs/PrivateStreetCSVExportRequest.md)
 - [PrivateStreetStatus](docs/PrivateStreetStatus.md)
 - [PromoterInspectionOutcomeStatusType](docs/PromoterInspectionOutcomeStatusType.md)
 - [ReinspectionCSVExportRequest](docs/ReinspectionCSVExportRequest.md)
 - [ReinstatementCSVExportRequest](docs/ReinstatementCSVExportRequest.md)
 - [ReinstatementStatus](docs/ReinstatementStatus.md)
 - [ReinstatementsDueCSVExportRequest](docs/ReinstatementsDueCSVExportRequest.md)
 - [Section58CSVExportRequest](docs/Section58CSVExportRequest.md)
 - [Section58Status](docs/Section58Status.md)
 - [Section74CSVExportRequest](docs/Section74CSVExportRequest.md)
 - [Section74HAStatus](docs/Section74HAStatus.md)
 - [Section81CSVExportRequest](docs/Section81CSVExportRequest.md)
 - [Section81Severity](docs/Section81Severity.md)
 - [Section81Status](docs/Section81Status.md)
 - [Section81Type](docs/Section81Type.md)
 - [WorkCategory](docs/WorkCategory.md)
 - [WorkStatus](docs/WorkStatus.md)

## Documentation For Authorization


## token

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header


## Author


