# swagger-client
See API specification Resource Guide > GeoJSON API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
min_easting = 1.2 # float | 
min_northing = 1.2 # float | 
max_easting = 1.2 # float | 
max_northing = 1.2 # float | 
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)

try:
    api_response = api_instance.get_activities_intersecting_bounds(min_easting, min_northing, max_easting, max_northing, start_date=start_date, end_date=end_date)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_activities_intersecting_bounds: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
min_easting = 1.2 # float | 
min_northing = 1.2 # float | 
max_easting = 1.2 # float | 
max_northing = 1.2 # float | 
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
ancillary_info_reference_number = 'ancillary_info_reference_number_example' # str |  (optional)

try:
    api_response = api_instance.get_ancillary_information_intersect_bounding_box(min_easting, min_northing, max_easting, max_northing, start_date=start_date, end_date=end_date, ancillary_info_reference_number=ancillary_info_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_ancillary_information_intersect_bounding_box: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
min_easting = 1.2 # float | 
min_northing = 1.2 # float | 
max_easting = 1.2 # float | 
max_northing = 1.2 # float | 
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
forward_plan_reference_number = 'forward_plan_reference_number_example' # str |  (optional)

try:
    api_response = api_instance.get_forward_plans_intersect_bounding_box(min_easting, min_northing, max_easting, max_northing, start_date=start_date, end_date=end_date, forward_plan_reference_number=forward_plan_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_forward_plans_intersect_bounding_box: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
min_easting = 1.2 # float | 
min_northing = 1.2 # float | 
max_easting = 1.2 # float | 
max_northing = 1.2 # float | 
phase = swagger_client.Hs2ActLimitPhase() # Hs2ActLimitPhase | 

try:
    api_response = api_instance.get_hs2_act_limits_intersecting_bounds(min_easting, min_northing, max_easting, max_northing, phase)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_hs2_act_limits_intersecting_bounds: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
min_easting = 1.2 # float |  (optional)
min_northing = 1.2 # float |  (optional)
max_easting = 1.2 # float |  (optional)
max_northing = 1.2 # float |  (optional)
sample_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
sample_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
usrn = 1.2 # float |  (optional)
classification = swagger_client.MaterialClassificationClassification() # MaterialClassificationClassification |  (optional)

try:
    api_response = api_instance.get_material_classifications_intersect_bounding_box(min_easting=min_easting, min_northing=min_northing, max_easting=max_easting, max_northing=max_northing, sample_date_from=sample_date_from, sample_date_to=sample_date_to, usrn=usrn, classification=classification)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_material_classifications_intersect_bounding_box: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
min_easting = 1.2 # float | 
min_northing = 1.2 # float | 
max_easting = 1.2 # float | 
max_northing = 1.2 # float | 
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
section_58_reference_number = 'section_58_reference_number_example' # str |  (optional)

try:
    api_response = api_instance.get_section58s_intersect_bounding_box(min_easting, min_northing, max_easting, max_northing, start_date=start_date, end_date=end_date, section_58_reference_number=section_58_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section58s_intersect_bounding_box: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
min_easting = 1.2 # float | 
min_northing = 1.2 # float | 
max_easting = 1.2 # float | 
max_northing = 1.2 # float | 
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)

try:
    api_response = api_instance.get_works_intersect_bounding_box(min_easting, min_northing, max_easting, max_northing, start_date=start_date, end_date=end_date, work_reference_number=work_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_works_intersect_bounding_box: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://department-for-transport-streetmanager.github.io/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_activities_intersecting_bounds**](docs/DefaultApi.md#get_activities_intersecting_bounds) | **GET** /activities | 
*DefaultApi* | [**get_ancillary_information_intersect_bounding_box**](docs/DefaultApi.md#get_ancillary_information_intersect_bounding_box) | **GET** /ancillary-informations | 
*DefaultApi* | [**get_forward_plans_intersect_bounding_box**](docs/DefaultApi.md#get_forward_plans_intersect_bounding_box) | **GET** /forward-plans | 
*DefaultApi* | [**get_hs2_act_limits_intersecting_bounds**](docs/DefaultApi.md#get_hs2_act_limits_intersecting_bounds) | **GET** /hs2-act-limits | 
*DefaultApi* | [**get_material_classifications_intersect_bounding_box**](docs/DefaultApi.md#get_material_classifications_intersect_bounding_box) | **GET** /material-classifications | 
*DefaultApi* | [**get_section58s_intersect_bounding_box**](docs/DefaultApi.md#get_section58s_intersect_bounding_box) | **GET** /section-58s | 
*DefaultApi* | [**get_works_intersect_bounding_box**](docs/DefaultApi.md#get_works_intersect_bounding_box) | **GET** /works | 

## Documentation For Models

 - [ActivityActivityTypeResponse](docs/ActivityActivityTypeResponse.md)
 - [ActivityFeature](docs/ActivityFeature.md)
 - [ActivityProperties](docs/ActivityProperties.md)
 - [ActivityResponse](docs/ActivityResponse.md)
 - [AllOfWorkPropertiesIndustrySector](docs/AllOfWorkPropertiesIndustrySector.md)
 - [AncillaryInfoFeature](docs/AncillaryInfoFeature.md)
 - [AncillaryInfoProperties](docs/AncillaryInfoProperties.md)
 - [AncillaryInfoResponse](docs/AncillaryInfoResponse.md)
 - [AncillaryInfoStatusResponse](docs/AncillaryInfoStatusResponse.md)
 - [AncillaryInfoTypeResponse](docs/AncillaryInfoTypeResponse.md)
 - [FeatureCollectionType](docs/FeatureCollectionType.md)
 - [FeatureType](docs/FeatureType.md)
 - [ForwardPlanFeature](docs/ForwardPlanFeature.md)
 - [ForwardPlanProperties](docs/ForwardPlanProperties.md)
 - [ForwardPlanResponse](docs/ForwardPlanResponse.md)
 - [ForwardPlanStatusResponse](docs/ForwardPlanStatusResponse.md)
 - [GeoJSONCentrePoint](docs/GeoJSONCentrePoint.md)
 - [GeoJSONCentrePointType](docs/GeoJSONCentrePointType.md)
 - [GeoJSONFeatureTypeResponse](docs/GeoJSONFeatureTypeResponse.md)
 - [GeoJSONGeometry](docs/GeoJSONGeometry.md)
 - [Hs2ActLimitPhase](docs/Hs2ActLimitPhase.md)
 - [Hs2ActLimitsFeature](docs/Hs2ActLimitsFeature.md)
 - [Hs2ActLimitsResponse](docs/Hs2ActLimitsResponse.md)
 - [IndustrySectorResponse](docs/IndustrySectorResponse.md)
 - [LocationTypeResponse](docs/LocationTypeResponse.md)
 - [MaterialClassificationClassification](docs/MaterialClassificationClassification.md)
 - [MaterialClassificationClassificationResponse](docs/MaterialClassificationClassificationResponse.md)
 - [MaterialClassificationFeature](docs/MaterialClassificationFeature.md)
 - [MaterialClassificationMaterialTypeResponse](docs/MaterialClassificationMaterialTypeResponse.md)
 - [MaterialClassificationProperties](docs/MaterialClassificationProperties.md)
 - [MaterialClassificationResponse](docs/MaterialClassificationResponse.md)
 - [PermitStatusResponse](docs/PermitStatusResponse.md)
 - [Section58DurationResponse](docs/Section58DurationResponse.md)
 - [Section58ExtentResponse](docs/Section58ExtentResponse.md)
 - [Section58Feature](docs/Section58Feature.md)
 - [Section58Properties](docs/Section58Properties.md)
 - [Section58Response](docs/Section58Response.md)
 - [Section58StatusResponse](docs/Section58StatusResponse.md)
 - [TrafficManagementTypeResponse](docs/TrafficManagementTypeResponse.md)
 - [WorkCategoryResponse](docs/WorkCategoryResponse.md)
 - [WorkFeature](docs/WorkFeature.md)
 - [WorkProperties](docs/WorkProperties.md)
 - [WorkResponse](docs/WorkResponse.md)

## Documentation For Authorization


## token

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header


## Author


