# coding: utf-8

"""
    Street Manager Street Lookup API

    See API specification Resource Guide > Street Lookup API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ..api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_streets(self, body, **kwargs):  # noqa: E501
        """get_streets  # noqa: E501

        See API specification Resource Guide > Street Lookup API > Get streets endpoint for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_streets(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StreetsRequest body: (required)
        :return: list[StreetResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_streets_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_streets_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_streets_with_http_info(self, body, **kwargs):  # noqa: E501
        """get_streets  # noqa: E501

        See API specification Resource Guide > Street Lookup API > Get streets endpoint for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_streets_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StreetsRequest body: (required)
        :return: list[StreetResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_streets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_streets`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/nsg/streets/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StreetResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_streets_by_query(self, query, **kwargs):  # noqa: E501
        """get_streets_by_query  # noqa: E501

        See API specification Resource Guide > Street Lookup API > Get nsg search endpoint for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_streets_by_query(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: (required)
        :return: list[StreetSummaryResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_streets_by_query_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_streets_by_query_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def get_streets_by_query_with_http_info(self, query, **kwargs):  # noqa: E501
        """get_streets_by_query  # noqa: E501

        See API specification Resource Guide > Street Lookup API > Get nsg search endpoint for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_streets_by_query_with_http_info(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: (required)
        :return: list[StreetSummaryResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_streets_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `get_streets_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/nsg/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StreetSummaryResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_streets_by_usrn(self, usrn, **kwargs):  # noqa: E501
        """get_streets_by_usrn  # noqa: E501

        See API specification Resource Guide > Street Lookup API > Get streets endpoint for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_streets_by_usrn(usrn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float usrn: (required)
        :return: StreetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_streets_by_usrn_with_http_info(usrn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_streets_by_usrn_with_http_info(usrn, **kwargs)  # noqa: E501
            return data

    def get_streets_by_usrn_with_http_info(self, usrn, **kwargs):  # noqa: E501
        """get_streets_by_usrn  # noqa: E501

        See API specification Resource Guide > Street Lookup API > Get streets endpoint for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_streets_by_usrn_with_http_info(usrn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float usrn: (required)
        :return: StreetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['usrn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_streets_by_usrn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'usrn' is set
        if ('usrn' not in params or
                params['usrn'] is None):
            raise ValueError("Missing the required parameter `usrn` when calling `get_streets_by_usrn`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'usrn' in params:
            path_params['usrn'] = params['usrn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/nsg/streets/{usrn}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
