# swagger-client
See API specification Resource Guide > Party API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.WorkstreamCreateRequest() # WorkstreamCreateRequest | 
organisation_reference = 'organisation_reference_example' # str | 

try:
    api_response = api_instance.create_workstream(body, organisation_reference)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_workstream: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.UserForgotPasswordRequest() # UserForgotPasswordRequest | 

try:
    api_instance.forgot_password(body)
except ApiException as e:
    print("Exception when calling DefaultApi->forgot_password: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
organisation_reference = 'organisation_reference_example' # str | 

try:
    api_response = api_instance.get_organisation(organisation_reference)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_organisation: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
type = [swagger_client.OrganisationType()] # list[OrganisationType] |  (optional)
query = 'query_example' # str |  (optional)

try:
    api_response = api_instance.get_organisations(type=type, query=query)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_organisations: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
email = 'email_example' # str | 
swa_code = 'swa_code_example' # str |  (optional)

try:
    api_response = api_instance.get_user(email, swa_code=swa_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_user: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
organisation_reference = 'organisation_reference_example' # str | 
workstream_prefix = 'workstream_prefix_example' # str | 

try:
    api_response = api_instance.get_workstream(organisation_reference, workstream_prefix)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_workstream: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
organisation_reference = 'organisation_reference_example' # str | 

try:
    api_response = api_instance.get_workstreams(organisation_reference)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_workstreams: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.LogoutRequest() # LogoutRequest | 

try:
    api_instance.logout(body)
except ApiException as e:
    print("Exception when calling DefaultApi->logout: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.TokenRefreshRequest() # TokenRefreshRequest | 

try:
    api_response = api_instance.refresh(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->refresh: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.UserResetPasswordRequest() # UserResetPasswordRequest | 

try:
    api_instance.reset_password(body)
except ApiException as e:
    print("Exception when calling DefaultApi->reset_password: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.UpdateUserDetailsRequest() # UpdateUserDetailsRequest | 
email = 'email_example' # str | 

try:
    api_instance.update_user_details(body, email)
except ApiException as e:
    print("Exception when calling DefaultApi->update_user_details: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.WorkstreamUpdateRequest() # WorkstreamUpdateRequest | 
organisation_reference = 'organisation_reference_example' # str | 
workstream_prefix = 'workstream_prefix_example' # str | 

try:
    api_instance.update_workstream(body, organisation_reference, workstream_prefix)
except ApiException as e:
    print("Exception when calling DefaultApi->update_workstream: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://department-for-transport-streetmanager.github.io/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_workstream**](docs/DefaultApi.md#create_workstream) | **POST** /organisations/{organisationReference}/workstreams | 
*DefaultApi* | [**forgot_password**](docs/DefaultApi.md#forgot_password) | **POST** /forgot-password | 
*DefaultApi* | [**get_organisation**](docs/DefaultApi.md#get_organisation) | **GET** /organisations/{organisationReference} | 
*DefaultApi* | [**get_organisations**](docs/DefaultApi.md#get_organisations) | **GET** /organisations | 
*DefaultApi* | [**get_user**](docs/DefaultApi.md#get_user) | **GET** /users/{email} | 
*DefaultApi* | [**get_workstream**](docs/DefaultApi.md#get_workstream) | **GET** /organisations/{organisationReference}/workstreams/{workstreamPrefix} | 
*DefaultApi* | [**get_workstreams**](docs/DefaultApi.md#get_workstreams) | **GET** /organisations/{organisationReference}/workstreams | 
*DefaultApi* | [**logout**](docs/DefaultApi.md#logout) | **POST** /logout | 
*DefaultApi* | [**refresh**](docs/DefaultApi.md#refresh) | **POST** /refresh | 
*DefaultApi* | [**reset_password**](docs/DefaultApi.md#reset_password) | **POST** /reset-password | 
*DefaultApi* | [**update_user_details**](docs/DefaultApi.md#update_user_details) | **PUT** /users/{email} | 
*DefaultApi* | [**update_workstream**](docs/DefaultApi.md#update_workstream) | **PUT** /organisations/{organisationReference}/workstreams/{workstreamPrefix} | 

## Documentation For Models

 - [AdminUpdateUserRolesRequest](docs/AdminUpdateUserRolesRequest.md)
 - [AllOfInviteUserRequestRole](docs/AllOfInviteUserRequestRole.md)
 - [AllOfOrganisationResponseIndustrySector](docs/AllOfOrganisationResponseIndustrySector.md)
 - [AllOfOrganisationResponseOrganisationStatus](docs/AllOfOrganisationResponseOrganisationStatus.md)
 - [AllOfOrganisationSummaryResponseOrganisationStatus](docs/AllOfOrganisationSummaryResponseOrganisationStatus.md)
 - [AllOfOrganisationUpdateRequestIndustrySector](docs/AllOfOrganisationUpdateRequestIndustrySector.md)
 - [AllOfUserResponseOrganisationStatus](docs/AllOfUserResponseOrganisationStatus.md)
 - [IndustrySector](docs/IndustrySector.md)
 - [IndustrySectorResponse](docs/IndustrySectorResponse.md)
 - [InternalUpdateUserRolesRequest](docs/InternalUpdateUserRolesRequest.md)
 - [InviteUserRequest](docs/InviteUserRequest.md)
 - [LogoutRequest](docs/LogoutRequest.md)
 - [OnboardUserRequest](docs/OnboardUserRequest.md)
 - [OrganisationContractsCreateRequest](docs/OrganisationContractsCreateRequest.md)
 - [OrganisationFpnDetailsResponse](docs/OrganisationFpnDetailsResponse.md)
 - [OrganisationResponse](docs/OrganisationResponse.md)
 - [OrganisationStatusResponse](docs/OrganisationStatusResponse.md)
 - [OrganisationSummaryResponse](docs/OrganisationSummaryResponse.md)
 - [OrganisationType](docs/OrganisationType.md)
 - [OrganisationTypeResponse](docs/OrganisationTypeResponse.md)
 - [OrganisationUpdateRequest](docs/OrganisationUpdateRequest.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [PaymentMethodResponse](docs/PaymentMethodResponse.md)
 - [PermissionResponse](docs/PermissionResponse.md)
 - [ReOnboardUserRequest](docs/ReOnboardUserRequest.md)
 - [RemoveMultipleUsersRequest](docs/RemoveMultipleUsersRequest.md)
 - [RemoveUserRequest](docs/RemoveUserRequest.md)
 - [Role](docs/Role.md)
 - [RolePermissionsResponse](docs/RolePermissionsResponse.md)
 - [RoleResponse](docs/RoleResponse.md)
 - [SetPasswordRequest](docs/SetPasswordRequest.md)
 - [SetPasswordResponse](docs/SetPasswordResponse.md)
 - [TokenRefreshRequest](docs/TokenRefreshRequest.md)
 - [TokenRefreshResponse](docs/TokenRefreshResponse.md)
 - [UpdateOrganisationFpnDetailsRequest](docs/UpdateOrganisationFpnDetailsRequest.md)
 - [UpdateUserDetailsRequest](docs/UpdateUserDetailsRequest.md)
 - [UserCreateRequest](docs/UserCreateRequest.md)
 - [UserForgotPasswordRequest](docs/UserForgotPasswordRequest.md)
 - [UserResetPasswordRequest](docs/UserResetPasswordRequest.md)
 - [UserResponse](docs/UserResponse.md)
 - [UserWorkstreamAccess](docs/UserWorkstreamAccess.md)
 - [UserWorkstreamAccessDetails](docs/UserWorkstreamAccessDetails.md)
 - [UserWorkstreamAccessUpdateRequest](docs/UserWorkstreamAccessUpdateRequest.md)
 - [WorkstreamAccessLevel](docs/WorkstreamAccessLevel.md)
 - [WorkstreamAccessLevelResponse](docs/WorkstreamAccessLevelResponse.md)
 - [WorkstreamCreateRequest](docs/WorkstreamCreateRequest.md)
 - [WorkstreamCreateResponse](docs/WorkstreamCreateResponse.md)
 - [WorkstreamResponse](docs/WorkstreamResponse.md)
 - [WorkstreamStatusResponse](docs/WorkstreamStatusResponse.md)
 - [WorkstreamUpdateRequest](docs/WorkstreamUpdateRequest.md)

## Documentation For Authorization


## systemToken

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header

## token

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header


## Author


