# coding: utf-8

"""
    Street Manager Party API

    See API specification Resource Guide > Party API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ..api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_workstream(self, body, organisation_reference, **kwargs):  # noqa: E501
        """create_workstream  # noqa: E501

        See API specification Resource Guide > Party API > Post workstreams for more information Authenticated user must have one of the following roles: Planner, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workstream(body, organisation_reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkstreamCreateRequest body: (required)
        :param str organisation_reference: (required)
        :return: WorkstreamCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_workstream_with_http_info(body, organisation_reference, **kwargs)  # noqa: E501
        else:
            (data) = self.create_workstream_with_http_info(body, organisation_reference, **kwargs)  # noqa: E501
            return data

    def create_workstream_with_http_info(self, body, organisation_reference, **kwargs):  # noqa: E501
        """create_workstream  # noqa: E501

        See API specification Resource Guide > Party API > Post workstreams for more information Authenticated user must have one of the following roles: Planner, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workstream_with_http_info(body, organisation_reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkstreamCreateRequest body: (required)
        :param str organisation_reference: (required)
        :return: WorkstreamCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organisation_reference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workstream" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_workstream`")  # noqa: E501
        # verify the required parameter 'organisation_reference' is set
        if ('organisation_reference' not in params or
                params['organisation_reference'] is None):
            raise ValueError("Missing the required parameter `organisation_reference` when calling `create_workstream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organisation_reference' in params:
            path_params['organisationReference'] = params['organisation_reference']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/organisations/{organisationReference}/workstreams', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkstreamCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def forgot_password(self, body, **kwargs):  # noqa: E501
        """forgot_password  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forgot_password(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserForgotPasswordRequest body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.forgot_password_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.forgot_password_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def forgot_password_with_http_info(self, body, **kwargs):  # noqa: E501
        """forgot_password  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forgot_password_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserForgotPasswordRequest body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method forgot_password" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `forgot_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/forgot-password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organisation(self, organisation_reference, **kwargs):  # noqa: E501
        """get_organisation  # noqa: E501

        See API specification Resource Guide > Party API > Get organisation for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organisation(organisation_reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organisation_reference: (required)
        :return: OrganisationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organisation_with_http_info(organisation_reference, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organisation_with_http_info(organisation_reference, **kwargs)  # noqa: E501
            return data

    def get_organisation_with_http_info(self, organisation_reference, **kwargs):  # noqa: E501
        """get_organisation  # noqa: E501

        See API specification Resource Guide > Party API > Get organisation for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organisation_with_http_info(organisation_reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organisation_reference: (required)
        :return: OrganisationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organisation_reference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organisation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organisation_reference' is set
        if ('organisation_reference' not in params or
                params['organisation_reference'] is None):
            raise ValueError("Missing the required parameter `organisation_reference` when calling `get_organisation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organisation_reference' in params:
            path_params['organisationReference'] = params['organisation_reference']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/organisations/{organisationReference}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganisationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organisations(self, **kwargs):  # noqa: E501
        """get_organisations  # noqa: E501

        See API specification Resource Guide > Party API > Get organisations for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organisations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[OrganisationType] type:
        :param str query:
        :return: list[OrganisationSummaryResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organisations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_organisations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_organisations_with_http_info(self, **kwargs):  # noqa: E501
        """get_organisations  # noqa: E501

        See API specification Resource Guide > Party API > Get organisations for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organisations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[OrganisationType] type:
        :param str query:
        :return: list[OrganisationSummaryResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organisations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/organisations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganisationSummaryResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user(self, email, **kwargs):  # noqa: E501
        """get_user  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: (required)
        :param str swa_code:
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_with_http_info(email, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_with_http_info(email, **kwargs)  # noqa: E501
            return data

    def get_user_with_http_info(self, email, **kwargs):  # noqa: E501
        """get_user  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_with_http_info(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: (required)
        :param str swa_code:
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email', 'swa_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email' is set
        if ('email' not in params or
                params['email'] is None):
            raise ValueError("Missing the required parameter `email` when calling `get_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email' in params:
            path_params['email'] = params['email']  # noqa: E501

        query_params = []
        if 'swa_code' in params:
            query_params.append(('swaCode', params['swa_code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/users/{email}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workstream(self, organisation_reference, workstream_prefix, **kwargs):  # noqa: E501
        """get_workstream  # noqa: E501

        See API specification Resource Guide > Party API > Get workstream for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workstream(organisation_reference, workstream_prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organisation_reference: (required)
        :param str workstream_prefix: (required)
        :return: WorkstreamResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workstream_with_http_info(organisation_reference, workstream_prefix, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workstream_with_http_info(organisation_reference, workstream_prefix, **kwargs)  # noqa: E501
            return data

    def get_workstream_with_http_info(self, organisation_reference, workstream_prefix, **kwargs):  # noqa: E501
        """get_workstream  # noqa: E501

        See API specification Resource Guide > Party API > Get workstream for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workstream_with_http_info(organisation_reference, workstream_prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organisation_reference: (required)
        :param str workstream_prefix: (required)
        :return: WorkstreamResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organisation_reference', 'workstream_prefix']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workstream" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organisation_reference' is set
        if ('organisation_reference' not in params or
                params['organisation_reference'] is None):
            raise ValueError("Missing the required parameter `organisation_reference` when calling `get_workstream`")  # noqa: E501
        # verify the required parameter 'workstream_prefix' is set
        if ('workstream_prefix' not in params or
                params['workstream_prefix'] is None):
            raise ValueError("Missing the required parameter `workstream_prefix` when calling `get_workstream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organisation_reference' in params:
            path_params['organisationReference'] = params['organisation_reference']  # noqa: E501
        if 'workstream_prefix' in params:
            path_params['workstreamPrefix'] = params['workstream_prefix']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/organisations/{organisationReference}/workstreams/{workstreamPrefix}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkstreamResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workstreams(self, organisation_reference, **kwargs):  # noqa: E501
        """get_workstreams  # noqa: E501

        See API specification Resource Guide > Party API > Get workstreams for more information Authenticated user must have one of the following roles: Planner, Contractor, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workstreams(organisation_reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organisation_reference: (required)
        :return: list[WorkstreamResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workstreams_with_http_info(organisation_reference, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workstreams_with_http_info(organisation_reference, **kwargs)  # noqa: E501
            return data

    def get_workstreams_with_http_info(self, organisation_reference, **kwargs):  # noqa: E501
        """get_workstreams  # noqa: E501

        See API specification Resource Guide > Party API > Get workstreams for more information Authenticated user must have one of the following roles: Planner, Contractor, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workstreams_with_http_info(organisation_reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organisation_reference: (required)
        :return: list[WorkstreamResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organisation_reference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workstreams" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organisation_reference' is set
        if ('organisation_reference' not in params or
                params['organisation_reference'] is None):
            raise ValueError("Missing the required parameter `organisation_reference` when calling `get_workstreams`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organisation_reference' in params:
            path_params['organisationReference'] = params['organisation_reference']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/organisations/{organisationReference}/workstreams', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WorkstreamResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def logout(self, body, **kwargs):  # noqa: E501
        """logout  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.logout(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LogoutRequest body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.logout_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.logout_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def logout_with_http_info(self, body, **kwargs):  # noqa: E501
        """logout  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.logout_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LogoutRequest body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method logout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `logout`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/logout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refresh(self, body, **kwargs):  # noqa: E501
        """refresh  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TokenRefreshRequest body: (required)
        :return: TokenRefreshResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refresh_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.refresh_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def refresh_with_http_info(self, body, **kwargs):  # noqa: E501
        """refresh  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TokenRefreshRequest body: (required)
        :return: TokenRefreshResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `refresh`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/refresh', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenRefreshResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_password(self, body, **kwargs):  # noqa: E501
        """reset_password  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_password(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserResetPasswordRequest body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_password_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_password_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def reset_password_with_http_info(self, body, **kwargs):  # noqa: E501
        """reset_password  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_password_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserResetPasswordRequest body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_password" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `reset_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/reset-password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user_details(self, body, email, **kwargs):  # noqa: E501
        """update_user_details  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_details(body, email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateUserDetailsRequest body: (required)
        :param str email: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_user_details_with_http_info(body, email, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_details_with_http_info(body, email, **kwargs)  # noqa: E501
            return data

    def update_user_details_with_http_info(self, body, email, **kwargs):  # noqa: E501
        """update_user_details  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_details_with_http_info(body, email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateUserDetailsRequest body: (required)
        :param str email: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_user_details`")  # noqa: E501
        # verify the required parameter 'email' is set
        if ('email' not in params or
                params['email'] is None):
            raise ValueError("Missing the required parameter `email` when calling `update_user_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email' in params:
            path_params['email'] = params['email']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/users/{email}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workstream(self, body, organisation_reference, workstream_prefix, **kwargs):  # noqa: E501
        """update_workstream  # noqa: E501

        See API specification Resource Guide > Party API > Put workstream for more information Authenticated user must have one of the following roles: Planner, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workstream(body, organisation_reference, workstream_prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkstreamUpdateRequest body: (required)
        :param str organisation_reference: (required)
        :param str workstream_prefix: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_workstream_with_http_info(body, organisation_reference, workstream_prefix, **kwargs)  # noqa: E501
        else:
            (data) = self.update_workstream_with_http_info(body, organisation_reference, workstream_prefix, **kwargs)  # noqa: E501
            return data

    def update_workstream_with_http_info(self, body, organisation_reference, workstream_prefix, **kwargs):  # noqa: E501
        """update_workstream  # noqa: E501

        See API specification Resource Guide > Party API > Put workstream for more information Authenticated user must have one of the following roles: Planner, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workstream_with_http_info(body, organisation_reference, workstream_prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkstreamUpdateRequest body: (required)
        :param str organisation_reference: (required)
        :param str workstream_prefix: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organisation_reference', 'workstream_prefix']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workstream" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_workstream`")  # noqa: E501
        # verify the required parameter 'organisation_reference' is set
        if ('organisation_reference' not in params or
                params['organisation_reference'] is None):
            raise ValueError("Missing the required parameter `organisation_reference` when calling `update_workstream`")  # noqa: E501
        # verify the required parameter 'workstream_prefix' is set
        if ('workstream_prefix' not in params or
                params['workstream_prefix'] is None):
            raise ValueError("Missing the required parameter `workstream_prefix` when calling `update_workstream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organisation_reference' in params:
            path_params['organisationReference'] = params['organisation_reference']  # noqa: E501
        if 'workstream_prefix' in params:
            path_params['workstreamPrefix'] = params['workstream_prefix']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/organisations/{organisationReference}/workstreams/{workstreamPrefix}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
