# swagger-client
See API specification Resource Guide > Reporting API for more information on paging and endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
ha_organisation_name = 'ha_organisation_name_example' # str |  (optional)
activity_activity_type = [swagger_client.ActivityActivityType()] # list[ActivityActivityType] |  (optional)
offset = 1.2 # float |  (optional)
query = 'query_example' # str |  (optional)
sort_column = swagger_client.ActivitySortColumn() # ActivitySortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_activities(ha_organisation_name=ha_organisation_name, activity_activity_type=activity_activity_type, offset=offset, query=query, sort_column=sort_column, sort_direction=sort_direction, geographical_area_reference_number=geographical_area_reference_number, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_activities: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
sort_column = swagger_client.AlterationDurationChallengeSortColumn() # AlterationDurationChallengeSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
organisation = 'organisation_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
duration_challenge_review_status = [swagger_client.DurationChallengeReviewStatus()] # list[DurationChallengeReviewStatus] |  (optional)
duration_challenge_non_acceptance_response_status = [swagger_client.DurationChallengeNonAcceptanceResponseStatus()] # list[DurationChallengeNonAcceptanceResponseStatus] |  (optional)
work_status = [swagger_client.WorkStatus()] # list[WorkStatus] |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
permit_alteration_reference_number = 'permit_alteration_reference_number_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_alteration_duration_challenges(offset=offset, sort_column=sort_column, sort_direction=sort_direction, swa_code=swa_code, organisation=organisation, geographical_area_reference_number=geographical_area_reference_number, duration_challenge_review_status=duration_challenge_review_status, duration_challenge_non_acceptance_response_status=duration_challenge_non_acceptance_response_status, work_status=work_status, street_descriptor=street_descriptor, usrn=usrn, permit_alteration_reference_number=permit_alteration_reference_number, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_alteration_duration_challenges: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
alteration_status = [swagger_client.AlterationStatus()] # list[AlterationStatus] |  (optional)
alteration_type = [swagger_client.AlterationType()] # list[AlterationType] |  (optional)
work_status = [swagger_client.WorkStatus()] # list[WorkStatus] |  (optional)
work_category = [swagger_client.WorkCategory()] # list[WorkCategory] |  (optional)
lane_rental_assessment_outcome = [swagger_client.LaneRentalAssessmentOutcome()] # list[LaneRentalAssessmentOutcome] |  (optional)
start_date_created = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_created = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.AlterationSortColumn() # AlterationSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
is_traffic_sensitive = true # bool |  (optional)
is_high_impact_traffic_management = true # bool |  (optional)
is_duration_extension = true # bool |  (optional)
is_early_start = true # bool |  (optional)
is_deemed = true # bool |  (optional)
lane_rental_charges_not_agreed = true # bool |  (optional)
lane_rental_charges_potentially_apply = true # bool |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
status_update_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
status_update_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
permit_alteration_reference_number = 'permit_alteration_reference_number_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_alterations(alteration_status=alteration_status, alteration_type=alteration_type, work_status=work_status, work_category=work_category, lane_rental_assessment_outcome=lane_rental_assessment_outcome, start_date_created=start_date_created, end_date_created=end_date_created, offset=offset, sort_column=sort_column, sort_direction=sort_direction, is_traffic_sensitive=is_traffic_sensitive, is_high_impact_traffic_management=is_high_impact_traffic_management, is_duration_extension=is_duration_extension, is_early_start=is_early_start, is_deemed=is_deemed, lane_rental_charges_not_agreed=lane_rental_charges_not_agreed, lane_rental_charges_potentially_apply=lane_rental_charges_potentially_apply, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, status_update_date_from=status_update_date_from, status_update_date_to=status_update_date_to, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, permit_alteration_reference_number=permit_alteration_reference_number, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_alterations: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
date_created_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
date_created_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
topic = [swagger_client.CommentTopic()] # list[CommentTopic] |  (optional)
is_internal = true # bool |  (optional)
is_read = true # bool |  (optional)
is_not_read = true # bool |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
author_email_address = 'author_email_address_example' # str |  (optional)
is_incoming = true # bool |  (optional)
is_outgoing = true # bool |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_comments(offset=offset, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, date_created_from=date_created_from, date_created_to=date_created_to, topic=topic, is_internal=is_internal, is_read=is_read, is_not_read=is_not_read, work_reference_number=work_reference_number, author_email_address=author_email_address, is_incoming=is_incoming, is_outgoing=is_outgoing, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_comments: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_csv_exports(offset=offset, swa_code=swa_code, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_csv_exports: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
sort_column = swagger_client.ReinstatementSortColumn() # ReinstatementSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
offset = 1.2 # float |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
registration_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
registration_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
work_reference_number_exact = 'work_reference_number_exact_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_expiring_interim_reinstatements(sort_column=sort_column, sort_direction=sort_direction, offset=offset, swa_code=swa_code, registration_date_from=registration_date_from, registration_date_to=registration_date_to, end_date_from=end_date_from, end_date_to=end_date_to, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, work_reference_number=work_reference_number, work_reference_number_exact=work_reference_number_exact, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_expiring_interim_reinstatements: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
forward_plan_status = [swagger_client.ForwardPlanStatus()] # list[ForwardPlanStatus] |  (optional)
proposed_start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
proposed_end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_start_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_start_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_end_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_end_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.ForwardPlanSortColumn() # ForwardPlanSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
forward_plan_reference_number = 'forward_plan_reference_number_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_forward_plans(forward_plan_status=forward_plan_status, proposed_start_date=proposed_start_date, proposed_end_date=proposed_end_date, work_start_date_from=work_start_date_from, work_start_date_to=work_start_date_to, work_end_date_from=work_end_date_from, work_end_date_to=work_end_date_to, offset=offset, sort_column=sort_column, sort_direction=sort_direction, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, forward_plan_reference_number=forward_plan_reference_number, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_forward_plans: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
fpn_reference_number = 'fpn_reference_number_example' # str | 
file_type = [swagger_client.FileType()] # list[FileType] |  (optional)

try:
    api_response = api_instance.get_fpn_files(fpn_reference_number, file_type=file_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_fpn_files: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
status = [swagger_client.FPNStatus()] # list[FPNStatus] |  (optional)
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
offset = 1.2 # float |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
offence_code = [swagger_client.OffenceCode()] # list[OffenceCode] |  (optional)
status_changed_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
status_changed_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
sort_column = swagger_client.FPNSortColumn() # FPNSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_fpns(status=status, start_date=start_date, end_date=end_date, offset=offset, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, offence_code=offence_code, status_changed_date_from=status_changed_date_from, status_changed_date_to=status_changed_date_to, sort_column=sort_column, sort_direction=sort_direction, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, work_reference_number=work_reference_number, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_fpns: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))

try:
    api_response = api_instance.get_geographical_areas()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_geographical_areas: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
inspection_reference_number = 'inspection_reference_number_example' # str | 
file_type = [swagger_client.FileType()] # list[FileType] |  (optional)

try:
    api_response = api_instance.get_inspection_files(inspection_reference_number, file_type=file_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_inspection_files: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
inspection_type = [swagger_client.InspectionType()] # list[InspectionType] |  (optional)
inspection_outcome = [swagger_client.InspectionOutcome()] # list[InspectionOutcome] |  (optional)
start_date_created = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_created = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.InspectionSortColumn() # InspectionSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
inspection_category = [swagger_client.InspectionCategory()] # list[InspectionCategory] |  (optional)
promoter_outcome_status = [swagger_client.PromoterInspectionOutcomeStatusType()] # list[PromoterInspectionOutcomeStatusType] |  (optional)
ha_outcome_status = [swagger_client.HAInspectionOutcomeStatusType()] # list[HAInspectionOutcomeStatusType] |  (optional)
is_auto_accepted = true # bool |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_inspections(start_date=start_date, end_date=end_date, inspection_type=inspection_type, inspection_outcome=inspection_outcome, start_date_created=start_date_created, end_date_created=end_date_created, offset=offset, sort_column=sort_column, sort_direction=sort_direction, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, work_reference_number=work_reference_number, inspection_category=inspection_category, promoter_outcome_status=promoter_outcome_status, ha_outcome_status=ha_outcome_status, is_auto_accepted=is_auto_accepted, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_inspections: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
sort_column = swagger_client.PermitSortColumn() # PermitSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
permit_reference_number = 'permit_reference_number_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
work_start_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_start_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_end_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_end_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
start_date_created = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_created = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_status = [swagger_client.WorkStatus()] # list[WorkStatus] |  (optional)
work_category = [swagger_client.WorkCategory()] # list[WorkCategory] |  (optional)
is_high_impact_traffic_management = true # bool |  (optional)
usrn = 'usrn_example' # str |  (optional)
promoter_organisation_name = 'promoter_organisation_name_example' # str |  (optional)
ha_organisation_name = 'ha_organisation_name_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_interested_party_permits(offset=offset, sort_column=sort_column, sort_direction=sort_direction, geographical_area_reference_number=geographical_area_reference_number, street_descriptor=street_descriptor, permit_reference_number=permit_reference_number, work_reference_number=work_reference_number, work_start_date_from=work_start_date_from, work_start_date_to=work_start_date_to, work_end_date_from=work_end_date_from, work_end_date_to=work_end_date_to, start_date_created=start_date_created, end_date_created=end_date_created, work_status=work_status, work_category=work_category, is_high_impact_traffic_management=is_high_impact_traffic_management, usrn=usrn, promoter_organisation_name=promoter_organisation_name, ha_organisation_name=ha_organisation_name, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_interested_party_permits: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
offset = 1.2 # float |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
material_classification_reference_number = 'material_classification_reference_number_example' # str |  (optional)
material_classification_classification = swagger_client.MaterialClassificationClassification() # MaterialClassificationClassification |  (optional)
date_sample_taken_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
date_sample_taken_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
date_created_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
date_created_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_material_classifications(street_descriptor=street_descriptor, usrn=usrn, offset=offset, sort_direction=sort_direction, material_classification_reference_number=material_classification_reference_number, material_classification_classification=material_classification_classification, date_sample_taken_from=date_sample_taken_from, date_sample_taken_to=date_sample_taken_to, date_created_from=date_created_from, date_created_to=date_created_to, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_material_classifications: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
non_compliance_date_created_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
non_compliance_date_created_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
non_compliance_reference_number = 'non_compliance_reference_number_example' # str |  (optional)
non_compliance_status = [swagger_client.NonComplianceStatus()] # list[NonComplianceStatus] |  (optional)
ha_response_status = [swagger_client.NonComplianceResponseStatus()] # list[NonComplianceResponseStatus] |  (optional)
promoter_response_status = [swagger_client.NonComplianceResponseStatus()] # list[NonComplianceResponseStatus] |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.NonComplianceSortColumn() # NonComplianceSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
most_recent_inspection_type = [swagger_client.InspectionType()] # list[InspectionType] |  (optional)
most_recent_inspection_outcome = [swagger_client.InspectionOutcome()] # list[InspectionOutcome] |  (optional)
most_recent_inspection_promoter_response_status = [swagger_client.PromoterInspectionOutcomeStatusType()] # list[PromoterInspectionOutcomeStatusType] |  (optional)
most_recent_inspection_ha_response_status = [swagger_client.HAInspectionOutcomeStatusType()] # list[HAInspectionOutcomeStatusType] |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_non_compliances(non_compliance_date_created_from=non_compliance_date_created_from, non_compliance_date_created_to=non_compliance_date_created_to, non_compliance_reference_number=non_compliance_reference_number, non_compliance_status=non_compliance_status, ha_response_status=ha_response_status, promoter_response_status=promoter_response_status, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, offset=offset, sort_column=sort_column, sort_direction=sort_direction, most_recent_inspection_type=most_recent_inspection_type, most_recent_inspection_outcome=most_recent_inspection_outcome, most_recent_inspection_promoter_response_status=most_recent_inspection_promoter_response_status, most_recent_inspection_ha_response_status=most_recent_inspection_ha_response_status, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_non_compliances: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_pbi_sample_generation_jobs(offset=offset, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_pbi_sample_generation_jobs: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
quarter_start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
sort_column = swagger_client.PbiSampleInspectionTargetSortColumn() # PbiSampleInspectionTargetSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_pbi_sample_inspection_targets(offset=offset, quarter_start_date=quarter_start_date, sort_column=sort_column, sort_direction=sort_direction, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_pbi_sample_inspection_targets: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
sample_expiry_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
sample_expiry_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
sort_column = swagger_client.PbiSampleInspectionSortColumn() # PbiSampleInspectionSortColumn |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_pbi_sample_inspections(offset=offset, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, sort_direction=sort_direction, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, work_reference_number=work_reference_number, sample_expiry_date_from=sample_expiry_date_from, sample_expiry_date_to=sample_expiry_date_to, sort_column=sort_column, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_pbi_sample_inspections: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
sort_column = swagger_client.PermitDurationChallengeSortColumn() # PermitDurationChallengeSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
organisation = 'organisation_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
duration_challenge_review_status = [swagger_client.DurationChallengeReviewStatus()] # list[DurationChallengeReviewStatus] |  (optional)
duration_challenge_non_acceptance_response_status = [swagger_client.DurationChallengeNonAcceptanceResponseStatus()] # list[DurationChallengeNonAcceptanceResponseStatus] |  (optional)
work_status = [swagger_client.WorkStatus()] # list[WorkStatus] |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
permit_reference_number = 'permit_reference_number_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_permit_duration_challenges(offset=offset, sort_column=sort_column, sort_direction=sort_direction, swa_code=swa_code, organisation=organisation, geographical_area_reference_number=geographical_area_reference_number, duration_challenge_review_status=duration_challenge_review_status, duration_challenge_non_acceptance_response_status=duration_challenge_non_acceptance_response_status, work_status=work_status, street_descriptor=street_descriptor, usrn=usrn, permit_reference_number=permit_reference_number, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_permit_duration_challenges: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
permit_reference_number = 'permit_reference_number_example' # str | 
file_type = [swagger_client.FileType()] # list[FileType] |  (optional)

try:
    api_response = api_instance.get_permit_files(permit_reference_number, file_type=file_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_permit_files: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
status = [swagger_client.PermitStatus()] # list[PermitStatus] |  (optional)
work_status = [swagger_client.WorkStatus()] # list[WorkStatus] |  (optional)
work_category = [swagger_client.WorkCategory()] # list[WorkCategory] |  (optional)
lane_rental_assessment_outcome = [swagger_client.LaneRentalAssessmentOutcome()] # list[LaneRentalAssessmentOutcome] |  (optional)
active_permit_only = true # bool |  (optional)
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_start_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_start_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_end_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_end_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
start_date_created = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_created = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.PermitSortColumn() # PermitSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
is_traffic_sensitive = true # bool |  (optional)
is_high_impact_traffic_management = true # bool |  (optional)
has_no_final_registration = true # bool |  (optional)
has_excavation = true # bool |  (optional)
is_early_start = true # bool |  (optional)
is_deemed = true # bool |  (optional)
lane_rental_charges_not_agreed = true # bool |  (optional)
lane_rental_charges_potentially_apply = true # bool |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
ever_modification_requested = true # bool |  (optional)
hs2_works_only = true # bool |  (optional)
consultation_works_only = true # bool |  (optional)
consent_works_only = true # bool |  (optional)
unacknowledged_by_ha_only = true # bool |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
is_duration_challenged = true # bool |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
permit_reference_number = 'permit_reference_number_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
include_total_count = true # bool |  (optional)
reasonable_period_end_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
reasonable_period_end_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)

try:
    api_response = api_instance.get_permits(status=status, work_status=work_status, work_category=work_category, lane_rental_assessment_outcome=lane_rental_assessment_outcome, active_permit_only=active_permit_only, start_date=start_date, end_date=end_date, work_start_date_from=work_start_date_from, work_start_date_to=work_start_date_to, work_end_date_from=work_end_date_from, work_end_date_to=work_end_date_to, start_date_created=start_date_created, end_date_created=end_date_created, offset=offset, sort_column=sort_column, sort_direction=sort_direction, is_traffic_sensitive=is_traffic_sensitive, is_high_impact_traffic_management=is_high_impact_traffic_management, has_no_final_registration=has_no_final_registration, has_excavation=has_excavation, is_early_start=is_early_start, is_deemed=is_deemed, lane_rental_charges_not_agreed=lane_rental_charges_not_agreed, lane_rental_charges_potentially_apply=lane_rental_charges_potentially_apply, swa_code=swa_code, ever_modification_requested=ever_modification_requested, hs2_works_only=hs2_works_only, consultation_works_only=consultation_works_only, consent_works_only=consent_works_only, unacknowledged_by_ha_only=unacknowledged_by_ha_only, geographical_area_reference_number=geographical_area_reference_number, is_duration_challenged=is_duration_challenged, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, permit_reference_number=permit_reference_number, work_reference_number=work_reference_number, include_total_count=include_total_count, reasonable_period_end_date_from=reasonable_period_end_date_from, reasonable_period_end_date_to=reasonable_period_end_date_to)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_permits: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
private_street_reference_number = 'private_street_reference_number_example' # str | 
file_type = [swagger_client.FileType()] # list[FileType] |  (optional)

try:
    api_response = api_instance.get_private_street_files(private_street_reference_number, file_type=file_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_private_street_files: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
offset = 1.2 # float |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
sort_column = swagger_client.PrivateStreetNoticeSortColumn() # PrivateStreetNoticeSortColumn |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
private_street_reference_number = 'private_street_reference_number_example' # str |  (optional)
start_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
start_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
date_created_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
date_created_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
private_street_status = [swagger_client.PrivateStreetStatus()] # list[PrivateStreetStatus] |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_private_streets(offset=offset, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, sort_direction=sort_direction, sort_column=sort_column, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, private_street_reference_number=private_street_reference_number, start_date_from=start_date_from, start_date_to=start_date_to, end_date_from=end_date_from, end_date_to=end_date_to, date_created_from=date_created_from, date_created_to=date_created_to, private_street_status=private_street_status, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_private_streets: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
inspection_type = [swagger_client.InspectionType()] # list[InspectionType] |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.ReinspectionSortColumn() # ReinspectionSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
inspection_category = [swagger_client.InspectionCategory()] # list[InspectionCategory] |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_reinspections(start_date=start_date, end_date=end_date, inspection_type=inspection_type, offset=offset, sort_column=sort_column, sort_direction=sort_direction, swa_code=swa_code, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, work_reference_number=work_reference_number, inspection_category=inspection_category, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_reinspections: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
reinstatement_reference_number = 'reinstatement_reference_number_example' # str | 
file_type = [swagger_client.FileType()] # list[FileType] |  (optional)

try:
    api_response = api_instance.get_reinstatement_files(reinstatement_reference_number, file_type=file_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_reinstatement_files: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
sort_column = swagger_client.ReinstatementSortColumn() # ReinstatementSortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
status = [swagger_client.ReinstatementStatus()] # list[ReinstatementStatus] |  (optional)
offset = 1.2 # float |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
latest_reinstatements_only = true # bool |  (optional)
registration_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
registration_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
end_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
work_reference_number_exact = 'work_reference_number_exact_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_reinstatements(sort_column=sort_column, sort_direction=sort_direction, status=status, offset=offset, swa_code=swa_code, latest_reinstatements_only=latest_reinstatements_only, registration_date_from=registration_date_from, registration_date_to=registration_date_to, end_date_from=end_date_from, end_date_to=end_date_to, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, work_reference_number=work_reference_number, work_reference_number_exact=work_reference_number_exact, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_reinstatements: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
swa_code = 'swa_code_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
work_reference_number = 'work_reference_number_example' # str |  (optional)
work_end_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
work_end_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
registration_due_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
registration_due_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_reinstatements_due(swa_code=swa_code, street_descriptor=street_descriptor, usrn=usrn, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, work_reference_number=work_reference_number, work_end_date_from=work_end_date_from, work_end_date_to=work_end_date_to, registration_due_date_from=registration_due_date_from, registration_due_date_to=registration_due_date_to, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_reinstatements_due: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
ha_organisation_name = 'ha_organisation_name_example' # str |  (optional)
start_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
start_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
section_58_status = [swagger_client.Section58Status()] # list[Section58Status] |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.Section58SortColumn() # Section58SortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
section_58_reference_number = 'section_58_reference_number_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_section58s(ha_organisation_name=ha_organisation_name, start_date_from=start_date_from, start_date_to=start_date_to, section_58_status=section_58_status, offset=offset, sort_column=sort_column, sort_direction=sort_direction, geographical_area_reference_number=geographical_area_reference_number, section_58_reference_number=section_58_reference_number, street_descriptor=street_descriptor, usrn=usrn, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section58s: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
section_74_reference_number = 'section_74_reference_number_example' # str | 
file_type = [swagger_client.FileType()] # list[FileType] |  (optional)

try:
    api_response = api_instance.get_section74_files(section_74_reference_number, file_type=file_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section74_files: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
section_74_ha_status = [swagger_client.Section74HAStatus()] # list[Section74HAStatus] |  (optional)
issue_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
issue_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.Section74SortColumn() # Section74SortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
section_74_reference_number = 'section_74_reference_number_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_section74s(section_74_ha_status=section_74_ha_status, issue_date_from=issue_date_from, issue_date_to=issue_date_to, swa_code=swa_code, offset=offset, sort_column=sort_column, sort_direction=sort_direction, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, street_descriptor=street_descriptor, usrn=usrn, section_74_reference_number=section_74_reference_number, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section74s: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
section_81_reference_number = 'section_81_reference_number_example' # str | 
file_type = [swagger_client.FileType()] # list[FileType] |  (optional)

try:
    api_response = api_instance.get_section81_files(section_81_reference_number, file_type=file_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section81_files: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
section_81_status = [swagger_client.Section81Status()] # list[Section81Status] |  (optional)
section_81_severity = [swagger_client.Section81Severity()] # list[Section81Severity] |  (optional)
issue_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
issue_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
status_changed_date_from = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
status_changed_date_to = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
swa_code = 'swa_code_example' # str |  (optional)
offset = 1.2 # float |  (optional)
sort_column = swagger_client.Section81SortColumn() # Section81SortColumn |  (optional)
sort_direction = swagger_client.SortDirection() # SortDirection |  (optional)
geographical_area_reference_number = ['geographical_area_reference_number_example'] # list[str] |  (optional)
organisation = 'organisation_example' # str |  (optional)
section_81_type = [swagger_client.Section81Type()] # list[Section81Type] |  (optional)
street_descriptor = 'street_descriptor_example' # str |  (optional)
usrn = 'usrn_example' # str |  (optional)
section_81_reference_number = 'section_81_reference_number_example' # str |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_section81s(section_81_status=section_81_status, section_81_severity=section_81_severity, issue_date_from=issue_date_from, issue_date_to=issue_date_to, status_changed_date_from=status_changed_date_from, status_changed_date_to=status_changed_date_to, swa_code=swa_code, offset=offset, sort_column=sort_column, sort_direction=sort_direction, geographical_area_reference_number=geographical_area_reference_number, organisation=organisation, section_81_type=section_81_type, street_descriptor=street_descriptor, usrn=usrn, section_81_reference_number=section_81_reference_number, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_section81s: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str | 
file_type = [swagger_client.FileType()] # list[FileType] |  (optional)

try:
    api_response = api_instance.get_work_files(work_reference_number, file_type=file_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_work_files: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
work_reference_number = 'work_reference_number_example' # str |  (optional)
swa_code = 'swa_code_example' # str |  (optional)

try:
    api_response = api_instance.get_works(work_reference_number=work_reference_number, swa_code=swa_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_works: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
status = [swagger_client.WorkstreamStatus()] # list[WorkstreamStatus] |  (optional)
offset = 1.2 # float |  (optional)
include_total_count = true # bool |  (optional)

try:
    api_response = api_instance.get_workstreams(status=status, offset=offset, include_total_count=include_total_count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_workstreams: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://department-for-transport-streetmanager.github.io/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_activities**](docs/DefaultApi.md#get_activities) | **GET** /activities | 
*DefaultApi* | [**get_alteration_duration_challenges**](docs/DefaultApi.md#get_alteration_duration_challenges) | **GET** /alterations/duration-challenges | 
*DefaultApi* | [**get_alterations**](docs/DefaultApi.md#get_alterations) | **GET** /alterations | 
*DefaultApi* | [**get_comments**](docs/DefaultApi.md#get_comments) | **GET** /comments | 
*DefaultApi* | [**get_csv_exports**](docs/DefaultApi.md#get_csv_exports) | **GET** /csv-exports | 
*DefaultApi* | [**get_expiring_interim_reinstatements**](docs/DefaultApi.md#get_expiring_interim_reinstatements) | **GET** /reinstatements/expiring-interims | 
*DefaultApi* | [**get_forward_plans**](docs/DefaultApi.md#get_forward_plans) | **GET** /forward-plans | 
*DefaultApi* | [**get_fpn_files**](docs/DefaultApi.md#get_fpn_files) | **GET** /fixed-penalty-notices/files | 
*DefaultApi* | [**get_fpns**](docs/DefaultApi.md#get_fpns) | **GET** /fixed-penalty-notices | 
*DefaultApi* | [**get_geographical_areas**](docs/DefaultApi.md#get_geographical_areas) | **GET** /geographical-areas | 
*DefaultApi* | [**get_inspection_files**](docs/DefaultApi.md#get_inspection_files) | **GET** /inspections/files | 
*DefaultApi* | [**get_inspections**](docs/DefaultApi.md#get_inspections) | **GET** /inspections | 
*DefaultApi* | [**get_interested_party_permits**](docs/DefaultApi.md#get_interested_party_permits) | **GET** /interested-party-permits | 
*DefaultApi* | [**get_material_classifications**](docs/DefaultApi.md#get_material_classifications) | **GET** /material-classifications | 
*DefaultApi* | [**get_non_compliances**](docs/DefaultApi.md#get_non_compliances) | **GET** /non-compliances | 
*DefaultApi* | [**get_pbi_sample_generation_jobs**](docs/DefaultApi.md#get_pbi_sample_generation_jobs) | **GET** /pbi-sample-generation-jobs | 
*DefaultApi* | [**get_pbi_sample_inspection_targets**](docs/DefaultApi.md#get_pbi_sample_inspection_targets) | **GET** /pbi-sample-inspection-targets | 
*DefaultApi* | [**get_pbi_sample_inspections**](docs/DefaultApi.md#get_pbi_sample_inspections) | **GET** /pbi-sample-inspections | 
*DefaultApi* | [**get_permit_duration_challenges**](docs/DefaultApi.md#get_permit_duration_challenges) | **GET** /permits/duration-challenges | 
*DefaultApi* | [**get_permit_files**](docs/DefaultApi.md#get_permit_files) | **GET** /permits/files | 
*DefaultApi* | [**get_permits**](docs/DefaultApi.md#get_permits) | **GET** /permits | 
*DefaultApi* | [**get_private_street_files**](docs/DefaultApi.md#get_private_street_files) | **GET** /private-street-notices/files | 
*DefaultApi* | [**get_private_streets**](docs/DefaultApi.md#get_private_streets) | **GET** /private-street-notices | 
*DefaultApi* | [**get_reinspections**](docs/DefaultApi.md#get_reinspections) | **GET** /reinspections | 
*DefaultApi* | [**get_reinstatement_files**](docs/DefaultApi.md#get_reinstatement_files) | **GET** /reinstatements/files | 
*DefaultApi* | [**get_reinstatements**](docs/DefaultApi.md#get_reinstatements) | **GET** /reinstatements | 
*DefaultApi* | [**get_reinstatements_due**](docs/DefaultApi.md#get_reinstatements_due) | **GET** /permits/reinstatements-due | 
*DefaultApi* | [**get_section58s**](docs/DefaultApi.md#get_section58s) | **GET** /section-58s | 
*DefaultApi* | [**get_section74_files**](docs/DefaultApi.md#get_section74_files) | **GET** /section-74s/files | 
*DefaultApi* | [**get_section74s**](docs/DefaultApi.md#get_section74s) | **GET** /section-74s | 
*DefaultApi* | [**get_section81_files**](docs/DefaultApi.md#get_section81_files) | **GET** /section-81s/files | 
*DefaultApi* | [**get_section81s**](docs/DefaultApi.md#get_section81s) | **GET** /section-81s | 
*DefaultApi* | [**get_work_files**](docs/DefaultApi.md#get_work_files) | **GET** /works/files | 
*DefaultApi* | [**get_works**](docs/DefaultApi.md#get_works) | **GET** /works | 
*DefaultApi* | [**get_workstreams**](docs/DefaultApi.md#get_workstreams) | **GET** /workstreams | 

## Documentation For Models

 - [ActivityActivityType](docs/ActivityActivityType.md)
 - [ActivityActivityTypeResponse](docs/ActivityActivityTypeResponse.md)
 - [ActivityReportingResponse](docs/ActivityReportingResponse.md)
 - [ActivitySortColumn](docs/ActivitySortColumn.md)
 - [ActivitySummaryResponse](docs/ActivitySummaryResponse.md)
 - [ActivityTypeResponse](docs/ActivityTypeResponse.md)
 - [AllOfAlterationDurationChallengeSummaryResponseDurationChallengeNonAcceptanceResponseStatus](docs/AllOfAlterationDurationChallengeSummaryResponseDurationChallengeNonAcceptanceResponseStatus.md)
 - [AllOfAlterationDurationChallengeSummaryResponseDurationChallengeReviewStatus](docs/AllOfAlterationDurationChallengeSummaryResponseDurationChallengeReviewStatus.md)
 - [AllOfAlterationSummaryResponseLaneRentalAssessmentOutcome](docs/AllOfAlterationSummaryResponseLaneRentalAssessmentOutcome.md)
 - [AllOfInspectionSummaryResponseHaResponseStatus](docs/AllOfInspectionSummaryResponseHaResponseStatus.md)
 - [AllOfInspectionSummaryResponseInspectionCategory](docs/AllOfInspectionSummaryResponseInspectionCategory.md)
 - [AllOfInspectionSummaryResponseInspectionOutcome](docs/AllOfInspectionSummaryResponseInspectionOutcome.md)
 - [AllOfInspectionSummaryResponsePromoterResponseStatus](docs/AllOfInspectionSummaryResponsePromoterResponseStatus.md)
 - [AllOfNonComplianceSummaryResponseLatestPromoterResponseStatus](docs/AllOfNonComplianceSummaryResponseLatestPromoterResponseStatus.md)
 - [AllOfNonComplianceSummaryResponseMostRecentInspectionHaResponseStatus](docs/AllOfNonComplianceSummaryResponseMostRecentInspectionHaResponseStatus.md)
 - [AllOfNonComplianceSummaryResponseMostRecentInspectionPromoterResponseStatus](docs/AllOfNonComplianceSummaryResponseMostRecentInspectionPromoterResponseStatus.md)
 - [AllOfPermitDurationChallengeSummaryResponseDurationChallengeNonAcceptanceResponseStatus](docs/AllOfPermitDurationChallengeSummaryResponseDurationChallengeNonAcceptanceResponseStatus.md)
 - [AllOfPermitDurationChallengeSummaryResponseDurationChallengeReviewStatus](docs/AllOfPermitDurationChallengeSummaryResponseDurationChallengeReviewStatus.md)
 - [AllOfPermitSummaryResponseAssessmentStatus](docs/AllOfPermitSummaryResponseAssessmentStatus.md)
 - [AllOfPermitSummaryResponseLaneRentalAssessmentOutcome](docs/AllOfPermitSummaryResponseLaneRentalAssessmentOutcome.md)
 - [AllOfReinspectionSummaryResponseInspectionCategory](docs/AllOfReinspectionSummaryResponseInspectionCategory.md)
 - [AllOfSection74SummaryResponsePromoterStatus](docs/AllOfSection74SummaryResponsePromoterStatus.md)
 - [AlterationDurationChallengeReportingResponse](docs/AlterationDurationChallengeReportingResponse.md)
 - [AlterationDurationChallengeSortColumn](docs/AlterationDurationChallengeSortColumn.md)
 - [AlterationDurationChallengeSummaryResponse](docs/AlterationDurationChallengeSummaryResponse.md)
 - [AlterationReportingResponse](docs/AlterationReportingResponse.md)
 - [AlterationSortColumn](docs/AlterationSortColumn.md)
 - [AlterationStatus](docs/AlterationStatus.md)
 - [AlterationStatusResponse](docs/AlterationStatusResponse.md)
 - [AlterationSummaryResponse](docs/AlterationSummaryResponse.md)
 - [AlterationType](docs/AlterationType.md)
 - [AlterationTypeResponse](docs/AlterationTypeResponse.md)
 - [AssessmentStatusResponse](docs/AssessmentStatusResponse.md)
 - [AsyncJobStatusResponse](docs/AsyncJobStatusResponse.md)
 - [CSVExportReportingResponse](docs/CSVExportReportingResponse.md)
 - [CSVExportStatusResponse](docs/CSVExportStatusResponse.md)
 - [CSVExportSummaryResponse](docs/CSVExportSummaryResponse.md)
 - [CSVExportTypeResponse](docs/CSVExportTypeResponse.md)
 - [CommentReportingResponse](docs/CommentReportingResponse.md)
 - [CommentSummaryResponse](docs/CommentSummaryResponse.md)
 - [CommentTopic](docs/CommentTopic.md)
 - [CommentTopicResponse](docs/CommentTopicResponse.md)
 - [DurationChallengeNonAcceptanceResponseStatus](docs/DurationChallengeNonAcceptanceResponseStatus.md)
 - [DurationChallengeNonAcceptanceResponseStatusResponse](docs/DurationChallengeNonAcceptanceResponseStatusResponse.md)
 - [DurationChallengeReviewStatus](docs/DurationChallengeReviewStatus.md)
 - [DurationChallengeReviewStatusResponse](docs/DurationChallengeReviewStatusResponse.md)
 - [FPNReportingResponse](docs/FPNReportingResponse.md)
 - [FPNSortColumn](docs/FPNSortColumn.md)
 - [FPNStatus](docs/FPNStatus.md)
 - [FPNStatusResponse](docs/FPNStatusResponse.md)
 - [FPNSummaryResponse](docs/FPNSummaryResponse.md)
 - [FileSummaryReportingResponse](docs/FileSummaryReportingResponse.md)
 - [FileSummaryResponse](docs/FileSummaryResponse.md)
 - [FileType](docs/FileType.md)
 - [ForwardPlanReportingResponse](docs/ForwardPlanReportingResponse.md)
 - [ForwardPlanSortColumn](docs/ForwardPlanSortColumn.md)
 - [ForwardPlanStatus](docs/ForwardPlanStatus.md)
 - [ForwardPlanStatusResponse](docs/ForwardPlanStatusResponse.md)
 - [ForwardPlanSummaryResponse](docs/ForwardPlanSummaryResponse.md)
 - [GeographicalAreaResponse](docs/GeographicalAreaResponse.md)
 - [HAInspectionOutcomeStatusType](docs/HAInspectionOutcomeStatusType.md)
 - [HazardousMaterialType](docs/HazardousMaterialType.md)
 - [InspectionCategory](docs/InspectionCategory.md)
 - [InspectionCategoryResponse](docs/InspectionCategoryResponse.md)
 - [InspectionOutcome](docs/InspectionOutcome.md)
 - [InspectionOutcomeResponse](docs/InspectionOutcomeResponse.md)
 - [InspectionOutcomeStatusTypeResponse](docs/InspectionOutcomeStatusTypeResponse.md)
 - [InspectionReportingResponse](docs/InspectionReportingResponse.md)
 - [InspectionSortColumn](docs/InspectionSortColumn.md)
 - [InspectionStatusResponse](docs/InspectionStatusResponse.md)
 - [InspectionSummaryResponse](docs/InspectionSummaryResponse.md)
 - [InspectionType](docs/InspectionType.md)
 - [InspectionTypeResponse](docs/InspectionTypeResponse.md)
 - [LaneRentalAssessmentOutcome](docs/LaneRentalAssessmentOutcome.md)
 - [LaneRentalAssessmentOutcomeResponse](docs/LaneRentalAssessmentOutcomeResponse.md)
 - [MaterialClassificationClassification](docs/MaterialClassificationClassification.md)
 - [MaterialClassificationReportingResponse](docs/MaterialClassificationReportingResponse.md)
 - [MaterialClassificationSummaryResponse](docs/MaterialClassificationSummaryResponse.md)
 - [NonComplianceReportingResponse](docs/NonComplianceReportingResponse.md)
 - [NonComplianceResponseStatus](docs/NonComplianceResponseStatus.md)
 - [NonComplianceResponseStatusResponse](docs/NonComplianceResponseStatusResponse.md)
 - [NonComplianceSortColumn](docs/NonComplianceSortColumn.md)
 - [NonComplianceStatus](docs/NonComplianceStatus.md)
 - [NonComplianceStatusResponse](docs/NonComplianceStatusResponse.md)
 - [NonComplianceSummaryResponse](docs/NonComplianceSummaryResponse.md)
 - [OffenceCode](docs/OffenceCode.md)
 - [OffenceCodeResponse](docs/OffenceCodeResponse.md)
 - [OverrunWarningReasonResponse](docs/OverrunWarningReasonResponse.md)
 - [PaginationResponse](docs/PaginationResponse.md)
 - [PbiSampleGenerationJobsReportingResponse](docs/PbiSampleGenerationJobsReportingResponse.md)
 - [PbiSampleGenerationJobsSummaryResponse](docs/PbiSampleGenerationJobsSummaryResponse.md)
 - [PbiSampleInspectionReportingResponse](docs/PbiSampleInspectionReportingResponse.md)
 - [PbiSampleInspectionSortColumn](docs/PbiSampleInspectionSortColumn.md)
 - [PbiSampleInspectionSummaryResponse](docs/PbiSampleInspectionSummaryResponse.md)
 - [PbiSampleInspectionTargetReportingResponse](docs/PbiSampleInspectionTargetReportingResponse.md)
 - [PbiSampleInspectionTargetSortColumn](docs/PbiSampleInspectionTargetSortColumn.md)
 - [PbiSampleInspectionTargetSummaryResponse](docs/PbiSampleInspectionTargetSummaryResponse.md)
 - [PermitCondition](docs/PermitCondition.md)
 - [PermitConditionTypeResponse](docs/PermitConditionTypeResponse.md)
 - [PermitDurationChallengeReportingResponse](docs/PermitDurationChallengeReportingResponse.md)
 - [PermitDurationChallengeSortColumn](docs/PermitDurationChallengeSortColumn.md)
 - [PermitDurationChallengeSummaryResponse](docs/PermitDurationChallengeSummaryResponse.md)
 - [PermitReportingResponse](docs/PermitReportingResponse.md)
 - [PermitSortColumn](docs/PermitSortColumn.md)
 - [PermitStatus](docs/PermitStatus.md)
 - [PermitStatusResponse](docs/PermitStatusResponse.md)
 - [PermitSummaryResponse](docs/PermitSummaryResponse.md)
 - [PrivateStreetNoticeSortColumn](docs/PrivateStreetNoticeSortColumn.md)
 - [PrivateStreetReportingResponse](docs/PrivateStreetReportingResponse.md)
 - [PrivateStreetStatus](docs/PrivateStreetStatus.md)
 - [PrivateStreetStatusResponse](docs/PrivateStreetStatusResponse.md)
 - [PrivateStreetSummaryResponse](docs/PrivateStreetSummaryResponse.md)
 - [PromoterInspectionOutcomeStatusType](docs/PromoterInspectionOutcomeStatusType.md)
 - [ReinspectionReportingResponse](docs/ReinspectionReportingResponse.md)
 - [ReinspectionSortColumn](docs/ReinspectionSortColumn.md)
 - [ReinspectionSummaryResponse](docs/ReinspectionSummaryResponse.md)
 - [ReinstatementReportingResponse](docs/ReinstatementReportingResponse.md)
 - [ReinstatementSortColumn](docs/ReinstatementSortColumn.md)
 - [ReinstatementStatus](docs/ReinstatementStatus.md)
 - [ReinstatementStatusResponse](docs/ReinstatementStatusResponse.md)
 - [ReinstatementSummaryResponse](docs/ReinstatementSummaryResponse.md)
 - [ReinstatementTypeResponse](docs/ReinstatementTypeResponse.md)
 - [ReinstatementsDueReportingResponse](docs/ReinstatementsDueReportingResponse.md)
 - [ReinstatementsDueSummaryResponse](docs/ReinstatementsDueSummaryResponse.md)
 - [RoleResponse](docs/RoleResponse.md)
 - [Section58DurationResponse](docs/Section58DurationResponse.md)
 - [Section58ReportingResponse](docs/Section58ReportingResponse.md)
 - [Section58SortColumn](docs/Section58SortColumn.md)
 - [Section58Status](docs/Section58Status.md)
 - [Section58StatusResponse](docs/Section58StatusResponse.md)
 - [Section58SummaryResponse](docs/Section58SummaryResponse.md)
 - [Section74HAStatus](docs/Section74HAStatus.md)
 - [Section74HAStatusResponse](docs/Section74HAStatusResponse.md)
 - [Section74PromoterStatusResponse](docs/Section74PromoterStatusResponse.md)
 - [Section74ReportingResponse](docs/Section74ReportingResponse.md)
 - [Section74SortColumn](docs/Section74SortColumn.md)
 - [Section74SummaryResponse](docs/Section74SummaryResponse.md)
 - [Section81ReportingResponse](docs/Section81ReportingResponse.md)
 - [Section81Severity](docs/Section81Severity.md)
 - [Section81SeverityResponse](docs/Section81SeverityResponse.md)
 - [Section81SortColumn](docs/Section81SortColumn.md)
 - [Section81Status](docs/Section81Status.md)
 - [Section81StatusResponse](docs/Section81StatusResponse.md)
 - [Section81SummaryResponse](docs/Section81SummaryResponse.md)
 - [Section81Type](docs/Section81Type.md)
 - [Section81TypeResponse](docs/Section81TypeResponse.md)
 - [SortDirection](docs/SortDirection.md)
 - [TrafficManagementTypeResponse](docs/TrafficManagementTypeResponse.md)
 - [UserWorkstreamAccess](docs/UserWorkstreamAccess.md)
 - [UsersReportingResponse](docs/UsersReportingResponse.md)
 - [UsersSummaryResponse](docs/UsersSummaryResponse.md)
 - [WorkCategory](docs/WorkCategory.md)
 - [WorkCategoryResponse](docs/WorkCategoryResponse.md)
 - [WorkSearchReportingResponse](docs/WorkSearchReportingResponse.md)
 - [WorkSearchResponse](docs/WorkSearchResponse.md)
 - [WorkStatus](docs/WorkStatus.md)
 - [WorkStatusResponse](docs/WorkStatusResponse.md)
 - [WorkstreamAccessLevelResponse](docs/WorkstreamAccessLevelResponse.md)
 - [WorkstreamReportingResponse](docs/WorkstreamReportingResponse.md)
 - [WorkstreamStatus](docs/WorkstreamStatus.md)
 - [WorkstreamStatusResponse](docs/WorkstreamStatusResponse.md)
 - [WorkstreamSummaryResponse](docs/WorkstreamSummaryResponse.md)

## Documentation For Authorization


## token

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header


## Author


