# coding: utf-8

"""
    Street Manager Reporting API

    See API specification Resource Guide > Reporting API for more information on paging and endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ..api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_activities(self, **kwargs):  # noqa: E501
        """get_activities  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Activities for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ha_organisation_name:
        :param list[ActivityActivityType] activity_activity_type:
        :param float offset:
        :param str query:
        :param ActivitySortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param bool include_total_count:
        :return: ActivityReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_activities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_activities_with_http_info(self, **kwargs):  # noqa: E501
        """get_activities  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Activities for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ha_organisation_name:
        :param list[ActivityActivityType] activity_activity_type:
        :param float offset:
        :param str query:
        :param ActivitySortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param bool include_total_count:
        :return: ActivityReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ha_organisation_name', 'activity_activity_type', 'offset', 'query', 'sort_column', 'sort_direction', 'geographical_area_reference_number', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ha_organisation_name' in params:
            query_params.append(('ha_organisation_name', params['ha_organisation_name']))  # noqa: E501
        if 'activity_activity_type' in params:
            query_params.append(('activity_activity_type', params['activity_activity_type']))  # noqa: E501
            collection_formats['activity_activity_type'] = 'multi'  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/activities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alteration_duration_challenges(self, **kwargs):  # noqa: E501
        """get_alteration_duration_challenges  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Permit Alteration Duration Challenges for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alteration_duration_challenges(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param AlterationDurationChallengeSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param str organisation:
        :param list[str] geographical_area_reference_number:
        :param list[DurationChallengeReviewStatus] duration_challenge_review_status:
        :param list[DurationChallengeNonAcceptanceResponseStatus] duration_challenge_non_acceptance_response_status:
        :param list[WorkStatus] work_status:
        :param str street_descriptor:
        :param str usrn:
        :param str permit_alteration_reference_number:
        :param bool include_total_count:
        :return: AlterationDurationChallengeReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alteration_duration_challenges_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_alteration_duration_challenges_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_alteration_duration_challenges_with_http_info(self, **kwargs):  # noqa: E501
        """get_alteration_duration_challenges  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Permit Alteration Duration Challenges for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alteration_duration_challenges_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param AlterationDurationChallengeSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param str organisation:
        :param list[str] geographical_area_reference_number:
        :param list[DurationChallengeReviewStatus] duration_challenge_review_status:
        :param list[DurationChallengeNonAcceptanceResponseStatus] duration_challenge_non_acceptance_response_status:
        :param list[WorkStatus] work_status:
        :param str street_descriptor:
        :param str usrn:
        :param str permit_alteration_reference_number:
        :param bool include_total_count:
        :return: AlterationDurationChallengeReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'sort_column', 'sort_direction', 'swa_code', 'organisation', 'geographical_area_reference_number', 'duration_challenge_review_status', 'duration_challenge_non_acceptance_response_status', 'work_status', 'street_descriptor', 'usrn', 'permit_alteration_reference_number', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alteration_duration_challenges" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'duration_challenge_review_status' in params:
            query_params.append(('duration_challenge_review_status', params['duration_challenge_review_status']))  # noqa: E501
            collection_formats['duration_challenge_review_status'] = 'multi'  # noqa: E501
        if 'duration_challenge_non_acceptance_response_status' in params:
            query_params.append(('duration_challenge_non_acceptance_response_status', params['duration_challenge_non_acceptance_response_status']))  # noqa: E501
            collection_formats['duration_challenge_non_acceptance_response_status'] = 'multi'  # noqa: E501
        if 'work_status' in params:
            query_params.append(('work_status', params['work_status']))  # noqa: E501
            collection_formats['work_status'] = 'multi'  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'permit_alteration_reference_number' in params:
            query_params.append(('permit_alteration_reference_number', params['permit_alteration_reference_number']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/alterations/duration-challenges', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlterationDurationChallengeReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alterations(self, **kwargs):  # noqa: E501
        """get_alterations  # noqa: E501

        Returns all alterations associated with the logged in user's organisation. Optional date range filter for date_created Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alterations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[AlterationStatus] alteration_status:
        :param list[AlterationType] alteration_type:
        :param list[WorkStatus] work_status:
        :param list[WorkCategory] work_category:
        :param list[LaneRentalAssessmentOutcome] lane_rental_assessment_outcome:
        :param datetime start_date_created:
        :param datetime end_date_created:
        :param float offset:
        :param AlterationSortColumn sort_column:
        :param SortDirection sort_direction:
        :param bool is_traffic_sensitive:
        :param bool is_high_impact_traffic_management:
        :param bool is_duration_extension:
        :param bool is_early_start:
        :param bool is_deemed:
        :param bool lane_rental_charges_not_agreed:
        :param bool lane_rental_charges_potentially_apply:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param datetime status_update_date_from:
        :param datetime status_update_date_to:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str permit_alteration_reference_number:
        :param bool include_total_count:
        :return: AlterationReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alterations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_alterations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_alterations_with_http_info(self, **kwargs):  # noqa: E501
        """get_alterations  # noqa: E501

        Returns all alterations associated with the logged in user's organisation. Optional date range filter for date_created Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alterations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[AlterationStatus] alteration_status:
        :param list[AlterationType] alteration_type:
        :param list[WorkStatus] work_status:
        :param list[WorkCategory] work_category:
        :param list[LaneRentalAssessmentOutcome] lane_rental_assessment_outcome:
        :param datetime start_date_created:
        :param datetime end_date_created:
        :param float offset:
        :param AlterationSortColumn sort_column:
        :param SortDirection sort_direction:
        :param bool is_traffic_sensitive:
        :param bool is_high_impact_traffic_management:
        :param bool is_duration_extension:
        :param bool is_early_start:
        :param bool is_deemed:
        :param bool lane_rental_charges_not_agreed:
        :param bool lane_rental_charges_potentially_apply:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param datetime status_update_date_from:
        :param datetime status_update_date_to:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str permit_alteration_reference_number:
        :param bool include_total_count:
        :return: AlterationReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alteration_status', 'alteration_type', 'work_status', 'work_category', 'lane_rental_assessment_outcome', 'start_date_created', 'end_date_created', 'offset', 'sort_column', 'sort_direction', 'is_traffic_sensitive', 'is_high_impact_traffic_management', 'is_duration_extension', 'is_early_start', 'is_deemed', 'lane_rental_charges_not_agreed', 'lane_rental_charges_potentially_apply', 'swa_code', 'geographical_area_reference_number', 'status_update_date_from', 'status_update_date_to', 'organisation', 'street_descriptor', 'usrn', 'permit_alteration_reference_number', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alterations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'alteration_status' in params:
            query_params.append(('alteration_status', params['alteration_status']))  # noqa: E501
            collection_formats['alteration_status'] = 'multi'  # noqa: E501
        if 'alteration_type' in params:
            query_params.append(('alteration_type', params['alteration_type']))  # noqa: E501
            collection_formats['alteration_type'] = 'multi'  # noqa: E501
        if 'work_status' in params:
            query_params.append(('work_status', params['work_status']))  # noqa: E501
            collection_formats['work_status'] = 'multi'  # noqa: E501
        if 'work_category' in params:
            query_params.append(('work_category', params['work_category']))  # noqa: E501
            collection_formats['work_category'] = 'multi'  # noqa: E501
        if 'lane_rental_assessment_outcome' in params:
            query_params.append(('lane_rental_assessment_outcome', params['lane_rental_assessment_outcome']))  # noqa: E501
            collection_formats['lane_rental_assessment_outcome'] = 'multi'  # noqa: E501
        if 'start_date_created' in params:
            query_params.append(('start_date_created', params['start_date_created']))  # noqa: E501
        if 'end_date_created' in params:
            query_params.append(('end_date_created', params['end_date_created']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'is_traffic_sensitive' in params:
            query_params.append(('is_traffic_sensitive', params['is_traffic_sensitive']))  # noqa: E501
        if 'is_high_impact_traffic_management' in params:
            query_params.append(('is_high_impact_traffic_management', params['is_high_impact_traffic_management']))  # noqa: E501
        if 'is_duration_extension' in params:
            query_params.append(('is_duration_extension', params['is_duration_extension']))  # noqa: E501
        if 'is_early_start' in params:
            query_params.append(('is_early_start', params['is_early_start']))  # noqa: E501
        if 'is_deemed' in params:
            query_params.append(('is_deemed', params['is_deemed']))  # noqa: E501
        if 'lane_rental_charges_not_agreed' in params:
            query_params.append(('lane_rental_charges_not_agreed', params['lane_rental_charges_not_agreed']))  # noqa: E501
        if 'lane_rental_charges_potentially_apply' in params:
            query_params.append(('lane_rental_charges_potentially_apply', params['lane_rental_charges_potentially_apply']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'status_update_date_from' in params:
            query_params.append(('status_update_date_from', params['status_update_date_from']))  # noqa: E501
        if 'status_update_date_to' in params:
            query_params.append(('status_update_date_to', params['status_update_date_to']))  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'permit_alteration_reference_number' in params:
            query_params.append(('permit_alteration_reference_number', params['permit_alteration_reference_number']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/alterations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlterationReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_comments(self, **kwargs):  # noqa: E501
        """get_comments  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_comments(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param datetime date_created_from:
        :param datetime date_created_to:
        :param list[CommentTopic] topic:
        :param bool is_internal:
        :param bool is_read:
        :param bool is_not_read:
        :param str work_reference_number:
        :param str author_email_address:
        :param bool is_incoming:
        :param bool is_outgoing:
        :param bool include_total_count:
        :return: CommentReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_comments_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_comments_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_comments_with_http_info(self, **kwargs):  # noqa: E501
        """get_comments  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_comments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param datetime date_created_from:
        :param datetime date_created_to:
        :param list[CommentTopic] topic:
        :param bool is_internal:
        :param bool is_read:
        :param bool is_not_read:
        :param str work_reference_number:
        :param str author_email_address:
        :param bool is_incoming:
        :param bool is_outgoing:
        :param bool include_total_count:
        :return: CommentReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'swa_code', 'geographical_area_reference_number', 'date_created_from', 'date_created_to', 'topic', 'is_internal', 'is_read', 'is_not_read', 'work_reference_number', 'author_email_address', 'is_incoming', 'is_outgoing', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_comments" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'date_created_from' in params:
            query_params.append(('date_created_from', params['date_created_from']))  # noqa: E501
        if 'date_created_to' in params:
            query_params.append(('date_created_to', params['date_created_to']))  # noqa: E501
        if 'topic' in params:
            query_params.append(('topic', params['topic']))  # noqa: E501
            collection_formats['topic'] = 'multi'  # noqa: E501
        if 'is_internal' in params:
            query_params.append(('is_internal', params['is_internal']))  # noqa: E501
        if 'is_read' in params:
            query_params.append(('is_read', params['is_read']))  # noqa: E501
        if 'is_not_read' in params:
            query_params.append(('is_not_read', params['is_not_read']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'author_email_address' in params:
            query_params.append(('author_email_address', params['author_email_address']))  # noqa: E501
        if 'is_incoming' in params:
            query_params.append(('is_incoming', params['is_incoming']))  # noqa: E501
        if 'is_outgoing' in params:
            query_params.append(('is_outgoing', params['is_outgoing']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommentReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_csv_exports(self, **kwargs):  # noqa: E501
        """get_csv_exports  # noqa: E501

        See API specification Resource Guide > Reporting API > Get CSV Exports for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_csv_exports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param str swa_code:
        :param bool include_total_count:
        :return: CSVExportReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_csv_exports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_csv_exports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_csv_exports_with_http_info(self, **kwargs):  # noqa: E501
        """get_csv_exports  # noqa: E501

        See API specification Resource Guide > Reporting API > Get CSV Exports for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority, Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_csv_exports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param str swa_code:
        :param bool include_total_count:
        :return: CSVExportReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'swa_code', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_csv_exports" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/csv-exports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CSVExportReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_expiring_interim_reinstatements(self, **kwargs):  # noqa: E501
        """get_expiring_interim_reinstatements  # noqa: E501

        Returns expiring interim associated with the logged in user's organisation. Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expiring_interim_reinstatements(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReinstatementSortColumn sort_column:
        :param SortDirection sort_direction:
        :param float offset:
        :param str swa_code:
        :param datetime registration_date_from:
        :param datetime registration_date_to:
        :param datetime end_date_from:
        :param datetime end_date_to:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param str work_reference_number_exact:
        :param bool include_total_count:
        :return: ReinstatementReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_expiring_interim_reinstatements_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_expiring_interim_reinstatements_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_expiring_interim_reinstatements_with_http_info(self, **kwargs):  # noqa: E501
        """get_expiring_interim_reinstatements  # noqa: E501

        Returns expiring interim associated with the logged in user's organisation. Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expiring_interim_reinstatements_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReinstatementSortColumn sort_column:
        :param SortDirection sort_direction:
        :param float offset:
        :param str swa_code:
        :param datetime registration_date_from:
        :param datetime registration_date_to:
        :param datetime end_date_from:
        :param datetime end_date_to:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param str work_reference_number_exact:
        :param bool include_total_count:
        :return: ReinstatementReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort_column', 'sort_direction', 'offset', 'swa_code', 'registration_date_from', 'registration_date_to', 'end_date_from', 'end_date_to', 'geographical_area_reference_number', 'organisation', 'street_descriptor', 'usrn', 'work_reference_number', 'work_reference_number_exact', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_expiring_interim_reinstatements" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'registration_date_from' in params:
            query_params.append(('registration_date_from', params['registration_date_from']))  # noqa: E501
        if 'registration_date_to' in params:
            query_params.append(('registration_date_to', params['registration_date_to']))  # noqa: E501
        if 'end_date_from' in params:
            query_params.append(('end_date_from', params['end_date_from']))  # noqa: E501
        if 'end_date_to' in params:
            query_params.append(('end_date_to', params['end_date_to']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'work_reference_number_exact' in params:
            query_params.append(('work_reference_number_exact', params['work_reference_number_exact']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/reinstatements/expiring-interims', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReinstatementReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_forward_plans(self, **kwargs):  # noqa: E501
        """get_forward_plans  # noqa: E501

        See API specification Resource Guide > Reporting API > Get ForwardPlans for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_forward_plans(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ForwardPlanStatus] forward_plan_status:
        :param datetime proposed_start_date:
        :param datetime proposed_end_date:
        :param datetime work_start_date_from:
        :param datetime work_start_date_to:
        :param datetime work_end_date_from:
        :param datetime work_end_date_to:
        :param float offset:
        :param ForwardPlanSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str forward_plan_reference_number:
        :param bool include_total_count:
        :return: ForwardPlanReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_forward_plans_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_forward_plans_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_forward_plans_with_http_info(self, **kwargs):  # noqa: E501
        """get_forward_plans  # noqa: E501

        See API specification Resource Guide > Reporting API > Get ForwardPlans for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_forward_plans_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ForwardPlanStatus] forward_plan_status:
        :param datetime proposed_start_date:
        :param datetime proposed_end_date:
        :param datetime work_start_date_from:
        :param datetime work_start_date_to:
        :param datetime work_end_date_from:
        :param datetime work_end_date_to:
        :param float offset:
        :param ForwardPlanSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str forward_plan_reference_number:
        :param bool include_total_count:
        :return: ForwardPlanReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['forward_plan_status', 'proposed_start_date', 'proposed_end_date', 'work_start_date_from', 'work_start_date_to', 'work_end_date_from', 'work_end_date_to', 'offset', 'sort_column', 'sort_direction', 'swa_code', 'geographical_area_reference_number', 'organisation', 'street_descriptor', 'usrn', 'forward_plan_reference_number', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_forward_plans" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'forward_plan_status' in params:
            query_params.append(('forward_plan_status', params['forward_plan_status']))  # noqa: E501
            collection_formats['forward_plan_status'] = 'multi'  # noqa: E501
        if 'proposed_start_date' in params:
            query_params.append(('proposed_start_date', params['proposed_start_date']))  # noqa: E501
        if 'proposed_end_date' in params:
            query_params.append(('proposed_end_date', params['proposed_end_date']))  # noqa: E501
        if 'work_start_date_from' in params:
            query_params.append(('work_start_date_from', params['work_start_date_from']))  # noqa: E501
        if 'work_start_date_to' in params:
            query_params.append(('work_start_date_to', params['work_start_date_to']))  # noqa: E501
        if 'work_end_date_from' in params:
            query_params.append(('work_end_date_from', params['work_end_date_from']))  # noqa: E501
        if 'work_end_date_to' in params:
            query_params.append(('work_end_date_to', params['work_end_date_to']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'forward_plan_reference_number' in params:
            query_params.append(('forward_plan_reference_number', params['forward_plan_reference_number']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/forward-plans', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ForwardPlanReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fpn_files(self, fpn_reference_number, **kwargs):  # noqa: E501
        """get_fpn_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fpn_files(fpn_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fpn_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_fpn_files_with_http_info(fpn_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_fpn_files_with_http_info(fpn_reference_number, **kwargs)  # noqa: E501
            return data

    def get_fpn_files_with_http_info(self, fpn_reference_number, **kwargs):  # noqa: E501
        """get_fpn_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fpn_files_with_http_info(fpn_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fpn_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fpn_reference_number', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fpn_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'fpn_reference_number' is set
        if ('fpn_reference_number' not in params or
                params['fpn_reference_number'] is None):
            raise ValueError("Missing the required parameter `fpn_reference_number` when calling `get_fpn_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fpn_reference_number' in params:
            query_params.append(('fpn_reference_number', params['fpn_reference_number']))  # noqa: E501
        if 'file_type' in params:
            query_params.append(('file_type', params['file_type']))  # noqa: E501
            collection_formats['file_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/fixed-penalty-notices/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fpns(self, **kwargs):  # noqa: E501
        """get_fpns  # noqa: E501

        See API specification Resource Guide > Reporting API > Get FPNs for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fpns(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FPNStatus] status:
        :param datetime start_date:
        :param datetime end_date:
        :param float offset:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param list[OffenceCode] offence_code:
        :param datetime status_changed_date_from:
        :param datetime status_changed_date_to:
        :param FPNSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param bool include_total_count:
        :return: FPNReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_fpns_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_fpns_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_fpns_with_http_info(self, **kwargs):  # noqa: E501
        """get_fpns  # noqa: E501

        See API specification Resource Guide > Reporting API > Get FPNs for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fpns_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FPNStatus] status:
        :param datetime start_date:
        :param datetime end_date:
        :param float offset:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param list[OffenceCode] offence_code:
        :param datetime status_changed_date_from:
        :param datetime status_changed_date_to:
        :param FPNSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param bool include_total_count:
        :return: FPNReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status', 'start_date', 'end_date', 'offset', 'swa_code', 'geographical_area_reference_number', 'offence_code', 'status_changed_date_from', 'status_changed_date_to', 'sort_column', 'sort_direction', 'organisation', 'street_descriptor', 'usrn', 'work_reference_number', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fpns" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
            collection_formats['status'] = 'multi'  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'offence_code' in params:
            query_params.append(('offence_code', params['offence_code']))  # noqa: E501
            collection_formats['offence_code'] = 'multi'  # noqa: E501
        if 'status_changed_date_from' in params:
            query_params.append(('status_changed_date_from', params['status_changed_date_from']))  # noqa: E501
        if 'status_changed_date_to' in params:
            query_params.append(('status_changed_date_to', params['status_changed_date_to']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/fixed-penalty-notices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FPNReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_geographical_areas(self, **kwargs):  # noqa: E501
        """get_geographical_areas  # noqa: E501

        Returns all geographic areas associated with the logged in user's organisation Authenticated user must have one of the following roles: Admin, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_geographical_areas(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GeographicalAreaResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_geographical_areas_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_geographical_areas_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_geographical_areas_with_http_info(self, **kwargs):  # noqa: E501
        """get_geographical_areas  # noqa: E501

        Returns all geographic areas associated with the logged in user's organisation Authenticated user must have one of the following roles: Admin, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_geographical_areas_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GeographicalAreaResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_geographical_areas" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/geographical-areas', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GeographicalAreaResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inspection_files(self, inspection_reference_number, **kwargs):  # noqa: E501
        """get_inspection_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inspection_files(inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str inspection_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_inspection_files_with_http_info(inspection_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_inspection_files_with_http_info(inspection_reference_number, **kwargs)  # noqa: E501
            return data

    def get_inspection_files_with_http_info(self, inspection_reference_number, **kwargs):  # noqa: E501
        """get_inspection_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inspection_files_with_http_info(inspection_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str inspection_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inspection_reference_number', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inspection_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'inspection_reference_number' is set
        if ('inspection_reference_number' not in params or
                params['inspection_reference_number'] is None):
            raise ValueError("Missing the required parameter `inspection_reference_number` when calling `get_inspection_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'inspection_reference_number' in params:
            query_params.append(('inspection_reference_number', params['inspection_reference_number']))  # noqa: E501
        if 'file_type' in params:
            query_params.append(('file_type', params['file_type']))  # noqa: E501
            collection_formats['file_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/inspections/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inspections(self, **kwargs):  # noqa: E501
        """get_inspections  # noqa: E501

        See API specification Resource Guide > Reporting API > Get inspections for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inspections(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date:
        :param datetime end_date:
        :param list[InspectionType] inspection_type:
        :param list[InspectionOutcome] inspection_outcome:
        :param datetime start_date_created:
        :param datetime end_date_created:
        :param float offset:
        :param InspectionSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param list[InspectionCategory] inspection_category:
        :param list[PromoterInspectionOutcomeStatusType] promoter_outcome_status:
        :param list[HAInspectionOutcomeStatusType] ha_outcome_status:
        :param bool is_auto_accepted:
        :param bool include_total_count:
        :return: InspectionReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_inspections_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_inspections_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_inspections_with_http_info(self, **kwargs):  # noqa: E501
        """get_inspections  # noqa: E501

        See API specification Resource Guide > Reporting API > Get inspections for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inspections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date:
        :param datetime end_date:
        :param list[InspectionType] inspection_type:
        :param list[InspectionOutcome] inspection_outcome:
        :param datetime start_date_created:
        :param datetime end_date_created:
        :param float offset:
        :param InspectionSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param list[InspectionCategory] inspection_category:
        :param list[PromoterInspectionOutcomeStatusType] promoter_outcome_status:
        :param list[HAInspectionOutcomeStatusType] ha_outcome_status:
        :param bool is_auto_accepted:
        :param bool include_total_count:
        :return: InspectionReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_date', 'end_date', 'inspection_type', 'inspection_outcome', 'start_date_created', 'end_date_created', 'offset', 'sort_column', 'sort_direction', 'swa_code', 'geographical_area_reference_number', 'organisation', 'street_descriptor', 'usrn', 'work_reference_number', 'inspection_category', 'promoter_outcome_status', 'ha_outcome_status', 'is_auto_accepted', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inspections" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'inspection_type' in params:
            query_params.append(('inspection_type', params['inspection_type']))  # noqa: E501
            collection_formats['inspection_type'] = 'multi'  # noqa: E501
        if 'inspection_outcome' in params:
            query_params.append(('inspection_outcome', params['inspection_outcome']))  # noqa: E501
            collection_formats['inspection_outcome'] = 'multi'  # noqa: E501
        if 'start_date_created' in params:
            query_params.append(('start_date_created', params['start_date_created']))  # noqa: E501
        if 'end_date_created' in params:
            query_params.append(('end_date_created', params['end_date_created']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'inspection_category' in params:
            query_params.append(('inspection_category', params['inspection_category']))  # noqa: E501
            collection_formats['inspection_category'] = 'multi'  # noqa: E501
        if 'promoter_outcome_status' in params:
            query_params.append(('promoter_outcome_status', params['promoter_outcome_status']))  # noqa: E501
            collection_formats['promoter_outcome_status'] = 'multi'  # noqa: E501
        if 'ha_outcome_status' in params:
            query_params.append(('ha_outcome_status', params['ha_outcome_status']))  # noqa: E501
            collection_formats['ha_outcome_status'] = 'multi'  # noqa: E501
        if 'is_auto_accepted' in params:
            query_params.append(('is_auto_accepted', params['is_auto_accepted']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/inspections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InspectionReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_interested_party_permits(self, **kwargs):  # noqa: E501
        """get_interested_party_permits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_interested_party_permits(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param PermitSortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param str street_descriptor:
        :param str permit_reference_number:
        :param str work_reference_number:
        :param datetime work_start_date_from:
        :param datetime work_start_date_to:
        :param datetime work_end_date_from:
        :param datetime work_end_date_to:
        :param datetime start_date_created:
        :param datetime end_date_created:
        :param list[WorkStatus] work_status:
        :param list[WorkCategory] work_category:
        :param bool is_high_impact_traffic_management:
        :param str usrn:
        :param str promoter_organisation_name:
        :param str ha_organisation_name:
        :param bool include_total_count:
        :return: PermitReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_interested_party_permits_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_interested_party_permits_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_interested_party_permits_with_http_info(self, **kwargs):  # noqa: E501
        """get_interested_party_permits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_interested_party_permits_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param PermitSortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param str street_descriptor:
        :param str permit_reference_number:
        :param str work_reference_number:
        :param datetime work_start_date_from:
        :param datetime work_start_date_to:
        :param datetime work_end_date_from:
        :param datetime work_end_date_to:
        :param datetime start_date_created:
        :param datetime end_date_created:
        :param list[WorkStatus] work_status:
        :param list[WorkCategory] work_category:
        :param bool is_high_impact_traffic_management:
        :param str usrn:
        :param str promoter_organisation_name:
        :param str ha_organisation_name:
        :param bool include_total_count:
        :return: PermitReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'sort_column', 'sort_direction', 'geographical_area_reference_number', 'street_descriptor', 'permit_reference_number', 'work_reference_number', 'work_start_date_from', 'work_start_date_to', 'work_end_date_from', 'work_end_date_to', 'start_date_created', 'end_date_created', 'work_status', 'work_category', 'is_high_impact_traffic_management', 'usrn', 'promoter_organisation_name', 'ha_organisation_name', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_interested_party_permits" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'permit_reference_number' in params:
            query_params.append(('permit_reference_number', params['permit_reference_number']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'work_start_date_from' in params:
            query_params.append(('work_start_date_from', params['work_start_date_from']))  # noqa: E501
        if 'work_start_date_to' in params:
            query_params.append(('work_start_date_to', params['work_start_date_to']))  # noqa: E501
        if 'work_end_date_from' in params:
            query_params.append(('work_end_date_from', params['work_end_date_from']))  # noqa: E501
        if 'work_end_date_to' in params:
            query_params.append(('work_end_date_to', params['work_end_date_to']))  # noqa: E501
        if 'start_date_created' in params:
            query_params.append(('start_date_created', params['start_date_created']))  # noqa: E501
        if 'end_date_created' in params:
            query_params.append(('end_date_created', params['end_date_created']))  # noqa: E501
        if 'work_status' in params:
            query_params.append(('work_status', params['work_status']))  # noqa: E501
            collection_formats['work_status'] = 'multi'  # noqa: E501
        if 'work_category' in params:
            query_params.append(('work_category', params['work_category']))  # noqa: E501
            collection_formats['work_category'] = 'multi'  # noqa: E501
        if 'is_high_impact_traffic_management' in params:
            query_params.append(('is_high_impact_traffic_management', params['is_high_impact_traffic_management']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'promoter_organisation_name' in params:
            query_params.append(('promoter_organisation_name', params['promoter_organisation_name']))  # noqa: E501
        if 'ha_organisation_name' in params:
            query_params.append(('ha_organisation_name', params['ha_organisation_name']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/interested-party-permits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermitReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_material_classifications(self, **kwargs):  # noqa: E501
        """get_material_classifications  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Material Classifications for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_material_classifications(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str street_descriptor:
        :param str usrn:
        :param float offset:
        :param SortDirection sort_direction:
        :param str material_classification_reference_number:
        :param MaterialClassificationClassification material_classification_classification:
        :param datetime date_sample_taken_from:
        :param datetime date_sample_taken_to:
        :param datetime date_created_from:
        :param datetime date_created_to:
        :param bool include_total_count:
        :return: MaterialClassificationReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_material_classifications_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_material_classifications_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_material_classifications_with_http_info(self, **kwargs):  # noqa: E501
        """get_material_classifications  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Material Classifications for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_material_classifications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str street_descriptor:
        :param str usrn:
        :param float offset:
        :param SortDirection sort_direction:
        :param str material_classification_reference_number:
        :param MaterialClassificationClassification material_classification_classification:
        :param datetime date_sample_taken_from:
        :param datetime date_sample_taken_to:
        :param datetime date_created_from:
        :param datetime date_created_to:
        :param bool include_total_count:
        :return: MaterialClassificationReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['street_descriptor', 'usrn', 'offset', 'sort_direction', 'material_classification_reference_number', 'material_classification_classification', 'date_sample_taken_from', 'date_sample_taken_to', 'date_created_from', 'date_created_to', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_material_classifications" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'material_classification_reference_number' in params:
            query_params.append(('material_classification_reference_number', params['material_classification_reference_number']))  # noqa: E501
        if 'material_classification_classification' in params:
            query_params.append(('material_classification_classification', params['material_classification_classification']))  # noqa: E501
        if 'date_sample_taken_from' in params:
            query_params.append(('date_sample_taken_from', params['date_sample_taken_from']))  # noqa: E501
        if 'date_sample_taken_to' in params:
            query_params.append(('date_sample_taken_to', params['date_sample_taken_to']))  # noqa: E501
        if 'date_created_from' in params:
            query_params.append(('date_created_from', params['date_created_from']))  # noqa: E501
        if 'date_created_to' in params:
            query_params.append(('date_created_to', params['date_created_to']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/material-classifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MaterialClassificationReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_non_compliances(self, **kwargs):  # noqa: E501
        """get_non_compliances  # noqa: E501

        See API specification Resource Guide > Reporting API > Get non compliances for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_non_compliances(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime non_compliance_date_created_from:
        :param datetime non_compliance_date_created_to:
        :param str non_compliance_reference_number:
        :param list[NonComplianceStatus] non_compliance_status:
        :param list[NonComplianceResponseStatus] ha_response_status:
        :param list[NonComplianceResponseStatus] promoter_response_status:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param float offset:
        :param NonComplianceSortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[InspectionType] most_recent_inspection_type:
        :param list[InspectionOutcome] most_recent_inspection_outcome:
        :param list[PromoterInspectionOutcomeStatusType] most_recent_inspection_promoter_response_status:
        :param list[HAInspectionOutcomeStatusType] most_recent_inspection_ha_response_status:
        :param bool include_total_count:
        :return: NonComplianceReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_non_compliances_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_non_compliances_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_non_compliances_with_http_info(self, **kwargs):  # noqa: E501
        """get_non_compliances  # noqa: E501

        See API specification Resource Guide > Reporting API > Get non compliances for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_non_compliances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime non_compliance_date_created_from:
        :param datetime non_compliance_date_created_to:
        :param str non_compliance_reference_number:
        :param list[NonComplianceStatus] non_compliance_status:
        :param list[NonComplianceResponseStatus] ha_response_status:
        :param list[NonComplianceResponseStatus] promoter_response_status:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param float offset:
        :param NonComplianceSortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[InspectionType] most_recent_inspection_type:
        :param list[InspectionOutcome] most_recent_inspection_outcome:
        :param list[PromoterInspectionOutcomeStatusType] most_recent_inspection_promoter_response_status:
        :param list[HAInspectionOutcomeStatusType] most_recent_inspection_ha_response_status:
        :param bool include_total_count:
        :return: NonComplianceReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['non_compliance_date_created_from', 'non_compliance_date_created_to', 'non_compliance_reference_number', 'non_compliance_status', 'ha_response_status', 'promoter_response_status', 'swa_code', 'geographical_area_reference_number', 'organisation', 'street_descriptor', 'usrn', 'offset', 'sort_column', 'sort_direction', 'most_recent_inspection_type', 'most_recent_inspection_outcome', 'most_recent_inspection_promoter_response_status', 'most_recent_inspection_ha_response_status', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_non_compliances" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'non_compliance_date_created_from' in params:
            query_params.append(('non_compliance_date_created_from', params['non_compliance_date_created_from']))  # noqa: E501
        if 'non_compliance_date_created_to' in params:
            query_params.append(('non_compliance_date_created_to', params['non_compliance_date_created_to']))  # noqa: E501
        if 'non_compliance_reference_number' in params:
            query_params.append(('non_compliance_reference_number', params['non_compliance_reference_number']))  # noqa: E501
        if 'non_compliance_status' in params:
            query_params.append(('non_compliance_status', params['non_compliance_status']))  # noqa: E501
            collection_formats['non_compliance_status'] = 'multi'  # noqa: E501
        if 'ha_response_status' in params:
            query_params.append(('ha_response_status', params['ha_response_status']))  # noqa: E501
            collection_formats['ha_response_status'] = 'multi'  # noqa: E501
        if 'promoter_response_status' in params:
            query_params.append(('promoter_response_status', params['promoter_response_status']))  # noqa: E501
            collection_formats['promoter_response_status'] = 'multi'  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'most_recent_inspection_type' in params:
            query_params.append(('most_recent_inspection_type', params['most_recent_inspection_type']))  # noqa: E501
            collection_formats['most_recent_inspection_type'] = 'multi'  # noqa: E501
        if 'most_recent_inspection_outcome' in params:
            query_params.append(('most_recent_inspection_outcome', params['most_recent_inspection_outcome']))  # noqa: E501
            collection_formats['most_recent_inspection_outcome'] = 'multi'  # noqa: E501
        if 'most_recent_inspection_promoter_response_status' in params:
            query_params.append(('most_recent_inspection_promoter_response_status', params['most_recent_inspection_promoter_response_status']))  # noqa: E501
            collection_formats['most_recent_inspection_promoter_response_status'] = 'multi'  # noqa: E501
        if 'most_recent_inspection_ha_response_status' in params:
            query_params.append(('most_recent_inspection_ha_response_status', params['most_recent_inspection_ha_response_status']))  # noqa: E501
            collection_formats['most_recent_inspection_ha_response_status'] = 'multi'  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/non-compliances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NonComplianceReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pbi_sample_generation_jobs(self, **kwargs):  # noqa: E501
        """get_pbi_sample_generation_jobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pbi_sample_generation_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param bool include_total_count:
        :return: PbiSampleGenerationJobsReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pbi_sample_generation_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_pbi_sample_generation_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_pbi_sample_generation_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """get_pbi_sample_generation_jobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pbi_sample_generation_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param bool include_total_count:
        :return: PbiSampleGenerationJobsReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pbi_sample_generation_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/pbi-sample-generation-jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PbiSampleGenerationJobsReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pbi_sample_inspection_targets(self, **kwargs):  # noqa: E501
        """get_pbi_sample_inspection_targets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pbi_sample_inspection_targets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param datetime quarter_start_date:
        :param PbiSampleInspectionTargetSortColumn sort_column:
        :param SortDirection sort_direction:
        :param bool include_total_count:
        :return: PbiSampleInspectionTargetReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pbi_sample_inspection_targets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_pbi_sample_inspection_targets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_pbi_sample_inspection_targets_with_http_info(self, **kwargs):  # noqa: E501
        """get_pbi_sample_inspection_targets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pbi_sample_inspection_targets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param datetime quarter_start_date:
        :param PbiSampleInspectionTargetSortColumn sort_column:
        :param SortDirection sort_direction:
        :param bool include_total_count:
        :return: PbiSampleInspectionTargetReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'quarter_start_date', 'sort_column', 'sort_direction', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pbi_sample_inspection_targets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'quarter_start_date' in params:
            query_params.append(('quarter_start_date', params['quarter_start_date']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/pbi-sample-inspection-targets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PbiSampleInspectionTargetReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pbi_sample_inspections(self, **kwargs):  # noqa: E501
        """get_pbi_sample_inspections  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pbi_sample_inspections(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param SortDirection sort_direction:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param datetime sample_expiry_date_from:
        :param datetime sample_expiry_date_to:
        :param PbiSampleInspectionSortColumn sort_column:
        :param bool include_total_count:
        :return: PbiSampleInspectionReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pbi_sample_inspections_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_pbi_sample_inspections_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_pbi_sample_inspections_with_http_info(self, **kwargs):  # noqa: E501
        """get_pbi_sample_inspections  # noqa: E501

        Authenticated user must have one of the following roles: HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pbi_sample_inspections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param SortDirection sort_direction:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param datetime sample_expiry_date_from:
        :param datetime sample_expiry_date_to:
        :param PbiSampleInspectionSortColumn sort_column:
        :param bool include_total_count:
        :return: PbiSampleInspectionReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'swa_code', 'geographical_area_reference_number', 'sort_direction', 'organisation', 'street_descriptor', 'usrn', 'work_reference_number', 'sample_expiry_date_from', 'sample_expiry_date_to', 'sort_column', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pbi_sample_inspections" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'sample_expiry_date_from' in params:
            query_params.append(('sample_expiry_date_from', params['sample_expiry_date_from']))  # noqa: E501
        if 'sample_expiry_date_to' in params:
            query_params.append(('sample_expiry_date_to', params['sample_expiry_date_to']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/pbi-sample-inspections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PbiSampleInspectionReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_permit_duration_challenges(self, **kwargs):  # noqa: E501
        """get_permit_duration_challenges  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Permit Duration Challenges for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permit_duration_challenges(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param PermitDurationChallengeSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param str organisation:
        :param list[str] geographical_area_reference_number:
        :param list[DurationChallengeReviewStatus] duration_challenge_review_status:
        :param list[DurationChallengeNonAcceptanceResponseStatus] duration_challenge_non_acceptance_response_status:
        :param list[WorkStatus] work_status:
        :param str street_descriptor:
        :param str usrn:
        :param str permit_reference_number:
        :param bool include_total_count:
        :return: PermitDurationChallengeReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_permit_duration_challenges_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_permit_duration_challenges_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_permit_duration_challenges_with_http_info(self, **kwargs):  # noqa: E501
        """get_permit_duration_challenges  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Permit Duration Challenges for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permit_duration_challenges_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param PermitDurationChallengeSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param str organisation:
        :param list[str] geographical_area_reference_number:
        :param list[DurationChallengeReviewStatus] duration_challenge_review_status:
        :param list[DurationChallengeNonAcceptanceResponseStatus] duration_challenge_non_acceptance_response_status:
        :param list[WorkStatus] work_status:
        :param str street_descriptor:
        :param str usrn:
        :param str permit_reference_number:
        :param bool include_total_count:
        :return: PermitDurationChallengeReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'sort_column', 'sort_direction', 'swa_code', 'organisation', 'geographical_area_reference_number', 'duration_challenge_review_status', 'duration_challenge_non_acceptance_response_status', 'work_status', 'street_descriptor', 'usrn', 'permit_reference_number', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_permit_duration_challenges" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'duration_challenge_review_status' in params:
            query_params.append(('duration_challenge_review_status', params['duration_challenge_review_status']))  # noqa: E501
            collection_formats['duration_challenge_review_status'] = 'multi'  # noqa: E501
        if 'duration_challenge_non_acceptance_response_status' in params:
            query_params.append(('duration_challenge_non_acceptance_response_status', params['duration_challenge_non_acceptance_response_status']))  # noqa: E501
            collection_formats['duration_challenge_non_acceptance_response_status'] = 'multi'  # noqa: E501
        if 'work_status' in params:
            query_params.append(('work_status', params['work_status']))  # noqa: E501
            collection_formats['work_status'] = 'multi'  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'permit_reference_number' in params:
            query_params.append(('permit_reference_number', params['permit_reference_number']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/permits/duration-challenges', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermitDurationChallengeReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_permit_files(self, permit_reference_number, **kwargs):  # noqa: E501
        """get_permit_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permit_files(permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str permit_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_permit_files_with_http_info(permit_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_permit_files_with_http_info(permit_reference_number, **kwargs)  # noqa: E501
            return data

    def get_permit_files_with_http_info(self, permit_reference_number, **kwargs):  # noqa: E501
        """get_permit_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permit_files_with_http_info(permit_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str permit_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['permit_reference_number', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_permit_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'permit_reference_number' is set
        if ('permit_reference_number' not in params or
                params['permit_reference_number'] is None):
            raise ValueError("Missing the required parameter `permit_reference_number` when calling `get_permit_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'permit_reference_number' in params:
            query_params.append(('permit_reference_number', params['permit_reference_number']))  # noqa: E501
        if 'file_type' in params:
            query_params.append(('file_type', params['file_type']))  # noqa: E501
            collection_formats['file_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/permits/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_permits(self, **kwargs):  # noqa: E501
        """get_permits  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Permits for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permits(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[PermitStatus] status:
        :param list[WorkStatus] work_status:
        :param list[WorkCategory] work_category:
        :param list[LaneRentalAssessmentOutcome] lane_rental_assessment_outcome:
        :param bool active_permit_only:
        :param datetime start_date:
        :param datetime end_date:
        :param datetime work_start_date_from:
        :param datetime work_start_date_to:
        :param datetime work_end_date_from:
        :param datetime work_end_date_to:
        :param datetime start_date_created:
        :param datetime end_date_created:
        :param float offset:
        :param PermitSortColumn sort_column:
        :param SortDirection sort_direction:
        :param bool is_traffic_sensitive:
        :param bool is_high_impact_traffic_management:
        :param bool has_no_final_registration:
        :param bool has_excavation:
        :param bool is_early_start:
        :param bool is_deemed:
        :param bool lane_rental_charges_not_agreed:
        :param bool lane_rental_charges_potentially_apply:
        :param str swa_code:
        :param bool ever_modification_requested:
        :param bool hs2_works_only:
        :param bool consultation_works_only:
        :param bool consent_works_only:
        :param bool unacknowledged_by_ha_only:
        :param list[str] geographical_area_reference_number:
        :param bool is_duration_challenged:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str permit_reference_number:
        :param str work_reference_number:
        :param bool include_total_count:
        :param datetime reasonable_period_end_date_from:
        :param datetime reasonable_period_end_date_to:
        :return: PermitReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_permits_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_permits_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_permits_with_http_info(self, **kwargs):  # noqa: E501
        """get_permits  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Permits for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permits_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[PermitStatus] status:
        :param list[WorkStatus] work_status:
        :param list[WorkCategory] work_category:
        :param list[LaneRentalAssessmentOutcome] lane_rental_assessment_outcome:
        :param bool active_permit_only:
        :param datetime start_date:
        :param datetime end_date:
        :param datetime work_start_date_from:
        :param datetime work_start_date_to:
        :param datetime work_end_date_from:
        :param datetime work_end_date_to:
        :param datetime start_date_created:
        :param datetime end_date_created:
        :param float offset:
        :param PermitSortColumn sort_column:
        :param SortDirection sort_direction:
        :param bool is_traffic_sensitive:
        :param bool is_high_impact_traffic_management:
        :param bool has_no_final_registration:
        :param bool has_excavation:
        :param bool is_early_start:
        :param bool is_deemed:
        :param bool lane_rental_charges_not_agreed:
        :param bool lane_rental_charges_potentially_apply:
        :param str swa_code:
        :param bool ever_modification_requested:
        :param bool hs2_works_only:
        :param bool consultation_works_only:
        :param bool consent_works_only:
        :param bool unacknowledged_by_ha_only:
        :param list[str] geographical_area_reference_number:
        :param bool is_duration_challenged:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str permit_reference_number:
        :param str work_reference_number:
        :param bool include_total_count:
        :param datetime reasonable_period_end_date_from:
        :param datetime reasonable_period_end_date_to:
        :return: PermitReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status', 'work_status', 'work_category', 'lane_rental_assessment_outcome', 'active_permit_only', 'start_date', 'end_date', 'work_start_date_from', 'work_start_date_to', 'work_end_date_from', 'work_end_date_to', 'start_date_created', 'end_date_created', 'offset', 'sort_column', 'sort_direction', 'is_traffic_sensitive', 'is_high_impact_traffic_management', 'has_no_final_registration', 'has_excavation', 'is_early_start', 'is_deemed', 'lane_rental_charges_not_agreed', 'lane_rental_charges_potentially_apply', 'swa_code', 'ever_modification_requested', 'hs2_works_only', 'consultation_works_only', 'consent_works_only', 'unacknowledged_by_ha_only', 'geographical_area_reference_number', 'is_duration_challenged', 'organisation', 'street_descriptor', 'usrn', 'permit_reference_number', 'work_reference_number', 'include_total_count', 'reasonable_period_end_date_from', 'reasonable_period_end_date_to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_permits" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
            collection_formats['status'] = 'multi'  # noqa: E501
        if 'work_status' in params:
            query_params.append(('work_status', params['work_status']))  # noqa: E501
            collection_formats['work_status'] = 'multi'  # noqa: E501
        if 'work_category' in params:
            query_params.append(('work_category', params['work_category']))  # noqa: E501
            collection_formats['work_category'] = 'multi'  # noqa: E501
        if 'lane_rental_assessment_outcome' in params:
            query_params.append(('lane_rental_assessment_outcome', params['lane_rental_assessment_outcome']))  # noqa: E501
            collection_formats['lane_rental_assessment_outcome'] = 'multi'  # noqa: E501
        if 'active_permit_only' in params:
            query_params.append(('active_permit_only', params['active_permit_only']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'work_start_date_from' in params:
            query_params.append(('work_start_date_from', params['work_start_date_from']))  # noqa: E501
        if 'work_start_date_to' in params:
            query_params.append(('work_start_date_to', params['work_start_date_to']))  # noqa: E501
        if 'work_end_date_from' in params:
            query_params.append(('work_end_date_from', params['work_end_date_from']))  # noqa: E501
        if 'work_end_date_to' in params:
            query_params.append(('work_end_date_to', params['work_end_date_to']))  # noqa: E501
        if 'start_date_created' in params:
            query_params.append(('start_date_created', params['start_date_created']))  # noqa: E501
        if 'end_date_created' in params:
            query_params.append(('end_date_created', params['end_date_created']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'is_traffic_sensitive' in params:
            query_params.append(('is_traffic_sensitive', params['is_traffic_sensitive']))  # noqa: E501
        if 'is_high_impact_traffic_management' in params:
            query_params.append(('is_high_impact_traffic_management', params['is_high_impact_traffic_management']))  # noqa: E501
        if 'has_no_final_registration' in params:
            query_params.append(('has_no_final_registration', params['has_no_final_registration']))  # noqa: E501
        if 'has_excavation' in params:
            query_params.append(('has_excavation', params['has_excavation']))  # noqa: E501
        if 'is_early_start' in params:
            query_params.append(('is_early_start', params['is_early_start']))  # noqa: E501
        if 'is_deemed' in params:
            query_params.append(('is_deemed', params['is_deemed']))  # noqa: E501
        if 'lane_rental_charges_not_agreed' in params:
            query_params.append(('lane_rental_charges_not_agreed', params['lane_rental_charges_not_agreed']))  # noqa: E501
        if 'lane_rental_charges_potentially_apply' in params:
            query_params.append(('lane_rental_charges_potentially_apply', params['lane_rental_charges_potentially_apply']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'ever_modification_requested' in params:
            query_params.append(('ever_modification_requested', params['ever_modification_requested']))  # noqa: E501
        if 'hs2_works_only' in params:
            query_params.append(('hs2_works_only', params['hs2_works_only']))  # noqa: E501
        if 'consultation_works_only' in params:
            query_params.append(('consultation_works_only', params['consultation_works_only']))  # noqa: E501
        if 'consent_works_only' in params:
            query_params.append(('consent_works_only', params['consent_works_only']))  # noqa: E501
        if 'unacknowledged_by_ha_only' in params:
            query_params.append(('unacknowledged_by_ha_only', params['unacknowledged_by_ha_only']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'is_duration_challenged' in params:
            query_params.append(('is_duration_challenged', params['is_duration_challenged']))  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'permit_reference_number' in params:
            query_params.append(('permit_reference_number', params['permit_reference_number']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501
        if 'reasonable_period_end_date_from' in params:
            query_params.append(('reasonable_period_end_date_from', params['reasonable_period_end_date_from']))  # noqa: E501
        if 'reasonable_period_end_date_to' in params:
            query_params.append(('reasonable_period_end_date_to', params['reasonable_period_end_date_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/permits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermitReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_private_street_files(self, private_street_reference_number, **kwargs):  # noqa: E501
        """get_private_street_files  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_private_street_files(private_street_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str private_street_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_private_street_files_with_http_info(private_street_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_private_street_files_with_http_info(private_street_reference_number, **kwargs)  # noqa: E501
            return data

    def get_private_street_files_with_http_info(self, private_street_reference_number, **kwargs):  # noqa: E501
        """get_private_street_files  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_private_street_files_with_http_info(private_street_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str private_street_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['private_street_reference_number', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_private_street_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'private_street_reference_number' is set
        if ('private_street_reference_number' not in params or
                params['private_street_reference_number'] is None):
            raise ValueError("Missing the required parameter `private_street_reference_number` when calling `get_private_street_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'private_street_reference_number' in params:
            query_params.append(('private_street_reference_number', params['private_street_reference_number']))  # noqa: E501
        if 'file_type' in params:
            query_params.append(('file_type', params['file_type']))  # noqa: E501
            collection_formats['file_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/private-street-notices/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_private_streets(self, **kwargs):  # noqa: E501
        """get_private_streets  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_private_streets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param SortDirection sort_direction:
        :param PrivateStreetNoticeSortColumn sort_column:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str private_street_reference_number:
        :param datetime start_date_from:
        :param datetime start_date_to:
        :param datetime end_date_from:
        :param datetime end_date_to:
        :param datetime date_created_from:
        :param datetime date_created_to:
        :param list[PrivateStreetStatus] private_street_status:
        :param bool include_total_count:
        :return: PrivateStreetReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_private_streets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_private_streets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_private_streets_with_http_info(self, **kwargs):  # noqa: E501
        """get_private_streets  # noqa: E501

        Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_private_streets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float offset:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param SortDirection sort_direction:
        :param PrivateStreetNoticeSortColumn sort_column:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str private_street_reference_number:
        :param datetime start_date_from:
        :param datetime start_date_to:
        :param datetime end_date_from:
        :param datetime end_date_to:
        :param datetime date_created_from:
        :param datetime date_created_to:
        :param list[PrivateStreetStatus] private_street_status:
        :param bool include_total_count:
        :return: PrivateStreetReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'swa_code', 'geographical_area_reference_number', 'sort_direction', 'sort_column', 'organisation', 'street_descriptor', 'usrn', 'private_street_reference_number', 'start_date_from', 'start_date_to', 'end_date_from', 'end_date_to', 'date_created_from', 'date_created_to', 'private_street_status', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_private_streets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'private_street_reference_number' in params:
            query_params.append(('private_street_reference_number', params['private_street_reference_number']))  # noqa: E501
        if 'start_date_from' in params:
            query_params.append(('start_date_from', params['start_date_from']))  # noqa: E501
        if 'start_date_to' in params:
            query_params.append(('start_date_to', params['start_date_to']))  # noqa: E501
        if 'end_date_from' in params:
            query_params.append(('end_date_from', params['end_date_from']))  # noqa: E501
        if 'end_date_to' in params:
            query_params.append(('end_date_to', params['end_date_to']))  # noqa: E501
        if 'date_created_from' in params:
            query_params.append(('date_created_from', params['date_created_from']))  # noqa: E501
        if 'date_created_to' in params:
            query_params.append(('date_created_to', params['date_created_to']))  # noqa: E501
        if 'private_street_status' in params:
            query_params.append(('private_street_status', params['private_street_status']))  # noqa: E501
            collection_formats['private_street_status'] = 'multi'  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/private-street-notices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateStreetReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reinspections(self, **kwargs):  # noqa: E501
        """get_reinspections  # noqa: E501

        See API specification Resource Guide > Reporting API > Get reinspections for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reinspections(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date:
        :param datetime end_date:
        :param list[InspectionType] inspection_type:
        :param float offset:
        :param ReinspectionSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param list[InspectionCategory] inspection_category:
        :param bool include_total_count:
        :return: ReinspectionReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reinspections_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_reinspections_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_reinspections_with_http_info(self, **kwargs):  # noqa: E501
        """get_reinspections  # noqa: E501

        See API specification Resource Guide > Reporting API > Get reinspections for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reinspections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date:
        :param datetime end_date:
        :param list[InspectionType] inspection_type:
        :param float offset:
        :param ReinspectionSortColumn sort_column:
        :param SortDirection sort_direction:
        :param str swa_code:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param list[InspectionCategory] inspection_category:
        :param bool include_total_count:
        :return: ReinspectionReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_date', 'end_date', 'inspection_type', 'offset', 'sort_column', 'sort_direction', 'swa_code', 'geographical_area_reference_number', 'organisation', 'street_descriptor', 'usrn', 'work_reference_number', 'inspection_category', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reinspections" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'inspection_type' in params:
            query_params.append(('inspection_type', params['inspection_type']))  # noqa: E501
            collection_formats['inspection_type'] = 'multi'  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'inspection_category' in params:
            query_params.append(('inspection_category', params['inspection_category']))  # noqa: E501
            collection_formats['inspection_category'] = 'multi'  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/reinspections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReinspectionReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reinstatement_files(self, reinstatement_reference_number, **kwargs):  # noqa: E501
        """get_reinstatement_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reinstatement_files(reinstatement_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reinstatement_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reinstatement_files_with_http_info(reinstatement_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_reinstatement_files_with_http_info(reinstatement_reference_number, **kwargs)  # noqa: E501
            return data

    def get_reinstatement_files_with_http_info(self, reinstatement_reference_number, **kwargs):  # noqa: E501
        """get_reinstatement_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reinstatement_files_with_http_info(reinstatement_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reinstatement_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reinstatement_reference_number', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reinstatement_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reinstatement_reference_number' is set
        if ('reinstatement_reference_number' not in params or
                params['reinstatement_reference_number'] is None):
            raise ValueError("Missing the required parameter `reinstatement_reference_number` when calling `get_reinstatement_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'reinstatement_reference_number' in params:
            query_params.append(('reinstatement_reference_number', params['reinstatement_reference_number']))  # noqa: E501
        if 'file_type' in params:
            query_params.append(('file_type', params['file_type']))  # noqa: E501
            collection_formats['file_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/reinstatements/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reinstatements(self, **kwargs):  # noqa: E501
        """get_reinstatements  # noqa: E501

        Returns all reinstatements associated with the logged in user's organisation. Optional filter by status Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reinstatements(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReinstatementSortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[ReinstatementStatus] status:
        :param float offset:
        :param str swa_code:
        :param bool latest_reinstatements_only:
        :param datetime registration_date_from:
        :param datetime registration_date_to:
        :param datetime end_date_from:
        :param datetime end_date_to:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param str work_reference_number_exact:
        :param bool include_total_count:
        :return: ReinstatementReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reinstatements_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_reinstatements_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_reinstatements_with_http_info(self, **kwargs):  # noqa: E501
        """get_reinstatements  # noqa: E501

        Returns all reinstatements associated with the logged in user's organisation. Optional filter by status Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reinstatements_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReinstatementSortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[ReinstatementStatus] status:
        :param float offset:
        :param str swa_code:
        :param bool latest_reinstatements_only:
        :param datetime registration_date_from:
        :param datetime registration_date_to:
        :param datetime end_date_from:
        :param datetime end_date_to:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str work_reference_number:
        :param str work_reference_number_exact:
        :param bool include_total_count:
        :return: ReinstatementReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort_column', 'sort_direction', 'status', 'offset', 'swa_code', 'latest_reinstatements_only', 'registration_date_from', 'registration_date_to', 'end_date_from', 'end_date_to', 'geographical_area_reference_number', 'organisation', 'street_descriptor', 'usrn', 'work_reference_number', 'work_reference_number_exact', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reinstatements" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
            collection_formats['status'] = 'multi'  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'latest_reinstatements_only' in params:
            query_params.append(('latest_reinstatements_only', params['latest_reinstatements_only']))  # noqa: E501
        if 'registration_date_from' in params:
            query_params.append(('registration_date_from', params['registration_date_from']))  # noqa: E501
        if 'registration_date_to' in params:
            query_params.append(('registration_date_to', params['registration_date_to']))  # noqa: E501
        if 'end_date_from' in params:
            query_params.append(('end_date_from', params['end_date_from']))  # noqa: E501
        if 'end_date_to' in params:
            query_params.append(('end_date_to', params['end_date_to']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'work_reference_number_exact' in params:
            query_params.append(('work_reference_number_exact', params['work_reference_number_exact']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/reinstatements', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReinstatementReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reinstatements_due(self, **kwargs):  # noqa: E501
        """get_reinstatements_due  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reinstatements_due(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str swa_code:
        :param str street_descriptor:
        :param str usrn:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str work_reference_number:
        :param datetime work_end_date_from:
        :param datetime work_end_date_to:
        :param datetime registration_due_date_from:
        :param datetime registration_due_date_to:
        :param bool include_total_count:
        :return: ReinstatementsDueReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reinstatements_due_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_reinstatements_due_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_reinstatements_due_with_http_info(self, **kwargs):  # noqa: E501
        """get_reinstatements_due  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reinstatements_due_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str swa_code:
        :param str street_descriptor:
        :param str usrn:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str work_reference_number:
        :param datetime work_end_date_from:
        :param datetime work_end_date_to:
        :param datetime registration_due_date_from:
        :param datetime registration_due_date_to:
        :param bool include_total_count:
        :return: ReinstatementsDueReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['swa_code', 'street_descriptor', 'usrn', 'geographical_area_reference_number', 'organisation', 'work_reference_number', 'work_end_date_from', 'work_end_date_to', 'registration_due_date_from', 'registration_due_date_to', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reinstatements_due" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'work_end_date_from' in params:
            query_params.append(('work_end_date_from', params['work_end_date_from']))  # noqa: E501
        if 'work_end_date_to' in params:
            query_params.append(('work_end_date_to', params['work_end_date_to']))  # noqa: E501
        if 'registration_due_date_from' in params:
            query_params.append(('registration_due_date_from', params['registration_due_date_from']))  # noqa: E501
        if 'registration_due_date_to' in params:
            query_params.append(('registration_due_date_to', params['registration_due_date_to']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/permits/reinstatements-due', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReinstatementsDueReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section58s(self, **kwargs):  # noqa: E501
        """get_section58s  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Section 58s for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section58s(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ha_organisation_name:
        :param datetime start_date_from:
        :param datetime start_date_to:
        :param list[Section58Status] section_58_status:
        :param float offset:
        :param Section58SortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param str section_58_reference_number:
        :param str street_descriptor:
        :param str usrn:
        :param bool include_total_count:
        :return: Section58ReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section58s_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_section58s_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_section58s_with_http_info(self, **kwargs):  # noqa: E501
        """get_section58s  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Section 58s for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section58s_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ha_organisation_name:
        :param datetime start_date_from:
        :param datetime start_date_to:
        :param list[Section58Status] section_58_status:
        :param float offset:
        :param Section58SortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param str section_58_reference_number:
        :param str street_descriptor:
        :param str usrn:
        :param bool include_total_count:
        :return: Section58ReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ha_organisation_name', 'start_date_from', 'start_date_to', 'section_58_status', 'offset', 'sort_column', 'sort_direction', 'geographical_area_reference_number', 'section_58_reference_number', 'street_descriptor', 'usrn', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section58s" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ha_organisation_name' in params:
            query_params.append(('ha_organisation_name', params['ha_organisation_name']))  # noqa: E501
        if 'start_date_from' in params:
            query_params.append(('start_date_from', params['start_date_from']))  # noqa: E501
        if 'start_date_to' in params:
            query_params.append(('start_date_to', params['start_date_to']))  # noqa: E501
        if 'section_58_status' in params:
            query_params.append(('section_58_status', params['section_58_status']))  # noqa: E501
            collection_formats['section_58_status'] = 'multi'  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'section_58_reference_number' in params:
            query_params.append(('section_58_reference_number', params['section_58_reference_number']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-58s', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section58ReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section74_files(self, section_74_reference_number, **kwargs):  # noqa: E501
        """get_section74_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section74_files(section_74_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str section_74_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section74_files_with_http_info(section_74_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_section74_files_with_http_info(section_74_reference_number, **kwargs)  # noqa: E501
            return data

    def get_section74_files_with_http_info(self, section_74_reference_number, **kwargs):  # noqa: E501
        """get_section74_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section74_files_with_http_info(section_74_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str section_74_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_74_reference_number', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section74_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_74_reference_number' is set
        if ('section_74_reference_number' not in params or
                params['section_74_reference_number'] is None):
            raise ValueError("Missing the required parameter `section_74_reference_number` when calling `get_section74_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'section_74_reference_number' in params:
            query_params.append(('section_74_reference_number', params['section_74_reference_number']))  # noqa: E501
        if 'file_type' in params:
            query_params.append(('file_type', params['file_type']))  # noqa: E501
            collection_formats['file_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-74s/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section74s(self, **kwargs):  # noqa: E501
        """get_section74s  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Section 74s for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section74s(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Section74HAStatus] section_74_ha_status:
        :param datetime issue_date_from:
        :param datetime issue_date_to:
        :param str swa_code:
        :param float offset:
        :param Section74SortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str section_74_reference_number:
        :param bool include_total_count:
        :return: Section74ReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section74s_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_section74s_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_section74s_with_http_info(self, **kwargs):  # noqa: E501
        """get_section74s  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Section 74s for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section74s_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Section74HAStatus] section_74_ha_status:
        :param datetime issue_date_from:
        :param datetime issue_date_to:
        :param str swa_code:
        :param float offset:
        :param Section74SortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param str street_descriptor:
        :param str usrn:
        :param str section_74_reference_number:
        :param bool include_total_count:
        :return: Section74ReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_74_ha_status', 'issue_date_from', 'issue_date_to', 'swa_code', 'offset', 'sort_column', 'sort_direction', 'geographical_area_reference_number', 'organisation', 'street_descriptor', 'usrn', 'section_74_reference_number', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section74s" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'section_74_ha_status' in params:
            query_params.append(('section_74_ha_status', params['section_74_ha_status']))  # noqa: E501
            collection_formats['section_74_ha_status'] = 'multi'  # noqa: E501
        if 'issue_date_from' in params:
            query_params.append(('issue_date_from', params['issue_date_from']))  # noqa: E501
        if 'issue_date_to' in params:
            query_params.append(('issue_date_to', params['issue_date_to']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'section_74_reference_number' in params:
            query_params.append(('section_74_reference_number', params['section_74_reference_number']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-74s', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section74ReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section81_files(self, section_81_reference_number, **kwargs):  # noqa: E501
        """get_section81_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section81_files(section_81_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str section_81_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section81_files_with_http_info(section_81_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_section81_files_with_http_info(section_81_reference_number, **kwargs)  # noqa: E501
            return data

    def get_section81_files_with_http_info(self, section_81_reference_number, **kwargs):  # noqa: E501
        """get_section81_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section81_files_with_http_info(section_81_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str section_81_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_81_reference_number', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section81_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_81_reference_number' is set
        if ('section_81_reference_number' not in params or
                params['section_81_reference_number'] is None):
            raise ValueError("Missing the required parameter `section_81_reference_number` when calling `get_section81_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'section_81_reference_number' in params:
            query_params.append(('section_81_reference_number', params['section_81_reference_number']))  # noqa: E501
        if 'file_type' in params:
            query_params.append(('file_type', params['file_type']))  # noqa: E501
            collection_formats['file_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-81s/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section81s(self, **kwargs):  # noqa: E501
        """get_section81s  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Section 81s for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section81s(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Section81Status] section_81_status:
        :param list[Section81Severity] section_81_severity:
        :param datetime issue_date_from:
        :param datetime issue_date_to:
        :param datetime status_changed_date_from:
        :param datetime status_changed_date_to:
        :param str swa_code:
        :param float offset:
        :param Section81SortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param list[Section81Type] section_81_type:
        :param str street_descriptor:
        :param str usrn:
        :param str section_81_reference_number:
        :param bool include_total_count:
        :return: Section81ReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section81s_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_section81s_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_section81s_with_http_info(self, **kwargs):  # noqa: E501
        """get_section81s  # noqa: E501

        See API specification Resource Guide > Reporting API > Get Section 81s for more information Authenticated user must have one of the following roles: Planner, Contractor, HighwayAuthority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section81s_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Section81Status] section_81_status:
        :param list[Section81Severity] section_81_severity:
        :param datetime issue_date_from:
        :param datetime issue_date_to:
        :param datetime status_changed_date_from:
        :param datetime status_changed_date_to:
        :param str swa_code:
        :param float offset:
        :param Section81SortColumn sort_column:
        :param SortDirection sort_direction:
        :param list[str] geographical_area_reference_number:
        :param str organisation:
        :param list[Section81Type] section_81_type:
        :param str street_descriptor:
        :param str usrn:
        :param str section_81_reference_number:
        :param bool include_total_count:
        :return: Section81ReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_81_status', 'section_81_severity', 'issue_date_from', 'issue_date_to', 'status_changed_date_from', 'status_changed_date_to', 'swa_code', 'offset', 'sort_column', 'sort_direction', 'geographical_area_reference_number', 'organisation', 'section_81_type', 'street_descriptor', 'usrn', 'section_81_reference_number', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section81s" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'section_81_status' in params:
            query_params.append(('section_81_status', params['section_81_status']))  # noqa: E501
            collection_formats['section_81_status'] = 'multi'  # noqa: E501
        if 'section_81_severity' in params:
            query_params.append(('section_81_severity', params['section_81_severity']))  # noqa: E501
            collection_formats['section_81_severity'] = 'multi'  # noqa: E501
        if 'issue_date_from' in params:
            query_params.append(('issue_date_from', params['issue_date_from']))  # noqa: E501
        if 'issue_date_to' in params:
            query_params.append(('issue_date_to', params['issue_date_to']))  # noqa: E501
        if 'status_changed_date_from' in params:
            query_params.append(('status_changed_date_from', params['status_changed_date_from']))  # noqa: E501
        if 'status_changed_date_to' in params:
            query_params.append(('status_changed_date_to', params['status_changed_date_to']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_column' in params:
            query_params.append(('sort_column', params['sort_column']))  # noqa: E501
        if 'sort_direction' in params:
            query_params.append(('sort_direction', params['sort_direction']))  # noqa: E501
        if 'geographical_area_reference_number' in params:
            query_params.append(('geographical_area_reference_number', params['geographical_area_reference_number']))  # noqa: E501
            collection_formats['geographical_area_reference_number'] = 'multi'  # noqa: E501
        if 'organisation' in params:
            query_params.append(('organisation', params['organisation']))  # noqa: E501
        if 'section_81_type' in params:
            query_params.append(('section_81_type', params['section_81_type']))  # noqa: E501
            collection_formats['section_81_type'] = 'multi'  # noqa: E501
        if 'street_descriptor' in params:
            query_params.append(('street_descriptor', params['street_descriptor']))  # noqa: E501
        if 'usrn' in params:
            query_params.append(('usrn', params['usrn']))  # noqa: E501
        if 'section_81_reference_number' in params:
            query_params.append(('section_81_reference_number', params['section_81_reference_number']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/section-81s', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Section81ReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work_files(self, work_reference_number, **kwargs):  # noqa: E501
        """get_work_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_files(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_work_files_with_http_info(work_reference_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_work_files_with_http_info(work_reference_number, **kwargs)  # noqa: E501
            return data

    def get_work_files_with_http_info(self, work_reference_number, **kwargs):  # noqa: E501
        """get_work_files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_files_with_http_info(work_reference_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number: (required)
        :param list[FileType] file_type:
        :return: FileSummaryReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_reference_number' is set
        if ('work_reference_number' not in params or
                params['work_reference_number'] is None):
            raise ValueError("Missing the required parameter `work_reference_number` when calling `get_work_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'file_type' in params:
            query_params.append(('file_type', params['file_type']))  # noqa: E501
            collection_formats['file_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileSummaryReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_works(self, **kwargs):  # noqa: E501
        """get_works  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_works(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number:
        :param str swa_code:
        :return: WorkSearchReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_works_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_works_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_works_with_http_info(self, **kwargs):  # noqa: E501
        """get_works  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_works_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str work_reference_number:
        :param str swa_code:
        :return: WorkSearchReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_reference_number', 'swa_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_works" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'work_reference_number' in params:
            query_params.append(('work_reference_number', params['work_reference_number']))  # noqa: E501
        if 'swa_code' in params:
            query_params.append(('swa_code', params['swa_code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/works', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkSearchReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workstreams(self, **kwargs):  # noqa: E501
        """get_workstreams  # noqa: E501

        Returns all workstreams associated with the logged in user's organisation. Optional filter by status Authenticated user must have one of the following roles: Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workstreams(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[WorkstreamStatus] status:
        :param float offset:
        :param bool include_total_count:
        :return: WorkstreamReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workstreams_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_workstreams_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_workstreams_with_http_info(self, **kwargs):  # noqa: E501
        """get_workstreams  # noqa: E501

        Returns all workstreams associated with the logged in user's organisation. Optional filter by status Authenticated user must have one of the following roles: Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workstreams_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[WorkstreamStatus] status:
        :param float offset:
        :param bool include_total_count:
        :return: WorkstreamReportingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status', 'offset', 'include_total_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workstreams" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
            collection_formats['status'] = 'multi'  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'include_total_count' in params:
            query_params.append(('include_total_count', params['include_total_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/workstreams', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkstreamReportingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
