# swagger-client
See API specification Resource Guide > Sampling API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.SampleInspectionTargetCreateRequest() # SampleInspectionTargetCreateRequest | 

try:
    api_response = api_instance.create_sample_inspection_target(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_sample_inspection_target: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
sample_inspection_target_reference_number = 'sample_inspection_target_reference_number_example' # str | 

try:
    api_instance.delete_sample_inspection_target(sample_inspection_target_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->delete_sample_inspection_target: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))

try:
    api_instance.end_quarter()
except ApiException as e:
    print("Exception when calling DefaultApi->end_quarter: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.GenerateSampleInspectionsRequest() # GenerateSampleInspectionsRequest | 

try:
    api_instance.generate_sample_inspections(body)
except ApiException as e:
    print("Exception when calling DefaultApi->generate_sample_inspections: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
promoter_org_ref = 'promoter_org_ref_example' # str | 
financial_year_start_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)

try:
    api_response = api_instance.get_previous_annual_inspection_units(promoter_org_ref, financial_year_start_date=financial_year_start_date)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_previous_annual_inspection_units: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
inspection_units = [3.4] # list[float] | 
inspection_rate = 1.2 # float | 

try:
    api_response = api_instance.get_sample_inspection_quota(inspection_units, inspection_rate)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_sample_inspection_quota: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
sample_inspection_target_reference_number = 'sample_inspection_target_reference_number_example' # str | 

try:
    api_response = api_instance.get_sample_inspection_target(sample_inspection_target_reference_number)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->get_sample_inspection_target: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))

try:
    api_instance.revert_end_quarter()
except ApiException as e:
    print("Exception when calling DefaultApi->revert_end_quarter: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.SampleInspectionStartQuarterRequest() # SampleInspectionStartQuarterRequest | 

try:
    api_instance.start_quarter(body)
except ApiException as e:
    print("Exception when calling DefaultApi->start_quarter: %s\n" % e)

# Configure API key authorization: token
configuration = swagger_client.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.DefaultApi(swagger_client.ApiClient(configuration))
body = swagger_client.SampleInspectionTargetUpdateRequest() # SampleInspectionTargetUpdateRequest | 
sample_inspection_target_reference_number = 'sample_inspection_target_reference_number_example' # str | 

try:
    api_instance.update_sample_inspection_target(body, sample_inspection_target_reference_number)
except ApiException as e:
    print("Exception when calling DefaultApi->update_sample_inspection_target: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://department-for-transport-streetmanager.github.io/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_sample_inspection_target**](docs/DefaultApi.md#create_sample_inspection_target) | **POST** /sample-inspection-targets | 
*DefaultApi* | [**delete_sample_inspection_target**](docs/DefaultApi.md#delete_sample_inspection_target) | **DELETE** /sample-inspection-targets/{sampleInspectionTargetReferenceNumber} | 
*DefaultApi* | [**end_quarter**](docs/DefaultApi.md#end_quarter) | **POST** /sample-inspections/end-quarter | 
*DefaultApi* | [**generate_sample_inspections**](docs/DefaultApi.md#generate_sample_inspections) | **POST** /sample-inspections | 
*DefaultApi* | [**get_previous_annual_inspection_units**](docs/DefaultApi.md#get_previous_annual_inspection_units) | **GET** /previous-annual-inspection-units | 
*DefaultApi* | [**get_sample_inspection_quota**](docs/DefaultApi.md#get_sample_inspection_quota) | **GET** /sample-inspection-quota | 
*DefaultApi* | [**get_sample_inspection_target**](docs/DefaultApi.md#get_sample_inspection_target) | **GET** /sample-inspection-targets/{sampleInspectionTargetReferenceNumber} | 
*DefaultApi* | [**revert_end_quarter**](docs/DefaultApi.md#revert_end_quarter) | **POST** /sample-inspections/revert-end-quarter | 
*DefaultApi* | [**start_quarter**](docs/DefaultApi.md#start_quarter) | **POST** /sample-inspections/start-quarter | 
*DefaultApi* | [**update_sample_inspection_target**](docs/DefaultApi.md#update_sample_inspection_target) | **PUT** /sample-inspection-targets/{sampleInspectionTargetReferenceNumber} | 

## Documentation For Models

 - [AnnualInspectionUnitsResponse](docs/AnnualInspectionUnitsResponse.md)
 - [AnnualInspectionUnitsSummary](docs/AnnualInspectionUnitsSummary.md)
 - [GenerateSampleInspectionsRequest](docs/GenerateSampleInspectionsRequest.md)
 - [SampleInspectionQuotaResponse](docs/SampleInspectionQuotaResponse.md)
 - [SampleInspectionStartQuarterRequest](docs/SampleInspectionStartQuarterRequest.md)
 - [SampleInspectionTargetCreateRequest](docs/SampleInspectionTargetCreateRequest.md)
 - [SampleInspectionTargetCreateResponse](docs/SampleInspectionTargetCreateResponse.md)
 - [SampleInspectionTargetResponse](docs/SampleInspectionTargetResponse.md)
 - [SampleInspectionTargetUpdateRequest](docs/SampleInspectionTargetUpdateRequest.md)

## Documentation For Authorization


## token

- **Type**: API key
- **API key parameter name**: token
- **Location**: HTTP header


## Author


