# coding: utf-8

"""
    Street Manager Sampling API

    See API specification Resource Guide > Sampling API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SampleInspectionTargetCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'internal_user_identifier': 'str',
        'internal_user_name': 'str',
        'inspection_units_baseline': 'float',
        'annual_inspection_units': 'list[AnnualInspectionUnitsSummary]',
        'inspection_rate': 'float',
        'target_a': 'float',
        'target_b': 'float',
        'target_c': 'float',
        'promoter_org_ref': 'str'
    }

    attribute_map = {
        'internal_user_identifier': 'internal_user_identifier',
        'internal_user_name': 'internal_user_name',
        'inspection_units_baseline': 'inspection_units_baseline',
        'annual_inspection_units': 'annual_inspection_units',
        'inspection_rate': 'inspection_rate',
        'target_a': 'target_a',
        'target_b': 'target_b',
        'target_c': 'target_c',
        'promoter_org_ref': 'promoter_org_ref'
    }

    def __init__(self, internal_user_identifier=None, internal_user_name=None, inspection_units_baseline=None, annual_inspection_units=None, inspection_rate=None, target_a=None, target_b=None, target_c=None, promoter_org_ref=None):  # noqa: E501
        """SampleInspectionTargetCreateRequest - a model defined in Swagger"""  # noqa: E501
        self._internal_user_identifier = None
        self._internal_user_name = None
        self._inspection_units_baseline = None
        self._annual_inspection_units = None
        self._inspection_rate = None
        self._target_a = None
        self._target_b = None
        self._target_c = None
        self._promoter_org_ref = None
        self.discriminator = None
        if internal_user_identifier is not None:
            self.internal_user_identifier = internal_user_identifier
        if internal_user_name is not None:
            self.internal_user_name = internal_user_name
        if inspection_units_baseline is not None:
            self.inspection_units_baseline = inspection_units_baseline
        if annual_inspection_units is not None:
            self.annual_inspection_units = annual_inspection_units
        self.inspection_rate = inspection_rate
        self.target_a = target_a
        self.target_b = target_b
        self.target_c = target_c
        self.promoter_org_ref = promoter_org_ref

    @property
    def internal_user_identifier(self):
        """Gets the internal_user_identifier of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_identifier of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_identifier

    @internal_user_identifier.setter
    def internal_user_identifier(self, internal_user_identifier):
        """Sets the internal_user_identifier of this SampleInspectionTargetCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_identifier: The internal_user_identifier of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_identifier = internal_user_identifier

    @property
    def internal_user_name(self):
        """Gets the internal_user_name of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Max length 50 characters  # noqa: E501

        :return: The internal_user_name of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_name

    @internal_user_name.setter
    def internal_user_name(self, internal_user_name):
        """Sets the internal_user_name of this SampleInspectionTargetCreateRequest.

        Max length 50 characters  # noqa: E501

        :param internal_user_name: The internal_user_name of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_name = internal_user_name

    @property
    def inspection_units_baseline(self):
        """Gets the inspection_units_baseline of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Required if annual_inspection_units not provided Must be whole number  # noqa: E501

        :return: The inspection_units_baseline of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._inspection_units_baseline

    @inspection_units_baseline.setter
    def inspection_units_baseline(self, inspection_units_baseline):
        """Sets the inspection_units_baseline of this SampleInspectionTargetCreateRequest.

        Required if annual_inspection_units not provided Must be whole number  # noqa: E501

        :param inspection_units_baseline: The inspection_units_baseline of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: float
        """

        self._inspection_units_baseline = inspection_units_baseline

    @property
    def annual_inspection_units(self):
        """Gets the annual_inspection_units of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Required if inspection_units_baseline not provided  # noqa: E501

        :return: The annual_inspection_units of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: list[AnnualInspectionUnitsSummary]
        """
        return self._annual_inspection_units

    @annual_inspection_units.setter
    def annual_inspection_units(self, annual_inspection_units):
        """Sets the annual_inspection_units of this SampleInspectionTargetCreateRequest.

        Required if inspection_units_baseline not provided  # noqa: E501

        :param annual_inspection_units: The annual_inspection_units of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: list[AnnualInspectionUnitsSummary]
        """

        self._annual_inspection_units = annual_inspection_units

    @property
    def inspection_rate(self):
        """Gets the inspection_rate of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Must be between 20 and 100  # noqa: E501

        :return: The inspection_rate of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._inspection_rate

    @inspection_rate.setter
    def inspection_rate(self, inspection_rate):
        """Sets the inspection_rate of this SampleInspectionTargetCreateRequest.

        Must be between 20 and 100  # noqa: E501

        :param inspection_rate: The inspection_rate of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: float
        """
        if inspection_rate is None:
            raise ValueError("Invalid value for `inspection_rate`, must not be `None`")  # noqa: E501

        self._inspection_rate = inspection_rate

    @property
    def target_a(self):
        """Gets the target_a of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Sum of target_a + target_b + target_c must not exceed the quarterly quota Must be whole number See API specification Resource Guide > Sampling API > Sample inspection quota for more information  # noqa: E501

        :return: The target_a of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._target_a

    @target_a.setter
    def target_a(self, target_a):
        """Sets the target_a of this SampleInspectionTargetCreateRequest.

        Sum of target_a + target_b + target_c must not exceed the quarterly quota Must be whole number See API specification Resource Guide > Sampling API > Sample inspection quota for more information  # noqa: E501

        :param target_a: The target_a of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: float
        """
        if target_a is None:
            raise ValueError("Invalid value for `target_a`, must not be `None`")  # noqa: E501

        self._target_a = target_a

    @property
    def target_b(self):
        """Gets the target_b of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Sum of target_a + target_b + target_c must not exceed the quarterly quota Must be whole number See API specification Resource Guide > Sampling API > Sample inspection quota for more information  # noqa: E501

        :return: The target_b of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._target_b

    @target_b.setter
    def target_b(self, target_b):
        """Sets the target_b of this SampleInspectionTargetCreateRequest.

        Sum of target_a + target_b + target_c must not exceed the quarterly quota Must be whole number See API specification Resource Guide > Sampling API > Sample inspection quota for more information  # noqa: E501

        :param target_b: The target_b of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: float
        """
        if target_b is None:
            raise ValueError("Invalid value for `target_b`, must not be `None`")  # noqa: E501

        self._target_b = target_b

    @property
    def target_c(self):
        """Gets the target_c of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Sum of target_a + target_b + target_c must not exceed the quarterly quota Must be whole number See API specification Resource Guide > Sampling API > Sample inspection quota for more information  # noqa: E501

        :return: The target_c of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._target_c

    @target_c.setter
    def target_c(self, target_c):
        """Sets the target_c of this SampleInspectionTargetCreateRequest.

        Sum of target_a + target_b + target_c must not exceed the quarterly quota Must be whole number See API specification Resource Guide > Sampling API > Sample inspection quota for more information  # noqa: E501

        :param target_c: The target_c of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: float
        """
        if target_c is None:
            raise ValueError("Invalid value for `target_c`, must not be `None`")  # noqa: E501

        self._target_c = target_c

    @property
    def promoter_org_ref(self):
        """Gets the promoter_org_ref of this SampleInspectionTargetCreateRequest.  # noqa: E501

        Max length 4 characters  # noqa: E501

        :return: The promoter_org_ref of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._promoter_org_ref

    @promoter_org_ref.setter
    def promoter_org_ref(self, promoter_org_ref):
        """Sets the promoter_org_ref of this SampleInspectionTargetCreateRequest.

        Max length 4 characters  # noqa: E501

        :param promoter_org_ref: The promoter_org_ref of this SampleInspectionTargetCreateRequest.  # noqa: E501
        :type: str
        """
        if promoter_org_ref is None:
            raise ValueError("Invalid value for `promoter_org_ref`, must not be `None`")  # noqa: E501

        self._promoter_org_ref = promoter_org_ref

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SampleInspectionTargetCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SampleInspectionTargetCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
