# coding: utf-8

"""
    Street Manager API

    See API specification Resource Guide > Work API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ForwardPlanCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'internal_user_identifier': 'str',
        'internal_user_name': 'str',
        'promoter_swa_code': 'str',
        'highway_authority_swa_code': 'str',
        'works_coordinates': 'object',
        'street_name': 'str',
        'town': 'str',
        'area_name': 'str',
        'usrn': 'float',
        'road_category': 'float',
        'work_reference_number': 'str',
        'start_date': 'datetime',
        'end_date': 'datetime',
        'description_of_work': 'str',
        'project_reference_number': 'str',
        'traffic_management_type': 'AllOfForwardPlanCreateRequestTrafficManagementType',
        'additional_info': 'str',
        'forward_plan_asds': 'list[PermitASD]',
        'works_location_description': 'str',
        'workstream_prefix': 'str',
        'hs2_work_type': 'AllOfForwardPlanCreateRequestHs2WorkType',
        'hs2_in_act_limits': 'bool',
        'hs2_consultation_requested_response_date': 'datetime',
        'hs2_highway_exemption': 'AllOfForwardPlanCreateRequestHs2HighwayExemption'
    }

    attribute_map = {
        'internal_user_identifier': 'internal_user_identifier',
        'internal_user_name': 'internal_user_name',
        'promoter_swa_code': 'promoter_swa_code',
        'highway_authority_swa_code': 'highway_authority_swa_code',
        'works_coordinates': 'works_coordinates',
        'street_name': 'street_name',
        'town': 'town',
        'area_name': 'area_name',
        'usrn': 'usrn',
        'road_category': 'road_category',
        'work_reference_number': 'work_reference_number',
        'start_date': 'start_date',
        'end_date': 'end_date',
        'description_of_work': 'description_of_work',
        'project_reference_number': 'project_reference_number',
        'traffic_management_type': 'traffic_management_type',
        'additional_info': 'additional_info',
        'forward_plan_asds': 'forward_plan_asds',
        'works_location_description': 'works_location_description',
        'workstream_prefix': 'workstream_prefix',
        'hs2_work_type': 'hs2_work_type',
        'hs2_in_act_limits': 'hs2_in_act_limits',
        'hs2_consultation_requested_response_date': 'hs2_consultation_requested_response_date',
        'hs2_highway_exemption': 'hs2_highway_exemption'
    }

    def __init__(self, internal_user_identifier=None, internal_user_name=None, promoter_swa_code=None, highway_authority_swa_code=None, works_coordinates=None, street_name=None, town=None, area_name=None, usrn=None, road_category=None, work_reference_number=None, start_date=None, end_date=None, description_of_work=None, project_reference_number=None, traffic_management_type=None, additional_info=None, forward_plan_asds=None, works_location_description=None, workstream_prefix=None, hs2_work_type=None, hs2_in_act_limits=None, hs2_consultation_requested_response_date=None, hs2_highway_exemption=None):  # noqa: E501
        """ForwardPlanCreateRequest - a model defined in Swagger"""  # noqa: E501
        self._internal_user_identifier = None
        self._internal_user_name = None
        self._promoter_swa_code = None
        self._highway_authority_swa_code = None
        self._works_coordinates = None
        self._street_name = None
        self._town = None
        self._area_name = None
        self._usrn = None
        self._road_category = None
        self._work_reference_number = None
        self._start_date = None
        self._end_date = None
        self._description_of_work = None
        self._project_reference_number = None
        self._traffic_management_type = None
        self._additional_info = None
        self._forward_plan_asds = None
        self._works_location_description = None
        self._workstream_prefix = None
        self._hs2_work_type = None
        self._hs2_in_act_limits = None
        self._hs2_consultation_requested_response_date = None
        self._hs2_highway_exemption = None
        self.discriminator = None
        if internal_user_identifier is not None:
            self.internal_user_identifier = internal_user_identifier
        if internal_user_name is not None:
            self.internal_user_name = internal_user_name
        self.promoter_swa_code = promoter_swa_code
        self.highway_authority_swa_code = highway_authority_swa_code
        self.works_coordinates = works_coordinates
        if street_name is not None:
            self.street_name = street_name
        if town is not None:
            self.town = town
        if area_name is not None:
            self.area_name = area_name
        self.usrn = usrn
        if road_category is not None:
            self.road_category = road_category
        if work_reference_number is not None:
            self.work_reference_number = work_reference_number
        self.start_date = start_date
        self.end_date = end_date
        self.description_of_work = description_of_work
        if project_reference_number is not None:
            self.project_reference_number = project_reference_number
        if traffic_management_type is not None:
            self.traffic_management_type = traffic_management_type
        if additional_info is not None:
            self.additional_info = additional_info
        if forward_plan_asds is not None:
            self.forward_plan_asds = forward_plan_asds
        self.works_location_description = works_location_description
        if workstream_prefix is not None:
            self.workstream_prefix = workstream_prefix
        if hs2_work_type is not None:
            self.hs2_work_type = hs2_work_type
        if hs2_in_act_limits is not None:
            self.hs2_in_act_limits = hs2_in_act_limits
        if hs2_consultation_requested_response_date is not None:
            self.hs2_consultation_requested_response_date = hs2_consultation_requested_response_date
        if hs2_highway_exemption is not None:
            self.hs2_highway_exemption = hs2_highway_exemption

    @property
    def internal_user_identifier(self):
        """Gets the internal_user_identifier of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_identifier of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_identifier

    @internal_user_identifier.setter
    def internal_user_identifier(self, internal_user_identifier):
        """Sets the internal_user_identifier of this ForwardPlanCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_identifier: The internal_user_identifier of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_identifier = internal_user_identifier

    @property
    def internal_user_name(self):
        """Gets the internal_user_name of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_name of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_name

    @internal_user_name.setter
    def internal_user_name(self, internal_user_name):
        """Sets the internal_user_name of this ForwardPlanCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_name: The internal_user_name of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_name = internal_user_name

    @property
    def promoter_swa_code(self):
        """Gets the promoter_swa_code of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 4 characters  # noqa: E501

        :return: The promoter_swa_code of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._promoter_swa_code

    @promoter_swa_code.setter
    def promoter_swa_code(self, promoter_swa_code):
        """Sets the promoter_swa_code of this ForwardPlanCreateRequest.

        Max length 4 characters  # noqa: E501

        :param promoter_swa_code: The promoter_swa_code of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """
        if promoter_swa_code is None:
            raise ValueError("Invalid value for `promoter_swa_code`, must not be `None`")  # noqa: E501

        self._promoter_swa_code = promoter_swa_code

    @property
    def highway_authority_swa_code(self):
        """Gets the highway_authority_swa_code of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 4 characters  # noqa: E501

        :return: The highway_authority_swa_code of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._highway_authority_swa_code

    @highway_authority_swa_code.setter
    def highway_authority_swa_code(self, highway_authority_swa_code):
        """Sets the highway_authority_swa_code of this ForwardPlanCreateRequest.

        Max length 4 characters  # noqa: E501

        :param highway_authority_swa_code: The highway_authority_swa_code of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """
        if highway_authority_swa_code is None:
            raise ValueError("Invalid value for `highway_authority_swa_code`, must not be `None`")  # noqa: E501

        self._highway_authority_swa_code = highway_authority_swa_code

    @property
    def works_coordinates(self):
        """Gets the works_coordinates of this ForwardPlanCreateRequest.  # noqa: E501

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :return: The works_coordinates of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: object
        """
        return self._works_coordinates

    @works_coordinates.setter
    def works_coordinates(self, works_coordinates):
        """Sets the works_coordinates of this ForwardPlanCreateRequest.

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :param works_coordinates: The works_coordinates of this ForwardPlanCreateRequest.  # noqa: E501
        :type: object
        """
        if works_coordinates is None:
            raise ValueError("Invalid value for `works_coordinates`, must not be `None`")  # noqa: E501

        self._works_coordinates = works_coordinates

    @property
    def street_name(self):
        """Gets the street_name of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The street_name of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._street_name

    @street_name.setter
    def street_name(self, street_name):
        """Sets the street_name of this ForwardPlanCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param street_name: The street_name of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._street_name = street_name

    @property
    def town(self):
        """Gets the town of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The town of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._town

    @town.setter
    def town(self, town):
        """Sets the town of this ForwardPlanCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param town: The town of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._town = town

    @property
    def area_name(self):
        """Gets the area_name of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The area_name of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._area_name

    @area_name.setter
    def area_name(self, area_name):
        """Sets the area_name of this ForwardPlanCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param area_name: The area_name of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._area_name = area_name

    @property
    def usrn(self):
        """Gets the usrn of this ForwardPlanCreateRequest.  # noqa: E501

        Is whole number between 1000001 and 99999999 inclusive See business rules section 1.4 - USRN  # noqa: E501

        :return: The usrn of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._usrn

    @usrn.setter
    def usrn(self, usrn):
        """Sets the usrn of this ForwardPlanCreateRequest.

        Is whole number between 1000001 and 99999999 inclusive See business rules section 1.4 - USRN  # noqa: E501

        :param usrn: The usrn of this ForwardPlanCreateRequest.  # noqa: E501
        :type: float
        """
        if usrn is None:
            raise ValueError("Invalid value for `usrn`, must not be `None`")  # noqa: E501

        self._usrn = usrn

    @property
    def road_category(self):
        """Gets the road_category of this ForwardPlanCreateRequest.  # noqa: E501

        Is whole number between 0 and 10 inclusive If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The road_category of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._road_category

    @road_category.setter
    def road_category(self, road_category):
        """Sets the road_category of this ForwardPlanCreateRequest.

        Is whole number between 0 and 10 inclusive If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param road_category: The road_category of this ForwardPlanCreateRequest.  # noqa: E501
        :type: float
        """

        self._road_category = road_category

    @property
    def work_reference_number(self):
        """Gets the work_reference_number of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 24 characters Must be unique in the system Must contain only alphanumeric characters, dashes and underscores If not supplied it will be auto-generated  # noqa: E501

        :return: The work_reference_number of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._work_reference_number

    @work_reference_number.setter
    def work_reference_number(self, work_reference_number):
        """Sets the work_reference_number of this ForwardPlanCreateRequest.

        Max length 24 characters Must be unique in the system Must contain only alphanumeric characters, dashes and underscores If not supplied it will be auto-generated  # noqa: E501

        :param work_reference_number: The work_reference_number of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._work_reference_number = work_reference_number

    @property
    def start_date(self):
        """Gets the start_date of this ForwardPlanCreateRequest.  # noqa: E501

        start_date must be within five years of end_date  # noqa: E501

        :return: The start_date of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this ForwardPlanCreateRequest.

        start_date must be within five years of end_date  # noqa: E501

        :param start_date: The start_date of this ForwardPlanCreateRequest.  # noqa: E501
        :type: datetime
        """
        if start_date is None:
            raise ValueError("Invalid value for `start_date`, must not be `None`")  # noqa: E501

        self._start_date = start_date

    @property
    def end_date(self):
        """Gets the end_date of this ForwardPlanCreateRequest.  # noqa: E501

        end_date must be on or after start_date  # noqa: E501

        :return: The end_date of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this ForwardPlanCreateRequest.

        end_date must be on or after start_date  # noqa: E501

        :param end_date: The end_date of this ForwardPlanCreateRequest.  # noqa: E501
        :type: datetime
        """
        if end_date is None:
            raise ValueError("Invalid value for `end_date`, must not be `None`")  # noqa: E501

        self._end_date = end_date

    @property
    def description_of_work(self):
        """Gets the description_of_work of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The description_of_work of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._description_of_work

    @description_of_work.setter
    def description_of_work(self, description_of_work):
        """Sets the description_of_work of this ForwardPlanCreateRequest.

        Max length 500 characters  # noqa: E501

        :param description_of_work: The description_of_work of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """
        if description_of_work is None:
            raise ValueError("Invalid value for `description_of_work`, must not be `None`")  # noqa: E501

        self._description_of_work = description_of_work

    @property
    def project_reference_number(self):
        """Gets the project_reference_number of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The project_reference_number of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._project_reference_number

    @project_reference_number.setter
    def project_reference_number(self, project_reference_number):
        """Sets the project_reference_number of this ForwardPlanCreateRequest.

        Max length 100 characters  # noqa: E501

        :param project_reference_number: The project_reference_number of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._project_reference_number = project_reference_number

    @property
    def traffic_management_type(self):
        """Gets the traffic_management_type of this ForwardPlanCreateRequest.  # noqa: E501


        :return: The traffic_management_type of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: AllOfForwardPlanCreateRequestTrafficManagementType
        """
        return self._traffic_management_type

    @traffic_management_type.setter
    def traffic_management_type(self, traffic_management_type):
        """Sets the traffic_management_type of this ForwardPlanCreateRequest.


        :param traffic_management_type: The traffic_management_type of this ForwardPlanCreateRequest.  # noqa: E501
        :type: AllOfForwardPlanCreateRequestTrafficManagementType
        """

        self._traffic_management_type = traffic_management_type

    @property
    def additional_info(self):
        """Gets the additional_info of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The additional_info of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info):
        """Sets the additional_info of this ForwardPlanCreateRequest.

        Max length 500 characters  # noqa: E501

        :param additional_info: The additional_info of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_info = additional_info

    @property
    def forward_plan_asds(self):
        """Gets the forward_plan_asds of this ForwardPlanCreateRequest.  # noqa: E501


        :return: The forward_plan_asds of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: list[PermitASD]
        """
        return self._forward_plan_asds

    @forward_plan_asds.setter
    def forward_plan_asds(self, forward_plan_asds):
        """Sets the forward_plan_asds of this ForwardPlanCreateRequest.


        :param forward_plan_asds: The forward_plan_asds of this ForwardPlanCreateRequest.  # noqa: E501
        :type: list[PermitASD]
        """

        self._forward_plan_asds = forward_plan_asds

    @property
    def works_location_description(self):
        """Gets the works_location_description of this ForwardPlanCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The works_location_description of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._works_location_description

    @works_location_description.setter
    def works_location_description(self, works_location_description):
        """Sets the works_location_description of this ForwardPlanCreateRequest.

        Max length 500 characters  # noqa: E501

        :param works_location_description: The works_location_description of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """
        if works_location_description is None:
            raise ValueError("Invalid value for `works_location_description`, must not be `None`")  # noqa: E501

        self._works_location_description = works_location_description

    @property
    def workstream_prefix(self):
        """Gets the workstream_prefix of this ForwardPlanCreateRequest.  # noqa: E501

        Must consist of 3 positive whole numbers  # noqa: E501

        :return: The workstream_prefix of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._workstream_prefix

    @workstream_prefix.setter
    def workstream_prefix(self, workstream_prefix):
        """Sets the workstream_prefix of this ForwardPlanCreateRequest.

        Must consist of 3 positive whole numbers  # noqa: E501

        :param workstream_prefix: The workstream_prefix of this ForwardPlanCreateRequest.  # noqa: E501
        :type: str
        """

        self._workstream_prefix = workstream_prefix

    @property
    def hs2_work_type(self):
        """Gets the hs2_work_type of this ForwardPlanCreateRequest.  # noqa: E501

        Required if promoter_swa_code = '7374'  # noqa: E501

        :return: The hs2_work_type of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: AllOfForwardPlanCreateRequestHs2WorkType
        """
        return self._hs2_work_type

    @hs2_work_type.setter
    def hs2_work_type(self, hs2_work_type):
        """Sets the hs2_work_type of this ForwardPlanCreateRequest.

        Required if promoter_swa_code = '7374'  # noqa: E501

        :param hs2_work_type: The hs2_work_type of this ForwardPlanCreateRequest.  # noqa: E501
        :type: AllOfForwardPlanCreateRequestHs2WorkType
        """

        self._hs2_work_type = hs2_work_type

    @property
    def hs2_in_act_limits(self):
        """Gets the hs2_in_act_limits of this ForwardPlanCreateRequest.  # noqa: E501

        Required if promoter_swa_code = '7374'  # noqa: E501

        :return: The hs2_in_act_limits of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._hs2_in_act_limits

    @hs2_in_act_limits.setter
    def hs2_in_act_limits(self, hs2_in_act_limits):
        """Sets the hs2_in_act_limits of this ForwardPlanCreateRequest.

        Required if promoter_swa_code = '7374'  # noqa: E501

        :param hs2_in_act_limits: The hs2_in_act_limits of this ForwardPlanCreateRequest.  # noqa: E501
        :type: bool
        """

        self._hs2_in_act_limits = hs2_in_act_limits

    @property
    def hs2_consultation_requested_response_date(self):
        """Gets the hs2_consultation_requested_response_date of this ForwardPlanCreateRequest.  # noqa: E501

        Date must occur today or a date in the future  # noqa: E501

        :return: The hs2_consultation_requested_response_date of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._hs2_consultation_requested_response_date

    @hs2_consultation_requested_response_date.setter
    def hs2_consultation_requested_response_date(self, hs2_consultation_requested_response_date):
        """Sets the hs2_consultation_requested_response_date of this ForwardPlanCreateRequest.

        Date must occur today or a date in the future  # noqa: E501

        :param hs2_consultation_requested_response_date: The hs2_consultation_requested_response_date of this ForwardPlanCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._hs2_consultation_requested_response_date = hs2_consultation_requested_response_date

    @property
    def hs2_highway_exemption(self):
        """Gets the hs2_highway_exemption of this ForwardPlanCreateRequest.  # noqa: E501

        Required if hs2_work_type = 'hs2_highway_works' and hs2_in_act_limits = true  # noqa: E501

        :return: The hs2_highway_exemption of this ForwardPlanCreateRequest.  # noqa: E501
        :rtype: AllOfForwardPlanCreateRequestHs2HighwayExemption
        """
        return self._hs2_highway_exemption

    @hs2_highway_exemption.setter
    def hs2_highway_exemption(self, hs2_highway_exemption):
        """Sets the hs2_highway_exemption of this ForwardPlanCreateRequest.

        Required if hs2_work_type = 'hs2_highway_works' and hs2_in_act_limits = true  # noqa: E501

        :param hs2_highway_exemption: The hs2_highway_exemption of this ForwardPlanCreateRequest.  # noqa: E501
        :type: AllOfForwardPlanCreateRequestHs2HighwayExemption
        """

        self._hs2_highway_exemption = hs2_highway_exemption

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ForwardPlanCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ForwardPlanCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
