# coding: utf-8

"""
    Street Manager API

    See API specification Resource Guide > Work API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class InspectionCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'internal_user_identifier': 'str',
        'internal_user_name': 'str',
        'inspection_type': 'InspectionType',
        'inspection_start_date': 'datetime',
        'inspection_category': 'AllOfInspectionCreateRequestInspectionCategory',
        'inspection_outcome': 'InspectionOutcome',
        'failure_reason_details': 'list[FailureReasonDetails]',
        'inspection_outcome_details': 'str',
        'was_call_logged': 'bool',
        'call_logged_to': 'str',
        'call_logged_reference': 'str',
        'call_logged_summary': 'str',
        'defect_fixed_on_site': 'AllOfInspectionCreateRequestDefectFixedOnSite',
        'additional_comments': 'str',
        'inspection_evidence': 'bool',
        'file_ids': 'list[float]',
        'reinspection_date': 'datetime',
        'reinspection_date_time': 'datetime',
        'reinspection_type': 'AllOfInspectionCreateRequestReinspectionType',
        'reinspection_category': 'AllOfInspectionCreateRequestReinspectionCategory',
        'username': 'str',
        'inspector_name': 'str',
        'made_safe_by_ha': 'bool',
        'non_compliance_reference_number': 'str'
    }

    attribute_map = {
        'internal_user_identifier': 'internal_user_identifier',
        'internal_user_name': 'internal_user_name',
        'inspection_type': 'inspection_type',
        'inspection_start_date': 'inspection_start_date',
        'inspection_category': 'inspection_category',
        'inspection_outcome': 'inspection_outcome',
        'failure_reason_details': 'failure_reason_details',
        'inspection_outcome_details': 'inspection_outcome_details',
        'was_call_logged': 'was_call_logged',
        'call_logged_to': 'call_logged_to',
        'call_logged_reference': 'call_logged_reference',
        'call_logged_summary': 'call_logged_summary',
        'defect_fixed_on_site': 'defect_fixed_on_site',
        'additional_comments': 'additional_comments',
        'inspection_evidence': 'inspection_evidence',
        'file_ids': 'file_ids',
        'reinspection_date': 'reinspection_date',
        'reinspection_date_time': 'reinspection_date_time',
        'reinspection_type': 'reinspection_type',
        'reinspection_category': 'reinspection_category',
        'username': 'username',
        'inspector_name': 'inspector_name',
        'made_safe_by_ha': 'made_safe_by_ha',
        'non_compliance_reference_number': 'non_compliance_reference_number'
    }

    def __init__(self, internal_user_identifier=None, internal_user_name=None, inspection_type=None, inspection_start_date=None, inspection_category=None, inspection_outcome=None, failure_reason_details=None, inspection_outcome_details=None, was_call_logged=None, call_logged_to=None, call_logged_reference=None, call_logged_summary=None, defect_fixed_on_site=None, additional_comments=None, inspection_evidence=None, file_ids=None, reinspection_date=None, reinspection_date_time=None, reinspection_type=None, reinspection_category=None, username=None, inspector_name=None, made_safe_by_ha=None, non_compliance_reference_number=None):  # noqa: E501
        """InspectionCreateRequest - a model defined in Swagger"""  # noqa: E501
        self._internal_user_identifier = None
        self._internal_user_name = None
        self._inspection_type = None
        self._inspection_start_date = None
        self._inspection_category = None
        self._inspection_outcome = None
        self._failure_reason_details = None
        self._inspection_outcome_details = None
        self._was_call_logged = None
        self._call_logged_to = None
        self._call_logged_reference = None
        self._call_logged_summary = None
        self._defect_fixed_on_site = None
        self._additional_comments = None
        self._inspection_evidence = None
        self._file_ids = None
        self._reinspection_date = None
        self._reinspection_date_time = None
        self._reinspection_type = None
        self._reinspection_category = None
        self._username = None
        self._inspector_name = None
        self._made_safe_by_ha = None
        self._non_compliance_reference_number = None
        self.discriminator = None
        if internal_user_identifier is not None:
            self.internal_user_identifier = internal_user_identifier
        if internal_user_name is not None:
            self.internal_user_name = internal_user_name
        self.inspection_type = inspection_type
        self.inspection_start_date = inspection_start_date
        if inspection_category is not None:
            self.inspection_category = inspection_category
        self.inspection_outcome = inspection_outcome
        if failure_reason_details is not None:
            self.failure_reason_details = failure_reason_details
        if inspection_outcome_details is not None:
            self.inspection_outcome_details = inspection_outcome_details
        if was_call_logged is not None:
            self.was_call_logged = was_call_logged
        if call_logged_to is not None:
            self.call_logged_to = call_logged_to
        if call_logged_reference is not None:
            self.call_logged_reference = call_logged_reference
        if call_logged_summary is not None:
            self.call_logged_summary = call_logged_summary
        if defect_fixed_on_site is not None:
            self.defect_fixed_on_site = defect_fixed_on_site
        if additional_comments is not None:
            self.additional_comments = additional_comments
        self.inspection_evidence = inspection_evidence
        if file_ids is not None:
            self.file_ids = file_ids
        if reinspection_date is not None:
            self.reinspection_date = reinspection_date
        if reinspection_date_time is not None:
            self.reinspection_date_time = reinspection_date_time
        if reinspection_type is not None:
            self.reinspection_type = reinspection_type
        if reinspection_category is not None:
            self.reinspection_category = reinspection_category
        self.username = username
        if inspector_name is not None:
            self.inspector_name = inspector_name
        if made_safe_by_ha is not None:
            self.made_safe_by_ha = made_safe_by_ha
        if non_compliance_reference_number is not None:
            self.non_compliance_reference_number = non_compliance_reference_number

    @property
    def internal_user_identifier(self):
        """Gets the internal_user_identifier of this InspectionCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_identifier of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_identifier

    @internal_user_identifier.setter
    def internal_user_identifier(self, internal_user_identifier):
        """Sets the internal_user_identifier of this InspectionCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_identifier: The internal_user_identifier of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_identifier = internal_user_identifier

    @property
    def internal_user_name(self):
        """Gets the internal_user_name of this InspectionCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_name of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_name

    @internal_user_name.setter
    def internal_user_name(self, internal_user_name):
        """Sets the internal_user_name of this InspectionCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_name: The internal_user_name of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_name = internal_user_name

    @property
    def inspection_type(self):
        """Gets the inspection_type of this InspectionCreateRequest.  # noqa: E501


        :return: The inspection_type of this InspectionCreateRequest.  # noqa: E501
        :rtype: InspectionType
        """
        return self._inspection_type

    @inspection_type.setter
    def inspection_type(self, inspection_type):
        """Sets the inspection_type of this InspectionCreateRequest.


        :param inspection_type: The inspection_type of this InspectionCreateRequest.  # noqa: E501
        :type: InspectionType
        """
        if inspection_type is None:
            raise ValueError("Invalid value for `inspection_type`, must not be `None`")  # noqa: E501

        self._inspection_type = inspection_type

    @property
    def inspection_start_date(self):
        """Gets the inspection_start_date of this InspectionCreateRequest.  # noqa: E501

        inspection_start_date must be in the past  # noqa: E501

        :return: The inspection_start_date of this InspectionCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._inspection_start_date

    @inspection_start_date.setter
    def inspection_start_date(self, inspection_start_date):
        """Sets the inspection_start_date of this InspectionCreateRequest.

        inspection_start_date must be in the past  # noqa: E501

        :param inspection_start_date: The inspection_start_date of this InspectionCreateRequest.  # noqa: E501
        :type: datetime
        """
        if inspection_start_date is None:
            raise ValueError("Invalid value for `inspection_start_date`, must not be `None`")  # noqa: E501

        self._inspection_start_date = inspection_start_date

    @property
    def inspection_category(self):
        """Gets the inspection_category of this InspectionCreateRequest.  # noqa: E501

        See business rules section 10.2 - Inspection types and categories  # noqa: E501

        :return: The inspection_category of this InspectionCreateRequest.  # noqa: E501
        :rtype: AllOfInspectionCreateRequestInspectionCategory
        """
        return self._inspection_category

    @inspection_category.setter
    def inspection_category(self, inspection_category):
        """Sets the inspection_category of this InspectionCreateRequest.

        See business rules section 10.2 - Inspection types and categories  # noqa: E501

        :param inspection_category: The inspection_category of this InspectionCreateRequest.  # noqa: E501
        :type: AllOfInspectionCreateRequestInspectionCategory
        """

        self._inspection_category = inspection_category

    @property
    def inspection_outcome(self):
        """Gets the inspection_outcome of this InspectionCreateRequest.  # noqa: E501


        :return: The inspection_outcome of this InspectionCreateRequest.  # noqa: E501
        :rtype: InspectionOutcome
        """
        return self._inspection_outcome

    @inspection_outcome.setter
    def inspection_outcome(self, inspection_outcome):
        """Sets the inspection_outcome of this InspectionCreateRequest.


        :param inspection_outcome: The inspection_outcome of this InspectionCreateRequest.  # noqa: E501
        :type: InspectionOutcome
        """
        if inspection_outcome is None:
            raise ValueError("Invalid value for `inspection_outcome`, must not be `None`")  # noqa: E501

        self._inspection_outcome = inspection_outcome

    @property
    def failure_reason_details(self):
        """Gets the failure_reason_details of this InspectionCreateRequest.  # noqa: E501

        See business rules section 10.3 - Inspection outcomes  # noqa: E501

        :return: The failure_reason_details of this InspectionCreateRequest.  # noqa: E501
        :rtype: list[FailureReasonDetails]
        """
        return self._failure_reason_details

    @failure_reason_details.setter
    def failure_reason_details(self, failure_reason_details):
        """Sets the failure_reason_details of this InspectionCreateRequest.

        See business rules section 10.3 - Inspection outcomes  # noqa: E501

        :param failure_reason_details: The failure_reason_details of this InspectionCreateRequest.  # noqa: E501
        :type: list[FailureReasonDetails]
        """

        self._failure_reason_details = failure_reason_details

    @property
    def inspection_outcome_details(self):
        """Gets the inspection_outcome_details of this InspectionCreateRequest.  # noqa: E501

        Required if inspection_outcome = unable_to_complete_inspection or non_compliant_with_conditions Max length 500 characters  # noqa: E501

        :return: The inspection_outcome_details of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._inspection_outcome_details

    @inspection_outcome_details.setter
    def inspection_outcome_details(self, inspection_outcome_details):
        """Sets the inspection_outcome_details of this InspectionCreateRequest.

        Required if inspection_outcome = unable_to_complete_inspection or non_compliant_with_conditions Max length 500 characters  # noqa: E501

        :param inspection_outcome_details: The inspection_outcome_details of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._inspection_outcome_details = inspection_outcome_details

    @property
    def was_call_logged(self):
        """Gets the was_call_logged of this InspectionCreateRequest.  # noqa: E501

        Required if inspection_outcome = failed_high and inspection_type = live_site  # noqa: E501

        :return: The was_call_logged of this InspectionCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._was_call_logged

    @was_call_logged.setter
    def was_call_logged(self, was_call_logged):
        """Sets the was_call_logged of this InspectionCreateRequest.

        Required if inspection_outcome = failed_high and inspection_type = live_site  # noqa: E501

        :param was_call_logged: The was_call_logged of this InspectionCreateRequest.  # noqa: E501
        :type: bool
        """

        self._was_call_logged = was_call_logged

    @property
    def call_logged_to(self):
        """Gets the call_logged_to of this InspectionCreateRequest.  # noqa: E501

        Required if was_call_logged = true Max length 100 characters  # noqa: E501

        :return: The call_logged_to of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._call_logged_to

    @call_logged_to.setter
    def call_logged_to(self, call_logged_to):
        """Sets the call_logged_to of this InspectionCreateRequest.

        Required if was_call_logged = true Max length 100 characters  # noqa: E501

        :param call_logged_to: The call_logged_to of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._call_logged_to = call_logged_to

    @property
    def call_logged_reference(self):
        """Gets the call_logged_reference of this InspectionCreateRequest.  # noqa: E501

        Required if was_call_logged = true Max length 100 characters  # noqa: E501

        :return: The call_logged_reference of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._call_logged_reference

    @call_logged_reference.setter
    def call_logged_reference(self, call_logged_reference):
        """Sets the call_logged_reference of this InspectionCreateRequest.

        Required if was_call_logged = true Max length 100 characters  # noqa: E501

        :param call_logged_reference: The call_logged_reference of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._call_logged_reference = call_logged_reference

    @property
    def call_logged_summary(self):
        """Gets the call_logged_summary of this InspectionCreateRequest.  # noqa: E501

        Required if was_call_logged = true Max length 500 characters  # noqa: E501

        :return: The call_logged_summary of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._call_logged_summary

    @call_logged_summary.setter
    def call_logged_summary(self, call_logged_summary):
        """Sets the call_logged_summary of this InspectionCreateRequest.

        Required if was_call_logged = true Max length 500 characters  # noqa: E501

        :param call_logged_summary: The call_logged_summary of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._call_logged_summary = call_logged_summary

    @property
    def defect_fixed_on_site(self):
        """Gets the defect_fixed_on_site of this InspectionCreateRequest.  # noqa: E501

        Required if inspection_outcome = failed_high and inspection_type = live_site  # noqa: E501

        :return: The defect_fixed_on_site of this InspectionCreateRequest.  # noqa: E501
        :rtype: AllOfInspectionCreateRequestDefectFixedOnSite
        """
        return self._defect_fixed_on_site

    @defect_fixed_on_site.setter
    def defect_fixed_on_site(self, defect_fixed_on_site):
        """Sets the defect_fixed_on_site of this InspectionCreateRequest.

        Required if inspection_outcome = failed_high and inspection_type = live_site  # noqa: E501

        :param defect_fixed_on_site: The defect_fixed_on_site of this InspectionCreateRequest.  # noqa: E501
        :type: AllOfInspectionCreateRequestDefectFixedOnSite
        """

        self._defect_fixed_on_site = defect_fixed_on_site

    @property
    def additional_comments(self):
        """Gets the additional_comments of this InspectionCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The additional_comments of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_comments

    @additional_comments.setter
    def additional_comments(self, additional_comments):
        """Sets the additional_comments of this InspectionCreateRequest.

        Max length 500 characters  # noqa: E501

        :param additional_comments: The additional_comments of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_comments = additional_comments

    @property
    def inspection_evidence(self):
        """Gets the inspection_evidence of this InspectionCreateRequest.  # noqa: E501


        :return: The inspection_evidence of this InspectionCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._inspection_evidence

    @inspection_evidence.setter
    def inspection_evidence(self, inspection_evidence):
        """Sets the inspection_evidence of this InspectionCreateRequest.


        :param inspection_evidence: The inspection_evidence of this InspectionCreateRequest.  # noqa: E501
        :type: bool
        """
        if inspection_evidence is None:
            raise ValueError("Invalid value for `inspection_evidence`, must not be `None`")  # noqa: E501

        self._inspection_evidence = inspection_evidence

    @property
    def file_ids(self):
        """Gets the file_ids of this InspectionCreateRequest.  # noqa: E501

        Required if inspection_evidence = true Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :return: The file_ids of this InspectionCreateRequest.  # noqa: E501
        :rtype: list[float]
        """
        return self._file_ids

    @file_ids.setter
    def file_ids(self, file_ids):
        """Sets the file_ids of this InspectionCreateRequest.

        Required if inspection_evidence = true Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :param file_ids: The file_ids of this InspectionCreateRequest.  # noqa: E501
        :type: list[float]
        """

        self._file_ids = file_ids

    @property
    def reinspection_date(self):
        """Gets the reinspection_date of this InspectionCreateRequest.  # noqa: E501

        Date must occur today or a date in the future  # noqa: E501

        :return: The reinspection_date of this InspectionCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._reinspection_date

    @reinspection_date.setter
    def reinspection_date(self, reinspection_date):
        """Sets the reinspection_date of this InspectionCreateRequest.

        Date must occur today or a date in the future  # noqa: E501

        :param reinspection_date: The reinspection_date of this InspectionCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._reinspection_date = reinspection_date

    @property
    def reinspection_date_time(self):
        """Gets the reinspection_date_time of this InspectionCreateRequest.  # noqa: E501

        The date for reinspection_date_time must match the date for reinspection_date Time must occur today or a date in the future  # noqa: E501

        :return: The reinspection_date_time of this InspectionCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._reinspection_date_time

    @reinspection_date_time.setter
    def reinspection_date_time(self, reinspection_date_time):
        """Sets the reinspection_date_time of this InspectionCreateRequest.

        The date for reinspection_date_time must match the date for reinspection_date Time must occur today or a date in the future  # noqa: E501

        :param reinspection_date_time: The reinspection_date_time of this InspectionCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._reinspection_date_time = reinspection_date_time

    @property
    def reinspection_type(self):
        """Gets the reinspection_type of this InspectionCreateRequest.  # noqa: E501

        Defaulted to inspection_type value if this and/or reinspection_category are not provided and reinspection_date is provided  # noqa: E501

        :return: The reinspection_type of this InspectionCreateRequest.  # noqa: E501
        :rtype: AllOfInspectionCreateRequestReinspectionType
        """
        return self._reinspection_type

    @reinspection_type.setter
    def reinspection_type(self, reinspection_type):
        """Sets the reinspection_type of this InspectionCreateRequest.

        Defaulted to inspection_type value if this and/or reinspection_category are not provided and reinspection_date is provided  # noqa: E501

        :param reinspection_type: The reinspection_type of this InspectionCreateRequest.  # noqa: E501
        :type: AllOfInspectionCreateRequestReinspectionType
        """

        self._reinspection_type = reinspection_type

    @property
    def reinspection_category(self):
        """Gets the reinspection_category of this InspectionCreateRequest.  # noqa: E501

        See business rules section 10.2 - Inspection types and categories Defaulted to inspection_category value if this and/or reinspection_type are not provided and reinspection_date is provided  # noqa: E501

        :return: The reinspection_category of this InspectionCreateRequest.  # noqa: E501
        :rtype: AllOfInspectionCreateRequestReinspectionCategory
        """
        return self._reinspection_category

    @reinspection_category.setter
    def reinspection_category(self, reinspection_category):
        """Sets the reinspection_category of this InspectionCreateRequest.

        See business rules section 10.2 - Inspection types and categories Defaulted to inspection_category value if this and/or reinspection_type are not provided and reinspection_date is provided  # noqa: E501

        :param reinspection_category: The reinspection_category of this InspectionCreateRequest.  # noqa: E501
        :type: AllOfInspectionCreateRequestReinspectionCategory
        """

        self._reinspection_category = reinspection_category

    @property
    def username(self):
        """Gets the username of this InspectionCreateRequest.  # noqa: E501

        Max length 100 characters Should be populated with the user creating the inspection  # noqa: E501

        :return: The username of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this InspectionCreateRequest.

        Max length 100 characters Should be populated with the user creating the inspection  # noqa: E501

        :param username: The username of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """
        if username is None:
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self._username = username

    @property
    def inspector_name(self):
        """Gets the inspector_name of this InspectionCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The inspector_name of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._inspector_name

    @inspector_name.setter
    def inspector_name(self, inspector_name):
        """Sets the inspector_name of this InspectionCreateRequest.

        Max length 100 characters  # noqa: E501

        :param inspector_name: The inspector_name of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._inspector_name = inspector_name

    @property
    def made_safe_by_ha(self):
        """Gets the made_safe_by_ha of this InspectionCreateRequest.  # noqa: E501

        Required if inspection_type = section 81 and inspection_outcome = Failed - high or Failed - low  # noqa: E501

        :return: The made_safe_by_ha of this InspectionCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._made_safe_by_ha

    @made_safe_by_ha.setter
    def made_safe_by_ha(self, made_safe_by_ha):
        """Sets the made_safe_by_ha of this InspectionCreateRequest.

        Required if inspection_type = section 81 and inspection_outcome = Failed - high or Failed - low  # noqa: E501

        :param made_safe_by_ha: The made_safe_by_ha of this InspectionCreateRequest.  # noqa: E501
        :type: bool
        """

        self._made_safe_by_ha = made_safe_by_ha

    @property
    def non_compliance_reference_number(self):
        """Gets the non_compliance_reference_number of this InspectionCreateRequest.  # noqa: E501

        Max length 106 characters Created inspection will be linked to an existing non-compliance with this reference number inspection_type must be reinstatement or non_compliance_follow_up  # noqa: E501

        :return: The non_compliance_reference_number of this InspectionCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._non_compliance_reference_number

    @non_compliance_reference_number.setter
    def non_compliance_reference_number(self, non_compliance_reference_number):
        """Sets the non_compliance_reference_number of this InspectionCreateRequest.

        Max length 106 characters Created inspection will be linked to an existing non-compliance with this reference number inspection_type must be reinstatement or non_compliance_follow_up  # noqa: E501

        :param non_compliance_reference_number: The non_compliance_reference_number of this InspectionCreateRequest.  # noqa: E501
        :type: str
        """

        self._non_compliance_reference_number = non_compliance_reference_number

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InspectionCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InspectionCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
