# coding: utf-8

"""
    Street Manager API

    See API specification Resource Guide > Work API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class NonNotifiableSiteCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'internal_user_identifier': 'str',
        'internal_user_name': 'str',
        'promoter_swa_code': 'str',
        'highway_authority_swa_code': 'str',
        'works_coordinates': 'object',
        'street_name': 'str',
        'town': 'str',
        'area_name': 'str',
        'usrn': 'float',
        'road_category': 'float',
        'work_reference_number': 'str',
        'workstream_prefix': 'str',
        'reinstatement_type': 'ReinstatementType',
        'reinstatement_status': 'ReinstatementStatus',
        'reinstatement_date': 'datetime',
        'reinstatement_coordinates': 'object',
        'secondary_reinstatement_coordinates': 'object',
        'location_description': 'str',
        'location_types': 'list[LocationType]',
        'reinstatement_evidence': 'bool',
        'file_ids': 'list[float]',
        'number_of_holes': 'float'
    }

    attribute_map = {
        'internal_user_identifier': 'internal_user_identifier',
        'internal_user_name': 'internal_user_name',
        'promoter_swa_code': 'promoter_swa_code',
        'highway_authority_swa_code': 'highway_authority_swa_code',
        'works_coordinates': 'works_coordinates',
        'street_name': 'street_name',
        'town': 'town',
        'area_name': 'area_name',
        'usrn': 'usrn',
        'road_category': 'road_category',
        'work_reference_number': 'work_reference_number',
        'workstream_prefix': 'workstream_prefix',
        'reinstatement_type': 'reinstatement_type',
        'reinstatement_status': 'reinstatement_status',
        'reinstatement_date': 'reinstatement_date',
        'reinstatement_coordinates': 'reinstatement_coordinates',
        'secondary_reinstatement_coordinates': 'secondary_reinstatement_coordinates',
        'location_description': 'location_description',
        'location_types': 'location_types',
        'reinstatement_evidence': 'reinstatement_evidence',
        'file_ids': 'file_ids',
        'number_of_holes': 'number_of_holes'
    }

    def __init__(self, internal_user_identifier=None, internal_user_name=None, promoter_swa_code=None, highway_authority_swa_code=None, works_coordinates=None, street_name=None, town=None, area_name=None, usrn=None, road_category=None, work_reference_number=None, workstream_prefix=None, reinstatement_type=None, reinstatement_status=None, reinstatement_date=None, reinstatement_coordinates=None, secondary_reinstatement_coordinates=None, location_description=None, location_types=None, reinstatement_evidence=None, file_ids=None, number_of_holes=None):  # noqa: E501
        """NonNotifiableSiteCreateRequest - a model defined in Swagger"""  # noqa: E501
        self._internal_user_identifier = None
        self._internal_user_name = None
        self._promoter_swa_code = None
        self._highway_authority_swa_code = None
        self._works_coordinates = None
        self._street_name = None
        self._town = None
        self._area_name = None
        self._usrn = None
        self._road_category = None
        self._work_reference_number = None
        self._workstream_prefix = None
        self._reinstatement_type = None
        self._reinstatement_status = None
        self._reinstatement_date = None
        self._reinstatement_coordinates = None
        self._secondary_reinstatement_coordinates = None
        self._location_description = None
        self._location_types = None
        self._reinstatement_evidence = None
        self._file_ids = None
        self._number_of_holes = None
        self.discriminator = None
        if internal_user_identifier is not None:
            self.internal_user_identifier = internal_user_identifier
        if internal_user_name is not None:
            self.internal_user_name = internal_user_name
        self.promoter_swa_code = promoter_swa_code
        self.highway_authority_swa_code = highway_authority_swa_code
        self.works_coordinates = works_coordinates
        if street_name is not None:
            self.street_name = street_name
        if town is not None:
            self.town = town
        if area_name is not None:
            self.area_name = area_name
        self.usrn = usrn
        if road_category is not None:
            self.road_category = road_category
        if work_reference_number is not None:
            self.work_reference_number = work_reference_number
        if workstream_prefix is not None:
            self.workstream_prefix = workstream_prefix
        self.reinstatement_type = reinstatement_type
        self.reinstatement_status = reinstatement_status
        self.reinstatement_date = reinstatement_date
        self.reinstatement_coordinates = reinstatement_coordinates
        if secondary_reinstatement_coordinates is not None:
            self.secondary_reinstatement_coordinates = secondary_reinstatement_coordinates
        self.location_description = location_description
        self.location_types = location_types
        self.reinstatement_evidence = reinstatement_evidence
        if file_ids is not None:
            self.file_ids = file_ids
        self.number_of_holes = number_of_holes

    @property
    def internal_user_identifier(self):
        """Gets the internal_user_identifier of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_identifier of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_identifier

    @internal_user_identifier.setter
    def internal_user_identifier(self, internal_user_identifier):
        """Sets the internal_user_identifier of this NonNotifiableSiteCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_identifier: The internal_user_identifier of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_identifier = internal_user_identifier

    @property
    def internal_user_name(self):
        """Gets the internal_user_name of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_name of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_name

    @internal_user_name.setter
    def internal_user_name(self, internal_user_name):
        """Sets the internal_user_name of this NonNotifiableSiteCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_name: The internal_user_name of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_name = internal_user_name

    @property
    def promoter_swa_code(self):
        """Gets the promoter_swa_code of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 4 characters  # noqa: E501

        :return: The promoter_swa_code of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._promoter_swa_code

    @promoter_swa_code.setter
    def promoter_swa_code(self, promoter_swa_code):
        """Sets the promoter_swa_code of this NonNotifiableSiteCreateRequest.

        Max length 4 characters  # noqa: E501

        :param promoter_swa_code: The promoter_swa_code of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """
        if promoter_swa_code is None:
            raise ValueError("Invalid value for `promoter_swa_code`, must not be `None`")  # noqa: E501

        self._promoter_swa_code = promoter_swa_code

    @property
    def highway_authority_swa_code(self):
        """Gets the highway_authority_swa_code of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 4 characters  # noqa: E501

        :return: The highway_authority_swa_code of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._highway_authority_swa_code

    @highway_authority_swa_code.setter
    def highway_authority_swa_code(self, highway_authority_swa_code):
        """Sets the highway_authority_swa_code of this NonNotifiableSiteCreateRequest.

        Max length 4 characters  # noqa: E501

        :param highway_authority_swa_code: The highway_authority_swa_code of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """
        if highway_authority_swa_code is None:
            raise ValueError("Invalid value for `highway_authority_swa_code`, must not be `None`")  # noqa: E501

        self._highway_authority_swa_code = highway_authority_swa_code

    @property
    def works_coordinates(self):
        """Gets the works_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :return: The works_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: object
        """
        return self._works_coordinates

    @works_coordinates.setter
    def works_coordinates(self, works_coordinates):
        """Sets the works_coordinates of this NonNotifiableSiteCreateRequest.

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :param works_coordinates: The works_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: object
        """
        if works_coordinates is None:
            raise ValueError("Invalid value for `works_coordinates`, must not be `None`")  # noqa: E501

        self._works_coordinates = works_coordinates

    @property
    def street_name(self):
        """Gets the street_name of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The street_name of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._street_name

    @street_name.setter
    def street_name(self, street_name):
        """Sets the street_name of this NonNotifiableSiteCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param street_name: The street_name of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """

        self._street_name = street_name

    @property
    def town(self):
        """Gets the town of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The town of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._town

    @town.setter
    def town(self, town):
        """Sets the town of this NonNotifiableSiteCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param town: The town of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """

        self._town = town

    @property
    def area_name(self):
        """Gets the area_name of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The area_name of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._area_name

    @area_name.setter
    def area_name(self, area_name):
        """Sets the area_name of this NonNotifiableSiteCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param area_name: The area_name of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """

        self._area_name = area_name

    @property
    def usrn(self):
        """Gets the usrn of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Is whole number between 1000001 and 99999999 inclusive See business rules section 1.4 - USRN  # noqa: E501

        :return: The usrn of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._usrn

    @usrn.setter
    def usrn(self, usrn):
        """Sets the usrn of this NonNotifiableSiteCreateRequest.

        Is whole number between 1000001 and 99999999 inclusive See business rules section 1.4 - USRN  # noqa: E501

        :param usrn: The usrn of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: float
        """
        if usrn is None:
            raise ValueError("Invalid value for `usrn`, must not be `None`")  # noqa: E501

        self._usrn = usrn

    @property
    def road_category(self):
        """Gets the road_category of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Is whole number between 0 and 10 inclusive If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The road_category of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._road_category

    @road_category.setter
    def road_category(self, road_category):
        """Sets the road_category of this NonNotifiableSiteCreateRequest.

        Is whole number between 0 and 10 inclusive If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param road_category: The road_category of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: float
        """

        self._road_category = road_category

    @property
    def work_reference_number(self):
        """Gets the work_reference_number of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 24 characters Must be unique in the system Must contain only alphanumeric characters, dashes and underscores If not supplied it will be auto-generated  # noqa: E501

        :return: The work_reference_number of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._work_reference_number

    @work_reference_number.setter
    def work_reference_number(self, work_reference_number):
        """Sets the work_reference_number of this NonNotifiableSiteCreateRequest.

        Max length 24 characters Must be unique in the system Must contain only alphanumeric characters, dashes and underscores If not supplied it will be auto-generated  # noqa: E501

        :param work_reference_number: The work_reference_number of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """

        self._work_reference_number = work_reference_number

    @property
    def workstream_prefix(self):
        """Gets the workstream_prefix of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Must consist of 3 positive whole numbers. Default workstream if not provided  # noqa: E501

        :return: The workstream_prefix of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._workstream_prefix

    @workstream_prefix.setter
    def workstream_prefix(self, workstream_prefix):
        """Sets the workstream_prefix of this NonNotifiableSiteCreateRequest.

        Must consist of 3 positive whole numbers. Default workstream if not provided  # noqa: E501

        :param workstream_prefix: The workstream_prefix of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """

        self._workstream_prefix = workstream_prefix

    @property
    def reinstatement_type(self):
        """Gets the reinstatement_type of this NonNotifiableSiteCreateRequest.  # noqa: E501


        :return: The reinstatement_type of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: ReinstatementType
        """
        return self._reinstatement_type

    @reinstatement_type.setter
    def reinstatement_type(self, reinstatement_type):
        """Sets the reinstatement_type of this NonNotifiableSiteCreateRequest.


        :param reinstatement_type: The reinstatement_type of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: ReinstatementType
        """
        if reinstatement_type is None:
            raise ValueError("Invalid value for `reinstatement_type`, must not be `None`")  # noqa: E501

        self._reinstatement_type = reinstatement_type

    @property
    def reinstatement_status(self):
        """Gets the reinstatement_status of this NonNotifiableSiteCreateRequest.  # noqa: E501


        :return: The reinstatement_status of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: ReinstatementStatus
        """
        return self._reinstatement_status

    @reinstatement_status.setter
    def reinstatement_status(self, reinstatement_status):
        """Sets the reinstatement_status of this NonNotifiableSiteCreateRequest.


        :param reinstatement_status: The reinstatement_status of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: ReinstatementStatus
        """
        if reinstatement_status is None:
            raise ValueError("Invalid value for `reinstatement_status`, must not be `None`")  # noqa: E501

        self._reinstatement_status = reinstatement_status

    @property
    def reinstatement_date(self):
        """Gets the reinstatement_date of this NonNotifiableSiteCreateRequest.  # noqa: E501

        reinstatement_date must be in the past Must be after actual start date Must be before actual end date (if entered)  # noqa: E501

        :return: The reinstatement_date of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._reinstatement_date

    @reinstatement_date.setter
    def reinstatement_date(self, reinstatement_date):
        """Sets the reinstatement_date of this NonNotifiableSiteCreateRequest.

        reinstatement_date must be in the past Must be after actual start date Must be before actual end date (if entered)  # noqa: E501

        :param reinstatement_date: The reinstatement_date of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: datetime
        """
        if reinstatement_date is None:
            raise ValueError("Invalid value for `reinstatement_date`, must not be `None`")  # noqa: E501

        self._reinstatement_date = reinstatement_date

    @property
    def reinstatement_coordinates(self):
        """Gets the reinstatement_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :return: The reinstatement_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: object
        """
        return self._reinstatement_coordinates

    @reinstatement_coordinates.setter
    def reinstatement_coordinates(self, reinstatement_coordinates):
        """Sets the reinstatement_coordinates of this NonNotifiableSiteCreateRequest.

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :param reinstatement_coordinates: The reinstatement_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: object
        """
        if reinstatement_coordinates is None:
            raise ValueError("Invalid value for `reinstatement_coordinates`, must not be `None`")  # noqa: E501

        self._reinstatement_coordinates = reinstatement_coordinates

    @property
    def secondary_reinstatement_coordinates(self):
        """Gets the secondary_reinstatement_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon, if provided  # noqa: E501

        :return: The secondary_reinstatement_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: object
        """
        return self._secondary_reinstatement_coordinates

    @secondary_reinstatement_coordinates.setter
    def secondary_reinstatement_coordinates(self, secondary_reinstatement_coordinates):
        """Sets the secondary_reinstatement_coordinates of this NonNotifiableSiteCreateRequest.

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon, if provided  # noqa: E501

        :param secondary_reinstatement_coordinates: The secondary_reinstatement_coordinates of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: object
        """

        self._secondary_reinstatement_coordinates = secondary_reinstatement_coordinates

    @property
    def location_description(self):
        """Gets the location_description of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The location_description of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._location_description

    @location_description.setter
    def location_description(self, location_description):
        """Sets the location_description of this NonNotifiableSiteCreateRequest.

        Max length 500 characters  # noqa: E501

        :param location_description: The location_description of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: str
        """
        if location_description is None:
            raise ValueError("Invalid value for `location_description`, must not be `None`")  # noqa: E501

        self._location_description = location_description

    @property
    def location_types(self):
        """Gets the location_types of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Array values must be unique Must not contain null or undefined values  # noqa: E501

        :return: The location_types of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: list[LocationType]
        """
        return self._location_types

    @location_types.setter
    def location_types(self, location_types):
        """Sets the location_types of this NonNotifiableSiteCreateRequest.

        Array values must be unique Must not contain null or undefined values  # noqa: E501

        :param location_types: The location_types of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: list[LocationType]
        """
        if location_types is None:
            raise ValueError("Invalid value for `location_types`, must not be `None`")  # noqa: E501

        self._location_types = location_types

    @property
    def reinstatement_evidence(self):
        """Gets the reinstatement_evidence of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Whether reinstatement evidence has been supplied  # noqa: E501

        :return: The reinstatement_evidence of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._reinstatement_evidence

    @reinstatement_evidence.setter
    def reinstatement_evidence(self, reinstatement_evidence):
        """Sets the reinstatement_evidence of this NonNotifiableSiteCreateRequest.

        Whether reinstatement evidence has been supplied  # noqa: E501

        :param reinstatement_evidence: The reinstatement_evidence of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: bool
        """
        if reinstatement_evidence is None:
            raise ValueError("Invalid value for `reinstatement_evidence`, must not be `None`")  # noqa: E501

        self._reinstatement_evidence = reinstatement_evidence

    @property
    def file_ids(self):
        """Gets the file_ids of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Required if reinstatement_evidence = true Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :return: The file_ids of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: list[float]
        """
        return self._file_ids

    @file_ids.setter
    def file_ids(self, file_ids):
        """Sets the file_ids of this NonNotifiableSiteCreateRequest.

        Required if reinstatement_evidence = true Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :param file_ids: The file_ids of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: list[float]
        """

        self._file_ids = file_ids

    @property
    def number_of_holes(self):
        """Gets the number_of_holes of this NonNotifiableSiteCreateRequest.  # noqa: E501

        Must be a number between 0 and 100  # noqa: E501

        :return: The number_of_holes of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._number_of_holes

    @number_of_holes.setter
    def number_of_holes(self, number_of_holes):
        """Sets the number_of_holes of this NonNotifiableSiteCreateRequest.

        Must be a number between 0 and 100  # noqa: E501

        :param number_of_holes: The number_of_holes of this NonNotifiableSiteCreateRequest.  # noqa: E501
        :type: float
        """
        if number_of_holes is None:
            raise ValueError("Invalid value for `number_of_holes`, must not be `None`")  # noqa: E501

        self._number_of_holes = number_of_holes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NonNotifiableSiteCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NonNotifiableSiteCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
