# coding: utf-8

"""
    Street Manager API

    See API specification Resource Guide > Work API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ReinstatementCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'internal_user_identifier': 'str',
        'internal_user_name': 'str',
        'reinstatement_status': 'ReinstatementStatus',
        'reinstatement_date': 'datetime',
        'depth': 'float',
        'length': 'float',
        'width': 'float',
        'reinstatement_coordinates': 'object',
        'secondary_reinstatement_coordinates': 'object',
        'location_description': 'str',
        'location_types': 'list[LocationType]',
        'reinstatement_evidence': 'bool',
        'file_ids': 'list[float]',
        'final_reinstatement': 'bool',
        'number_of_holes': 'float',
        'permit_reference_number': 'str',
        'response_to_remedial_works': 'bool',
        'base_courses_affected': 'bool'
    }

    attribute_map = {
        'internal_user_identifier': 'internal_user_identifier',
        'internal_user_name': 'internal_user_name',
        'reinstatement_status': 'reinstatement_status',
        'reinstatement_date': 'reinstatement_date',
        'depth': 'depth',
        'length': 'length',
        'width': 'width',
        'reinstatement_coordinates': 'reinstatement_coordinates',
        'secondary_reinstatement_coordinates': 'secondary_reinstatement_coordinates',
        'location_description': 'location_description',
        'location_types': 'location_types',
        'reinstatement_evidence': 'reinstatement_evidence',
        'file_ids': 'file_ids',
        'final_reinstatement': 'final_reinstatement',
        'number_of_holes': 'number_of_holes',
        'permit_reference_number': 'permit_reference_number',
        'response_to_remedial_works': 'response_to_remedial_works',
        'base_courses_affected': 'base_courses_affected'
    }

    def __init__(self, internal_user_identifier=None, internal_user_name=None, reinstatement_status=None, reinstatement_date=None, depth=None, length=None, width=None, reinstatement_coordinates=None, secondary_reinstatement_coordinates=None, location_description=None, location_types=None, reinstatement_evidence=None, file_ids=None, final_reinstatement=None, number_of_holes=None, permit_reference_number=None, response_to_remedial_works=None, base_courses_affected=None):  # noqa: E501
        """ReinstatementCreateRequest - a model defined in Swagger"""  # noqa: E501
        self._internal_user_identifier = None
        self._internal_user_name = None
        self._reinstatement_status = None
        self._reinstatement_date = None
        self._depth = None
        self._length = None
        self._width = None
        self._reinstatement_coordinates = None
        self._secondary_reinstatement_coordinates = None
        self._location_description = None
        self._location_types = None
        self._reinstatement_evidence = None
        self._file_ids = None
        self._final_reinstatement = None
        self._number_of_holes = None
        self._permit_reference_number = None
        self._response_to_remedial_works = None
        self._base_courses_affected = None
        self.discriminator = None
        if internal_user_identifier is not None:
            self.internal_user_identifier = internal_user_identifier
        if internal_user_name is not None:
            self.internal_user_name = internal_user_name
        self.reinstatement_status = reinstatement_status
        self.reinstatement_date = reinstatement_date
        if depth is not None:
            self.depth = depth
        if length is not None:
            self.length = length
        if width is not None:
            self.width = width
        self.reinstatement_coordinates = reinstatement_coordinates
        if secondary_reinstatement_coordinates is not None:
            self.secondary_reinstatement_coordinates = secondary_reinstatement_coordinates
        self.location_description = location_description
        self.location_types = location_types
        self.reinstatement_evidence = reinstatement_evidence
        if file_ids is not None:
            self.file_ids = file_ids
        if final_reinstatement is not None:
            self.final_reinstatement = final_reinstatement
        if number_of_holes is not None:
            self.number_of_holes = number_of_holes
        if permit_reference_number is not None:
            self.permit_reference_number = permit_reference_number
        if response_to_remedial_works is not None:
            self.response_to_remedial_works = response_to_remedial_works
        if base_courses_affected is not None:
            self.base_courses_affected = base_courses_affected

    @property
    def internal_user_identifier(self):
        """Gets the internal_user_identifier of this ReinstatementCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_identifier of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_identifier

    @internal_user_identifier.setter
    def internal_user_identifier(self, internal_user_identifier):
        """Sets the internal_user_identifier of this ReinstatementCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_identifier: The internal_user_identifier of this ReinstatementCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_identifier = internal_user_identifier

    @property
    def internal_user_name(self):
        """Gets the internal_user_name of this ReinstatementCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_name of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_name

    @internal_user_name.setter
    def internal_user_name(self, internal_user_name):
        """Sets the internal_user_name of this ReinstatementCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_name: The internal_user_name of this ReinstatementCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_name = internal_user_name

    @property
    def reinstatement_status(self):
        """Gets the reinstatement_status of this ReinstatementCreateRequest.  # noqa: E501


        :return: The reinstatement_status of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: ReinstatementStatus
        """
        return self._reinstatement_status

    @reinstatement_status.setter
    def reinstatement_status(self, reinstatement_status):
        """Sets the reinstatement_status of this ReinstatementCreateRequest.


        :param reinstatement_status: The reinstatement_status of this ReinstatementCreateRequest.  # noqa: E501
        :type: ReinstatementStatus
        """
        if reinstatement_status is None:
            raise ValueError("Invalid value for `reinstatement_status`, must not be `None`")  # noqa: E501

        self._reinstatement_status = reinstatement_status

    @property
    def reinstatement_date(self):
        """Gets the reinstatement_date of this ReinstatementCreateRequest.  # noqa: E501

        reinstatement_date must be in the past Must be after actual start date Must be before actual end date (if entered)  # noqa: E501

        :return: The reinstatement_date of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._reinstatement_date

    @reinstatement_date.setter
    def reinstatement_date(self, reinstatement_date):
        """Sets the reinstatement_date of this ReinstatementCreateRequest.

        reinstatement_date must be in the past Must be after actual start date Must be before actual end date (if entered)  # noqa: E501

        :param reinstatement_date: The reinstatement_date of this ReinstatementCreateRequest.  # noqa: E501
        :type: datetime
        """
        if reinstatement_date is None:
            raise ValueError("Invalid value for `reinstatement_date`, must not be `None`")  # noqa: E501

        self._reinstatement_date = reinstatement_date

    @property
    def depth(self):
        """Gets the depth of this ReinstatementCreateRequest.  # noqa: E501

        Is number between 0 and 99.99 inclusive, to two decimal places. Required if reinstatement type is excavation.  # noqa: E501

        :return: The depth of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._depth

    @depth.setter
    def depth(self, depth):
        """Sets the depth of this ReinstatementCreateRequest.

        Is number between 0 and 99.99 inclusive, to two decimal places. Required if reinstatement type is excavation.  # noqa: E501

        :param depth: The depth of this ReinstatementCreateRequest.  # noqa: E501
        :type: float
        """

        self._depth = depth

    @property
    def length(self):
        """Gets the length of this ReinstatementCreateRequest.  # noqa: E501

        Is number between 0 and 9999.99 inclusive, to two decimal places Required if reinstatement type is excavation.  # noqa: E501

        :return: The length of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._length

    @length.setter
    def length(self, length):
        """Sets the length of this ReinstatementCreateRequest.

        Is number between 0 and 9999.99 inclusive, to two decimal places Required if reinstatement type is excavation.  # noqa: E501

        :param length: The length of this ReinstatementCreateRequest.  # noqa: E501
        :type: float
        """

        self._length = length

    @property
    def width(self):
        """Gets the width of this ReinstatementCreateRequest.  # noqa: E501

        Is number between 0 and 99.99 inclusive, to two decimal places Required if reinstatement type is excavation.  # noqa: E501

        :return: The width of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this ReinstatementCreateRequest.

        Is number between 0 and 99.99 inclusive, to two decimal places Required if reinstatement type is excavation.  # noqa: E501

        :param width: The width of this ReinstatementCreateRequest.  # noqa: E501
        :type: float
        """

        self._width = width

    @property
    def reinstatement_coordinates(self):
        """Gets the reinstatement_coordinates of this ReinstatementCreateRequest.  # noqa: E501

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :return: The reinstatement_coordinates of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: object
        """
        return self._reinstatement_coordinates

    @reinstatement_coordinates.setter
    def reinstatement_coordinates(self, reinstatement_coordinates):
        """Sets the reinstatement_coordinates of this ReinstatementCreateRequest.

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :param reinstatement_coordinates: The reinstatement_coordinates of this ReinstatementCreateRequest.  # noqa: E501
        :type: object
        """
        if reinstatement_coordinates is None:
            raise ValueError("Invalid value for `reinstatement_coordinates`, must not be `None`")  # noqa: E501

        self._reinstatement_coordinates = reinstatement_coordinates

    @property
    def secondary_reinstatement_coordinates(self):
        """Gets the secondary_reinstatement_coordinates of this ReinstatementCreateRequest.  # noqa: E501

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon, if provided  # noqa: E501

        :return: The secondary_reinstatement_coordinates of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: object
        """
        return self._secondary_reinstatement_coordinates

    @secondary_reinstatement_coordinates.setter
    def secondary_reinstatement_coordinates(self, secondary_reinstatement_coordinates):
        """Sets the secondary_reinstatement_coordinates of this ReinstatementCreateRequest.

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon, if provided  # noqa: E501

        :param secondary_reinstatement_coordinates: The secondary_reinstatement_coordinates of this ReinstatementCreateRequest.  # noqa: E501
        :type: object
        """

        self._secondary_reinstatement_coordinates = secondary_reinstatement_coordinates

    @property
    def location_description(self):
        """Gets the location_description of this ReinstatementCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The location_description of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._location_description

    @location_description.setter
    def location_description(self, location_description):
        """Sets the location_description of this ReinstatementCreateRequest.

        Max length 500 characters  # noqa: E501

        :param location_description: The location_description of this ReinstatementCreateRequest.  # noqa: E501
        :type: str
        """
        if location_description is None:
            raise ValueError("Invalid value for `location_description`, must not be `None`")  # noqa: E501

        self._location_description = location_description

    @property
    def location_types(self):
        """Gets the location_types of this ReinstatementCreateRequest.  # noqa: E501

        Array values must be unique Must not contain null or undefined values  # noqa: E501

        :return: The location_types of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: list[LocationType]
        """
        return self._location_types

    @location_types.setter
    def location_types(self, location_types):
        """Sets the location_types of this ReinstatementCreateRequest.

        Array values must be unique Must not contain null or undefined values  # noqa: E501

        :param location_types: The location_types of this ReinstatementCreateRequest.  # noqa: E501
        :type: list[LocationType]
        """
        if location_types is None:
            raise ValueError("Invalid value for `location_types`, must not be `None`")  # noqa: E501

        self._location_types = location_types

    @property
    def reinstatement_evidence(self):
        """Gets the reinstatement_evidence of this ReinstatementCreateRequest.  # noqa: E501

        Whether reinstatement evidence has been supplied  # noqa: E501

        :return: The reinstatement_evidence of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._reinstatement_evidence

    @reinstatement_evidence.setter
    def reinstatement_evidence(self, reinstatement_evidence):
        """Sets the reinstatement_evidence of this ReinstatementCreateRequest.

        Whether reinstatement evidence has been supplied  # noqa: E501

        :param reinstatement_evidence: The reinstatement_evidence of this ReinstatementCreateRequest.  # noqa: E501
        :type: bool
        """
        if reinstatement_evidence is None:
            raise ValueError("Invalid value for `reinstatement_evidence`, must not be `None`")  # noqa: E501

        self._reinstatement_evidence = reinstatement_evidence

    @property
    def file_ids(self):
        """Gets the file_ids of this ReinstatementCreateRequest.  # noqa: E501

        Required if reinstatement_evidence = true Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :return: The file_ids of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: list[float]
        """
        return self._file_ids

    @file_ids.setter
    def file_ids(self, file_ids):
        """Sets the file_ids of this ReinstatementCreateRequest.

        Required if reinstatement_evidence = true Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :param file_ids: The file_ids of this ReinstatementCreateRequest.  # noqa: E501
        :type: list[float]
        """

        self._file_ids = file_ids

    @property
    def final_reinstatement(self):
        """Gets the final_reinstatement of this ReinstatementCreateRequest.  # noqa: E501

        Whether it is a final reinstatement Required if reinstatement type is excavation  # noqa: E501

        :return: The final_reinstatement of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._final_reinstatement

    @final_reinstatement.setter
    def final_reinstatement(self, final_reinstatement):
        """Sets the final_reinstatement of this ReinstatementCreateRequest.

        Whether it is a final reinstatement Required if reinstatement type is excavation  # noqa: E501

        :param final_reinstatement: The final_reinstatement of this ReinstatementCreateRequest.  # noqa: E501
        :type: bool
        """

        self._final_reinstatement = final_reinstatement

    @property
    def number_of_holes(self):
        """Gets the number_of_holes of this ReinstatementCreateRequest.  # noqa: E501

        Must be a number between 0 and 100 Required if reinstatement type is not excavation  # noqa: E501

        :return: The number_of_holes of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._number_of_holes

    @number_of_holes.setter
    def number_of_holes(self, number_of_holes):
        """Sets the number_of_holes of this ReinstatementCreateRequest.

        Must be a number between 0 and 100 Required if reinstatement type is not excavation  # noqa: E501

        :param number_of_holes: The number_of_holes of this ReinstatementCreateRequest.  # noqa: E501
        :type: float
        """

        self._number_of_holes = number_of_holes

    @property
    def permit_reference_number(self):
        """Gets the permit_reference_number of this ReinstatementCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The permit_reference_number of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._permit_reference_number

    @permit_reference_number.setter
    def permit_reference_number(self, permit_reference_number):
        """Sets the permit_reference_number of this ReinstatementCreateRequest.

        Max length 100 characters  # noqa: E501

        :param permit_reference_number: The permit_reference_number of this ReinstatementCreateRequest.  # noqa: E501
        :type: str
        """

        self._permit_reference_number = permit_reference_number

    @property
    def response_to_remedial_works(self):
        """Gets the response_to_remedial_works of this ReinstatementCreateRequest.  # noqa: E501

        Must be provided if base_courses_affected is provided  # noqa: E501

        :return: The response_to_remedial_works of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._response_to_remedial_works

    @response_to_remedial_works.setter
    def response_to_remedial_works(self, response_to_remedial_works):
        """Sets the response_to_remedial_works of this ReinstatementCreateRequest.

        Must be provided if base_courses_affected is provided  # noqa: E501

        :param response_to_remedial_works: The response_to_remedial_works of this ReinstatementCreateRequest.  # noqa: E501
        :type: bool
        """

        self._response_to_remedial_works = response_to_remedial_works

    @property
    def base_courses_affected(self):
        """Gets the base_courses_affected of this ReinstatementCreateRequest.  # noqa: E501

        Must be provided if response_to_remedial_works is provided  # noqa: E501

        :return: The base_courses_affected of this ReinstatementCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._base_courses_affected

    @base_courses_affected.setter
    def base_courses_affected(self, base_courses_affected):
        """Sets the base_courses_affected of this ReinstatementCreateRequest.

        Must be provided if response_to_remedial_works is provided  # noqa: E501

        :param base_courses_affected: The base_courses_affected of this ReinstatementCreateRequest.  # noqa: E501
        :type: bool
        """

        self._base_courses_affected = base_courses_affected

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ReinstatementCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReinstatementCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
