"use strict";
(self["webpackChunk_elyra_pipeline_editor_extension"] = self["webpackChunk_elyra_pipeline_editor_extension"] || []).push([["vendors-node_modules_swr_esm_index_js"],{

/***/ "../../node_modules/swr/esm/cache.js":
/*!*******************************************!*\
  !*** ../../node_modules/swr/esm/cache.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _libs_hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./libs/hash */ "../../node_modules/swr/esm/libs/hash.js");

var Cache = /** @class */ (function () {
    function Cache(initialData) {
        if (initialData === void 0) { initialData = {}; }
        this.cache = new Map(Object.entries(initialData));
        this.subs = [];
    }
    Cache.prototype.get = function (key) {
        var _key = this.serializeKey(key)[0];
        return this.cache.get(_key);
    };
    Cache.prototype.set = function (key, value) {
        var _key = this.serializeKey(key)[0];
        this.cache.set(_key, value);
        this.notify();
    };
    Cache.prototype.keys = function () {
        return Array.from(this.cache.keys());
    };
    Cache.prototype.has = function (key) {
        var _key = this.serializeKey(key)[0];
        return this.cache.has(_key);
    };
    Cache.prototype.clear = function () {
        this.cache.clear();
        this.notify();
    };
    Cache.prototype.delete = function (key) {
        var _key = this.serializeKey(key)[0];
        this.cache.delete(_key);
        this.notify();
    };
    // TODO: introduce namespace for the cache
    Cache.prototype.serializeKey = function (key) {
        var args = null;
        if (typeof key === 'function') {
            try {
                key = key();
            }
            catch (err) {
                // dependencies not ready
                key = '';
            }
        }
        if (Array.isArray(key)) {
            // args array
            args = key;
            key = (0,_libs_hash__WEBPACK_IMPORTED_MODULE_0__["default"])(key);
        }
        else {
            // convert null to ''
            key = String(key || '');
        }
        var errorKey = key ? 'err@' + key : '';
        var isValidatingKey = key ? 'validating@' + key : '';
        return [key, args, errorKey, isValidatingKey];
    };
    Cache.prototype.subscribe = function (listener) {
        var _this = this;
        if (typeof listener !== 'function') {
            throw new Error('Expected the listener to be a function.');
        }
        var isSubscribed = true;
        this.subs.push(listener);
        return function () {
            if (!isSubscribed)
                return;
            isSubscribed = false;
            var index = _this.subs.indexOf(listener);
            if (index > -1) {
                _this.subs[index] = _this.subs[_this.subs.length - 1];
                _this.subs.length--;
            }
        };
    };
    // Notify Cache subscribers about a change in the cache
    Cache.prototype.notify = function () {
        for (var _i = 0, _a = this.subs; _i < _a.length; _i++) {
            var listener = _a[_i];
            listener();
        }
    };
    return Cache;
}());
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Cache);


/***/ }),

/***/ "../../node_modules/swr/esm/config.js":
/*!********************************************!*\
  !*** ../../node_modules/swr/esm/config.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cache: () => (/* binding */ cache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var dequal_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dequal/lite */ "../../node_modules/dequal/lite/index.mjs");
/* harmony import */ var _cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cache */ "../../node_modules/swr/esm/cache.js");
/* harmony import */ var _libs_web_preset__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./libs/web-preset */ "../../node_modules/swr/esm/libs/web-preset.js");
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};



// cache
var cache = new _cache__WEBPACK_IMPORTED_MODULE_1__["default"]();
// error retry
function onErrorRetry(_, __, config, revalidate, opts) {
    if (!config.isDocumentVisible()) {
        // if it's hidden, stop
        // it will auto revalidate when focus
        return;
    }
    if (typeof config.errorRetryCount === 'number' &&
        opts.retryCount > config.errorRetryCount) {
        return;
    }
    // exponential backoff
    var count = Math.min(opts.retryCount, 8);
    var timeout = ~~((Math.random() + 0.5) * (1 << count)) * config.errorRetryInterval;
    setTimeout(revalidate, timeout, opts);
}
// client side: need to adjust the config
// based on the browser status
// slow connection (<= 70Kbps)
var slowConnection = typeof window !== 'undefined' &&
    // @ts-ignore
    navigator['connection'] &&
    // @ts-ignore
    ['slow-2g', '2g'].indexOf(navigator['connection'].effectiveType) !== -1;
// config
var defaultConfig = __assign({ 
    // events
    onLoadingSlow: function () { }, onSuccess: function () { }, onError: function () { }, onErrorRetry: onErrorRetry, errorRetryInterval: (slowConnection ? 10 : 5) * 1000, focusThrottleInterval: 5 * 1000, dedupingInterval: 2 * 1000, loadingTimeout: (slowConnection ? 5 : 3) * 1000, refreshInterval: 0, revalidateOnFocus: true, revalidateOnReconnect: true, refreshWhenHidden: false, refreshWhenOffline: false, shouldRetryOnError: true, suspense: false, compare: dequal_lite__WEBPACK_IMPORTED_MODULE_0__.dequal, isPaused: function () { return false; } }, _libs_web_preset__WEBPACK_IMPORTED_MODULE_2__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (defaultConfig);


/***/ }),

/***/ "../../node_modules/swr/esm/env.js":
/*!*****************************************!*\
  !*** ../../node_modules/swr/esm/env.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IS_SERVER: () => (/* binding */ IS_SERVER),
/* harmony export */   rAF: () => (/* binding */ rAF),
/* harmony export */   useIsomorphicLayoutEffect: () => (/* binding */ useIsomorphicLayoutEffect)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

var IS_SERVER = typeof window === 'undefined' ||
    // @ts-ignore
    !!(typeof Deno !== 'undefined' && Deno && Deno.version && Deno.version.deno);
// polyfill for requestAnimationFrame
var rAF = IS_SERVER
    ? null
    : window['requestAnimationFrame']
        ? function (f) { return window['requestAnimationFrame'](f); }
        : function (f) { return setTimeout(f, 1); };
// React currently throws a warning when using useLayoutEffect on the server.
// To get around it, we can conditionally useEffect on the server (no-op) and
// useLayoutEffect in the browser.
var useIsomorphicLayoutEffect = IS_SERVER ? react__WEBPACK_IMPORTED_MODULE_0__.useEffect : react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect;


/***/ }),

/***/ "../../node_modules/swr/esm/index.js":
/*!*******************************************!*\
  !*** ../../node_modules/swr/esm/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SWRConfig: () => (/* reexport safe */ _use_swr__WEBPACK_IMPORTED_MODULE_0__.SWRConfig),
/* harmony export */   cache: () => (/* reexport safe */ _config__WEBPACK_IMPORTED_MODULE_2__.cache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   mutate: () => (/* reexport safe */ _use_swr__WEBPACK_IMPORTED_MODULE_0__.mutate),
/* harmony export */   trigger: () => (/* reexport safe */ _use_swr__WEBPACK_IMPORTED_MODULE_0__.trigger),
/* harmony export */   useSWRInfinite: () => (/* reexport safe */ _use_swr_infinite__WEBPACK_IMPORTED_MODULE_1__.useSWRInfinite)
/* harmony export */ });
/* harmony import */ var _use_swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./use-swr */ "../../node_modules/swr/esm/use-swr.js");
/* harmony import */ var _use_swr_infinite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./use-swr-infinite */ "../../node_modules/swr/esm/use-swr-infinite.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./config */ "../../node_modules/swr/esm/config.js");
// `useSWR` and related APIs

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_use_swr__WEBPACK_IMPORTED_MODULE_0__["default"]);

// `useSWRInfinite`

// Cache related, to be replaced by the new APIs



/***/ }),

/***/ "../../node_modules/swr/esm/libs/hash.js":
/*!***********************************************!*\
  !*** ../../node_modules/swr/esm/libs/hash.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ hash)
/* harmony export */ });
// use WeakMap to store the object->key mapping
// so the objects can be garbage collected.
// WeakMap uses a hashtable under the hood, so the lookup
// complexity is almost O(1).
var table = new WeakMap();
// counter of the key
var counter = 0;
// hashes an array of objects and returns a string
function hash(args) {
    if (!args.length)
        return '';
    var key = 'arg';
    for (var i = 0; i < args.length; ++i) {
        if (args[i] === null) {
            key += '@null';
            continue;
        }
        var _hash = void 0;
        if (typeof args[i] !== 'object' && typeof args[i] !== 'function') {
            // need to consider the case that args[i] is a string:
            // args[i]        _hash
            // "undefined" -> '"undefined"'
            // undefined   -> 'undefined'
            // 123         -> '123'
            // "null"      -> '"null"'
            if (typeof args[i] === 'string') {
                _hash = '"' + args[i] + '"';
            }
            else {
                _hash = String(args[i]);
            }
        }
        else {
            if (!table.has(args[i])) {
                _hash = counter;
                table.set(args[i], counter++);
            }
            else {
                _hash = table.get(args[i]);
            }
        }
        key += '@' + _hash;
    }
    return key;
}


/***/ }),

/***/ "../../node_modules/swr/esm/libs/web-preset.js":
/*!*****************************************************!*\
  !*** ../../node_modules/swr/esm/libs/web-preset.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Due to bug https://bugs.chromium.org/p/chromium/issues/detail?id=678075,
 * it's not reliable to detect if the browser is currently online or offline
 * based on `navigator.onLine`.
 * As a work around, we always assume it's online on first load, and change
 * the status upon `online` or `offline` events.
 */
var online = true;
var isOnline = function () { return online; };
var isDocumentVisible = function () {
    if (typeof document !== 'undefined' &&
        document.visibilityState !== undefined) {
        return document.visibilityState !== 'hidden';
    }
    // always assume it's visible
    return true;
};
var fetcher = function (url) { return fetch(url).then(function (res) { return res.json(); }); };
var registerOnFocus = function (cb) {
    if (typeof window !== 'undefined' &&
        window.addEventListener !== undefined &&
        typeof document !== 'undefined' &&
        document.addEventListener !== undefined) {
        // focus revalidate
        document.addEventListener('visibilitychange', function () { return cb(); }, false);
        window.addEventListener('focus', function () { return cb(); }, false);
    }
};
var registerOnReconnect = function (cb) {
    if (typeof window !== 'undefined' && window.addEventListener !== undefined) {
        // reconnect revalidate
        window.addEventListener('online', function () {
            online = true;
            cb();
        }, false);
        // nothing to revalidate, just update the status
        window.addEventListener('offline', function () { return (online = false); }, false);
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
    isOnline: isOnline,
    isDocumentVisible: isDocumentVisible,
    fetcher: fetcher,
    registerOnFocus: registerOnFocus,
    registerOnReconnect: registerOnReconnect
});


/***/ }),

/***/ "../../node_modules/swr/esm/swr-config-context.js":
/*!********************************************************!*\
  !*** ../../node_modules/swr/esm/swr-config-context.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

var SWRConfigContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});
SWRConfigContext.displayName = 'SWRConfigContext';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SWRConfigContext);


/***/ }),

/***/ "../../node_modules/swr/esm/use-swr-infinite.js":
/*!******************************************************!*\
  !*** ../../node_modules/swr/esm/use-swr-infinite.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useSWRInfinite: () => (/* binding */ useSWRInfinite)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./config */ "../../node_modules/swr/esm/config.js");
/* harmony import */ var _env__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./env */ "../../node_modules/swr/esm/env.js");
/* harmony import */ var _swr_config_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./swr-config-context */ "../../node_modules/swr/esm/swr-config-context.js");
/* harmony import */ var _use_swr__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./use-swr */ "../../node_modules/swr/esm/use-swr.js");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
// TODO: use @ts-expect-error





function useSWRInfinite() {
    var _this = this;
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var getKey = args[0];
    var config = Object.assign({}, _config__WEBPACK_IMPORTED_MODULE_1__["default"], (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_swr_config_context__WEBPACK_IMPORTED_MODULE_3__["default"]), args.length > 2
        ? args[2]
        : args.length === 2 && typeof args[1] === 'object'
            ? args[1]
            : {});
    // in typescript args.length > 2 is not same as args.lenth === 3
    // we do a safe type assertion here
    // args.length === 3
    var fn = (args.length > 2
        ? args[1]
        : args.length === 2 && typeof args[1] === 'function'
            ? args[1]
            : config.fetcher);
    var _a = config.initialSize, initialSize = _a === void 0 ? 1 : _a, _b = config.revalidateAll, revalidateAll = _b === void 0 ? false : _b, _c = config.persistSize, persistSize = _c === void 0 ? false : _c, extraConfig = __rest(config
    // get the serialized key of the first page
    , ["initialSize", "revalidateAll", "persistSize"]);
    // get the serialized key of the first page
    var firstPageKey = null;
    try {
        ;
        firstPageKey = _config__WEBPACK_IMPORTED_MODULE_1__.cache.serializeKey(getKey(0, null))[0];
    }
    catch (err) {
        // not ready
    }
    var rerender = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({})[1];
    // we use cache to pass extra info (context) to fetcher so it can be globally shared
    // here we get the key of the fetcher context cache
    var contextCacheKey = null;
    if (firstPageKey) {
        contextCacheKey = 'ctx@' + firstPageKey;
    }
    // page size is also cached to share the page data between hooks having the same key
    var pageSizeCacheKey = null;
    if (firstPageKey) {
        pageSizeCacheKey = 'len@' + firstPageKey;
    }
    var didMountRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
    var resolvePageSize = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
        var cachedPageSize = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(pageSizeCacheKey);
        return typeof cachedPageSize !== 'undefined' ? cachedPageSize : initialSize;
    }, [pageSizeCacheKey, initialSize]);
    // keep the last page size to restore it with the persistSize option
    var lastPageSizeRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(resolvePageSize());
    // every time the key changes, we reset the page size if it's not persisted
    (0,_env__WEBPACK_IMPORTED_MODULE_2__.useIsomorphicLayoutEffect)(function () {
        if (!didMountRef.current) {
            didMountRef.current = true;
            return;
        }
        // If the key has been changed, we keep the current page size if persistSize is enabled
        _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(pageSizeCacheKey, persistSize ? lastPageSizeRef.current : initialSize);
        // initialSize isn't allowed to change during the lifecycle
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [firstPageKey]);
    // keep the data inside a ref
    var dataRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
    // actual swr of all pages
    var swr = (0,_use_swr__WEBPACK_IMPORTED_MODULE_4__["default"])(firstPageKey ? ['inf', firstPageKey] : null, function () { return __awaiter(_this, void 0, void 0, function () {
        var _a, originalData, force, data, pageSize, previousPageData, i, _b, pageKey, pageArgs, pageData, shouldFetchPage;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    _a = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(contextCacheKey) || {}, originalData = _a.data, force = _a.force;
                    data = [];
                    pageSize = resolvePageSize();
                    previousPageData = null;
                    i = 0;
                    _c.label = 1;
                case 1:
                    if (!(i < pageSize)) return [3 /*break*/, 8];
                    _b = _config__WEBPACK_IMPORTED_MODULE_1__.cache.serializeKey(getKey(i, previousPageData)), pageKey = _b[0], pageArgs = _b[1];
                    if (!pageKey) {
                        // pageKey is falsy, stop fetching next pages
                        return [3 /*break*/, 8];
                    }
                    pageData = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(pageKey);
                    shouldFetchPage = revalidateAll ||
                        force ||
                        typeof pageData === 'undefined' ||
                        (typeof force === 'undefined' &&
                            i === 0 &&
                            typeof dataRef.current !== 'undefined') ||
                        (originalData && !config.compare(originalData[i], pageData));
                    if (!shouldFetchPage) return [3 /*break*/, 6];
                    if (!(pageArgs !== null)) return [3 /*break*/, 3];
                    return [4 /*yield*/, fn.apply(void 0, pageArgs)];
                case 2:
                    pageData = _c.sent();
                    return [3 /*break*/, 5];
                case 3: return [4 /*yield*/, fn(pageKey)];
                case 4:
                    pageData = _c.sent();
                    _c.label = 5;
                case 5:
                    _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(pageKey, pageData);
                    _c.label = 6;
                case 6:
                    data.push(pageData);
                    previousPageData = pageData;
                    _c.label = 7;
                case 7:
                    ++i;
                    return [3 /*break*/, 1];
                case 8:
                    // once we executed the data fetching based on the context, clear the context
                    _config__WEBPACK_IMPORTED_MODULE_1__.cache.delete(contextCacheKey);
                    // return the data
                    return [2 /*return*/, data];
            }
        });
    }); }, extraConfig);
    // update dataRef
    (0,_env__WEBPACK_IMPORTED_MODULE_2__.useIsomorphicLayoutEffect)(function () {
        dataRef.current = swr.data;
    }, [swr.data]);
    var mutate = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (data, shouldRevalidate) {
        if (shouldRevalidate === void 0) { shouldRevalidate = true; }
        if (shouldRevalidate && typeof data !== 'undefined') {
            // we only revalidate the pages that are changed
            var originalData = dataRef.current;
            _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(contextCacheKey, { data: originalData, force: false });
        }
        else if (shouldRevalidate) {
            // calling `mutate()`, we revalidate all pages
            _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(contextCacheKey, { force: true });
        }
        return swr.mutate(data, shouldRevalidate);
    }, 
    // swr.mutate is always the same reference
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [contextCacheKey]);
    // extend the SWR API
    var setSize = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (arg) {
        var size;
        if (typeof arg === 'function') {
            size = arg(resolvePageSize());
        }
        else if (typeof arg === 'number') {
            size = arg;
        }
        if (typeof size === 'number') {
            _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(pageSizeCacheKey, size);
            lastPageSizeRef.current = size;
        }
        rerender({});
        return mutate(function (v) { return v; });
    }, 
    // immutability of rerender is guaranteed by React, but react-hooks/exhaustive-deps doesn't recognize it
    // from `rerender = useState({})[1], so we put rerender here
    [pageSizeCacheKey, resolvePageSize, mutate, rerender]);
    // Use getter functions to avoid unnecessary re-renders caused by triggering all the getters of the returned swr object
    var swrInfinite = { size: resolvePageSize(), setSize: setSize, mutate: mutate };
    Object.defineProperties(swrInfinite, {
        error: {
            get: function () { return swr.error; },
            enumerable: true
        },
        data: {
            get: function () { return swr.data; },
            enumerable: true
        },
        // revalidate will be deprecated in the 1.x release
        // because mutate() covers the same use case of revalidate().
        // This remains only for backward compatibility
        revalidate: {
            get: function () { return swr.revalidate; },
            enumerable: true
        },
        isValidating: {
            get: function () { return swr.isValidating; },
            enumerable: true
        }
    });
    return swrInfinite;
}



/***/ }),

/***/ "../../node_modules/swr/esm/use-swr.js":
/*!*********************************************!*\
  !*** ../../node_modules/swr/esm/use-swr.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SWRConfig: () => (/* binding */ SWRConfig),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   mutate: () => (/* binding */ mutate),
/* harmony export */   trigger: () => (/* binding */ trigger)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./config */ "../../node_modules/swr/esm/config.js");
/* harmony import */ var _env__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./env */ "../../node_modules/swr/esm/env.js");
/* harmony import */ var _swr_config_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./swr-config-context */ "../../node_modules/swr/esm/swr-config-context.js");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
// TODO: use @ts-expect-error




// global state managers
var CONCURRENT_PROMISES = {};
var CONCURRENT_PROMISES_TS = {};
var FOCUS_REVALIDATORS = {};
var RECONNECT_REVALIDATORS = {};
var CACHE_REVALIDATORS = {};
var MUTATION_TS = {};
var MUTATION_END_TS = {};
// generate strictly increasing timestamps
var now = (function () {
    var ts = 0;
    return function () { return ++ts; };
})();
// setup DOM events listeners for `focus` and `reconnect` actions
if (!_env__WEBPACK_IMPORTED_MODULE_2__.IS_SERVER) {
    var revalidate_1 = function (revalidators) {
        if (!_config__WEBPACK_IMPORTED_MODULE_1__["default"].isDocumentVisible() || !_config__WEBPACK_IMPORTED_MODULE_1__["default"].isOnline())
            return;
        for (var key in revalidators) {
            if (revalidators[key][0])
                revalidators[key][0]();
        }
    };
    if (typeof _config__WEBPACK_IMPORTED_MODULE_1__["default"].registerOnFocus === 'function') {
        _config__WEBPACK_IMPORTED_MODULE_1__["default"].registerOnFocus(function () { return revalidate_1(FOCUS_REVALIDATORS); });
    }
    if (typeof _config__WEBPACK_IMPORTED_MODULE_1__["default"].registerOnReconnect === 'function') {
        _config__WEBPACK_IMPORTED_MODULE_1__["default"].registerOnReconnect(function () { return revalidate_1(RECONNECT_REVALIDATORS); });
    }
}
var trigger = function (_key, shouldRevalidate) {
    if (shouldRevalidate === void 0) { shouldRevalidate = true; }
    // we are ignoring the second argument which correspond to the arguments
    // the fetcher will receive when key is an array
    var _a = _config__WEBPACK_IMPORTED_MODULE_1__.cache.serializeKey(_key), key = _a[0], keyErr = _a[2], keyValidating = _a[3];
    if (!key)
        return Promise.resolve();
    var updaters = CACHE_REVALIDATORS[key];
    if (key && updaters) {
        var currentData = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key);
        var currentError = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(keyErr);
        var currentIsValidating = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(keyValidating);
        var promises = [];
        for (var i = 0; i < updaters.length; ++i) {
            promises.push(updaters[i](shouldRevalidate, currentData, currentError, currentIsValidating, i > 0));
        }
        // return new updated value
        return Promise.all(promises).then(function () { return _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key); });
    }
    return Promise.resolve(_config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key));
};
var broadcastState = function (key, data, error, isValidating) {
    var updaters = CACHE_REVALIDATORS[key];
    if (key && updaters) {
        for (var i = 0; i < updaters.length; ++i) {
            updaters[i](false, data, error, isValidating);
        }
    }
};
var mutate = function (_key, _data, shouldRevalidate) {
    if (shouldRevalidate === void 0) { shouldRevalidate = true; }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, key, keyErr, beforeMutationTs, beforeConcurrentPromisesTs, data, error, isAsyncMutation, err_1, shouldAbort, updaters, promises, i;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = _config__WEBPACK_IMPORTED_MODULE_1__.cache.serializeKey(_key), key = _a[0], keyErr = _a[2];
                    if (!key)
                        return [2 /*return*/];
                    // if there is no new data to update, let's just revalidate the key
                    if (typeof _data === 'undefined')
                        return [2 /*return*/, trigger(_key, shouldRevalidate)
                            // update global timestamps
                        ];
                    // update global timestamps
                    MUTATION_TS[key] = now() - 1;
                    MUTATION_END_TS[key] = 0;
                    beforeMutationTs = MUTATION_TS[key];
                    beforeConcurrentPromisesTs = CONCURRENT_PROMISES_TS[key];
                    isAsyncMutation = false;
                    if (_data && typeof _data === 'function') {
                        // `_data` is a function, call it passing current cache value
                        try {
                            _data = _data(_config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key));
                        }
                        catch (err) {
                            // if `_data` function throws an error synchronously, it shouldn't be cached
                            _data = undefined;
                            error = err;
                        }
                    }
                    if (!(_data && typeof _data.then === 'function')) return [3 /*break*/, 5];
                    // `_data` is a promise
                    isAsyncMutation = true;
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, _data];
                case 2:
                    data = _b.sent();
                    return [3 /*break*/, 4];
                case 3:
                    err_1 = _b.sent();
                    error = err_1;
                    return [3 /*break*/, 4];
                case 4: return [3 /*break*/, 6];
                case 5:
                    data = _data;
                    _b.label = 6;
                case 6:
                    shouldAbort = function () {
                        // check if other mutations have occurred since we've started this mutation
                        if (beforeMutationTs !== MUTATION_TS[key] ||
                            beforeConcurrentPromisesTs !== CONCURRENT_PROMISES_TS[key]) {
                            if (error)
                                throw error;
                            return true;
                        }
                    };
                    // if there's a race we don't update cache or broadcast change, just return the data
                    if (shouldAbort())
                        return [2 /*return*/, data];
                    if (typeof data !== 'undefined') {
                        // update cached data
                        _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(key, data);
                    }
                    // always update or reset the error
                    _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(keyErr, error);
                    // reset the timestamp to mark the mutation has ended
                    MUTATION_END_TS[key] = now() - 1;
                    if (!isAsyncMutation) {
                        // we skip broadcasting if there's another mutation happened synchronously
                        if (shouldAbort())
                            return [2 /*return*/, data];
                    }
                    updaters = CACHE_REVALIDATORS[key];
                    if (updaters) {
                        promises = [];
                        for (i = 0; i < updaters.length; ++i) {
                            promises.push(updaters[i](!!shouldRevalidate, data, error, undefined, i > 0));
                        }
                        // return new updated value
                        return [2 /*return*/, Promise.all(promises).then(function () {
                                if (error)
                                    throw error;
                                return _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key);
                            })];
                    }
                    // throw error or return data to be used by caller of mutate
                    if (error)
                        throw error;
                    return [2 /*return*/, data];
            }
        });
    });
};
function useSWR() {
    var _this = this;
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var _key = args[0];
    var config = Object.assign({}, _config__WEBPACK_IMPORTED_MODULE_1__["default"], (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_swr_config_context__WEBPACK_IMPORTED_MODULE_3__["default"]), args.length > 2
        ? args[2]
        : args.length === 2 && typeof args[1] === 'object'
            ? args[1]
            : {});
    // in typescript args.length > 2 is not same as args.lenth === 3
    // we do a safe type assertion here
    // args.length === 3
    var fn = (args.length > 2
        ? args[1]
        : args.length === 2 && typeof args[1] === 'function'
            ? args[1]
            : /**
                  pass fn as null will disable revalidate
                  https://paco.sh/blog/shared-hook-state-with-swr
                */
                args[1] === null
                    ? args[1]
                    : config.fetcher);
    // we assume `key` as the identifier of the request
    // `key` can change but `fn` shouldn't
    // (because `revalidate` only depends on `key`)
    // `keyErr` is the cache key for error objects
    var _a = _config__WEBPACK_IMPORTED_MODULE_1__.cache.serializeKey(_key), key = _a[0], fnArgs = _a[1], keyErr = _a[2], keyValidating = _a[3];
    var configRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(config);
    (0,_env__WEBPACK_IMPORTED_MODULE_2__.useIsomorphicLayoutEffect)(function () {
        configRef.current = config;
    });
    var willRevalidateOnMount = function () {
        return (config.revalidateOnMount ||
            (!config.initialData && config.revalidateOnMount === undefined));
    };
    var resolveData = function () {
        var cachedData = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key);
        return typeof cachedData === 'undefined' ? config.initialData : cachedData;
    };
    var resolveIsValidating = function () {
        return !!_config__WEBPACK_IMPORTED_MODULE_1__.cache.get(keyValidating) || (key && willRevalidateOnMount());
    };
    var initialData = resolveData();
    var initialError = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(keyErr);
    var initialIsValidating = resolveIsValidating();
    // if a state is accessed (data, error or isValidating),
    // we add the state to dependencies so if the state is
    // updated in the future, we can trigger a rerender
    var stateDependencies = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({
        data: false,
        error: false,
        isValidating: false
    });
    var stateRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({
        data: initialData,
        error: initialError,
        isValidating: initialIsValidating
    });
    // display the data label in the React DevTools next to SWR hooks
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useDebugValue)(stateRef.current.data);
    var rerender = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({})[1];
    var dispatch = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (payload) {
        var shouldUpdateState = false;
        for (var k in payload) {
            // @ts-ignore
            if (stateRef.current[k] === payload[k]) {
                continue;
            }
            // @ts-ignore
            stateRef.current[k] = payload[k];
            // @ts-ignore
            if (stateDependencies.current[k]) {
                shouldUpdateState = true;
            }
        }
        if (shouldUpdateState) {
            // if component is unmounted, should skip rerender
            // if component is not mounted, should skip rerender
            if (unmountedRef.current || !initialMountedRef.current)
                return;
            rerender({});
        }
    }, 
    // config.suspense isn't allowed to change during the lifecycle
    // eslint-disable-next-line react-hooks/exhaustive-deps
    []);
    // error ref inside revalidate (is last request errored?)
    var unmountedRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
    var keyRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(key);
    // check if component is mounted in suspense mode
    var initialMountedRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
    // do unmount check for callbacks
    var eventsCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (event) {
        var _a;
        var params = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            params[_i - 1] = arguments[_i];
        }
        if (unmountedRef.current)
            return;
        if (!initialMountedRef.current)
            return;
        if (key !== keyRef.current)
            return;
        // @ts-ignore
        (_a = configRef.current)[event].apply(_a, params);
    }, [key]);
    var boundMutate = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (data, shouldRevalidate) {
        return mutate(keyRef.current, data, shouldRevalidate);
    }, []);
    var addRevalidator = function (revalidators, callback) {
        if (!revalidators[key]) {
            revalidators[key] = [callback];
        }
        else {
            revalidators[key].push(callback);
        }
        return function () {
            var keyedRevalidators = revalidators[key];
            var index = keyedRevalidators.indexOf(callback);
            if (index >= 0) {
                // O(1): faster than splice
                keyedRevalidators[index] =
                    keyedRevalidators[keyedRevalidators.length - 1];
                keyedRevalidators.pop();
            }
        };
    };
    // start a revalidation
    var revalidate = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (revalidateOpts) {
        if (revalidateOpts === void 0) { revalidateOpts = {}; }
        return __awaiter(_this, void 0, void 0, function () {
            var _a, retryCount, _b, dedupe, loading, shouldDeduping, newData, startAt, newState, err_2;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        if (!key || !fn)
                            return [2 /*return*/, false];
                        if (unmountedRef.current)
                            return [2 /*return*/, false];
                        if (configRef.current.isPaused())
                            return [2 /*return*/, false];
                        _a = revalidateOpts.retryCount, retryCount = _a === void 0 ? 0 : _a, _b = revalidateOpts.dedupe, dedupe = _b === void 0 ? false : _b;
                        loading = true;
                        shouldDeduping = typeof CONCURRENT_PROMISES[key] !== 'undefined' && dedupe;
                        _c.label = 1;
                    case 1:
                        _c.trys.push([1, 6, , 7]);
                        dispatch({
                            isValidating: true
                        });
                        _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(keyValidating, true);
                        if (!shouldDeduping) {
                            // also update other hooks
                            broadcastState(key, stateRef.current.data, stateRef.current.error, true);
                        }
                        newData = void 0;
                        startAt = void 0;
                        if (!shouldDeduping) return [3 /*break*/, 3];
                        // there's already an ongoing request,
                        // this one needs to be deduplicated.
                        startAt = CONCURRENT_PROMISES_TS[key];
                        return [4 /*yield*/, CONCURRENT_PROMISES[key]];
                    case 2:
                        newData = _c.sent();
                        return [3 /*break*/, 5];
                    case 3:
                        // if no cache being rendered currently (it shows a blank page),
                        // we trigger the loading slow event.
                        if (config.loadingTimeout && !_config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key)) {
                            setTimeout(function () {
                                if (loading)
                                    eventsCallback('onLoadingSlow', key, config);
                            }, config.loadingTimeout);
                        }
                        if (fnArgs !== null) {
                            CONCURRENT_PROMISES[key] = fn.apply(void 0, fnArgs);
                        }
                        else {
                            CONCURRENT_PROMISES[key] = fn(key);
                        }
                        CONCURRENT_PROMISES_TS[key] = startAt = now();
                        return [4 /*yield*/, CONCURRENT_PROMISES[key]];
                    case 4:
                        newData = _c.sent();
                        setTimeout(function () {
                            delete CONCURRENT_PROMISES[key];
                            delete CONCURRENT_PROMISES_TS[key];
                        }, config.dedupingInterval);
                        // trigger the success event,
                        // only do this for the original request.
                        eventsCallback('onSuccess', newData, key, config);
                        _c.label = 5;
                    case 5:
                        // if there're other ongoing request(s), started after the current one,
                        // we need to ignore the current one to avoid possible race conditions:
                        //   req1------------------>res1        (current one)
                        //        req2---------------->res2
                        // the request that fired later will always be kept.
                        if (CONCURRENT_PROMISES_TS[key] > startAt) {
                            return [2 /*return*/, false];
                        }
                        // if there're other mutations(s), overlapped with the current revalidation:
                        // case 1:
                        //   req------------------>res
                        //       mutate------>end
                        // case 2:
                        //         req------------>res
                        //   mutate------>end
                        // case 3:
                        //   req------------------>res
                        //       mutate-------...---------->
                        // we have to ignore the revalidation result (res) because it's no longer fresh.
                        // meanwhile, a new revalidation should be triggered when the mutation ends.
                        if (MUTATION_TS[key] &&
                            // case 1
                            (startAt <= MUTATION_TS[key] ||
                                // case 2
                                startAt <= MUTATION_END_TS[key] ||
                                // case 3
                                MUTATION_END_TS[key] === 0)) {
                            dispatch({ isValidating: false });
                            return [2 /*return*/, false];
                        }
                        _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(keyErr, undefined);
                        _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(keyValidating, false);
                        newState = {
                            isValidating: false
                        };
                        if (typeof stateRef.current.error !== 'undefined') {
                            // we don't have an error
                            newState.error = undefined;
                        }
                        if (!config.compare(stateRef.current.data, newData)) {
                            // deep compare to avoid extra re-render
                            // data changed
                            newState.data = newData;
                        }
                        if (!config.compare(_config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key), newData)) {
                            _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(key, newData);
                        }
                        // merge the new state
                        dispatch(newState);
                        if (!shouldDeduping) {
                            // also update other hooks
                            broadcastState(key, newData, newState.error, false);
                        }
                        return [3 /*break*/, 7];
                    case 6:
                        err_2 = _c.sent();
                        delete CONCURRENT_PROMISES[key];
                        delete CONCURRENT_PROMISES_TS[key];
                        if (configRef.current.isPaused()) {
                            dispatch({
                                isValidating: false
                            });
                            return [2 /*return*/, false];
                        }
                        _config__WEBPACK_IMPORTED_MODULE_1__.cache.set(keyErr, err_2);
                        // get a new error
                        // don't use deep equal for errors
                        if (stateRef.current.error !== err_2) {
                            // we keep the stale data
                            dispatch({
                                isValidating: false,
                                error: err_2
                            });
                            if (!shouldDeduping) {
                                // also broadcast to update other hooks
                                broadcastState(key, undefined, err_2, false);
                            }
                        }
                        // events and retry
                        eventsCallback('onError', err_2, key, config);
                        if (config.shouldRetryOnError) {
                            // when retrying, we always enable deduping
                            eventsCallback('onErrorRetry', err_2, key, config, revalidate, {
                                retryCount: retryCount + 1,
                                dedupe: true
                            });
                        }
                        return [3 /*break*/, 7];
                    case 7:
                        loading = false;
                        return [2 /*return*/, true];
                }
            });
        });
    }, 
    // dispatch is immutable, and `eventsCallback`, `fnArgs`, `keyErr`, and `keyValidating` are based on `key`,
    // so we can them from the deps array.
    //
    // FIXME:
    // `fn` and `config` might be changed during the lifecycle,
    // but they might be changed every render like this.
    // useSWR('key', () => fetch('/api/'), { suspense: true })
    // So we omit the values from the deps array
    // even though it might cause unexpected behaviors.
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [key]);
    // mounted (client side rendering)
    (0,_env__WEBPACK_IMPORTED_MODULE_2__.useIsomorphicLayoutEffect)(function () {
        if (!key)
            return undefined;
        // after `key` updates, we need to mark it as mounted
        unmountedRef.current = false;
        var isUpdating = initialMountedRef.current;
        initialMountedRef.current = true;
        // after the component is mounted (hydrated),
        // we need to update the data from the cache
        // and trigger a revalidation
        var currentHookData = stateRef.current.data;
        var latestKeyedData = resolveData();
        // update the state if the key changed (not the inital render) or cache updated
        keyRef.current = key;
        if (!config.compare(currentHookData, latestKeyedData)) {
            dispatch({ data: latestKeyedData });
        }
        // revalidate with deduping
        var softRevalidate = function () { return revalidate({ dedupe: true }); };
        // trigger a revalidation
        if (isUpdating || willRevalidateOnMount()) {
            if (typeof latestKeyedData !== 'undefined' && !_env__WEBPACK_IMPORTED_MODULE_2__.IS_SERVER) {
                // delay revalidate if there's cache
                // to not block the rendering
                // @ts-ignore it's safe to use requestAnimationFrame in browser
                (0,_env__WEBPACK_IMPORTED_MODULE_2__.rAF)(softRevalidate);
            }
            else {
                softRevalidate();
            }
        }
        var pending = false;
        var onFocus = function () {
            if (pending || !configRef.current.revalidateOnFocus)
                return;
            pending = true;
            softRevalidate();
            setTimeout(function () { return (pending = false); }, configRef.current.focusThrottleInterval);
        };
        var onReconnect = function () {
            if (configRef.current.revalidateOnReconnect) {
                softRevalidate();
            }
        };
        // register global cache update listener
        var onUpdate = function (shouldRevalidate, updatedData, updatedError, updatedIsValidating, dedupe) {
            if (shouldRevalidate === void 0) { shouldRevalidate = true; }
            if (dedupe === void 0) { dedupe = true; }
            // update hook state
            var newState = {};
            var needUpdate = false;
            if (typeof updatedData !== 'undefined' &&
                !config.compare(stateRef.current.data, updatedData)) {
                newState.data = updatedData;
                needUpdate = true;
            }
            // always update error
            // because it can be `undefined`
            if (stateRef.current.error !== updatedError) {
                newState.error = updatedError;
                needUpdate = true;
            }
            if (typeof updatedIsValidating !== 'undefined' &&
                stateRef.current.isValidating !== updatedIsValidating) {
                newState.isValidating = updatedIsValidating;
                needUpdate = true;
            }
            if (needUpdate) {
                dispatch(newState);
            }
            if (shouldRevalidate) {
                if (dedupe) {
                    return softRevalidate();
                }
                else {
                    return revalidate();
                }
            }
            return false;
        };
        var unsubFocus = addRevalidator(FOCUS_REVALIDATORS, onFocus);
        var unsubReconnect = addRevalidator(RECONNECT_REVALIDATORS, onReconnect);
        var unsubUpdate = addRevalidator(CACHE_REVALIDATORS, onUpdate);
        return function () {
            // cleanup
            dispatch = function () { return null; };
            // mark it as unmounted
            unmountedRef.current = true;
            unsubFocus();
            unsubReconnect();
            unsubUpdate();
        };
    }, [key, revalidate]);
    (0,_env__WEBPACK_IMPORTED_MODULE_2__.useIsomorphicLayoutEffect)(function () {
        var timer = null;
        var tick = function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(!stateRef.current.error &&
                            (configRef.current.refreshWhenHidden ||
                                configRef.current.isDocumentVisible()) &&
                            (configRef.current.refreshWhenOffline || configRef.current.isOnline()))) return [3 /*break*/, 2];
                        // only revalidate when the page is visible
                        // if API request errored, we stop polling in this round
                        // and let the error retry function handle it
                        return [4 /*yield*/, revalidate({ dedupe: true })];
                    case 1:
                        // only revalidate when the page is visible
                        // if API request errored, we stop polling in this round
                        // and let the error retry function handle it
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        // Read the latest refreshInterval
                        if (configRef.current.refreshInterval && timer) {
                            timer = setTimeout(tick, configRef.current.refreshInterval);
                        }
                        return [2 /*return*/];
                }
            });
        }); };
        if (configRef.current.refreshInterval) {
            timer = setTimeout(tick, configRef.current.refreshInterval);
        }
        return function () {
            if (timer) {
                clearTimeout(timer);
                timer = null;
            }
        };
    }, [
        config.refreshInterval,
        config.refreshWhenHidden,
        config.refreshWhenOffline,
        revalidate
    ]);
    // suspense
    var latestData;
    var latestError;
    if (config.suspense) {
        // in suspense mode, we can't return empty state
        // (it should be suspended)
        // try to get data and error from cache
        latestData = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(key);
        latestError = _config__WEBPACK_IMPORTED_MODULE_1__.cache.get(keyErr);
        if (typeof latestData === 'undefined') {
            latestData = initialData;
        }
        if (typeof latestError === 'undefined') {
            latestError = initialError;
        }
        if (typeof latestData === 'undefined' &&
            typeof latestError === 'undefined') {
            // need to start the request if it hasn't
            if (!CONCURRENT_PROMISES[key]) {
                // trigger revalidate immediately
                // to get the promise
                // in this revalidate, should not rerender
                revalidate();
            }
            if (CONCURRENT_PROMISES[key] &&
                typeof CONCURRENT_PROMISES[key].then === 'function') {
                // if it is a promise
                throw CONCURRENT_PROMISES[key];
            }
            // it's a value, return it directly (override)
            latestData = CONCURRENT_PROMISES[key];
        }
        if (typeof latestData === 'undefined' && latestError) {
            // in suspense mode, throw error if there's no content
            throw latestError;
        }
    }
    // define returned state
    // can be memorized since the state is a ref
    var memoizedState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
        // revalidate will be deprecated in the 1.x release
        // because mutate() covers the same use case of revalidate().
        // This remains only for backward compatibility
        var state = { revalidate: revalidate, mutate: boundMutate };
        Object.defineProperties(state, {
            error: {
                // `key` might be changed in the upcoming hook re-render,
                // but the previous state will stay
                // so we need to match the latest key and data (fallback to `initialData`)
                get: function () {
                    stateDependencies.current.error = true;
                    if (config.suspense) {
                        return latestError;
                    }
                    return keyRef.current === key ? stateRef.current.error : initialError;
                },
                enumerable: true
            },
            data: {
                get: function () {
                    stateDependencies.current.data = true;
                    if (config.suspense) {
                        return latestData;
                    }
                    return keyRef.current === key ? stateRef.current.data : initialData;
                },
                enumerable: true
            },
            isValidating: {
                get: function () {
                    stateDependencies.current.isValidating = true;
                    return key ? stateRef.current.isValidating : false;
                },
                enumerable: true
            }
        });
        return state;
        // `config.suspense` isn't allowed to change during the lifecycle.
        // `boundMutate` is immutable, and the immutability of `revalidate` depends on `key`
        // so we can omit them from the deps array,
        // but we put it to enable react-hooks/exhaustive-deps rule.
        // `initialData` and `initialError` are not initial values
        // because they are changed during the lifecycle
        // so we should add them in the deps array.
    }, [
        revalidate,
        initialData,
        initialError,
        boundMutate,
        key,
        config.suspense,
        latestError,
        latestData
    ]);
    return memoizedState;
}
Object.defineProperty(_swr_config_context__WEBPACK_IMPORTED_MODULE_3__["default"].Provider, 'default', {
    value: _config__WEBPACK_IMPORTED_MODULE_1__["default"]
});
var SWRConfig = _swr_config_context__WEBPACK_IMPORTED_MODULE_3__["default"].Provider;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useSWR);


/***/ }),

/***/ "../../node_modules/dequal/lite/index.mjs":
/*!************************************************!*\
  !*** ../../node_modules/dequal/lite/index.mjs ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dequal: () => (/* binding */ dequal)
/* harmony export */ });
var has = Object.prototype.hasOwnProperty;

function dequal(foo, bar) {
	var ctor, len;
	if (foo === bar) return true;

	if (foo && bar && (ctor=foo.constructor) === bar.constructor) {
		if (ctor === Date) return foo.getTime() === bar.getTime();
		if (ctor === RegExp) return foo.toString() === bar.toString();

		if (ctor === Array) {
			if ((len=foo.length) === bar.length) {
				while (len-- && dequal(foo[len], bar[len]));
			}
			return len === -1;
		}

		if (!ctor || typeof foo === 'object') {
			len = 0;
			for (ctor in foo) {
				if (has.call(foo, ctor) && ++len && !has.call(bar, ctor)) return false;
				if (!(ctor in bar) || !dequal(foo[ctor], bar[ctor])) return false;
			}
			return Object.keys(bar).length === len;
		}
	}

	return foo !== foo && bar !== bar;
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_swr_esm_index_js.498d2a3673ec781ff303.js.map