(self["webpackChunk_elyra_ui_components"] = self["webpackChunk_elyra_ui_components"] || []).push([["vendors-node_modules_rjsf_core_lib_index_js"],{

/***/ "../../node_modules/@rjsf/core/lib/components/Form.js":
/*!************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/Form.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Form)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_forEach__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/forEach */ "../../node_modules/lodash/forEach.js");
/* harmony import */ var lodash_forEach__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_forEach__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_pick__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/pick */ "../../node_modules/lodash/pick.js");
/* harmony import */ var lodash_pick__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_pick__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var lodash_toPath__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash/toPath */ "../../node_modules/lodash/toPath.js");
/* harmony import */ var lodash_toPath__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash_toPath__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _getDefaultRegistry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../getDefaultRegistry */ "../../node_modules/@rjsf/core/lib/getDefaultRegistry.js");









/** The `Form` component renders the outer form and all the fields defined in the `schema` */
class Form extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    /** Constructs the `Form` from the `props`. Will setup the initial state from the props. It will also call the
     * `onChange` handler if the initially provided `formData` is modified to add missing default values as part of the
     * state construction.
     *
     * @param props - The initial props for the `Form`
     */
    constructor(props) {
        super(props);
        /** Returns the `formData` with only the elements specified in the `fields` list
         *
         * @param formData - The data for the `Form`
         * @param fields - The fields to keep while filtering
         */
        this.getUsedFormData = (formData, fields) => {
            // For the case of a single input form
            if (fields.length === 0 && typeof formData !== 'object') {
                return formData;
            }
            // _pick has incorrect type definition, it works with string[][], because lodash/hasIn supports it
            const data = lodash_pick__WEBPACK_IMPORTED_MODULE_6___default()(formData, fields);
            if (Array.isArray(formData)) {
                return Object.keys(data).map((key) => data[key]);
            }
            return data;
        };
        /** Returns the list of field names from inspecting the `pathSchema` as well as using the `formData`
         *
         * @param pathSchema - The `PathSchema` object for the form
         * @param [formData] - The form data to use while checking for empty objects/arrays
         */
        this.getFieldNames = (pathSchema, formData) => {
            const getAllPaths = (_obj, acc = [], paths = [[]]) => {
                Object.keys(_obj).forEach((key) => {
                    if (typeof _obj[key] === 'object') {
                        const newPaths = paths.map((path) => [...path, key]);
                        // If an object is marked with additionalProperties, all its keys are valid
                        if (_obj[key][_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.RJSF_ADDITIONAL_PROPERTIES_FLAG] && _obj[key][_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.NAME_KEY] !== '') {
                            acc.push(_obj[key][_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.NAME_KEY]);
                        }
                        else {
                            getAllPaths(_obj[key], acc, newPaths);
                        }
                    }
                    else if (key === _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.NAME_KEY && _obj[key] !== '') {
                        paths.forEach((path) => {
                            const formValue = lodash_get__WEBPACK_IMPORTED_MODULE_4___default()(formData, path);
                            // adds path to fieldNames if it points to a value
                            // or an empty object/array
                            if (typeof formValue !== 'object' ||
                                lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default()(formValue) ||
                                (Array.isArray(formValue) && formValue.every((val) => typeof val !== 'object'))) {
                                acc.push(path);
                            }
                        });
                    }
                });
                return acc;
            };
            return getAllPaths(pathSchema);
        };
        /** Returns the `formData` after filtering to remove any extra data not in a form field
         *
         * @param formData - The data for the `Form`
         * @returns The `formData` after omitting extra data
         */
        this.omitExtraData = (formData) => {
            const { schema, schemaUtils } = this.state;
            const retrievedSchema = schemaUtils.retrieveSchema(schema, formData);
            const pathSchema = schemaUtils.toPathSchema(retrievedSchema, '', formData);
            const fieldNames = this.getFieldNames(pathSchema, formData);
            const newFormData = this.getUsedFormData(formData, fieldNames);
            return newFormData;
        };
        /** Function to handle changes made to a field in the `Form`. This handler receives an entirely new copy of the
         * `formData` along with a new `ErrorSchema`. It will first update the `formData` with any missing default fields and
         * then, if `omitExtraData` and `liveOmit` are turned on, the `formData` will be filtered to remove any extra data not
         * in a form field. Then, the resulting formData will be validated if required. The state will be updated with the new
         * updated (potentially filtered) `formData`, any errors that resulted from validation. Finally the `onChange`
         * callback will be called if specified with the updated state.
         *
         * @param formData - The new form data from a change to a field
         * @param newErrorSchema - The new `ErrorSchema` based on the field change
         * @param id - The id of the field that caused the change
         */
        this.onChange = (formData, newErrorSchema, id) => {
            const { extraErrors, omitExtraData, liveOmit, noValidate, liveValidate, onChange } = this.props;
            const { schemaUtils, schema, retrievedSchema } = this.state;
            if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isObject)(formData) || Array.isArray(formData)) {
                const newState = this.getStateFromProps(this.props, formData, retrievedSchema);
                formData = newState.formData;
            }
            const mustValidate = !noValidate && liveValidate;
            let state = { formData, schema };
            let newFormData = formData;
            let _retrievedSchema;
            if (omitExtraData === true && liveOmit === true) {
                newFormData = this.omitExtraData(formData);
                state = {
                    formData: newFormData,
                };
            }
            if (mustValidate) {
                const schemaValidation = this.validate(newFormData, schema, schemaUtils, retrievedSchema);
                let errors = schemaValidation.errors;
                let errorSchema = schemaValidation.errorSchema;
                const schemaValidationErrors = errors;
                const schemaValidationErrorSchema = errorSchema;
                if (extraErrors) {
                    const merged = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.validationDataMerge)(schemaValidation, extraErrors);
                    errorSchema = merged.errorSchema;
                    errors = merged.errors;
                }
                // Merging 'newErrorSchema' into 'errorSchema' to display the custom raised errors.
                if (newErrorSchema) {
                    const filteredErrors = this.filterErrorsBasedOnSchema(newErrorSchema, retrievedSchema, newFormData);
                    errorSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.mergeObjects)(errorSchema, filteredErrors, 'preventDuplicates');
                }
                state = {
                    formData: newFormData,
                    errors,
                    errorSchema,
                    schemaValidationErrors,
                    schemaValidationErrorSchema,
                };
            }
            else if (!noValidate && newErrorSchema) {
                const errorSchema = extraErrors
                    ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.mergeObjects)(newErrorSchema, extraErrors, 'preventDuplicates')
                    : newErrorSchema;
                state = {
                    formData: newFormData,
                    errorSchema: errorSchema,
                    errors: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.toErrorList)(errorSchema),
                };
            }
            if (_retrievedSchema) {
                state.retrievedSchema = _retrievedSchema;
            }
            this.setState(state, () => onChange && onChange({ ...this.state, ...state }, id));
        };
        /**
         * Callback function to handle reset form data.
         * - Reset all fields with default values.
         * - Reset validations and errors
         *
         */
        this.reset = () => {
            const { onChange } = this.props;
            const newState = this.getStateFromProps(this.props, undefined);
            const newFormData = newState.formData;
            const state = {
                formData: newFormData,
                errorSchema: {},
                errors: [],
                schemaValidationErrors: [],
                schemaValidationErrorSchema: {},
            };
            this.setState(state, () => onChange && onChange({ ...this.state, ...state }));
        };
        /** Callback function to handle when a field on the form is blurred. Calls the `onBlur` callback for the `Form` if it
         * was provided.
         *
         * @param id - The unique `id` of the field that was blurred
         * @param data - The data associated with the field that was blurred
         */
        this.onBlur = (id, data) => {
            const { onBlur } = this.props;
            if (onBlur) {
                onBlur(id, data);
            }
        };
        /** Callback function to handle when a field on the form is focused. Calls the `onFocus` callback for the `Form` if it
         * was provided.
         *
         * @param id - The unique `id` of the field that was focused
         * @param data - The data associated with the field that was focused
         */
        this.onFocus = (id, data) => {
            const { onFocus } = this.props;
            if (onFocus) {
                onFocus(id, data);
            }
        };
        /** Callback function to handle when the form is submitted. First, it prevents the default event behavior. Nothing
         * happens if the target and currentTarget of the event are not the same. It will omit any extra data in the
         * `formData` in the state if `omitExtraData` is true. It will validate the resulting `formData`, reporting errors
         * via the `onError()` callback unless validation is disabled. Finally, it will add in any `extraErrors` and then call
         * back the `onSubmit` callback if it was provided.
         *
         * @param event - The submit HTML form event
         */
        this.onSubmit = (event) => {
            event.preventDefault();
            if (event.target !== event.currentTarget) {
                return;
            }
            event.persist();
            const { omitExtraData, extraErrors, noValidate, onSubmit } = this.props;
            let { formData: newFormData } = this.state;
            if (omitExtraData === true) {
                newFormData = this.omitExtraData(newFormData);
            }
            if (noValidate || this.validateFormWithFormData(newFormData)) {
                // There are no errors generated through schema validation.
                // Check for user provided errors and update state accordingly.
                const errorSchema = extraErrors || {};
                const errors = extraErrors ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.toErrorList)(extraErrors) : [];
                this.setState({
                    formData: newFormData,
                    errors,
                    errorSchema,
                    schemaValidationErrors: [],
                    schemaValidationErrorSchema: {},
                }, () => {
                    if (onSubmit) {
                        onSubmit({ ...this.state, formData: newFormData, status: 'submitted' }, event);
                    }
                });
            }
        };
        /** Provides a function that can be used to programmatically submit the `Form` */
        this.submit = () => {
            if (this.formElement.current) {
                const submitCustomEvent = new CustomEvent('submit', {
                    cancelable: true,
                });
                submitCustomEvent.preventDefault();
                this.formElement.current.dispatchEvent(submitCustomEvent);
                this.formElement.current.requestSubmit();
            }
        };
        /** Validates the form using the given `formData`. For use on form submission or on programmatic validation.
         * If `onError` is provided, then it will be called with the list of errors.
         *
         * @param formData - The form data to validate
         * @returns - True if the form is valid, false otherwise.
         */
        this.validateFormWithFormData = (formData) => {
            const { extraErrors, extraErrorsBlockSubmit, focusOnFirstError, onError } = this.props;
            const { errors: prevErrors } = this.state;
            const schemaValidation = this.validate(formData);
            let errors = schemaValidation.errors;
            let errorSchema = schemaValidation.errorSchema;
            const schemaValidationErrors = errors;
            const schemaValidationErrorSchema = errorSchema;
            const hasError = errors.length > 0 || (extraErrors && extraErrorsBlockSubmit);
            if (hasError) {
                if (extraErrors) {
                    const merged = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.validationDataMerge)(schemaValidation, extraErrors);
                    errorSchema = merged.errorSchema;
                    errors = merged.errors;
                }
                if (focusOnFirstError) {
                    if (typeof focusOnFirstError === 'function') {
                        focusOnFirstError(errors[0]);
                    }
                    else {
                        this.focusOnError(errors[0]);
                    }
                }
                this.setState({
                    errors,
                    errorSchema,
                    schemaValidationErrors,
                    schemaValidationErrorSchema,
                }, () => {
                    if (onError) {
                        onError(errors);
                    }
                    else {
                        console.error('Form validation failed', errors);
                    }
                });
            }
            else if (prevErrors.length > 0) {
                this.setState({
                    errors: [],
                    errorSchema: {},
                    schemaValidationErrors: [],
                    schemaValidationErrorSchema: {},
                });
            }
            return !hasError;
        };
        if (!props.validator) {
            throw new Error('A validator is required for Form functionality to work');
        }
        this.state = this.getStateFromProps(props, props.formData);
        if (this.props.onChange && !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(this.state.formData, this.props.formData)) {
            this.props.onChange(this.state);
        }
        this.formElement = (0,react__WEBPACK_IMPORTED_MODULE_1__.createRef)();
    }
    /**
     * `getSnapshotBeforeUpdate` is a React lifecycle method that is invoked right before the most recently rendered
     * output is committed to the DOM. It enables your component to capture current values (e.g., scroll position) before
     * they are potentially changed.
     *
     * In this case, it checks if the props have changed since the last render. If they have, it computes the next state
     * of the component using `getStateFromProps` method and returns it along with a `shouldUpdate` flag set to `true` IF
     * the `nextState` and `prevState` are different, otherwise `false`. This ensures that we have the most up-to-date
     * state ready to be applied in `componentDidUpdate`.
     *
     * If `formData` hasn't changed, it simply returns an object with `shouldUpdate` set to `false`, indicating that a
     * state update is not necessary.
     *
     * @param prevProps - The previous set of props before the update.
     * @param prevState - The previous state before the update.
     * @returns Either an object containing the next state and a flag indicating that an update should occur, or an object
     *        with a flag indicating that an update is not necessary.
     */
    getSnapshotBeforeUpdate(prevProps, prevState) {
        if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(this.props, prevProps)) {
            const isSchemaChanged = !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(prevProps.schema, this.props.schema);
            const isFormDataChanged = !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(prevProps.formData, this.props.formData);
            const nextState = this.getStateFromProps(this.props, this.props.formData, 
            // If the `schema` has changed, we need to update the retrieved schema.
            // Or if the `formData` changes, for example in the case of a schema with dependencies that need to
            //  match one of the subSchemas, the retrieved schema must be updated.
            isSchemaChanged || isFormDataChanged ? undefined : this.state.retrievedSchema, isSchemaChanged);
            const shouldUpdate = !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(nextState, prevState);
            return { nextState, shouldUpdate };
        }
        return { shouldUpdate: false };
    }
    /**
     * `componentDidUpdate` is a React lifecycle method that is invoked immediately after updating occurs. This method is
     * not called for the initial render.
     *
     * Here, it checks if an update is necessary based on the `shouldUpdate` flag received from `getSnapshotBeforeUpdate`.
     * If an update is required, it applies the next state and, if needed, triggers the `onChange` handler to inform about
     * changes.
     *
     * This method effectively replaces the deprecated `UNSAFE_componentWillReceiveProps`, providing a safer alternative
     * to handle prop changes and state updates.
     *
     * @param _ - The previous set of props.
     * @param prevState - The previous state of the component before the update.
     * @param snapshot - The value returned from `getSnapshotBeforeUpdate`.
     */
    componentDidUpdate(_, prevState, snapshot) {
        if (snapshot.shouldUpdate) {
            const { nextState } = snapshot;
            if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(nextState.formData, this.props.formData) &&
                !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(nextState.formData, prevState.formData) &&
                this.props.onChange) {
                this.props.onChange(nextState);
            }
            this.setState(nextState);
        }
    }
    /** Extracts the updated state from the given `props` and `inputFormData`. As part of this process, the
     * `inputFormData` is first processed to add any missing required defaults. After that, the data is run through the
     * validation process IF required by the `props`.
     *
     * @param props - The props passed to the `Form`
     * @param inputFormData - The new or current data for the `Form`
     * @param retrievedSchema - An expanded schema, if not provided, it will be retrieved from the `schema` and `formData`.
     * @param isSchemaChanged - A flag indicating whether the schema has changed.
     * @returns - The new state for the `Form`
     */
    getStateFromProps(props, inputFormData, retrievedSchema, isSchemaChanged = false) {
        var _a;
        const state = this.state || {};
        const schema = 'schema' in props ? props.schema : this.props.schema;
        const uiSchema = ('uiSchema' in props ? props.uiSchema : this.props.uiSchema) || {};
        const edit = typeof inputFormData !== 'undefined';
        const liveValidate = 'liveValidate' in props ? props.liveValidate : this.props.liveValidate;
        const mustValidate = edit && !props.noValidate && liveValidate;
        const rootSchema = schema;
        const experimental_defaultFormStateBehavior = 'experimental_defaultFormStateBehavior' in props
            ? props.experimental_defaultFormStateBehavior
            : this.props.experimental_defaultFormStateBehavior;
        let schemaUtils = state.schemaUtils;
        if (!schemaUtils ||
            schemaUtils.doesSchemaUtilsDiffer(props.validator, rootSchema, experimental_defaultFormStateBehavior)) {
            schemaUtils = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.createSchemaUtils)(props.validator, rootSchema, experimental_defaultFormStateBehavior);
        }
        const formData = schemaUtils.getDefaultFormState(schema, inputFormData);
        const _retrievedSchema = retrievedSchema !== null && retrievedSchema !== void 0 ? retrievedSchema : schemaUtils.retrieveSchema(schema, formData);
        const getCurrentErrors = () => {
            // If the `props.noValidate` option is set or the schema has changed, we reset the error state.
            if (props.noValidate || isSchemaChanged) {
                return { errors: [], errorSchema: {} };
            }
            else if (!props.liveValidate) {
                return {
                    errors: state.schemaValidationErrors || [],
                    errorSchema: state.schemaValidationErrorSchema || {},
                };
            }
            return {
                errors: state.errors || [],
                errorSchema: state.errorSchema || {},
            };
        };
        let errors;
        let errorSchema;
        let schemaValidationErrors = state.schemaValidationErrors;
        let schemaValidationErrorSchema = state.schemaValidationErrorSchema;
        if (mustValidate) {
            const schemaValidation = this.validate(formData, schema, schemaUtils, _retrievedSchema);
            errors = schemaValidation.errors;
            // If the schema has changed, we do not merge state.errorSchema.
            // Else in the case where it hasn't changed, we merge 'state.errorSchema' with 'schemaValidation.errorSchema.' This done to display the raised field error.
            if (isSchemaChanged) {
                errorSchema = schemaValidation.errorSchema;
            }
            else {
                errorSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.mergeObjects)((_a = this.state) === null || _a === void 0 ? void 0 : _a.errorSchema, schemaValidation.errorSchema, 'preventDuplicates');
            }
            schemaValidationErrors = errors;
            schemaValidationErrorSchema = errorSchema;
        }
        else {
            const currentErrors = getCurrentErrors();
            errors = currentErrors.errors;
            errorSchema = currentErrors.errorSchema;
        }
        if (props.extraErrors) {
            const merged = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.validationDataMerge)({ errorSchema, errors }, props.extraErrors);
            errorSchema = merged.errorSchema;
            errors = merged.errors;
        }
        const idSchema = schemaUtils.toIdSchema(_retrievedSchema, uiSchema['ui:rootFieldId'], formData, props.idPrefix, props.idSeparator);
        const nextState = {
            schemaUtils,
            schema,
            uiSchema,
            idSchema,
            formData,
            edit,
            errors,
            errorSchema,
            schemaValidationErrors,
            schemaValidationErrorSchema,
            retrievedSchema: _retrievedSchema,
        };
        return nextState;
    }
    /** React lifecycle method that is used to determine whether component should be updated.
     *
     * @param nextProps - The next version of the props
     * @param nextState - The next version of the state
     * @returns - True if the component should be updated, false otherwise
     */
    shouldComponentUpdate(nextProps, nextState) {
        return (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.shouldRender)(this, nextProps, nextState);
    }
    /** Validates the `formData` against the `schema` using the `altSchemaUtils` (if provided otherwise it uses the
     * `schemaUtils` in the state), returning the results.
     *
     * @param formData - The new form data to validate
     * @param schema - The schema used to validate against
     * @param altSchemaUtils - The alternate schemaUtils to use for validation
     */
    validate(formData, schema = this.props.schema, altSchemaUtils, retrievedSchema) {
        const schemaUtils = altSchemaUtils ? altSchemaUtils : this.state.schemaUtils;
        const { customValidate, transformErrors, uiSchema } = this.props;
        const resolvedSchema = retrievedSchema !== null && retrievedSchema !== void 0 ? retrievedSchema : schemaUtils.retrieveSchema(schema, formData);
        return schemaUtils
            .getValidator()
            .validateFormData(formData, resolvedSchema, customValidate, transformErrors, uiSchema);
    }
    /** Renders any errors contained in the `state` in using the `ErrorList`, if not disabled by `showErrorList`. */
    renderErrors(registry) {
        const { errors, errorSchema, schema, uiSchema } = this.state;
        const { formContext } = this.props;
        const options = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
        const ErrorListTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ErrorListTemplate', registry, options);
        if (errors && errors.length) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ErrorListTemplate, { errors: errors, errorSchema: errorSchema || {}, schema: schema, uiSchema: uiSchema, formContext: formContext, registry: registry }));
        }
        return null;
    }
    // Filtering errors based on your retrieved schema to only show errors for properties in the selected branch.
    filterErrorsBasedOnSchema(schemaErrors, resolvedSchema, formData) {
        const { retrievedSchema, schemaUtils } = this.state;
        const _retrievedSchema = resolvedSchema !== null && resolvedSchema !== void 0 ? resolvedSchema : retrievedSchema;
        const pathSchema = schemaUtils.toPathSchema(_retrievedSchema, '', formData);
        const fieldNames = this.getFieldNames(pathSchema, formData);
        const filteredErrors = lodash_pick__WEBPACK_IMPORTED_MODULE_6___default()(schemaErrors, fieldNames);
        // If the root schema is of a primitive type, do not filter out the __errors
        if ((resolvedSchema === null || resolvedSchema === void 0 ? void 0 : resolvedSchema.type) !== 'object' && (resolvedSchema === null || resolvedSchema === void 0 ? void 0 : resolvedSchema.type) !== 'array') {
            filteredErrors.__errors = schemaErrors.__errors;
        }
        // Removing undefined and empty errors.
        const filterUndefinedErrors = (errors) => {
            lodash_forEach__WEBPACK_IMPORTED_MODULE_3___default()(errors, (errorAtKey, errorKey) => {
                if (errorAtKey === undefined) {
                    delete errors[errorKey];
                }
                else if (typeof errorAtKey === 'object' && !Array.isArray(errorAtKey.__errors)) {
                    filterUndefinedErrors(errorAtKey);
                }
            });
            return errors;
        };
        return filterUndefinedErrors(filteredErrors);
    }
    /** Returns the registry for the form */
    getRegistry() {
        var _a;
        const { translateString: customTranslateString, uiSchema = {} } = this.props;
        const { schemaUtils } = this.state;
        const { fields, templates, widgets, formContext, translateString } = (0,_getDefaultRegistry__WEBPACK_IMPORTED_MODULE_8__["default"])();
        return {
            fields: { ...fields, ...this.props.fields },
            templates: {
                ...templates,
                ...this.props.templates,
                ButtonTemplates: {
                    ...templates.ButtonTemplates,
                    ...(_a = this.props.templates) === null || _a === void 0 ? void 0 : _a.ButtonTemplates,
                },
            },
            widgets: { ...widgets, ...this.props.widgets },
            rootSchema: this.props.schema,
            formContext: this.props.formContext || formContext,
            schemaUtils,
            translateString: customTranslateString || translateString,
            globalUiOptions: uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_GLOBAL_OPTIONS_KEY],
        };
    }
    /** Attempts to focus on the field associated with the `error`. Uses the `property` field to compute path of the error
     * field, then, using the `idPrefix` and `idSeparator` converts that path into an id. Then the input element with that
     * id is attempted to be found using the `formElement` ref. If it is located, then it is focused.
     *
     * @param error - The error on which to focus
     */
    focusOnError(error) {
        const { idPrefix = 'root', idSeparator = '_' } = this.props;
        const { property } = error;
        const path = lodash_toPath__WEBPACK_IMPORTED_MODULE_7___default()(property);
        if (path[0] === '') {
            // Most of the time the `.foo` property results in the first element being empty, so replace it with the idPrefix
            path[0] = idPrefix;
        }
        else {
            // Otherwise insert the idPrefix into the first location using unshift
            path.unshift(idPrefix);
        }
        const elementId = path.join(idSeparator);
        let field = this.formElement.current.elements[elementId];
        if (!field) {
            // if not an exact match, try finding an input starting with the element id (like radio buttons or checkboxes)
            field = this.formElement.current.querySelector(`input[id^="${elementId}"`);
        }
        if (field && field.length) {
            // If we got a list with length > 0
            field = field[0];
        }
        if (field) {
            field.focus();
        }
    }
    /** Programmatically validate the form.  If `omitExtraData` is true, the `formData` will first be filtered to remove
     * any extra data not in a form field. If `onError` is provided, then it will be called with the list of errors the
     * same way as would happen on form submission.
     *
     * @returns - True if the form is valid, false otherwise.
     */
    validateForm() {
        const { omitExtraData } = this.props;
        let { formData: newFormData } = this.state;
        if (omitExtraData === true) {
            newFormData = this.omitExtraData(newFormData);
        }
        return this.validateFormWithFormData(newFormData);
    }
    /** Renders the `Form` fields inside the <form> | `tagName` or `_internalFormWrapper`, rendering any errors if
     * needed along with the submit button or any children of the form.
     */
    render() {
        const { children, id, idPrefix, idSeparator, className = '', tagName, name, method, target, action, autoComplete, enctype, acceptcharset, acceptCharset, noHtml5Validate = false, disabled, readonly, formContext, showErrorList = 'top', _internalFormWrapper, } = this.props;
        const { schema, uiSchema, formData, errorSchema, idSchema } = this.state;
        const registry = this.getRegistry();
        const { SchemaField: _SchemaField } = registry.fields;
        const { SubmitButton } = registry.templates.ButtonTemplates;
        // The `semantic-ui` and `material-ui` themes have `_internalFormWrapper`s that take an `as` prop that is the
        // PropTypes.elementType to use for the inner tag, so we'll need to pass `tagName` along if it is provided.
        // NOTE, the `as` prop is native to `semantic-ui` and is emulated in the `material-ui` theme
        const as = _internalFormWrapper ? tagName : undefined;
        const FormTag = _internalFormWrapper || tagName || 'form';
        let { [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.SUBMIT_BTN_OPTIONS_KEY]: submitOptions = {} } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
        if (disabled) {
            submitOptions = { ...submitOptions, props: { ...submitOptions.props, disabled: true } };
        }
        const submitUiSchema = { [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_OPTIONS_KEY]: { [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.SUBMIT_BTN_OPTIONS_KEY]: submitOptions } };
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(FormTag, { className: className ? className : 'rjsf', id: id, name: name, method: method, target: target, action: action, autoComplete: autoComplete, encType: enctype, acceptCharset: acceptCharset || acceptcharset, noValidate: noHtml5Validate, onSubmit: this.onSubmit, as: as, ref: this.formElement, children: [showErrorList === 'top' && this.renderErrors(registry), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SchemaField, { name: '', schema: schema, uiSchema: uiSchema, errorSchema: errorSchema, idSchema: idSchema, idPrefix: idPrefix, idSeparator: idSeparator, formContext: formContext, formData: formData, onChange: this.onChange, onBlur: this.onBlur, onFocus: this.onFocus, registry: registry, disabled: disabled, readonly: readonly }), children ? children : (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SubmitButton, { uiSchema: submitUiSchema, registry: registry }), showErrorList === 'bottom' && this.renderErrors(registry)] }));
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/ArrayField.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/ArrayField.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/cloneDeep */ "../../node_modules/lodash/cloneDeep.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! nanoid */ "../../node_modules/nanoid/index.browser.js");








/** Used to generate a unique ID for an element in a row */
function generateRowId() {
    return (0,nanoid__WEBPACK_IMPORTED_MODULE_7__.nanoid)();
}
/** Converts the `formData` into `KeyedFormDataType` data, using the `generateRowId()` function to create the key
 *
 * @param formData - The data for the form
 * @returns - The `formData` converted into a `KeyedFormDataType` element
 */
function generateKeyedFormData(formData) {
    return !Array.isArray(formData)
        ? []
        : formData.map((item) => {
            return {
                key: generateRowId(),
                item,
            };
        });
}
/** Converts `KeyedFormDataType` data into the inner `formData`
 *
 * @param keyedFormData - The `KeyedFormDataType` to be converted
 * @returns - The inner `formData` item(s) in the `keyedFormData`
 */
function keyedToPlainFormData(keyedFormData) {
    if (Array.isArray(keyedFormData)) {
        return keyedFormData.map((keyedItem) => keyedItem.item);
    }
    return [];
}
/** The `ArrayField` component is used to render a field in the schema that is of type `array`. It supports both normal
 * and fixed array, allowing user to add and remove elements from the array data.
 */
class ArrayField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    /** Constructs an `ArrayField` from the `props`, generating the initial keyed data from the `formData`
     *
     * @param props - The `FieldProps` for this template
     */
    constructor(props) {
        super(props);
        /** Returns the default form information for an item based on the schema for that item. Deals with the possibility
         * that the schema is fixed and allows additional items.
         */
        this._getNewFormDataRow = () => {
            const { schema, registry } = this.props;
            const { schemaUtils } = registry;
            let itemSchema = schema.items;
            if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isFixedItems)(schema) && (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.allowAdditionalItems)(schema)) {
                itemSchema = schema.additionalItems;
            }
            // Cast this as a T to work around schema utils being for T[] caused by the FieldProps<T[], S, F> call on the class
            return schemaUtils.getDefaultFormState(itemSchema);
        };
        /** Callback handler for when the user clicks on the add button. Creates a new row of keyed form data at the end of
         * the list, adding it into the state, and then returning `onChange()` with the plain form data converted from the
         * keyed data
         *
         * @param event - The event for the click
         */
        this.onAddClick = (event) => {
            this._handleAddClick(event);
        };
        /** Callback handler for when the user clicks on the add button on an existing array element. Creates a new row of
         * keyed form data inserted at the `index`, adding it into the state, and then returning `onChange()` with the plain
         * form data converted from the keyed data
         *
         * @param index - The index at which the add button is clicked
         */
        this.onAddIndexClick = (index) => {
            return (event) => {
                this._handleAddClick(event, index);
            };
        };
        /** Callback handler for when the user clicks on the copy button on an existing array element. Clones the row of
         * keyed form data at the `index` into the next position in the state, and then returning `onChange()` with the plain
         * form data converted from the keyed data
         *
         * @param index - The index at which the copy button is clicked
         */
        this.onCopyIndexClick = (index) => {
            return (event) => {
                if (event) {
                    event.preventDefault();
                }
                const { onChange, errorSchema } = this.props;
                const { keyedFormData } = this.state;
                // refs #195: revalidate to ensure properly reindexing errors
                let newErrorSchema;
                if (errorSchema) {
                    newErrorSchema = {};
                    for (const idx in errorSchema) {
                        const i = parseInt(idx);
                        if (i <= index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i], errorSchema[idx]);
                        }
                        else if (i > index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i + 1], errorSchema[idx]);
                        }
                    }
                }
                const newKeyedFormDataRow = {
                    key: generateRowId(),
                    item: lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3___default()(keyedFormData[index].item),
                };
                const newKeyedFormData = [...keyedFormData];
                if (index !== undefined) {
                    newKeyedFormData.splice(index + 1, 0, newKeyedFormDataRow);
                }
                else {
                    newKeyedFormData.push(newKeyedFormDataRow);
                }
                this.setState({
                    keyedFormData: newKeyedFormData,
                    updatedKeyedFormData: true,
                }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));
            };
        };
        /** Callback handler for when the user clicks on the remove button on an existing array element. Removes the row of
         * keyed form data at the `index` in the state, and then returning `onChange()` with the plain form data converted
         * from the keyed data
         *
         * @param index - The index at which the remove button is clicked
         */
        this.onDropIndexClick = (index) => {
            return (event) => {
                if (event) {
                    event.preventDefault();
                }
                const { onChange, errorSchema } = this.props;
                const { keyedFormData } = this.state;
                // refs #195: revalidate to ensure properly reindexing errors
                let newErrorSchema;
                if (errorSchema) {
                    newErrorSchema = {};
                    for (const idx in errorSchema) {
                        const i = parseInt(idx);
                        if (i < index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i], errorSchema[idx]);
                        }
                        else if (i > index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i - 1], errorSchema[idx]);
                        }
                    }
                }
                const newKeyedFormData = keyedFormData.filter((_, i) => i !== index);
                this.setState({
                    keyedFormData: newKeyedFormData,
                    updatedKeyedFormData: true,
                }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));
            };
        };
        /** Callback handler for when the user clicks on one of the move item buttons on an existing array element. Moves the
         * row of keyed form data at the `index` to the `newIndex` in the state, and then returning `onChange()` with the
         * plain form data converted from the keyed data
         *
         * @param index - The index of the item to move
         * @param newIndex - The index to where the item is to be moved
         */
        this.onReorderClick = (index, newIndex) => {
            return (event) => {
                if (event) {
                    event.preventDefault();
                    event.currentTarget.blur();
                }
                const { onChange, errorSchema } = this.props;
                let newErrorSchema;
                if (errorSchema) {
                    newErrorSchema = {};
                    for (const idx in errorSchema) {
                        const i = parseInt(idx);
                        if (i == index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [newIndex], errorSchema[index]);
                        }
                        else if (i == newIndex) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [index], errorSchema[newIndex]);
                        }
                        else {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [idx], errorSchema[i]);
                        }
                    }
                }
                const { keyedFormData } = this.state;
                function reOrderArray() {
                    // Copy item
                    const _newKeyedFormData = keyedFormData.slice();
                    // Moves item from index to newIndex
                    _newKeyedFormData.splice(index, 1);
                    _newKeyedFormData.splice(newIndex, 0, keyedFormData[index]);
                    return _newKeyedFormData;
                }
                const newKeyedFormData = reOrderArray();
                this.setState({
                    keyedFormData: newKeyedFormData,
                }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));
            };
        };
        /** Callback handler used to deal with changing the value of the data in the array at the `index`. Calls the
         * `onChange` callback with the updated form data
         *
         * @param index - The index of the item being changed
         */
        this.onChangeForIndex = (index) => {
            return (value, newErrorSchema, id) => {
                const { formData, onChange, errorSchema } = this.props;
                const arrayData = Array.isArray(formData) ? formData : [];
                const newFormData = arrayData.map((item, i) => {
                    // We need to treat undefined items as nulls to have validation.
                    // See https://github.com/tdegrunt/jsonschema/issues/206
                    const jsonValue = typeof value === 'undefined' ? null : value;
                    return index === i ? jsonValue : item;
                });
                onChange(newFormData, errorSchema &&
                    errorSchema && {
                    ...errorSchema,
                    [index]: newErrorSchema,
                }, id);
            };
        };
        /** Callback handler used to change the value for a checkbox */
        this.onSelectChange = (value) => {
            const { onChange, idSchema } = this.props;
            onChange(value, undefined, idSchema && idSchema.$id);
        };
        const { formData = [] } = props;
        const keyedFormData = generateKeyedFormData(formData);
        this.state = {
            keyedFormData,
            updatedKeyedFormData: false,
        };
    }
    /** React lifecycle method that is called when the props are about to change allowing the state to be updated. It
     * regenerates the keyed form data and returns it
     *
     * @param nextProps - The next set of props data
     * @param prevState - The previous set of state data
     */
    static getDerivedStateFromProps(nextProps, prevState) {
        // Don't call getDerivedStateFromProps if keyed formdata was just updated.
        if (prevState.updatedKeyedFormData) {
            return {
                updatedKeyedFormData: false,
            };
        }
        const nextFormData = Array.isArray(nextProps.formData) ? nextProps.formData : [];
        const previousKeyedFormData = prevState.keyedFormData || [];
        const newKeyedFormData = nextFormData.length === previousKeyedFormData.length
            ? previousKeyedFormData.map((previousKeyedFormDatum, index) => {
                return {
                    key: previousKeyedFormDatum.key,
                    item: nextFormData[index],
                };
            })
            : generateKeyedFormData(nextFormData);
        return {
            keyedFormData: newKeyedFormData,
        };
    }
    /** Returns the appropriate title for an item by getting first the title from the schema.items, then falling back to
     * the description from the schema.items, and finally the string "Item"
     */
    get itemTitle() {
        const { schema, registry } = this.props;
        const { translateString } = registry;
        return lodash_get__WEBPACK_IMPORTED_MODULE_4___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY, 'title'], lodash_get__WEBPACK_IMPORTED_MODULE_4___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY, 'description'], translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.ArrayItemTitle)));
    }
    /** Determines whether the item described in the schema is always required, which is determined by whether any item
     * may be null.
     *
     * @param itemSchema - The schema for the item
     * @return - True if the item schema type does not contain the "null" type
     */
    isItemRequired(itemSchema) {
        if (Array.isArray(itemSchema.type)) {
            // While we don't yet support composite/nullable jsonschema types, it's
            // future-proof to check for requirement against these.
            return !itemSchema.type.includes('null');
        }
        // All non-null array item types are inherently required by design
        return itemSchema.type !== 'null';
    }
    /** Determines whether more items can be added to the array. If the uiSchema indicates the array doesn't allow adding
     * then false is returned. Otherwise, if the schema indicates that there are a maximum number of items and the
     * `formData` matches that value, then false is returned, otherwise true is returned.
     *
     * @param formItems - The list of items in the form
     * @returns - True if the item is addable otherwise false
     */
    canAddItem(formItems) {
        const { schema, uiSchema, registry } = this.props;
        let { addable } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, registry.globalUiOptions);
        if (addable !== false) {
            // if ui:options.addable was not explicitly set to false, we can add
            // another item if we have not exceeded maxItems yet
            if (schema.maxItems !== undefined) {
                addable = formItems.length < schema.maxItems;
            }
            else {
                addable = true;
            }
        }
        return addable;
    }
    /** Callback handler for when the user clicks on the add or add at index buttons. Creates a new row of keyed form data
     * either at the end of the list (when index is not specified) or inserted at the `index` when it is, adding it into
     * the state, and then returning `onChange()` with the plain form data converted from the keyed data
     *
     * @param event - The event for the click
     * @param [index] - The optional index at which to add the new data
     */
    _handleAddClick(event, index) {
        if (event) {
            event.preventDefault();
        }
        const { onChange, errorSchema } = this.props;
        const { keyedFormData } = this.state;
        // refs #195: revalidate to ensure properly reindexing errors
        let newErrorSchema;
        if (errorSchema) {
            newErrorSchema = {};
            for (const idx in errorSchema) {
                const i = parseInt(idx);
                if (index === undefined || i < index) {
                    lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i], errorSchema[idx]);
                }
                else if (i >= index) {
                    lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i + 1], errorSchema[idx]);
                }
            }
        }
        const newKeyedFormDataRow = {
            key: generateRowId(),
            item: this._getNewFormDataRow(),
        };
        const newKeyedFormData = [...keyedFormData];
        if (index !== undefined) {
            newKeyedFormData.splice(index, 0, newKeyedFormDataRow);
        }
        else {
            newKeyedFormData.push(newKeyedFormDataRow);
        }
        this.setState({
            keyedFormData: newKeyedFormData,
            updatedKeyedFormData: true,
        }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));
    }
    /** Renders the `ArrayField` depending on the specific needs of the schema and uischema elements
     */
    render() {
        const { schema, uiSchema, idSchema, registry } = this.props;
        const { schemaUtils, translateString } = registry;
        if (!(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY in schema)) {
            const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
            const UnsupportedFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('UnsupportedFieldTemplate', registry, uiOptions);
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnsupportedFieldTemplate, { schema: schema, idSchema: idSchema, reason: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.MissingItems), registry: registry }));
        }
        if (schemaUtils.isMultiSelect(schema)) {
            // If array has enum or uniqueItems set to true, call renderMultiSelect() to render the default multiselect widget or a custom widget, if specified.
            return this.renderMultiSelect();
        }
        if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isCustomWidget)(uiSchema)) {
            return this.renderCustomWidget();
        }
        if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isFixedItems)(schema)) {
            return this.renderFixedArray();
        }
        if (schemaUtils.isFilesArray(schema, uiSchema)) {
            return this.renderFiles();
        }
        return this.renderNormalArray();
    }
    /** Renders a normal array without any limitations of length
     */
    renderNormalArray() {
        const { schema, uiSchema = {}, errorSchema, idSchema, name, title, disabled = false, readonly = false, autofocus = false, required = false, registry, onBlur, onFocus, idPrefix, idSeparator = '_', rawErrors, } = this.props;
        const { keyedFormData } = this.state;
        const fieldTitle = schema.title || title || name;
        const { schemaUtils, formContext } = registry;
        const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
        const _schemaItems = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.items) ? schema.items : {};
        const itemsSchema = schemaUtils.retrieveSchema(_schemaItems);
        const formData = keyedToPlainFormData(this.state.keyedFormData);
        const canAdd = this.canAddItem(formData);
        const arrayProps = {
            canAdd,
            items: keyedFormData.map((keyedItem, index) => {
                const { key, item } = keyedItem;
                // While we are actually dealing with a single item of type T, the types require a T[], so cast
                const itemCast = item;
                const itemSchema = schemaUtils.retrieveSchema(_schemaItems, itemCast);
                const itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
                const itemIdPrefix = idSchema.$id + idSeparator + index;
                const itemIdSchema = schemaUtils.toIdSchema(itemSchema, itemIdPrefix, itemCast, idPrefix, idSeparator);
                return this.renderArrayFieldItem({
                    key,
                    index,
                    name: name && `${name}-${index}`,
                    title: fieldTitle ? `${fieldTitle}-${index + 1}` : undefined,
                    canAdd,
                    canMoveUp: index > 0,
                    canMoveDown: index < formData.length - 1,
                    itemSchema,
                    itemIdSchema,
                    itemErrorSchema,
                    itemData: itemCast,
                    itemUiSchema: uiSchema.items,
                    autofocus: autofocus && index === 0,
                    onBlur,
                    onFocus,
                    rawErrors,
                    totalItems: keyedFormData.length,
                });
            }),
            className: `field field-array field-array-of-${itemsSchema.type}`,
            disabled,
            idSchema,
            uiSchema,
            onAddClick: this.onAddClick,
            readonly,
            required,
            schema,
            title: fieldTitle,
            formContext,
            formData,
            rawErrors,
            registry,
        };
        const Template = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ArrayFieldTemplate', registry, uiOptions);
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Template, { ...arrayProps });
    }
    /** Renders an array using the custom widget provided by the user in the `uiSchema`
     */
    renderCustomWidget() {
        var _a;
        const { schema, idSchema, uiSchema, disabled = false, readonly = false, autofocus = false, required = false, hideError, placeholder, onBlur, onFocus, formData: items = [], registry, rawErrors, name, } = this.props;
        const { widgets, formContext, globalUiOptions, schemaUtils } = registry;
        const { widget, title: uiTitle, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);
        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;
        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, options: options, schema: schema, uiSchema: uiSchema, registry: registry, value: items, disabled: disabled, readonly: readonly, hideError: hideError, required: required, label: label, hideLabel: !displayLabel, placeholder: placeholder, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors }));
    }
    /** Renders an array as a set of checkboxes
     */
    renderMultiSelect() {
        var _a;
        const { schema, idSchema, uiSchema, formData: items = [], disabled = false, readonly = false, autofocus = false, required = false, placeholder, onBlur, onFocus, registry, rawErrors, name, } = this.props;
        const { widgets, schemaUtils, formContext, globalUiOptions } = registry;
        const itemsSchema = schemaUtils.retrieveSchema(schema.items, items);
        const enumOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.optionsList)(itemsSchema, uiSchema);
        const { widget = 'select', title: uiTitle, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);
        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;
        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, options: { ...options, enumOptions }, schema: schema, uiSchema: uiSchema, registry: registry, value: items, disabled: disabled, readonly: readonly, required: required, label: label, hideLabel: !displayLabel, placeholder: placeholder, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors }));
    }
    /** Renders an array of files using the `FileWidget`
     */
    renderFiles() {
        var _a;
        const { schema, uiSchema, idSchema, name, disabled = false, readonly = false, autofocus = false, required = false, onBlur, onFocus, registry, formData: items = [], rawErrors, } = this.props;
        const { widgets, formContext, globalUiOptions, schemaUtils } = registry;
        const { widget = 'files', title: uiTitle, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);
        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;
        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { options: options, id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, schema: schema, uiSchema: uiSchema, value: items, disabled: disabled, readonly: readonly, required: required, registry: registry, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors, label: label, hideLabel: !displayLabel }));
    }
    /** Renders an array that has a maximum limit of items
     */
    renderFixedArray() {
        const { schema, uiSchema = {}, formData = [], errorSchema, idPrefix, idSeparator = '_', idSchema, name, title, disabled = false, readonly = false, autofocus = false, required = false, registry, onBlur, onFocus, rawErrors, } = this.props;
        const { keyedFormData } = this.state;
        let { formData: items = [] } = this.props;
        const fieldTitle = schema.title || title || name;
        const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
        const { schemaUtils, formContext } = registry;
        const _schemaItems = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.items) ? schema.items : [];
        const itemSchemas = _schemaItems.map((item, index) => schemaUtils.retrieveSchema(item, formData[index]));
        const additionalSchema = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.additionalItems)
            ? schemaUtils.retrieveSchema(schema.additionalItems, formData)
            : null;
        if (!items || items.length < itemSchemas.length) {
            // to make sure at least all fixed items are generated
            items = items || [];
            items = items.concat(new Array(itemSchemas.length - items.length));
        }
        // These are the props passed into the render function
        const canAdd = this.canAddItem(items) && !!additionalSchema;
        const arrayProps = {
            canAdd,
            className: 'field field-array field-array-fixed-items',
            disabled,
            idSchema,
            formData,
            items: keyedFormData.map((keyedItem, index) => {
                const { key, item } = keyedItem;
                // While we are actually dealing with a single item of type T, the types require a T[], so cast
                const itemCast = item;
                const additional = index >= itemSchemas.length;
                const itemSchema = (additional && lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.additionalItems)
                    ? schemaUtils.retrieveSchema(schema.additionalItems, itemCast)
                    : itemSchemas[index]) || {};
                const itemIdPrefix = idSchema.$id + idSeparator + index;
                const itemIdSchema = schemaUtils.toIdSchema(itemSchema, itemIdPrefix, itemCast, idPrefix, idSeparator);
                const itemUiSchema = additional
                    ? uiSchema.additionalItems || {}
                    : Array.isArray(uiSchema.items)
                        ? uiSchema.items[index]
                        : uiSchema.items || {};
                const itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
                return this.renderArrayFieldItem({
                    key,
                    index,
                    name: name && `${name}-${index}`,
                    title: fieldTitle ? `${fieldTitle}-${index + 1}` : undefined,
                    canAdd,
                    canRemove: additional,
                    canMoveUp: index >= itemSchemas.length + 1,
                    canMoveDown: additional && index < items.length - 1,
                    itemSchema,
                    itemData: itemCast,
                    itemUiSchema,
                    itemIdSchema,
                    itemErrorSchema,
                    autofocus: autofocus && index === 0,
                    onBlur,
                    onFocus,
                    rawErrors,
                    totalItems: keyedFormData.length,
                });
            }),
            onAddClick: this.onAddClick,
            readonly,
            required,
            registry,
            schema,
            uiSchema,
            title: fieldTitle,
            formContext,
            errorSchema,
            rawErrors,
        };
        const Template = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ArrayFieldTemplate', registry, uiOptions);
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Template, { ...arrayProps });
    }
    /** Renders the individual array item using a `SchemaField` along with the additional properties required to be send
     * back to the `ArrayFieldItemTemplate`.
     *
     * @param props - The props for the individual array item to be rendered
     */
    renderArrayFieldItem(props) {
        const { key, index, name, canAdd, canRemove = true, canMoveUp, canMoveDown, itemSchema, itemData, itemUiSchema, itemIdSchema, itemErrorSchema, autofocus, onBlur, onFocus, rawErrors, totalItems, title, } = props;
        const { disabled, hideError, idPrefix, idSeparator, readonly, uiSchema, registry, formContext } = this.props;
        const { fields: { ArraySchemaField, SchemaField }, globalUiOptions, } = registry;
        const ItemSchemaField = ArraySchemaField || SchemaField;
        const { orderable = true, removable = true, copyable = false } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const has = {
            moveUp: orderable && canMoveUp,
            moveDown: orderable && canMoveDown,
            copy: copyable && canAdd,
            remove: removable && canRemove,
            toolbar: false,
        };
        has.toolbar = Object.keys(has).some((key) => has[key]);
        return {
            children: ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ItemSchemaField, { name: name, title: title, index: index, schema: itemSchema, uiSchema: itemUiSchema, formData: itemData, formContext: formContext, errorSchema: itemErrorSchema, idPrefix: idPrefix, idSeparator: idSeparator, idSchema: itemIdSchema, required: this.isItemRequired(itemSchema), onChange: this.onChangeForIndex(index), onBlur: onBlur, onFocus: onFocus, registry: registry, disabled: disabled, readonly: readonly, hideError: hideError, autofocus: autofocus, rawErrors: rawErrors })),
            className: 'array-item',
            disabled,
            canAdd,
            hasCopy: has.copy,
            hasToolbar: has.toolbar,
            hasMoveUp: has.moveUp,
            hasMoveDown: has.moveDown,
            hasRemove: has.remove,
            index,
            totalItems,
            key,
            onAddIndexClick: this.onAddIndexClick,
            onCopyIndexClick: this.onCopyIndexClick,
            onDropIndexClick: this.onDropIndexClick,
            onReorderClick: this.onReorderClick,
            readonly,
            registry,
            schema: itemSchema,
            uiSchema: itemUiSchema,
        };
    }
}
/** `ArrayField` is `React.ComponentType<FieldProps<T[], S, F>>` (necessarily) but the `registry` requires things to be a
 * `Field` which is defined as `React.ComponentType<FieldProps<T, S, F>>`, so cast it to make `registry` happy.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ArrayField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/BooleanField.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/BooleanField.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_2__);



/** The `BooleanField` component is used to render a field in the schema is boolean. It constructs `enumOptions` for the
 * two boolean values based on the various alternatives in the schema.
 *
 * @param props - The `FieldProps` for this template
 */
function BooleanField(props) {
    var _a, _b, _c;
    const { schema, name, uiSchema, idSchema, formData, registry, required, disabled, readonly, hideError, autofocus, title, onChange, onFocus, onBlur, rawErrors, } = props;
    const { title: schemaTitle } = schema;
    const { widgets, formContext, translateString, globalUiOptions } = registry;
    const { widget = 'checkbox', title: uiTitle, 
    // Unlike the other fields, don't use `getDisplayLabel()` since it always returns false for the boolean type
    label: displayLabel = true, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema, globalUiOptions);
    const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getWidget)(schema, widget, widgets);
    const yes = translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.YesLabel);
    const no = translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.NoLabel);
    let enumOptions;
    const label = (_b = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schemaTitle) !== null && _a !== void 0 ? _a : title) !== null && _b !== void 0 ? _b : name;
    if (Array.isArray(schema.oneOf)) {
        enumOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.optionsList)({
            oneOf: schema.oneOf
                .map((option) => {
                if (lodash_isObject__WEBPACK_IMPORTED_MODULE_2___default()(option)) {
                    return {
                        ...option,
                        title: option.title || (option.const === true ? yes : no),
                    };
                }
                return undefined;
            })
                .filter((o) => o), // cast away the error that typescript can't grok is fixed
        }, uiSchema);
    }
    else {
        // We deprecated enumNames in v5. It's intentionally omitted from RSJFSchema type, so we need to cast here.
        const schemaWithEnumNames = schema;
        const enums = (_c = schema.enum) !== null && _c !== void 0 ? _c : [true, false];
        if (!schemaWithEnumNames.enumNames && enums.length === 2 && enums.every((v) => typeof v === 'boolean')) {
            enumOptions = [
                {
                    value: enums[0],
                    label: enums[0] ? yes : no,
                },
                {
                    value: enums[1],
                    label: enums[1] ? yes : no,
                },
            ];
        }
        else {
            enumOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.optionsList)({
                enum: enums,
                // NOTE: enumNames is deprecated, but still supported for now.
                enumNames: schemaWithEnumNames.enumNames,
            }, uiSchema);
        }
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { options: { ...options, enumOptions }, schema: schema, uiSchema: uiSchema, id: idSchema.$id, name: name, onChange: onChange, onFocus: onFocus, onBlur: onBlur, label: label, hideLabel: !displayLabel, value: formData, required: required, disabled: disabled, readonly: readonly, hideError: hideError, registry: registry, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BooleanField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/MultiSchemaField.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/MultiSchemaField.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/omit */ "../../node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__);






/** The `AnyOfField` component is used to render a field in the schema that is an `anyOf`, `allOf` or `oneOf`. It tracks
 * the currently selected option and cleans up any irrelevant data in `formData`.
 *
 * @param props - The `FieldProps` for this template
 */
class AnyOfField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    /** Constructs an `AnyOfField` with the given `props` to initialize the initially selected option in state
     *
     * @param props - The `FieldProps` for this template
     */
    constructor(props) {
        super(props);
        /** Callback handler to remember what the currently selected option is. In addition to that the `formData` is updated
         * to remove properties that are not part of the newly selected option schema, and then the updated data is passed to
         * the `onChange` handler.
         *
         * @param option - The new option value being selected
         */
        this.onOptionChange = (option) => {
            const { selectedOption, retrievedOptions } = this.state;
            const { formData, onChange, registry } = this.props;
            const { schemaUtils } = registry;
            const intOption = option !== undefined ? parseInt(option, 10) : -1;
            if (intOption === selectedOption) {
                return;
            }
            const newOption = intOption >= 0 ? retrievedOptions[intOption] : undefined;
            const oldOption = selectedOption >= 0 ? retrievedOptions[selectedOption] : undefined;
            let newFormData = schemaUtils.sanitizeDataForNewSchema(newOption, oldOption, formData);
            if (newFormData && newOption) {
                // Call getDefaultFormState to make sure defaults are populated on change. Pass "excludeObjectChildren"
                // so that only the root objects themselves are created without adding undefined children properties
                newFormData = schemaUtils.getDefaultFormState(newOption, newFormData, 'excludeObjectChildren');
            }
            onChange(newFormData, undefined, this.getFieldId());
            this.setState({ selectedOption: intOption });
        };
        const { formData, options, registry: { schemaUtils }, } = this.props;
        // cache the retrieved options in state in case they have $refs to save doing it later
        const retrievedOptions = options.map((opt) => schemaUtils.retrieveSchema(opt, formData));
        this.state = {
            retrievedOptions,
            selectedOption: this.getMatchingOption(0, formData, retrievedOptions),
        };
    }
    /** React lifecycle method that is called when the props and/or state for this component is updated. It recomputes the
     * currently selected option based on the overall `formData`
     *
     * @param prevProps - The previous `FieldProps` for this template
     * @param prevState - The previous `AnyOfFieldState` for this template
     */
    componentDidUpdate(prevProps, prevState) {
        const { formData, options, idSchema } = this.props;
        const { selectedOption } = this.state;
        let newState = this.state;
        if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.deepEquals)(prevProps.options, options)) {
            const { registry: { schemaUtils }, } = this.props;
            // re-cache the retrieved options in state in case they have $refs to save doing it later
            const retrievedOptions = options.map((opt) => schemaUtils.retrieveSchema(opt, formData));
            newState = { selectedOption, retrievedOptions };
        }
        if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.deepEquals)(formData, prevProps.formData) && idSchema.$id === prevProps.idSchema.$id) {
            const { retrievedOptions } = newState;
            const matchingOption = this.getMatchingOption(selectedOption, formData, retrievedOptions);
            if (prevState && matchingOption !== selectedOption) {
                newState = { selectedOption: matchingOption, retrievedOptions };
            }
        }
        if (newState !== this.state) {
            this.setState(newState);
        }
    }
    /** Determines the best matching option for the given `formData` and `options`.
     *
     * @param formData - The new formData
     * @param options - The list of options to choose from
     * @return - The index of the `option` that best matches the `formData`
     */
    getMatchingOption(selectedOption, formData, options) {
        const { schema, registry: { schemaUtils }, } = this.props;
        const discriminator = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.getDiscriminatorFieldFromSchema)(schema);
        const option = schemaUtils.getClosestMatchingOption(formData, options, selectedOption, discriminator);
        return option;
    }
    getFieldId() {
        const { idSchema, schema } = this.props;
        return `${idSchema.$id}${schema.oneOf ? '__oneof_select' : '__anyof_select'}`;
    }
    /** Renders the `AnyOfField` selector along with a `SchemaField` for the value of the `formData`
     */
    render() {
        const { name, disabled = false, errorSchema = {}, formContext, onBlur, onFocus, registry, schema, uiSchema, } = this.props;
        const { widgets, fields, translateString, globalUiOptions, schemaUtils } = registry;
        const { SchemaField: _SchemaField } = fields;
        const { selectedOption, retrievedOptions } = this.state;
        const { widget = 'select', placeholder, autofocus, autocomplete, title = schema.title, ...uiOptions } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.getUiOptions)(uiSchema, globalUiOptions);
        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.getWidget)({ type: 'number' }, widget, widgets);
        const rawErrors = lodash_get__WEBPACK_IMPORTED_MODULE_2___default()(errorSchema, _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ERRORS_KEY, []);
        const fieldErrorSchema = lodash_omit__WEBPACK_IMPORTED_MODULE_4___default()(errorSchema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ERRORS_KEY]);
        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
        const option = selectedOption >= 0 ? retrievedOptions[selectedOption] || null : null;
        let optionSchema;
        if (option) {
            // merge top level required field
            const { required } = schema;
            // Merge in all the non-oneOf/anyOf properties and also skip the special ADDITIONAL_PROPERTY_FLAG property
            optionSchema = required ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.mergeSchemas)({ required }, option) : option;
        }
        // First we will check to see if there is an anyOf/oneOf override for the UI schema
        let optionsUiSchema = [];
        if (_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY in schema && uiSchema && _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY in uiSchema) {
            if (Array.isArray(uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY])) {
                optionsUiSchema = uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY];
            }
            else {
                console.warn(`uiSchema.oneOf is not an array for "${title || name}"`);
            }
        }
        else if (_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY in schema && uiSchema && _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY in uiSchema) {
            if (Array.isArray(uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY])) {
                optionsUiSchema = uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY];
            }
            else {
                console.warn(`uiSchema.anyOf is not an array for "${title || name}"`);
            }
        }
        // Then we pick the one that matches the selected option index, if one exists otherwise default to the main uiSchema
        let optionUiSchema = uiSchema;
        if (selectedOption >= 0 && optionsUiSchema.length > selectedOption) {
            optionUiSchema = optionsUiSchema[selectedOption];
        }
        const translateEnum = title
            ? _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.TranslatableString.TitleOptionPrefix
            : _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.TranslatableString.OptionPrefix;
        const translateParams = title ? [title] : [];
        const enumOptions = retrievedOptions.map((opt, index) => {
            // Also see if there is an override title in the uiSchema for each option, otherwise use the title from the option
            const { title: uiTitle = opt.title } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.getUiOptions)(optionsUiSchema[index]);
            return {
                label: uiTitle || translateString(translateEnum, translateParams.concat(String(index + 1))),
                value: index,
            };
        });
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'panel panel-default panel-body', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'form-group', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { id: this.getFieldId(), name: `${name}${schema.oneOf ? '__oneof_select' : '__anyof_select'}`, schema: { type: 'number', default: 0 }, onChange: this.onOptionChange, onBlur: onBlur, onFocus: onFocus, disabled: disabled || lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default()(enumOptions), multiple: false, rawErrors: rawErrors, errorSchema: fieldErrorSchema, value: selectedOption >= 0 ? selectedOption : undefined, options: { enumOptions, ...uiOptions }, registry: registry, formContext: formContext, placeholder: placeholder, autocomplete: autocomplete, autofocus: autofocus, label: title !== null && title !== void 0 ? title : name, hideLabel: !displayLabel }) }), optionSchema && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SchemaField, { ...this.props, schema: optionSchema, uiSchema: optionUiSchema })] }));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AnyOfField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/NullField.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/NullField.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/** The `NullField` component is used to render a field in the schema is null. It also ensures that the `formData` is
 * also set to null if it has no value.
 *
 * @param props - The `FieldProps` for this template
 */
function NullField(props) {
    const { formData, onChange } = props;
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (formData === undefined) {
            onChange(null);
        }
    }, [formData, onChange]);
    return null;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NullField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/NumberField.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/NumberField.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



// Matches a string that ends in a . character, optionally followed by a sequence of
// digits followed by any number of 0 characters up until the end of the line.
// Ensuring that there is at least one prefixed character is important so that
// you don't incorrectly match against "0".
const trailingCharMatcherWithPrefix = /\.([0-9]*0)*$/;
// This is used for trimming the trailing 0 and . characters without affecting
// the rest of the string. Its possible to use one RegEx with groups for this
// functionality, but it is fairly complex compared to simply defining two
// different matchers.
const trailingCharMatcher = /[0.]0*$/;
/**
 * The NumberField class has some special handling for dealing with trailing
 * decimal points and/or zeroes. This logic is designed to allow trailing values
 * to be visible in the input element, but not be represented in the
 * corresponding form data.
 *
 * The algorithm is as follows:
 *
 * 1. When the input value changes the value is cached in the component state
 *
 * 2. The value is then normalized, removing trailing decimal points and zeros,
 *    then passed to the "onChange" callback
 *
 * 3. When the component is rendered, the formData value is checked against the
 *    value cached in the state. If it matches the cached value, the cached
 *    value is passed to the input instead of the formData value
 */
function NumberField(props) {
    const { registry, onChange, formData, value: initialValue } = props;
    const [lastValue, setLastValue] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(initialValue);
    const { StringField } = registry.fields;
    let value = formData;
    /** Handle the change from the `StringField` to properly convert to a number
     *
     * @param value - The current value for the change occurring
     */
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => {
        // Cache the original value in component state
        setLastValue(value);
        // Normalize decimals that don't start with a zero character in advance so
        // that the rest of the normalization logic is simpler
        if (`${value}`.charAt(0) === '.') {
            value = `0${value}`;
        }
        // Check that the value is a string (this can happen if the widget used is a
        // <select>, due to an enum declaration etc) then, if the value ends in a
        // trailing decimal point or multiple zeroes, strip the trailing values
        const processed = typeof value === 'string' && value.match(trailingCharMatcherWithPrefix)
            ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.asNumber)(value.replace(trailingCharMatcher, ''))
            : (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.asNumber)(value);
        onChange(processed);
    }, [onChange]);
    if (typeof lastValue === 'string' && typeof value === 'number') {
        // Construct a regular expression that checks for a string that consists
        // of the formData value suffixed with zero or one '.' characters and zero
        // or more '0' characters
        const re = new RegExp(`^(${String(value).replace('.', '\\.')})?\\.?0*$`);
        // If the cached "lastValue" is a match, use that instead of the formData
        // value to prevent the input value from changing in the UI
        if (lastValue.match(re)) {
            value = lastValue;
        }
    }
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StringField, { ...props, formData: value, onChange: handleChange });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NumberField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/ObjectField.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/ObjectField.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var markdown_to_jsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! markdown-to-jsx */ "../../node_modules/markdown-to-jsx/dist/index.modern.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/has */ "../../node_modules/lodash/has.js");
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_has__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var lodash_unset__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash/unset */ "../../node_modules/lodash/unset.js");
/* harmony import */ var lodash_unset__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash_unset__WEBPACK_IMPORTED_MODULE_7__);









/** The `ObjectField` component is used to render a field in the schema that is of type `object`. It tracks whether an
 * additional property key was modified and what it was modified to
 *
 * @param props - The `FieldProps` for this template
 */
class ObjectField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor() {
        super(...arguments);
        /** Set up the initial state */
        this.state = {
            wasPropertyKeyModified: false,
            additionalProperties: {},
        };
        /** Returns the `onPropertyChange` handler for the `name` field. Handles the special case where a user is attempting
         * to clear the data for a field added as an additional property. Calls the `onChange()` handler with the updated
         * formData.
         *
         * @param name - The name of the property
         * @param addedByAdditionalProperties - Flag indicating whether this property is an additional property
         * @returns - The onPropertyChange callback for the `name` property
         */
        this.onPropertyChange = (name, addedByAdditionalProperties = false) => {
            return (value, newErrorSchema, id) => {
                const { formData, onChange, errorSchema } = this.props;
                if (value === undefined && addedByAdditionalProperties) {
                    // Don't set value = undefined for fields added by
                    // additionalProperties. Doing so removes them from the
                    // formData, which causes them to completely disappear
                    // (including the input field for the property name). Unlike
                    // fields which are "mandated" by the schema, these fields can
                    // be set to undefined by clicking a "delete field" button, so
                    // set empty values to the empty string.
                    value = '';
                }
                const newFormData = { ...formData, [name]: value };
                onChange(newFormData, errorSchema &&
                    errorSchema && {
                    ...errorSchema,
                    [name]: newErrorSchema,
                }, id);
            };
        };
        /** Returns a callback to handle the onDropPropertyClick event for the given `key` which removes the old `key` data
         * and calls the `onChange` callback with it
         *
         * @param key - The key for which the drop callback is desired
         * @returns - The drop property click callback
         */
        this.onDropPropertyClick = (key) => {
            return (event) => {
                event.preventDefault();
                const { onChange, formData } = this.props;
                const copiedFormData = { ...formData };
                lodash_unset__WEBPACK_IMPORTED_MODULE_7___default()(copiedFormData, key);
                onChange(copiedFormData);
            };
        };
        /** Computes the next available key name from the `preferredKey`, indexing through the already existing keys until one
         * that is already not assigned is found.
         *
         * @param preferredKey - The preferred name of a new key
         * @param [formData] - The form data in which to check if the desired key already exists
         * @returns - The name of the next available key from `preferredKey`
         */
        this.getAvailableKey = (preferredKey, formData) => {
            const { uiSchema, registry } = this.props;
            const { duplicateKeySuffixSeparator = '-' } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, registry.globalUiOptions);
            let index = 0;
            let newKey = preferredKey;
            while (lodash_has__WEBPACK_IMPORTED_MODULE_4___default()(formData, newKey)) {
                newKey = `${preferredKey}${duplicateKeySuffixSeparator}${++index}`;
            }
            return newKey;
        };
        /** Returns a callback function that deals with the rename of a key for an additional property for a schema. That
         * callback will attempt to rename the key and move the existing data to that key, calling `onChange` when it does.
         *
         * @param oldValue - The old value of a field
         * @returns - The key change callback function
         */
        this.onKeyChange = (oldValue) => {
            return (value, newErrorSchema) => {
                if (oldValue === value) {
                    return;
                }
                const { formData, onChange, errorSchema } = this.props;
                value = this.getAvailableKey(value, formData);
                const newFormData = {
                    ...formData,
                };
                const newKeys = { [oldValue]: value };
                const keyValues = Object.keys(newFormData).map((key) => {
                    const newKey = newKeys[key] || key;
                    return { [newKey]: newFormData[key] };
                });
                const renamedObj = Object.assign({}, ...keyValues);
                this.setState({ wasPropertyKeyModified: true });
                onChange(renamedObj, errorSchema &&
                    errorSchema && {
                    ...errorSchema,
                    [value]: newErrorSchema,
                });
            };
        };
        /** Handles the adding of a new additional property on the given `schema`. Calls the `onChange` callback once the new
         * default data for that field has been added to the formData.
         *
         * @param schema - The schema element to which the new property is being added
         */
        this.handleAddClick = (schema) => () => {
            if (!schema.additionalProperties) {
                return;
            }
            const { formData, onChange, registry } = this.props;
            const newFormData = { ...formData };
            let type = undefined;
            let defaultValue = undefined;
            if (lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.additionalProperties)) {
                type = schema.additionalProperties.type;
                defaultValue = schema.additionalProperties.default;
                let apSchema = schema.additionalProperties;
                if (_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.REF_KEY in apSchema) {
                    const { schemaUtils } = registry;
                    apSchema = schemaUtils.retrieveSchema({ $ref: apSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.REF_KEY] }, formData);
                    type = apSchema.type;
                    defaultValue = apSchema.default;
                }
                if (!type && (_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ANY_OF_KEY in apSchema || _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ONE_OF_KEY in apSchema)) {
                    type = 'object';
                }
            }
            const newKey = this.getAvailableKey('newKey', newFormData);
            // Cast this to make the `set` work properly
            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newFormData, newKey, defaultValue !== null && defaultValue !== void 0 ? defaultValue : this.getDefaultValue(type));
            onChange(newFormData);
        };
    }
    /** Returns a flag indicating whether the `name` field is required in the object schema
     *
     * @param name - The name of the field to check for required-ness
     * @returns - True if the field `name` is required, false otherwise
     */
    isRequired(name) {
        const { schema } = this.props;
        return Array.isArray(schema.required) && schema.required.indexOf(name) !== -1;
    }
    /** Returns a default value to be used for a new additional schema property of the given `type`
     *
     * @param type - The type of the new additional schema property
     */
    getDefaultValue(type) {
        const { registry: { translateString }, } = this.props;
        switch (type) {
            case 'array':
                return [];
            case 'boolean':
                return false;
            case 'null':
                return null;
            case 'number':
                return 0;
            case 'object':
                return {};
            case 'string':
            default:
                // We don't have a datatype for some reason (perhaps additionalProperties was true)
                return translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.NewStringDefault);
        }
    }
    /** Renders the `ObjectField` from the given props
     */
    render() {
        var _a, _b, _c, _d;
        const { schema: rawSchema, uiSchema = {}, formData, errorSchema, idSchema, name, required = false, disabled, readonly, hideError, idPrefix, idSeparator, onBlur, onFocus, registry, title, } = this.props;
        const { fields, formContext, schemaUtils, translateString, globalUiOptions } = registry;
        const { SchemaField } = fields;
        const schema = schemaUtils.retrieveSchema(rawSchema, formData);
        const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const { properties: schemaProperties = {} } = schema;
        const templateTitle = (_c = (_b = (_a = uiOptions.title) !== null && _a !== void 0 ? _a : schema.title) !== null && _b !== void 0 ? _b : title) !== null && _c !== void 0 ? _c : name;
        const description = (_d = uiOptions.description) !== null && _d !== void 0 ? _d : schema.description;
        let orderedProperties;
        try {
            const properties = Object.keys(schemaProperties);
            orderedProperties = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.orderProperties)(properties, uiOptions.order);
        }
        catch (err) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { className: 'config-error', style: { color: 'red' }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(markdown_to_jsx__WEBPACK_IMPORTED_MODULE_8__["default"], { options: { disableParsingRawHTML: true }, children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.InvalidObjectField, [name || 'root', err.message]) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("pre", { children: JSON.stringify(schema) })] }));
        }
        const Template = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ObjectFieldTemplate', registry, uiOptions);
        const templateProps = {
            // getDisplayLabel() always returns false for object types, so just check the `uiOptions.label`
            title: uiOptions.label === false ? '' : templateTitle,
            description: uiOptions.label === false ? undefined : description,
            properties: orderedProperties.map((name) => {
                const addedByAdditionalProperties = lodash_has__WEBPACK_IMPORTED_MODULE_4___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, name, _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ADDITIONAL_PROPERTY_FLAG]);
                const fieldUiSchema = addedByAdditionalProperties ? uiSchema.additionalProperties : uiSchema[name];
                const hidden = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(fieldUiSchema).widget === 'hidden';
                const fieldIdSchema = lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(idSchema, [name], {});
                return {
                    content: ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SchemaField, { name: name, required: this.isRequired(name), schema: lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, name], {}), uiSchema: fieldUiSchema, errorSchema: lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(errorSchema, name), idSchema: fieldIdSchema, idPrefix: idPrefix, idSeparator: idSeparator, formData: lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(formData, name), formContext: formContext, wasPropertyKeyModified: this.state.wasPropertyKeyModified, onKeyChange: this.onKeyChange(name), onChange: this.onPropertyChange(name, addedByAdditionalProperties), onBlur: onBlur, onFocus: onFocus, registry: registry, disabled: disabled, readonly: readonly, hideError: hideError, onDropPropertyClick: this.onDropPropertyClick }, name)),
                    name,
                    readonly,
                    disabled,
                    required,
                    hidden,
                };
            }),
            readonly,
            disabled,
            required,
            idSchema,
            uiSchema,
            errorSchema,
            schema,
            formData,
            formContext,
            registry,
        };
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Template, { ...templateProps, onAddClick: this.handleAddClick });
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ObjectField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/SchemaField.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/SchemaField.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/omit */ "../../node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var markdown_to_jsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! markdown-to-jsx */ "../../node_modules/markdown-to-jsx/dist/index.modern.js");






/** The map of component type to FieldName */
const COMPONENT_TYPES = {
    array: 'ArrayField',
    boolean: 'BooleanField',
    integer: 'NumberField',
    number: 'NumberField',
    object: 'ObjectField',
    string: 'StringField',
    null: 'NullField',
};
/** Computes and returns which `Field` implementation to return in order to render the field represented by the
 * `schema`. The `uiOptions` are used to alter what potential `Field` implementation is actually returned. If no
 * appropriate `Field` implementation can be found then a wrapper around `UnsupportedFieldTemplate` is used.
 *
 * @param schema - The schema from which to obtain the type
 * @param uiOptions - The UI Options that may affect the component decision
 * @param idSchema - The id that is passed to the `UnsupportedFieldTemplate`
 * @param registry - The registry from which fields and templates are obtained
 * @returns - The `Field` component that is used to render the actual field data
 */
function getFieldComponent(schema, uiOptions, idSchema, registry) {
    const field = uiOptions.field;
    const { fields, translateString } = registry;
    if (typeof field === 'function') {
        return field;
    }
    if (typeof field === 'string' && field in fields) {
        return fields[field];
    }
    const schemaType = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getSchemaType)(schema);
    const type = Array.isArray(schemaType) ? schemaType[0] : schemaType || '';
    const schemaId = schema.$id;
    let componentName = COMPONENT_TYPES[type];
    if (schemaId && schemaId in fields) {
        componentName = schemaId;
    }
    // If the type is not defined and the schema uses 'anyOf' or 'oneOf', don't
    // render a field and let the MultiSchemaField component handle the form display
    if (!componentName && (schema.anyOf || schema.oneOf)) {
        return () => null;
    }
    return componentName in fields
        ? fields[componentName]
        : () => {
            const UnsupportedFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('UnsupportedFieldTemplate', registry, uiOptions);
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnsupportedFieldTemplate, { schema: schema, idSchema: idSchema, reason: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.UnknownFieldType, [String(schema.type)]), registry: registry }));
        };
}
/** The `SchemaFieldRender` component is the work-horse of react-jsonschema-form, determining what kind of real field to
 * render based on the `schema`, `uiSchema` and all the other props. It also deals with rendering the `anyOf` and
 * `oneOf` fields.
 *
 * @param props - The `FieldProps` for this component
 */
function SchemaFieldRender(props) {
    var _a, _b, _c;
    const { schema: _schema, idSchema: _idSchema, uiSchema, formData, errorSchema, idPrefix, idSeparator, name, onChange, onKeyChange, onDropPropertyClick, required, registry, wasPropertyKeyModified = false, } = props;
    const { formContext, schemaUtils, globalUiOptions } = registry;
    const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
    const FieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('FieldTemplate', registry, uiOptions);
    const DescriptionFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('DescriptionFieldTemplate', registry, uiOptions);
    const FieldHelpTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('FieldHelpTemplate', registry, uiOptions);
    const FieldErrorTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('FieldErrorTemplate', registry, uiOptions);
    const schema = schemaUtils.retrieveSchema(_schema, formData);
    const fieldId = _idSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ID_KEY];
    const idSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.mergeObjects)(schemaUtils.toIdSchema(schema, fieldId, formData, idPrefix, idSeparator), _idSchema);
    /** Intermediary `onChange` handler for field components that will inject the `id` of the current field into the
     * `onChange` chain if it is not already being provided from a deeper level in the hierarchy
     */
    const handleFieldComponentChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((formData, newErrorSchema, id) => {
        const theId = id || fieldId;
        return onChange(formData, newErrorSchema, theId);
    }, [fieldId, onChange]);
    const FieldComponent = getFieldComponent(schema, uiOptions, idSchema, registry);
    const disabled = Boolean((_a = uiOptions.disabled) !== null && _a !== void 0 ? _a : props.disabled);
    const readonly = Boolean((_b = uiOptions.readonly) !== null && _b !== void 0 ? _b : (props.readonly || props.schema.readOnly || schema.readOnly));
    const uiSchemaHideError = uiOptions.hideError;
    // Set hideError to the value provided in the uiSchema, otherwise stick with the prop to propagate to children
    const hideError = uiSchemaHideError === undefined ? props.hideError : Boolean(uiSchemaHideError);
    const autofocus = Boolean((_c = uiOptions.autofocus) !== null && _c !== void 0 ? _c : props.autofocus);
    if (Object.keys(schema).length === 0) {
        return null;
    }
    const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
    const { __errors, ...fieldErrorSchema } = errorSchema || {};
    // See #439: uiSchema: Don't pass consumed class names or style to child components
    const fieldUiSchema = lodash_omit__WEBPACK_IMPORTED_MODULE_4___default()(uiSchema, ['ui:classNames', 'classNames', 'ui:style']);
    if (_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_OPTIONS_KEY in fieldUiSchema) {
        fieldUiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_OPTIONS_KEY] = lodash_omit__WEBPACK_IMPORTED_MODULE_4___default()(fieldUiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_OPTIONS_KEY], ['classNames', 'style']);
    }
    const field = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldComponent, { ...props, onChange: handleFieldComponentChange, idSchema: idSchema, schema: schema, uiSchema: fieldUiSchema, disabled: disabled, readonly: readonly, hideError: hideError, autofocus: autofocus, errorSchema: fieldErrorSchema, formContext: formContext, rawErrors: __errors }));
    const id = idSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ID_KEY];
    // If this schema has a title defined, but the user has set a new key/label, retain their input.
    let label;
    if (wasPropertyKeyModified) {
        label = name;
    }
    else {
        label =
            _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ADDITIONAL_PROPERTY_FLAG in schema
                ? name
                : uiOptions.title || props.schema.title || schema.title || props.title || name;
    }
    const description = uiOptions.description || props.schema.description || schema.description || '';
    const richDescription = uiOptions.enableMarkdownInDescription ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(markdown_to_jsx__WEBPACK_IMPORTED_MODULE_5__["default"], { options: { disableParsingRawHTML: true }, children: description })) : (description);
    const help = uiOptions.help;
    const hidden = uiOptions.widget === 'hidden';
    const classNames = ['form-group', 'field', `field-${(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getSchemaType)(schema)}`];
    if (!hideError && __errors && __errors.length > 0) {
        classNames.push('field-error has-error has-danger');
    }
    if (uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema.classNames) {
        if (true) {
            console.warn("'uiSchema.classNames' is deprecated and may be removed in a major release; Use 'ui:classNames' instead.");
        }
        classNames.push(uiSchema.classNames);
    }
    if (uiOptions.classNames) {
        classNames.push(uiOptions.classNames);
    }
    const helpComponent = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldHelpTemplate, { help: help, idSchema: idSchema, schema: schema, uiSchema: uiSchema, hasErrors: !hideError && __errors && __errors.length > 0, registry: registry }));
    /*
     * AnyOf/OneOf errors handled by child schema
     * unless it can be rendered as select control
     */
    const errorsComponent = hideError || ((schema.anyOf || schema.oneOf) && !schemaUtils.isSelect(schema)) ? undefined : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldErrorTemplate, { errors: __errors, errorSchema: errorSchema, idSchema: idSchema, schema: schema, uiSchema: uiSchema, registry: registry }));
    const fieldProps = {
        description: ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DescriptionFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.descriptionId)(id), description: richDescription, schema: schema, uiSchema: uiSchema, registry: registry })),
        rawDescription: description,
        help: helpComponent,
        rawHelp: typeof help === 'string' ? help : undefined,
        errors: errorsComponent,
        rawErrors: hideError ? undefined : __errors,
        id,
        label,
        hidden,
        onChange,
        onKeyChange,
        onDropPropertyClick,
        required,
        disabled,
        readonly,
        hideError,
        displayLabel,
        classNames: classNames.join(' ').trim(),
        style: uiOptions.style,
        formContext,
        formData,
        schema,
        uiSchema,
        registry,
    };
    const _AnyOfField = registry.fields.AnyOfField;
    const _OneOfField = registry.fields.OneOfField;
    const isReplacingAnyOrOneOf = (uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema['ui:field']) && (uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema['ui:fieldReplacesAnyOrOneOf']) === true;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldTemplate, { ...fieldProps, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [field, schema.anyOf && !isReplacingAnyOrOneOf && !schemaUtils.isSelect(schema) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_AnyOfField, { name: name, disabled: disabled, readonly: readonly, hideError: hideError, errorSchema: errorSchema, formData: formData, formContext: formContext, idPrefix: idPrefix, idSchema: idSchema, idSeparator: idSeparator, onBlur: props.onBlur, onChange: props.onChange, onFocus: props.onFocus, options: schema.anyOf.map((_schema) => schemaUtils.retrieveSchema(lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default()(_schema) ? _schema : {}, formData)), registry: registry, schema: schema, uiSchema: uiSchema })), schema.oneOf && !isReplacingAnyOrOneOf && !schemaUtils.isSelect(schema) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_OneOfField, { name: name, disabled: disabled, readonly: readonly, hideError: hideError, errorSchema: errorSchema, formData: formData, formContext: formContext, idPrefix: idPrefix, idSchema: idSchema, idSeparator: idSeparator, onBlur: props.onBlur, onChange: props.onChange, onFocus: props.onFocus, options: schema.oneOf.map((_schema) => schemaUtils.retrieveSchema(lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default()(_schema) ? _schema : {}, formData)), registry: registry, schema: schema, uiSchema: uiSchema }))] }) }));
}
/** The `SchemaField` component determines whether it is necessary to rerender the component based on any props changes
 * and if so, calls the `SchemaFieldRender` component with the props.
 */
class SchemaField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    shouldComponentUpdate(nextProps) {
        return !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(this.props, nextProps);
    }
    render() {
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SchemaFieldRender, { ...this.props });
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/StringField.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/StringField.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `StringField` component is used to render a schema field that represents a string type
 *
 * @param props - The `FieldProps` for this template
 */
function StringField(props) {
    var _a;
    const { schema, name, uiSchema, idSchema, formData, required, disabled = false, readonly = false, autofocus = false, onChange, onBlur, onFocus, registry, rawErrors, hideError, } = props;
    const { title, format } = schema;
    const { widgets, formContext, schemaUtils, globalUiOptions } = registry;
    const enumOptions = schemaUtils.isSelect(schema) ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.optionsList)(schema, uiSchema) : undefined;
    let defaultWidget = enumOptions ? 'select' : 'text';
    if (format && (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.hasWidget)(schema, format, widgets)) {
        defaultWidget = format;
    }
    const { widget = defaultWidget, placeholder = '', title: uiTitle, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema);
    const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
    const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : title) !== null && _a !== void 0 ? _a : name;
    const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getWidget)(schema, widget, widgets);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { options: { ...options, enumOptions }, schema: schema, uiSchema: uiSchema, id: idSchema.$id, name: name, label: label, hideLabel: !displayLabel, hideError: hideError, value: formData, onChange: onChange, onBlur: onBlur, onFocus: onFocus, required: required, disabled: disabled, readonly: readonly, formContext: formContext, autofocus: autofocus, registry: registry, placeholder: placeholder, rawErrors: rawErrors }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StringField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/index.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ArrayField__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ArrayField */ "../../node_modules/@rjsf/core/lib/components/fields/ArrayField.js");
/* harmony import */ var _BooleanField__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BooleanField */ "../../node_modules/@rjsf/core/lib/components/fields/BooleanField.js");
/* harmony import */ var _MultiSchemaField__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MultiSchemaField */ "../../node_modules/@rjsf/core/lib/components/fields/MultiSchemaField.js");
/* harmony import */ var _NumberField__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./NumberField */ "../../node_modules/@rjsf/core/lib/components/fields/NumberField.js");
/* harmony import */ var _ObjectField__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ObjectField */ "../../node_modules/@rjsf/core/lib/components/fields/ObjectField.js");
/* harmony import */ var _SchemaField__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SchemaField */ "../../node_modules/@rjsf/core/lib/components/fields/SchemaField.js");
/* harmony import */ var _StringField__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./StringField */ "../../node_modules/@rjsf/core/lib/components/fields/StringField.js");
/* harmony import */ var _NullField__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./NullField */ "../../node_modules/@rjsf/core/lib/components/fields/NullField.js");








function fields() {
    return {
        AnyOfField: _MultiSchemaField__WEBPACK_IMPORTED_MODULE_2__["default"],
        ArrayField: _ArrayField__WEBPACK_IMPORTED_MODULE_0__["default"],
        // ArrayField falls back to SchemaField if ArraySchemaField is not defined, which it isn't by default
        BooleanField: _BooleanField__WEBPACK_IMPORTED_MODULE_1__["default"],
        NumberField: _NumberField__WEBPACK_IMPORTED_MODULE_3__["default"],
        ObjectField: _ObjectField__WEBPACK_IMPORTED_MODULE_4__["default"],
        OneOfField: _MultiSchemaField__WEBPACK_IMPORTED_MODULE_2__["default"],
        SchemaField: _SchemaField__WEBPACK_IMPORTED_MODULE_5__["default"],
        StringField: _StringField__WEBPACK_IMPORTED_MODULE_6__["default"],
        NullField: _NullField__WEBPACK_IMPORTED_MODULE_7__["default"],
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (fields);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldDescriptionTemplate.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldDescriptionTemplate.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ArrayFieldDescriptionTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `ArrayFieldDescriptionTemplate` component renders a `DescriptionFieldTemplate` with an `id` derived from
 * the `idSchema`.
 *
 * @param props - The `ArrayFieldDescriptionProps` for the component
 */
function ArrayFieldDescriptionTemplate(props) {
    const { idSchema, description, registry, schema, uiSchema } = props;
    const options = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema, registry.globalUiOptions);
    const { label: displayLabel = true } = options;
    if (!description || !displayLabel) {
        return null;
    }
    const DescriptionFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('DescriptionFieldTemplate', registry, options);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DescriptionFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.descriptionId)(idSchema), description: description, schema: schema, uiSchema: uiSchema, registry: registry }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldItemTemplate.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldItemTemplate.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ArrayFieldItemTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `ArrayFieldItemTemplate` component is the template used to render an items of an array.
 *
 * @param props - The `ArrayFieldTemplateItemType` props for the component
 */
function ArrayFieldItemTemplate(props) {
    const { children, className, disabled, hasToolbar, hasMoveDown, hasMoveUp, hasRemove, hasCopy, index, onCopyIndexClick, onDropIndexClick, onReorderClick, readonly, registry, uiSchema, } = props;
    const { CopyButton, MoveDownButton, MoveUpButton, RemoveButton } = registry.templates.ButtonTemplates;
    const btnStyle = {
        flex: 1,
        paddingLeft: 6,
        paddingRight: 6,
        fontWeight: 'bold',
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: className, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: hasToolbar ? 'col-xs-9' : 'col-xs-12', children: children }), hasToolbar && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-3 array-item-toolbox', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'btn-group', style: {
                        display: 'flex',
                        justifyContent: 'space-around',
                    }, children: [(hasMoveUp || hasMoveDown) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MoveUpButton, { style: btnStyle, disabled: disabled || readonly || !hasMoveUp, onClick: onReorderClick(index, index - 1), uiSchema: uiSchema, registry: registry })), (hasMoveUp || hasMoveDown) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MoveDownButton, { style: btnStyle, disabled: disabled || readonly || !hasMoveDown, onClick: onReorderClick(index, index + 1), uiSchema: uiSchema, registry: registry })), hasCopy && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(CopyButton, { style: btnStyle, disabled: disabled || readonly, onClick: onCopyIndexClick(index), uiSchema: uiSchema, registry: registry })), hasRemove && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RemoveButton, { style: btnStyle, disabled: disabled || readonly, onClick: onDropIndexClick(index), uiSchema: uiSchema, registry: registry }))] }) }))] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTemplate.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTemplate.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ArrayFieldTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `ArrayFieldTemplate` component is the template used to render all items in an array.
 *
 * @param props - The `ArrayFieldTemplateItemType` props for the component
 */
function ArrayFieldTemplate(props) {
    const { canAdd, className, disabled, idSchema, uiSchema, items, onAddClick, readonly, registry, required, schema, title, } = props;
    const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema);
    const ArrayFieldDescriptionTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('ArrayFieldDescriptionTemplate', registry, uiOptions);
    const ArrayFieldItemTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('ArrayFieldItemTemplate', registry, uiOptions);
    const ArrayFieldTitleTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('ArrayFieldTitleTemplate', registry, uiOptions);
    // Button templates are not overridden in the uiSchema
    const { ButtonTemplates: { AddButton }, } = registry.templates;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("fieldset", { className: className, id: idSchema.$id, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ArrayFieldTitleTemplate, { idSchema: idSchema, title: uiOptions.title || title, required: required, schema: schema, uiSchema: uiSchema, registry: registry }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ArrayFieldDescriptionTemplate, { idSchema: idSchema, description: uiOptions.description || schema.description, schema: schema, uiSchema: uiSchema, registry: registry }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'row array-item-list', children: items &&
                    items.map(({ key, ...itemProps }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ArrayFieldItemTemplate, { ...itemProps }, key))) }), canAdd && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AddButton, { className: 'array-item-add', onClick: onAddClick, disabled: disabled || readonly, uiSchema: uiSchema, registry: registry }))] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTitleTemplate.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTitleTemplate.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ArrayFieldTitleTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `ArrayFieldTitleTemplate` component renders a `TitleFieldTemplate` with an `id` derived from
 * the `idSchema`.
 *
 * @param props - The `ArrayFieldTitleProps` for the component
 */
function ArrayFieldTitleTemplate(props) {
    const { idSchema, title, schema, uiSchema, required, registry } = props;
    const options = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema, registry.globalUiOptions);
    const { label: displayLabel = true } = options;
    if (!title || !displayLabel) {
        return null;
    }
    const TitleFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('TitleFieldTemplate', registry, options);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TitleFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.titleId)(idSchema), title: title, required: required, schema: schema, uiSchema: uiSchema, registry: registry }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/BaseInputTemplate.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/BaseInputTemplate.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BaseInputTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



/** The `BaseInputTemplate` is the template to use to render the basic `<input>` component for the `core` theme.
 * It is used as the template for rendering many of the <input> based widgets that differ by `type` and callbacks only.
 * It can be customized/overridden for other themes or individual implementations as needed.
 *
 * @param props - The `WidgetProps` for this template
 */
function BaseInputTemplate(props) {
    const { id, name, // remove this from ...rest
    value, readonly, disabled, autofocus, onBlur, onFocus, onChange, onChangeOverride, options, schema, uiSchema, formContext, registry, rawErrors, type, hideLabel, // remove this from ...rest
    hideError, // remove this from ...rest
    ...rest } = props;
    // Note: since React 15.2.0 we can't forward unknown element attributes, so we
    // exclude the "options" and "schema" ones here.
    if (!id) {
        console.log('No id for', props);
        throw new Error(`no id for props ${JSON.stringify(props)}`);
    }
    const inputProps = {
        ...rest,
        ...(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getInputProps)(schema, type, options),
    };
    let inputValue;
    if (inputProps.type === 'number' || inputProps.type === 'integer') {
        inputValue = value || value === 0 ? value : '';
    }
    else {
        inputValue = value == null ? '' : value;
    }
    const _onChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target: { value } }) => onChange(value === '' ? options.emptyValue : value), [onChange, options]);
    const _onBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onBlur(id, target && target.value), [onBlur, id]);
    const _onFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onFocus(id, target && target.value), [onFocus, id]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { id: id, name: id, className: 'form-control', readOnly: readonly, disabled: disabled, autoFocus: autofocus, value: inputValue, ...inputProps, list: schema.examples ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.examplesId)(id) : undefined, onChange: onChangeOverride || _onChange, onBlur: _onBlur, onFocus: _onFocus, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id, !!schema.examples) }), Array.isArray(schema.examples) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("datalist", { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.examplesId)(id), children: schema.examples
                    .concat(schema.default && !schema.examples.includes(schema.default) ? [schema.default] : [])
                    .map((example) => {
                    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("option", { value: example }, example);
                }) }, `datalist_${id}`))] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/AddButton.js":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/AddButton.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AddButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IconButton */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/IconButton.js");



/** The `AddButton` renders a button that represent the `Add` action on a form
 */
function AddButton({ className, onClick, disabled, registry, }) {
    const { translateString } = registry;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'row', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { className: `col-xs-3 col-xs-offset-9 text-right ${className}`, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_IconButton__WEBPACK_IMPORTED_MODULE_2__["default"], { iconType: 'info', icon: 'plus', className: 'btn-add col-xs-12', title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.AddButton), onClick: onClick, disabled: disabled, registry: registry }) }) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/IconButton.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/IconButton.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CopyButton: () => (/* binding */ CopyButton),
/* harmony export */   MoveDownButton: () => (/* binding */ MoveDownButton),
/* harmony export */   MoveUpButton: () => (/* binding */ MoveUpButton),
/* harmony export */   RemoveButton: () => (/* binding */ RemoveButton),
/* harmony export */   "default": () => (/* binding */ IconButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


function IconButton(props) {
    const { iconType = 'default', icon, className, uiSchema, registry, ...otherProps } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { type: 'button', className: `btn btn-${iconType} ${className}`, ...otherProps, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("i", { className: `glyphicon glyphicon-${icon}` }) }));
}
function CopyButton(props) {
    const { registry: { translateString }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IconButton, { title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.CopyButton), className: 'array-item-copy', ...props, icon: 'copy' }));
}
function MoveDownButton(props) {
    const { registry: { translateString }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IconButton, { title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.MoveDownButton), className: 'array-item-move-down', ...props, icon: 'arrow-down' }));
}
function MoveUpButton(props) {
    const { registry: { translateString }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IconButton, { title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.MoveUpButton), className: 'array-item-move-up', ...props, icon: 'arrow-up' }));
}
function RemoveButton(props) {
    const { registry: { translateString }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IconButton, { title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.RemoveButton), className: 'array-item-remove', ...props, iconType: 'danger', icon: 'remove' }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/SubmitButton.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/SubmitButton.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SubmitButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `SubmitButton` renders a button that represent the `Submit` action on a form
 */
function SubmitButton({ uiSchema }) {
    const { submitText, norender, props: submitButtonProps = {} } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getSubmitButtonOptions)(uiSchema);
    if (norender) {
        return null;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { type: 'submit', ...submitButtonProps, className: `btn btn-info ${submitButtonProps.className || ''}`, children: submitText }) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/index.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/index.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SubmitButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SubmitButton */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/SubmitButton.js");
/* harmony import */ var _AddButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AddButton */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/AddButton.js");
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IconButton */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/IconButton.js");



function buttonTemplates() {
    return {
        SubmitButton: _SubmitButton__WEBPACK_IMPORTED_MODULE_0__["default"],
        AddButton: _AddButton__WEBPACK_IMPORTED_MODULE_1__["default"],
        CopyButton: _IconButton__WEBPACK_IMPORTED_MODULE_2__.CopyButton,
        MoveDownButton: _IconButton__WEBPACK_IMPORTED_MODULE_2__.MoveDownButton,
        MoveUpButton: _IconButton__WEBPACK_IMPORTED_MODULE_2__.MoveUpButton,
        RemoveButton: _IconButton__WEBPACK_IMPORTED_MODULE_2__.RemoveButton,
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (buttonTemplates);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/DescriptionField.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/DescriptionField.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DescriptionField)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `DescriptionField` is the template to use to render the description of a field
 *
 * @param props - The `DescriptionFieldProps` for this component
 */
function DescriptionField(props) {
    const { id, description } = props;
    if (!description) {
        return null;
    }
    if (typeof description === 'string') {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { id: id, className: 'field-description', children: description }));
    }
    else {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: id, className: 'field-description', children: description }));
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ErrorList.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ErrorList.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorList)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `ErrorList` component is the template that renders the all the errors associated with the fields in the `Form`
 *
 * @param props - The `ErrorListProps` for this component
 */
function ErrorList({ errors, registry, }) {
    const { translateString } = registry;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'panel panel-danger errors', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'panel-heading', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { className: 'panel-title', children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.ErrorsLabel) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { className: 'list-group', children: errors.map((error, i) => {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'list-group-item text-danger', children: error.stack }, i));
                }) })] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldErrorTemplate.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldErrorTemplate.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FieldErrorTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `FieldErrorTemplate` component renders the errors local to the particular field
 *
 * @param props - The `FieldErrorProps` for the errors being rendered
 */
function FieldErrorTemplate(props) {
    const { errors = [], idSchema } = props;
    if (errors.length === 0) {
        return null;
    }
    const id = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.errorId)(idSchema);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { id: id, className: 'error-detail bs-callout bs-callout-info', children: errors
                .filter((elem) => !!elem)
                .map((error, index) => {
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'text-danger', children: error }, index));
            }) }) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldHelpTemplate.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldHelpTemplate.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FieldHelpTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `FieldHelpTemplate` component renders any help desired for a field
 *
 * @param props - The `FieldHelpProps` to be rendered
 */
function FieldHelpTemplate(props) {
    const { idSchema, help } = props;
    if (!help) {
        return null;
    }
    const id = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.helpId)(idSchema);
    if (typeof help === 'string') {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { id: id, className: 'help-block', children: help }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: id, className: 'help-block', children: help }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/FieldTemplate.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/FieldTemplate.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FieldTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Label */ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/Label.js");



/** The `FieldTemplate` component is the template used by `SchemaField` to render any field. It renders the field
 * content, (label, description, children, errors and help) inside of a `WrapIfAdditional` component.
 *
 * @param props - The `FieldTemplateProps` for this component
 */
function FieldTemplate(props) {
    const { id, label, children, errors, help, description, hidden, required, displayLabel, registry, uiSchema } = props;
    const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema);
    const WrapIfAdditionalTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('WrapIfAdditionalTemplate', registry, uiOptions);
    if (hidden) {
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'hidden', children: children });
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(WrapIfAdditionalTemplate, { ...props, children: [displayLabel && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label__WEBPACK_IMPORTED_MODULE_2__["default"], { label: label, required: required, id: id }), displayLabel && description ? description : null, children, errors, help] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/Label.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/Label.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Label)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

const REQUIRED_FIELD_SYMBOL = '*';
/** Renders a label for a field
 *
 * @param props - The `LabelProps` for this component
 */
function Label(props) {
    const { label, required, id } = props;
    if (!label) {
        return null;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("label", { className: 'control-label', htmlFor: id, children: [label, required && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'required', children: REQUIRED_FIELD_SYMBOL })] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FieldTemplate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FieldTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/FieldTemplate.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_FieldTemplate__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ObjectFieldTemplate.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ObjectFieldTemplate.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ObjectFieldTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `ObjectFieldTemplate` is the template to use to render all the inner properties of an object along with the
 * title and description if available. If the object is expandable, then an `AddButton` is also rendered after all
 * the properties.
 *
 * @param props - The `ObjectFieldTemplateProps` for this component
 */
function ObjectFieldTemplate(props) {
    const { description, disabled, formData, idSchema, onAddClick, properties, readonly, registry, required, schema, title, uiSchema, } = props;
    const options = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema);
    const TitleFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('TitleFieldTemplate', registry, options);
    const DescriptionFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('DescriptionFieldTemplate', registry, options);
    // Button templates are not overridden in the uiSchema
    const { ButtonTemplates: { AddButton }, } = registry.templates;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("fieldset", { id: idSchema.$id, children: [title && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TitleFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.titleId)(idSchema), title: title, required: required, schema: schema, uiSchema: uiSchema, registry: registry })), description && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DescriptionFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.descriptionId)(idSchema), description: description, schema: schema, uiSchema: uiSchema, registry: registry })), properties.map((prop) => prop.content), (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.canExpand)(schema, uiSchema, formData) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AddButton, { className: 'object-property-expand', onClick: onAddClick(schema), disabled: disabled || readonly, uiSchema: uiSchema, registry: registry }))] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/TitleField.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/TitleField.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TitleField)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

const REQUIRED_FIELD_SYMBOL = '*';
/** The `TitleField` is the template to use to render the title of a field
 *
 * @param props - The `TitleFieldProps` for this component
 */
function TitleField(props) {
    const { id, title, required } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("legend", { id: id, children: [title, required && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'required', children: REQUIRED_FIELD_SYMBOL })] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/UnsupportedField.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/UnsupportedField.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var markdown_to_jsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! markdown-to-jsx */ "../../node_modules/markdown-to-jsx/dist/index.modern.js");



/** The `UnsupportedField` component is used to render a field in the schema is one that is not supported by
 * react-jsonschema-form.
 *
 * @param props - The `FieldProps` for this template
 */
function UnsupportedField(props) {
    const { schema, idSchema, reason, registry } = props;
    const { translateString } = registry;
    let translateEnum = _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedField;
    const translateParams = [];
    if (idSchema && idSchema.$id) {
        translateEnum = _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedFieldWithId;
        translateParams.push(idSchema.$id);
    }
    if (reason) {
        translateEnum =
            translateEnum === _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedField
                ? _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedFieldWithReason
                : _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedFieldWithIdAndReason;
        translateParams.push(reason);
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'unsupported-field', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(markdown_to_jsx__WEBPACK_IMPORTED_MODULE_2__["default"], { options: { disableParsingRawHTML: true }, children: translateString(translateEnum, translateParams) }) }), schema && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("pre", { children: JSON.stringify(schema, null, 2) })] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UnsupportedField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/WrapIfAdditionalTemplate.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/WrapIfAdditionalTemplate.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WrapIfAdditionalTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _FieldTemplate_Label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FieldTemplate/Label */ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/Label.js");



/** The `WrapIfAdditional` component is used by the `FieldTemplate` to rename, or remove properties that are
 * part of an `additionalProperties` part of a schema.
 *
 * @param props - The `WrapIfAdditionalProps` for this component
 */
function WrapIfAdditionalTemplate(props) {
    const { id, classNames, style, disabled, label, onKeyChange, onDropPropertyClick, readonly, required, schema, children, uiSchema, registry, } = props;
    const { templates, translateString } = registry;
    // Button templates are not overridden in the uiSchema
    const { RemoveButton } = templates.ButtonTemplates;
    const keyLabel = translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.KeyLabel, [label]);
    const additional = _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.ADDITIONAL_PROPERTY_FLAG in schema;
    if (!additional) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classNames, style: style, children: children }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classNames, style: style, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'row', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-5 form-additional', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'form-group', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_FieldTemplate_Label__WEBPACK_IMPORTED_MODULE_2__["default"], { label: keyLabel, required: required, id: `${id}-key` }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { className: 'form-control', type: 'text', id: `${id}-key`, onBlur: ({ target }) => onKeyChange(target && target.value), defaultValue: label })] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'form-additional form-group col-xs-5', children: children }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-2', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RemoveButton, { className: 'array-item-remove btn-block', style: { border: '0' }, disabled: disabled || readonly, onClick: onDropPropertyClick(label), uiSchema: uiSchema, registry: registry }) })] }) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/index.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ArrayFieldDescriptionTemplate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ArrayFieldDescriptionTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldDescriptionTemplate.js");
/* harmony import */ var _ArrayFieldItemTemplate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ArrayFieldItemTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldItemTemplate.js");
/* harmony import */ var _ArrayFieldTemplate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ArrayFieldTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTemplate.js");
/* harmony import */ var _ArrayFieldTitleTemplate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ArrayFieldTitleTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTitleTemplate.js");
/* harmony import */ var _BaseInputTemplate__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BaseInputTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/BaseInputTemplate.js");
/* harmony import */ var _ButtonTemplates__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ButtonTemplates */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/index.js");
/* harmony import */ var _DescriptionField__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DescriptionField */ "../../node_modules/@rjsf/core/lib/components/templates/DescriptionField.js");
/* harmony import */ var _ErrorList__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ErrorList */ "../../node_modules/@rjsf/core/lib/components/templates/ErrorList.js");
/* harmony import */ var _FieldTemplate__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./FieldTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/index.js");
/* harmony import */ var _FieldErrorTemplate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./FieldErrorTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/FieldErrorTemplate.js");
/* harmony import */ var _FieldHelpTemplate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./FieldHelpTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/FieldHelpTemplate.js");
/* harmony import */ var _ObjectFieldTemplate__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ObjectFieldTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ObjectFieldTemplate.js");
/* harmony import */ var _TitleField__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./TitleField */ "../../node_modules/@rjsf/core/lib/components/templates/TitleField.js");
/* harmony import */ var _UnsupportedField__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./UnsupportedField */ "../../node_modules/@rjsf/core/lib/components/templates/UnsupportedField.js");
/* harmony import */ var _WrapIfAdditionalTemplate__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./WrapIfAdditionalTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/WrapIfAdditionalTemplate.js");















function templates() {
    return {
        ArrayFieldDescriptionTemplate: _ArrayFieldDescriptionTemplate__WEBPACK_IMPORTED_MODULE_0__["default"],
        ArrayFieldItemTemplate: _ArrayFieldItemTemplate__WEBPACK_IMPORTED_MODULE_1__["default"],
        ArrayFieldTemplate: _ArrayFieldTemplate__WEBPACK_IMPORTED_MODULE_2__["default"],
        ArrayFieldTitleTemplate: _ArrayFieldTitleTemplate__WEBPACK_IMPORTED_MODULE_3__["default"],
        ButtonTemplates: (0,_ButtonTemplates__WEBPACK_IMPORTED_MODULE_5__["default"])(),
        BaseInputTemplate: _BaseInputTemplate__WEBPACK_IMPORTED_MODULE_4__["default"],
        DescriptionFieldTemplate: _DescriptionField__WEBPACK_IMPORTED_MODULE_6__["default"],
        ErrorListTemplate: _ErrorList__WEBPACK_IMPORTED_MODULE_7__["default"],
        FieldTemplate: _FieldTemplate__WEBPACK_IMPORTED_MODULE_8__["default"],
        FieldErrorTemplate: _FieldErrorTemplate__WEBPACK_IMPORTED_MODULE_9__["default"],
        FieldHelpTemplate: _FieldHelpTemplate__WEBPACK_IMPORTED_MODULE_10__["default"],
        ObjectFieldTemplate: _ObjectFieldTemplate__WEBPACK_IMPORTED_MODULE_11__["default"],
        TitleFieldTemplate: _TitleField__WEBPACK_IMPORTED_MODULE_12__["default"],
        UnsupportedFieldTemplate: _UnsupportedField__WEBPACK_IMPORTED_MODULE_13__["default"],
        WrapIfAdditionalTemplate: _WrapIfAdditionalTemplate__WEBPACK_IMPORTED_MODULE_14__["default"],
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (templates);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/AltDateTimeWidget.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/AltDateTimeWidget.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `AltDateTimeWidget` is an alternative widget for rendering datetime properties.
 *  It uses the AltDateWidget for rendering, with the `time` prop set to true by default.
 *
 * @param props - The `WidgetProps` for this component
 */
function AltDateTimeWidget({ time = true, ...props }) {
    const { AltDateWidget } = props.registry.widgets;
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AltDateWidget, { time: time, ...props });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AltDateTimeWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/AltDateWidget.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/AltDateWidget.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



function readyForChange(state) {
    return Object.values(state).every((value) => value !== -1);
}
function DateElement({ type, range, value, select, rootId, name, disabled, readonly, autofocus, registry, onBlur, onFocus, }) {
    const id = rootId + '_' + type;
    const { SelectWidget } = registry.widgets;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SelectWidget, { schema: { type: 'integer' }, id: id, name: name, className: 'form-control', options: { enumOptions: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.dateRangeOptions)(range[0], range[1]) }, placeholder: type, value: value, disabled: disabled, readonly: readonly, autofocus: autofocus, onChange: (value) => select(type, value), onBlur: onBlur, onFocus: onFocus, registry: registry, label: '', "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(rootId) }));
}
/** The `AltDateWidget` is an alternative widget for rendering date properties.
 * @param props - The `WidgetProps` for this component
 */
function AltDateWidget({ time = false, disabled = false, readonly = false, autofocus = false, options, id, name, registry, onBlur, onFocus, onChange, value, }) {
    const { translateString } = registry;
    const [lastValue, setLastValue] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(value);
    const [state, setState] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useReducer)((state, action) => {
        return { ...state, ...action };
    }, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.parseDateString)(value, time));
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const stateValue = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.toDateString)(state, time);
        if (readyForChange(state) && stateValue !== value) {
            // The user changed the date to a new valid data via the comboboxes, so call onChange
            onChange(stateValue);
        }
        else if (lastValue !== value) {
            // We got a new value in the props
            setLastValue(value);
            setState((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.parseDateString)(value, time));
        }
    }, [time, value, onChange, state, lastValue]);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((property, value) => {
        setState({ [property]: value });
    }, []);
    const handleSetNow = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        event.preventDefault();
        if (disabled || readonly) {
            return;
        }
        const nextState = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.parseDateString)(new Date().toJSON(), time);
        onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.toDateString)(nextState, time));
    }, [disabled, readonly, time]);
    const handleClear = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        event.preventDefault();
        if (disabled || readonly) {
            return;
        }
        onChange(undefined);
    }, [disabled, readonly, onChange]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("ul", { className: 'list-inline', children: [(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getDateElementProps)(state, time, options.yearsRange, options.format).map((elemProps, i) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'list-inline-item', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DateElement, { rootId: id, name: name, select: handleChange, ...elemProps, disabled: disabled, readonly: readonly, registry: registry, onBlur: onBlur, onFocus: onFocus, autofocus: autofocus && i === 0 }) }, i))), (options.hideNowButton !== 'undefined' ? !options.hideNowButton : true) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'list-inline-item', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: '#', className: 'btn btn-info btn-now', onClick: handleSetNow, children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.NowLabel) }) })), (options.hideClearButton !== 'undefined' ? !options.hideClearButton : true) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'list-inline-item', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: '#', className: 'btn btn-warning btn-clear', onClick: handleClear, children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.ClearLabel) }) }))] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AltDateWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/CheckboxWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/CheckboxWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



/** The `CheckBoxWidget` is a widget for rendering boolean properties.
 *  It is typically used to represent a boolean.
 *
 * @param props - The `WidgetProps` for this component
 */
function CheckboxWidget({ schema, uiSchema, options, id, value, disabled, readonly, label, hideLabel, autofocus = false, onBlur, onFocus, onChange, registry, }) {
    var _a;
    const DescriptionFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('DescriptionFieldTemplate', registry, options);
    // Because an unchecked checkbox will cause html5 validation to fail, only add
    // the "required" attribute if the field value must be "true", due to the
    // "const" or "enum" keywords
    const required = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.schemaRequiresTrueValue)(schema);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => onChange(event.target.checked), [onChange]);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => onBlur(id, event.target.checked), [onBlur, id]);
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => onFocus(id, event.target.checked), [onFocus, id]);
    const description = (_a = options.description) !== null && _a !== void 0 ? _a : schema.description;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: `checkbox ${disabled || readonly ? 'disabled' : ''}`, children: [!hideLabel && !!description && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DescriptionFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.descriptionId)(id), description: description, schema: schema, uiSchema: uiSchema, registry: registry })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("label", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'checkbox', id: id, name: id, checked: typeof value === 'undefined' ? false : value, required: required, disabled: disabled || readonly, autoFocus: autofocus, onChange: handleChange, onBlur: handleBlur, onFocus: handleFocus, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id) }), (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.labelValue)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { children: label }), hideLabel)] })] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/CheckboxesWidget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/CheckboxesWidget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



/** The `CheckboxesWidget` is a widget for rendering checkbox groups.
 *  It is typically used to represent an array of enums.
 *
 * @param props - The `WidgetProps` for this component
 */
function CheckboxesWidget({ id, disabled, options: { inline = false, enumOptions, enumDisabled, emptyValue }, value, autofocus = false, readonly, onChange, onBlur, onFocus, }) {
    const checkboxesValues = Array.isArray(value) ? value : [value];
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onBlur(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(target && target.value, enumOptions, emptyValue)), [onBlur, id]);
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onFocus(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(target && target.value, enumOptions, emptyValue)), [onFocus, id]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'checkboxes', id: id, children: Array.isArray(enumOptions) &&
            enumOptions.map((option, index) => {
                const checked = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsIsSelected)(option.value, checkboxesValues);
                const itemDisabled = Array.isArray(enumDisabled) && enumDisabled.indexOf(option.value) !== -1;
                const disabledCls = disabled || itemDisabled || readonly ? 'disabled' : '';
                const handleChange = (event) => {
                    if (event.target.checked) {
                        onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsSelectValue)(index, checkboxesValues, enumOptions));
                    }
                    else {
                        onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsDeselectValue)(index, checkboxesValues, enumOptions));
                    }
                };
                const checkbox = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'checkbox', id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.optionId)(id, index), name: id, checked: checked, value: String(index), disabled: disabled || itemDisabled || readonly, autoFocus: autofocus && index === 0, onChange: handleChange, onBlur: handleBlur, onFocus: handleFocus, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { children: option.label })] }));
                return inline ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { className: `checkbox-inline ${disabledCls}`, children: checkbox }, index)) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `checkbox ${disabledCls}`, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { children: checkbox }) }, index));
            }) }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxesWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/ColorWidget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/ColorWidget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ColorWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `ColorWidget` component uses the `BaseInputTemplate` changing the type to `color` and disables it when it is
 * either disabled or readonly.
 *
 * @param props - The `WidgetProps` for this component
 */
function ColorWidget(props) {
    const { disabled, readonly, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'color', ...props, disabled: disabled || readonly });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/DateTimeWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/DateTimeWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DateTimeWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `DateTimeWidget` component uses the `BaseInputTemplate` changing the type to `datetime-local` and transforms
 * the value to/from utc using the appropriate utility functions.
 *
 * @param props - The `WidgetProps` for this component
 */
function DateTimeWidget(props) {
    const { onChange, value, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'datetime-local', ...props, value: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.utcToLocal)(value), onChange: (value) => onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.localToUTC)(value)) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/DateWidget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/DateWidget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DateWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



/** The `DateWidget` component uses the `BaseInputTemplate` changing the type to `date` and transforms
 * the value to undefined when it is falsy during the `onChange` handling.
 *
 * @param props - The `WidgetProps` for this component
 */
function DateWidget(props) {
    const { onChange, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('BaseInputTemplate', registry, options);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => onChange(value || undefined), [onChange]);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'date', ...props, onChange: handleChange });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/EmailWidget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/EmailWidget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EmailWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `EmailWidget` component uses the `BaseInputTemplate` changing the type to `email`.
 *
 * @param props - The `WidgetProps` for this component
 */
function EmailWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'email', ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/FileWidget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/FileWidget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var markdown_to_jsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! markdown-to-jsx */ "../../node_modules/markdown-to-jsx/dist/index.modern.js");




function addNameToDataURL(dataURL, name) {
    if (dataURL === null) {
        return null;
    }
    return dataURL.replace(';base64', `;name=${encodeURIComponent(name)};base64`);
}
function processFile(file) {
    const { name, size, type } = file;
    return new Promise((resolve, reject) => {
        const reader = new window.FileReader();
        reader.onerror = reject;
        reader.onload = (event) => {
            var _a;
            if (typeof ((_a = event.target) === null || _a === void 0 ? void 0 : _a.result) === 'string') {
                resolve({
                    dataURL: addNameToDataURL(event.target.result, name),
                    name,
                    size,
                    type,
                });
            }
            else {
                resolve({
                    dataURL: null,
                    name,
                    size,
                    type,
                });
            }
        };
        reader.readAsDataURL(file);
    });
}
function processFiles(files) {
    return Promise.all(Array.from(files).map(processFile));
}
function FileInfoPreview({ fileInfo, registry, }) {
    const { translateString } = registry;
    const { dataURL, type, name } = fileInfo;
    if (!dataURL) {
        return null;
    }
    // If type is JPEG or PNG then show image preview.
    // Originally, any type of image was supported, but this was changed into a whitelist
    // since SVGs and animated GIFs are also images, which are generally considered a security risk.
    if (['image/jpeg', 'image/png'].includes(type)) {
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", { src: dataURL, style: { maxWidth: '100%' }, className: 'file-preview' });
    }
    // otherwise, let users download file
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [' ', (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { download: `preview-${name}`, href: dataURL, className: 'file-download', children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.PreviewLabel) })] }));
}
function FilesInfo({ filesInfo, registry, preview, onRemove, options, }) {
    if (filesInfo.length === 0) {
        return null;
    }
    const { translateString } = registry;
    const { RemoveButton } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ButtonTemplates', registry, options);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { className: 'file-info', children: filesInfo.map((fileInfo, key) => {
            const { name, size, type } = fileInfo;
            const handleRemove = () => onRemove(key);
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(markdown_to_jsx__WEBPACK_IMPORTED_MODULE_3__["default"], { children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.FilesInfo, [name, type, String(size)]) }), preview && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FileInfoPreview, { fileInfo: fileInfo, registry: registry }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RemoveButton, { onClick: handleRemove, registry: registry })] }, key));
        }) }));
}
function extractFileInfo(dataURLs) {
    return dataURLs.reduce((acc, dataURL) => {
        if (!dataURL) {
            return acc;
        }
        try {
            const { blob, name } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.dataURItoBlob)(dataURL);
            return [
                ...acc,
                {
                    dataURL,
                    name: name,
                    size: blob.size,
                    type: blob.type,
                },
            ];
        }
        catch (e) {
            // Invalid dataURI, so just ignore it.
            return acc;
        }
    }, []);
}
/**
 *  The `FileWidget` is a widget for rendering file upload fields.
 *  It is typically used with a string property with data-url format.
 */
function FileWidget(props) {
    const { disabled, readonly, required, multiple, onChange, value, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('BaseInputTemplate', registry, options);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        if (!event.target.files) {
            return;
        }
        // Due to variances in themes, dealing with multiple files for the array case now happens one file at a time.
        // This is because we don't pass `multiple` into the `BaseInputTemplate` anymore. Instead, we deal with the single
        // file in each event and concatenate them together ourselves
        processFiles(event.target.files).then((filesInfoEvent) => {
            const newValue = filesInfoEvent.map((fileInfo) => fileInfo.dataURL);
            if (multiple) {
                onChange(value.concat(newValue[0]));
            }
            else {
                onChange(newValue[0]);
            }
        });
    }, [multiple, value, onChange]);
    const filesInfo = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => extractFileInfo(Array.isArray(value) ? value : [value]), [value]);
    const rmFile = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((index) => {
        if (multiple) {
            const newValue = value.filter((_, i) => i !== index);
            onChange(newValue);
        }
        else {
            onChange(undefined);
        }
    }, [multiple, value, onChange]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { ...props, disabled: disabled || readonly, type: 'file', required: value ? false : required, onChangeOverride: handleChange, value: '', accept: options.accept ? String(options.accept) : undefined }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FilesInfo, { filesInfo: filesInfo, onRemove: rmFile, registry: registry, preview: options.filePreview, options: options })] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FileWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/HiddenWidget.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/HiddenWidget.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `HiddenWidget` is a widget for rendering a hidden input field.
 *  It is typically used by setting type to "hidden".
 *
 * @param props - The `WidgetProps` for this component
 */
function HiddenWidget({ id, value, }) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'hidden', id: id, name: id, value: typeof value === 'undefined' ? '' : value });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HiddenWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/PasswordWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/PasswordWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PasswordWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `PasswordWidget` component uses the `BaseInputTemplate` changing the type to `password`.
 *
 * @param props - The `WidgetProps` for this component
 */
function PasswordWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'password', ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/RadioWidget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/RadioWidget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



/** The `RadioWidget` is a widget for rendering a radio group.
 *  It is typically used with a string property constrained with enum options.
 *
 * @param props - The `WidgetProps` for this component
 */
function RadioWidget({ options, value, required, disabled, readonly, autofocus = false, onBlur, onFocus, onChange, id, }) {
    const { enumOptions, enumDisabled, inline, emptyValue } = options;
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onBlur(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(target && target.value, enumOptions, emptyValue)), [onBlur, id]);
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onFocus(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(target && target.value, enumOptions, emptyValue)), [onFocus, id]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'field-radio-group', id: id, children: Array.isArray(enumOptions) &&
            enumOptions.map((option, i) => {
                const checked = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsIsSelected)(option.value, value);
                const itemDisabled = Array.isArray(enumDisabled) && enumDisabled.indexOf(option.value) !== -1;
                const disabledCls = disabled || itemDisabled || readonly ? 'disabled' : '';
                const handleChange = () => onChange(option.value);
                const radio = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'radio', id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.optionId)(id, i), checked: checked, name: id, required: required, value: String(i), disabled: disabled || itemDisabled || readonly, autoFocus: autofocus && i === 0, onChange: handleChange, onBlur: handleBlur, onFocus: handleFocus, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { children: option.label })] }));
                return inline ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { className: `radio-inline ${disabledCls}`, children: radio }, i)) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `radio ${disabledCls}`, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { children: radio }) }, i));
            }) }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RadioWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/RangeWidget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/RangeWidget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RangeWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `RangeWidget` component uses the `BaseInputTemplate` changing the type to `range` and wrapping the result
 * in a div, with the value along side it.
 *
 * @param props - The `WidgetProps` for this component
 */
function RangeWidget(props) {
    const { value, registry: { templates: { BaseInputTemplate }, }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'field-range-wrapper', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'range', ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'range-view', children: value })] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/SelectWidget.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/SelectWidget.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



function getValue(event, multiple) {
    if (multiple) {
        return Array.from(event.target.options)
            .slice()
            .filter((o) => o.selected)
            .map((o) => o.value);
    }
    return event.target.value;
}
/** The `SelectWidget` is a widget for rendering dropdowns.
 *  It is typically used with string properties constrained with enum options.
 *
 * @param props - The `WidgetProps` for this component
 */
function SelectWidget({ schema, id, options, value, required, disabled, readonly, multiple = false, autofocus = false, onChange, onBlur, onFocus, placeholder, }) {
    const { enumOptions, enumDisabled, emptyValue: optEmptyVal } = options;
    const emptyValue = multiple ? [] : '';
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        const newValue = getValue(event, multiple);
        return onFocus(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(newValue, enumOptions, optEmptyVal));
    }, [onFocus, id, schema, multiple, enumOptions, optEmptyVal]);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        const newValue = getValue(event, multiple);
        return onBlur(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(newValue, enumOptions, optEmptyVal));
    }, [onBlur, id, schema, multiple, enumOptions, optEmptyVal]);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        const newValue = getValue(event, multiple);
        return onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(newValue, enumOptions, optEmptyVal));
    }, [onChange, schema, multiple, enumOptions, optEmptyVal]);
    const selectedIndexes = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsIndexForValue)(value, enumOptions, multiple);
    const showPlaceholderOption = !multiple && schema.default === undefined;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("select", { id: id, name: id, multiple: multiple, className: 'form-control', value: typeof selectedIndexes === 'undefined' ? emptyValue : selectedIndexes, required: required, disabled: disabled || readonly, autoFocus: autofocus, onBlur: handleBlur, onFocus: handleFocus, onChange: handleChange, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id), children: [showPlaceholderOption && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("option", { value: '', children: placeholder }), Array.isArray(enumOptions) &&
                enumOptions.map(({ value, label }, i) => {
                    const disabled = enumDisabled && enumDisabled.indexOf(value) !== -1;
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("option", { value: String(i), disabled: disabled, children: label }, i));
                })] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SelectWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/TextWidget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/TextWidget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `TextWidget` component uses the `BaseInputTemplate`.
 *
 * @param props - The `WidgetProps` for this component
 */
function TextWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/TextareaWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/TextareaWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



/** The `TextareaWidget` is a widget for rendering input fields as textarea.
 *
 * @param props - The `WidgetProps` for this component
 */
function TextareaWidget({ id, options = {}, placeholder, value, required, disabled, readonly, autofocus = false, onChange, onBlur, onFocus, }) {
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target: { value } }) => onChange(value === '' ? options.emptyValue : value), [onChange, options.emptyValue]);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onBlur(id, target && target.value), [onBlur, id]);
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onFocus(id, target && target.value), [id, onFocus]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("textarea", { id: id, name: id, className: 'form-control', value: value ? value : '', placeholder: placeholder, required: required, disabled: disabled, readOnly: readonly, autoFocus: autofocus, rows: options.rows, onBlur: handleBlur, onFocus: handleFocus, onChange: handleChange, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id) }));
}
TextareaWidget.defaultProps = {
    autofocus: false,
    options: {},
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextareaWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/TimeWidget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/TimeWidget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TimeWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__);



/** The `TimeWidget` component uses the `BaseInputTemplate` changing the type to `time` and transforms
 * the value to undefined when it is falsy during the `onChange` handling.
 *
 * @param props - The `WidgetProps` for this component
 */
function TimeWidget(props) {
    const { onChange, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('BaseInputTemplate', registry, options);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => onChange(value ? `${value}:00` : undefined), [onChange]);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'time', ...props, onChange: handleChange });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/URLWidget.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/URLWidget.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ URLWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `URLWidget` component uses the `BaseInputTemplate` changing the type to `url`.
 *
 * @param props - The `WidgetProps` for this component
 */
function URLWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'url', ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/UpDownWidget.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/UpDownWidget.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UpDownWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__);


/** The `UpDownWidget` component uses the `BaseInputTemplate` changing the type to `number`.
 *
 * @param props - The `WidgetProps` for this component
 */
function UpDownWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'number', ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/index.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _AltDateWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AltDateWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/AltDateWidget.js");
/* harmony import */ var _AltDateTimeWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AltDateTimeWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/AltDateTimeWidget.js");
/* harmony import */ var _CheckboxWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CheckboxWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/CheckboxWidget.js");
/* harmony import */ var _CheckboxesWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CheckboxesWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/CheckboxesWidget.js");
/* harmony import */ var _ColorWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ColorWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/ColorWidget.js");
/* harmony import */ var _DateWidget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DateWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/DateWidget.js");
/* harmony import */ var _DateTimeWidget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DateTimeWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/DateTimeWidget.js");
/* harmony import */ var _EmailWidget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./EmailWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/EmailWidget.js");
/* harmony import */ var _FileWidget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./FileWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/FileWidget.js");
/* harmony import */ var _HiddenWidget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./HiddenWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/HiddenWidget.js");
/* harmony import */ var _PasswordWidget__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./PasswordWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/PasswordWidget.js");
/* harmony import */ var _RadioWidget__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./RadioWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/RadioWidget.js");
/* harmony import */ var _RangeWidget__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./RangeWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/RangeWidget.js");
/* harmony import */ var _SelectWidget__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./SelectWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/SelectWidget.js");
/* harmony import */ var _TextareaWidget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./TextareaWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/TextareaWidget.js");
/* harmony import */ var _TextWidget__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./TextWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/TextWidget.js");
/* harmony import */ var _TimeWidget__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./TimeWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/TimeWidget.js");
/* harmony import */ var _URLWidget__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./URLWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/URLWidget.js");
/* harmony import */ var _UpDownWidget__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./UpDownWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/UpDownWidget.js");



















function widgets() {
    return {
        AltDateWidget: _AltDateWidget__WEBPACK_IMPORTED_MODULE_0__["default"],
        AltDateTimeWidget: _AltDateTimeWidget__WEBPACK_IMPORTED_MODULE_1__["default"],
        CheckboxWidget: _CheckboxWidget__WEBPACK_IMPORTED_MODULE_2__["default"],
        CheckboxesWidget: _CheckboxesWidget__WEBPACK_IMPORTED_MODULE_3__["default"],
        ColorWidget: _ColorWidget__WEBPACK_IMPORTED_MODULE_4__["default"],
        DateWidget: _DateWidget__WEBPACK_IMPORTED_MODULE_5__["default"],
        DateTimeWidget: _DateTimeWidget__WEBPACK_IMPORTED_MODULE_6__["default"],
        EmailWidget: _EmailWidget__WEBPACK_IMPORTED_MODULE_7__["default"],
        FileWidget: _FileWidget__WEBPACK_IMPORTED_MODULE_8__["default"],
        HiddenWidget: _HiddenWidget__WEBPACK_IMPORTED_MODULE_9__["default"],
        PasswordWidget: _PasswordWidget__WEBPACK_IMPORTED_MODULE_10__["default"],
        RadioWidget: _RadioWidget__WEBPACK_IMPORTED_MODULE_11__["default"],
        RangeWidget: _RangeWidget__WEBPACK_IMPORTED_MODULE_12__["default"],
        SelectWidget: _SelectWidget__WEBPACK_IMPORTED_MODULE_13__["default"],
        TextWidget: _TextWidget__WEBPACK_IMPORTED_MODULE_15__["default"],
        TextareaWidget: _TextareaWidget__WEBPACK_IMPORTED_MODULE_14__["default"],
        TimeWidget: _TimeWidget__WEBPACK_IMPORTED_MODULE_16__["default"],
        UpDownWidget: _UpDownWidget__WEBPACK_IMPORTED_MODULE_18__["default"],
        URLWidget: _URLWidget__WEBPACK_IMPORTED_MODULE_17__["default"],
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widgets);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/getDefaultRegistry.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/getDefaultRegistry.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDefaultRegistry)
/* harmony export */ });
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rjsf/utils */ "webpack/sharing/consume/default/@rjsf/utils/@rjsf/utils");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_fields__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/fields */ "../../node_modules/@rjsf/core/lib/components/fields/index.js");
/* harmony import */ var _components_templates__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/templates */ "../../node_modules/@rjsf/core/lib/components/templates/index.js");
/* harmony import */ var _components_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/widgets */ "../../node_modules/@rjsf/core/lib/components/widgets/index.js");




/** The default registry consists of all the fields, templates and widgets provided in the core implementation,
 * plus an empty `rootSchema` and `formContext. We omit schemaUtils here because it cannot be defaulted without a
 * rootSchema and validator. It will be added into the computed registry later in the Form.
 */
function getDefaultRegistry() {
    return {
        fields: (0,_components_fields__WEBPACK_IMPORTED_MODULE_1__["default"])(),
        templates: (0,_components_templates__WEBPACK_IMPORTED_MODULE_2__["default"])(),
        widgets: (0,_components_widgets__WEBPACK_IMPORTED_MODULE_3__["default"])(),
        rootSchema: {},
        formContext: {},
        translateString: _rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.englishStringTranslator,
    };
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/index.js":
/*!**************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   getDefaultRegistry: () => (/* reexport safe */ _getDefaultRegistry__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   withTheme: () => (/* reexport safe */ _withTheme__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _components_Form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/Form */ "../../node_modules/@rjsf/core/lib/components/Form.js");
/* harmony import */ var _withTheme__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./withTheme */ "../../node_modules/@rjsf/core/lib/withTheme.js");
/* harmony import */ var _getDefaultRegistry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDefaultRegistry */ "../../node_modules/@rjsf/core/lib/getDefaultRegistry.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_components_Form__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/withTheme.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/withTheme.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ withTheme)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_Form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/Form */ "../../node_modules/@rjsf/core/lib/components/Form.js");



/** A Higher-Order component that creates a wrapper around a `Form` with the overrides from the `WithThemeProps` */
function withTheme(themeProps) {
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ fields, widgets, templates, ...directProps }, ref) => {
        var _a;
        fields = { ...themeProps === null || themeProps === void 0 ? void 0 : themeProps.fields, ...fields };
        widgets = { ...themeProps === null || themeProps === void 0 ? void 0 : themeProps.widgets, ...widgets };
        templates = {
            ...themeProps === null || themeProps === void 0 ? void 0 : themeProps.templates,
            ...templates,
            ButtonTemplates: {
                ...(_a = themeProps === null || themeProps === void 0 ? void 0 : themeProps.templates) === null || _a === void 0 ? void 0 : _a.ButtonTemplates,
                ...templates === null || templates === void 0 ? void 0 : templates.ButtonTemplates,
            },
        };
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_Form__WEBPACK_IMPORTED_MODULE_2__["default"], { ...themeProps, ...directProps, fields: fields, widgets: widgets, templates: templates, ref: ref }));
    });
}


/***/ }),

/***/ "../../node_modules/lodash/_basePick.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/_basePick.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var basePickBy = __webpack_require__(/*! ./_basePickBy */ "../../node_modules/lodash/_basePickBy.js"),
    hasIn = __webpack_require__(/*! ./hasIn */ "../../node_modules/lodash/hasIn.js");

/**
 * The base implementation of `_.pick` without support for individual
 * property identifiers.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} paths The property paths to pick.
 * @returns {Object} Returns the new object.
 */
function basePick(object, paths) {
  return basePickBy(object, paths, function(value, path) {
    return hasIn(object, path);
  });
}

module.exports = basePick;


/***/ }),

/***/ "../../node_modules/lodash/_basePickBy.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/_basePickBy.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGet = __webpack_require__(/*! ./_baseGet */ "../../node_modules/lodash/_baseGet.js"),
    baseSet = __webpack_require__(/*! ./_baseSet */ "../../node_modules/lodash/_baseSet.js"),
    castPath = __webpack_require__(/*! ./_castPath */ "../../node_modules/lodash/_castPath.js");

/**
 * The base implementation of  `_.pickBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} paths The property paths to pick.
 * @param {Function} predicate The function invoked per property.
 * @returns {Object} Returns the new object.
 */
function basePickBy(object, paths, predicate) {
  var index = -1,
      length = paths.length,
      result = {};

  while (++index < length) {
    var path = paths[index],
        value = baseGet(object, path);

    if (predicate(value, path)) {
      baseSet(result, castPath(path, object), value);
    }
  }
  return result;
}

module.exports = basePickBy;


/***/ }),

/***/ "../../node_modules/lodash/pick.js":
/*!*****************************************!*\
  !*** ../../node_modules/lodash/pick.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var basePick = __webpack_require__(/*! ./_basePick */ "../../node_modules/lodash/_basePick.js"),
    flatRest = __webpack_require__(/*! ./_flatRest */ "../../node_modules/lodash/_flatRest.js");

/**
 * Creates an object composed of the picked `object` properties.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The source object.
 * @param {...(string|string[])} [paths] The property paths to pick.
 * @returns {Object} Returns the new object.
 * @example
 *
 * var object = { 'a': 1, 'b': '2', 'c': 3 };
 *
 * _.pick(object, ['a', 'c']);
 * // => { 'a': 1, 'c': 3 }
 */
var pick = flatRest(function(object, paths) {
  return object == null ? {} : basePick(object, paths);
});

module.exports = pick;


/***/ }),

/***/ "../../node_modules/lodash/unset.js":
/*!******************************************!*\
  !*** ../../node_modules/lodash/unset.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseUnset = __webpack_require__(/*! ./_baseUnset */ "../../node_modules/lodash/_baseUnset.js");

/**
 * Removes the property at `path` of `object`.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to modify.
 * @param {Array|string} path The path of the property to unset.
 * @returns {boolean} Returns `true` if the property is deleted, else `false`.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 7 } }] };
 * _.unset(object, 'a[0].b.c');
 * // => true
 *
 * console.log(object);
 * // => { 'a': [{ 'b': {} }] };
 *
 * _.unset(object, ['a', '0', 'b', 'c']);
 * // => true
 *
 * console.log(object);
 * // => { 'a': [{ 'b': {} }] };
 */
function unset(object, path) {
  return object == null ? true : baseUnset(object, path);
}

module.exports = unset;


/***/ }),

/***/ "../../node_modules/markdown-to-jsx/dist/index.modern.js":
/*!***************************************************************!*\
  !*** ../../node_modules/markdown-to-jsx/dist/index.modern.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RuleType: () => (/* binding */ r),
/* harmony export */   compiler: () => (/* binding */ Ze),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   sanitizer: () => (/* binding */ Ue),
/* harmony export */   slugify: () => (/* binding */ Ce)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
function t(){return t=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},t.apply(this,arguments)}const n=["children","options"],r={blockQuote:"0",breakLine:"1",breakThematic:"2",codeBlock:"3",codeFenced:"4",codeInline:"5",footnote:"6",footnoteReference:"7",gfmTask:"8",heading:"9",headingSetext:"10",htmlBlock:"11",htmlComment:"12",htmlSelfClosing:"13",image:"14",link:"15",linkAngleBraceStyleDetector:"16",linkBareUrlDetector:"17",linkMailtoDetector:"18",newlineCoalescer:"19",orderedList:"20",paragraph:"21",ref:"22",refImage:"23",refLink:"24",table:"25",tableSeparator:"26",text:"27",textBolded:"28",textEmphasized:"29",textEscaped:"30",textMarked:"31",textStrikethroughed:"32",unorderedList:"33"};var i;!function(e){e[e.MAX=0]="MAX",e[e.HIGH=1]="HIGH",e[e.MED=2]="MED",e[e.LOW=3]="LOW",e[e.MIN=4]="MIN"}(i||(i={}));const l=["allowFullScreen","allowTransparency","autoComplete","autoFocus","autoPlay","cellPadding","cellSpacing","charSet","className","classId","colSpan","contentEditable","contextMenu","crossOrigin","encType","formAction","formEncType","formMethod","formNoValidate","formTarget","frameBorder","hrefLang","inputMode","keyParams","keyType","marginHeight","marginWidth","maxLength","mediaGroup","minLength","noValidate","radioGroup","readOnly","rowSpan","spellCheck","srcDoc","srcLang","srcSet","tabIndex","useMap"].reduce((e,t)=>(e[t.toLowerCase()]=t,e),{for:"htmlFor"}),a={amp:"&",apos:"'",gt:">",lt:"<",nbsp:" ",quot:"“"},o=["style","script"],c=/([-A-Z0-9_:]+)(?:\s*=\s*(?:(?:"((?:\\.|[^"])*)")|(?:'((?:\\.|[^'])*)')|(?:\{((?:\\.|{[^}]*?}|[^}])*)\})))?/gi,s=/mailto:/i,d=/\n{2,}$/,u=/^(\s*>[\s\S]*?)(?=\n{2,})/,p=/^ *> ?/gm,f=/^ {2,}\n/,h=/^(?:( *[-*_])){3,} *(?:\n *)+\n/,m=/^\s*(`{3,}|~{3,}) *(\S+)?([^\n]*?)?\n([\s\S]+?)\s*\1 *(?:\n *)*\n?/,g=/^(?: {4}[^\n]+\n*)+(?:\n *)+\n?/,y=/^(`+)\s*([\s\S]*?[^`])\s*\1(?!`)/,k=/^(?:\n *)*\n/,x=/\r\n?/g,b=/^\[\^([^\]]+)](:(.*)((\n+ {4,}.*)|(\n(?!\[\^).+))*)/,v=/^\[\^([^\]]+)]/,S=/\f/g,E=/^---[ \t]*\n(.|\n)*\n---[ \t]*\n/,$=/^\s*?\[(x|\s)\]/,w=/^ *(#{1,6}) *([^\n]+?)(?: +#*)?(?:\n *)*(?:\n|$)/,C=/^ *(#{1,6}) +([^\n]+?)(?: +#*)?(?:\n *)*(?:\n|$)/,z=/^([^\n]+)\n *(=|-){3,} *(?:\n *)+\n/,L=/^ *(?!<[a-z][^ >/]* ?\/>)<([a-z][^ >/]*) ?((?:[^>]*[^/])?)>\n?(\s*(?:<\1[^>]*?>[\s\S]*?<\/\1>|(?!<\1\b)[\s\S])*?)<\/\1>(?!<\/\1>)\n*/i,A=/&([a-z0-9]+|#[0-9]{1,6}|#x[0-9a-fA-F]{1,6});/gi,T=/^<!--[\s\S]*?(?:-->)/,O=/^(data|aria|x)-[a-z_][a-z\d_.-]*$/,B=/^ *<([a-z][a-z0-9:]*)(?:\s+((?:<.*?>|[^>])*))?\/?>(?!<\/\1>)(\s*\n)?/i,M=/^\{.*\}$/,R=/^(https?:\/\/[^\s<]+[^<.,:;"')\]\s])/,I=/^<([^ >]+@[^ >]+)>/,U=/^<([^ >]+:\/[^ >]+)>/,D=/-([a-z])?/gi,j=/^(.*\|.*)\n(?: *(\|? *[-:]+ *\|[-| :]*)\n((?:.*\|.*\n)*))?\n?/,N=/^\[([^\]]*)\]:\s+<?([^\s>]+)>?\s*("([^"]*)")?/,H=/^!\[([^\]]*)\] ?\[([^\]]*)\]/,F=/^\[([^\]]*)\] ?\[([^\]]*)\]/,P=/(\[|\])/g,_=/(\n|^[-*]\s|^#|^ {2,}|^-{2,}|^>\s)/,W=/\t/g,G=/(^ *\||\| *$)/g,Z=/^ *:-+: *$/,q=/^ *:-+ *$/,Q=/^ *-+: *$/,V="((?:\\[.*?\\][([].*?[)\\]]|<.*?>(?:.*?<.*?>)?|`.*?`|~~.*?~~|==.*?==|.|\\n)*?)",X=new RegExp(`^([*_])\\1${V}\\1\\1(?!\\1)`),J=new RegExp(`^([*_])${V}\\1(?!\\1|\\w)`),K=new RegExp(`^==${V}==`),Y=new RegExp(`^~~${V}~~`),ee=/^\\([^0-9A-Za-z\s])/,te=/^[\s\S]+?(?=[^0-9A-Z\s\u00c0-\uffff&#;.()'"]|\d+\.|\n\n| {2,}\n|\w+:\S|$)/i,ne=/^\n+/,re=/^([ \t]*)/,ie=/\\([^\\])/g,le=/ *\n+$/,ae=/(?:^|\n)( *)$/,oe="(?:\\d+\\.)",ce="(?:[*+-])";function se(e){return"( *)("+(1===e?oe:ce)+") +"}const de=se(1),ue=se(2);function pe(e){return new RegExp("^"+(1===e?de:ue))}const fe=pe(1),he=pe(2);function me(e){return new RegExp("^"+(1===e?de:ue)+"[^\\n]*(?:\\n(?!\\1"+(1===e?oe:ce)+" )[^\\n]*)*(\\n|$)","gm")}const ge=me(1),ye=me(2);function ke(e){const t=1===e?oe:ce;return new RegExp("^( *)("+t+") [\\s\\S]+?(?:\\n{2,}(?! )(?!\\1"+t+" (?!"+t+" ))\\n*|\\s*\\n*$)")}const xe=ke(1),be=ke(2);function ve(e,t){const n=1===t,i=n?xe:be,l=n?ge:ye,a=n?fe:he;return{match(e,t,n){const r=ae.exec(n);return r&&(t.list||!t.inline&&!t.simple)?i.exec(e=r[1]+e):null},order:1,parse(e,t,r){const i=n?+e[2]:void 0,o=e[0].replace(d,"\n").match(l);let c=!1;return{items:o.map(function(e,n){const i=a.exec(e)[0].length,l=new RegExp("^ {1,"+i+"}","gm"),s=e.replace(l,"").replace(a,""),d=n===o.length-1,u=-1!==s.indexOf("\n\n")||d&&c;c=u;const p=r.inline,f=r.list;let h;r.list=!0,u?(r.inline=!1,h=s.replace(le,"\n\n")):(r.inline=!0,h=s.replace(le,""));const m=t(h,r);return r.inline=p,r.list=f,m}),ordered:n,start:i}},render:(t,n,i)=>e(t.ordered?"ol":"ul",{key:i.key,start:t.type===r.orderedList?t.start:void 0},t.items.map(function(t,r){return e("li",{key:r},n(t,i))}))}}const Se=new RegExp("^\\[((?:\\[[^\\]]*\\]|[^\\[\\]]|\\](?=[^\\[]*\\]))*)\\]\\(\\s*<?((?:\\([^)]*\\)|[^\\s\\\\]|\\\\.)*?)>?(?:\\s+['\"]([\\s\\S]*?)['\"])?\\s*\\)"),Ee=/^!\[(.*?)\]\( *((?:\([^)]*\)|[^() ])*) *"?([^)"]*)?"?\)/,$e=[u,m,g,w,z,C,T,j,ge,xe,ye,be],we=[...$e,/^[^\n]+(?:  \n|\n{2,})/,L,B];function Ce(e){return e.replace(/[ÀÁÂÃÄÅàáâãäåæÆ]/g,"a").replace(/[çÇ]/g,"c").replace(/[ðÐ]/g,"d").replace(/[ÈÉÊËéèêë]/g,"e").replace(/[ÏïÎîÍíÌì]/g,"i").replace(/[Ññ]/g,"n").replace(/[øØœŒÕõÔôÓóÒò]/g,"o").replace(/[ÜüÛûÚúÙù]/g,"u").replace(/[ŸÿÝý]/g,"y").replace(/[^a-z0-9- ]/gi,"").replace(/ /gi,"-").toLowerCase()}function ze(e){return Q.test(e)?"right":Z.test(e)?"center":q.test(e)?"left":null}function Le(e,t,n,i){const l=n.inTable;n.inTable=!0;let a=e.trim().split(/( *(?:`[^`]*`|<.*?>.*?<\/.*?>(?!<\/.*?>)|\\\||\|) *)/).reduce((e,l)=>("|"===l.trim()?e.push(i?{type:r.tableSeparator}:{type:r.text,text:l}):""!==l&&e.push.apply(e,t(l,n)),e),[]);n.inTable=l;let o=[[]];return a.forEach(function(e,t){e.type===r.tableSeparator?0!==t&&t!==a.length-1&&o.push([]):(e.type!==r.text||null!=a[t+1]&&a[t+1].type!==r.tableSeparator||(e.text=e.text.trimEnd()),o[o.length-1].push(e))}),o}function Ae(e,t,n){n.inline=!0;const i=e[2]?e[2].replace(G,"").split("|").map(ze):[],l=e[3]?function(e,t,n){return e.trim().split("\n").map(function(e){return Le(e,t,n,!0)})}(e[3],t,n):[],a=Le(e[1],t,n,!!l.length);return n.inline=!1,l.length?{align:i,cells:l,header:a,type:r.table}:{children:a,type:r.paragraph}}function Te(e,t){return null==e.align[t]?{}:{textAlign:e.align[t]}}function Oe(e){return function(t,n){return n.inline?e.exec(t):null}}function Be(e){return function(t,n){return n.inline||n.simple?e.exec(t):null}}function Me(e){return function(t,n){return n.inline||n.simple?null:e.exec(t)}}function Re(e){return function(t){return e.exec(t)}}function Ie(e,t,n){if(t.inline||t.simple)return null;if(n&&!n.endsWith("\n"))return null;let r="";e.split("\n").every(e=>!$e.some(t=>t.test(e))&&(r+=e+"\n",e.trim()));const i=r.trimEnd();return""==i?null:[r,i]}function Ue(e){try{if(decodeURIComponent(e).replace(/[^A-Za-z0-9/:]/g,"").match(/^\s*(javascript|vbscript|data(?!:image)):/i))return null}catch(e){return null}return e}function De(e){return e.replace(ie,"$1")}function je(e,t,n){const r=n.inline||!1,i=n.simple||!1;n.inline=!0,n.simple=!0;const l=e(t,n);return n.inline=r,n.simple=i,l}function Ne(e,t,n){const r=n.inline||!1,i=n.simple||!1;n.inline=!1,n.simple=!0;const l=e(t,n);return n.inline=r,n.simple=i,l}function He(e,t,n){const r=n.inline||!1;n.inline=!1;const i=e(t,n);return n.inline=r,i}const Fe=(e,t,n)=>({children:je(t,e[1],n)});function Pe(){return{}}function _e(){return null}function We(...e){return e.filter(Boolean).join(" ")}function Ge(e,t,n){let r=e;const i=t.split(".");for(;i.length&&(r=r[i[0]],void 0!==r);)i.shift();return r||n}function Ze(n="",i={}){function d(e,n,...r){const l=Ge(i.overrides,`${e}.props`,{});return i.createElement(function(e,t){const n=Ge(t,e);return n?"function"==typeof n||"object"==typeof n&&"render"in n?n:Ge(t,`${e}.component`,e):e}(e,i.overrides),t({},n,l,{className:We(null==n?void 0:n.className,l.className)||void 0}),...r)}function G(t){t=t.replace(E,"");let n=!1;i.forceInline?n=!0:i.forceBlock||(n=!1===_.test(t));const r=le(ie(n?t:`${t.trimEnd().replace(ne,"")}\n\n`,{inline:n}));for(;"string"==typeof r[r.length-1]&&!r[r.length-1].trim();)r.pop();if(null===i.wrapper)return r;const l=i.wrapper||(n?"span":"div");let a;if(r.length>1||i.forceWrapper)a=r;else{if(1===r.length)return a=r[0],"string"==typeof a?d("span",{key:"outer"},a):a;a=null}return react__WEBPACK_IMPORTED_MODULE_0__.createElement(l,{key:"outer"},a)}function Z(t,n){const r=n.match(c);return r?r.reduce(function(n,r,a){const o=r.indexOf("=");if(-1!==o){const c=function(e){return-1!==e.indexOf("-")&&null===e.match(O)&&(e=e.replace(D,function(e,t){return t.toUpperCase()})),e}(r.slice(0,o)).trim(),s=function(e){const t=e[0];return('"'===t||"'"===t)&&e.length>=2&&e[e.length-1]===t?e.slice(1,-1):e}(r.slice(o+1).trim()),d=l[c]||c,u=n[d]=function(e,t,n,r){return"style"===t?n.split(/;\s?/).reduce(function(e,t){const n=t.slice(0,t.indexOf(":"));return e[n.trim().replace(/(-[a-z])/g,e=>e[1].toUpperCase())]=t.slice(n.length+1).trim(),e},{}):"href"===t||"src"===t?r(n,e,t):(n.match(M)&&(n=n.slice(1,n.length-1)),"true"===n||"false"!==n&&n)}(t,c,s,i.sanitizer);"string"==typeof u&&(L.test(u)||B.test(u))&&(n[d]=react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(G(u.trim()),{key:a}))}else"style"!==r&&(n[l[r]||r]=!0);return n},{}):null}i.overrides=i.overrides||{},i.sanitizer=i.sanitizer||Ue,i.slugify=i.slugify||Ce,i.namedCodesToUnicode=i.namedCodesToUnicode?t({},a,i.namedCodesToUnicode):a,i.createElement=i.createElement||react__WEBPACK_IMPORTED_MODULE_0__.createElement;const q=[],Q={},V={[r.blockQuote]:{match:Me(u),order:1,parse:(e,t,n)=>({children:t(e[0].replace(p,""),n)}),render:(e,t,n)=>d("blockquote",{key:n.key},t(e.children,n))},[r.breakLine]:{match:Re(f),order:1,parse:Pe,render:(e,t,n)=>d("br",{key:n.key})},[r.breakThematic]:{match:Me(h),order:1,parse:Pe,render:(e,t,n)=>d("hr",{key:n.key})},[r.codeBlock]:{match:Me(g),order:0,parse:e=>({lang:void 0,text:e[0].replace(/^ {4}/gm,"").replace(/\n+$/,"")}),render:(e,n,r)=>d("pre",{key:r.key},d("code",t({},e.attrs,{className:e.lang?`lang-${e.lang}`:""}),e.text))},[r.codeFenced]:{match:Me(m),order:0,parse:e=>({attrs:Z("code",e[3]||""),lang:e[2]||void 0,text:e[4],type:r.codeBlock})},[r.codeInline]:{match:Be(y),order:3,parse:e=>({text:e[2]}),render:(e,t,n)=>d("code",{key:n.key},e.text)},[r.footnote]:{match:Me(b),order:0,parse:e=>(q.push({footnote:e[2],identifier:e[1]}),{}),render:_e},[r.footnoteReference]:{match:Oe(v),order:1,parse:e=>({target:`#${i.slugify(e[1],Ce)}`,text:e[1]}),render:(e,t,n)=>d("a",{key:n.key,href:i.sanitizer(e.target,"a","href")},d("sup",{key:n.key},e.text))},[r.gfmTask]:{match:Oe($),order:1,parse:e=>({completed:"x"===e[1].toLowerCase()}),render:(e,t,n)=>d("input",{checked:e.completed,key:n.key,readOnly:!0,type:"checkbox"})},[r.heading]:{match:Me(i.enforceAtxHeadings?C:w),order:1,parse:(e,t,n)=>({children:je(t,e[2],n),id:i.slugify(e[2],Ce),level:e[1].length}),render:(e,t,n)=>d(`h${e.level}`,{id:e.id,key:n.key},t(e.children,n))},[r.headingSetext]:{match:Me(z),order:0,parse:(e,t,n)=>({children:je(t,e[1],n),level:"="===e[2]?1:2,type:r.heading})},[r.htmlBlock]:{match:Re(L),order:1,parse(e,t,n){const[,r]=e[3].match(re),i=new RegExp(`^${r}`,"gm"),l=e[3].replace(i,""),a=(c=l,we.some(e=>e.test(c))?He:je);var c;const s=e[1].toLowerCase(),d=-1!==o.indexOf(s),u=(d?s:e[1]).trim(),p={attrs:Z(u,e[2]),noInnerParse:d,tag:u};return n.inAnchor=n.inAnchor||"a"===s,d?p.text=e[3]:p.children=a(t,l,n),n.inAnchor=!1,p},render:(e,n,r)=>d(e.tag,t({key:r.key},e.attrs),e.text||n(e.children,r))},[r.htmlSelfClosing]:{match:Re(B),order:1,parse(e){const t=e[1].trim();return{attrs:Z(t,e[2]||""),tag:t}},render:(e,n,r)=>d(e.tag,t({},e.attrs,{key:r.key}))},[r.htmlComment]:{match:Re(T),order:1,parse:()=>({}),render:_e},[r.image]:{match:Be(Ee),order:1,parse:e=>({alt:e[1],target:De(e[2]),title:e[3]}),render:(e,t,n)=>d("img",{key:n.key,alt:e.alt||void 0,title:e.title||void 0,src:i.sanitizer(e.target,"img","src")})},[r.link]:{match:Oe(Se),order:3,parse:(e,t,n)=>({children:Ne(t,e[1],n),target:De(e[2]),title:e[3]}),render:(e,t,n)=>d("a",{key:n.key,href:i.sanitizer(e.target,"a","href"),title:e.title},t(e.children,n))},[r.linkAngleBraceStyleDetector]:{match:Oe(U),order:0,parse:e=>({children:[{text:e[1],type:r.text}],target:e[1],type:r.link})},[r.linkBareUrlDetector]:{match:(e,t)=>t.inAnchor?null:Oe(R)(e,t),order:0,parse:e=>({children:[{text:e[1],type:r.text}],target:e[1],title:void 0,type:r.link})},[r.linkMailtoDetector]:{match:Oe(I),order:0,parse(e){let t=e[1],n=e[1];return s.test(n)||(n="mailto:"+n),{children:[{text:t.replace("mailto:",""),type:r.text}],target:n,type:r.link}}},[r.orderedList]:ve(d,1),[r.unorderedList]:ve(d,2),[r.newlineCoalescer]:{match:Me(k),order:3,parse:Pe,render:()=>"\n"},[r.paragraph]:{match:Ie,order:3,parse:Fe,render:(e,t,n)=>d("p",{key:n.key},t(e.children,n))},[r.ref]:{match:Oe(N),order:0,parse:e=>(Q[e[1]]={target:e[2],title:e[4]},{}),render:_e},[r.refImage]:{match:Be(H),order:0,parse:e=>({alt:e[1]||void 0,ref:e[2]}),render:(e,t,n)=>Q[e.ref]?d("img",{key:n.key,alt:e.alt,src:i.sanitizer(Q[e.ref].target,"img","src"),title:Q[e.ref].title}):null},[r.refLink]:{match:Oe(F),order:0,parse:(e,t,n)=>({children:t(e[1],n),fallbackChildren:t(e[0].replace(P,"\\$1"),n),ref:e[2]}),render:(e,t,n)=>Q[e.ref]?d("a",{key:n.key,href:i.sanitizer(Q[e.ref].target,"a","href"),title:Q[e.ref].title},t(e.children,n)):d("span",{key:n.key},t(e.fallbackChildren,n))},[r.table]:{match:Me(j),order:1,parse:Ae,render(e,t,n){const r=e;return d("table",{key:n.key},d("thead",null,d("tr",null,r.header.map(function(e,i){return d("th",{key:i,style:Te(r,i)},t(e,n))}))),d("tbody",null,r.cells.map(function(e,i){return d("tr",{key:i},e.map(function(e,i){return d("td",{key:i,style:Te(r,i)},t(e,n))}))})))}},[r.text]:{match:Re(te),order:4,parse:e=>({text:e[0].replace(A,(e,t)=>i.namedCodesToUnicode[t]?i.namedCodesToUnicode[t]:e)}),render:e=>e.text},[r.textBolded]:{match:Be(X),order:2,parse:(e,t,n)=>({children:t(e[2],n)}),render:(e,t,n)=>d("strong",{key:n.key},t(e.children,n))},[r.textEmphasized]:{match:Be(J),order:3,parse:(e,t,n)=>({children:t(e[2],n)}),render:(e,t,n)=>d("em",{key:n.key},t(e.children,n))},[r.textEscaped]:{match:Be(ee),order:1,parse:e=>({text:e[1],type:r.text})},[r.textMarked]:{match:Be(K),order:3,parse:Fe,render:(e,t,n)=>d("mark",{key:n.key},t(e.children,n))},[r.textStrikethroughed]:{match:Be(Y),order:3,parse:Fe,render:(e,t,n)=>d("del",{key:n.key},t(e.children,n))}};!0===i.disableParsingRawHTML&&(delete V[r.htmlBlock],delete V[r.htmlSelfClosing]);const ie=function(e){let t=Object.keys(e);function n(r,i){let l=[],a="";for(;r;){let o=0;for(;o<t.length;){const c=t[o],s=e[c],d=s.match(r,i,a);if(d){const e=d[0];r=r.substring(e.length);const t=s.parse(d,n,i);null==t.type&&(t.type=c),l.push(t),a=e;break}o++}}return l}return t.sort(function(t,n){let r=e[t].order,i=e[n].order;return r!==i?r-i:t<n?-1:1}),function(e,t){return n(function(e){return e.replace(x,"\n").replace(S,"").replace(W,"    ")}(e),t)}}(V),le=(ae=function(e,t){return function(n,r,i){const l=e[n.type].render;return t?t(()=>l(n,r,i),n,r,i):l(n,r,i)}}(V,i.renderRule),function e(t,n={}){if(Array.isArray(t)){const r=n.key,i=[];let l=!1;for(let r=0;r<t.length;r++){n.key=r;const a=e(t[r],n),o="string"==typeof a;o&&l?i[i.length-1]+=a:null!==a&&i.push(a),l=o}return n.key=r,i}return ae(t,e,n)});var ae;const oe=G(n);return q.length?d("div",null,oe,d("footer",{key:"footer"},q.map(function(e){return d("div",{id:i.slugify(e.identifier,Ce),key:e.identifier},e.identifier,le(ie(e.footnote,{inline:!0})))}))):oe}/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (t=>{let{children:r="",options:i}=t,l=function(e,t){if(null==e)return{};var n,r,i={},l=Object.keys(e);for(r=0;r<l.length;r++)t.indexOf(n=l[r])>=0||(i[n]=e[n]);return i}(t,n);return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(Ze(r,i),l)});


/***/ }),

/***/ "../../node_modules/nanoid/index.browser.js":
/*!**************************************************!*\
  !*** ../../node_modules/nanoid/index.browser.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   customAlphabet: () => (/* binding */ customAlphabet),
/* harmony export */   customRandom: () => (/* binding */ customRandom),
/* harmony export */   nanoid: () => (/* binding */ nanoid),
/* harmony export */   random: () => (/* binding */ random),
/* harmony export */   urlAlphabet: () => (/* reexport safe */ _url_alphabet_index_js__WEBPACK_IMPORTED_MODULE_0__.urlAlphabet)
/* harmony export */ });
/* harmony import */ var _url_alphabet_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./url-alphabet/index.js */ "../../node_modules/nanoid/url-alphabet/index.js");

let random = bytes => crypto.getRandomValues(new Uint8Array(bytes))
let customRandom = (alphabet, defaultSize, getRandom) => {
  let mask = (2 << (Math.log(alphabet.length - 1) / Math.LN2)) - 1
  let step = -~((1.6 * mask * defaultSize) / alphabet.length)
  return (size = defaultSize) => {
    let id = ''
    while (true) {
      let bytes = getRandom(step)
      let j = step
      while (j--) {
        id += alphabet[bytes[j] & mask] || ''
        if (id.length === size) return id
      }
    }
  }
}
let customAlphabet = (alphabet, size = 21) =>
  customRandom(alphabet, size, random)
let nanoid = (size = 21) =>
  crypto.getRandomValues(new Uint8Array(size)).reduce((id, byte) => {
    byte &= 63
    if (byte < 36) {
      id += byte.toString(36)
    } else if (byte < 62) {
      id += (byte - 26).toString(36).toUpperCase()
    } else if (byte > 62) {
      id += '-'
    } else {
      id += '_'
    }
    return id
  }, '')



/***/ }),

/***/ "../../node_modules/nanoid/url-alphabet/index.js":
/*!*******************************************************!*\
  !*** ../../node_modules/nanoid/url-alphabet/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   urlAlphabet: () => (/* binding */ urlAlphabet)
/* harmony export */ });
let urlAlphabet =
  'useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict'



/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_rjsf_core_lib_index_js.fd6601e0359be6588696.js.map