(self["webpackChunk_elyra_ui_components"] = self["webpackChunk_elyra_ui_components"] || []).push([["vendors-node_modules_rjsf_utils_lib_index_js"],{

/***/ "../../node_modules/@rjsf/utils/lib/ErrorSchemaBuilder.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/ErrorSchemaBuilder.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorSchemaBuilder)
/* harmony export */ });
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/cloneDeep */ "../../node_modules/lodash/cloneDeep.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");




/** The `ErrorSchemaBuilder<T>` is used to build an `ErrorSchema<T>` since the definition of the `ErrorSchema` type is
 * designed for reading information rather than writing it. Use this class to add, replace or clear errors in an error
 * schema by using either dotted path or an array of path names. Once you are done building the `ErrorSchema`, you can
 * get the result and/or reset all the errors back to an initial set and start again.
 */
class ErrorSchemaBuilder {
    /** Construct an `ErrorSchemaBuilder` with an optional initial set of errors in an `ErrorSchema`.
     *
     * @param [initialSchema] - The optional set of initial errors, that will be cloned into the class
     */
    constructor(initialSchema) {
        /** The error schema being built
         *
         * @private
         */
        this.errorSchema = {};
        this.resetAllErrors(initialSchema);
    }
    /** Returns the `ErrorSchema` that has been updated by the methods of the `ErrorSchemaBuilder`
     */
    get ErrorSchema() {
        return this.errorSchema;
    }
    /** Will get an existing `ErrorSchema` at the specified `pathOfError` or create and return one.
     *
     * @param [pathOfError] - The optional path into the `ErrorSchema` at which to add the error(s)
     * @returns - The error block for the given `pathOfError` or the root if not provided
     * @private
     */
    getOrCreateErrorBlock(pathOfError) {
        const hasPath = (Array.isArray(pathOfError) && pathOfError.length > 0) || typeof pathOfError === 'string';
        let errorBlock = hasPath ? lodash_get__WEBPACK_IMPORTED_MODULE_1___default()(this.errorSchema, pathOfError) : this.errorSchema;
        if (!errorBlock && pathOfError) {
            errorBlock = {};
            lodash_set__WEBPACK_IMPORTED_MODULE_2___default()(this.errorSchema, pathOfError, errorBlock);
        }
        return errorBlock;
    }
    /** Resets all errors in the `ErrorSchemaBuilder` back to the `initialSchema` if provided, otherwise an empty set.
     *
     * @param [initialSchema] - The optional set of initial errors, that will be cloned into the class
     * @returns - The `ErrorSchemaBuilder` object for chaining purposes
     */
    resetAllErrors(initialSchema) {
        this.errorSchema = initialSchema ? lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_0___default()(initialSchema) : {};
        return this;
    }
    /** Adds the `errorOrList` to the list of errors in the `ErrorSchema` at either the root level or the location within
     * the schema described by the `pathOfError`. For more information about how to specify the path see the
     * [eslint lodash plugin docs](https://github.com/wix/eslint-plugin-lodash/blob/master/docs/rules/path-style.md).
     *
     * @param errorOrList - The error or list of errors to add into the `ErrorSchema`
     * @param [pathOfError] - The optional path into the `ErrorSchema` at which to add the error(s)
     * @returns - The `ErrorSchemaBuilder` object for chaining purposes
     */
    addErrors(errorOrList, pathOfError) {
        const errorBlock = this.getOrCreateErrorBlock(pathOfError);
        let errorsList = lodash_get__WEBPACK_IMPORTED_MODULE_1___default()(errorBlock, _constants__WEBPACK_IMPORTED_MODULE_3__.ERRORS_KEY);
        if (!Array.isArray(errorsList)) {
            errorsList = [];
            errorBlock[_constants__WEBPACK_IMPORTED_MODULE_3__.ERRORS_KEY] = errorsList;
        }
        if (Array.isArray(errorOrList)) {
            errorsList.push(...errorOrList);
        }
        else {
            errorsList.push(errorOrList);
        }
        return this;
    }
    /** Sets/replaces the `errorOrList` as the error(s) in the `ErrorSchema` at either the root level or the location
     * within the schema described by the `pathOfError`. For more information about how to specify the path see the
     * [eslint lodash plugin docs](https://github.com/wix/eslint-plugin-lodash/blob/master/docs/rules/path-style.md).
     *
     * @param errorOrList - The error or list of errors to set into the `ErrorSchema`
     * @param [pathOfError] - The optional path into the `ErrorSchema` at which to set the error(s)
     * @returns - The `ErrorSchemaBuilder` object for chaining purposes
     */
    setErrors(errorOrList, pathOfError) {
        const errorBlock = this.getOrCreateErrorBlock(pathOfError);
        // Effectively clone the array being given to prevent accidental outside manipulation of the given list
        const listToAdd = Array.isArray(errorOrList) ? [...errorOrList] : [errorOrList];
        lodash_set__WEBPACK_IMPORTED_MODULE_2___default()(errorBlock, _constants__WEBPACK_IMPORTED_MODULE_3__.ERRORS_KEY, listToAdd);
        return this;
    }
    /** Clears the error(s) in the `ErrorSchema` at either the root level or the location within the schema described by
     * the `pathOfError`. For more information about how to specify the path see the
     * [eslint lodash plugin docs](https://github.com/wix/eslint-plugin-lodash/blob/master/docs/rules/path-style.md).
     *
     * @param [pathOfError] - The optional path into the `ErrorSchema` at which to clear the error(s)
     * @returns - The `ErrorSchemaBuilder` object for chaining purposes
     */
    clearErrors(pathOfError) {
        const errorBlock = this.getOrCreateErrorBlock(pathOfError);
        lodash_set__WEBPACK_IMPORTED_MODULE_2___default()(errorBlock, _constants__WEBPACK_IMPORTED_MODULE_3__.ERRORS_KEY, []);
        return this;
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/allowAdditionalItems.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/allowAdditionalItems.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ allowAdditionalItems)
/* harmony export */ });
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");

/** Checks the schema to see if it is allowing additional items, by verifying that `schema.additionalItems` is an
 * object. The user is warned in the console if `schema.additionalItems` has the value `true`.
 *
 * @param schema - The schema object to check
 * @returns - True if additional items is allowed, otherwise false
 */
function allowAdditionalItems(schema) {
    if (schema.additionalItems === true) {
        console.warn('additionalItems=true is currently not supported');
    }
    return (0,_isObject__WEBPACK_IMPORTED_MODULE_0__["default"])(schema.additionalItems);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/asNumber.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/asNumber.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ asNumber)
/* harmony export */ });
/** Attempts to convert the string into a number. If an empty string is provided, then `undefined` is returned. If a
 * `null` is provided, it is returned. If the string ends in a `.` then the string is returned because the user may be
 * in the middle of typing a float number. If a number ends in a pattern like `.0`, `.20`, `.030`, string is returned
 * because the user may be typing number that will end in a non-zero digit. Otherwise, the string is wrapped by
 * `Number()` and if that result is not `NaN`, that number will be returned, otherwise the string `value` will be.
 *
 * @param value - The string or null value to convert to a number
 * @returns - The `value` converted to a number when appropriate, otherwise the `value`
 */
function asNumber(value) {
    if (value === '') {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    if (/\.$/.test(value)) {
        // '3.' can't really be considered a number even if it parses in js. The
        // user is most likely entering a float.
        return value;
    }
    if (/\.0$/.test(value)) {
        // we need to return this as a string here, to allow for input like 3.07
        return value;
    }
    if (/\.\d*0$/.test(value)) {
        // It's a number, that's cool - but we need it as a string so it doesn't screw
        // with the user when entering dollar amounts or other values (such as those with
        // specific precision or number of significant digits)
        return value;
    }
    const n = Number(value);
    const valid = typeof n === 'number' && !Number.isNaN(n);
    return valid ? n : value;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/canExpand.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/canExpand.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ canExpand)
/* harmony export */ });
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");

/** Checks whether the field described by `schema`, having the `uiSchema` and `formData` supports expanding. The UI for
 * the field can expand if it has additional properties, is not forced as non-expandable by the `uiSchema` and the
 * `formData` object doesn't already have `schema.maxProperties` elements.
 *
 * @param schema - The schema for the field that is being checked
 * @param [uiSchema={}] - The uiSchema for the field
 * @param [formData] - The formData for the field
 * @returns - True if the schema element has additionalProperties, is expandable, and not at the maxProperties limit
 */
function canExpand(schema, uiSchema = {}, formData) {
    if (!schema.additionalProperties) {
        return false;
    }
    const { expandable = true } = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_0__["default"])(uiSchema);
    if (expandable === false) {
        return expandable;
    }
    // if ui:options.expandable was not explicitly set to false, we can add
    // another property if we have not exceeded maxProperties yet
    if (schema.maxProperties !== undefined && formData) {
        return Object.keys(formData).length < schema.maxProperties;
    }
    return true;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/constants.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ADDITIONAL_PROPERTIES_KEY: () => (/* binding */ ADDITIONAL_PROPERTIES_KEY),
/* harmony export */   ADDITIONAL_PROPERTY_FLAG: () => (/* binding */ ADDITIONAL_PROPERTY_FLAG),
/* harmony export */   ALL_OF_KEY: () => (/* binding */ ALL_OF_KEY),
/* harmony export */   ANY_OF_KEY: () => (/* binding */ ANY_OF_KEY),
/* harmony export */   CONST_KEY: () => (/* binding */ CONST_KEY),
/* harmony export */   DEFAULT_KEY: () => (/* binding */ DEFAULT_KEY),
/* harmony export */   DEFINITIONS_KEY: () => (/* binding */ DEFINITIONS_KEY),
/* harmony export */   DEPENDENCIES_KEY: () => (/* binding */ DEPENDENCIES_KEY),
/* harmony export */   ENUM_KEY: () => (/* binding */ ENUM_KEY),
/* harmony export */   ERRORS_KEY: () => (/* binding */ ERRORS_KEY),
/* harmony export */   ID_KEY: () => (/* binding */ ID_KEY),
/* harmony export */   IF_KEY: () => (/* binding */ IF_KEY),
/* harmony export */   ITEMS_KEY: () => (/* binding */ ITEMS_KEY),
/* harmony export */   JUNK_OPTION_ID: () => (/* binding */ JUNK_OPTION_ID),
/* harmony export */   NAME_KEY: () => (/* binding */ NAME_KEY),
/* harmony export */   ONE_OF_KEY: () => (/* binding */ ONE_OF_KEY),
/* harmony export */   PROPERTIES_KEY: () => (/* binding */ PROPERTIES_KEY),
/* harmony export */   REF_KEY: () => (/* binding */ REF_KEY),
/* harmony export */   REQUIRED_KEY: () => (/* binding */ REQUIRED_KEY),
/* harmony export */   RJSF_ADDITIONAL_PROPERTIES_FLAG: () => (/* binding */ RJSF_ADDITIONAL_PROPERTIES_FLAG),
/* harmony export */   RJSF_ADDITONAL_PROPERTIES_FLAG: () => (/* binding */ RJSF_ADDITONAL_PROPERTIES_FLAG),
/* harmony export */   ROOT_SCHEMA_PREFIX: () => (/* binding */ ROOT_SCHEMA_PREFIX),
/* harmony export */   SUBMIT_BTN_OPTIONS_KEY: () => (/* binding */ SUBMIT_BTN_OPTIONS_KEY),
/* harmony export */   UI_FIELD_KEY: () => (/* binding */ UI_FIELD_KEY),
/* harmony export */   UI_GLOBAL_OPTIONS_KEY: () => (/* binding */ UI_GLOBAL_OPTIONS_KEY),
/* harmony export */   UI_OPTIONS_KEY: () => (/* binding */ UI_OPTIONS_KEY),
/* harmony export */   UI_WIDGET_KEY: () => (/* binding */ UI_WIDGET_KEY)
/* harmony export */ });
/** Below are the list of all the keys into various elements of a RJSFSchema or UiSchema that are used by the various
 * utility functions. In addition to those keys, there are the special `ADDITIONAL_PROPERTY_FLAG` and
 * `RJSF_ADDITIONAL_PROPERTIES_FLAG` flags that is added to a schema under certain conditions by the `retrieveSchema()`
 * utility.
 */
const ADDITIONAL_PROPERTY_FLAG = '__additional_property';
const ADDITIONAL_PROPERTIES_KEY = 'additionalProperties';
const ALL_OF_KEY = 'allOf';
const ANY_OF_KEY = 'anyOf';
const CONST_KEY = 'const';
const DEFAULT_KEY = 'default';
const DEFINITIONS_KEY = 'definitions';
const DEPENDENCIES_KEY = 'dependencies';
const ENUM_KEY = 'enum';
const ERRORS_KEY = '__errors';
const ID_KEY = '$id';
const IF_KEY = 'if';
const ITEMS_KEY = 'items';
const JUNK_OPTION_ID = '_$junk_option_schema_id$_';
const NAME_KEY = '$name';
const ONE_OF_KEY = 'oneOf';
const PROPERTIES_KEY = 'properties';
const REQUIRED_KEY = 'required';
const SUBMIT_BTN_OPTIONS_KEY = 'submitButtonOptions';
const REF_KEY = '$ref';
/**
 * @deprecated Replace with correctly spelled constant `RJSF_ADDITIONAL_PROPERTIES_FLAG`
 */
const RJSF_ADDITONAL_PROPERTIES_FLAG = '__rjsf_additionalProperties';
const RJSF_ADDITIONAL_PROPERTIES_FLAG = '__rjsf_additionalProperties';
const ROOT_SCHEMA_PREFIX = '__rjsf_rootSchema';
const UI_FIELD_KEY = 'ui:field';
const UI_WIDGET_KEY = 'ui:widget';
const UI_OPTIONS_KEY = 'ui:options';
const UI_GLOBAL_OPTIONS_KEY = 'ui:globalOptions';


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/createErrorHandler.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/createErrorHandler.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createErrorHandler)
/* harmony export */ });
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js");
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");


/** Given a `formData` object, recursively creates a `FormValidation` error handling structure around it
 *
 * @param formData - The form data around which the error handler is created
 * @returns - A `FormValidation` object based on the `formData` structure
 */
function createErrorHandler(formData) {
    const handler = {
        // We store the list of errors for this node in a property named __errors
        // to avoid name collision with a possible sub schema field named
        // 'errors' (see `utils.toErrorSchema`).
        [_constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY]: [],
        addError(message) {
            this[_constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY].push(message);
        },
    };
    if (Array.isArray(formData)) {
        return formData.reduce((acc, value, key) => {
            return { ...acc, [key]: createErrorHandler(value) };
        }, handler);
    }
    if (lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default()(formData)) {
        const formObject = formData;
        return Object.keys(formObject).reduce((acc, key) => {
            return { ...acc, [key]: createErrorHandler(formObject[key]) };
        }, handler);
    }
    return handler;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/createSchemaUtils.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/createSchemaUtils.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createSchemaUtils)
/* harmony export */ });
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");
/* harmony import */ var _schema__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./schema */ "../../node_modules/@rjsf/utils/lib/schema/index.js");


/** The `SchemaUtils` class provides a wrapper around the publicly exported APIs in the `utils/schema` directory such
 * that one does not have to explicitly pass the `validator`, `rootSchema`, or `experimental_defaultFormStateBehavior` to each method.
 * Since these generally do not change across a `Form`, this allows for providing a simplified set of APIs to the
 * `@rjsf/core` components and the various themes as well. This class implements the `SchemaUtilsType` interface.
 */
class SchemaUtils {
    /** Constructs the `SchemaUtils` instance with the given `validator` and `rootSchema` stored as instance variables
     *
     * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
     * @param rootSchema - The root schema that will be forwarded to all the APIs
     * @param experimental_defaultFormStateBehavior - Configuration flags to allow users to override default form state behavior
     */
    constructor(validator, rootSchema, experimental_defaultFormStateBehavior) {
        this.rootSchema = rootSchema;
        this.validator = validator;
        this.experimental_defaultFormStateBehavior = experimental_defaultFormStateBehavior;
    }
    /** Returns the `ValidatorType` in the `SchemaUtilsType`
     *
     * @returns - The `ValidatorType`
     */
    getValidator() {
        return this.validator;
    }
    /** Determines whether either the `validator` and `rootSchema` differ from the ones associated with this instance of
     * the `SchemaUtilsType`. If either `validator` or `rootSchema` are falsy, then return false to prevent the creation
     * of a new `SchemaUtilsType` with incomplete properties.
     *
     * @param validator - An implementation of the `ValidatorType` interface that will be compared against the current one
     * @param rootSchema - The root schema that will be compared against the current one
     * @param [experimental_defaultFormStateBehavior] Optional configuration object, if provided, allows users to override default form state behavior
     * @returns - True if the `SchemaUtilsType` differs from the given `validator` or `rootSchema`
     */
    doesSchemaUtilsDiffer(validator, rootSchema, experimental_defaultFormStateBehavior = {}) {
        if (!validator || !rootSchema) {
            return false;
        }
        return (this.validator !== validator ||
            !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(this.rootSchema, rootSchema) ||
            !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(this.experimental_defaultFormStateBehavior, experimental_defaultFormStateBehavior));
    }
    /** Returns the superset of `formData` that includes the given set updated to include any missing fields that have
     * computed to have defaults provided in the `schema`.
     *
     * @param schema - The schema for which the default state is desired
     * @param [formData] - The current formData, if any, onto which to provide any missing defaults
     * @param [includeUndefinedValues=false] - Optional flag, if true, cause undefined values to be added as defaults.
     *          If "excludeObjectChildren", pass `includeUndefinedValues` as false when computing defaults for any nested
     *          object properties.
     * @returns - The resulting `formData` with all the defaults provided
     */
    getDefaultFormState(schema, formData, includeUndefinedValues = false) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getDefaultFormState)(this.validator, schema, formData, this.rootSchema, includeUndefinedValues, this.experimental_defaultFormStateBehavior);
    }
    /** Determines whether the combination of `schema` and `uiSchema` properties indicates that the label for the `schema`
     * should be displayed in a UI.
     *
     * @param schema - The schema for which the display label flag is desired
     * @param [uiSchema] - The UI schema from which to derive potentially displayable information
     * @param [globalOptions={}] - The optional Global UI Schema from which to get any fallback `xxx` options
     * @returns - True if the label should be displayed or false if it should not
     */
    getDisplayLabel(schema, uiSchema, globalOptions) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getDisplayLabel)(this.validator, schema, uiSchema, this.rootSchema, globalOptions);
    }
    /** Determines which of the given `options` provided most closely matches the `formData`.
     * Returns the index of the option that is valid and is the closest match, or 0 if there is no match.
     *
     * The closest match is determined using the number of matching properties, and more heavily favors options with
     * matching readOnly, default, or const values.
     *
     * @param formData - The form data associated with the schema
     * @param options - The list of options that can be selected from
     * @param [selectedOption] - The index of the currently selected option, defaulted to -1 if not specified
     * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
     *          determine which option is selected
     * @returns - The index of the option that is the closest match to the `formData` or the `selectedOption` if no match
     */
    getClosestMatchingOption(formData, options, selectedOption, discriminatorField) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getClosestMatchingOption)(this.validator, this.rootSchema, formData, options, selectedOption, discriminatorField);
    }
    /** Given the `formData` and list of `options`, attempts to find the index of the first option that matches the data.
     * Always returns the first option if there is nothing that matches.
     *
     * @param formData - The current formData, if any, used to figure out a match
     * @param options - The list of options to find a matching options from
     * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
     *          determine which option is selected
     * @returns - The firstindex of the matched option or 0 if none is available
     */
    getFirstMatchingOption(formData, options, discriminatorField) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getFirstMatchingOption)(this.validator, formData, options, this.rootSchema, discriminatorField);
    }
    /** Given the `formData` and list of `options`, attempts to find the index of the option that best matches the data.
     * Deprecated, use `getFirstMatchingOption()` instead.
     *
     * @param formData - The current formData, if any, onto which to provide any missing defaults
     * @param options - The list of options to find a matching options from
     * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
     *          determine which option is selected
     * @returns - The index of the matched option or 0 if none is available
     * @deprecated
     */
    getMatchingOption(formData, options, discriminatorField) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getMatchingOption)(this.validator, formData, options, this.rootSchema, discriminatorField);
    }
    /** Checks to see if the `schema` and `uiSchema` combination represents an array of files
     *
     * @param schema - The schema for which check for array of files flag is desired
     * @param [uiSchema] - The UI schema from which to check the widget
     * @returns - True if schema/uiSchema contains an array of files, otherwise false
     */
    isFilesArray(schema, uiSchema) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.isFilesArray)(this.validator, schema, uiSchema, this.rootSchema);
    }
    /** Checks to see if the `schema` combination represents a multi-select
     *
     * @param schema - The schema for which check for a multi-select flag is desired
     * @returns - True if schema contains a multi-select, otherwise false
     */
    isMultiSelect(schema) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.isMultiSelect)(this.validator, schema, this.rootSchema);
    }
    /** Checks to see if the `schema` combination represents a select
     *
     * @param schema - The schema for which check for a select flag is desired
     * @returns - True if schema contains a select, otherwise false
     */
    isSelect(schema) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.isSelect)(this.validator, schema, this.rootSchema);
    }
    /** Merges the errors in `additionalErrorSchema` into the existing `validationData` by combining the hierarchies in
     * the two `ErrorSchema`s and then appending the error list from the `additionalErrorSchema` obtained by calling
     * `getValidator().toErrorList()` onto the `errors` in the `validationData`. If no `additionalErrorSchema` is passed,
     * then `validationData` is returned.
     *
     * @param validationData - The current `ValidationData` into which to merge the additional errors
     * @param [additionalErrorSchema] - The additional set of errors
     * @returns - The `validationData` with the additional errors from `additionalErrorSchema` merged into it, if provided.
     * @deprecated - Use the `validationDataMerge()` function exported from `@rjsf/utils` instead. This function will be
     *        removed in the next major release.
     */
    mergeValidationData(validationData, additionalErrorSchema) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.mergeValidationData)(this.validator, validationData, additionalErrorSchema);
    }
    /** Retrieves an expanded schema that has had all of its conditions, additional properties, references and
     * dependencies resolved and merged into the `schema` given a `rawFormData` that is used to do the potentially
     * recursive resolution.
     *
     * @param schema - The schema for which retrieving a schema is desired
     * @param [rawFormData] - The current formData, if any, to assist retrieving a schema
     * @returns - The schema having its conditions, additional properties, references and dependencies resolved
     */
    retrieveSchema(schema, rawFormData) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.retrieveSchema)(this.validator, schema, this.rootSchema, rawFormData);
    }
    /** Sanitize the `data` associated with the `oldSchema` so it is considered appropriate for the `newSchema`. If the
     * new schema does not contain any properties, then `undefined` is returned to clear all the form data. Due to the
     * nature of schemas, this sanitization happens recursively for nested objects of data. Also, any properties in the
     * old schemas that are non-existent in the new schema are set to `undefined`.
     *
     * @param [newSchema] - The new schema for which the data is being sanitized
     * @param [oldSchema] - The old schema from which the data originated
     * @param [data={}] - The form data associated with the schema, defaulting to an empty object when undefined
     * @returns - The new form data, with all the fields uniquely associated with the old schema set
     *      to `undefined`. Will return `undefined` if the new schema is not an object containing properties.
     */
    sanitizeDataForNewSchema(newSchema, oldSchema, data) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.sanitizeDataForNewSchema)(this.validator, this.rootSchema, newSchema, oldSchema, data);
    }
    /** Generates an `IdSchema` object for the `schema`, recursively
     *
     * @param schema - The schema for which the display label flag is desired
     * @param [id] - The base id for the schema
     * @param [formData] - The current formData, if any, onto which to provide any missing defaults
     * @param [idPrefix='root'] - The prefix to use for the id
     * @param [idSeparator='_'] - The separator to use for the path segments in the id
     * @returns - The `IdSchema` object for the `schema`
     */
    toIdSchema(schema, id, formData, idPrefix = 'root', idSeparator = '_') {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.toIdSchema)(this.validator, schema, id, this.rootSchema, formData, idPrefix, idSeparator);
    }
    /** Generates an `PathSchema` object for the `schema`, recursively
     *
     * @param schema - The schema for which the display label flag is desired
     * @param [name] - The base name for the schema
     * @param [formData] - The current formData, if any, onto which to provide any missing defaults
     * @returns - The `PathSchema` object for the `schema`
     */
    toPathSchema(schema, name, formData) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.toPathSchema)(this.validator, schema, name, this.rootSchema, formData);
    }
}
/** Creates a `SchemaUtilsType` interface that is based around the given `validator` and `rootSchema` parameters. The
 * resulting interface implementation will forward the `validator` and `rootSchema` to all the wrapped APIs.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param [experimental_defaultFormStateBehavior] Optional configuration object, if provided, allows users to override default form state behavior
 * @returns - An implementation of a `SchemaUtilsType` interface
 */
function createSchemaUtils(validator, rootSchema, experimental_defaultFormStateBehavior = {}) {
    return new SchemaUtils(validator, rootSchema, experimental_defaultFormStateBehavior);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/dataURItoBlob.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/dataURItoBlob.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dataURItoBlob)
/* harmony export */ });
/** Given the `FileReader.readAsDataURL()` based `dataURI` extracts that data into an actual Blob along with the name
 * of that Blob if provided in the URL. If no name is provided, then the name falls back to `unknown`.
 *
 * @param dataURI - The `DataUrl` potentially containing name and raw data to be converted to a Blob
 * @returns - an object containing a Blob and its name, extracted from the URI
 */
function dataURItoBlob(dataURILike) {
    var _a;
    // check if is dataURI
    if (dataURILike.indexOf('data:') === -1) {
        throw new Error('File is invalid: URI must be a dataURI');
    }
    const dataURI = dataURILike.slice(5);
    // split the dataURI into media and base64, with the base64 signature
    const splitted = dataURI.split(';base64,');
    // if the base64 signature is not present, the latter part will become empty
    if (splitted.length !== 2) {
        throw new Error('File is invalid: dataURI must be base64');
    }
    // extract the mime type, media parameters including the name, and the base64 string
    const [media, base64] = splitted;
    const [mime, ...mediaparams] = media.split(';');
    const type = mime || '';
    // extract the name from the parameters
    const name = decodeURI(
    // parse the parameters into key-value pairs, find a key, and extract a value
    // if no key is found, then the name is unknown
    ((_a = mediaparams.map((param) => param.split('=')).find(([key]) => key === 'name')) === null || _a === void 0 ? void 0 : _a[1]) || 'unknown');
    // Built the Uint8Array Blob parameter from the base64 string.
    try {
        const binary = atob(base64);
        const array = new Array(binary.length);
        for (let i = 0; i < binary.length; i++) {
            array[i] = binary.charCodeAt(i);
        }
        // Create the blob object
        const blob = new window.Blob([new Uint8Array(array)], { type });
        return { blob, name };
    }
    catch (error) {
        throw new Error('File is invalid: ' + error.message);
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/dateRangeOptions.js":
/*!**************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/dateRangeOptions.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dateRangeOptions)
/* harmony export */ });
/* harmony import */ var _pad__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pad */ "../../node_modules/@rjsf/utils/lib/pad.js");

/** Returns a list of options for a date range between `start` and `stop`. If the start date is greater than the end
 * date, then the date range is reversed. If `start` and `stop` are negative numbers (or zero), then they will be
 * treated as relative to the current year.
 *
 * @param start - The starting point of the date range
 * @param stop - The ending point of the date range
 * @returns - The list of EnumOptionsType for the date range between `start` and `stop`
 * @throws - Error when `start` and `stop` aren't both <= 0 or > 0
 */
function dateRangeOptions(start, stop) {
    if (start <= 0 && stop <= 0) {
        start = new Date().getFullYear() + start;
        stop = new Date().getFullYear() + stop;
    }
    else if (start < 0 || stop < 0) {
        throw new Error(`Both start (${start}) and stop (${stop}) must both be <= 0 or > 0, got one of each`);
    }
    if (start > stop) {
        return dateRangeOptions(stop, start).reverse();
    }
    const options = [];
    for (let i = start; i <= stop; i++) {
        options.push({ value: i, label: (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(i, 2) });
    }
    return options;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/deepEquals.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/deepEquals.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ deepEquals)
/* harmony export */ });
/* harmony import */ var fast_equals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fast-equals */ "../../node_modules/fast-equals/dist/esm/index.mjs");

/** Check if all parameters are typeof function.
 *
 * @param a - The first element to check typeof
 * @param b - The second element to check typeof
 * @returns - if typeof a and b are equal to function return true, otherwise false
 */
function isFunctions(a, b) {
    return typeof a === 'function' && typeof b === 'function';
}
/** Implements a deep equals using the `fast-equal.createCustomEqual` function, that provides a customized comparator that
 * assumes all functions in objects are equivalent.
 *
 * @param a - The first element to compare
 * @param b - The second element to compare
 * @returns - True if the `a` and `b` are deeply equal, false otherwise
 */
const customDeepEqual = (0,fast_equals__WEBPACK_IMPORTED_MODULE_0__.createCustomEqual)({
    createInternalComparator: (comparator) => {
        return (a, b, _idxA, _idxB, _parentA, _parentB, state) => {
            if (isFunctions(a, b)) {
                // Assume all functions are equivalent
                // see https://github.com/rjsf-team/react-jsonschema-form/issues/255
                return true;
            }
            return comparator(a, b, state);
        };
    },
});
/** Implements a deep equals using the `fast-equal.createCustomEqual` function, that provides a customized comparator that
 * assumes all functions are equivalent.
 *
 * @param a - The first element to compare
 * @param b - The second element to compare
 * @returns - True if the `a` and `b` are deeply equal, false otherwise
 */
function deepEquals(a, b) {
    if (isFunctions(a, b)) {
        return true;
    }
    return customDeepEqual(a, b);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/englishStringTranslator.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/englishStringTranslator.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ englishStringTranslator)
/* harmony export */ });
/* harmony import */ var _replaceStringParameters__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./replaceStringParameters */ "../../node_modules/@rjsf/utils/lib/replaceStringParameters.js");

/** Translates a `TranslatableString` value `stringToTranslate` into english. When a `params` array is provided, each
 * value in the array is used to replace any of the replaceable parameters in the `stringToTranslate` using the `%1`,
 * `%2`, etc. replacement specifiers.
 *
 * @param stringToTranslate - The `TranslatableString` value to convert to english
 * @param params - The optional list of replaceable parameter values to substitute into the english string
 * @returns - The `stringToTranslate` itself with any replaceable parameter values substituted
 */
function englishStringTranslator(stringToTranslate, params) {
    return (0,_replaceStringParameters__WEBPACK_IMPORTED_MODULE_0__["default"])(stringToTranslate, params);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsDeselectValue.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsDeselectValue.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsDeselectValue)
/* harmony export */ });
/* harmony import */ var _enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./enumOptionsValueForIndex */ "../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");


/** Removes the enum option value at the `valueIndex` from the currently `selected` (list of) value(s). If `selected` is
 * a list, then that list is updated to remove the enum option value with the `valueIndex` in `allEnumOptions`. If it is
 * a single value, then if the enum option value with the `valueIndex` in `allEnumOptions` matches `selected`, undefined
 * is returned, otherwise the `selected` value is returned.
 *
 * @param valueIndex - The index of the value to be removed from the selected list or single value
 * @param selected - The current (list of) selected value(s)
 * @param [allEnumOptions=[]] - The list of all the known enumOptions
 * @returns - The updated `selected` with the enum option value at `valueIndex` in `allEnumOptions` removed from it,
 *        unless `selected` is a single value. In that case, if the `valueIndex` value matches `selected`, returns
 *        undefined, otherwise `selected`.
 */
function enumOptionsDeselectValue(valueIndex, selected, allEnumOptions = []) {
    const value = (0,_enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_0__["default"])(valueIndex, allEnumOptions);
    if (Array.isArray(selected)) {
        return selected.filter((v) => !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_1__["default"])(v, value));
    }
    return (0,_deepEquals__WEBPACK_IMPORTED_MODULE_1__["default"])(value, selected) ? undefined : selected;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsIndexForValue.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsIndexForValue.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsIndexForValue)
/* harmony export */ });
/* harmony import */ var _enumOptionsIsSelected__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./enumOptionsIsSelected */ "../../node_modules/@rjsf/utils/lib/enumOptionsIsSelected.js");

/** Returns the index(es) of the options in `allEnumOptions` whose value(s) match the ones in `value`. All the
 * `enumOptions` are filtered based on whether they are a "selected" `value` and the index of each selected one is then
 * stored in an array. If `multiple` is true, that array is returned, otherwise the first element in the array is
 * returned.
 *
 * @param value - The single value or list of values for which indexes are desired
 * @param [allEnumOptions=[]] - The list of all the known enumOptions
 * @param [multiple=false] - Optional flag, if true will return a list of index, otherwise a single one
 * @returns - A single string index for the first `value` in `allEnumOptions`, if not `multiple`. Otherwise, the list
 *        of indexes for (each of) the value(s) in `value`.
 */
function enumOptionsIndexForValue(value, allEnumOptions = [], multiple = false) {
    const selectedIndexes = allEnumOptions
        .map((opt, index) => ((0,_enumOptionsIsSelected__WEBPACK_IMPORTED_MODULE_0__["default"])(opt.value, value) ? String(index) : undefined))
        .filter((opt) => typeof opt !== 'undefined');
    if (!multiple) {
        return selectedIndexes[0];
    }
    return selectedIndexes;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsIsSelected.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsIsSelected.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsIsSelected)
/* harmony export */ });
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");

/** Determines whether the given `value` is (one of) the `selected` value(s).
 *
 * @param value - The value being checked to see if it is selected
 * @param selected - The current selected value or list of values
 * @returns - true if the `value` is one of the `selected` ones, false otherwise
 */
function enumOptionsIsSelected(value, selected) {
    if (Array.isArray(selected)) {
        return selected.some((sel) => (0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(sel, value));
    }
    return (0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(selected, value);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsSelectValue.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsSelectValue.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsSelectValue)
/* harmony export */ });
/* harmony import */ var _enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./enumOptionsValueForIndex */ "../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js");
/* harmony import */ var lodash_isNil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isNil */ "../../node_modules/lodash/isNil.js");
/* harmony import */ var lodash_isNil__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isNil__WEBPACK_IMPORTED_MODULE_1__);


/** Add the enum option value at the `valueIndex` to the list of `selected` values in the proper order as defined by
 * `allEnumOptions`
 *
 * @param valueIndex - The index of the value that should be selected
 * @param selected - The current list of selected values
 * @param [allEnumOptions=[]] - The list of all the known enumOptions
 * @returns - The updated list of selected enum values with enum value at the `valueIndex` added to it
 */
function enumOptionsSelectValue(valueIndex, selected, allEnumOptions = []) {
    const value = (0,_enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_0__["default"])(valueIndex, allEnumOptions);
    if (!lodash_isNil__WEBPACK_IMPORTED_MODULE_1___default()(value)) {
        const index = allEnumOptions.findIndex((opt) => value === opt.value);
        const all = allEnumOptions.map(({ value: val }) => val);
        const updated = selected.slice(0, index).concat(value, selected.slice(index));
        // As inserting values at predefined index positions doesn't work with empty
        // arrays, we need to reorder the updated selection to match the initial order
        return updated.sort((a, b) => Number(all.indexOf(a) > all.indexOf(b)));
    }
    return selected;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsValueForIndex)
/* harmony export */ });
/** Returns the value(s) from `allEnumOptions` at the index(es) provided by `valueIndex`. If `valueIndex` is not an
 * array AND the index is not valid for `allEnumOptions`, `emptyValue` is returned. If `valueIndex` is an array, AND it
 * contains an invalid index, the returned array will have the resulting undefined values filtered out, leaving only
 * valid values or in the worst case, an empty array.
 *
 * @param valueIndex - The index(es) of the value(s) that should be returned
 * @param [allEnumOptions=[]] - The list of all the known enumOptions
 * @param [emptyValue] - The value to return when the non-array `valueIndex` does not refer to a real option
 * @returns - The single or list of values specified by the single or list of indexes if they are valid. Otherwise,
 *        `emptyValue` or an empty list.
 */
function enumOptionsValueForIndex(valueIndex, allEnumOptions = [], emptyValue) {
    if (Array.isArray(valueIndex)) {
        return (valueIndex
            .map((index) => enumOptionsValueForIndex(index, allEnumOptions))
            // Since the recursive call returns `emptyValue` when we get a bad option, only filter those out
            .filter((val) => val !== emptyValue));
    }
    // So Number(null) and Number('') both return 0, so use emptyValue for those two values
    const index = valueIndex === '' || valueIndex === null ? -1 : Number(valueIndex);
    const option = allEnumOptions[index];
    return option ? option.value : emptyValue;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enums.js":
/*!***************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enums.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TranslatableString: () => (/* binding */ TranslatableString)
/* harmony export */ });
/** An enumeration of all the translatable strings used by `@rjsf/core` and its themes. The value of each of the
 * enumeration keys is expected to be the actual english string. Some strings contain replaceable parameter values
 * as indicated by `%1`, `%2`, etc. The number after the `%` indicates the order of the parameter. The ordering of
 * parameters is important because some languages may choose to put the second parameter before the first in its
 * translation. Also, some strings are rendered using `markdown-to-jsx` and thus support markdown and inline html.
 */
var TranslatableString;
(function (TranslatableString) {
    /** Fallback title of an array item, used by ArrayField */
    TranslatableString["ArrayItemTitle"] = "Item";
    /** Missing items reason, used by ArrayField */
    TranslatableString["MissingItems"] = "Missing items definition";
    /** Yes label, used by BooleanField */
    TranslatableString["YesLabel"] = "Yes";
    /** No label, used by BooleanField */
    TranslatableString["NoLabel"] = "No";
    /** Close label, used by ErrorList */
    TranslatableString["CloseLabel"] = "Close";
    /** Errors label, used by ErrorList */
    TranslatableString["ErrorsLabel"] = "Errors";
    /** New additionalProperties string default value, used by ObjectField */
    TranslatableString["NewStringDefault"] = "New Value";
    /** Add button title, used by AddButton */
    TranslatableString["AddButton"] = "Add";
    /** Add button title, used by AddButton */
    TranslatableString["AddItemButton"] = "Add Item";
    /** Copy button title, used by IconButton */
    TranslatableString["CopyButton"] = "Copy";
    /** Move down button title, used by IconButton */
    TranslatableString["MoveDownButton"] = "Move down";
    /** Move up button title, used by IconButton */
    TranslatableString["MoveUpButton"] = "Move up";
    /** Remove button title, used by IconButton */
    TranslatableString["RemoveButton"] = "Remove";
    /** Now label, used by AltDateWidget */
    TranslatableString["NowLabel"] = "Now";
    /** Clear label, used by AltDateWidget */
    TranslatableString["ClearLabel"] = "Clear";
    /** Aria date label, used by DateWidget */
    TranslatableString["AriaDateLabel"] = "Select a date";
    /** File preview label, used by FileWidget */
    TranslatableString["PreviewLabel"] = "Preview";
    /** Decrement button aria label, used by UpDownWidget */
    TranslatableString["DecrementAriaLabel"] = "Decrease value by 1";
    /** Increment button aria label, used by UpDownWidget */
    TranslatableString["IncrementAriaLabel"] = "Increase value by 1";
    // Strings with replaceable parameters
    /** Unknown field type reason, where %1 will be replaced with the type as provided by SchemaField */
    TranslatableString["UnknownFieldType"] = "Unknown field type %1";
    /** Option prefix, where %1 will be replaced with the option index as provided by MultiSchemaField */
    TranslatableString["OptionPrefix"] = "Option %1";
    /** Option prefix, where %1 and %2 will be replaced by the schema title and option index, respectively as provided by
     * MultiSchemaField
     */
    TranslatableString["TitleOptionPrefix"] = "%1 option %2";
    /** Key label, where %1 will be replaced by the label as provided by WrapIfAdditionalTemplate */
    TranslatableString["KeyLabel"] = "%1 Key";
    // Strings with replaceable parameters AND/OR that support markdown and html
    /** Invalid object field configuration as provided by the ObjectField.
     * NOTE: Use markdown notation rather than html tags.
     */
    TranslatableString["InvalidObjectField"] = "Invalid \"%1\" object field configuration: _%2_.";
    /** Unsupported field schema, used by UnsupportedField */
    TranslatableString["UnsupportedField"] = "Unsupported field schema.";
    /** Unsupported field schema, where %1 will be replaced by the idSchema.$id as provided by UnsupportedField.
     * NOTE: Use markdown notation rather than html tags.
     */
    TranslatableString["UnsupportedFieldWithId"] = "Unsupported field schema for field `%1`.";
    /** Unsupported field schema, where %1 will be replaced by the reason string as provided by UnsupportedField.
     * NOTE: Use markdown notation rather than html tags.
     */
    TranslatableString["UnsupportedFieldWithReason"] = "Unsupported field schema: _%1_.";
    /** Unsupported field schema, where %1 and %2 will be replaced by the idSchema.$id and reason strings, respectively,
     * as provided by UnsupportedField.
     * NOTE: Use markdown notation rather than html tags.
     */
    TranslatableString["UnsupportedFieldWithIdAndReason"] = "Unsupported field schema for field `%1`: _%2_.";
    /** File name, type and size info, where %1, %2 and %3 will be replaced by the file name, file type and file size as
     * provided by FileWidget
     */
    TranslatableString["FilesInfo"] = "**%1** (%2, %3 bytes)";
})(TranslatableString || (TranslatableString = {}));


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ findSchemaDefinition),
/* harmony export */   findSchemaDefinitionRecursive: () => (/* binding */ findSchemaDefinitionRecursive),
/* harmony export */   splitKeyElementFromObject: () => (/* binding */ splitKeyElementFromObject)
/* harmony export */ });
/* harmony import */ var jsonpointer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jsonpointer */ "../../node_modules/jsonpointer/jsonpointer.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/omit */ "../../node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");



/** Splits out the value at the `key` in `object` from the `object`, returning an array that contains in the first
 * location, the `object` minus the `key: value` and in the second location the `value`.
 *
 * @param key - The key from the object to extract
 * @param object - The object from which to extract the element
 * @returns - An array with the first value being the object minus the `key` element and the second element being the
 *      value from `object[key]`
 */
function splitKeyElementFromObject(key, object) {
    const value = object[key];
    const remaining = lodash_omit__WEBPACK_IMPORTED_MODULE_1___default()(object, [key]);
    return [remaining, value];
}
/** Given the name of a `$ref` from within a schema, using the `rootSchema`, recursively look up and return the
 * sub-schema using the path provided by that reference. If `#` is not the first character of the reference, the path
 * does not exist in the schema, or the reference resolves circularly back to itself, then throw an Error.
 * Otherwise return the sub-schema. Also deals with nested `$ref`s in the sub-schema.
 *
 * @param $ref - The ref string for which the schema definition is desired
 * @param [rootSchema={}] - The root schema in which to search for the definition
 * @param recurseList - List of $refs already resolved to prevent recursion
 * @returns - The sub-schema within the `rootSchema` which matches the `$ref` if it exists
 * @throws - Error indicating that no schema for that reference could be resolved
 */
function findSchemaDefinitionRecursive($ref, rootSchema = {}, recurseList = []) {
    const ref = $ref || '';
    let decodedRef;
    if (ref.startsWith('#')) {
        // Decode URI fragment representation.
        decodedRef = decodeURIComponent(ref.substring(1));
    }
    else {
        throw new Error(`Could not find a definition for ${$ref}.`);
    }
    const current = jsonpointer__WEBPACK_IMPORTED_MODULE_0__.get(rootSchema, decodedRef);
    if (current === undefined) {
        throw new Error(`Could not find a definition for ${$ref}.`);
    }
    const nextRef = current[_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY];
    if (nextRef) {
        // Check for circular references.
        if (recurseList.includes(nextRef)) {
            if (recurseList.length === 1) {
                throw new Error(`Definition for ${$ref} is a circular reference`);
            }
            const [firstRef, ...restRefs] = recurseList;
            const circularPath = [...restRefs, ref, firstRef].join(' -> ');
            throw new Error(`Definition for ${firstRef} contains a circular reference through ${circularPath}`);
        }
        const [remaining, theRef] = splitKeyElementFromObject(_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY, current);
        const subSchema = findSchemaDefinitionRecursive(theRef, rootSchema, [...recurseList, ref]);
        if (Object.keys(remaining).length > 0) {
            return { ...remaining, ...subSchema };
        }
        return subSchema;
    }
    return current;
}
/** Given the name of a `$ref` from within a schema, using the `rootSchema`, look up and return the sub-schema using the
 * path provided by that reference. If `#` is not the first character of the reference, the path does not exist in
 * the schema, or the reference resolves circularly back to itself, then throw an Error. Otherwise return the
 * sub-schema. Also deals with nested `$ref`s in the sub-schema.
 *
 * @param $ref - The ref string for which the schema definition is desired
 * @param [rootSchema={}] - The root schema in which to search for the definition
 * @returns - The sub-schema within the `rootSchema` which matches the `$ref` if it exists
 * @throws - Error indicating that no schema for that reference could be resolved
 */
function findSchemaDefinition($ref, rootSchema = {}) {
    const recurseList = [];
    return findSchemaDefinitionRecursive($ref, rootSchema, recurseList);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getDateElementProps.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getDateElementProps.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDateElementProps)
/* harmony export */ });
/** Given date & time information with optional yearRange & format, returns props for DateElement
 *
 * @param date - Object containing date with optional time information
 * @param time - Determines whether to include time or not
 * @param [yearRange=[1900, new Date().getFullYear() + 2]] - Controls the list of years to be displayed
 * @param [format='YMD'] - Controls the order in which day, month and year input element will be displayed
 * @returns Array of props for DateElement
 */
function getDateElementProps(date, time, yearRange = [1900, new Date().getFullYear() + 2], format = 'YMD') {
    const { day, month, year, hour, minute, second } = date;
    const dayObj = { type: 'day', range: [1, 31], value: day };
    const monthObj = { type: 'month', range: [1, 12], value: month };
    const yearObj = { type: 'year', range: yearRange, value: year };
    const dateElementProp = [];
    switch (format) {
        case 'MDY':
            dateElementProp.push(monthObj, dayObj, yearObj);
            break;
        case 'DMY':
            dateElementProp.push(dayObj, monthObj, yearObj);
            break;
        case 'YMD':
        default:
            dateElementProp.push(yearObj, monthObj, dayObj);
    }
    if (time) {
        dateElementProp.push({ type: 'hour', range: [0, 23], value: hour }, { type: 'minute', range: [0, 59], value: minute }, { type: 'second', range: [0, 59], value: second });
    }
    return dateElementProp;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDiscriminatorFieldFromSchema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isString */ "../../node_modules/lodash/isString.js");
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isString__WEBPACK_IMPORTED_MODULE_1__);


/** Returns the `discriminator.propertyName` when defined in the `schema` if it is a string. A warning is generated when
 * it is not a string. Returns `undefined` when a valid discriminator is not present.
 *
 * @param schema - The schema from which the discriminator is potentially obtained
 * @returns - The `discriminator.propertyName` if it exists in the schema, otherwise `undefined`
 */
function getDiscriminatorFieldFromSchema(schema) {
    let discriminator;
    const maybeString = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, 'discriminator.propertyName', undefined);
    if (lodash_isString__WEBPACK_IMPORTED_MODULE_1___default()(maybeString)) {
        discriminator = maybeString;
    }
    else if (maybeString !== undefined) {
        console.warn(`Expecting discriminator to be a string, got "${typeof maybeString}" instead`);
    }
    return discriminator;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getInputProps.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getInputProps.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getInputProps)
/* harmony export */ });
/* harmony import */ var _rangeSpec__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rangeSpec */ "../../node_modules/@rjsf/utils/lib/rangeSpec.js");

/** Using the `schema`, `defaultType` and `options`, extract out the props for the <input> element that make sense.
 *
 * @param schema - The schema for the field provided by the widget
 * @param [defaultType] - The default type, if any, for the field provided by the widget
 * @param [options={}] - The UI Options for the field provided by the widget
 * @param [autoDefaultStepAny=true] - Determines whether to auto-default step=any when the type is number and no step
 * @returns - The extracted `InputPropsType` object
 */
function getInputProps(schema, defaultType, options = {}, autoDefaultStepAny = true) {
    const inputProps = {
        type: defaultType || 'text',
        ...(0,_rangeSpec__WEBPACK_IMPORTED_MODULE_0__["default"])(schema),
    };
    // If options.inputType is set use that as the input type
    if (options.inputType) {
        inputProps.type = options.inputType;
    }
    else if (!defaultType) {
        // If the schema is of type number or integer, set the input type to number
        if (schema.type === 'number') {
            inputProps.type = 'number';
            // Only add step if one isn't already defined and we are auto-defaulting the "any" step
            if (autoDefaultStepAny && inputProps.step === undefined) {
                // Setting step to 'any' fixes a bug in Safari where decimals are not
                // allowed in number inputs
                inputProps.step = 'any';
            }
        }
        else if (schema.type === 'integer') {
            inputProps.type = 'number';
            // Only add step if one isn't already defined
            if (inputProps.step === undefined) {
                // Since this is integer, you always want to step up or down in multiples of 1
                inputProps.step = 1;
            }
        }
    }
    if (options.autocomplete) {
        inputProps.autoComplete = options.autocomplete;
    }
    return inputProps;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOptionMatchingSimpleDiscriminator)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");


/** Compares the value of `discriminatorField` within `formData` against the value of `discriminatorField` within schema for each `option`.
 * Returns index of first `option` whose discriminator matches formData. Returns `undefined` if there is no match.
 * This function does not work with discriminators of `"type": "object"` and `"type": "array"`
 *
 * @param formData - The current formData, if any, used to figure out a match
 * @param options - The list of options to find a matching options from
 * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
 *          determine which option is selected
 * @returns - The index of the matched option or undefined if there is no match
 */
function getOptionMatchingSimpleDiscriminator(formData, options, discriminatorField) {
    var _a;
    if (formData && discriminatorField) {
        const value = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, discriminatorField);
        if (value === undefined) {
            return;
        }
        for (let i = 0; i < options.length; i++) {
            const option = options[i];
            const discriminator = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(option, [_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY, discriminatorField], {});
            if (discriminator.type === 'object' || discriminator.type === 'array') {
                continue;
            }
            if (discriminator.const === value) {
                return i;
            }
            if ((_a = discriminator.enum) === null || _a === void 0 ? void 0 : _a.includes(value)) {
                return i;
            }
        }
    }
    return;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getSchemaType.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getSchemaType.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getSchemaType)
/* harmony export */ });
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./guessType */ "../../node_modules/@rjsf/utils/lib/guessType.js");

/** Gets the type of a given `schema`. If the type is not explicitly defined, then an attempt is made to infer it from
 * other elements of the schema as follows:
 * - schema.const: Returns the `guessType()` of that value
 * - schema.enum: Returns `string`
 * - schema.properties: Returns `object`
 * - schema.additionalProperties: Returns `object`
 * - type is an array with a length of 2 and one type is 'null': Returns the other type
 *
 * @param schema - The schema for which to get the type
 * @returns - The type of the schema
 */
function getSchemaType(schema) {
    let { type } = schema;
    if (!type && schema.const) {
        return (0,_guessType__WEBPACK_IMPORTED_MODULE_0__["default"])(schema.const);
    }
    if (!type && schema.enum) {
        return 'string';
    }
    if (!type && (schema.properties || schema.additionalProperties)) {
        return 'object';
    }
    if (Array.isArray(type)) {
        if (type.length === 2 && type.includes('null')) {
            type = type.find((type) => type !== 'null');
        }
        else {
            type = type[0];
        }
    }
    return type;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getSubmitButtonOptions.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getSubmitButtonOptions.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_OPTIONS: () => (/* binding */ DEFAULT_OPTIONS),
/* harmony export */   "default": () => (/* binding */ getSubmitButtonOptions)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");


/** The default submit button options, exported for testing purposes
 */
const DEFAULT_OPTIONS = {
    props: {
        disabled: false,
    },
    submitText: 'Submit',
    norender: false,
};
/** Extracts any `ui:submitButtonOptions` from the `uiSchema` and merges them onto the `DEFAULT_OPTIONS`
 *
 * @param [uiSchema={}] - the UI Schema from which to extract submit button props
 * @returns - The merging of the `DEFAULT_OPTIONS` with any custom ones
 */
function getSubmitButtonOptions(uiSchema = {}) {
    const uiOptions = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_1__["default"])(uiSchema);
    if (uiOptions && uiOptions[_constants__WEBPACK_IMPORTED_MODULE_0__.SUBMIT_BTN_OPTIONS_KEY]) {
        const options = uiOptions[_constants__WEBPACK_IMPORTED_MODULE_0__.SUBMIT_BTN_OPTIONS_KEY];
        return { ...DEFAULT_OPTIONS, ...options };
    }
    return DEFAULT_OPTIONS;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getTemplate.js":
/*!*********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getTemplate.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getTemplate)
/* harmony export */ });
/** Returns the template with the given `name` from either the `uiSchema` if it is defined or from the `registry`
 * otherwise. NOTE, since `ButtonTemplates` are not overridden in `uiSchema` only those in the `registry` are returned.
 *
 * @param name - The name of the template to fetch, restricted to the keys of `TemplatesType`
 * @param registry - The `Registry` from which to read the template
 * @param [uiOptions={}] - The `UIOptionsType` from which to read an alternate template
 * @returns - The template from either the `uiSchema` or `registry` for the `name`
 */
function getTemplate(name, registry, uiOptions = {}) {
    const { templates } = registry;
    if (name === 'ButtonTemplates') {
        return templates[name];
    }
    return (
    // Evaluating uiOptions[name] results in TS2590: Expression produces a union type that is too complex to represent
    // To avoid that, we cast uiOptions to `any` before accessing the name field
    uiOptions[name] || templates[name]);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getUiOptions.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getUiOptions.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getUiOptions)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");


/** Get all passed options from ui:options, and ui:<optionName>, returning them in an object with the `ui:`
 * stripped off. Any `globalOptions` will always be returned, unless they are overridden by options in the `uiSchema`.
 *
 * @param [uiSchema={}] - The UI Schema from which to get any `ui:xxx` options
 * @param [globalOptions={}] - The optional Global UI Schema from which to get any fallback `xxx` options
 * @returns - An object containing all the `ui:xxx` options with the `ui:` stripped off along with all `globalOptions`
 */
function getUiOptions(uiSchema = {}, globalOptions = {}) {
    return Object.keys(uiSchema)
        .filter((key) => key.indexOf('ui:') === 0)
        .reduce((options, key) => {
        const value = uiSchema[key];
        if (key === _constants__WEBPACK_IMPORTED_MODULE_0__.UI_WIDGET_KEY && (0,_isObject__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) {
            console.error('Setting options via ui:widget object is no longer supported, use ui:options instead');
            return options;
        }
        if (key === _constants__WEBPACK_IMPORTED_MODULE_0__.UI_OPTIONS_KEY && (0,_isObject__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) {
            return { ...options, ...value };
        }
        return { ...options, [key.substring(3)]: value };
    }, { ...globalOptions });
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getWidget.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getWidget.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-is */ "../../node_modules/@rjsf/utils/node_modules/react-is/index.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");






/** The map of schema types to widget type to widget name
 */
const widgetMap = {
    boolean: {
        checkbox: 'CheckboxWidget',
        radio: 'RadioWidget',
        select: 'SelectWidget',
        hidden: 'HiddenWidget',
    },
    string: {
        text: 'TextWidget',
        password: 'PasswordWidget',
        email: 'EmailWidget',
        hostname: 'TextWidget',
        ipv4: 'TextWidget',
        ipv6: 'TextWidget',
        uri: 'URLWidget',
        'data-url': 'FileWidget',
        radio: 'RadioWidget',
        select: 'SelectWidget',
        textarea: 'TextareaWidget',
        hidden: 'HiddenWidget',
        date: 'DateWidget',
        datetime: 'DateTimeWidget',
        'date-time': 'DateTimeWidget',
        'alt-date': 'AltDateWidget',
        'alt-datetime': 'AltDateTimeWidget',
        time: 'TimeWidget',
        color: 'ColorWidget',
        file: 'FileWidget',
    },
    number: {
        text: 'TextWidget',
        select: 'SelectWidget',
        updown: 'UpDownWidget',
        range: 'RangeWidget',
        radio: 'RadioWidget',
        hidden: 'HiddenWidget',
    },
    integer: {
        text: 'TextWidget',
        select: 'SelectWidget',
        updown: 'UpDownWidget',
        range: 'RangeWidget',
        radio: 'RadioWidget',
        hidden: 'HiddenWidget',
    },
    array: {
        select: 'SelectWidget',
        checkboxes: 'CheckboxesWidget',
        files: 'FileWidget',
        hidden: 'HiddenWidget',
    },
};
/** Wraps the given widget with stateless functional component that will merge any `defaultProps.options` with the
 * `options` that are provided in the props. It will add the wrapper component as a `MergedWidget` property onto the
 * `Widget` so that future attempts to wrap `AWidget` will return the already existing wrapper.
 *
 * @param AWidget - A widget that will be wrapped or one that is already wrapped
 * @returns - The wrapper widget
 */
function mergeWidgetOptions(AWidget) {
    let MergedWidget = lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(AWidget, 'MergedWidget');
    // cache return value as property of widget for proper react reconciliation
    if (!MergedWidget) {
        const defaultOptions = (AWidget.defaultProps && AWidget.defaultProps.options) || {};
        MergedWidget = ({ options, ...props }) => {
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AWidget, { options: { ...defaultOptions, ...options }, ...props });
        };
        lodash_set__WEBPACK_IMPORTED_MODULE_4___default()(AWidget, 'MergedWidget', MergedWidget);
    }
    return MergedWidget;
}
/** Given a schema representing a field to render and either the name or actual `Widget` implementation, returns the
 * React component that is used to render the widget. If the `widget` is already a React component, then it is wrapped
 * with a `MergedWidget`. Otherwise an attempt is made to look up the widget inside of the `registeredWidgets` map based
 * on the schema type and `widget` name. If no widget component can be found an `Error` is thrown.
 *
 * @param schema - The schema for the field
 * @param [widget] - Either the name of the widget OR a `Widget` implementation to use
 * @param [registeredWidgets={}] - A registry of widget name to `Widget` implementation
 * @returns - The `Widget` component to use
 * @throws - An error if there is no `Widget` component that can be returned
 */
function getWidget(schema, widget, registeredWidgets = {}) {
    const type = (0,_getSchemaType__WEBPACK_IMPORTED_MODULE_5__["default"])(schema);
    if (typeof widget === 'function' ||
        (widget && react_is__WEBPACK_IMPORTED_MODULE_2__.isForwardRef((0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(widget))) ||
        react_is__WEBPACK_IMPORTED_MODULE_2__.isMemo(widget)) {
        return mergeWidgetOptions(widget);
    }
    if (typeof widget !== 'string') {
        throw new Error(`Unsupported widget definition: ${typeof widget}`);
    }
    if (widget in registeredWidgets) {
        const registeredWidget = registeredWidgets[widget];
        return getWidget(schema, registeredWidget, registeredWidgets);
    }
    if (typeof type === 'string') {
        if (!(type in widgetMap)) {
            throw new Error(`No widget for type '${type}'`);
        }
        if (widget in widgetMap[type]) {
            const registeredWidget = registeredWidgets[widgetMap[type][widget]];
            return getWidget(schema, registeredWidget, registeredWidgets);
        }
    }
    throw new Error(`No widget '${widget}' for type '${type}'`);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/guessType.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/guessType.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ guessType)
/* harmony export */ });
/** Given a specific `value` attempts to guess the type of a schema element. In the case where we have to implicitly
 *  create a schema, it is useful to know what type to use based on the data we are defining.
 *
 * @param value - The value from which to guess the type
 * @returns - The best guess for the object type
 */
function guessType(value) {
    if (Array.isArray(value)) {
        return 'array';
    }
    if (typeof value === 'string') {
        return 'string';
    }
    if (value == null) {
        return 'null';
    }
    if (typeof value === 'boolean') {
        return 'boolean';
    }
    if (!isNaN(value)) {
        return 'number';
    }
    if (typeof value === 'object') {
        return 'object';
    }
    // Default to string if we can't figure it out
    return 'string';
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/hasWidget.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/hasWidget.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ hasWidget)
/* harmony export */ });
/* harmony import */ var _getWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWidget */ "../../node_modules/@rjsf/utils/lib/getWidget.js");

/** Detects whether the `widget` exists for the `schema` with the associated `registryWidgets` and returns true if it
 * does, or false if it doesn't.
 *
 * @param schema - The schema for the field
 * @param widget - Either the name of the widget OR a `Widget` implementation to use
 * @param [registeredWidgets={}] - A registry of widget name to `Widget` implementation
 * @returns - True if the widget exists, false otherwise
 */
function hasWidget(schema, widget, registeredWidgets = {}) {
    try {
        (0,_getWidget__WEBPACK_IMPORTED_MODULE_0__["default"])(schema, widget, registeredWidgets);
        return true;
    }
    catch (e) {
        const err = e;
        if (err.message && (err.message.startsWith('No widget') || err.message.startsWith('Unsupported widget'))) {
            return false;
        }
        throw e;
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/hashForSchema.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/hashForSchema.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ hashForSchema)
/* harmony export */ });
/** JS has no built-in hashing function, so rolling our own
 *  based on Java's hashing fn:
 *  http://www.java2s.com/example/nodejs-utility-method/string-hash/hashcode-4dc2b.html
 *
 * @param string - The string for which to get the hash
 * @returns - The resulting hash of the string in hex format
 */
function hashString(string) {
    let hash = 0;
    for (let i = 0; i < string.length; i += 1) {
        const chr = string.charCodeAt(i);
        hash = (hash << 5) - hash + chr;
        hash = hash & hash; // Convert to 32bit integer
    }
    return hash.toString(16);
}
/** Stringifies the schema and returns the hash of the resulting string. Sorts schema fields
 * in consistent order before stringify to prevent different hash ids for the same schema.
 *
 * @param schema - The schema for which the hash is desired
 * @returns - The string obtained from the hash of the stringified schema
 */
function hashForSchema(schema) {
    const allKeys = new Set();
    // solution source: https://stackoverflow.com/questions/16167581/sort-object-properties-and-json-stringify/53593328#53593328
    JSON.stringify(schema, (key, value) => (allKeys.add(key), value));
    return hashString(JSON.stringify(schema, Array.from(allKeys).sort()));
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/idGenerators.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/idGenerators.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ariaDescribedByIds: () => (/* binding */ ariaDescribedByIds),
/* harmony export */   descriptionId: () => (/* binding */ descriptionId),
/* harmony export */   errorId: () => (/* binding */ errorId),
/* harmony export */   examplesId: () => (/* binding */ examplesId),
/* harmony export */   helpId: () => (/* binding */ helpId),
/* harmony export */   optionId: () => (/* binding */ optionId),
/* harmony export */   titleId: () => (/* binding */ titleId)
/* harmony export */ });
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isString */ "../../node_modules/lodash/isString.js");
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isString__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");


/** Generates a consistent `id` pattern for a given `id` and a `suffix`
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @param suffix - The suffix to append to the id
 */
function idGenerator(id, suffix) {
    const theId = lodash_isString__WEBPACK_IMPORTED_MODULE_0___default()(id) ? id : id[_constants__WEBPACK_IMPORTED_MODULE_1__.ID_KEY];
    return `${theId}__${suffix}`;
}
/** Return a consistent `id` for the field description element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field description element from the given `id`
 */
function descriptionId(id) {
    return idGenerator(id, 'description');
}
/** Return a consistent `id` for the field error element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field error element from the given `id`
 */
function errorId(id) {
    return idGenerator(id, 'error');
}
/** Return a consistent `id` for the field examples element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field examples element from the given `id`
 */
function examplesId(id) {
    return idGenerator(id, 'examples');
}
/** Return a consistent `id` for the field help element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field help element from the given `id`
 */
function helpId(id) {
    return idGenerator(id, 'help');
}
/** Return a consistent `id` for the field title element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field title element from the given `id`
 */
function titleId(id) {
    return idGenerator(id, 'title');
}
/** Return a list of element ids that contain additional information about the field that can be used to as the aria
 * description of the field. This is correctly omitting `titleId` which would be "labeling" rather than "describing" the
 * element.
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @param [includeExamples=false] - Optional flag, if true, will add the `examplesId` into the list
 * @returns - The string containing the list of ids for use in an `aria-describedBy` attribute
 */
function ariaDescribedByIds(id, includeExamples = false) {
    const examples = includeExamples ? ` ${examplesId(id)}` : '';
    return `${errorId(id)} ${descriptionId(id)} ${helpId(id)}${examples}`;
}
/** Return a consistent `id` for the `optionIndex`s of a `Radio` or `Checkboxes` widget
 *
 * @param id - The id of the parent component for the option
 * @param optionIndex - The index of the option for which the id is desired
 * @returns - An id for the option index based on the parent `id`
 */
function optionId(id, optionIndex) {
    return `${id}-${optionIndex}`;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/index.js":
/*!***************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ADDITIONAL_PROPERTIES_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ADDITIONAL_PROPERTIES_KEY),
/* harmony export */   ADDITIONAL_PROPERTY_FLAG: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ADDITIONAL_PROPERTY_FLAG),
/* harmony export */   ALL_OF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ALL_OF_KEY),
/* harmony export */   ANY_OF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ANY_OF_KEY),
/* harmony export */   CONST_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.CONST_KEY),
/* harmony export */   DEFAULT_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.DEFAULT_KEY),
/* harmony export */   DEFINITIONS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.DEFINITIONS_KEY),
/* harmony export */   DEPENDENCIES_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.DEPENDENCIES_KEY),
/* harmony export */   ENUM_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ENUM_KEY),
/* harmony export */   ERRORS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ERRORS_KEY),
/* harmony export */   ErrorSchemaBuilder: () => (/* reexport safe */ _ErrorSchemaBuilder__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   ID_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ID_KEY),
/* harmony export */   IF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.IF_KEY),
/* harmony export */   ITEMS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ITEMS_KEY),
/* harmony export */   JUNK_OPTION_ID: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.JUNK_OPTION_ID),
/* harmony export */   NAME_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.NAME_KEY),
/* harmony export */   ONE_OF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ONE_OF_KEY),
/* harmony export */   PROPERTIES_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.PROPERTIES_KEY),
/* harmony export */   REF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.REF_KEY),
/* harmony export */   REQUIRED_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.REQUIRED_KEY),
/* harmony export */   RJSF_ADDITIONAL_PROPERTIES_FLAG: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.RJSF_ADDITIONAL_PROPERTIES_FLAG),
/* harmony export */   RJSF_ADDITONAL_PROPERTIES_FLAG: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.RJSF_ADDITONAL_PROPERTIES_FLAG),
/* harmony export */   ROOT_SCHEMA_PREFIX: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ROOT_SCHEMA_PREFIX),
/* harmony export */   SUBMIT_BTN_OPTIONS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.SUBMIT_BTN_OPTIONS_KEY),
/* harmony export */   TranslatableString: () => (/* reexport safe */ _enums__WEBPACK_IMPORTED_MODULE_55__.TranslatableString),
/* harmony export */   UI_FIELD_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.UI_FIELD_KEY),
/* harmony export */   UI_GLOBAL_OPTIONS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.UI_GLOBAL_OPTIONS_KEY),
/* harmony export */   UI_OPTIONS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.UI_OPTIONS_KEY),
/* harmony export */   UI_WIDGET_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.UI_WIDGET_KEY),
/* harmony export */   allowAdditionalItems: () => (/* reexport safe */ _allowAdditionalItems__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   ariaDescribedByIds: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.ariaDescribedByIds),
/* harmony export */   asNumber: () => (/* reexport safe */ _asNumber__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   canExpand: () => (/* reexport safe */ _canExpand__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   createErrorHandler: () => (/* reexport safe */ _createErrorHandler__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   createSchemaUtils: () => (/* reexport safe */ _createSchemaUtils__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   dataURItoBlob: () => (/* reexport safe */ _dataURItoBlob__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   dateRangeOptions: () => (/* reexport safe */ _dateRangeOptions__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   deepEquals: () => (/* reexport safe */ _deepEquals__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   descriptionId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.descriptionId),
/* harmony export */   englishStringTranslator: () => (/* reexport safe */ _englishStringTranslator__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   enumOptionsDeselectValue: () => (/* reexport safe */ _enumOptionsDeselectValue__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   enumOptionsIndexForValue: () => (/* reexport safe */ _enumOptionsIndexForValue__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   enumOptionsIsSelected: () => (/* reexport safe */ _enumOptionsIsSelected__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   enumOptionsSelectValue: () => (/* reexport safe */ _enumOptionsSelectValue__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   enumOptionsValueForIndex: () => (/* reexport safe */ _enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   errorId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.errorId),
/* harmony export */   examplesId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.examplesId),
/* harmony export */   findSchemaDefinition: () => (/* reexport safe */ _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   getClosestMatchingOption: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getClosestMatchingOption),
/* harmony export */   getDateElementProps: () => (/* reexport safe */ _getDateElementProps__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   getDefaultFormState: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getDefaultFormState),
/* harmony export */   getDiscriminatorFieldFromSchema: () => (/* reexport safe */ _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   getDisplayLabel: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getDisplayLabel),
/* harmony export */   getFirstMatchingOption: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getFirstMatchingOption),
/* harmony export */   getInputProps: () => (/* reexport safe */ _getInputProps__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   getMatchingOption: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getMatchingOption),
/* harmony export */   getOptionMatchingSimpleDiscriminator: () => (/* reexport safe */ _getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_53__["default"]),
/* harmony export */   getSchemaType: () => (/* reexport safe */ _getSchemaType__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   getSubmitButtonOptions: () => (/* reexport safe */ _getSubmitButtonOptions__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   getTemplate: () => (/* reexport safe */ _getTemplate__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   getUiOptions: () => (/* reexport safe */ _getUiOptions__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   getWidget: () => (/* reexport safe */ _getWidget__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   guessType: () => (/* reexport safe */ _guessType__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   hasWidget: () => (/* reexport safe */ _hasWidget__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   hashForSchema: () => (/* reexport safe */ _hashForSchema__WEBPACK_IMPORTED_MODULE_25__["default"]),
/* harmony export */   helpId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.helpId),
/* harmony export */   isConstant: () => (/* reexport safe */ _isConstant__WEBPACK_IMPORTED_MODULE_28__["default"]),
/* harmony export */   isCustomWidget: () => (/* reexport safe */ _isCustomWidget__WEBPACK_IMPORTED_MODULE_29__["default"]),
/* harmony export */   isFilesArray: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.isFilesArray),
/* harmony export */   isFixedItems: () => (/* reexport safe */ _isFixedItems__WEBPACK_IMPORTED_MODULE_30__["default"]),
/* harmony export */   isMultiSelect: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.isMultiSelect),
/* harmony export */   isObject: () => (/* reexport safe */ _isObject__WEBPACK_IMPORTED_MODULE_31__["default"]),
/* harmony export */   isSelect: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.isSelect),
/* harmony export */   labelValue: () => (/* reexport safe */ _labelValue__WEBPACK_IMPORTED_MODULE_32__["default"]),
/* harmony export */   localToUTC: () => (/* reexport safe */ _localToUTC__WEBPACK_IMPORTED_MODULE_33__["default"]),
/* harmony export */   mergeDefaultsWithFormData: () => (/* reexport safe */ _mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_34__["default"]),
/* harmony export */   mergeObjects: () => (/* reexport safe */ _mergeObjects__WEBPACK_IMPORTED_MODULE_35__["default"]),
/* harmony export */   mergeSchemas: () => (/* reexport safe */ _mergeSchemas__WEBPACK_IMPORTED_MODULE_36__["default"]),
/* harmony export */   mergeValidationData: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.mergeValidationData),
/* harmony export */   optionId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.optionId),
/* harmony export */   optionsList: () => (/* reexport safe */ _optionsList__WEBPACK_IMPORTED_MODULE_37__["default"]),
/* harmony export */   orderProperties: () => (/* reexport safe */ _orderProperties__WEBPACK_IMPORTED_MODULE_38__["default"]),
/* harmony export */   pad: () => (/* reexport safe */ _pad__WEBPACK_IMPORTED_MODULE_39__["default"]),
/* harmony export */   parseDateString: () => (/* reexport safe */ _parseDateString__WEBPACK_IMPORTED_MODULE_40__["default"]),
/* harmony export */   rangeSpec: () => (/* reexport safe */ _rangeSpec__WEBPACK_IMPORTED_MODULE_41__["default"]),
/* harmony export */   replaceStringParameters: () => (/* reexport safe */ _replaceStringParameters__WEBPACK_IMPORTED_MODULE_42__["default"]),
/* harmony export */   retrieveSchema: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.retrieveSchema),
/* harmony export */   sanitizeDataForNewSchema: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.sanitizeDataForNewSchema),
/* harmony export */   schemaParser: () => (/* reexport safe */ _parser__WEBPACK_IMPORTED_MODULE_57__.schemaParser),
/* harmony export */   schemaRequiresTrueValue: () => (/* reexport safe */ _schemaRequiresTrueValue__WEBPACK_IMPORTED_MODULE_43__["default"]),
/* harmony export */   shouldRender: () => (/* reexport safe */ _shouldRender__WEBPACK_IMPORTED_MODULE_44__["default"]),
/* harmony export */   titleId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.titleId),
/* harmony export */   toConstant: () => (/* reexport safe */ _toConstant__WEBPACK_IMPORTED_MODULE_45__["default"]),
/* harmony export */   toDateString: () => (/* reexport safe */ _toDateString__WEBPACK_IMPORTED_MODULE_46__["default"]),
/* harmony export */   toErrorList: () => (/* reexport safe */ _toErrorList__WEBPACK_IMPORTED_MODULE_47__["default"]),
/* harmony export */   toErrorSchema: () => (/* reexport safe */ _toErrorSchema__WEBPACK_IMPORTED_MODULE_48__["default"]),
/* harmony export */   toIdSchema: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.toIdSchema),
/* harmony export */   toPathSchema: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.toPathSchema),
/* harmony export */   unwrapErrorHandler: () => (/* reexport safe */ _unwrapErrorHandler__WEBPACK_IMPORTED_MODULE_49__["default"]),
/* harmony export */   utcToLocal: () => (/* reexport safe */ _utcToLocal__WEBPACK_IMPORTED_MODULE_50__["default"]),
/* harmony export */   validationDataMerge: () => (/* reexport safe */ _validationDataMerge__WEBPACK_IMPORTED_MODULE_51__["default"]),
/* harmony export */   withIdRefPrefix: () => (/* reexport safe */ _withIdRefPrefix__WEBPACK_IMPORTED_MODULE_52__["default"])
/* harmony export */ });
/* harmony import */ var _allowAdditionalItems__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./allowAdditionalItems */ "../../node_modules/@rjsf/utils/lib/allowAdditionalItems.js");
/* harmony import */ var _asNumber__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./asNumber */ "../../node_modules/@rjsf/utils/lib/asNumber.js");
/* harmony import */ var _canExpand__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./canExpand */ "../../node_modules/@rjsf/utils/lib/canExpand.js");
/* harmony import */ var _createErrorHandler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./createErrorHandler */ "../../node_modules/@rjsf/utils/lib/createErrorHandler.js");
/* harmony import */ var _createSchemaUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./createSchemaUtils */ "../../node_modules/@rjsf/utils/lib/createSchemaUtils.js");
/* harmony import */ var _dataURItoBlob__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dataURItoBlob */ "../../node_modules/@rjsf/utils/lib/dataURItoBlob.js");
/* harmony import */ var _dateRangeOptions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dateRangeOptions */ "../../node_modules/@rjsf/utils/lib/dateRangeOptions.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");
/* harmony import */ var _englishStringTranslator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./englishStringTranslator */ "../../node_modules/@rjsf/utils/lib/englishStringTranslator.js");
/* harmony import */ var _enumOptionsDeselectValue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./enumOptionsDeselectValue */ "../../node_modules/@rjsf/utils/lib/enumOptionsDeselectValue.js");
/* harmony import */ var _enumOptionsIndexForValue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./enumOptionsIndexForValue */ "../../node_modules/@rjsf/utils/lib/enumOptionsIndexForValue.js");
/* harmony import */ var _enumOptionsIsSelected__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./enumOptionsIsSelected */ "../../node_modules/@rjsf/utils/lib/enumOptionsIsSelected.js");
/* harmony import */ var _enumOptionsSelectValue__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./enumOptionsSelectValue */ "../../node_modules/@rjsf/utils/lib/enumOptionsSelectValue.js");
/* harmony import */ var _enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./enumOptionsValueForIndex */ "../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js");
/* harmony import */ var _ErrorSchemaBuilder__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./ErrorSchemaBuilder */ "../../node_modules/@rjsf/utils/lib/ErrorSchemaBuilder.js");
/* harmony import */ var _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./findSchemaDefinition */ "../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js");
/* harmony import */ var _getDateElementProps__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./getDateElementProps */ "../../node_modules/@rjsf/utils/lib/getDateElementProps.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _getInputProps__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./getInputProps */ "../../node_modules/@rjsf/utils/lib/getInputProps.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _getSubmitButtonOptions__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./getSubmitButtonOptions */ "../../node_modules/@rjsf/utils/lib/getSubmitButtonOptions.js");
/* harmony import */ var _getTemplate__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./getTemplate */ "../../node_modules/@rjsf/utils/lib/getTemplate.js");
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");
/* harmony import */ var _getWidget__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./getWidget */ "../../node_modules/@rjsf/utils/lib/getWidget.js");
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./guessType */ "../../node_modules/@rjsf/utils/lib/guessType.js");
/* harmony import */ var _hashForSchema__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./hashForSchema */ "../../node_modules/@rjsf/utils/lib/hashForSchema.js");
/* harmony import */ var _hasWidget__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./hasWidget */ "../../node_modules/@rjsf/utils/lib/hasWidget.js");
/* harmony import */ var _idGenerators__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./idGenerators */ "../../node_modules/@rjsf/utils/lib/idGenerators.js");
/* harmony import */ var _isConstant__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./isConstant */ "../../node_modules/@rjsf/utils/lib/isConstant.js");
/* harmony import */ var _isCustomWidget__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./isCustomWidget */ "../../node_modules/@rjsf/utils/lib/isCustomWidget.js");
/* harmony import */ var _isFixedItems__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./isFixedItems */ "../../node_modules/@rjsf/utils/lib/isFixedItems.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");
/* harmony import */ var _labelValue__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./labelValue */ "../../node_modules/@rjsf/utils/lib/labelValue.js");
/* harmony import */ var _localToUTC__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./localToUTC */ "../../node_modules/@rjsf/utils/lib/localToUTC.js");
/* harmony import */ var _mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./mergeDefaultsWithFormData */ "../../node_modules/@rjsf/utils/lib/mergeDefaultsWithFormData.js");
/* harmony import */ var _mergeObjects__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./mergeObjects */ "../../node_modules/@rjsf/utils/lib/mergeObjects.js");
/* harmony import */ var _mergeSchemas__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./mergeSchemas */ "../../node_modules/@rjsf/utils/lib/mergeSchemas.js");
/* harmony import */ var _optionsList__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./optionsList */ "../../node_modules/@rjsf/utils/lib/optionsList.js");
/* harmony import */ var _orderProperties__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./orderProperties */ "../../node_modules/@rjsf/utils/lib/orderProperties.js");
/* harmony import */ var _pad__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./pad */ "../../node_modules/@rjsf/utils/lib/pad.js");
/* harmony import */ var _parseDateString__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./parseDateString */ "../../node_modules/@rjsf/utils/lib/parseDateString.js");
/* harmony import */ var _rangeSpec__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./rangeSpec */ "../../node_modules/@rjsf/utils/lib/rangeSpec.js");
/* harmony import */ var _replaceStringParameters__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./replaceStringParameters */ "../../node_modules/@rjsf/utils/lib/replaceStringParameters.js");
/* harmony import */ var _schemaRequiresTrueValue__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./schemaRequiresTrueValue */ "../../node_modules/@rjsf/utils/lib/schemaRequiresTrueValue.js");
/* harmony import */ var _shouldRender__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./shouldRender */ "../../node_modules/@rjsf/utils/lib/shouldRender.js");
/* harmony import */ var _toConstant__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./toConstant */ "../../node_modules/@rjsf/utils/lib/toConstant.js");
/* harmony import */ var _toDateString__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./toDateString */ "../../node_modules/@rjsf/utils/lib/toDateString.js");
/* harmony import */ var _toErrorList__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./toErrorList */ "../../node_modules/@rjsf/utils/lib/toErrorList.js");
/* harmony import */ var _toErrorSchema__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./toErrorSchema */ "../../node_modules/@rjsf/utils/lib/toErrorSchema.js");
/* harmony import */ var _unwrapErrorHandler__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./unwrapErrorHandler */ "../../node_modules/@rjsf/utils/lib/unwrapErrorHandler.js");
/* harmony import */ var _utcToLocal__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./utcToLocal */ "../../node_modules/@rjsf/utils/lib/utcToLocal.js");
/* harmony import */ var _validationDataMerge__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./validationDataMerge */ "../../node_modules/@rjsf/utils/lib/validationDataMerge.js");
/* harmony import */ var _withIdRefPrefix__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./withIdRefPrefix */ "../../node_modules/@rjsf/utils/lib/withIdRefPrefix.js");
/* harmony import */ var _getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./getOptionMatchingSimpleDiscriminator */ "../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./types */ "../../node_modules/@rjsf/utils/lib/types.js");
/* harmony import */ var _enums__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./enums */ "../../node_modules/@rjsf/utils/lib/enums.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _parser__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./parser */ "../../node_modules/@rjsf/utils/lib/parser/index.js");
/* harmony import */ var _schema__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./schema */ "../../node_modules/@rjsf/utils/lib/schema/index.js");






























































/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/isConstant.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/isConstant.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isConstant)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");

/** This function checks if the given `schema` matches a single constant value. This happens when either the schema has
 * an `enum` array with a single value or there is a `const` defined.
 *
 * @param schema - The schema for a field
 * @returns - True if the `schema` has a single constant value, false otherwise
 */
function isConstant(schema) {
    return (Array.isArray(schema.enum) && schema.enum.length === 1) || _constants__WEBPACK_IMPORTED_MODULE_0__.CONST_KEY in schema;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/isCustomWidget.js":
/*!************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/isCustomWidget.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isCustomWidget)
/* harmony export */ });
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");

/** Checks to see if the `uiSchema` contains the `widget` field and that the widget is not `hidden`
 *
 * @param uiSchema - The UI Schema from which to detect if it is customized
 * @returns - True if the `uiSchema` describes a custom widget, false otherwise
 */
function isCustomWidget(uiSchema = {}) {
    return (
    // TODO: Remove the `&& uiSchema['ui:widget'] !== 'hidden'` once we support hidden widgets for arrays.
    // https://rjsf-team.github.io/react-jsonschema-form/docs/usage/widgets/#hidden-widgets
    'widget' in (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_0__["default"])(uiSchema) && (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_0__["default"])(uiSchema)['widget'] !== 'hidden');
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/isFixedItems.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/isFixedItems.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isFixedItems)
/* harmony export */ });
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");

/** Detects whether the given `schema` contains fixed items. This is the case when `schema.items` is a non-empty array
 * that only contains objects.
 *
 * @param schema - The schema in which to check for fixed items
 * @returns - True if there are fixed items in the schema, false otherwise
 */
function isFixedItems(schema) {
    return Array.isArray(schema.items) && schema.items.length > 0 && schema.items.every((item) => (0,_isObject__WEBPACK_IMPORTED_MODULE_0__["default"])(item));
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/isObject.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/isObject.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isObject)
/* harmony export */ });
/** Determines whether a `thing` is an object for the purposes of RSJF. In this case, `thing` is an object if it has
 * the type `object` but is NOT null, an array or a File.
 *
 * @param thing - The thing to check to see whether it is an object
 * @returns - True if it is a non-null, non-array, non-File object
 */
function isObject(thing) {
    if (typeof File !== 'undefined' && thing instanceof File) {
        return false;
    }
    if (typeof Date !== 'undefined' && thing instanceof Date) {
        return false;
    }
    return typeof thing === 'object' && thing !== null && !Array.isArray(thing);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/labelValue.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/labelValue.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ labelValue)
/* harmony export */ });
function labelValue(label, hideLabel, fallback) {
    return hideLabel ? fallback : label;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/localToUTC.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/localToUTC.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ localToUTC)
/* harmony export */ });
/** Converts a local Date string into a UTC date string
 *
 * @param dateString - The string representation of a date as accepted by the `Date()` constructor
 * @returns - A UTC date string if `dateString` is truthy, otherwise undefined
 */
function localToUTC(dateString) {
    return dateString ? new Date(dateString).toJSON() : undefined;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/mergeDefaultsWithFormData.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/mergeDefaultsWithFormData.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeDefaultsWithFormData)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");


/** Merges the `defaults` object of type `T` into the `formData` of type `T`
 *
 * When merging defaults and form data, we want to merge in this specific way:
 * - objects are deeply merged
 * - arrays are merged in such a way that:
 *   - when the array is set in form data, only array entries set in form data
 *     are deeply merged; additional entries from the defaults are ignored unless `mergeExtraArrayDefaults` is true, in
 *     which case the extras are appended onto the end of the form data
 *   - when the array is not set in form data, the default is copied over
 * - scalars are overwritten/set by form data
 *
 * @param [defaults] - The defaults to merge
 * @param [formData] - The form data into which the defaults will be merged
 * @param [mergeExtraArrayDefaults=false] - If true, any additional default array entries are appended onto the formData
 * @returns - The resulting merged form data with defaults
 */
function mergeDefaultsWithFormData(defaults, formData, mergeExtraArrayDefaults = false) {
    if (Array.isArray(formData)) {
        const defaultsArray = Array.isArray(defaults) ? defaults : [];
        const mapped = formData.map((value, idx) => {
            if (defaultsArray[idx]) {
                return mergeDefaultsWithFormData(defaultsArray[idx], value, mergeExtraArrayDefaults);
            }
            return value;
        });
        // Merge any extra defaults when mergeExtraArrayDefaults is true
        if (mergeExtraArrayDefaults && mapped.length < defaultsArray.length) {
            mapped.push(...defaultsArray.slice(mapped.length));
        }
        return mapped;
    }
    if ((0,_isObject__WEBPACK_IMPORTED_MODULE_1__["default"])(formData)) {
        const acc = Object.assign({}, defaults); // Prevent mutation of source object.
        return Object.keys(formData).reduce((acc, key) => {
            acc[key] = mergeDefaultsWithFormData(defaults ? lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(defaults, key) : {}, lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, key), mergeExtraArrayDefaults);
            return acc;
        }, acc);
    }
    return formData;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/mergeObjects.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/mergeObjects.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeObjects)
/* harmony export */ });
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");

/** Recursively merge deeply nested objects.
 *
 * @param obj1 - The first object to merge
 * @param obj2 - The second object to merge
 * @param [concatArrays=false] - Optional flag that, when true, will cause arrays to be concatenated. Use
 *          "preventDuplicates" to merge arrays in a manner that prevents any duplicate entries from being merged.
 *          NOTE: Uses shallow comparison for the duplicate checking.
 * @returns - A new object that is the merge of the two given objects
 */
function mergeObjects(obj1, obj2, concatArrays = false) {
    return Object.keys(obj2).reduce((acc, key) => {
        const left = obj1 ? obj1[key] : {}, right = obj2[key];
        if (obj1 && key in obj1 && (0,_isObject__WEBPACK_IMPORTED_MODULE_0__["default"])(right)) {
            acc[key] = mergeObjects(left, right, concatArrays);
        }
        else if (concatArrays && Array.isArray(left) && Array.isArray(right)) {
            let toMerge = right;
            if (concatArrays === 'preventDuplicates') {
                toMerge = right.reduce((result, value) => {
                    if (!left.includes(value)) {
                        result.push(value);
                    }
                    return result;
                }, []);
            }
            acc[key] = left.concat(toMerge);
        }
        else {
            acc[key] = right;
        }
        return acc;
    }, Object.assign({}, obj1)); // Prevent mutation of source object.
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/mergeSchemas.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/mergeSchemas.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeSchemas)
/* harmony export */ });
/* harmony import */ var lodash_union__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/union */ "../../node_modules/lodash/union.js");
/* harmony import */ var lodash_union__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_union__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");




/** Recursively merge deeply nested schemas. The difference between `mergeSchemas` and `mergeObjects` is that
 * `mergeSchemas` only concats arrays for values under the 'required' keyword, and when it does, it doesn't include
 * duplicate values.
 *
 * @param obj1 - The first schema object to merge
 * @param obj2 - The second schema object to merge
 * @returns - The merged schema object
 */
function mergeSchemas(obj1, obj2) {
    const acc = Object.assign({}, obj1); // Prevent mutation of source object.
    return Object.keys(obj2).reduce((acc, key) => {
        const left = obj1 ? obj1[key] : {}, right = obj2[key];
        if (obj1 && key in obj1 && (0,_isObject__WEBPACK_IMPORTED_MODULE_3__["default"])(right)) {
            acc[key] = mergeSchemas(left, right);
        }
        else if (obj1 &&
            obj2 &&
            ((0,_getSchemaType__WEBPACK_IMPORTED_MODULE_2__["default"])(obj1) === 'object' || (0,_getSchemaType__WEBPACK_IMPORTED_MODULE_2__["default"])(obj2) === 'object') &&
            key === _constants__WEBPACK_IMPORTED_MODULE_1__.REQUIRED_KEY &&
            Array.isArray(left) &&
            Array.isArray(right)) {
            // Don't include duplicate values when merging 'required' fields.
            acc[key] = lodash_union__WEBPACK_IMPORTED_MODULE_0___default()(left, right);
        }
        else {
            acc[key] = right;
        }
        return acc;
    }, acc);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/optionsList.js":
/*!*********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/optionsList.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ optionsList)
/* harmony export */ });
/* harmony import */ var _toConstant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./toConstant */ "../../node_modules/@rjsf/utils/lib/toConstant.js");
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");


/** Gets the list of options from the `schema`. If the schema has an enum list, then those enum values are returned. The
 * labels for the options will be extracted from the non-standard, RJSF-deprecated `enumNames` if it exists, otherwise
 * the label will be the same as the `value`. If the schema has a `oneOf` or `anyOf`, then the value is the list of
 * `const` values from the schema and the label is either the `schema.title` or the value. If a `uiSchema` is provided
 * and it has the `ui:enumNames` matched with `enum` or it has an associated `oneOf` or `anyOf` with a list of objects
 * containing `ui:title` then the UI schema values will replace the values from the schema.
 *
 * @param schema - The schema from which to extract the options list
 * @param [uiSchema] - The optional uiSchema from which to get alternate labels for the options
 * @returns - The list of options from the schema
 */
function optionsList(schema, uiSchema) {
    // TODO flip generics to move T first in v6
    const schemaWithEnumNames = schema;
    if (schema.enum) {
        let enumNames;
        if (uiSchema) {
            const { enumNames: uiEnumNames } = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_1__["default"])(uiSchema);
            enumNames = uiEnumNames;
        }
        if (!enumNames && schemaWithEnumNames.enumNames) {
            // enumNames was deprecated in v5 and is intentionally omitted from the RJSFSchema type.
            // Cast the type to include enumNames so the feature still works.
            if (true) {
                console.warn('The "enumNames" property in the schema is deprecated and will be removed in a future major release. Use the "ui:enumNames" property in the uiSchema instead.');
            }
            enumNames = schemaWithEnumNames.enumNames;
        }
        return schema.enum.map((value, i) => {
            const label = (enumNames === null || enumNames === void 0 ? void 0 : enumNames[i]) || String(value);
            return { label, value };
        });
    }
    let altSchemas = undefined;
    let altUiSchemas = undefined;
    if (schema.anyOf) {
        altSchemas = schema.anyOf;
        altUiSchemas = uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema.anyOf;
    }
    else if (schema.oneOf) {
        altSchemas = schema.oneOf;
        altUiSchemas = uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema.oneOf;
    }
    return (altSchemas &&
        altSchemas.map((aSchemaDef, index) => {
            const { title } = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_1__["default"])(altUiSchemas === null || altUiSchemas === void 0 ? void 0 : altUiSchemas[index]);
            const aSchema = aSchemaDef;
            const value = (0,_toConstant__WEBPACK_IMPORTED_MODULE_0__["default"])(aSchema);
            const label = title || aSchema.title || String(value);
            return {
                schema: aSchema,
                label,
                value,
            };
        }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/orderProperties.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/orderProperties.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ orderProperties)
/* harmony export */ });
/** Given a list of `properties` and an `order` list, returns a list that contains the `properties` ordered correctly.
 * If `order` is not an array, then the untouched `properties` list is returned. Otherwise `properties` is ordered per
 * the `order` list. If `order` contains a '*' then any `properties` that are not mentioned explicity in `order` will be
 * places in the location of the `*`.
 *
 * @param properties - The list of property keys to be ordered
 * @param order - An array of property keys to be ordered first, with an optional '*' property
 * @returns - A list with the `properties` ordered
 * @throws - Error when the properties cannot be ordered correctly
 */
function orderProperties(properties, order) {
    if (!Array.isArray(order)) {
        return properties;
    }
    const arrayToHash = (arr) => arr.reduce((prev, curr) => {
        prev[curr] = true;
        return prev;
    }, {});
    const errorPropList = (arr) => arr.length > 1 ? `properties '${arr.join("', '")}'` : `property '${arr[0]}'`;
    const propertyHash = arrayToHash(properties);
    const orderFiltered = order.filter((prop) => prop === '*' || propertyHash[prop]);
    const orderHash = arrayToHash(orderFiltered);
    const rest = properties.filter((prop) => !orderHash[prop]);
    const restIndex = orderFiltered.indexOf('*');
    if (restIndex === -1) {
        if (rest.length) {
            throw new Error(`uiSchema order list does not contain ${errorPropList(rest)}`);
        }
        return orderFiltered;
    }
    if (restIndex !== orderFiltered.lastIndexOf('*')) {
        throw new Error('uiSchema order list contains more than one wildcard item');
    }
    const complete = [...orderFiltered];
    complete.splice(restIndex, 1, ...rest);
    return complete;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/pad.js":
/*!*************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/pad.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ pad)
/* harmony export */ });
/** Returns a string representation of the `num` that is padded with leading "0"s if necessary
 *
 * @param num - The number to pad
 * @param width - The width of the string at which no lead padding is necessary
 * @returns - The number converted to a string with leading zero padding if the number of digits is less than `width`
 */
function pad(num, width) {
    let s = String(num);
    while (s.length < width) {
        s = '0' + s;
    }
    return s;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/parseDateString.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/parseDateString.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ parseDateString)
/* harmony export */ });
/** Parses the `dateString` into a `DateObject`, including the time information when `includeTime` is true
 *
 * @param dateString - The date string to parse into a DateObject
 * @param [includeTime=true] - Optional flag, if false, will not include the time data into the object
 * @returns - The date string converted to a `DateObject`
 * @throws - Error when the date cannot be parsed from the string
 */
function parseDateString(dateString, includeTime = true) {
    if (!dateString) {
        return {
            year: -1,
            month: -1,
            day: -1,
            hour: includeTime ? -1 : 0,
            minute: includeTime ? -1 : 0,
            second: includeTime ? -1 : 0,
        };
    }
    const date = new Date(dateString);
    if (Number.isNaN(date.getTime())) {
        throw new Error('Unable to parse date ' + dateString);
    }
    return {
        year: date.getUTCFullYear(),
        month: date.getUTCMonth() + 1,
        day: date.getUTCDate(),
        hour: includeTime ? date.getUTCHours() : 0,
        minute: includeTime ? date.getUTCMinutes() : 0,
        second: includeTime ? date.getUTCSeconds() : 0,
    };
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/parser/ParserValidator.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/parser/ParserValidator.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ParserValidator)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _hashForSchema__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../hashForSchema */ "../../node_modules/@rjsf/utils/lib/hashForSchema.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");




/** An implementation of the `ValidatorType` interface that is designed for use in capturing schemas used by the
 * `isValid()` function. The rest of the implementation of the interface throws errors when it is attempted to be used.
 * An instance of the object allows the caller to capture the schemas used in calls to the `isValid()` function. These
 * captured schema, along with the root schema used to construct the object are stored in the map of schemas keyed by
 * the hashed value of the schema. NOTE: After hashing the schema, an $id with the hash value is added to the
 * schema IF that schema doesn't already have an $id, prior to putting the schema into the map.
 */
class ParserValidator {
    /** Construct the ParserValidator for the given `rootSchema`. This `rootSchema` will be stashed in the `schemaMap`
     * first.
     *
     * @param rootSchema - The root schema against which this validator will be executed
     */
    constructor(rootSchema) {
        /** The map of schemas encountered by the ParserValidator */
        this.schemaMap = {};
        this.rootSchema = rootSchema;
        this.addSchema(rootSchema, (0,_hashForSchema__WEBPACK_IMPORTED_MODULE_2__["default"])(rootSchema));
    }
    /** Resets the internal AJV validator to clear schemas from it. Can be helpful for resetting the validator for tests.
     */
    reset() {
        this.schemaMap = {};
    }
    /** Adds the given `schema` to the `schemaMap` keyed by the `hash` or `ID_KEY` if present on the `schema`. If the
     * schema does not have an `ID_KEY`, then the `hash` will be added as the `ID_KEY` to allow the schema to be
     * associated with it's `hash` for future use (by a schema compiler).
     *
     * @param schema - The schema which is to be added to the map
     * @param hash - The hash value at which to map the schema
     */
    addSchema(schema, hash) {
        const key = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, _constants__WEBPACK_IMPORTED_MODULE_1__.ID_KEY, hash);
        const identifiedSchema = { ...schema, [_constants__WEBPACK_IMPORTED_MODULE_1__.ID_KEY]: key };
        const existing = this.schemaMap[key];
        if (!existing) {
            this.schemaMap[key] = identifiedSchema;
        }
        else if (!(0,_deepEquals__WEBPACK_IMPORTED_MODULE_3__["default"])(existing, identifiedSchema)) {
            console.error('existing schema:', JSON.stringify(existing, null, 2));
            console.error('new schema:', JSON.stringify(identifiedSchema, null, 2));
            throw new Error(`Two different schemas exist with the same key ${key}! What a bad coincidence. If possible, try adding an $id to one of the schemas`);
        }
    }
    /** Returns the current `schemaMap` to the caller
     */
    getSchemaMap() {
        return this.schemaMap;
    }
    /** Implements the `ValidatorType` `isValid()` method to capture the `schema` in the `schemaMap`. Throws an error when
     * the `rootSchema` is not the same as the root schema provided during construction.
     *
     * @param schema - The schema to record in the `schemaMap`
     * @param _formData - The formData parameter that is ignored
     * @param rootSchema - The root schema associated with the schema
     * @throws - Error when the given `rootSchema` differs from the root schema provided during construction
     */
    isValid(schema, _formData, rootSchema) {
        if (!(0,_deepEquals__WEBPACK_IMPORTED_MODULE_3__["default"])(rootSchema, this.rootSchema)) {
            throw new Error('Unexpectedly calling isValid() with a rootSchema that differs from the construction rootSchema');
        }
        this.addSchema(schema, (0,_hashForSchema__WEBPACK_IMPORTED_MODULE_2__["default"])(schema));
        return false;
    }
    /** Implements the `ValidatorType` `rawValidation()` method to throw an error since it is never supposed to be called
     *
     * @param _schema - The schema parameter that is ignored
     * @param _formData - The formData parameter that is ignored
     */
    rawValidation(_schema, _formData) {
        throw new Error('Unexpectedly calling the `rawValidation()` method during schema parsing');
    }
    /** Implements the `ValidatorType` `toErrorList()` method to throw an error since it is never supposed to be called
     *
     * @param _errorSchema - The error schema parameter that is ignored
     * @param _fieldPath - The field path parameter that is ignored
     */
    toErrorList(_errorSchema, _fieldPath) {
        throw new Error('Unexpectedly calling the `toErrorList()` method during schema parsing');
    }
    /** Implements the `ValidatorType` `validateFormData()` method to throw an error since it is never supposed to be
     * called
     *
     * @param _formData - The formData parameter that is ignored
     * @param _schema - The schema parameter that is ignored
     * @param _customValidate - The customValidate parameter that is ignored
     * @param _transformErrors - The transformErrors parameter that is ignored
     * @param _uiSchema - The uiSchema parameter that is ignored
     */
    validateFormData(_formData, _schema, _customValidate, _transformErrors, _uiSchema) {
        throw new Error('Unexpectedly calling the `validateFormData()` method during schema parsing');
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/parser/index.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/parser/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   schemaParser: () => (/* reexport safe */ _schemaParser__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _schemaParser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./schemaParser */ "../../node_modules/@rjsf/utils/lib/parser/schemaParser.js");




/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/parser/schemaParser.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/parser/schemaParser.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ schemaParser)
/* harmony export */ });
/* harmony import */ var lodash_forEach__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/forEach */ "../../node_modules/lodash/forEach.js");
/* harmony import */ var lodash_forEach__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_forEach__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _ParserValidator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParserValidator */ "../../node_modules/@rjsf/utils/lib/parser/ParserValidator.js");
/* harmony import */ var _schema_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../schema/retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");





/** Recursive function used to parse the given `schema` belonging to the `rootSchema`. The `validator` is used to
 * capture the sub-schemas that the `isValid()` function is called with. For each schema returned by the
 * `retrieveSchemaInternal()`, the `resolveAnyOrOneOfSchemas()` function is called. For each of the schemas returned
 * from THAT call have `properties`, then each of the sub-schema property objects are then recursively parsed.
 *
 * @param validator - The `ParserValidator` implementation used to capture `isValid()` calls during parsing
 * @param recurseList - The list of schemas returned from the `retrieveSchemaInternal`, preventing infinite recursion
 * @param rootSchema - The root schema from which the schema parsing began
 * @param schema - The current schema element being parsed
 */
function parseSchema(validator, recurseList, rootSchema, schema) {
    const schemas = (0,_schema_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__.retrieveSchemaInternal)(validator, schema, rootSchema, undefined, true);
    schemas.forEach((schema) => {
        const sameSchemaIndex = recurseList.findIndex((item) => (0,_deepEquals__WEBPACK_IMPORTED_MODULE_4__["default"])(item, schema));
        if (sameSchemaIndex === -1) {
            recurseList.push(schema);
            const allOptions = (0,_schema_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__.resolveAnyOrOneOfSchemas)(validator, schema, rootSchema, true);
            allOptions.forEach((s) => {
                if (_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY in s && s[_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY]) {
                    lodash_forEach__WEBPACK_IMPORTED_MODULE_0___default()(schema[_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY], (value) => {
                        parseSchema(validator, recurseList, rootSchema, value);
                    });
                }
            });
            if (_constants__WEBPACK_IMPORTED_MODULE_1__.ITEMS_KEY in schema && !Array.isArray(schema.items) && typeof schema.items !== 'boolean') {
                parseSchema(validator, recurseList, rootSchema, schema.items);
            }
        }
    });
}
/** Parses the given `rootSchema` to extract out all the sub-schemas that maybe contained within it. Returns a map of
 * the hash of the schema to schema/sub-schema.
 *
 * @param rootSchema - The root schema to parse for sub-schemas used by `isValid()` calls
 * @returns - The `SchemaMap` of all schemas that were parsed
 */
function schemaParser(rootSchema) {
    const validator = new _ParserValidator__WEBPACK_IMPORTED_MODULE_2__["default"](rootSchema);
    const recurseList = [];
    parseSchema(validator, recurseList, rootSchema, rootSchema);
    return validator.getSchemaMap();
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/rangeSpec.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/rangeSpec.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ rangeSpec)
/* harmony export */ });
/** Extracts the range spec information `{ step?: number, min?: number, max?: number }` that can be spread onto an HTML
 * input from the range analog in the schema `{ multipleOf?: number, minimum?: number, maximum?: number }`.
 *
 * @param schema - The schema from which to extract the range spec
 * @returns - A range specification from the schema
 */
function rangeSpec(schema) {
    const spec = {};
    if (schema.multipleOf) {
        spec.step = schema.multipleOf;
    }
    if (schema.minimum || schema.minimum === 0) {
        spec.min = schema.minimum;
    }
    if (schema.maximum || schema.maximum === 0) {
        spec.max = schema.maximum;
    }
    return spec;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/replaceStringParameters.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/replaceStringParameters.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ replaceStringParameters)
/* harmony export */ });
/** Potentially substitutes all replaceable parameters with the associated value(s) from the `params` if available. When
 * a `params` array is provided, each value in the array is used to replace any of the replaceable parameters in the
 * `inputString` using the `%1`, `%2`, etc. replacement specifiers.
 *
 * @param inputString - The string which will be potentially updated with replacement parameters
 * @param params - The optional list of replaceable parameter values to substitute into the english string
 * @returns - The updated string with any replacement specifiers replaced
 */
function replaceStringParameters(inputString, params) {
    let output = inputString;
    if (Array.isArray(params)) {
        const parts = output.split(/(%\d)/);
        params.forEach((param, index) => {
            const partIndex = parts.findIndex((part) => part === `%${index + 1}`);
            if (partIndex >= 0) {
                parts[partIndex] = param;
            }
        });
        output = parts.join('');
    }
    return output;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JUNK_OPTION: () => (/* binding */ JUNK_OPTION),
/* harmony export */   calculateIndexScore: () => (/* binding */ calculateIndexScore),
/* harmony export */   "default": () => (/* binding */ getClosestMatchingOption)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/has */ "../../node_modules/lodash/has.js");
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_has__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isNumber */ "../../node_modules/lodash/isNumber.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isNumber__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/isString */ "../../node_modules/lodash/isString.js");
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_isString__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_reduce__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/reduce */ "../../node_modules/lodash/reduce.js");
/* harmony import */ var lodash_reduce__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_reduce__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/times */ "../../node_modules/lodash/times.js");
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_times__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./getFirstMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../guessType */ "../../node_modules/@rjsf/utils/lib/guessType.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../getOptionMatchingSimpleDiscriminator */ "../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js");













/** A junk option used to determine when the getFirstMatchingOption call really matches an option rather than returning
 * the first item
 */
const JUNK_OPTION = {
    type: 'object',
    $id: _constants__WEBPACK_IMPORTED_MODULE_9__.JUNK_OPTION_ID,
    properties: {
        __not_really_there__: {
            type: 'number',
        },
    },
};
/** Recursive function that calculates the score of a `formData` against the given `schema`. The computation is fairly
 * simple. Initially the total score is 0. When `schema.properties` object exists, then all the `key/value` pairs within
 * the object are processed as follows after obtaining the formValue from `formData` using the `key`:
 * - If the `value` contains a `$ref`, `calculateIndexScore()` is called recursively with the formValue and the new
 *   schema that is the result of the ref in the schema being resolved and that sub-schema's resulting score is added to
 *   the total.
 * - If the `value` contains a `oneOf` and there is a formValue, then score based on the index returned from calling
 *   `getClosestMatchingOption()` of that oneOf.
 * - If the type of the `value` is 'object', `calculateIndexScore()` is called recursively with the formValue and the
 *   `value` itself as the sub-schema, and the score is added to the total.
 * - If the type of the `value` matches the guessed-type of the `formValue`, the score is incremented by 1, UNLESS the
 *   value has a `default` or `const`. In those case, if the `default` or `const` and the `formValue` match, the score
 *   is incremented by another 1 otherwise it is decremented by 1.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param rootSchema - The root JSON schema of the entire form
 * @param schema - The schema for which the score is being calculated
 * @param formData - The form data associated with the schema, used to calculate the score
 * @returns - The score a schema against the formData
 */
function calculateIndexScore(validator, rootSchema, schema, formData = {}) {
    let totalScore = 0;
    if (schema) {
        if (lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default()(schema.properties)) {
            totalScore += lodash_reduce__WEBPACK_IMPORTED_MODULE_5___default()(schema.properties, (score, value, key) => {
                const formValue = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, key);
                if (typeof value === 'boolean') {
                    return score;
                }
                if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(value, _constants__WEBPACK_IMPORTED_MODULE_9__.REF_KEY)) {
                    const newSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_8__["default"])(validator, value, rootSchema, formValue);
                    return score + calculateIndexScore(validator, rootSchema, newSchema, formValue || {});
                }
                if ((lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(value, _constants__WEBPACK_IMPORTED_MODULE_9__.ONE_OF_KEY) || lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(value, _constants__WEBPACK_IMPORTED_MODULE_9__.ANY_OF_KEY)) && formValue) {
                    const key = lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(value, _constants__WEBPACK_IMPORTED_MODULE_9__.ONE_OF_KEY) ? _constants__WEBPACK_IMPORTED_MODULE_9__.ONE_OF_KEY : _constants__WEBPACK_IMPORTED_MODULE_9__.ANY_OF_KEY;
                    const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_11__["default"])(value);
                    return (score +
                        getClosestMatchingOption(validator, rootSchema, formValue, lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(value, key), -1, discriminator));
                }
                if (value.type === 'object') {
                    return score + calculateIndexScore(validator, rootSchema, value, formValue || {});
                }
                if (value.type === (0,_guessType__WEBPACK_IMPORTED_MODULE_10__["default"])(formValue)) {
                    // If the types match, then we bump the score by one
                    let newScore = score + 1;
                    if (value.default) {
                        // If the schema contains a readonly default value score the value that matches the default higher and
                        // any non-matching value lower
                        newScore += formValue === value.default ? 1 : -1;
                    }
                    else if (value.const) {
                        // If the schema contains a const value score the value that matches the default higher and
                        // any non-matching value lower
                        newScore += formValue === value.const ? 1 : -1;
                    }
                    // TODO eventually, deal with enums/arrays
                    return newScore;
                }
                return score;
            }, 0);
        }
        else if (lodash_isString__WEBPACK_IMPORTED_MODULE_4___default()(schema.type) && schema.type === (0,_guessType__WEBPACK_IMPORTED_MODULE_10__["default"])(formData)) {
            totalScore += 1;
        }
    }
    return totalScore;
}
/** Determines which of the given `options` provided most closely matches the `formData`. Using
 * `getFirstMatchingOption()` to match two schemas that differ only by the readOnly, default or const value of a field
 * based on the `formData` and returns 0 when there is no match. Rather than passing in all the `options` at once to
 * this utility, instead an array of valid option indexes is created by iterating over the list of options, call
 * `getFirstMatchingOptions` with a list of one junk option and one good option, seeing if the good option is considered
 * matched.
 *
 * Once the list of valid indexes is created, if there is only one valid index, just return it. Otherwise, if there are
 * no valid indexes, then fill the valid indexes array with the indexes of all the options. Next, the index of the
 * option with the highest score is determined by iterating over the list of valid options, calling
 * `calculateIndexScore()` on each, comparing it against the current best score, and returning the index of the one that
 * eventually has the best score.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param rootSchema - The root JSON schema of the entire form
 * @param formData - The form data associated with the schema
 * @param options - The list of options that can be selected from
 * @param [selectedOption=-1] - The index of the currently selected option, defaulted to -1 if not specified
 * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
 *          determine which option is selected
 * @returns - The index of the option that is the closest match to the `formData` or the `selectedOption` if no match
 */
function getClosestMatchingOption(validator, rootSchema, formData, options, selectedOption = -1, discriminatorField) {
    // First resolve any refs in the options
    const resolvedOptions = options.map((option) => {
        return (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_8__.resolveAllReferences)(option, rootSchema, []);
    });
    const simpleDiscriminatorMatch = (0,_getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_12__["default"])(formData, options, discriminatorField);
    if (lodash_isNumber__WEBPACK_IMPORTED_MODULE_2___default()(simpleDiscriminatorMatch)) {
        return simpleDiscriminatorMatch;
    }
    // Reduce the array of options down to a list of the indexes that are considered matching options
    const allValidIndexes = resolvedOptions.reduce((validList, option, index) => {
        const testOptions = [JUNK_OPTION, option];
        const match = (0,_getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_7__["default"])(validator, formData, testOptions, rootSchema, discriminatorField);
        // The match is the real option, so add its index to list of valid indexes
        if (match === 1) {
            validList.push(index);
        }
        return validList;
    }, []);
    // There is only one valid index, so return it!
    if (allValidIndexes.length === 1) {
        return allValidIndexes[0];
    }
    if (!allValidIndexes.length) {
        // No indexes were valid, so we'll score all the options, add all the indexes
        lodash_times__WEBPACK_IMPORTED_MODULE_6___default()(resolvedOptions.length, (i) => allValidIndexes.push(i));
    }
    const scoreCount = new Set();
    // Score all the options in the list of valid indexes and return the index with the best score
    const { bestIndex } = allValidIndexes.reduce((scoreData, index) => {
        const { bestScore } = scoreData;
        const option = resolvedOptions[index];
        const score = calculateIndexScore(validator, rootSchema, option, formData);
        scoreCount.add(score);
        if (score > bestScore) {
            return { bestIndex: index, bestScore: score };
        }
        return scoreData;
    }, { bestIndex: selectedOption, bestScore: 0 });
    // if all scores are the same go with selectedOption
    if (scoreCount.size === 1 && selectedOption >= 0) {
        return selectedOption;
    }
    return bestIndex;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getDefaultFormState.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getDefaultFormState.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdditionalItemsHandling: () => (/* binding */ AdditionalItemsHandling),
/* harmony export */   computeDefaults: () => (/* binding */ computeDefaults),
/* harmony export */   "default": () => (/* binding */ getDefaultFormState),
/* harmony export */   getArrayDefaults: () => (/* binding */ getArrayDefaults),
/* harmony export */   getDefaultBasedOnSchemaType: () => (/* binding */ getDefaultBasedOnSchemaType),
/* harmony export */   getInnerSchemaForArrayItem: () => (/* binding */ getInnerSchemaForArrayItem),
/* harmony export */   getObjectDefaults: () => (/* binding */ getObjectDefaults)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../findSchemaDefinition */ "../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js");
/* harmony import */ var _getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getClosestMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");
/* harmony import */ var _isFixedItems__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../isFixedItems */ "../../node_modules/@rjsf/utils/lib/isFixedItems.js");
/* harmony import */ var _mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../mergeDefaultsWithFormData */ "../../node_modules/@rjsf/utils/lib/mergeDefaultsWithFormData.js");
/* harmony import */ var _mergeObjects__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../mergeObjects */ "../../node_modules/@rjsf/utils/lib/mergeObjects.js");
/* harmony import */ var _mergeSchemas__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../mergeSchemas */ "../../node_modules/@rjsf/utils/lib/mergeSchemas.js");
/* harmony import */ var _isMultiSelect__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isMultiSelect */ "../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");














/** Enum that indicates how `schema.additionalItems` should be handled by the `getInnerSchemaForArrayItem()` function.
 */
var AdditionalItemsHandling;
(function (AdditionalItemsHandling) {
    AdditionalItemsHandling[AdditionalItemsHandling["Ignore"] = 0] = "Ignore";
    AdditionalItemsHandling[AdditionalItemsHandling["Invert"] = 1] = "Invert";
    AdditionalItemsHandling[AdditionalItemsHandling["Fallback"] = 2] = "Fallback";
})(AdditionalItemsHandling || (AdditionalItemsHandling = {}));
/** Given a `schema` will return an inner schema that for an array item. This is computed differently based on the
 * `additionalItems` enum and the value of `idx`. There are four possible returns:
 * 1. If `idx` is >= 0, then if `schema.items` is an array the `idx`th element of the array is returned if it is a valid
 *    index and not a boolean, otherwise it falls through to 3.
 * 2. If `schema.items` is not an array AND truthy and not a boolean, then `schema.items` is returned since it actually
 *    is a schema, otherwise it falls through to 3.
 * 3. If `additionalItems` is not `AdditionalItemsHandling.Ignore` and `schema.additionalItems` is an object, then
 *    `schema.additionalItems` is returned since it actually is a schema, otherwise it falls through to 4.
 * 4. {} is returned representing an empty schema
 *
 * @param schema - The schema from which to get the particular item
 * @param [additionalItems=AdditionalItemsHandling.Ignore] - How do we want to handle additional items?
 * @param [idx=-1] - Index, if non-negative, will be used to return the idx-th element in a `schema.items` array
 * @returns - The best fit schema object from the `schema` given the `additionalItems` and `idx` modifiers
 */
function getInnerSchemaForArrayItem(schema, additionalItems = AdditionalItemsHandling.Ignore, idx = -1) {
    if (idx >= 0) {
        if (Array.isArray(schema.items) && idx < schema.items.length) {
            const item = schema.items[idx];
            if (typeof item !== 'boolean') {
                return item;
            }
        }
    }
    else if (schema.items && !Array.isArray(schema.items) && typeof schema.items !== 'boolean') {
        return schema.items;
    }
    if (additionalItems !== AdditionalItemsHandling.Ignore && (0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(schema.additionalItems)) {
        return schema.additionalItems;
    }
    return {};
}
/** Either add `computedDefault` at `key` into `obj` or not add it based on its value, the value of
 * `includeUndefinedValues`, the value of `emptyObjectFields` and if its parent field is required. Generally undefined
 * `computedDefault` values are added only when `includeUndefinedValues` is either true/"excludeObjectChildren". If `
 * includeUndefinedValues` is false and `emptyObjectFields` is not "skipDefaults", then non-undefined and non-empty-object
 * values will be added based on certain conditions.
 *
 * @param obj - The object into which the computed default may be added
 * @param key - The key into the object at which the computed default may be added
 * @param computedDefault - The computed default value that maybe should be added to the obj
 * @param includeUndefinedValues - Optional flag, if true, cause undefined values to be added as defaults.
 *          If "excludeObjectChildren", cause undefined values for this object and pass `includeUndefinedValues` as
 *          false when computing defaults for any nested object properties. If "allowEmptyObject", prevents undefined
 *          values in this object while allow the object itself to be empty and passing `includeUndefinedValues` as
 *          false when computing defaults for any nested object properties.
 * @param isParentRequired - The optional boolean that indicates whether the parent field is required
 * @param requiredFields - The list of fields that are required
 * @param experimental_defaultFormStateBehavior - Optional configuration object, if provided, allows users to override
 *        default form state behavior
 */
function maybeAddDefaultToObject(obj, key, computedDefault, includeUndefinedValues, isParentRequired, requiredFields = [], experimental_defaultFormStateBehavior = {}) {
    const { emptyObjectFields = 'populateAllDefaults' } = experimental_defaultFormStateBehavior;
    if (includeUndefinedValues) {
        obj[key] = computedDefault;
    }
    else if (emptyObjectFields !== 'skipDefaults') {
        if ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(computedDefault)) {
            // If isParentRequired is undefined, then we are at the root level of the schema so defer to the requiredness of
            // the field key itself in the `requiredField` list
            const isSelfOrParentRequired = isParentRequired === undefined ? requiredFields.includes(key) : isParentRequired;
            // If emptyObjectFields 'skipEmptyDefaults' store computedDefault if it's a non-empty object(e.g. not {})
            if (emptyObjectFields === 'skipEmptyDefaults') {
                if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default()(computedDefault)) {
                    obj[key] = computedDefault;
                }
            }
            // Else store computedDefault if it's a non-empty object(e.g. not {}) and satisfies certain conditions
            // Condition 1: If computedDefault is not empty or if the key is a required field
            // Condition 2: If the parent object is required or emptyObjectFields is not 'populateRequiredDefaults'
            else if ((!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default()(computedDefault) || requiredFields.includes(key)) &&
                (isSelfOrParentRequired || emptyObjectFields !== 'populateRequiredDefaults')) {
                obj[key] = computedDefault;
            }
        }
        else if (
        // Store computedDefault if it's a defined primitive (e.g., true) and satisfies certain conditions
        // Condition 1: computedDefault is not undefined
        // Condition 2: If emptyObjectFields is 'populateAllDefaults' or 'skipEmptyDefaults) or if the key is a required field
        computedDefault !== undefined &&
            (emptyObjectFields === 'populateAllDefaults' ||
                emptyObjectFields === 'skipEmptyDefaults' ||
                requiredFields.includes(key))) {
            obj[key] = computedDefault;
        }
    }
}
/** Computes the defaults for the current `schema` given the `rawFormData` and `parentDefaults` if any. This drills into
 * each level of the schema, recursively, to fill out every level of defaults provided by the schema.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be used when necessary
 * @param rawSchema - The schema for which the default state is desired
 * @param {ComputeDefaultsProps} computeDefaultsProps - Optional props for this function
 * @returns - The resulting `formData` with all the defaults provided
 */
function computeDefaults(validator, rawSchema, computeDefaultsProps = {}) {
    const { parentDefaults, rawFormData, rootSchema = {}, includeUndefinedValues = false, _recurseList = [], experimental_defaultFormStateBehavior = undefined, required, } = computeDefaultsProps;
    const formData = ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(rawFormData) ? rawFormData : {});
    const schema = (0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(rawSchema) ? rawSchema : {};
    // Compute the defaults recursively: give highest priority to deepest nodes.
    let defaults = parentDefaults;
    // If we get a new schema, then we need to recompute defaults again for the new schema found.
    let schemaToCompute = null;
    let updatedRecurseList = _recurseList;
    if ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(defaults) && (0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(schema.default)) {
        // For object defaults, only override parent defaults that are defined in
        // schema.default.
        defaults = (0,_mergeObjects__WEBPACK_IMPORTED_MODULE_10__["default"])(defaults, schema.default);
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.DEFAULT_KEY in schema) {
        defaults = schema.default;
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY in schema) {
        const refName = schema[_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY];
        // Use referenced schema defaults for this node.
        if (!_recurseList.includes(refName)) {
            updatedRecurseList = _recurseList.concat(refName);
            schemaToCompute = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_3__["default"])(refName, rootSchema);
        }
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.DEPENDENCIES_KEY in schema) {
        // Get the default if set from properties to ensure the dependencies conditions are resolved based on it
        const defaultFormData = {
            ...formData,
            ...getDefaultBasedOnSchemaType(validator, schema, computeDefaultsProps, defaults),
        };
        const resolvedSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_13__.resolveDependencies)(validator, schema, rootSchema, false, [], defaultFormData);
        schemaToCompute = resolvedSchema[0]; // pick the first element from resolve dependencies
    }
    else if ((0,_isFixedItems__WEBPACK_IMPORTED_MODULE_8__["default"])(schema)) {
        defaults = schema.items.map((itemSchema, idx) => computeDefaults(validator, itemSchema, {
            rootSchema,
            includeUndefinedValues,
            _recurseList,
            experimental_defaultFormStateBehavior,
            parentDefaults: Array.isArray(parentDefaults) ? parentDefaults[idx] : undefined,
            rawFormData: formData,
            required,
        }));
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.ONE_OF_KEY in schema) {
        const { oneOf, ...remaining } = schema;
        if (oneOf.length === 0) {
            return undefined;
        }
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_5__["default"])(schema);
        schemaToCompute = oneOf[(0,_getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__["default"])(validator, rootSchema, lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default()(formData) ? undefined : formData, oneOf, 0, discriminator)];
        schemaToCompute = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_11__["default"])(remaining, schemaToCompute);
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.ANY_OF_KEY in schema) {
        const { anyOf, ...remaining } = schema;
        if (anyOf.length === 0) {
            return undefined;
        }
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_5__["default"])(schema);
        schemaToCompute = anyOf[(0,_getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__["default"])(validator, rootSchema, lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default()(formData) ? undefined : formData, anyOf, 0, discriminator)];
        schemaToCompute = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_11__["default"])(remaining, schemaToCompute);
    }
    if (schemaToCompute) {
        return computeDefaults(validator, schemaToCompute, {
            rootSchema,
            includeUndefinedValues,
            _recurseList: updatedRecurseList,
            experimental_defaultFormStateBehavior,
            parentDefaults: defaults,
            rawFormData: formData,
            required,
        });
    }
    // No defaults defined for this node, fallback to generic typed ones.
    if (defaults === undefined) {
        defaults = schema.default;
    }
    const defaultBasedOnSchemaType = getDefaultBasedOnSchemaType(validator, schema, computeDefaultsProps, defaults);
    return defaultBasedOnSchemaType !== null && defaultBasedOnSchemaType !== void 0 ? defaultBasedOnSchemaType : defaults;
}
/** Computes the default value for objects.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be used when necessary
 * @param rawSchema - The schema for which the default state is desired
 * @param {ComputeDefaultsProps} computeDefaultsProps - Optional props for this function
 * @param defaults - Optional props for this function
 * @returns - The default value based on the schema type if they are defined for object or array schemas.
 */
function getObjectDefaults(validator, rawSchema, { rawFormData, rootSchema = {}, includeUndefinedValues = false, _recurseList = [], experimental_defaultFormStateBehavior = undefined, required, } = {}, defaults) {
    {
        const formData = ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(rawFormData) ? rawFormData : {});
        const schema = rawSchema;
        // This is a custom addition that fixes this issue:
        // https://github.com/rjsf-team/react-jsonschema-form/issues/3832
        const retrievedSchema = (experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.allOf) === 'populateDefaults' && _constants__WEBPACK_IMPORTED_MODULE_2__.ALL_OF_KEY in schema
            ? (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_13__["default"])(validator, schema, rootSchema, formData)
            : schema;
        const objectDefaults = Object.keys(retrievedSchema.properties || {}).reduce((acc, key) => {
            var _a;
            // Compute the defaults for this node, with the parent defaults we might
            // have from a previous run: defaults[key].
            const computedDefault = computeDefaults(validator, lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(retrievedSchema, [_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, key]), {
                rootSchema,
                _recurseList,
                experimental_defaultFormStateBehavior,
                includeUndefinedValues: includeUndefinedValues === true,
                parentDefaults: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(defaults, [key]),
                rawFormData: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key]),
                required: (_a = retrievedSchema.required) === null || _a === void 0 ? void 0 : _a.includes(key),
            });
            maybeAddDefaultToObject(acc, key, computedDefault, includeUndefinedValues, required, retrievedSchema.required, experimental_defaultFormStateBehavior);
            return acc;
        }, {});
        if (retrievedSchema.additionalProperties) {
            // as per spec additionalProperties may be either schema or boolean
            const additionalPropertiesSchema = (0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(retrievedSchema.additionalProperties)
                ? retrievedSchema.additionalProperties
                : {};
            const keys = new Set();
            if ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(defaults)) {
                Object.keys(defaults)
                    .filter((key) => !retrievedSchema.properties || !retrievedSchema.properties[key])
                    .forEach((key) => keys.add(key));
            }
            const formDataRequired = [];
            Object.keys(formData)
                .filter((key) => !retrievedSchema.properties || !retrievedSchema.properties[key])
                .forEach((key) => {
                keys.add(key);
                formDataRequired.push(key);
            });
            keys.forEach((key) => {
                var _a;
                const computedDefault = computeDefaults(validator, additionalPropertiesSchema, {
                    rootSchema,
                    _recurseList,
                    experimental_defaultFormStateBehavior,
                    includeUndefinedValues: includeUndefinedValues === true,
                    parentDefaults: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(defaults, [key]),
                    rawFormData: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key]),
                    required: (_a = retrievedSchema.required) === null || _a === void 0 ? void 0 : _a.includes(key),
                });
                // Since these are additional properties we don't need to add the `experimental_defaultFormStateBehavior` prop
                maybeAddDefaultToObject(objectDefaults, key, computedDefault, includeUndefinedValues, required, formDataRequired);
            });
        }
        return objectDefaults;
    }
}
/** Computes the default value for arrays.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be used when necessary
 * @param rawSchema - The schema for which the default state is desired
 * @param {ComputeDefaultsProps} computeDefaultsProps - Optional props for this function
 * @param defaults - Optional props for this function
 * @returns - The default value based on the schema type if they are defined for object or array schemas.
 */
function getArrayDefaults(validator, rawSchema, { rawFormData, rootSchema = {}, _recurseList = [], experimental_defaultFormStateBehavior = undefined, required, } = {}, defaults) {
    var _a, _b, _c, _d;
    const schema = rawSchema;
    const neverPopulate = ((_a = experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.arrayMinItems) === null || _a === void 0 ? void 0 : _a.populate) === 'never';
    const ignoreMinItemsFlagSet = ((_b = experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.arrayMinItems) === null || _b === void 0 ? void 0 : _b.populate) === 'requiredOnly';
    const isSkipEmptyDefaults = (experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.emptyObjectFields) === 'skipEmptyDefaults';
    const computeSkipPopulate = (_d = (_c = experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.arrayMinItems) === null || _c === void 0 ? void 0 : _c.computeSkipPopulate) !== null && _d !== void 0 ? _d : (() => false);
    const emptyDefault = isSkipEmptyDefaults ? undefined : [];
    // Inject defaults into existing array defaults
    if (Array.isArray(defaults)) {
        defaults = defaults.map((item, idx) => {
            const schemaItem = getInnerSchemaForArrayItem(schema, AdditionalItemsHandling.Fallback, idx);
            return computeDefaults(validator, schemaItem, {
                rootSchema,
                _recurseList,
                experimental_defaultFormStateBehavior,
                parentDefaults: item,
                required,
            });
        });
    }
    // Deeply inject defaults into already existing form data
    if (Array.isArray(rawFormData)) {
        const schemaItem = getInnerSchemaForArrayItem(schema);
        if (neverPopulate) {
            defaults = rawFormData;
        }
        else {
            defaults = rawFormData.map((item, idx) => {
                return computeDefaults(validator, schemaItem, {
                    rootSchema,
                    _recurseList,
                    experimental_defaultFormStateBehavior,
                    rawFormData: item,
                    parentDefaults: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(defaults, [idx]),
                    required,
                });
            });
        }
    }
    if (neverPopulate) {
        return defaults !== null && defaults !== void 0 ? defaults : emptyDefault;
    }
    if (ignoreMinItemsFlagSet && !required) {
        // If no form data exists or defaults are set leave the field empty/non-existent, otherwise
        // return form data/defaults
        return defaults ? defaults : undefined;
    }
    const defaultsLength = Array.isArray(defaults) ? defaults.length : 0;
    if (!schema.minItems ||
        (0,_isMultiSelect__WEBPACK_IMPORTED_MODULE_12__["default"])(validator, schema, rootSchema) ||
        computeSkipPopulate(validator, schema, rootSchema) ||
        schema.minItems <= defaultsLength) {
        return defaults ? defaults : emptyDefault;
    }
    const defaultEntries = (defaults || []);
    const fillerSchema = getInnerSchemaForArrayItem(schema, AdditionalItemsHandling.Invert);
    const fillerDefault = fillerSchema.default;
    // Calculate filler entries for remaining items (minItems - existing raw data/defaults)
    const fillerEntries = new Array(schema.minItems - defaultsLength).fill(computeDefaults(validator, fillerSchema, {
        parentDefaults: fillerDefault,
        rootSchema,
        _recurseList,
        experimental_defaultFormStateBehavior,
        required,
    }));
    // then fill up the rest with either the item default or empty, up to minItems
    return defaultEntries.concat(fillerEntries);
}
/** Computes the default value based on the schema type.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be used when necessary
 * @param rawSchema - The schema for which the default state is desired
 * @param {ComputeDefaultsProps} computeDefaultsProps - Optional props for this function
 * @param defaults - Optional props for this function
 * @returns - The default value based on the schema type if they are defined for object or array schemas.
 */
function getDefaultBasedOnSchemaType(validator, rawSchema, computeDefaultsProps = {}, defaults) {
    switch ((0,_getSchemaType__WEBPACK_IMPORTED_MODULE_6__["default"])(rawSchema)) {
        // We need to recurse for object schema inner default values.
        case 'object': {
            return getObjectDefaults(validator, rawSchema, computeDefaultsProps, defaults);
        }
        case 'array': {
            return getArrayDefaults(validator, rawSchema, computeDefaultsProps, defaults);
        }
    }
}
/** Returns the superset of `formData` that includes the given set updated to include any missing fields that have
 * computed to have defaults provided in the `schema`.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param theSchema - The schema for which the default state is desired
 * @param [formData] - The current formData, if any, onto which to provide any missing defaults
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [includeUndefinedValues=false] - Optional flag, if true, cause undefined values to be added as defaults.
 *          If "excludeObjectChildren", cause undefined values for this object and pass `includeUndefinedValues` as
 *          false when computing defaults for any nested object properties.
 * @param [experimental_defaultFormStateBehavior] Optional configuration object, if provided, allows users to override default form state behavior
 * @returns - The resulting `formData` with all the defaults provided
 */
function getDefaultFormState(validator, theSchema, formData, rootSchema, includeUndefinedValues = false, experimental_defaultFormStateBehavior) {
    if (!(0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(theSchema)) {
        throw new Error('Invalid schema: ' + theSchema);
    }
    const schema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_13__["default"])(validator, theSchema, rootSchema, formData);
    const defaults = computeDefaults(validator, schema, {
        rootSchema,
        includeUndefinedValues,
        experimental_defaultFormStateBehavior,
        rawFormData: formData,
    });
    if (formData === undefined || formData === null || (typeof formData === 'number' && isNaN(formData))) {
        // No form data? Use schema defaults.
        return defaults;
    }
    const { mergeExtraDefaults } = (experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.arrayMinItems) || {};
    if ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(formData)) {
        return (0,_mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_9__["default"])(defaults, formData, mergeExtraDefaults);
    }
    if (Array.isArray(formData)) {
        return (0,_mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_9__["default"])(defaults, formData, mergeExtraDefaults);
    }
    return formData;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getDisplayLabel.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getDisplayLabel.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDisplayLabel)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");
/* harmony import */ var _isCustomWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../isCustomWidget */ "../../node_modules/@rjsf/utils/lib/isCustomWidget.js");
/* harmony import */ var _isFilesArray__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./isFilesArray */ "../../node_modules/@rjsf/utils/lib/schema/isFilesArray.js");
/* harmony import */ var _isMultiSelect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isMultiSelect */ "../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js");






/** Determines whether the combination of `schema` and `uiSchema` properties indicates that the label for the `schema`
 * should be displayed in a UI.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the display label flag is desired
 * @param [uiSchema={}] - The UI schema from which to derive potentially displayable information
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [globalOptions={}] - The optional Global UI Schema from which to get any fallback `xxx` options
 * @returns - True if the label should be displayed or false if it should not
 */
function getDisplayLabel(validator, schema, uiSchema = {}, rootSchema, globalOptions) {
    const uiOptions = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_2__["default"])(uiSchema, globalOptions);
    const { label = true } = uiOptions;
    let displayLabel = !!label;
    const schemaType = (0,_getSchemaType__WEBPACK_IMPORTED_MODULE_1__["default"])(schema);
    if (schemaType === 'array') {
        displayLabel =
            (0,_isMultiSelect__WEBPACK_IMPORTED_MODULE_5__["default"])(validator, schema, rootSchema) ||
                (0,_isFilesArray__WEBPACK_IMPORTED_MODULE_4__["default"])(validator, schema, uiSchema, rootSchema) ||
                (0,_isCustomWidget__WEBPACK_IMPORTED_MODULE_3__["default"])(uiSchema);
    }
    if (schemaType === 'object') {
        displayLabel = false;
    }
    if (schemaType === 'boolean' && !uiSchema[_constants__WEBPACK_IMPORTED_MODULE_0__.UI_WIDGET_KEY]) {
        displayLabel = false;
    }
    if (uiSchema[_constants__WEBPACK_IMPORTED_MODULE_0__.UI_FIELD_KEY]) {
        displayLabel = false;
    }
    return displayLabel;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getFirstMatchingOption)
/* harmony export */ });
/* harmony import */ var _getMatchingOption__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getMatchingOption.js");

/** Given the `formData` and list of `options`, attempts to find the index of the first option that matches the data.
 * Always returns the first option if there is nothing that matches.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param formData - The current formData, if any, used to figure out a match
 * @param options - The list of options to find a matching options from
 * @param rootSchema - The root schema, used to primarily to look up `$ref`s
 * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
 *          determine which option is selected
 * @returns - The index of the first matched option or 0 if none is available
 */
function getFirstMatchingOption(validator, formData, options, rootSchema, discriminatorField) {
    return (0,_getMatchingOption__WEBPACK_IMPORTED_MODULE_0__["default"])(validator, formData, options, rootSchema, discriminatorField);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getMatchingOption.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getMatchingOption.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getMatchingOption)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/has */ "../../node_modules/lodash/has.js");
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_has__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isNumber */ "../../node_modules/lodash/isNumber.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isNumber__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../getOptionMatchingSimpleDiscriminator */ "../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js");





/** Given the `formData` and list of `options`, attempts to find the index of the option that best matches the data.
 * Deprecated, use `getFirstMatchingOption()` instead.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param formData - The current formData, if any, used to figure out a match
 * @param options - The list of options to find a matching options from
 * @param rootSchema - The root schema, used to primarily to look up `$ref`s
 * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
 *          determine which option is selected
 * @returns - The index of the matched option or 0 if none is available
 * @deprecated
 */
function getMatchingOption(validator, formData, options, rootSchema, discriminatorField) {
    // For performance, skip validating subschemas if formData is undefined. We just
    // want to get the first option in that case.
    if (formData === undefined) {
        return 0;
    }
    const simpleDiscriminatorMatch = (0,_getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_4__["default"])(formData, options, discriminatorField);
    if (lodash_isNumber__WEBPACK_IMPORTED_MODULE_2___default()(simpleDiscriminatorMatch)) {
        return simpleDiscriminatorMatch;
    }
    for (let i = 0; i < options.length; i++) {
        const option = options[i];
        // If we have a discriminator field, then we will use this to make the determination
        if (discriminatorField && lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(option, [_constants__WEBPACK_IMPORTED_MODULE_3__.PROPERTIES_KEY, discriminatorField])) {
            const value = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, discriminatorField);
            const discriminator = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(option, [_constants__WEBPACK_IMPORTED_MODULE_3__.PROPERTIES_KEY, discriminatorField], {});
            if (validator.isValid(discriminator, value, rootSchema)) {
                return i;
            }
        }
        else if (option[_constants__WEBPACK_IMPORTED_MODULE_3__.PROPERTIES_KEY]) {
            // If the schema describes an object then we need to add slightly more
            // strict matching to the schema, because unless the schema uses the
            // "requires" keyword, an object will match the schema as long as it
            // doesn't have matching keys with a conflicting type. To do this we use an
            // "anyOf" with an array of requires. This augmentation expresses that the
            // schema should match if any of the keys in the schema are present on the
            // object and pass validation.
            //
            // Create an "anyOf" schema that requires at least one of the keys in the
            // "properties" object
            const requiresAnyOf = {
                anyOf: Object.keys(option[_constants__WEBPACK_IMPORTED_MODULE_3__.PROPERTIES_KEY]).map((key) => ({
                    required: [key],
                })),
            };
            let augmentedSchema;
            // If the "anyOf" keyword already exists, wrap the augmentation in an "allOf"
            if (option.anyOf) {
                // Create a shallow clone of the option
                const { ...shallowClone } = option;
                if (!shallowClone.allOf) {
                    shallowClone.allOf = [];
                }
                else {
                    // If "allOf" already exists, shallow clone the array
                    shallowClone.allOf = shallowClone.allOf.slice();
                }
                shallowClone.allOf.push(requiresAnyOf);
                augmentedSchema = shallowClone;
            }
            else {
                augmentedSchema = Object.assign({}, option, requiresAnyOf);
            }
            // Remove the "required" field as it's likely that not all fields have
            // been filled in yet, which will mean that the schema is not valid
            delete augmentedSchema.required;
            if (validator.isValid(augmentedSchema, formData, rootSchema)) {
                return i;
            }
        }
        else if (validator.isValid(option, formData, rootSchema)) {
            return i;
        }
    }
    return 0;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/index.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getClosestMatchingOption: () => (/* reexport safe */ _getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   getDefaultFormState: () => (/* reexport safe */ _getDefaultFormState__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   getDisplayLabel: () => (/* reexport safe */ _getDisplayLabel__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   getFirstMatchingOption: () => (/* reexport safe */ _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   getMatchingOption: () => (/* reexport safe */ _getMatchingOption__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   isFilesArray: () => (/* reexport safe */ _isFilesArray__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   isMultiSelect: () => (/* reexport safe */ _isMultiSelect__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   isSelect: () => (/* reexport safe */ _isSelect__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   mergeValidationData: () => (/* reexport safe */ _mergeValidationData__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   retrieveSchema: () => (/* reexport safe */ _retrieveSchema__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   sanitizeDataForNewSchema: () => (/* reexport safe */ _sanitizeDataForNewSchema__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   toIdSchema: () => (/* reexport safe */ _toIdSchema__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   toPathSchema: () => (/* reexport safe */ _toPathSchema__WEBPACK_IMPORTED_MODULE_12__["default"])
/* harmony export */ });
/* harmony import */ var _getDefaultFormState__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getDefaultFormState */ "../../node_modules/@rjsf/utils/lib/schema/getDefaultFormState.js");
/* harmony import */ var _getDisplayLabel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDisplayLabel */ "../../node_modules/@rjsf/utils/lib/schema/getDisplayLabel.js");
/* harmony import */ var _getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getClosestMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js");
/* harmony import */ var _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getFirstMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js");
/* harmony import */ var _getMatchingOption__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getMatchingOption.js");
/* harmony import */ var _isFilesArray__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isFilesArray */ "../../node_modules/@rjsf/utils/lib/schema/isFilesArray.js");
/* harmony import */ var _isMultiSelect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./isMultiSelect */ "../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js");
/* harmony import */ var _isSelect__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./isSelect */ "../../node_modules/@rjsf/utils/lib/schema/isSelect.js");
/* harmony import */ var _mergeValidationData__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./mergeValidationData */ "../../node_modules/@rjsf/utils/lib/schema/mergeValidationData.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _sanitizeDataForNewSchema__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./sanitizeDataForNewSchema */ "../../node_modules/@rjsf/utils/lib/schema/sanitizeDataForNewSchema.js");
/* harmony import */ var _toIdSchema__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./toIdSchema */ "../../node_modules/@rjsf/utils/lib/schema/toIdSchema.js");
/* harmony import */ var _toPathSchema__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./toPathSchema */ "../../node_modules/@rjsf/utils/lib/schema/toPathSchema.js");
















/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/isFilesArray.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/isFilesArray.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isFilesArray)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");


/** Checks to see if the `schema` and `uiSchema` combination represents an array of files
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which check for array of files flag is desired
 * @param [uiSchema={}] - The UI schema from which to check the widget
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @returns - True if schema/uiSchema contains an array of files, otherwise false
 */
function isFilesArray(validator, schema, uiSchema = {}, rootSchema) {
    if (uiSchema[_constants__WEBPACK_IMPORTED_MODULE_0__.UI_WIDGET_KEY] === 'files') {
        return true;
    }
    if (schema.items) {
        const itemsSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_1__["default"])(validator, schema.items, rootSchema);
        return itemsSchema.type === 'string' && itemsSchema.format === 'data-url';
    }
    return false;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isMultiSelect)
/* harmony export */ });
/* harmony import */ var _isSelect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isSelect */ "../../node_modules/@rjsf/utils/lib/schema/isSelect.js");

/** Checks to see if the `schema` combination represents a multi-select
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which check for a multi-select flag is desired
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @returns - True if schema contains a multi-select, otherwise false
 */
function isMultiSelect(validator, schema, rootSchema) {
    if (!schema.uniqueItems || !schema.items || typeof schema.items === 'boolean') {
        return false;
    }
    return (0,_isSelect__WEBPACK_IMPORTED_MODULE_0__["default"])(validator, schema.items, rootSchema);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/isSelect.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/isSelect.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isSelect)
/* harmony export */ });
/* harmony import */ var _isConstant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../isConstant */ "../../node_modules/@rjsf/utils/lib/isConstant.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");


/** Checks to see if the `schema` combination represents a select
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param theSchema - The schema for which check for a select flag is desired
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @returns - True if schema contains a select, otherwise false
 */
function isSelect(validator, theSchema, rootSchema = {}) {
    const schema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_1__["default"])(validator, theSchema, rootSchema, undefined);
    const altSchemas = schema.oneOf || schema.anyOf;
    if (Array.isArray(schema.enum)) {
        return true;
    }
    if (Array.isArray(altSchemas)) {
        return altSchemas.every((altSchemas) => typeof altSchemas !== 'boolean' && (0,_isConstant__WEBPACK_IMPORTED_MODULE_0__["default"])(altSchemas));
    }
    return false;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/mergeValidationData.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/mergeValidationData.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeValidationData)
/* harmony export */ });
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mergeObjects__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../mergeObjects */ "../../node_modules/@rjsf/utils/lib/mergeObjects.js");


/** Merges the errors in `additionalErrorSchema` into the existing `validationData` by combining the hierarchies in the
 * two `ErrorSchema`s and then appending the error list from the `additionalErrorSchema` obtained by calling
 * `validator.toErrorList()` onto the `errors` in the `validationData`. If no `additionalErrorSchema` is passed, then
 * `validationData` is returned.
 *
 * @param validator - The validator used to convert an ErrorSchema to a list of errors
 * @param validationData - The current `ValidationData` into which to merge the additional errors
 * @param [additionalErrorSchema] - The additional set of errors in an `ErrorSchema`
 * @returns - The `validationData` with the additional errors from `additionalErrorSchema` merged into it, if provided.
 * @deprecated - Use the `validationDataMerge()` function exported from `@rjsf/utils` instead. This function will be
 *        removed in the next major release.
 */
function mergeValidationData(validator, validationData, additionalErrorSchema) {
    if (!additionalErrorSchema) {
        return validationData;
    }
    const { errors: oldErrors, errorSchema: oldErrorSchema } = validationData;
    let errors = validator.toErrorList(additionalErrorSchema);
    let errorSchema = additionalErrorSchema;
    if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default()(oldErrorSchema)) {
        errorSchema = (0,_mergeObjects__WEBPACK_IMPORTED_MODULE_1__["default"])(oldErrorSchema, additionalErrorSchema, true);
        errors = [...oldErrors].concat(errors);
    }
    return { errorSchema, errors };
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ retrieveSchema),
/* harmony export */   getAllPermutationsOfXxxOf: () => (/* binding */ getAllPermutationsOfXxxOf),
/* harmony export */   processDependencies: () => (/* binding */ processDependencies),
/* harmony export */   resolveAllReferences: () => (/* binding */ resolveAllReferences),
/* harmony export */   resolveAnyOrOneOfSchemas: () => (/* binding */ resolveAnyOrOneOfSchemas),
/* harmony export */   resolveCondition: () => (/* binding */ resolveCondition),
/* harmony export */   resolveDependencies: () => (/* binding */ resolveDependencies),
/* harmony export */   resolveReference: () => (/* binding */ resolveReference),
/* harmony export */   resolveSchema: () => (/* binding */ resolveSchema),
/* harmony export */   retrieveSchemaInternal: () => (/* binding */ retrieveSchemaInternal),
/* harmony export */   stubExistingAdditionalProperties: () => (/* binding */ stubExistingAdditionalProperties),
/* harmony export */   withDependentProperties: () => (/* binding */ withDependentProperties),
/* harmony export */   withDependentSchema: () => (/* binding */ withDependentSchema),
/* harmony export */   withExactlyOneSubschema: () => (/* binding */ withExactlyOneSubschema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/times */ "../../node_modules/lodash/times.js");
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_times__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_transform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/transform */ "../../node_modules/lodash/transform.js");
/* harmony import */ var lodash_transform__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_transform__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_merge__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/merge */ "../../node_modules/lodash/merge.js");
/* harmony import */ var lodash_merge__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_merge__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/flattenDeep */ "../../node_modules/lodash/flattenDeep.js");
/* harmony import */ var lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_uniq__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/uniq */ "../../node_modules/lodash/uniq.js");
/* harmony import */ var lodash_uniq__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_uniq__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! json-schema-merge-allof */ "../../node_modules/json-schema-merge-allof/src/index.js");
/* harmony import */ var json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../findSchemaDefinition */ "../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../guessType */ "../../node_modules/@rjsf/utils/lib/guessType.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");
/* harmony import */ var _mergeSchemas__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../mergeSchemas */ "../../node_modules/@rjsf/utils/lib/mergeSchemas.js");
/* harmony import */ var _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./getFirstMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");
















/** Retrieves an expanded schema that has had all of its conditions, additional properties, references and dependencies
 * resolved and merged into the `schema` given a `validator`, `rootSchema` and `rawFormData` that is used to do the
 * potentially recursive resolution.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param [rootSchema={}] - The root schema that will be forwarded to all the APIs
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema
 * @returns - The schema having its conditions, additional properties, references and dependencies resolved
 */
function retrieveSchema(validator, schema, rootSchema = {}, rawFormData) {
    return retrieveSchemaInternal(validator, schema, rootSchema, rawFormData)[0];
}
/** Resolves a conditional block (if/else/then) by removing the condition and merging the appropriate conditional branch
 * with the rest of the schema. If `expandAllBranches` is true, then the `retrieveSchemaInteral()` results for both
 * conditions will be returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that is used to detect valid schema conditions
 * @param schema - The schema for which resolving a condition is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and
 *          dependencies as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData to assist retrieving a schema
 * @returns - A list of schemas with the appropriate conditions resolved, possibly with all branches expanded
 */
function resolveCondition(validator, schema, rootSchema, expandAllBranches, recurseList, formData) {
    const { if: expression, then, else: otherwise, ...resolvedSchemaLessConditional } = schema;
    const conditionValue = validator.isValid(expression, formData || {}, rootSchema);
    let resolvedSchemas = [resolvedSchemaLessConditional];
    let schemas = [];
    if (expandAllBranches) {
        if (then && typeof then !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, then, rootSchema, formData, expandAllBranches, recurseList));
        }
        if (otherwise && typeof otherwise !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, otherwise, rootSchema, formData, expandAllBranches, recurseList));
        }
    }
    else {
        const conditionalSchema = conditionValue ? then : otherwise;
        if (conditionalSchema && typeof conditionalSchema !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, conditionalSchema, rootSchema, formData, expandAllBranches, recurseList));
        }
    }
    if (schemas.length) {
        resolvedSchemas = schemas.map((s) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(resolvedSchemaLessConditional, s));
    }
    return resolvedSchemas.flatMap((s) => retrieveSchemaInternal(validator, s, rootSchema, formData, expandAllBranches, recurseList));
}
/** Given a list of lists of allOf, anyOf or oneOf values, create a list of lists of all permutations of the values. The
 * `listOfLists` is expected to be all resolved values of the 1st...nth schemas within an `allOf`, `anyOf` or `oneOf`.
 * From those lists, build a matrix for each `xxxOf` where there is more than one schema for a row in the list of lists.
 *
 * For example:
 * - If there are three xxxOf rows (A, B, C) and they have been resolved such that there is only one A, two B and three
 *   C schemas then:
 *   - The permutation for the first row is `[[A]]`
 *   - The permutations for the second row are `[[A,B1], [A,B2]]`
 *   - The permutations for the third row are `[[A,B1,C1], [A,B1,C2], [A,B1,C3], [A,B2,C1], [A,B2,C2], [A,B2,C3]]`
 *
 * @param listOfLists - The list of lists of elements that represent the allOf, anyOf or oneOf resolved values in order
 * @returns - The list of all permutations of schemas for a set of `xxxOf`s
 */
function getAllPermutationsOfXxxOf(listOfLists) {
    const allPermutations = listOfLists.reduce((permutations, list) => {
        // When there are more than one set of schemas for a row, duplicate the set of permutations and add in the values
        if (list.length > 1) {
            return list.flatMap((element) => lodash_times__WEBPACK_IMPORTED_MODULE_2___default()(permutations.length, (i) => [...permutations[i]].concat(element)));
        }
        // Otherwise just push in the single value into the current set of permutations
        permutations.forEach((permutation) => permutation.push(list[0]));
        return permutations;
    }, [[]] // Start with an empty list
    );
    return allPermutations;
}
/** Resolves references and dependencies within a schema and its 'allOf' children. Passes the `expandAllBranches` flag
 * down to the `retrieveSchemaInternal()`, `resolveReference()` and `resolveDependencies()` helper calls. If
 * `expandAllBranches` is true, then all possible dependencies and/or allOf branches are returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list of schemas having its references, dependencies and allOf schemas resolved
 */
function resolveSchema(validator, schema, rootSchema, expandAllBranches, recurseList, formData) {
    const updatedSchemas = resolveReference(validator, schema, rootSchema, expandAllBranches, recurseList, formData);
    if (updatedSchemas.length > 1 || updatedSchemas[0] !== schema) {
        // return the updatedSchemas array if it has either multiple schemas within it
        // OR the first schema is not the same as the original schema
        return updatedSchemas;
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.DEPENDENCIES_KEY in schema) {
        const resolvedSchemas = resolveDependencies(validator, schema, rootSchema, expandAllBranches, recurseList, formData);
        return resolvedSchemas.flatMap((s) => {
            return retrieveSchemaInternal(validator, s, rootSchema, formData, expandAllBranches, recurseList);
        });
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.ALL_OF_KEY in schema && Array.isArray(schema.allOf)) {
        const allOfSchemaElements = schema.allOf.map((allOfSubschema) => retrieveSchemaInternal(validator, allOfSubschema, rootSchema, formData, expandAllBranches, recurseList));
        const allPermutations = getAllPermutationsOfXxxOf(allOfSchemaElements);
        return allPermutations.map((permutation) => ({
            ...schema,
            allOf: permutation,
        }));
    }
    // No $ref or dependencies or allOf attribute was found, returning the original schema.
    return [schema];
}
/** Resolves all references within a schema and then returns the `retrieveSchemaInternal()` if the resolved schema is
 * actually different than the original. Passes the `expandAllBranches` flag down to the `retrieveSchemaInternal()`
 * helper call.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a reference is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list schemas retrieved after having all references resolved
 */
function resolveReference(validator, schema, rootSchema, expandAllBranches, recurseList, formData) {
    const updatedSchema = resolveAllReferences(schema, rootSchema, recurseList);
    if (updatedSchema !== schema) {
        // Only call this if the schema was actually changed by the `resolveAllReferences()` function
        return retrieveSchemaInternal(validator, updatedSchema, rootSchema, formData, expandAllBranches, recurseList);
    }
    return [schema];
}
/** Resolves all references within the schema itself as well as any of its properties and array items.
 *
 * @param schema - The schema for which resolving all references is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param recurseList - List of $refs already resolved to prevent recursion
 * @returns - given schema will all references resolved or the original schema if no internal `$refs` were resolved
 */
function resolveAllReferences(schema, rootSchema, recurseList) {
    if (!(0,_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(schema)) {
        return schema;
    }
    let resolvedSchema = schema;
    // resolve top level ref
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.REF_KEY in resolvedSchema) {
        const { $ref, ...localSchema } = resolvedSchema;
        // Check for a recursive reference and stop the loop
        if (recurseList.includes($ref)) {
            return resolvedSchema;
        }
        recurseList.push($ref);
        // Retrieve the referenced schema definition.
        const refSchema = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_9__["default"])($ref, rootSchema);
        resolvedSchema = { ...refSchema, ...localSchema };
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.PROPERTIES_KEY in resolvedSchema) {
        const childrenLists = [];
        const updatedProps = lodash_transform__WEBPACK_IMPORTED_MODULE_3___default()(resolvedSchema[_constants__WEBPACK_IMPORTED_MODULE_8__.PROPERTIES_KEY], (result, value, key) => {
            const childList = [...recurseList];
            result[key] = resolveAllReferences(value, rootSchema, childList);
            childrenLists.push(childList);
        }, {});
        lodash_merge__WEBPACK_IMPORTED_MODULE_4___default()(recurseList, lodash_uniq__WEBPACK_IMPORTED_MODULE_6___default()(lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_5___default()(childrenLists)));
        resolvedSchema = { ...resolvedSchema, [_constants__WEBPACK_IMPORTED_MODULE_8__.PROPERTIES_KEY]: updatedProps };
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.ITEMS_KEY in resolvedSchema &&
        !Array.isArray(resolvedSchema.items) &&
        typeof resolvedSchema.items !== 'boolean') {
        resolvedSchema = {
            ...resolvedSchema,
            items: resolveAllReferences(resolvedSchema.items, rootSchema, recurseList),
        };
    }
    return (0,_deepEquals__WEBPACK_IMPORTED_MODULE_15__["default"])(schema, resolvedSchema) ? schema : resolvedSchema;
}
/** Creates new 'properties' items for each key in the `formData`
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param theSchema - The schema for which the existing additional properties is desired
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s * @param validator
 * @param [aFormData] - The current formData, if any, to assist retrieving a schema
 * @returns - The updated schema with additional properties stubbed
 */
function stubExistingAdditionalProperties(validator, theSchema, rootSchema, aFormData) {
    // Clone the schema so that we don't ruin the consumer's original
    const schema = {
        ...theSchema,
        properties: { ...theSchema.properties },
    };
    // make sure formData is an object
    const formData = aFormData && (0,_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(aFormData) ? aFormData : {};
    Object.keys(formData).forEach((key) => {
        if (key in schema.properties) {
            // No need to stub, our schema already has the property
            return;
        }
        let additionalProperties = {};
        if (typeof schema.additionalProperties !== 'boolean') {
            if (_constants__WEBPACK_IMPORTED_MODULE_8__.REF_KEY in schema.additionalProperties) {
                additionalProperties = retrieveSchema(validator, { $ref: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema.additionalProperties, [_constants__WEBPACK_IMPORTED_MODULE_8__.REF_KEY]) }, rootSchema, formData);
            }
            else if ('type' in schema.additionalProperties) {
                additionalProperties = { ...schema.additionalProperties };
            }
            else if (_constants__WEBPACK_IMPORTED_MODULE_8__.ANY_OF_KEY in schema.additionalProperties || _constants__WEBPACK_IMPORTED_MODULE_8__.ONE_OF_KEY in schema.additionalProperties) {
                additionalProperties = {
                    type: 'object',
                    ...schema.additionalProperties,
                };
            }
            else {
                additionalProperties = { type: (0,_guessType__WEBPACK_IMPORTED_MODULE_11__["default"])(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key])) };
            }
        }
        else {
            additionalProperties = { type: (0,_guessType__WEBPACK_IMPORTED_MODULE_11__["default"])(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key])) };
        }
        // The type of our new key should match the additionalProperties value;
        schema.properties[key] = additionalProperties;
        // Set our additional property flag so we know it was dynamically added
        lodash_set__WEBPACK_IMPORTED_MODULE_1___default()(schema.properties, [key, _constants__WEBPACK_IMPORTED_MODULE_8__.ADDITIONAL_PROPERTY_FLAG], true);
    });
    return schema;
}
/** Internal handler that retrieves an expanded schema that has had all of its conditions, additional properties,
 * references and dependencies resolved and merged into the `schema` given a `validator`, `rootSchema` and `rawFormData`
 * that is used to do the potentially recursive resolution. If `expandAllBranches` is true, then all possible branches
 * of the schema and its references, conditions and dependencies are returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema
 * @param [expandAllBranches=false] - Flag, if true, will return all possible branches of conditions, any/oneOf and
 *          dependencies as a list of schemas
 * @param [recurseList=[]] - The optional, list of recursive references already processed
 * @returns - The schema(s) resulting from having its conditions, additional properties, references and dependencies
 *          resolved. Multiple schemas may be returned if `expandAllBranches` is true.
 */
function retrieveSchemaInternal(validator, schema, rootSchema, rawFormData, expandAllBranches = false, recurseList = []) {
    if (!(0,_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(schema)) {
        return [{}];
    }
    const resolvedSchemas = resolveSchema(validator, schema, rootSchema, expandAllBranches, recurseList, rawFormData);
    return resolvedSchemas.flatMap((s) => {
        let resolvedSchema = s;
        if (_constants__WEBPACK_IMPORTED_MODULE_8__.IF_KEY in resolvedSchema) {
            return resolveCondition(validator, resolvedSchema, rootSchema, expandAllBranches, recurseList, rawFormData);
        }
        if (_constants__WEBPACK_IMPORTED_MODULE_8__.ALL_OF_KEY in resolvedSchema) {
            // resolve allOf schemas
            if (expandAllBranches) {
                const { allOf, ...restOfSchema } = resolvedSchema;
                return [...allOf, restOfSchema];
            }
            try {
                resolvedSchema = json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_7___default()(resolvedSchema, {
                    deep: false,
                });
            }
            catch (e) {
                console.warn('could not merge subschemas in allOf:\n', e);
                const { allOf, ...resolvedSchemaWithoutAllOf } = resolvedSchema;
                return resolvedSchemaWithoutAllOf;
            }
        }
        const hasAdditionalProperties = _constants__WEBPACK_IMPORTED_MODULE_8__.ADDITIONAL_PROPERTIES_KEY in resolvedSchema && resolvedSchema.additionalProperties !== false;
        if (hasAdditionalProperties) {
            return stubExistingAdditionalProperties(validator, resolvedSchema, rootSchema, rawFormData);
        }
        return resolvedSchema;
    });
}
/** Resolves an `anyOf` or `oneOf` within a schema (if present) to the list of schemas returned from
 * `retrieveSchemaInternal()` for the best matching option. If `expandAllBranches` is true, then a list of schemas for ALL
 * options are retrieved and returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema, defaults to an empty object
 * @returns - Either an array containing the best matching option or all options if `expandAllBranches` is true
 */
function resolveAnyOrOneOfSchemas(validator, schema, rootSchema, expandAllBranches, rawFormData) {
    let anyOrOneOf;
    const { oneOf, anyOf, ...remaining } = schema;
    if (Array.isArray(oneOf)) {
        anyOrOneOf = oneOf;
    }
    else if (Array.isArray(anyOf)) {
        anyOrOneOf = anyOf;
    }
    if (anyOrOneOf) {
        // Ensure that during expand all branches we pass an object rather than undefined so that all options are interrogated
        const formData = rawFormData === undefined && expandAllBranches ? {} : rawFormData;
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_10__["default"])(schema);
        anyOrOneOf = anyOrOneOf.map((s) => {
            // Due to anyOf/oneOf possibly using the same $ref we always pass a fresh recurse list array so that each option
            // can resolve recursive references independently
            return resolveAllReferences(s, rootSchema, []);
        });
        // Call this to trigger the set of isValid() calls that the schema parser will need
        const option = (0,_getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_14__["default"])(validator, formData, anyOrOneOf, rootSchema, discriminator);
        if (expandAllBranches) {
            return anyOrOneOf.map((item) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(remaining, item));
        }
        schema = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(remaining, anyOrOneOf[option]);
    }
    return [schema];
}
/** Resolves dependencies within a schema and its 'anyOf/oneOf' children. Passes the `expandAllBranches` flag down to
 * the `resolveAnyOrOneOfSchema()` and `processDependencies()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a dependency is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list of schemas with their dependencies resolved
 */
function resolveDependencies(validator, schema, rootSchema, expandAllBranches, recurseList, formData) {
    // Drop the dependencies from the source schema.
    const { dependencies, ...remainingSchema } = schema;
    const resolvedSchemas = resolveAnyOrOneOfSchemas(validator, remainingSchema, rootSchema, expandAllBranches, formData);
    return resolvedSchemas.flatMap((resolvedSchema) => processDependencies(validator, dependencies, resolvedSchema, rootSchema, expandAllBranches, recurseList, formData));
}
/** Processes all the `dependencies` recursively into the list of `resolvedSchema`s as needed. Passes the
 * `expandAllBranches` flag down to the `withDependentSchema()` and the recursive `processDependencies()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param dependencies - The set of dependencies that needs to be processed
 * @param resolvedSchema - The schema for which processing dependencies is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The schema with the `dependencies` resolved into it
 */
function processDependencies(validator, dependencies, resolvedSchema, rootSchema, expandAllBranches, recurseList, formData) {
    let schemas = [resolvedSchema];
    // Process dependencies updating the local schema properties as appropriate.
    for (const dependencyKey in dependencies) {
        // Skip this dependency if its trigger property is not present.
        if (!expandAllBranches && lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [dependencyKey]) === undefined) {
            continue;
        }
        // Skip this dependency if it is not included in the schema (such as when dependencyKey is itself a hidden dependency.)
        if (resolvedSchema.properties && !(dependencyKey in resolvedSchema.properties)) {
            continue;
        }
        const [remainingDependencies, dependencyValue] = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_9__.splitKeyElementFromObject)(dependencyKey, dependencies);
        if (Array.isArray(dependencyValue)) {
            schemas[0] = withDependentProperties(resolvedSchema, dependencyValue);
        }
        else if ((0,_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(dependencyValue)) {
            schemas = withDependentSchema(validator, resolvedSchema, rootSchema, dependencyKey, dependencyValue, expandAllBranches, recurseList, formData);
        }
        return schemas.flatMap((schema) => processDependencies(validator, remainingDependencies, schema, rootSchema, expandAllBranches, recurseList, formData));
    }
    return schemas;
}
/** Updates a schema with additionally required properties added
 *
 * @param schema - The schema for which resolving a dependent properties is desired
 * @param [additionallyRequired] - An optional array of additionally required names
 * @returns - The schema with the additional required values merged in
 */
function withDependentProperties(schema, additionallyRequired) {
    if (!additionallyRequired) {
        return schema;
    }
    const required = Array.isArray(schema.required)
        ? Array.from(new Set([...schema.required, ...additionallyRequired]))
        : additionallyRequired;
    return { ...schema, required: required };
}
/** Merges a dependent schema into the `schema` dealing with oneOfs and references. Passes the `expandAllBranches` flag
 * down to the `retrieveSchemaInternal()`, `resolveReference()` and `withExactlyOneSubschema()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a dependent schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param dependencyKey - The key name of the dependency
 * @param dependencyValue - The potentially dependent schema
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData]- The current formData to assist retrieving a schema
 * @returns - The list of schemas with the dependent schema resolved into them
 */
function withDependentSchema(validator, schema, rootSchema, dependencyKey, dependencyValue, expandAllBranches, recurseList, formData) {
    const dependentSchemas = retrieveSchemaInternal(validator, dependencyValue, rootSchema, formData, expandAllBranches, recurseList);
    return dependentSchemas.flatMap((dependent) => {
        const { oneOf, ...dependentSchema } = dependent;
        schema = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(schema, dependentSchema);
        // Since it does not contain oneOf, we return the original schema.
        if (oneOf === undefined) {
            return schema;
        }
        // Resolve $refs inside oneOf.
        const resolvedOneOfs = oneOf.map((subschema) => {
            if (typeof subschema === 'boolean' || !(_constants__WEBPACK_IMPORTED_MODULE_8__.REF_KEY in subschema)) {
                return [subschema];
            }
            return resolveReference(validator, subschema, rootSchema, expandAllBranches, recurseList, formData);
        });
        const allPermutations = getAllPermutationsOfXxxOf(resolvedOneOfs);
        return allPermutations.flatMap((resolvedOneOf) => withExactlyOneSubschema(validator, schema, rootSchema, dependencyKey, resolvedOneOf, expandAllBranches, recurseList, formData));
    });
}
/** Returns a list of `schema`s with the best choice from the `oneOf` options merged into it. If `expandAllBranches` is
 * true, then a list of schemas for ALL options are retrieved and returned. Passes the `expandAllBranches` flag down to
 * the `retrieveSchemaInternal()` helper call.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used to validate oneOf options
 * @param schema - The schema for which resolving a oneOf subschema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param dependencyKey - The key name of the oneOf dependency
 * @param oneOf - The list of schemas representing the oneOf options
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData to assist retrieving a schema
 * @returns - Either an array containing the best matching option or all options if `expandAllBranches` is true
 */
function withExactlyOneSubschema(validator, schema, rootSchema, dependencyKey, oneOf, expandAllBranches, recurseList, formData) {
    const validSubschemas = oneOf.filter((subschema) => {
        if (typeof subschema === 'boolean' || !subschema || !subschema.properties) {
            return false;
        }
        const { [dependencyKey]: conditionPropertySchema } = subschema.properties;
        if (conditionPropertySchema) {
            const conditionSchema = {
                type: 'object',
                properties: {
                    [dependencyKey]: conditionPropertySchema,
                },
            };
            return validator.isValid(conditionSchema, formData, rootSchema) || expandAllBranches;
        }
        return false;
    });
    if (!expandAllBranches && validSubschemas.length !== 1) {
        console.warn("ignoring oneOf in dependencies because there isn't exactly one subschema that is valid");
        return [schema];
    }
    return validSubschemas.flatMap((s) => {
        const subschema = s;
        const [dependentSubschema] = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_9__.splitKeyElementFromObject)(dependencyKey, subschema.properties);
        const dependentSchema = { ...subschema, properties: dependentSubschema };
        const schemas = retrieveSchemaInternal(validator, dependentSchema, rootSchema, formData, expandAllBranches, recurseList);
        return schemas.map((s) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(schema, s));
    });
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/sanitizeDataForNewSchema.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/sanitizeDataForNewSchema.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ sanitizeDataForNewSchema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/has */ "../../node_modules/lodash/has.js");
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_has__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");




const NO_VALUE = Symbol('no Value');
/** Sanitize the `data` associated with the `oldSchema` so it is considered appropriate for the `newSchema`. If the new
 * schema does not contain any properties, then `undefined` is returned to clear all the form data. Due to the nature
 * of schemas, this sanitization happens recursively for nested objects of data. Also, any properties in the old schema
 * that are non-existent in the new schema are set to `undefined`. The data sanitization process has the following flow:
 *
 * - If the new schema is an object that contains a `properties` object then:
 *   - Create a `removeOldSchemaData` object, setting each key in the `oldSchema.properties` having `data` to undefined
 *   - Create an empty `nestedData` object for use in the key filtering below:
 *   - Iterate over each key in the `newSchema.properties` as follows:
 *     - Get the `formValue` of the key from the `data`
 *     - Get the `oldKeySchema` and `newKeyedSchema` for the key, defaulting to `{}` when it doesn't exist
 *     - Retrieve the schema for any refs within each `oldKeySchema` and/or `newKeySchema`
 *     - Get the types of the old and new keyed schemas and if the old doesn't exist or the old & new are the same then:
 *       - If `removeOldSchemaData` has an entry for the key, delete it since the new schema has the same property
 *       - If type of the key in the new schema is `object`:
 *         - Store the value from the recursive `sanitizeDataForNewSchema` call in `nestedData[key]`
 *       - Otherwise, check for default or const values:
 *         - Get the old and new `default` values from the schema and check:
 *           - If the new `default` value does not match the form value:
 *             - If the old `default` value DOES match the form value, then:
 *               - Replace `removeOldSchemaData[key]` with the new `default`
 *               - Otherwise, if the new schema is `readOnly` then replace `removeOldSchemaData[key]` with undefined
 *         - Get the old and new `const` values from the schema and check:
 *           - If the new `const` value does not match the form value:
 *           - If the old `const` value DOES match the form value, then:
 *             - Replace `removeOldSchemaData[key]` with the new `const`
 *             - Otherwise, replace `removeOldSchemaData[key]` with undefined
 *   - Once all keys have been processed, return an object built as follows:
 *     - `{ ...removeOldSchemaData, ...nestedData, ...pick(data, keysToKeep) }`
 * - If the new and old schema types are array and the `data` is an array then:
 *   - If the type of the old and new schema `items` are a non-array objects:
 *     - Retrieve the schema for any refs within each `oldKeySchema.items` and/or `newKeySchema.items`
 *     - If the `type`s of both items are the same (or the old does not have a type):
 *       - If the type is "object", then:
 *         - For each element in the `data` recursively sanitize the data, stopping at `maxItems` if specified
 *       - Otherwise, just return the `data` removing any values after `maxItems` if it is set
 *   - If the type of the old and new schema `items` are booleans of the same value, return `data` as is
 * - Otherwise return `undefined`
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param rootSchema - The root JSON schema of the entire form
 * @param [newSchema] - The new schema for which the data is being sanitized
 * @param [oldSchema] - The old schema from which the data originated
 * @param [data={}] - The form data associated with the schema, defaulting to an empty object when undefined
 * @returns - The new form data, with all the fields uniquely associated with the old schema set
 *      to `undefined`. Will return `undefined` if the new schema is not an object containing properties.
 */
function sanitizeDataForNewSchema(validator, rootSchema, newSchema, oldSchema, data = {}) {
    // By default, we will clear the form data
    let newFormData;
    // If the new schema is of type object and that object contains a list of properties
    if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(newSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY)) {
        // Create an object containing root-level keys in the old schema, setting each key to undefined to remove the data
        const removeOldSchemaData = {};
        if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(oldSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY)) {
            const properties = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, {});
            Object.keys(properties).forEach((key) => {
                if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(data, key)) {
                    removeOldSchemaData[key] = undefined;
                }
            });
        }
        const keys = Object.keys(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, {}));
        // Create a place to store nested data that will be a side-effect of the filter
        const nestedData = {};
        keys.forEach((key) => {
            const formValue = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(data, key);
            let oldKeyedSchema = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchema, [_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, key], {});
            let newKeyedSchema = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, [_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, key], {});
            // Resolve the refs if they exist
            if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(oldKeyedSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY)) {
                oldKeyedSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, oldKeyedSchema, rootSchema, formValue);
            }
            if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(newKeyedSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY)) {
                newKeyedSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, newKeyedSchema, rootSchema, formValue);
            }
            // Now get types and see if they are the same
            const oldSchemaTypeForKey = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldKeyedSchema, 'type');
            const newSchemaTypeForKey = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newKeyedSchema, 'type');
            // Check if the old option has the same key with the same type
            if (!oldSchemaTypeForKey || oldSchemaTypeForKey === newSchemaTypeForKey) {
                if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(removeOldSchemaData, key)) {
                    // SIDE-EFFECT: remove the undefined value for a key that has the same type between the old and new schemas
                    delete removeOldSchemaData[key];
                }
                // If it is an object, we'll recurse and store the resulting sanitized data for the key
                if (newSchemaTypeForKey === 'object' || (newSchemaTypeForKey === 'array' && Array.isArray(formValue))) {
                    // SIDE-EFFECT: process the new schema type of object recursively to save iterations
                    const itemData = sanitizeDataForNewSchema(validator, rootSchema, newKeyedSchema, oldKeyedSchema, formValue);
                    if (itemData !== undefined || newSchemaTypeForKey === 'array') {
                        // only put undefined values for the array type and not the object type
                        nestedData[key] = itemData;
                    }
                }
                else {
                    // Ok, the non-object types match, let's make sure that a default or a const of a different value is replaced
                    // with the new default or const. This allows the case where two schemas differ that only by the default/const
                    // value to be properly selected
                    const newOptionDefault = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newKeyedSchema, 'default', NO_VALUE);
                    const oldOptionDefault = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldKeyedSchema, 'default', NO_VALUE);
                    if (newOptionDefault !== NO_VALUE && newOptionDefault !== formValue) {
                        if (oldOptionDefault === formValue) {
                            // If the old default matches the formValue, we'll update the new value to match the new default
                            removeOldSchemaData[key] = newOptionDefault;
                        }
                        else if (lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newKeyedSchema, 'readOnly') === true) {
                            // If the new schema has the default set to read-only, treat it like a const and remove the value
                            removeOldSchemaData[key] = undefined;
                        }
                    }
                    const newOptionConst = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newKeyedSchema, 'const', NO_VALUE);
                    const oldOptionConst = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldKeyedSchema, 'const', NO_VALUE);
                    if (newOptionConst !== NO_VALUE && newOptionConst !== formValue) {
                        // Since this is a const, if the old value matches, replace the value with the new const otherwise clear it
                        removeOldSchemaData[key] = oldOptionConst === formValue ? newOptionConst : undefined;
                    }
                }
            }
        });
        newFormData = {
            ...(typeof data == 'string' || Array.isArray(data) ? undefined : data),
            ...removeOldSchemaData,
            ...nestedData,
        };
        // First apply removing the old schema data, then apply the nested data, then apply the old data keys to keep
    }
    else if (lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchema, 'type') === 'array' && lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, 'type') === 'array' && Array.isArray(data)) {
        let oldSchemaItems = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchema, 'items');
        let newSchemaItems = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, 'items');
        // If any of the array types `items` are arrays (remember arrays are objects) then we'll just drop the data
        // Eventually, we may want to deal with when either of the `items` are arrays since those tuple validations
        if (typeof oldSchemaItems === 'object' &&
            typeof newSchemaItems === 'object' &&
            !Array.isArray(oldSchemaItems) &&
            !Array.isArray(newSchemaItems)) {
            if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(oldSchemaItems, _constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY)) {
                oldSchemaItems = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, oldSchemaItems, rootSchema, data);
            }
            if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(newSchemaItems, _constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY)) {
                newSchemaItems = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, newSchemaItems, rootSchema, data);
            }
            // Now get types and see if they are the same
            const oldSchemaType = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchemaItems, 'type');
            const newSchemaType = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchemaItems, 'type');
            // Check if the old option has the same key with the same type
            if (!oldSchemaType || oldSchemaType === newSchemaType) {
                const maxItems = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, 'maxItems', -1);
                if (newSchemaType === 'object') {
                    newFormData = data.reduce((newValue, aValue) => {
                        const itemValue = sanitizeDataForNewSchema(validator, rootSchema, newSchemaItems, oldSchemaItems, aValue);
                        if (itemValue !== undefined && (maxItems < 0 || newValue.length < maxItems)) {
                            newValue.push(itemValue);
                        }
                        return newValue;
                    }, []);
                }
                else {
                    newFormData = maxItems > 0 && data.length > maxItems ? data.slice(0, maxItems) : data;
                }
            }
        }
        else if (typeof oldSchemaItems === 'boolean' &&
            typeof newSchemaItems === 'boolean' &&
            oldSchemaItems === newSchemaItems) {
            // If they are both booleans and have the same value just return the data as is otherwise fall-thru to undefined
            newFormData = data;
        }
        // Also probably want to deal with `prefixItems` as tuples with the latest 2020 draft
    }
    return newFormData;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/toIdSchema.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/toIdSchema.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toIdSchema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");






/** An internal helper that generates an `IdSchema` object for the `schema`, recursively with protection against
 * infinite recursion
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the `IdSchema` is desired
 * @param idPrefix - The prefix to use for the id
 * @param idSeparator - The separator to use for the path segments in the id
 * @param [id] - The base id for the schema
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @param [_recurseList=[]] - The list of retrieved schemas currently being recursed, used to prevent infinite recursion
 * @returns - The `IdSchema` object for the `schema`
 */
function toIdSchemaInternal(validator, schema, idPrefix, idSeparator, id, rootSchema, formData, _recurseList = []) {
    if (_constants__WEBPACK_IMPORTED_MODULE_1__.REF_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_1__.DEPENDENCIES_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_1__.ALL_OF_KEY in schema) {
        const _schema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, schema, rootSchema, formData);
        const sameSchemaIndex = _recurseList.findIndex((item) => (0,_deepEquals__WEBPACK_IMPORTED_MODULE_5__["default"])(item, _schema));
        if (sameSchemaIndex === -1) {
            return toIdSchemaInternal(validator, _schema, idPrefix, idSeparator, id, rootSchema, formData, _recurseList.concat(_schema));
        }
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_1__.ITEMS_KEY in schema && !lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, [_constants__WEBPACK_IMPORTED_MODULE_1__.ITEMS_KEY, _constants__WEBPACK_IMPORTED_MODULE_1__.REF_KEY])) {
        return toIdSchemaInternal(validator, lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, _constants__WEBPACK_IMPORTED_MODULE_1__.ITEMS_KEY), idPrefix, idSeparator, id, rootSchema, formData, _recurseList);
    }
    const $id = id || idPrefix;
    const idSchema = { $id };
    if ((0,_getSchemaType__WEBPACK_IMPORTED_MODULE_4__["default"])(schema) === 'object' && _constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY in schema) {
        for (const name in schema.properties) {
            const field = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, [_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY, name]);
            const fieldId = idSchema[_constants__WEBPACK_IMPORTED_MODULE_1__.ID_KEY] + idSeparator + name;
            idSchema[name] = toIdSchemaInternal(validator, (0,_isObject__WEBPACK_IMPORTED_MODULE_2__["default"])(field) ? field : {}, idPrefix, idSeparator, fieldId, rootSchema, 
            // It's possible that formData is not an object -- this can happen if an
            // array item has just been added, but not populated with data yet
            lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [name]), _recurseList);
        }
    }
    return idSchema;
}
/** Generates an `IdSchema` object for the `schema`, recursively
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the `IdSchema` is desired
 * @param [id] - The base id for the schema
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @param [idPrefix='root'] - The prefix to use for the id
 * @param [idSeparator='_'] - The separator to use for the path segments in the id
 * @returns - The `IdSchema` object for the `schema`
 */
function toIdSchema(validator, schema, id, rootSchema, formData, idPrefix = 'root', idSeparator = '_') {
    return toIdSchemaInternal(validator, schema, idPrefix, idSeparator, id, rootSchema, formData);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/toPathSchema.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/toPathSchema.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toPathSchema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getClosestMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");







/** An internal helper that generates an `PathSchema` object for the `schema`, recursively with protection against
 * infinite recursion
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the `PathSchema` is desired
 * @param [name=''] - The base name for the schema
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @param [_recurseList=[]] - The list of retrieved schemas currently being recursed, used to prevent infinite recursion
 * @returns - The `PathSchema` object for the `schema`
 */
function toPathSchemaInternal(validator, schema, name, rootSchema, formData, _recurseList = []) {
    if (_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_2__.DEPENDENCIES_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_2__.ALL_OF_KEY in schema) {
        const _schema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_5__["default"])(validator, schema, rootSchema, formData);
        const sameSchemaIndex = _recurseList.findIndex((item) => (0,_deepEquals__WEBPACK_IMPORTED_MODULE_6__["default"])(item, _schema));
        if (sameSchemaIndex === -1) {
            return toPathSchemaInternal(validator, _schema, name, rootSchema, formData, _recurseList.concat(_schema));
        }
    }
    let pathSchema = {
        [_constants__WEBPACK_IMPORTED_MODULE_2__.NAME_KEY]: name.replace(/^\./, ''),
    };
    if (_constants__WEBPACK_IMPORTED_MODULE_2__.ONE_OF_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_2__.ANY_OF_KEY in schema) {
        const xxxOf = _constants__WEBPACK_IMPORTED_MODULE_2__.ONE_OF_KEY in schema ? schema.oneOf : schema.anyOf;
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(schema);
        const index = (0,_getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__["default"])(validator, rootSchema, formData, xxxOf, 0, discriminator);
        const _schema = xxxOf[index];
        pathSchema = {
            ...pathSchema,
            ...toPathSchemaInternal(validator, _schema, name, rootSchema, formData, _recurseList),
        };
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_2__.ADDITIONAL_PROPERTIES_KEY in schema && schema[_constants__WEBPACK_IMPORTED_MODULE_2__.ADDITIONAL_PROPERTIES_KEY] !== false) {
        lodash_set__WEBPACK_IMPORTED_MODULE_1___default()(pathSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.RJSF_ADDITIONAL_PROPERTIES_FLAG, true);
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY in schema && Array.isArray(formData)) {
        const { items: schemaItems, additionalItems: schemaAdditionalItems } = schema;
        if (Array.isArray(schemaItems)) {
            formData.forEach((element, i) => {
                if (schemaItems[i]) {
                    pathSchema[i] = toPathSchemaInternal(validator, schemaItems[i], `${name}.${i}`, rootSchema, element, _recurseList);
                }
                else if (schemaAdditionalItems) {
                    pathSchema[i] = toPathSchemaInternal(validator, schemaAdditionalItems, `${name}.${i}`, rootSchema, element, _recurseList);
                }
                else {
                    console.warn(`Unable to generate path schema for "${name}.${i}". No schema defined for it`);
                }
            });
        }
        else {
            formData.forEach((element, i) => {
                pathSchema[i] = toPathSchemaInternal(validator, schemaItems, `${name}.${i}`, rootSchema, element, _recurseList);
            });
        }
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY in schema) {
        for (const property in schema.properties) {
            const field = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, [_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, property]);
            pathSchema[property] = toPathSchemaInternal(validator, field, `${name}.${property}`, rootSchema, 
            // It's possible that formData is not an object -- this can happen if an
            // array item has just been added, but not populated with data yet
            lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [property]), _recurseList);
        }
    }
    return pathSchema;
}
/** Generates an `PathSchema` object for the `schema`, recursively
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the `PathSchema` is desired
 * @param [name=''] - The base name for the schema
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The `PathSchema` object for the `schema`
 */
function toPathSchema(validator, schema, name = '', rootSchema, formData) {
    return toPathSchemaInternal(validator, schema, name, rootSchema, formData);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schemaRequiresTrueValue.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schemaRequiresTrueValue.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ schemaRequiresTrueValue)
/* harmony export */ });
/** Check to see if a `schema` specifies that a value must be true. This happens when:
 * - `schema.const` is truthy
 * - `schema.enum` == `[true]`
 * - `schema.anyOf` or `schema.oneOf` has a single value which recursively returns true
 * - `schema.allOf` has at least one value which recursively returns true
 *
 * @param schema - The schema to check
 * @returns - True if the schema specifies a value that must be true, false otherwise
 */
function schemaRequiresTrueValue(schema) {
    // Check if const is a truthy value
    if (schema.const) {
        return true;
    }
    // Check if an enum has a single value of true
    if (schema.enum && schema.enum.length === 1 && schema.enum[0] === true) {
        return true;
    }
    // If anyOf has a single value, evaluate the subschema
    if (schema.anyOf && schema.anyOf.length === 1) {
        return schemaRequiresTrueValue(schema.anyOf[0]);
    }
    // If oneOf has a single value, evaluate the subschema
    if (schema.oneOf && schema.oneOf.length === 1) {
        return schemaRequiresTrueValue(schema.oneOf[0]);
    }
    // Evaluate each subschema in allOf, to see if one of them requires a true value
    if (schema.allOf) {
        const schemaSome = (subSchema) => schemaRequiresTrueValue(subSchema);
        return schema.allOf.some(schemaSome);
    }
    return false;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/shouldRender.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/shouldRender.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ shouldRender)
/* harmony export */ });
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");

/** Determines whether the given `component` should be rerendered by comparing its current set of props and state
 * against the next set. If either of those two sets are not the same, then the component should be rerendered.
 *
 * @param component - A React component being checked
 * @param nextProps - The next set of props against which to check
 * @param nextState - The next set of state against which to check
 * @returns - True if the component should be re-rendered, false otherwise
 */
function shouldRender(component, nextProps, nextState) {
    const { props, state } = component;
    return !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(props, nextProps) || !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(state, nextState);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/toConstant.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/toConstant.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toConstant)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");

/** Returns the constant value from the schema when it is either a single value enum or has a const key. Otherwise
 * throws an error.
 *
 * @param schema - The schema from which to obtain the constant value
 * @returns - The constant value for the schema
 * @throws - Error when the schema does not have a constant value
 */
function toConstant(schema) {
    if (_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_KEY in schema && Array.isArray(schema.enum) && schema.enum.length === 1) {
        return schema.enum[0];
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_0__.CONST_KEY in schema) {
        return schema.const;
    }
    throw new Error('schema cannot be inferred as a constant');
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/toDateString.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/toDateString.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toDateString)
/* harmony export */ });
/** Returns a UTC date string for the given `dateObject`. If `time` is false, then the time portion of the string is
 * removed.
 *
 * @param dateObject - The `DateObject` to convert to a date string
 * @param [time=true] - Optional flag used to remove the time portion of the date string if false
 * @returns - The UTC date string
 */
function toDateString(dateObject, time = true) {
    const { year, month, day, hour = 0, minute = 0, second = 0 } = dateObject;
    const utcTime = Date.UTC(year, month - 1, day, hour, minute, second);
    const datetime = new Date(utcTime).toJSON();
    return time ? datetime : datetime.slice(0, 10);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/toErrorList.js":
/*!*********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/toErrorList.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toErrorList)
/* harmony export */ });
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js");
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");


/** Converts an `errorSchema` into a list of `RJSFValidationErrors`
 *
 * @param errorSchema - The `ErrorSchema` instance to convert
 * @param [fieldPath=[]] - The current field path, defaults to [] if not specified
 * @returns - The list of `RJSFValidationErrors` extracted from the `errorSchema`
 */
function toErrorList(errorSchema, fieldPath = []) {
    if (!errorSchema) {
        return [];
    }
    let errorList = [];
    if (_constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY in errorSchema) {
        errorList = errorList.concat(errorSchema[_constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY].map((message) => {
            const property = `.${fieldPath.join('.')}`;
            return {
                property,
                message,
                stack: `${property} ${message}`,
            };
        }));
    }
    return Object.keys(errorSchema).reduce((acc, key) => {
        if (key !== _constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY) {
            const childSchema = errorSchema[key];
            if (lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default()(childSchema)) {
                acc = acc.concat(toErrorList(childSchema, [...fieldPath, key]));
            }
        }
        return acc;
    }, errorList);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/toErrorSchema.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/toErrorSchema.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toErrorSchema)
/* harmony export */ });
/* harmony import */ var lodash_toPath__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/toPath */ "../../node_modules/lodash/toPath.js");
/* harmony import */ var lodash_toPath__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_toPath__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ErrorSchemaBuilder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ErrorSchemaBuilder */ "../../node_modules/@rjsf/utils/lib/ErrorSchemaBuilder.js");


/** Transforms a rjsf validation errors list:
 * [
 *   {property: '.level1.level2[2].level3', message: 'err a'},
 *   {property: '.level1.level2[2].level3', message: 'err b'},
 *   {property: '.level1.level2[4].level3', message: 'err b'},
 * ]
 * Into an error tree:
 * {
 *   level1: {
 *     level2: {
 *       2: {level3: {errors: ['err a', 'err b']}},
 *       4: {level3: {errors: ['err b']}},
 *     }
 *   }
 * };
 *
 * @param errors - The list of RJSFValidationError objects
 * @returns - The `ErrorSchema` built from the list of `RJSFValidationErrors`
 */
function toErrorSchema(errors) {
    const builder = new _ErrorSchemaBuilder__WEBPACK_IMPORTED_MODULE_1__["default"]();
    if (errors.length) {
        errors.forEach((error) => {
            const { property, message } = error;
            // When the property is the root element, just use an empty array for the path
            const path = property === '.' ? [] : lodash_toPath__WEBPACK_IMPORTED_MODULE_0___default()(property);
            // If the property is at the root (.level1) then toPath creates
            // an empty array element at the first index. Remove it.
            if (path.length > 0 && path[0] === '') {
                path.splice(0, 1);
            }
            if (message) {
                builder.addErrors(message, path);
            }
        });
    }
    return builder.ErrorSchema;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/types.js":
/*!***************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/types.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);



/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/unwrapErrorHandler.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/unwrapErrorHandler.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ unwrapErrorHandler)
/* harmony export */ });
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js");
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__);

/** Unwraps the `errorHandler` structure into the associated `ErrorSchema`, stripping the `addError()` functions from it
 *
 * @param errorHandler - The `FormValidation` error handling structure
 * @returns - The `ErrorSchema` resulting from the stripping of the `addError()` function
 */
function unwrapErrorHandler(errorHandler) {
    return Object.keys(errorHandler).reduce((acc, key) => {
        if (key === 'addError') {
            return acc;
        }
        else {
            const childSchema = errorHandler[key];
            if (lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default()(childSchema)) {
                return {
                    ...acc,
                    [key]: unwrapErrorHandler(childSchema),
                };
            }
            return { ...acc, [key]: childSchema };
        }
    }, {});
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/utcToLocal.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/utcToLocal.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ utcToLocal)
/* harmony export */ });
/* harmony import */ var _pad__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pad */ "../../node_modules/@rjsf/utils/lib/pad.js");

/** Converts a UTC date string into a local Date format
 *
 * @param jsonDate - A UTC date string
 * @returns - An empty string when `jsonDate` is falsey, otherwise a date string in local format
 */
function utcToLocal(jsonDate) {
    if (!jsonDate) {
        return '';
    }
    // required format of `'yyyy-MM-ddThh:mm' followed by optional ':ss' or ':ss.SSS'
    // https://html.spec.whatwg.org/multipage/input.html#local-date-and-time-state-(type%3Ddatetime-local)
    // > should be a _valid local date and time string_ (not GMT)
    // Note - date constructor passed local ISO-8601 does not correctly
    // change time to UTC in node pre-8
    const date = new Date(jsonDate);
    const yyyy = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getFullYear(), 4);
    const MM = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getMonth() + 1, 2);
    const dd = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getDate(), 2);
    const hh = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getHours(), 2);
    const mm = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getMinutes(), 2);
    const ss = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getSeconds(), 2);
    const SSS = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getMilliseconds(), 3);
    return `${yyyy}-${MM}-${dd}T${hh}:${mm}:${ss}.${SSS}`;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/validationDataMerge.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/validationDataMerge.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ validationDataMerge)
/* harmony export */ });
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mergeObjects__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mergeObjects */ "../../node_modules/@rjsf/utils/lib/mergeObjects.js");
/* harmony import */ var _toErrorList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./toErrorList */ "../../node_modules/@rjsf/utils/lib/toErrorList.js");



/** Merges the errors in `additionalErrorSchema` into the existing `validationData` by combining the hierarchies in the
 * two `ErrorSchema`s and then appending the error list from the `additionalErrorSchema` obtained by calling
 * `toErrorList()` on the `errors` in the `validationData`. If no `additionalErrorSchema` is passed, then
 * `validationData` is returned.
 *
 * @param validationData - The current `ValidationData` into which to merge the additional errors
 * @param [additionalErrorSchema] - The optional additional set of errors in an `ErrorSchema`
 * @returns - The `validationData` with the additional errors from `additionalErrorSchema` merged into it, if provided.
 */
function validationDataMerge(validationData, additionalErrorSchema) {
    if (!additionalErrorSchema) {
        return validationData;
    }
    const { errors: oldErrors, errorSchema: oldErrorSchema } = validationData;
    let errors = (0,_toErrorList__WEBPACK_IMPORTED_MODULE_2__["default"])(additionalErrorSchema);
    let errorSchema = additionalErrorSchema;
    if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default()(oldErrorSchema)) {
        errorSchema = (0,_mergeObjects__WEBPACK_IMPORTED_MODULE_1__["default"])(oldErrorSchema, additionalErrorSchema, true);
        errors = [...oldErrors].concat(errors);
    }
    return { errorSchema, errors };
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/withIdRefPrefix.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/withIdRefPrefix.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ withIdRefPrefix)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_1__);


/** Takes a `node` object and transforms any contained `$ref` node variables with a prefix, recursively calling
 * `withIdRefPrefix` for any other elements.
 *
 * @param node - The object node to which a ROOT_SCHEMA_PREFIX is added when a REF_KEY is part of it
 */
function withIdRefPrefixObject(node) {
    for (const key in node) {
        const realObj = node;
        const value = realObj[key];
        if (key === _constants__WEBPACK_IMPORTED_MODULE_0__.REF_KEY && typeof value === 'string' && value.startsWith('#')) {
            realObj[key] = _constants__WEBPACK_IMPORTED_MODULE_0__.ROOT_SCHEMA_PREFIX + value;
        }
        else {
            realObj[key] = withIdRefPrefix(value);
        }
    }
    return node;
}
/** Takes a `node` object list and transforms any contained `$ref` node variables with a prefix, recursively calling
 * `withIdRefPrefix` for any other elements.
 *
 * @param node - The list of object nodes to which a ROOT_SCHEMA_PREFIX is added when a REF_KEY is part of it
 */
function withIdRefPrefixArray(node) {
    for (let i = 0; i < node.length; i++) {
        node[i] = withIdRefPrefix(node[i]);
    }
    return node;
}
/** Recursively prefixes all `$ref`s in a schema with the value of the `ROOT_SCHEMA_PREFIX` constant.
 * This is used in isValid to make references to the rootSchema
 *
 * @param schemaNode - The object node to which a ROOT_SCHEMA_PREFIX is added when a REF_KEY is part of it
 * @returns - A copy of the `schemaNode` with updated `$ref`s
 */
function withIdRefPrefix(schemaNode) {
    if (Array.isArray(schemaNode)) {
        return withIdRefPrefixArray([...schemaNode]);
    }
    if (lodash_isObject__WEBPACK_IMPORTED_MODULE_1___default()(schemaNode)) {
        return withIdRefPrefixObject({ ...schemaNode });
    }
    return schemaNode;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/node_modules/react-is/cjs/react-is.development.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/node_modules/react-is/cjs/react-is.development.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
/**
 * @license React
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



if (true) {
  (function() {
'use strict';

// ATTENTION
// When adding new symbols to this file,
// Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'
// The Symbol used to tag the ReactElement-like types.
var REACT_ELEMENT_TYPE = Symbol.for('react.element');
var REACT_PORTAL_TYPE = Symbol.for('react.portal');
var REACT_FRAGMENT_TYPE = Symbol.for('react.fragment');
var REACT_STRICT_MODE_TYPE = Symbol.for('react.strict_mode');
var REACT_PROFILER_TYPE = Symbol.for('react.profiler');
var REACT_PROVIDER_TYPE = Symbol.for('react.provider');
var REACT_CONTEXT_TYPE = Symbol.for('react.context');
var REACT_SERVER_CONTEXT_TYPE = Symbol.for('react.server_context');
var REACT_FORWARD_REF_TYPE = Symbol.for('react.forward_ref');
var REACT_SUSPENSE_TYPE = Symbol.for('react.suspense');
var REACT_SUSPENSE_LIST_TYPE = Symbol.for('react.suspense_list');
var REACT_MEMO_TYPE = Symbol.for('react.memo');
var REACT_LAZY_TYPE = Symbol.for('react.lazy');
var REACT_OFFSCREEN_TYPE = Symbol.for('react.offscreen');

// -----------------------------------------------------------------------------

var enableScopeAPI = false; // Experimental Create Event Handle API.
var enableCacheElement = false;
var enableTransitionTracing = false; // No known bugs, but needs performance testing

var enableLegacyHidden = false; // Enables unstable_avoidThisFallback feature in Fiber
// stuff. Intended to enable React core members to more easily debug scheduling
// issues in DEV builds.

var enableDebugTracing = false; // Track which Fiber(s) schedule render work.

var REACT_MODULE_REFERENCE;

{
  REACT_MODULE_REFERENCE = Symbol.for('react.module.reference');
}

function isValidElementType(type) {
  if (typeof type === 'string' || typeof type === 'function') {
    return true;
  } // Note: typeof might be other than 'symbol' or 'number' (e.g. if it's a polyfill).


  if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || enableDebugTracing  || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || enableLegacyHidden  || type === REACT_OFFSCREEN_TYPE || enableScopeAPI  || enableCacheElement  || enableTransitionTracing ) {
    return true;
  }

  if (typeof type === 'object' && type !== null) {
    if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || // This needs to include all possible module reference object
    // types supported by any Flight configuration anywhere since
    // we don't know which Flight build this will end up being used
    // with.
    type.$$typeof === REACT_MODULE_REFERENCE || type.getModuleId !== undefined) {
      return true;
    }
  }

  return false;
}

function typeOf(object) {
  if (typeof object === 'object' && object !== null) {
    var $$typeof = object.$$typeof;

    switch ($$typeof) {
      case REACT_ELEMENT_TYPE:
        var type = object.type;

        switch (type) {
          case REACT_FRAGMENT_TYPE:
          case REACT_PROFILER_TYPE:
          case REACT_STRICT_MODE_TYPE:
          case REACT_SUSPENSE_TYPE:
          case REACT_SUSPENSE_LIST_TYPE:
            return type;

          default:
            var $$typeofType = type && type.$$typeof;

            switch ($$typeofType) {
              case REACT_SERVER_CONTEXT_TYPE:
              case REACT_CONTEXT_TYPE:
              case REACT_FORWARD_REF_TYPE:
              case REACT_LAZY_TYPE:
              case REACT_MEMO_TYPE:
              case REACT_PROVIDER_TYPE:
                return $$typeofType;

              default:
                return $$typeof;
            }

        }

      case REACT_PORTAL_TYPE:
        return $$typeof;
    }
  }

  return undefined;
}
var ContextConsumer = REACT_CONTEXT_TYPE;
var ContextProvider = REACT_PROVIDER_TYPE;
var Element = REACT_ELEMENT_TYPE;
var ForwardRef = REACT_FORWARD_REF_TYPE;
var Fragment = REACT_FRAGMENT_TYPE;
var Lazy = REACT_LAZY_TYPE;
var Memo = REACT_MEMO_TYPE;
var Portal = REACT_PORTAL_TYPE;
var Profiler = REACT_PROFILER_TYPE;
var StrictMode = REACT_STRICT_MODE_TYPE;
var Suspense = REACT_SUSPENSE_TYPE;
var SuspenseList = REACT_SUSPENSE_LIST_TYPE;
var hasWarnedAboutDeprecatedIsAsyncMode = false;
var hasWarnedAboutDeprecatedIsConcurrentMode = false; // AsyncMode should be deprecated

function isAsyncMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
      hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

      console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 18+.');
    }
  }

  return false;
}
function isConcurrentMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsConcurrentMode) {
      hasWarnedAboutDeprecatedIsConcurrentMode = true; // Using console['warn'] to evade Babel and ESLint

      console['warn']('The ReactIs.isConcurrentMode() alias has been deprecated, ' + 'and will be removed in React 18+.');
    }
  }

  return false;
}
function isContextConsumer(object) {
  return typeOf(object) === REACT_CONTEXT_TYPE;
}
function isContextProvider(object) {
  return typeOf(object) === REACT_PROVIDER_TYPE;
}
function isElement(object) {
  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
}
function isForwardRef(object) {
  return typeOf(object) === REACT_FORWARD_REF_TYPE;
}
function isFragment(object) {
  return typeOf(object) === REACT_FRAGMENT_TYPE;
}
function isLazy(object) {
  return typeOf(object) === REACT_LAZY_TYPE;
}
function isMemo(object) {
  return typeOf(object) === REACT_MEMO_TYPE;
}
function isPortal(object) {
  return typeOf(object) === REACT_PORTAL_TYPE;
}
function isProfiler(object) {
  return typeOf(object) === REACT_PROFILER_TYPE;
}
function isStrictMode(object) {
  return typeOf(object) === REACT_STRICT_MODE_TYPE;
}
function isSuspense(object) {
  return typeOf(object) === REACT_SUSPENSE_TYPE;
}
function isSuspenseList(object) {
  return typeOf(object) === REACT_SUSPENSE_LIST_TYPE;
}

exports.ContextConsumer = ContextConsumer;
exports.ContextProvider = ContextProvider;
exports.Element = Element;
exports.ForwardRef = ForwardRef;
exports.Fragment = Fragment;
exports.Lazy = Lazy;
exports.Memo = Memo;
exports.Portal = Portal;
exports.Profiler = Profiler;
exports.StrictMode = StrictMode;
exports.Suspense = Suspense;
exports.SuspenseList = SuspenseList;
exports.isAsyncMode = isAsyncMode;
exports.isConcurrentMode = isConcurrentMode;
exports.isContextConsumer = isContextConsumer;
exports.isContextProvider = isContextProvider;
exports.isElement = isElement;
exports.isForwardRef = isForwardRef;
exports.isFragment = isFragment;
exports.isLazy = isLazy;
exports.isMemo = isMemo;
exports.isPortal = isPortal;
exports.isProfiler = isProfiler;
exports.isStrictMode = isStrictMode;
exports.isSuspense = isSuspense;
exports.isSuspenseList = isSuspenseList;
exports.isValidElementType = isValidElementType;
exports.typeOf = typeOf;
  })();
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/node_modules/react-is/index.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/node_modules/react-is/index.js ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


if (false) {} else {
  module.exports = __webpack_require__(/*! ./cjs/react-is.development.js */ "../../node_modules/@rjsf/utils/node_modules/react-is/cjs/react-is.development.js");
}


/***/ }),

/***/ "../../node_modules/compute-gcd/lib/index.js":
/*!***************************************************!*\
  !*** ../../node_modules/compute-gcd/lib/index.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


// MODULES //

var isArray = __webpack_require__( /*! validate.io-array */ "../../node_modules/validate.io-array/lib/index.js" ),
	isIntegerArray = __webpack_require__( /*! validate.io-integer-array */ "../../node_modules/validate.io-integer-array/lib/index.js" ),
	isFunction = __webpack_require__( /*! validate.io-function */ "../../node_modules/validate.io-function/lib/index.js" );


// VARIABLES //

var MAXINT = Math.pow( 2, 31 ) - 1;


// FUNCTIONS //

/**
* FUNCTION: gcd( a, b )
*	Computes the greatest common divisor of two integers `a` and `b`, using the binary GCD algorithm.
*
* @param {Number} a - integer
* @param {Number} b - integer
* @returns {Number} greatest common divisor
*/
function gcd( a, b ) {
	var k = 1,
		t;
	// Simple cases:
	if ( a === 0 ) {
		return b;
	}
	if ( b === 0 ) {
		return a;
	}
	// Reduce `a` and/or `b` to odd numbers and keep track of the greatest power of 2 dividing both `a` and `b`...
	while ( a%2 === 0 && b%2 === 0 ) {
		a = a / 2; // right shift
		b = b / 2; // right shift
		k = k * 2; // left shift
	}
	// Reduce `a` to an odd number...
	while ( a%2 === 0 ) {
		a = a / 2; // right shift
	}
	// Henceforth, `a` is always odd...
	while ( b ) {
		// Remove all factors of 2 in `b`, as they are not common...
		while ( b%2 === 0 ) {
			b = b / 2; // right shift
		}
		// `a` and `b` are both odd. Swap values such that `b` is the larger of the two values, and then set `b` to the difference (which is even)...
		if ( a > b ) {
			t = b;
			b = a;
			a = t;
		}
		b = b - a; // b=0 iff b=a
	}
	// Restore common factors of 2...
	return k * a;
} // end FUNCTION gcd()

/**
* FUNCTION: bitwise( a, b )
*	Computes the greatest common divisor of two integers `a` and `b`, using the binary GCD algorithm and bitwise operations.
*
* @param {Number} a - safe integer
* @param {Number} b - safe integer
* @returns {Number} greatest common divisor
*/
function bitwise( a, b ) {
	var k = 0,
		t;
	// Simple cases:
	if ( a === 0 ) {
		return b;
	}
	if ( b === 0 ) {
		return a;
	}
	// Reduce `a` and/or `b` to odd numbers and keep track of the greatest power of 2 dividing both `a` and `b`...
	while ( (a & 1) === 0 && (b & 1) === 0 ) {
		a >>>= 1; // right shift
		b >>>= 1; // right shift
		k++;
	}
	// Reduce `a` to an odd number...
	while ( (a & 1) === 0 ) {
		a >>>= 1; // right shift
	}
	// Henceforth, `a` is always odd...
	while ( b ) {
		// Remove all factors of 2 in `b`, as they are not common...
		while ( (b & 1) === 0 ) {
			b >>>= 1; // right shift
		}
		// `a` and `b` are both odd. Swap values such that `b` is the larger of the two values, and then set `b` to the difference (which is even)...
		if ( a > b ) {
			t = b;
			b = a;
			a = t;
		}
		b = b - a; // b=0 iff b=a
	}
	// Restore common factors of 2...
	return a << k;
} // end FUNCTION bitwise()


// GREATEST COMMON DIVISOR //

/**
* FUNCTION: compute( arr[, clbk] )
*	Computes the greatest common divisor.
*
* @param {Number[]|Number} arr - input array of integers
* @param {Function|Number} [clbk] - accessor function for accessing array values
* @returns {Number|Null} greatest common divisor or null
*/
function compute() {
	var nargs = arguments.length,
		args,
		clbk,
		arr,
		len,
		a, b,
		i;

	// Copy the input arguments to an array...
	args = new Array( nargs );
	for ( i = 0; i < nargs; i++ ) {
		args[ i ] = arguments[ i ];
	}
	// Have we been provided with integer arguments?
	if ( isIntegerArray( args ) ) {
		if ( nargs === 2 ) {
			a = args[ 0 ];
			b = args[ 1 ];
			if ( a < 0 ) {
				a = -a;
			}
			if ( b < 0 ) {
				b = -b;
			}
			if ( a <= MAXINT && b <= MAXINT ) {
				return bitwise( a, b );
			} else {
				return gcd( a, b );
			}
		}
		arr = args;
	}
	// If not integers, ensure the first argument is an array...
	else if ( !isArray( args[ 0 ] ) ) {
		throw new TypeError( 'gcd()::invalid input argument. Must provide an array of integers. Value: `' + args[ 0 ] + '`.' );
	}
	// Have we been provided with more than one argument? If so, ensure that the accessor argument is a function...
	else if ( nargs > 1 ) {
		arr = args[ 0 ];
		clbk = args[ 1 ];
		if ( !isFunction( clbk ) ) {
			throw new TypeError( 'gcd()::invalid input argument. Accessor must be a function. Value: `' + clbk + '`.' );
		}
	}
	// We have been provided an array...
	else {
		arr = args[ 0 ];
	}
	len = arr.length;

	// Check if a sufficient number of values have been provided...
	if ( len < 2 ) {
		return null;
	}
	// If an accessor is provided, extract the array values...
	if ( clbk ) {
		a = new Array( len );
		for ( i = 0; i < len; i++ ) {
			a[ i ] = clbk( arr[ i ], i );
		}
		arr = a;
	}
	// Given an input array, ensure all array values are integers...
	if ( nargs < 3 ) {
		if ( !isIntegerArray( arr ) ) {
			throw new TypeError( 'gcd()::invalid input argument. Accessed array values must be integers. Value: `' + arr + '`.' );
		}
	}
	// Convert any negative integers to positive integers...
	for ( i = 0; i < len; i++ ) {
		a = arr[ i ];
		if ( a < 0 ) {
			arr[ i ] = -a;
		}
	}
	// Exploit the fact that the gcd is an associative function...
	a = arr[ 0 ];
	for ( i = 1; i < len; i++ ) {
		b = arr[ i ];
		if ( b <= MAXINT && a <= MAXINT ) {
			a = bitwise( a, b );
		} else {
			a = gcd( a, b );
		}
	}
	return a;
} // end FUNCTION compute()


// EXPORTS //

module.exports = compute;


/***/ }),

/***/ "../../node_modules/compute-lcm/lib/index.js":
/*!***************************************************!*\
  !*** ../../node_modules/compute-lcm/lib/index.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


// MODULES //

var gcd = __webpack_require__( /*! compute-gcd */ "../../node_modules/compute-gcd/lib/index.js" ),
	isArray = __webpack_require__( /*! validate.io-array */ "../../node_modules/validate.io-array/lib/index.js" ),
	isIntegerArray = __webpack_require__( /*! validate.io-integer-array */ "../../node_modules/validate.io-integer-array/lib/index.js" ),
	isFunction = __webpack_require__( /*! validate.io-function */ "../../node_modules/validate.io-function/lib/index.js" );


// LEAST COMMON MULTIPLE //

/**
* FUNCTION: lcm( arr[, clbk] )
*	Computes the least common multiple (lcm).
*
* @param {Number[]|Number} arr - input array of integers
* @param {Function|Number} [accessor] - accessor function for accessing array values
* @returns {Number|Null} least common multiple or null
*/
function lcm() {
	var nargs = arguments.length,
		args,
		clbk,
		arr,
		len,
		a, b,
		i;

	// Copy the input arguments to an array...
	args = new Array( nargs );
	for ( i = 0; i < nargs; i++ ) {
		args[ i ] = arguments[ i ];
	}
	// Have we been provided with integer arguments?
	if ( isIntegerArray( args ) ) {
		if ( nargs === 2 ) {
			a = args[ 0 ];
			b = args[ 1 ];
			if ( a < 0 ) {
				a = -a;
			}
			if ( b < 0 ) {
				b = -b;
			}
			if ( a === 0 || b === 0 ) {
				return 0;
			}
			return ( a/gcd(a,b) ) * b;
		}
		arr = args;
	}
	// If not integers, ensure that the first argument is an array...
	else if ( !isArray( args[ 0 ] ) ) {
		throw new TypeError( 'lcm()::invalid input argument. Must provide an array of integers. Value: `' + args[ 0 ] + '`.' );
	}
	// Have we been provided with more than one argument? If so, ensure that the accessor argument is a function...
	else if ( nargs > 1 ) {
		arr = args[ 0 ];
		clbk = args[ 1 ];
		if ( !isFunction( clbk ) ) {
			throw new TypeError( 'lcm()::invalid input argument. Accessor must be a function. Value: `' + clbk + '`.' );
		}
	}
	// We have been provided an array...
	else {
		arr = args[ 0 ];
	}
	len = arr.length;

	// Check if a sufficient number of values have been provided...
	if ( len < 2 ) {
		return null;
	}
	// If an accessor is provided, extract the array values...
	if ( clbk ) {
		a = new Array( len );
		for ( i = 0; i < len; i++ ) {
			a[ i ] = clbk( arr[ i ], i );
		}
		arr = a;
	}
	// Given an input array, ensure all array values are integers...
	if ( nargs < 3 ) {
		if ( !isIntegerArray( arr ) ) {
			throw new TypeError( 'lcm()::invalid input argument. Accessed array values must be integers. Value: `' + arr + '`.' );
		}
	}
	// Convert any negative integers to positive integers...
	for ( i = 0; i < len; i++ ) {
		a = arr[ i ];
		if ( a < 0 ) {
			arr[ i ] = -a;
		}
	}
	// Exploit the fact that the lcm is an associative function...
	a = arr[ 0 ];
	for ( i = 1; i < len; i++ ) {
		b = arr[ i ];
		if ( a === 0 || b === 0 ) {
			return 0;
		}
		a = ( a/gcd(a,b) ) * b;
	}
	return a;
} // end FUNCTION lcm()


// EXPORTS //

module.exports = lcm;


/***/ }),

/***/ "../../node_modules/json-schema-compare/src/index.js":
/*!***********************************************************!*\
  !*** ../../node_modules/json-schema-compare/src/index.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isEqual = __webpack_require__(/*! lodash/isEqual */ "../../node_modules/lodash/isEqual.js")
var sortBy = __webpack_require__(/*! lodash/sortBy */ "../../node_modules/lodash/sortBy.js")
var uniq = __webpack_require__(/*! lodash/uniq */ "../../node_modules/lodash/uniq.js")
var uniqWith = __webpack_require__(/*! lodash/uniqWith */ "../../node_modules/lodash/uniqWith.js")
var defaults = __webpack_require__(/*! lodash/defaults */ "../../node_modules/lodash/defaults.js")
var intersectionWith = __webpack_require__(/*! lodash/intersectionWith */ "../../node_modules/lodash/intersectionWith.js")
var isPlainObject = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js")
var isBoolean = __webpack_require__(/*! lodash/isBoolean */ "../../node_modules/lodash/isBoolean.js")

var normalizeArray = val => Array.isArray(val)
  ? val : [val]
var undef = val => val === undefined
var keys = obj => isPlainObject(obj) || Array.isArray(obj) ? Object.keys(obj) : []
var has = (obj, key) => obj.hasOwnProperty(key)
var stringArray = arr => sortBy(uniq(arr))
var undefEmpty = val => undef(val) || (Array.isArray(val) && val.length === 0)
var keyValEqual = (a, b, key, compare) => b && has(b, key) && a && has(a, key) && compare(a[key], b[key])
var undefAndZero = (a, b) => (undef(a) && b === 0) || (undef(b) && a === 0) || isEqual(a, b)
var falseUndefined = (a, b) => (undef(a) && b === false) || (undef(b) && a === false) || isEqual(a, b)
var emptySchema = schema => undef(schema) || isEqual(schema, {}) || schema === true
var emptyObjUndef = schema => undef(schema) || isEqual(schema, {})
var isSchema = val => undef(val) || isPlainObject(val) || val === true || val === false

function undefArrayEqual(a, b) {
  if (undefEmpty(a) && undefEmpty(b)) {
    return true
  } else {
    return isEqual(stringArray(a), stringArray(b))
  }
}

function unsortedNormalizedArray(a, b) {
  a = normalizeArray(a)
  b = normalizeArray(b)
  return isEqual(stringArray(a), stringArray(b))
}

function schemaGroup(a, b, key, compare) {
  var allProps = uniq(keys(a).concat(keys(b)))
  if (emptyObjUndef(a) && emptyObjUndef(b)) {
    return true
  } else if (emptyObjUndef(a) && keys(b).length) {
    return false
  } else if (emptyObjUndef(b) && keys(a).length) {
    return false
  }

  return allProps.every(function(key) {
    var aVal = a[key]
    var bVal = b[key]
    if (Array.isArray(aVal) && Array.isArray(bVal)) {
      return isEqual(stringArray(a), stringArray(b))
    } else if (Array.isArray(aVal) && !Array.isArray(bVal)) {
      return false
    } else if (Array.isArray(bVal) && !Array.isArray(aVal)) {
      return false
    }
    return keyValEqual(a, b, key, compare)
  })
}

function items(a, b, key, compare) {
  if (isPlainObject(a) && isPlainObject(b)) {
    return compare(a, b)
  } else if (Array.isArray(a) && Array.isArray(b)) {
    return schemaGroup(a, b, key, compare)
  } else {
    return isEqual(a, b)
  }
}

function unsortedArray(a, b, key, compare) {
  var uniqueA = uniqWith(a, compare)
  var uniqueB = uniqWith(b, compare)
  var inter = intersectionWith(uniqueA, uniqueB, compare)
  return inter.length === Math.max(uniqueA.length, uniqueB.length)
}

var comparers = {
  title: isEqual,
  uniqueItems: falseUndefined,
  minLength: undefAndZero,
  minItems: undefAndZero,
  minProperties: undefAndZero,
  required: undefArrayEqual,
  enum: undefArrayEqual,
  type: unsortedNormalizedArray,
  items: items,
  anyOf: unsortedArray,
  allOf: unsortedArray,
  oneOf: unsortedArray,
  properties: schemaGroup,
  patternProperties: schemaGroup,
  dependencies: schemaGroup
}

var acceptsUndefined = [
  'properties',
  'patternProperties',
  'dependencies',
  'uniqueItems',
  'minLength',
  'minItems',
  'minProperties',
  'required'
]

var schemaProps = ['additionalProperties', 'additionalItems', 'contains', 'propertyNames', 'not']

function compare(a, b, options) {
  options = defaults(options, {
    ignore: []
  })

  if (emptySchema(a) && emptySchema(b)) {
    return true
  }

  if (!isSchema(a) || !isSchema(b)) {
    throw new Error('Either of the values are not a JSON schema.')
  }
  if (a === b) {
    return true
  }

  if (isBoolean(a) && isBoolean(b)) {
    return a === b
  }

  if ((a === undefined && b === false) || (b === undefined && a === false)) {
    return false
  }

  if ((undef(a) && !undef(b)) || (!undef(a) && undef(b))) {
    return false
  }

  var allKeys = uniq(Object.keys(a).concat(Object.keys(b)))

  if (options.ignore.length) {
    allKeys = allKeys.filter(k => options.ignore.indexOf(k) === -1)
  }

  if (!allKeys.length) {
    return true
  }

  function innerCompare(a, b) {
    return compare(a, b, options)
  }

  return allKeys.every(function(key) {
    var aValue = a[key]
    var bValue = b[key]

    if (schemaProps.indexOf(key) !== -1) {
      return compare(aValue, bValue, options)
    }

    var comparer = comparers[key]
    if (!comparer) {
      comparer = isEqual
    }

    // do simple lodash check first
    if (isEqual(aValue, bValue)) {
      return true
    }

    if (acceptsUndefined.indexOf(key) === -1) {
      if ((!has(a, key) && has(b, key)) || (has(a, key) && !has(b, key))) {
        return aValue === bValue
      }
    }

    var result = comparer(aValue, bValue, key, innerCompare)
    if (!isBoolean(result)) {
      throw new Error('Comparer must return true or false')
    }
    return result
  })
}

module.exports = compare


/***/ }),

/***/ "../../node_modules/json-schema-merge-allof/src/common.js":
/*!****************************************************************!*\
  !*** ../../node_modules/json-schema-merge-allof/src/common.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const flatten = __webpack_require__(/*! lodash/flatten */ "../../node_modules/lodash/flatten.js")
const flattenDeep = __webpack_require__(/*! lodash/flattenDeep */ "../../node_modules/lodash/flattenDeep.js")
const isPlainObject = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js")
const uniq = __webpack_require__(/*! lodash/uniq */ "../../node_modules/lodash/uniq.js")
const uniqWith = __webpack_require__(/*! lodash/uniqWith */ "../../node_modules/lodash/uniqWith.js")
const without = __webpack_require__(/*! lodash/without */ "../../node_modules/lodash/without.js")

function deleteUndefinedProps(returnObject) {
  // cleanup empty
  for (const prop in returnObject) {
    if (has(returnObject, prop) && isEmptySchema(returnObject[prop])) {
      delete returnObject[prop]
    }
  }
  return returnObject
}

const allUniqueKeys = (arr) => uniq(flattenDeep(arr.map(keys)))
const getValues = (schemas, key) => schemas.map(schema => schema && schema[key])
const has = (obj, propName) => Object.prototype.hasOwnProperty.call(obj, propName)
const keys = obj => {
  if (isPlainObject(obj) || Array.isArray(obj)) {
    return Object.keys(obj)
  } else {
    return []
  }
}

const notUndefined = (val) => val !== undefined
const isSchema = (val) => isPlainObject(val) || val === true || val === false
const isEmptySchema = (obj) => (!keys(obj).length) && obj !== false && obj !== true
const withoutArr = (arr, ...rest) => without.apply(null, [arr].concat(flatten(rest)))

module.exports = {
  allUniqueKeys,
  deleteUndefinedProps,
  getValues,
  has,
  isEmptySchema,
  isSchema,
  keys,
  notUndefined,
  uniqWith,
  withoutArr
}


/***/ }),

/***/ "../../node_modules/json-schema-merge-allof/src/complex-resolvers/items.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/json-schema-merge-allof/src/complex-resolvers/items.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


const compare = __webpack_require__(/*! json-schema-compare */ "../../node_modules/json-schema-compare/src/index.js")
const forEach = __webpack_require__(/*! lodash/forEach */ "../../node_modules/lodash/forEach.js")
const {
  allUniqueKeys,
  deleteUndefinedProps,
  has,
  isSchema,
  notUndefined,
  uniqWith
} = __webpack_require__(/*! ../common */ "../../node_modules/json-schema-merge-allof/src/common.js")

function removeFalseSchemasFromArray(target) {
  forEach(target, function(schema, index) {
    if (schema === false) {
      target.splice(index, 1)
    }
  })
}

function getItemSchemas(subSchemas, key) {
  return subSchemas.map(function(sub) {
    if (!sub) {
      return undefined
    }

    if (Array.isArray(sub.items)) {
      const schemaAtPos = sub.items[key]
      if (isSchema(schemaAtPos)) {
        return schemaAtPos
      } else if (has(sub, 'additionalItems')) {
        return sub.additionalItems
      }
    } else {
      return sub.items
    }

    return undefined
  })
}

function getAdditionalSchemas(subSchemas) {
  return subSchemas.map(function(sub) {
    if (!sub) {
      return undefined
    }
    if (Array.isArray(sub.items)) {
      return sub.additionalItems
    }
    return sub.items
  })
}

// Provide source when array
function mergeItems(group, mergeSchemas, items) {
  const allKeys = allUniqueKeys(items)
  return allKeys.reduce(function(all, key) {
    const schemas = getItemSchemas(group, key)
    const compacted = uniqWith(schemas.filter(notUndefined), compare)
    all[key] = mergeSchemas(compacted, key)
    return all
  }, [])
}

module.exports = {
  keywords: ['items', 'additionalItems'],
  resolver(values, parents, mergers) {
    // const createSubMerger = groupKey => (schemas, key) => mergeSchemas(schemas, parents.concat(groupKey, key))
    const items = values.map(s => s.items)
    const itemsCompacted = items.filter(notUndefined)
    const returnObject = {}

    // if all items keyword values are schemas, we can merge them as simple schemas
    // if not we need to merge them as mixed
    if (itemsCompacted.every(isSchema)) {
      returnObject.items = mergers.items(items)
    } else {
      returnObject.items = mergeItems(values, mergers.items, items)
    }

    let schemasAtLastPos
    if (itemsCompacted.every(Array.isArray)) {
      schemasAtLastPos = values.map(s => s.additionalItems)
    } else if (itemsCompacted.some(Array.isArray)) {
      schemasAtLastPos = getAdditionalSchemas(values)
    }

    if (schemasAtLastPos) {
      returnObject.additionalItems = mergers.additionalItems(schemasAtLastPos)
    }

    if (returnObject.additionalItems === false && Array.isArray(returnObject.items)) {
      removeFalseSchemasFromArray(returnObject.items)
    }

    return deleteUndefinedProps(returnObject)
  }
}


/***/ }),

/***/ "../../node_modules/json-schema-merge-allof/src/complex-resolvers/properties.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/json-schema-merge-allof/src/complex-resolvers/properties.js ***!
  \**************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


const compare = __webpack_require__(/*! json-schema-compare */ "../../node_modules/json-schema-compare/src/index.js")
const forEach = __webpack_require__(/*! lodash/forEach */ "../../node_modules/lodash/forEach.js")
const {
  allUniqueKeys,
  deleteUndefinedProps,
  getValues,
  keys,
  notUndefined,
  uniqWith,
  withoutArr
} = __webpack_require__(/*! ../common */ "../../node_modules/json-schema-merge-allof/src/common.js")

function removeFalseSchemas(target) {
  forEach(target, function(schema, prop) {
    if (schema === false) {
      delete target[prop]
    }
  })
}

function mergeSchemaGroup(group, mergeSchemas) {
  const allKeys = allUniqueKeys(group)
  return allKeys.reduce(function(all, key) {
    const schemas = getValues(group, key)
    const compacted = uniqWith(schemas.filter(notUndefined), compare)
    all[key] = mergeSchemas(compacted, key)
    return all
  }, {})
}

module.exports = {
  keywords: ['properties', 'patternProperties', 'additionalProperties'],
  resolver(values, parents, mergers, options) {
    // first get rid of all non permitted properties
    if (!options.ignoreAdditionalProperties) {
      values.forEach(function(subSchema) {
        const otherSubSchemas = values.filter(s => s !== subSchema)
        const ownKeys = keys(subSchema.properties)
        const ownPatternKeys = keys(subSchema.patternProperties)
        const ownPatterns = ownPatternKeys.map(k => new RegExp(k))
        otherSubSchemas.forEach(function(other) {
          const allOtherKeys = keys(other.properties)
          const keysMatchingPattern = allOtherKeys.filter(k => ownPatterns.some(pk => pk.test(k)))
          const additionalKeys = withoutArr(allOtherKeys, ownKeys, keysMatchingPattern)
          additionalKeys.forEach(function(key) {
            other.properties[key] = mergers.properties([
              other.properties[key], subSchema.additionalProperties
            ], key)
          })
        })
      })

      // remove disallowed patternProperties
      values.forEach(function(subSchema) {
        const otherSubSchemas = values.filter(s => s !== subSchema)
        const ownPatternKeys = keys(subSchema.patternProperties)
        if (subSchema.additionalProperties === false) {
          otherSubSchemas.forEach(function(other) {
            const allOtherPatterns = keys(other.patternProperties)
            const additionalPatternKeys = withoutArr(allOtherPatterns, ownPatternKeys)
            additionalPatternKeys.forEach(key => delete other.patternProperties[key])
          })
        }
      })
    }

    const returnObject = {
      additionalProperties: mergers.additionalProperties(values.map(s => s.additionalProperties)),
      patternProperties: mergeSchemaGroup(values.map(s => s.patternProperties), mergers.patternProperties),
      properties: mergeSchemaGroup(values.map(s => s.properties), mergers.properties)
    }

    if (returnObject.additionalProperties === false) {
      removeFalseSchemas(returnObject.properties)
    }

    return deleteUndefinedProps(returnObject)
  }
}


/***/ }),

/***/ "../../node_modules/json-schema-merge-allof/src/index.js":
/*!***************************************************************!*\
  !*** ../../node_modules/json-schema-merge-allof/src/index.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const cloneDeep = __webpack_require__(/*! lodash/cloneDeep */ "../../node_modules/lodash/cloneDeep.js")
const compare = __webpack_require__(/*! json-schema-compare */ "../../node_modules/json-schema-compare/src/index.js")
const computeLcm = __webpack_require__(/*! compute-lcm */ "../../node_modules/compute-lcm/lib/index.js")
const defaultsDeep = __webpack_require__(/*! lodash/defaultsDeep */ "../../node_modules/lodash/defaultsDeep.js")
const flatten = __webpack_require__(/*! lodash/flatten */ "../../node_modules/lodash/flatten.js")
const flattenDeep = __webpack_require__(/*! lodash/flattenDeep */ "../../node_modules/lodash/flattenDeep.js")
const intersection = __webpack_require__(/*! lodash/intersection */ "../../node_modules/lodash/intersection.js")
const intersectionWith = __webpack_require__(/*! lodash/intersectionWith */ "../../node_modules/lodash/intersectionWith.js")
const isEqual = __webpack_require__(/*! lodash/isEqual */ "../../node_modules/lodash/isEqual.js")
const isPlainObject = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js")
const pullAll = __webpack_require__(/*! lodash/pullAll */ "../../node_modules/lodash/pullAll.js")
const sortBy = __webpack_require__(/*! lodash/sortBy */ "../../node_modules/lodash/sortBy.js")
const uniq = __webpack_require__(/*! lodash/uniq */ "../../node_modules/lodash/uniq.js")
const uniqWith = __webpack_require__(/*! lodash/uniqWith */ "../../node_modules/lodash/uniqWith.js")

const propertiesResolver = __webpack_require__(/*! ./complex-resolvers/properties */ "../../node_modules/json-schema-merge-allof/src/complex-resolvers/properties.js")
const itemsResolver = __webpack_require__(/*! ./complex-resolvers/items */ "../../node_modules/json-schema-merge-allof/src/complex-resolvers/items.js")

const contains = (arr, val) => arr.indexOf(val) !== -1
const isSchema = (val) => isPlainObject(val) || val === true || val === false
const isFalse = (val) => val === false
const isTrue = (val) => val === true
const schemaResolver = (compacted, key, mergeSchemas) => mergeSchemas(compacted)
const stringArray = (values) => sortBy(uniq(flattenDeep(values)))
const notUndefined = (val) => val !== undefined
const allUniqueKeys = (arr) => uniq(flattenDeep(arr.map(keys)))

// resolvers
const first = compacted => compacted[0]
const required = compacted => stringArray(compacted)
const maximumValue = compacted => Math.max.apply(Math, compacted)
const minimumValue = compacted => Math.min.apply(Math, compacted)
const uniqueItems = compacted => compacted.some(isTrue)
const examples = compacted => uniqWith(flatten(compacted), isEqual)

function compareProp(key) {
  return function(a, b) {
    return compare({
      [key]: a
    }, { [key]: b })
  }
}

function getAllOf(schema) {
  let { allOf = [], ...copy } = schema
  copy = isPlainObject(schema) ? copy : schema // if schema is boolean
  return [copy, ...allOf.map(getAllOf)]
}

function getValues(schemas, key) {
  return schemas.map(schema => schema && schema[key])
}

function tryMergeSchemaGroups(schemaGroups, mergeSchemas) {
  return schemaGroups.map(function(schemas, index) {
    try {
      return mergeSchemas(schemas, index)
    } catch (e) {
      return undefined
    }
  }).filter(notUndefined)
}

function keys(obj) {
  if (isPlainObject(obj) || Array.isArray(obj)) {
    return Object.keys(obj)
  } else {
    return []
  }
}

function getAnyOfCombinations(arrOfArrays, combinations) {
  combinations = combinations || []
  if (!arrOfArrays.length) {
    return combinations
  }

  const values = arrOfArrays.slice(0).shift()
  const rest = arrOfArrays.slice(1)
  if (combinations.length) {
    return getAnyOfCombinations(rest, flatten(combinations.map(combination => values.map(item => ([item].concat(combination))))))
  }
  return getAnyOfCombinations(rest, values.map(item => (item)))
}

function throwIncompatible(values, paths) {
  let asJSON
  try {
    asJSON = values.map(function(val) {
      return JSON.stringify(val, null, 2)
    }).join('\n')
  } catch (variable) {
    asJSON = values.join(', ')
  }
  throw new Error('Could not resolve values for path:"' + paths.join('.') + '". They are probably incompatible. Values: \n' + asJSON)
}

function callGroupResolver(complexKeywords, resolverName, schemas, mergeSchemas, options, parents) {
  if (complexKeywords.length) {
    const resolverConfig = options.complexResolvers[resolverName]
    if (!resolverConfig || !resolverConfig.resolver) {
      throw new Error('No resolver found for ' + resolverName)
    }

    // extract all keywords from all the schemas that have one or more
    // then remove all undefined ones and not unique
    const extractedKeywordsOnly = schemas.map(schema => complexKeywords.reduce((all, key) => {
      if (schema[key] !== undefined) all[key] = schema[key]
      return all
    }, {}))
    const unique = uniqWith(extractedKeywordsOnly, compare)

    // create mergers that automatically add the path of the keyword for use in the complex resolver
    const mergers = resolverConfig.keywords.reduce((all, key) => ({
      ...all,
      [key]: (schemas, extraKey = []) => mergeSchemas(schemas, null, parents.concat(key, extraKey))
    }), {})

    const result = resolverConfig.resolver(unique, parents.concat(resolverName), mergers, options)

    if (!isPlainObject(result)) {
      throwIncompatible(unique, parents.concat(resolverName))
    }

    return result
  }
}

function createRequiredMetaArray(arr) {
  return { required: arr }
}

const schemaGroupProps = ['properties', 'patternProperties', 'definitions', 'dependencies']
const schemaArrays = ['anyOf', 'oneOf']
const schemaProps = [
  'additionalProperties',
  'additionalItems',
  'contains',
  'propertyNames',
  'not',
  'items'
]

const defaultResolvers = {
  type(compacted) {
    if (compacted.some(Array.isArray)) {
      const normalized = compacted.map(function(val) {
        return Array.isArray(val)
          ? val
          : [val]
      })
      const common = intersection.apply(null, normalized)

      if (common.length === 1) {
        return common[0]
      } else if (common.length > 1) {
        return uniq(common)
      }
    }
  },
  dependencies(compacted, paths, mergeSchemas) {
    const allChildren = allUniqueKeys(compacted)

    return allChildren.reduce(function(all, childKey) {
      const childSchemas = getValues(compacted, childKey)
      let innerCompacted = uniqWith(childSchemas.filter(notUndefined), isEqual)

      // to support dependencies
      const innerArrays = innerCompacted.filter(Array.isArray)

      if (innerArrays.length) {
        if (innerArrays.length === innerCompacted.length) {
          all[childKey] = stringArray(innerCompacted)
        } else {
          const innerSchemas = innerCompacted.filter(isSchema)
          const arrayMetaScheams = innerArrays.map(createRequiredMetaArray)
          all[childKey] = mergeSchemas(innerSchemas.concat(arrayMetaScheams), childKey)
        }
        return all
      }

      innerCompacted = uniqWith(innerCompacted, compare)

      all[childKey] = mergeSchemas(innerCompacted, childKey)
      return all
    }, {})
  },
  oneOf(compacted, paths, mergeSchemas) {
    const combinations = getAnyOfCombinations(cloneDeep(compacted))
    const result = tryMergeSchemaGroups(combinations, mergeSchemas)
    const unique = uniqWith(result, compare)

    if (unique.length) {
      return unique
    }
  },
  not(compacted) {
    return { anyOf: compacted }
  },
  pattern(compacted) {
    return compacted.map(r => '(?=' + r + ')').join('')
  },
  multipleOf(compacted) {
    let integers = compacted.slice(0)
    let factor = 1
    while (integers.some(n => !Number.isInteger(n))) {
      integers = integers.map(n => n * 10)
      factor = factor * 10
    }
    return computeLcm(integers) / factor
  },
  enum(compacted) {
    const enums = intersectionWith.apply(null, compacted.concat(isEqual))
    if (enums.length) {
      return sortBy(enums)
    }
  }
}

defaultResolvers.$id = first
defaultResolvers.$ref = first
defaultResolvers.$schema = first
defaultResolvers.additionalItems = schemaResolver
defaultResolvers.additionalProperties = schemaResolver
defaultResolvers.anyOf = defaultResolvers.oneOf
defaultResolvers.contains = schemaResolver
defaultResolvers.default = first
defaultResolvers.definitions = defaultResolvers.dependencies
defaultResolvers.description = first
defaultResolvers.examples = examples
defaultResolvers.exclusiveMaximum = minimumValue
defaultResolvers.exclusiveMinimum = maximumValue
defaultResolvers.items = itemsResolver
defaultResolvers.maximum = minimumValue
defaultResolvers.maxItems = minimumValue
defaultResolvers.maxLength = minimumValue
defaultResolvers.maxProperties = minimumValue
defaultResolvers.minimum = maximumValue
defaultResolvers.minItems = maximumValue
defaultResolvers.minLength = maximumValue
defaultResolvers.minProperties = maximumValue
defaultResolvers.properties = propertiesResolver
defaultResolvers.propertyNames = schemaResolver
defaultResolvers.required = required
defaultResolvers.title = first
defaultResolvers.uniqueItems = uniqueItems

const defaultComplexResolvers = {
  properties: propertiesResolver,
  items: itemsResolver
}

function merger(rootSchema, options, totalSchemas) {
  totalSchemas = totalSchemas || []
  options = defaultsDeep(options, {
    ignoreAdditionalProperties: false,
    resolvers: defaultResolvers,
    complexResolvers: defaultComplexResolvers,
    deep: true
  })

  const complexResolvers = Object.entries(options.complexResolvers)

  function mergeSchemas(schemas, base, parents) {
    schemas = cloneDeep(schemas.filter(notUndefined))
    parents = parents || []
    const merged = isPlainObject(base)
      ? base
      : {}

    // return undefined, an empty schema
    if (!schemas.length) {
      return
    }

    if (schemas.some(isFalse)) {
      return false
    }

    if (schemas.every(isTrue)) {
      return true
    }

    // there are no false and we don't need the true ones as they accept everything
    schemas = schemas.filter(isPlainObject)

    const allKeys = allUniqueKeys(schemas)
    if (options.deep && contains(allKeys, 'allOf')) {
      return merger({
        allOf: schemas
      }, options, totalSchemas)
    }

    const complexKeysArr = complexResolvers.map(([mainKeyWord, resolverConf]) =>
      allKeys.filter(k => resolverConf.keywords.includes(k)))

    // remove all complex keys before simple resolvers
    complexKeysArr.forEach(keys => pullAll(allKeys, keys))

    // call all simple resolvers for relevant keywords
    allKeys.forEach(function(key) {
      const values = getValues(schemas, key)
      const compacted = uniqWith(values.filter(notUndefined), compareProp(key))

      // arrayprops like anyOf and oneOf must be merged first, as they contains schemas
      // allOf is treated differently alltogether
      if (compacted.length === 1 && contains(schemaArrays, key)) {
        merged[key] = compacted[0].map(schema => mergeSchemas([schema], schema))
        // prop groups must always be resolved
      } else if (compacted.length === 1 && !contains(schemaGroupProps, key) && !contains(schemaProps, key)) {
        merged[key] = compacted[0]
      } else {
        const resolver = options.resolvers[key] || options.resolvers.defaultResolver
        if (!resolver) throw new Error('No resolver found for key ' + key + '. You can provide a resolver for this keyword in the options, or provide a default resolver.')

        const merger = (schemas, extraKey = []) => mergeSchemas(schemas, null, parents.concat(key, extraKey))
        merged[key] = resolver(compacted, parents.concat(key), merger, options)

        if (merged[key] === undefined) {
          throwIncompatible(compacted, parents.concat(key))
        } else if (merged[key] === undefined) {
          delete merged[key]
        }
      }
    })

    return complexResolvers.reduce((all, [resolverKeyword, config], index) => ({
      ...all,
      ...callGroupResolver(complexKeysArr[index], resolverKeyword, schemas, mergeSchemas, options, parents)
    }), merged)
  }

  const allSchemas = flattenDeep(getAllOf(rootSchema))
  const merged = mergeSchemas(allSchemas)

  return merged
}

merger.options = {
  resolvers: defaultResolvers
}

module.exports = merger


/***/ }),

/***/ "../../node_modules/jsonpointer/jsonpointer.js":
/*!*****************************************************!*\
  !*** ../../node_modules/jsonpointer/jsonpointer.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports) => {

var hasExcape = /~/
var escapeMatcher = /~[01]/g
function escapeReplacer (m) {
  switch (m) {
    case '~1': return '/'
    case '~0': return '~'
  }
  throw new Error('Invalid tilde escape: ' + m)
}

function untilde (str) {
  if (!hasExcape.test(str)) return str
  return str.replace(escapeMatcher, escapeReplacer)
}

function setter (obj, pointer, value) {
  var part
  var hasNextPart

  for (var p = 1, len = pointer.length; p < len;) {
    if (pointer[p] === 'constructor' || pointer[p] === 'prototype' || pointer[p] === '__proto__') return obj

    part = untilde(pointer[p++])
    hasNextPart = len > p

    if (typeof obj[part] === 'undefined') {
      // support setting of /-
      if (Array.isArray(obj) && part === '-') {
        part = obj.length
      }

      // support nested objects/array when setting values
      if (hasNextPart) {
        if ((pointer[p] !== '' && pointer[p] < Infinity) || pointer[p] === '-') obj[part] = []
        else obj[part] = {}
      }
    }

    if (!hasNextPart) break
    obj = obj[part]
  }

  var oldValue = obj[part]
  if (value === undefined) delete obj[part]
  else obj[part] = value
  return oldValue
}

function compilePointer (pointer) {
  if (typeof pointer === 'string') {
    pointer = pointer.split('/')
    if (pointer[0] === '') return pointer
    throw new Error('Invalid JSON pointer.')
  } else if (Array.isArray(pointer)) {
    for (const part of pointer) {
      if (typeof part !== 'string' && typeof part !== 'number') {
        throw new Error('Invalid JSON pointer. Must be of type string or number.')
      }
    }
    return pointer
  }

  throw new Error('Invalid JSON pointer.')
}

function get (obj, pointer) {
  if (typeof obj !== 'object') throw new Error('Invalid input object.')
  pointer = compilePointer(pointer)
  var len = pointer.length
  if (len === 1) return obj

  for (var p = 1; p < len;) {
    obj = obj[untilde(pointer[p++])]
    if (len === p) return obj
    if (typeof obj !== 'object' || obj === null) return undefined
  }
}

function set (obj, pointer, value) {
  if (typeof obj !== 'object') throw new Error('Invalid input object.')
  pointer = compilePointer(pointer)
  if (pointer.length === 0) throw new Error('Invalid JSON pointer for set.')
  return setter(obj, pointer, value)
}

function compile (pointer) {
  var compiled = compilePointer(pointer)
  return {
    get: function (object) {
      return get(object, compiled)
    },
    set: function (object, value) {
      return set(object, compiled, value)
    }
  }
}

exports.get = get
exports.set = set
exports.compile = compile


/***/ }),

/***/ "../../node_modules/lodash/_SetCache.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/_SetCache.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var MapCache = __webpack_require__(/*! ./_MapCache */ "../../node_modules/lodash/_MapCache.js"),
    setCacheAdd = __webpack_require__(/*! ./_setCacheAdd */ "../../node_modules/lodash/_setCacheAdd.js"),
    setCacheHas = __webpack_require__(/*! ./_setCacheHas */ "../../node_modules/lodash/_setCacheHas.js");

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;

module.exports = SetCache;


/***/ }),

/***/ "../../node_modules/lodash/_arrayIncludes.js":
/*!***************************************************!*\
  !*** ../../node_modules/lodash/_arrayIncludes.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIndexOf = __webpack_require__(/*! ./_baseIndexOf */ "../../node_modules/lodash/_baseIndexOf.js");

/**
 * A specialized version of `_.includes` for arrays without support for
 * specifying an index to search from.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludes(array, value) {
  var length = array == null ? 0 : array.length;
  return !!length && baseIndexOf(array, value, 0) > -1;
}

module.exports = arrayIncludes;


/***/ }),

/***/ "../../node_modules/lodash/_arrayIncludesWith.js":
/*!*******************************************************!*\
  !*** ../../node_modules/lodash/_arrayIncludesWith.js ***!
  \*******************************************************/
/***/ ((module) => {

/**
 * This function is like `arrayIncludes` except that it accepts a comparator.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @param {Function} comparator The comparator invoked per element.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludesWith(array, value, comparator) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (comparator(value, array[index])) {
      return true;
    }
  }
  return false;
}

module.exports = arrayIncludesWith;


/***/ }),

/***/ "../../node_modules/lodash/_arrayReduce.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_arrayReduce.js ***!
  \*************************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.reduce` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {boolean} [initAccum] Specify using the first element of `array` as
 *  the initial value.
 * @returns {*} Returns the accumulated value.
 */
function arrayReduce(array, iteratee, accumulator, initAccum) {
  var index = -1,
      length = array == null ? 0 : array.length;

  if (initAccum && length) {
    accumulator = array[++index];
  }
  while (++index < length) {
    accumulator = iteratee(accumulator, array[index], index, array);
  }
  return accumulator;
}

module.exports = arrayReduce;


/***/ }),

/***/ "../../node_modules/lodash/_arraySome.js":
/*!***********************************************!*\
  !*** ../../node_modules/lodash/_arraySome.js ***!
  \***********************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

module.exports = arraySome;


/***/ }),

/***/ "../../node_modules/lodash/_assignMergeValue.js":
/*!******************************************************!*\
  !*** ../../node_modules/lodash/_assignMergeValue.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseAssignValue = __webpack_require__(/*! ./_baseAssignValue */ "../../node_modules/lodash/_baseAssignValue.js"),
    eq = __webpack_require__(/*! ./eq */ "../../node_modules/lodash/eq.js");

/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if ((value !== undefined && !eq(object[key], value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignMergeValue;


/***/ }),

/***/ "../../node_modules/lodash/_baseDifference.js":
/*!****************************************************!*\
  !*** ../../node_modules/lodash/_baseDifference.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(/*! ./_SetCache */ "../../node_modules/lodash/_SetCache.js"),
    arrayIncludes = __webpack_require__(/*! ./_arrayIncludes */ "../../node_modules/lodash/_arrayIncludes.js"),
    arrayIncludesWith = __webpack_require__(/*! ./_arrayIncludesWith */ "../../node_modules/lodash/_arrayIncludesWith.js"),
    arrayMap = __webpack_require__(/*! ./_arrayMap */ "../../node_modules/lodash/_arrayMap.js"),
    baseUnary = __webpack_require__(/*! ./_baseUnary */ "../../node_modules/lodash/_baseUnary.js"),
    cacheHas = __webpack_require__(/*! ./_cacheHas */ "../../node_modules/lodash/_cacheHas.js");

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of methods like `_.difference` without support
 * for excluding multiple arrays or iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Array} values The values to exclude.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new array of filtered values.
 */
function baseDifference(array, values, iteratee, comparator) {
  var index = -1,
      includes = arrayIncludes,
      isCommon = true,
      length = array.length,
      result = [],
      valuesLength = values.length;

  if (!length) {
    return result;
  }
  if (iteratee) {
    values = arrayMap(values, baseUnary(iteratee));
  }
  if (comparator) {
    includes = arrayIncludesWith;
    isCommon = false;
  }
  else if (values.length >= LARGE_ARRAY_SIZE) {
    includes = cacheHas;
    isCommon = false;
    values = new SetCache(values);
  }
  outer:
  while (++index < length) {
    var value = array[index],
        computed = iteratee == null ? value : iteratee(value);

    value = (comparator || value !== 0) ? value : 0;
    if (isCommon && computed === computed) {
      var valuesIndex = valuesLength;
      while (valuesIndex--) {
        if (values[valuesIndex] === computed) {
          continue outer;
        }
      }
      result.push(value);
    }
    else if (!includes(values, computed, comparator)) {
      result.push(value);
    }
  }
  return result;
}

module.exports = baseDifference;


/***/ }),

/***/ "../../node_modules/lodash/_baseFindIndex.js":
/*!***************************************************!*\
  !*** ../../node_modules/lodash/_baseFindIndex.js ***!
  \***************************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.findIndex` and `_.findLastIndex` without
 * support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} predicate The function invoked per iteration.
 * @param {number} fromIndex The index to search from.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseFindIndex(array, predicate, fromIndex, fromRight) {
  var length = array.length,
      index = fromIndex + (fromRight ? 1 : -1);

  while ((fromRight ? index-- : ++index < length)) {
    if (predicate(array[index], index, array)) {
      return index;
    }
  }
  return -1;
}

module.exports = baseFindIndex;


/***/ }),

/***/ "../../node_modules/lodash/_baseIndexOf.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_baseIndexOf.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseFindIndex = __webpack_require__(/*! ./_baseFindIndex */ "../../node_modules/lodash/_baseFindIndex.js"),
    baseIsNaN = __webpack_require__(/*! ./_baseIsNaN */ "../../node_modules/lodash/_baseIsNaN.js"),
    strictIndexOf = __webpack_require__(/*! ./_strictIndexOf */ "../../node_modules/lodash/_strictIndexOf.js");

/**
 * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseIndexOf(array, value, fromIndex) {
  return value === value
    ? strictIndexOf(array, value, fromIndex)
    : baseFindIndex(array, baseIsNaN, fromIndex);
}

module.exports = baseIndexOf;


/***/ }),

/***/ "../../node_modules/lodash/_baseIndexOfWith.js":
/*!*****************************************************!*\
  !*** ../../node_modules/lodash/_baseIndexOfWith.js ***!
  \*****************************************************/
/***/ ((module) => {

/**
 * This function is like `baseIndexOf` except that it accepts a comparator.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @param {Function} comparator The comparator invoked per element.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseIndexOfWith(array, value, fromIndex, comparator) {
  var index = fromIndex - 1,
      length = array.length;

  while (++index < length) {
    if (comparator(array[index], value)) {
      return index;
    }
  }
  return -1;
}

module.exports = baseIndexOfWith;


/***/ }),

/***/ "../../node_modules/lodash/_baseIntersection.js":
/*!******************************************************!*\
  !*** ../../node_modules/lodash/_baseIntersection.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(/*! ./_SetCache */ "../../node_modules/lodash/_SetCache.js"),
    arrayIncludes = __webpack_require__(/*! ./_arrayIncludes */ "../../node_modules/lodash/_arrayIncludes.js"),
    arrayIncludesWith = __webpack_require__(/*! ./_arrayIncludesWith */ "../../node_modules/lodash/_arrayIncludesWith.js"),
    arrayMap = __webpack_require__(/*! ./_arrayMap */ "../../node_modules/lodash/_arrayMap.js"),
    baseUnary = __webpack_require__(/*! ./_baseUnary */ "../../node_modules/lodash/_baseUnary.js"),
    cacheHas = __webpack_require__(/*! ./_cacheHas */ "../../node_modules/lodash/_cacheHas.js");

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMin = Math.min;

/**
 * The base implementation of methods like `_.intersection`, without support
 * for iteratee shorthands, that accepts an array of arrays to inspect.
 *
 * @private
 * @param {Array} arrays The arrays to inspect.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new array of shared values.
 */
function baseIntersection(arrays, iteratee, comparator) {
  var includes = comparator ? arrayIncludesWith : arrayIncludes,
      length = arrays[0].length,
      othLength = arrays.length,
      othIndex = othLength,
      caches = Array(othLength),
      maxLength = Infinity,
      result = [];

  while (othIndex--) {
    var array = arrays[othIndex];
    if (othIndex && iteratee) {
      array = arrayMap(array, baseUnary(iteratee));
    }
    maxLength = nativeMin(array.length, maxLength);
    caches[othIndex] = !comparator && (iteratee || (length >= 120 && array.length >= 120))
      ? new SetCache(othIndex && array)
      : undefined;
  }
  array = arrays[0];

  var index = -1,
      seen = caches[0];

  outer:
  while (++index < length && result.length < maxLength) {
    var value = array[index],
        computed = iteratee ? iteratee(value) : value;

    value = (comparator || value !== 0) ? value : 0;
    if (!(seen
          ? cacheHas(seen, computed)
          : includes(result, computed, comparator)
        )) {
      othIndex = othLength;
      while (--othIndex) {
        var cache = caches[othIndex];
        if (!(cache
              ? cacheHas(cache, computed)
              : includes(arrays[othIndex], computed, comparator))
            ) {
          continue outer;
        }
      }
      if (seen) {
        seen.push(computed);
      }
      result.push(value);
    }
  }
  return result;
}

module.exports = baseIntersection;


/***/ }),

/***/ "../../node_modules/lodash/_baseIsEqual.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_baseIsEqual.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqualDeep = __webpack_require__(/*! ./_baseIsEqualDeep */ "../../node_modules/lodash/_baseIsEqualDeep.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "../../node_modules/lodash/isObjectLike.js");

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

module.exports = baseIsEqual;


/***/ }),

/***/ "../../node_modules/lodash/_baseIsEqualDeep.js":
/*!*****************************************************!*\
  !*** ../../node_modules/lodash/_baseIsEqualDeep.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(/*! ./_Stack */ "../../node_modules/lodash/_Stack.js"),
    equalArrays = __webpack_require__(/*! ./_equalArrays */ "../../node_modules/lodash/_equalArrays.js"),
    equalByTag = __webpack_require__(/*! ./_equalByTag */ "../../node_modules/lodash/_equalByTag.js"),
    equalObjects = __webpack_require__(/*! ./_equalObjects */ "../../node_modules/lodash/_equalObjects.js"),
    getTag = __webpack_require__(/*! ./_getTag */ "../../node_modules/lodash/_getTag.js"),
    isArray = __webpack_require__(/*! ./isArray */ "../../node_modules/lodash/isArray.js"),
    isBuffer = __webpack_require__(/*! ./isBuffer */ "../../node_modules/lodash/isBuffer.js"),
    isTypedArray = __webpack_require__(/*! ./isTypedArray */ "../../node_modules/lodash/isTypedArray.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = objIsArr ? arrayTag : getTag(object),
      othTag = othIsArr ? arrayTag : getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer(object)) {
    if (!isBuffer(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

module.exports = baseIsEqualDeep;


/***/ }),

/***/ "../../node_modules/lodash/_baseIsMatch.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_baseIsMatch.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(/*! ./_Stack */ "../../node_modules/lodash/_Stack.js"),
    baseIsEqual = __webpack_require__(/*! ./_baseIsEqual */ "../../node_modules/lodash/_baseIsEqual.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.isMatch` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Object} source The object of property values to match.
 * @param {Array} matchData The property names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparisons.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var stack = new Stack;
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source, stack);
      }
      if (!(result === undefined
            ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
            : result
          )) {
        return false;
      }
    }
  }
  return true;
}

module.exports = baseIsMatch;


/***/ }),

/***/ "../../node_modules/lodash/_baseIsNaN.js":
/*!***********************************************!*\
  !*** ../../node_modules/lodash/_baseIsNaN.js ***!
  \***********************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.isNaN` without support for number objects.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
 */
function baseIsNaN(value) {
  return value !== value;
}

module.exports = baseIsNaN;


/***/ }),

/***/ "../../node_modules/lodash/_baseIteratee.js":
/*!**************************************************!*\
  !*** ../../node_modules/lodash/_baseIteratee.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseMatches = __webpack_require__(/*! ./_baseMatches */ "../../node_modules/lodash/_baseMatches.js"),
    baseMatchesProperty = __webpack_require__(/*! ./_baseMatchesProperty */ "../../node_modules/lodash/_baseMatchesProperty.js"),
    identity = __webpack_require__(/*! ./identity */ "../../node_modules/lodash/identity.js"),
    isArray = __webpack_require__(/*! ./isArray */ "../../node_modules/lodash/isArray.js"),
    property = __webpack_require__(/*! ./property */ "../../node_modules/lodash/property.js");

/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return identity;
  }
  if (typeof value == 'object') {
    return isArray(value)
      ? baseMatchesProperty(value[0], value[1])
      : baseMatches(value);
  }
  return property(value);
}

module.exports = baseIteratee;


/***/ }),

/***/ "../../node_modules/lodash/_baseMap.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/_baseMap.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseEach = __webpack_require__(/*! ./_baseEach */ "../../node_modules/lodash/_baseEach.js"),
    isArrayLike = __webpack_require__(/*! ./isArrayLike */ "../../node_modules/lodash/isArrayLike.js");

/**
 * The base implementation of `_.map` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function baseMap(collection, iteratee) {
  var index = -1,
      result = isArrayLike(collection) ? Array(collection.length) : [];

  baseEach(collection, function(value, key, collection) {
    result[++index] = iteratee(value, key, collection);
  });
  return result;
}

module.exports = baseMap;


/***/ }),

/***/ "../../node_modules/lodash/_baseMatches.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_baseMatches.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsMatch = __webpack_require__(/*! ./_baseIsMatch */ "../../node_modules/lodash/_baseIsMatch.js"),
    getMatchData = __webpack_require__(/*! ./_getMatchData */ "../../node_modules/lodash/_getMatchData.js"),
    matchesStrictComparable = __webpack_require__(/*! ./_matchesStrictComparable */ "../../node_modules/lodash/_matchesStrictComparable.js");

/**
 * The base implementation of `_.matches` which doesn't clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatches(source) {
  var matchData = getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || baseIsMatch(object, source, matchData);
  };
}

module.exports = baseMatches;


/***/ }),

/***/ "../../node_modules/lodash/_baseMatchesProperty.js":
/*!*********************************************************!*\
  !*** ../../node_modules/lodash/_baseMatchesProperty.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqual = __webpack_require__(/*! ./_baseIsEqual */ "../../node_modules/lodash/_baseIsEqual.js"),
    get = __webpack_require__(/*! ./get */ "../../node_modules/lodash/get.js"),
    hasIn = __webpack_require__(/*! ./hasIn */ "../../node_modules/lodash/hasIn.js"),
    isKey = __webpack_require__(/*! ./_isKey */ "../../node_modules/lodash/_isKey.js"),
    isStrictComparable = __webpack_require__(/*! ./_isStrictComparable */ "../../node_modules/lodash/_isStrictComparable.js"),
    matchesStrictComparable = __webpack_require__(/*! ./_matchesStrictComparable */ "../../node_modules/lodash/_matchesStrictComparable.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "../../node_modules/lodash/_toKey.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
 *
 * @private
 * @param {string} path The path of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatchesProperty(path, srcValue) {
  if (isKey(path) && isStrictComparable(srcValue)) {
    return matchesStrictComparable(toKey(path), srcValue);
  }
  return function(object) {
    var objValue = get(object, path);
    return (objValue === undefined && objValue === srcValue)
      ? hasIn(object, path)
      : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
  };
}

module.exports = baseMatchesProperty;


/***/ }),

/***/ "../../node_modules/lodash/_baseMerge.js":
/*!***********************************************!*\
  !*** ../../node_modules/lodash/_baseMerge.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(/*! ./_Stack */ "../../node_modules/lodash/_Stack.js"),
    assignMergeValue = __webpack_require__(/*! ./_assignMergeValue */ "../../node_modules/lodash/_assignMergeValue.js"),
    baseFor = __webpack_require__(/*! ./_baseFor */ "../../node_modules/lodash/_baseFor.js"),
    baseMergeDeep = __webpack_require__(/*! ./_baseMergeDeep */ "../../node_modules/lodash/_baseMergeDeep.js"),
    isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js"),
    keysIn = __webpack_require__(/*! ./keysIn */ "../../node_modules/lodash/keysIn.js"),
    safeGet = __webpack_require__(/*! ./_safeGet */ "../../node_modules/lodash/_safeGet.js");

/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  baseFor(source, function(srcValue, key) {
    stack || (stack = new Stack);
    if (isObject(srcValue)) {
      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    }
    else {
      var newValue = customizer
        ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
        : undefined;

      if (newValue === undefined) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}

module.exports = baseMerge;


/***/ }),

/***/ "../../node_modules/lodash/_baseMergeDeep.js":
/*!***************************************************!*\
  !*** ../../node_modules/lodash/_baseMergeDeep.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assignMergeValue = __webpack_require__(/*! ./_assignMergeValue */ "../../node_modules/lodash/_assignMergeValue.js"),
    cloneBuffer = __webpack_require__(/*! ./_cloneBuffer */ "../../node_modules/lodash/_cloneBuffer.js"),
    cloneTypedArray = __webpack_require__(/*! ./_cloneTypedArray */ "../../node_modules/lodash/_cloneTypedArray.js"),
    copyArray = __webpack_require__(/*! ./_copyArray */ "../../node_modules/lodash/_copyArray.js"),
    initCloneObject = __webpack_require__(/*! ./_initCloneObject */ "../../node_modules/lodash/_initCloneObject.js"),
    isArguments = __webpack_require__(/*! ./isArguments */ "../../node_modules/lodash/isArguments.js"),
    isArray = __webpack_require__(/*! ./isArray */ "../../node_modules/lodash/isArray.js"),
    isArrayLikeObject = __webpack_require__(/*! ./isArrayLikeObject */ "../../node_modules/lodash/isArrayLikeObject.js"),
    isBuffer = __webpack_require__(/*! ./isBuffer */ "../../node_modules/lodash/isBuffer.js"),
    isFunction = __webpack_require__(/*! ./isFunction */ "../../node_modules/lodash/isFunction.js"),
    isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js"),
    isPlainObject = __webpack_require__(/*! ./isPlainObject */ "../../node_modules/lodash/isPlainObject.js"),
    isTypedArray = __webpack_require__(/*! ./isTypedArray */ "../../node_modules/lodash/isTypedArray.js"),
    safeGet = __webpack_require__(/*! ./_safeGet */ "../../node_modules/lodash/_safeGet.js"),
    toPlainObject = __webpack_require__(/*! ./toPlainObject */ "../../node_modules/lodash/toPlainObject.js");

/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = safeGet(object, key),
      srcValue = safeGet(source, key),
      stacked = stack.get(srcValue);

  if (stacked) {
    assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer
    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
    : undefined;

  var isCommon = newValue === undefined;

  if (isCommon) {
    var isArr = isArray(srcValue),
        isBuff = !isArr && isBuffer(srcValue),
        isTyped = !isArr && !isBuff && isTypedArray(srcValue);

    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (isArray(objValue)) {
        newValue = objValue;
      }
      else if (isArrayLikeObject(objValue)) {
        newValue = copyArray(objValue);
      }
      else if (isBuff) {
        isCommon = false;
        newValue = cloneBuffer(srcValue, true);
      }
      else if (isTyped) {
        isCommon = false;
        newValue = cloneTypedArray(srcValue, true);
      }
      else {
        newValue = [];
      }
    }
    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
      newValue = objValue;
      if (isArguments(objValue)) {
        newValue = toPlainObject(objValue);
      }
      else if (!isObject(objValue) || isFunction(objValue)) {
        newValue = initCloneObject(srcValue);
      }
    }
    else {
      isCommon = false;
    }
  }
  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack['delete'](srcValue);
  }
  assignMergeValue(object, key, newValue);
}

module.exports = baseMergeDeep;


/***/ }),

/***/ "../../node_modules/lodash/_baseOrderBy.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_baseOrderBy.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayMap = __webpack_require__(/*! ./_arrayMap */ "../../node_modules/lodash/_arrayMap.js"),
    baseGet = __webpack_require__(/*! ./_baseGet */ "../../node_modules/lodash/_baseGet.js"),
    baseIteratee = __webpack_require__(/*! ./_baseIteratee */ "../../node_modules/lodash/_baseIteratee.js"),
    baseMap = __webpack_require__(/*! ./_baseMap */ "../../node_modules/lodash/_baseMap.js"),
    baseSortBy = __webpack_require__(/*! ./_baseSortBy */ "../../node_modules/lodash/_baseSortBy.js"),
    baseUnary = __webpack_require__(/*! ./_baseUnary */ "../../node_modules/lodash/_baseUnary.js"),
    compareMultiple = __webpack_require__(/*! ./_compareMultiple */ "../../node_modules/lodash/_compareMultiple.js"),
    identity = __webpack_require__(/*! ./identity */ "../../node_modules/lodash/identity.js"),
    isArray = __webpack_require__(/*! ./isArray */ "../../node_modules/lodash/isArray.js");

/**
 * The base implementation of `_.orderBy` without param guards.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
 * @param {string[]} orders The sort orders of `iteratees`.
 * @returns {Array} Returns the new sorted array.
 */
function baseOrderBy(collection, iteratees, orders) {
  if (iteratees.length) {
    iteratees = arrayMap(iteratees, function(iteratee) {
      if (isArray(iteratee)) {
        return function(value) {
          return baseGet(value, iteratee.length === 1 ? iteratee[0] : iteratee);
        }
      }
      return iteratee;
    });
  } else {
    iteratees = [identity];
  }

  var index = -1;
  iteratees = arrayMap(iteratees, baseUnary(baseIteratee));

  var result = baseMap(collection, function(value, key, collection) {
    var criteria = arrayMap(iteratees, function(iteratee) {
      return iteratee(value);
    });
    return { 'criteria': criteria, 'index': ++index, 'value': value };
  });

  return baseSortBy(result, function(object, other) {
    return compareMultiple(object, other, orders);
  });
}

module.exports = baseOrderBy;


/***/ }),

/***/ "../../node_modules/lodash/_baseProperty.js":
/*!**************************************************!*\
  !*** ../../node_modules/lodash/_baseProperty.js ***!
  \**************************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

module.exports = baseProperty;


/***/ }),

/***/ "../../node_modules/lodash/_basePropertyDeep.js":
/*!******************************************************!*\
  !*** ../../node_modules/lodash/_basePropertyDeep.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGet = __webpack_require__(/*! ./_baseGet */ "../../node_modules/lodash/_baseGet.js");

/**
 * A specialized version of `baseProperty` which supports deep paths.
 *
 * @private
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyDeep(path) {
  return function(object) {
    return baseGet(object, path);
  };
}

module.exports = basePropertyDeep;


/***/ }),

/***/ "../../node_modules/lodash/_basePullAll.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_basePullAll.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayMap = __webpack_require__(/*! ./_arrayMap */ "../../node_modules/lodash/_arrayMap.js"),
    baseIndexOf = __webpack_require__(/*! ./_baseIndexOf */ "../../node_modules/lodash/_baseIndexOf.js"),
    baseIndexOfWith = __webpack_require__(/*! ./_baseIndexOfWith */ "../../node_modules/lodash/_baseIndexOfWith.js"),
    baseUnary = __webpack_require__(/*! ./_baseUnary */ "../../node_modules/lodash/_baseUnary.js"),
    copyArray = __webpack_require__(/*! ./_copyArray */ "../../node_modules/lodash/_copyArray.js");

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * The base implementation of `_.pullAllBy` without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to remove.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns `array`.
 */
function basePullAll(array, values, iteratee, comparator) {
  var indexOf = comparator ? baseIndexOfWith : baseIndexOf,
      index = -1,
      length = values.length,
      seen = array;

  if (array === values) {
    values = copyArray(values);
  }
  if (iteratee) {
    seen = arrayMap(array, baseUnary(iteratee));
  }
  while (++index < length) {
    var fromIndex = 0,
        value = values[index],
        computed = iteratee ? iteratee(value) : value;

    while ((fromIndex = indexOf(seen, computed, fromIndex, comparator)) > -1) {
      if (seen !== array) {
        splice.call(seen, fromIndex, 1);
      }
      splice.call(array, fromIndex, 1);
    }
  }
  return array;
}

module.exports = basePullAll;


/***/ }),

/***/ "../../node_modules/lodash/_baseReduce.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/_baseReduce.js ***!
  \************************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.reduce` and `_.reduceRight`, without support
 * for iteratee shorthands, which iterates over `collection` using `eachFunc`.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} accumulator The initial value.
 * @param {boolean} initAccum Specify using the first or last element of
 *  `collection` as the initial value.
 * @param {Function} eachFunc The function to iterate over `collection`.
 * @returns {*} Returns the accumulated value.
 */
function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
  eachFunc(collection, function(value, index, collection) {
    accumulator = initAccum
      ? (initAccum = false, value)
      : iteratee(accumulator, value, index, collection);
  });
  return accumulator;
}

module.exports = baseReduce;


/***/ }),

/***/ "../../node_modules/lodash/_baseRest.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/_baseRest.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var identity = __webpack_require__(/*! ./identity */ "../../node_modules/lodash/identity.js"),
    overRest = __webpack_require__(/*! ./_overRest */ "../../node_modules/lodash/_overRest.js"),
    setToString = __webpack_require__(/*! ./_setToString */ "../../node_modules/lodash/_setToString.js");

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString(overRest(func, start, identity), func + '');
}

module.exports = baseRest;


/***/ }),

/***/ "../../node_modules/lodash/_baseSortBy.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/_baseSortBy.js ***!
  \************************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.sortBy` which uses `comparer` to define the
 * sort order of `array` and replaces criteria objects with their corresponding
 * values.
 *
 * @private
 * @param {Array} array The array to sort.
 * @param {Function} comparer The function to define sort order.
 * @returns {Array} Returns `array`.
 */
function baseSortBy(array, comparer) {
  var length = array.length;

  array.sort(comparer);
  while (length--) {
    array[length] = array[length].value;
  }
  return array;
}

module.exports = baseSortBy;


/***/ }),

/***/ "../../node_modules/lodash/_baseTrim.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/_baseTrim.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var trimmedEndIndex = __webpack_require__(/*! ./_trimmedEndIndex */ "../../node_modules/lodash/_trimmedEndIndex.js");

/** Used to match leading whitespace. */
var reTrimStart = /^\s+/;

/**
 * The base implementation of `_.trim`.
 *
 * @private
 * @param {string} string The string to trim.
 * @returns {string} Returns the trimmed string.
 */
function baseTrim(string) {
  return string
    ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, '')
    : string;
}

module.exports = baseTrim;


/***/ }),

/***/ "../../node_modules/lodash/_baseUniq.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/_baseUniq.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(/*! ./_SetCache */ "../../node_modules/lodash/_SetCache.js"),
    arrayIncludes = __webpack_require__(/*! ./_arrayIncludes */ "../../node_modules/lodash/_arrayIncludes.js"),
    arrayIncludesWith = __webpack_require__(/*! ./_arrayIncludesWith */ "../../node_modules/lodash/_arrayIncludesWith.js"),
    cacheHas = __webpack_require__(/*! ./_cacheHas */ "../../node_modules/lodash/_cacheHas.js"),
    createSet = __webpack_require__(/*! ./_createSet */ "../../node_modules/lodash/_createSet.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "../../node_modules/lodash/_setToArray.js");

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of `_.uniqBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 */
function baseUniq(array, iteratee, comparator) {
  var index = -1,
      includes = arrayIncludes,
      length = array.length,
      isCommon = true,
      result = [],
      seen = result;

  if (comparator) {
    isCommon = false;
    includes = arrayIncludesWith;
  }
  else if (length >= LARGE_ARRAY_SIZE) {
    var set = iteratee ? null : createSet(array);
    if (set) {
      return setToArray(set);
    }
    isCommon = false;
    includes = cacheHas;
    seen = new SetCache;
  }
  else {
    seen = iteratee ? [] : result;
  }
  outer:
  while (++index < length) {
    var value = array[index],
        computed = iteratee ? iteratee(value) : value;

    value = (comparator || value !== 0) ? value : 0;
    if (isCommon && computed === computed) {
      var seenIndex = seen.length;
      while (seenIndex--) {
        if (seen[seenIndex] === computed) {
          continue outer;
        }
      }
      if (iteratee) {
        seen.push(computed);
      }
      result.push(value);
    }
    else if (!includes(seen, computed, comparator)) {
      if (seen !== result) {
        seen.push(computed);
      }
      result.push(value);
    }
  }
  return result;
}

module.exports = baseUniq;


/***/ }),

/***/ "../../node_modules/lodash/_cacheHas.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/_cacheHas.js ***!
  \**********************************************/
/***/ ((module) => {

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

module.exports = cacheHas;


/***/ }),

/***/ "../../node_modules/lodash/_castArrayLikeObject.js":
/*!*********************************************************!*\
  !*** ../../node_modules/lodash/_castArrayLikeObject.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArrayLikeObject = __webpack_require__(/*! ./isArrayLikeObject */ "../../node_modules/lodash/isArrayLikeObject.js");

/**
 * Casts `value` to an empty array if it's not an array like object.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {Array|Object} Returns the cast array-like object.
 */
function castArrayLikeObject(value) {
  return isArrayLikeObject(value) ? value : [];
}

module.exports = castArrayLikeObject;


/***/ }),

/***/ "../../node_modules/lodash/_compareAscending.js":
/*!******************************************************!*\
  !*** ../../node_modules/lodash/_compareAscending.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isSymbol = __webpack_require__(/*! ./isSymbol */ "../../node_modules/lodash/isSymbol.js");

/**
 * Compares values to sort them in ascending order.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {number} Returns the sort order indicator for `value`.
 */
function compareAscending(value, other) {
  if (value !== other) {
    var valIsDefined = value !== undefined,
        valIsNull = value === null,
        valIsReflexive = value === value,
        valIsSymbol = isSymbol(value);

    var othIsDefined = other !== undefined,
        othIsNull = other === null,
        othIsReflexive = other === other,
        othIsSymbol = isSymbol(other);

    if ((!othIsNull && !othIsSymbol && !valIsSymbol && value > other) ||
        (valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol) ||
        (valIsNull && othIsDefined && othIsReflexive) ||
        (!valIsDefined && othIsReflexive) ||
        !valIsReflexive) {
      return 1;
    }
    if ((!valIsNull && !valIsSymbol && !othIsSymbol && value < other) ||
        (othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol) ||
        (othIsNull && valIsDefined && valIsReflexive) ||
        (!othIsDefined && valIsReflexive) ||
        !othIsReflexive) {
      return -1;
    }
  }
  return 0;
}

module.exports = compareAscending;


/***/ }),

/***/ "../../node_modules/lodash/_compareMultiple.js":
/*!*****************************************************!*\
  !*** ../../node_modules/lodash/_compareMultiple.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var compareAscending = __webpack_require__(/*! ./_compareAscending */ "../../node_modules/lodash/_compareAscending.js");

/**
 * Used by `_.orderBy` to compare multiple properties of a value to another
 * and stable sort them.
 *
 * If `orders` is unspecified, all values are sorted in ascending order. Otherwise,
 * specify an order of "desc" for descending or "asc" for ascending sort order
 * of corresponding values.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {boolean[]|string[]} orders The order to sort by for each property.
 * @returns {number} Returns the sort order indicator for `object`.
 */
function compareMultiple(object, other, orders) {
  var index = -1,
      objCriteria = object.criteria,
      othCriteria = other.criteria,
      length = objCriteria.length,
      ordersLength = orders.length;

  while (++index < length) {
    var result = compareAscending(objCriteria[index], othCriteria[index]);
    if (result) {
      if (index >= ordersLength) {
        return result;
      }
      var order = orders[index];
      return result * (order == 'desc' ? -1 : 1);
    }
  }
  // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
  // that causes it, under certain circumstances, to provide the same value for
  // `object` and `other`. See https://github.com/jashkenas/underscore/pull/1247
  // for more details.
  //
  // This also ensures a stable sort in V8 and other engines.
  // See https://bugs.chromium.org/p/v8/issues/detail?id=90 for more details.
  return object.index - other.index;
}

module.exports = compareMultiple;


/***/ }),

/***/ "../../node_modules/lodash/_createAssigner.js":
/*!****************************************************!*\
  !*** ../../node_modules/lodash/_createAssigner.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseRest = __webpack_require__(/*! ./_baseRest */ "../../node_modules/lodash/_baseRest.js"),
    isIterateeCall = __webpack_require__(/*! ./_isIterateeCall */ "../../node_modules/lodash/_isIterateeCall.js");

/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

module.exports = createAssigner;


/***/ }),

/***/ "../../node_modules/lodash/_createSet.js":
/*!***********************************************!*\
  !*** ../../node_modules/lodash/_createSet.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Set = __webpack_require__(/*! ./_Set */ "../../node_modules/lodash/_Set.js"),
    noop = __webpack_require__(/*! ./noop */ "../../node_modules/lodash/noop.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "../../node_modules/lodash/_setToArray.js");

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Creates a set object of `values`.
 *
 * @private
 * @param {Array} values The values to add to the set.
 * @returns {Object} Returns the new set.
 */
var createSet = !(Set && (1 / setToArray(new Set([,-0]))[1]) == INFINITY) ? noop : function(values) {
  return new Set(values);
};

module.exports = createSet;


/***/ }),

/***/ "../../node_modules/lodash/_customDefaultsMerge.js":
/*!*********************************************************!*\
  !*** ../../node_modules/lodash/_customDefaultsMerge.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseMerge = __webpack_require__(/*! ./_baseMerge */ "../../node_modules/lodash/_baseMerge.js"),
    isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js");

/**
 * Used by `_.defaultsDeep` to customize its `_.merge` use to merge source
 * objects into destination objects that are passed thru.
 *
 * @private
 * @param {*} objValue The destination value.
 * @param {*} srcValue The source value.
 * @param {string} key The key of the property to merge.
 * @param {Object} object The parent object of `objValue`.
 * @param {Object} source The parent object of `srcValue`.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 * @returns {*} Returns the value to assign.
 */
function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
  if (isObject(objValue) && isObject(srcValue)) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, objValue);
    baseMerge(objValue, srcValue, undefined, customDefaultsMerge, stack);
    stack['delete'](srcValue);
  }
  return objValue;
}

module.exports = customDefaultsMerge;


/***/ }),

/***/ "../../node_modules/lodash/_equalArrays.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_equalArrays.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(/*! ./_SetCache */ "../../node_modules/lodash/_SetCache.js"),
    arraySome = __webpack_require__(/*! ./_arraySome */ "../../node_modules/lodash/_arraySome.js"),
    cacheHas = __webpack_require__(/*! ./_cacheHas */ "../../node_modules/lodash/_cacheHas.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

module.exports = equalArrays;


/***/ }),

/***/ "../../node_modules/lodash/_equalByTag.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/_equalByTag.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "../../node_modules/lodash/_Symbol.js"),
    Uint8Array = __webpack_require__(/*! ./_Uint8Array */ "../../node_modules/lodash/_Uint8Array.js"),
    eq = __webpack_require__(/*! ./eq */ "../../node_modules/lodash/eq.js"),
    equalArrays = __webpack_require__(/*! ./_equalArrays */ "../../node_modules/lodash/_equalArrays.js"),
    mapToArray = __webpack_require__(/*! ./_mapToArray */ "../../node_modules/lodash/_mapToArray.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "../../node_modules/lodash/_setToArray.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

module.exports = equalByTag;


/***/ }),

/***/ "../../node_modules/lodash/_equalObjects.js":
/*!**************************************************!*\
  !*** ../../node_modules/lodash/_equalObjects.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getAllKeys = __webpack_require__(/*! ./_getAllKeys */ "../../node_modules/lodash/_getAllKeys.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      objProps = getAllKeys(object),
      objLength = objProps.length,
      othProps = getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Check that cyclic values are equal.
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

module.exports = equalObjects;


/***/ }),

/***/ "../../node_modules/lodash/_getMatchData.js":
/*!**************************************************!*\
  !*** ../../node_modules/lodash/_getMatchData.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isStrictComparable = __webpack_require__(/*! ./_isStrictComparable */ "../../node_modules/lodash/_isStrictComparable.js"),
    keys = __webpack_require__(/*! ./keys */ "../../node_modules/lodash/keys.js");

/**
 * Gets the property names, values, and compare flags of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the match data of `object`.
 */
function getMatchData(object) {
  var result = keys(object),
      length = result.length;

  while (length--) {
    var key = result[length],
        value = object[key];

    result[length] = [key, value, isStrictComparable(value)];
  }
  return result;
}

module.exports = getMatchData;


/***/ }),

/***/ "../../node_modules/lodash/_isIterateeCall.js":
/*!****************************************************!*\
  !*** ../../node_modules/lodash/_isIterateeCall.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var eq = __webpack_require__(/*! ./eq */ "../../node_modules/lodash/eq.js"),
    isArrayLike = __webpack_require__(/*! ./isArrayLike */ "../../node_modules/lodash/isArrayLike.js"),
    isIndex = __webpack_require__(/*! ./_isIndex */ "../../node_modules/lodash/_isIndex.js"),
    isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js");

/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
        ? (isArrayLike(object) && isIndex(index, object.length))
        : (type == 'string' && index in object)
      ) {
    return eq(object[index], value);
  }
  return false;
}

module.exports = isIterateeCall;


/***/ }),

/***/ "../../node_modules/lodash/_isStrictComparable.js":
/*!********************************************************!*\
  !*** ../../node_modules/lodash/_isStrictComparable.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js");

/**
 * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` if suitable for strict
 *  equality comparisons, else `false`.
 */
function isStrictComparable(value) {
  return value === value && !isObject(value);
}

module.exports = isStrictComparable;


/***/ }),

/***/ "../../node_modules/lodash/_mapToArray.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/_mapToArray.js ***!
  \************************************************/
/***/ ((module) => {

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

module.exports = mapToArray;


/***/ }),

/***/ "../../node_modules/lodash/_matchesStrictComparable.js":
/*!*************************************************************!*\
  !*** ../../node_modules/lodash/_matchesStrictComparable.js ***!
  \*************************************************************/
/***/ ((module) => {

/**
 * A specialized version of `matchesProperty` for source values suitable
 * for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue &&
      (srcValue !== undefined || (key in Object(object)));
  };
}

module.exports = matchesStrictComparable;


/***/ }),

/***/ "../../node_modules/lodash/_safeGet.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/_safeGet.js ***!
  \*********************************************/
/***/ ((module) => {

/**
 * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function safeGet(object, key) {
  if (key === 'constructor' && typeof object[key] === 'function') {
    return;
  }

  if (key == '__proto__') {
    return;
  }

  return object[key];
}

module.exports = safeGet;


/***/ }),

/***/ "../../node_modules/lodash/_setCacheAdd.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_setCacheAdd.js ***!
  \*************************************************/
/***/ ((module) => {

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

module.exports = setCacheAdd;


/***/ }),

/***/ "../../node_modules/lodash/_setCacheHas.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/_setCacheHas.js ***!
  \*************************************************/
/***/ ((module) => {

/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

module.exports = setCacheHas;


/***/ }),

/***/ "../../node_modules/lodash/_setToArray.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/_setToArray.js ***!
  \************************************************/
/***/ ((module) => {

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

module.exports = setToArray;


/***/ }),

/***/ "../../node_modules/lodash/_strictIndexOf.js":
/*!***************************************************!*\
  !*** ../../node_modules/lodash/_strictIndexOf.js ***!
  \***************************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.indexOf` which performs strict equality
 * comparisons of values, i.e. `===`.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function strictIndexOf(array, value, fromIndex) {
  var index = fromIndex - 1,
      length = array.length;

  while (++index < length) {
    if (array[index] === value) {
      return index;
    }
  }
  return -1;
}

module.exports = strictIndexOf;


/***/ }),

/***/ "../../node_modules/lodash/_trimmedEndIndex.js":
/*!*****************************************************!*\
  !*** ../../node_modules/lodash/_trimmedEndIndex.js ***!
  \*****************************************************/
/***/ ((module) => {

/** Used to match a single whitespace character. */
var reWhitespace = /\s/;

/**
 * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
 * character of `string`.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {number} Returns the index of the last non-whitespace character.
 */
function trimmedEndIndex(string) {
  var index = string.length;

  while (index-- && reWhitespace.test(string.charAt(index))) {}
  return index;
}

module.exports = trimmedEndIndex;


/***/ }),

/***/ "../../node_modules/lodash/defaults.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/defaults.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseRest = __webpack_require__(/*! ./_baseRest */ "../../node_modules/lodash/_baseRest.js"),
    eq = __webpack_require__(/*! ./eq */ "../../node_modules/lodash/eq.js"),
    isIterateeCall = __webpack_require__(/*! ./_isIterateeCall */ "../../node_modules/lodash/_isIterateeCall.js"),
    keysIn = __webpack_require__(/*! ./keysIn */ "../../node_modules/lodash/keysIn.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Assigns own and inherited enumerable string keyed properties of source
 * objects to the destination object for all destination properties that
 * resolve to `undefined`. Source objects are applied from left to right.
 * Once a property is set, additional values of the same property are ignored.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @see _.defaultsDeep
 * @example
 *
 * _.defaults({ 'a': 1 }, { 'b': 2 }, { 'a': 3 });
 * // => { 'a': 1, 'b': 2 }
 */
var defaults = baseRest(function(object, sources) {
  object = Object(object);

  var index = -1;
  var length = sources.length;
  var guard = length > 2 ? sources[2] : undefined;

  if (guard && isIterateeCall(sources[0], sources[1], guard)) {
    length = 1;
  }

  while (++index < length) {
    var source = sources[index];
    var props = keysIn(source);
    var propsIndex = -1;
    var propsLength = props.length;

    while (++propsIndex < propsLength) {
      var key = props[propsIndex];
      var value = object[key];

      if (value === undefined ||
          (eq(value, objectProto[key]) && !hasOwnProperty.call(object, key))) {
        object[key] = source[key];
      }
    }
  }

  return object;
});

module.exports = defaults;


/***/ }),

/***/ "../../node_modules/lodash/defaultsDeep.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/defaultsDeep.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var apply = __webpack_require__(/*! ./_apply */ "../../node_modules/lodash/_apply.js"),
    baseRest = __webpack_require__(/*! ./_baseRest */ "../../node_modules/lodash/_baseRest.js"),
    customDefaultsMerge = __webpack_require__(/*! ./_customDefaultsMerge */ "../../node_modules/lodash/_customDefaultsMerge.js"),
    mergeWith = __webpack_require__(/*! ./mergeWith */ "../../node_modules/lodash/mergeWith.js");

/**
 * This method is like `_.defaults` except that it recursively assigns
 * default properties.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 3.10.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @see _.defaults
 * @example
 *
 * _.defaultsDeep({ 'a': { 'b': 2 } }, { 'a': { 'b': 1, 'c': 3 } });
 * // => { 'a': { 'b': 2, 'c': 3 } }
 */
var defaultsDeep = baseRest(function(args) {
  args.push(undefined, customDefaultsMerge);
  return apply(mergeWith, undefined, args);
});

module.exports = defaultsDeep;


/***/ }),

/***/ "../../node_modules/lodash/flattenDeep.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/flattenDeep.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseFlatten = __webpack_require__(/*! ./_baseFlatten */ "../../node_modules/lodash/_baseFlatten.js");

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Recursively flattens `array`.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Array
 * @param {Array} array The array to flatten.
 * @returns {Array} Returns the new flattened array.
 * @example
 *
 * _.flattenDeep([1, [2, [3, [4]], 5]]);
 * // => [1, 2, 3, 4, 5]
 */
function flattenDeep(array) {
  var length = array == null ? 0 : array.length;
  return length ? baseFlatten(array, INFINITY) : [];
}

module.exports = flattenDeep;


/***/ }),

/***/ "../../node_modules/lodash/intersection.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/intersection.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayMap = __webpack_require__(/*! ./_arrayMap */ "../../node_modules/lodash/_arrayMap.js"),
    baseIntersection = __webpack_require__(/*! ./_baseIntersection */ "../../node_modules/lodash/_baseIntersection.js"),
    baseRest = __webpack_require__(/*! ./_baseRest */ "../../node_modules/lodash/_baseRest.js"),
    castArrayLikeObject = __webpack_require__(/*! ./_castArrayLikeObject */ "../../node_modules/lodash/_castArrayLikeObject.js");

/**
 * Creates an array of unique values that are included in all given arrays
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons. The order and references of result values are
 * determined by the first array.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {...Array} [arrays] The arrays to inspect.
 * @returns {Array} Returns the new array of intersecting values.
 * @example
 *
 * _.intersection([2, 1], [2, 3]);
 * // => [2]
 */
var intersection = baseRest(function(arrays) {
  var mapped = arrayMap(arrays, castArrayLikeObject);
  return (mapped.length && mapped[0] === arrays[0])
    ? baseIntersection(mapped)
    : [];
});

module.exports = intersection;


/***/ }),

/***/ "../../node_modules/lodash/intersectionWith.js":
/*!*****************************************************!*\
  !*** ../../node_modules/lodash/intersectionWith.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayMap = __webpack_require__(/*! ./_arrayMap */ "../../node_modules/lodash/_arrayMap.js"),
    baseIntersection = __webpack_require__(/*! ./_baseIntersection */ "../../node_modules/lodash/_baseIntersection.js"),
    baseRest = __webpack_require__(/*! ./_baseRest */ "../../node_modules/lodash/_baseRest.js"),
    castArrayLikeObject = __webpack_require__(/*! ./_castArrayLikeObject */ "../../node_modules/lodash/_castArrayLikeObject.js"),
    last = __webpack_require__(/*! ./last */ "../../node_modules/lodash/last.js");

/**
 * This method is like `_.intersection` except that it accepts `comparator`
 * which is invoked to compare elements of `arrays`. The order and references
 * of result values are determined by the first array. The comparator is
 * invoked with two arguments: (arrVal, othVal).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Array
 * @param {...Array} [arrays] The arrays to inspect.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new array of intersecting values.
 * @example
 *
 * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
 * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
 *
 * _.intersectionWith(objects, others, _.isEqual);
 * // => [{ 'x': 1, 'y': 2 }]
 */
var intersectionWith = baseRest(function(arrays) {
  var comparator = last(arrays),
      mapped = arrayMap(arrays, castArrayLikeObject);

  comparator = typeof comparator == 'function' ? comparator : undefined;
  if (comparator) {
    mapped.pop();
  }
  return (mapped.length && mapped[0] === arrays[0])
    ? baseIntersection(mapped, undefined, comparator)
    : [];
});

module.exports = intersectionWith;


/***/ }),

/***/ "../../node_modules/lodash/isArrayLikeObject.js":
/*!******************************************************!*\
  !*** ../../node_modules/lodash/isArrayLikeObject.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArrayLike = __webpack_require__(/*! ./isArrayLike */ "../../node_modules/lodash/isArrayLike.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "../../node_modules/lodash/isObjectLike.js");

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

module.exports = isArrayLikeObject;


/***/ }),

/***/ "../../node_modules/lodash/isBoolean.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/isBoolean.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "../../node_modules/lodash/_baseGetTag.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "../../node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var boolTag = '[object Boolean]';

/**
 * Checks if `value` is classified as a boolean primitive or object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a boolean, else `false`.
 * @example
 *
 * _.isBoolean(false);
 * // => true
 *
 * _.isBoolean(null);
 * // => false
 */
function isBoolean(value) {
  return value === true || value === false ||
    (isObjectLike(value) && baseGetTag(value) == boolTag);
}

module.exports = isBoolean;


/***/ }),

/***/ "../../node_modules/lodash/isEqual.js":
/*!********************************************!*\
  !*** ../../node_modules/lodash/isEqual.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqual = __webpack_require__(/*! ./_baseIsEqual */ "../../node_modules/lodash/_baseIsEqual.js");

/**
 * Performs a deep comparison between two values to determine if they are
 * equivalent.
 *
 * **Note:** This method supports comparing arrays, array buffers, booleans,
 * date objects, error objects, maps, numbers, `Object` objects, regexes,
 * sets, strings, symbols, and typed arrays. `Object` objects are compared
 * by their own, not inherited, enumerable properties. Functions and DOM
 * nodes are compared by strict equality, i.e. `===`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.isEqual(object, other);
 * // => true
 *
 * object === other;
 * // => false
 */
function isEqual(value, other) {
  return baseIsEqual(value, other);
}

module.exports = isEqual;


/***/ }),

/***/ "../../node_modules/lodash/isNil.js":
/*!******************************************!*\
  !*** ../../node_modules/lodash/isNil.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * Checks if `value` is `null` or `undefined`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is nullish, else `false`.
 * @example
 *
 * _.isNil(null);
 * // => true
 *
 * _.isNil(void 0);
 * // => true
 *
 * _.isNil(NaN);
 * // => false
 */
function isNil(value) {
  return value == null;
}

module.exports = isNil;


/***/ }),

/***/ "../../node_modules/lodash/isNumber.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/isNumber.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "../../node_modules/lodash/_baseGetTag.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "../../node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var numberTag = '[object Number]';

/**
 * Checks if `value` is classified as a `Number` primitive or object.
 *
 * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are
 * classified as numbers, use the `_.isFinite` method.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a number, else `false`.
 * @example
 *
 * _.isNumber(3);
 * // => true
 *
 * _.isNumber(Number.MIN_VALUE);
 * // => true
 *
 * _.isNumber(Infinity);
 * // => true
 *
 * _.isNumber('3');
 * // => false
 */
function isNumber(value) {
  return typeof value == 'number' ||
    (isObjectLike(value) && baseGetTag(value) == numberTag);
}

module.exports = isNumber;


/***/ }),

/***/ "../../node_modules/lodash/isString.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/isString.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "../../node_modules/lodash/_baseGetTag.js"),
    isArray = __webpack_require__(/*! ./isArray */ "../../node_modules/lodash/isArray.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "../../node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var stringTag = '[object String]';

/**
 * Checks if `value` is classified as a `String` primitive or object.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a string, else `false`.
 * @example
 *
 * _.isString('abc');
 * // => true
 *
 * _.isString(1);
 * // => false
 */
function isString(value) {
  return typeof value == 'string' ||
    (!isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag);
}

module.exports = isString;


/***/ }),

/***/ "../../node_modules/lodash/merge.js":
/*!******************************************!*\
  !*** ../../node_modules/lodash/merge.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseMerge = __webpack_require__(/*! ./_baseMerge */ "../../node_modules/lodash/_baseMerge.js"),
    createAssigner = __webpack_require__(/*! ./_createAssigner */ "../../node_modules/lodash/_createAssigner.js");

/**
 * This method is like `_.assign` except that it recursively merges own and
 * inherited enumerable string keyed properties of source objects into the
 * destination object. Source properties that resolve to `undefined` are
 * skipped if a destination value exists. Array and plain object properties
 * are merged recursively. Other objects and value types are overridden by
 * assignment. Source objects are applied from left to right. Subsequent
 * sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 0.5.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @example
 *
 * var object = {
 *   'a': [{ 'b': 2 }, { 'd': 4 }]
 * };
 *
 * var other = {
 *   'a': [{ 'c': 3 }, { 'e': 5 }]
 * };
 *
 * _.merge(object, other);
 * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
 */
var merge = createAssigner(function(object, source, srcIndex) {
  baseMerge(object, source, srcIndex);
});

module.exports = merge;


/***/ }),

/***/ "../../node_modules/lodash/mergeWith.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/mergeWith.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseMerge = __webpack_require__(/*! ./_baseMerge */ "../../node_modules/lodash/_baseMerge.js"),
    createAssigner = __webpack_require__(/*! ./_createAssigner */ "../../node_modules/lodash/_createAssigner.js");

/**
 * This method is like `_.merge` except that it accepts `customizer` which
 * is invoked to produce the merged values of the destination and source
 * properties. If `customizer` returns `undefined`, merging is handled by the
 * method instead. The `customizer` is invoked with six arguments:
 * (objValue, srcValue, key, object, source, stack).
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} sources The source objects.
 * @param {Function} customizer The function to customize assigned values.
 * @returns {Object} Returns `object`.
 * @example
 *
 * function customizer(objValue, srcValue) {
 *   if (_.isArray(objValue)) {
 *     return objValue.concat(srcValue);
 *   }
 * }
 *
 * var object = { 'a': [1], 'b': [2] };
 * var other = { 'a': [3], 'b': [4] };
 *
 * _.mergeWith(object, other, customizer);
 * // => { 'a': [1, 3], 'b': [2, 4] }
 */
var mergeWith = createAssigner(function(object, source, srcIndex, customizer) {
  baseMerge(object, source, srcIndex, customizer);
});

module.exports = mergeWith;


/***/ }),

/***/ "../../node_modules/lodash/noop.js":
/*!*****************************************!*\
  !*** ../../node_modules/lodash/noop.js ***!
  \*****************************************/
/***/ ((module) => {

/**
 * This method returns `undefined`.
 *
 * @static
 * @memberOf _
 * @since 2.3.0
 * @category Util
 * @example
 *
 * _.times(2, _.noop);
 * // => [undefined, undefined]
 */
function noop() {
  // No operation performed.
}

module.exports = noop;


/***/ }),

/***/ "../../node_modules/lodash/property.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/property.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseProperty = __webpack_require__(/*! ./_baseProperty */ "../../node_modules/lodash/_baseProperty.js"),
    basePropertyDeep = __webpack_require__(/*! ./_basePropertyDeep */ "../../node_modules/lodash/_basePropertyDeep.js"),
    isKey = __webpack_require__(/*! ./_isKey */ "../../node_modules/lodash/_isKey.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "../../node_modules/lodash/_toKey.js");

/**
 * Creates a function that returns the value at `path` of a given object.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 * @example
 *
 * var objects = [
 *   { 'a': { 'b': 2 } },
 *   { 'a': { 'b': 1 } }
 * ];
 *
 * _.map(objects, _.property('a.b'));
 * // => [2, 1]
 *
 * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
 * // => [1, 2]
 */
function property(path) {
  return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
}

module.exports = property;


/***/ }),

/***/ "../../node_modules/lodash/pullAll.js":
/*!********************************************!*\
  !*** ../../node_modules/lodash/pullAll.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var basePullAll = __webpack_require__(/*! ./_basePullAll */ "../../node_modules/lodash/_basePullAll.js");

/**
 * This method is like `_.pull` except that it accepts an array of values to remove.
 *
 * **Note:** Unlike `_.difference`, this method mutates `array`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Array
 * @param {Array} array The array to modify.
 * @param {Array} values The values to remove.
 * @returns {Array} Returns `array`.
 * @example
 *
 * var array = ['a', 'b', 'c', 'a', 'b', 'c'];
 *
 * _.pullAll(array, ['a', 'c']);
 * console.log(array);
 * // => ['b', 'b']
 */
function pullAll(array, values) {
  return (array && array.length && values && values.length)
    ? basePullAll(array, values)
    : array;
}

module.exports = pullAll;


/***/ }),

/***/ "../../node_modules/lodash/reduce.js":
/*!*******************************************!*\
  !*** ../../node_modules/lodash/reduce.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayReduce = __webpack_require__(/*! ./_arrayReduce */ "../../node_modules/lodash/_arrayReduce.js"),
    baseEach = __webpack_require__(/*! ./_baseEach */ "../../node_modules/lodash/_baseEach.js"),
    baseIteratee = __webpack_require__(/*! ./_baseIteratee */ "../../node_modules/lodash/_baseIteratee.js"),
    baseReduce = __webpack_require__(/*! ./_baseReduce */ "../../node_modules/lodash/_baseReduce.js"),
    isArray = __webpack_require__(/*! ./isArray */ "../../node_modules/lodash/isArray.js");

/**
 * Reduces `collection` to a value which is the accumulated result of running
 * each element in `collection` thru `iteratee`, where each successive
 * invocation is supplied the return value of the previous. If `accumulator`
 * is not given, the first element of `collection` is used as the initial
 * value. The iteratee is invoked with four arguments:
 * (accumulator, value, index|key, collection).
 *
 * Many lodash methods are guarded to work as iteratees for methods like
 * `_.reduce`, `_.reduceRight`, and `_.transform`.
 *
 * The guarded methods are:
 * `assign`, `defaults`, `defaultsDeep`, `includes`, `merge`, `orderBy`,
 * and `sortBy`
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Collection
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @returns {*} Returns the accumulated value.
 * @see _.reduceRight
 * @example
 *
 * _.reduce([1, 2], function(sum, n) {
 *   return sum + n;
 * }, 0);
 * // => 3
 *
 * _.reduce({ 'a': 1, 'b': 2, 'c': 1 }, function(result, value, key) {
 *   (result[value] || (result[value] = [])).push(key);
 *   return result;
 * }, {});
 * // => { '1': ['a', 'c'], '2': ['b'] } (iteration order is not guaranteed)
 */
function reduce(collection, iteratee, accumulator) {
  var func = isArray(collection) ? arrayReduce : baseReduce,
      initAccum = arguments.length < 3;

  return func(collection, baseIteratee(iteratee, 4), accumulator, initAccum, baseEach);
}

module.exports = reduce;


/***/ }),

/***/ "../../node_modules/lodash/sortBy.js":
/*!*******************************************!*\
  !*** ../../node_modules/lodash/sortBy.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseFlatten = __webpack_require__(/*! ./_baseFlatten */ "../../node_modules/lodash/_baseFlatten.js"),
    baseOrderBy = __webpack_require__(/*! ./_baseOrderBy */ "../../node_modules/lodash/_baseOrderBy.js"),
    baseRest = __webpack_require__(/*! ./_baseRest */ "../../node_modules/lodash/_baseRest.js"),
    isIterateeCall = __webpack_require__(/*! ./_isIterateeCall */ "../../node_modules/lodash/_isIterateeCall.js");

/**
 * Creates an array of elements, sorted in ascending order by the results of
 * running each element in a collection thru each iteratee. This method
 * performs a stable sort, that is, it preserves the original sort order of
 * equal elements. The iteratees are invoked with one argument: (value).
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Collection
 * @param {Array|Object} collection The collection to iterate over.
 * @param {...(Function|Function[])} [iteratees=[_.identity]]
 *  The iteratees to sort by.
 * @returns {Array} Returns the new sorted array.
 * @example
 *
 * var users = [
 *   { 'user': 'fred',   'age': 48 },
 *   { 'user': 'barney', 'age': 36 },
 *   { 'user': 'fred',   'age': 30 },
 *   { 'user': 'barney', 'age': 34 }
 * ];
 *
 * _.sortBy(users, [function(o) { return o.user; }]);
 * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 30]]
 *
 * _.sortBy(users, ['user', 'age']);
 * // => objects for [['barney', 34], ['barney', 36], ['fred', 30], ['fred', 48]]
 */
var sortBy = baseRest(function(collection, iteratees) {
  if (collection == null) {
    return [];
  }
  var length = iteratees.length;
  if (length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
    iteratees = [];
  } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
    iteratees = [iteratees[0]];
  }
  return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
});

module.exports = sortBy;


/***/ }),

/***/ "../../node_modules/lodash/times.js":
/*!******************************************!*\
  !*** ../../node_modules/lodash/times.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseTimes = __webpack_require__(/*! ./_baseTimes */ "../../node_modules/lodash/_baseTimes.js"),
    castFunction = __webpack_require__(/*! ./_castFunction */ "../../node_modules/lodash/_castFunction.js"),
    toInteger = __webpack_require__(/*! ./toInteger */ "../../node_modules/lodash/toInteger.js");

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used as references for the maximum length and index of an array. */
var MAX_ARRAY_LENGTH = 4294967295;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMin = Math.min;

/**
 * Invokes the iteratee `n` times, returning an array of the results of
 * each invocation. The iteratee is invoked with one argument; (index).
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 * @example
 *
 * _.times(3, String);
 * // => ['0', '1', '2']
 *
 *  _.times(4, _.constant(0));
 * // => [0, 0, 0, 0]
 */
function times(n, iteratee) {
  n = toInteger(n);
  if (n < 1 || n > MAX_SAFE_INTEGER) {
    return [];
  }
  var index = MAX_ARRAY_LENGTH,
      length = nativeMin(n, MAX_ARRAY_LENGTH);

  iteratee = castFunction(iteratee);
  n -= MAX_ARRAY_LENGTH;

  var result = baseTimes(length, iteratee);
  while (++index < n) {
    iteratee(index);
  }
  return result;
}

module.exports = times;


/***/ }),

/***/ "../../node_modules/lodash/toFinite.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/toFinite.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toNumber = __webpack_require__(/*! ./toNumber */ "../../node_modules/lodash/toNumber.js");

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0,
    MAX_INTEGER = 1.7976931348623157e+308;

/**
 * Converts `value` to a finite number.
 *
 * @static
 * @memberOf _
 * @since 4.12.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted number.
 * @example
 *
 * _.toFinite(3.2);
 * // => 3.2
 *
 * _.toFinite(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toFinite(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toFinite('3.2');
 * // => 3.2
 */
function toFinite(value) {
  if (!value) {
    return value === 0 ? value : 0;
  }
  value = toNumber(value);
  if (value === INFINITY || value === -INFINITY) {
    var sign = (value < 0 ? -1 : 1);
    return sign * MAX_INTEGER;
  }
  return value === value ? value : 0;
}

module.exports = toFinite;


/***/ }),

/***/ "../../node_modules/lodash/toInteger.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/toInteger.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toFinite = __webpack_require__(/*! ./toFinite */ "../../node_modules/lodash/toFinite.js");

/**
 * Converts `value` to an integer.
 *
 * **Note:** This method is loosely based on
 * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted integer.
 * @example
 *
 * _.toInteger(3.2);
 * // => 3
 *
 * _.toInteger(Number.MIN_VALUE);
 * // => 0
 *
 * _.toInteger(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toInteger('3.2');
 * // => 3
 */
function toInteger(value) {
  var result = toFinite(value),
      remainder = result % 1;

  return result === result ? (remainder ? result - remainder : result) : 0;
}

module.exports = toInteger;


/***/ }),

/***/ "../../node_modules/lodash/toNumber.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/toNumber.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseTrim = __webpack_require__(/*! ./_baseTrim */ "../../node_modules/lodash/_baseTrim.js"),
    isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js"),
    isSymbol = __webpack_require__(/*! ./isSymbol */ "../../node_modules/lodash/isSymbol.js");

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = baseTrim(value);
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = toNumber;


/***/ }),

/***/ "../../node_modules/lodash/toPlainObject.js":
/*!**************************************************!*\
  !*** ../../node_modules/lodash/toPlainObject.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var copyObject = __webpack_require__(/*! ./_copyObject */ "../../node_modules/lodash/_copyObject.js"),
    keysIn = __webpack_require__(/*! ./keysIn */ "../../node_modules/lodash/keysIn.js");

/**
 * Converts `value` to a plain object flattening inherited enumerable string
 * keyed properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return copyObject(value, keysIn(value));
}

module.exports = toPlainObject;


/***/ }),

/***/ "../../node_modules/lodash/transform.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/transform.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayEach = __webpack_require__(/*! ./_arrayEach */ "../../node_modules/lodash/_arrayEach.js"),
    baseCreate = __webpack_require__(/*! ./_baseCreate */ "../../node_modules/lodash/_baseCreate.js"),
    baseForOwn = __webpack_require__(/*! ./_baseForOwn */ "../../node_modules/lodash/_baseForOwn.js"),
    baseIteratee = __webpack_require__(/*! ./_baseIteratee */ "../../node_modules/lodash/_baseIteratee.js"),
    getPrototype = __webpack_require__(/*! ./_getPrototype */ "../../node_modules/lodash/_getPrototype.js"),
    isArray = __webpack_require__(/*! ./isArray */ "../../node_modules/lodash/isArray.js"),
    isBuffer = __webpack_require__(/*! ./isBuffer */ "../../node_modules/lodash/isBuffer.js"),
    isFunction = __webpack_require__(/*! ./isFunction */ "../../node_modules/lodash/isFunction.js"),
    isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js"),
    isTypedArray = __webpack_require__(/*! ./isTypedArray */ "../../node_modules/lodash/isTypedArray.js");

/**
 * An alternative to `_.reduce`; this method transforms `object` to a new
 * `accumulator` object which is the result of running each of its own
 * enumerable string keyed properties thru `iteratee`, with each invocation
 * potentially mutating the `accumulator` object. If `accumulator` is not
 * provided, a new object with the same `[[Prototype]]` will be used. The
 * iteratee is invoked with four arguments: (accumulator, value, key, object).
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @static
 * @memberOf _
 * @since 1.3.0
 * @category Object
 * @param {Object} object The object to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @param {*} [accumulator] The custom accumulator value.
 * @returns {*} Returns the accumulated value.
 * @example
 *
 * _.transform([2, 3, 4], function(result, n) {
 *   result.push(n *= n);
 *   return n % 2 == 0;
 * }, []);
 * // => [4, 9]
 *
 * _.transform({ 'a': 1, 'b': 2, 'c': 1 }, function(result, value, key) {
 *   (result[value] || (result[value] = [])).push(key);
 * }, {});
 * // => { '1': ['a', 'c'], '2': ['b'] }
 */
function transform(object, iteratee, accumulator) {
  var isArr = isArray(object),
      isArrLike = isArr || isBuffer(object) || isTypedArray(object);

  iteratee = baseIteratee(iteratee, 4);
  if (accumulator == null) {
    var Ctor = object && object.constructor;
    if (isArrLike) {
      accumulator = isArr ? new Ctor : [];
    }
    else if (isObject(object)) {
      accumulator = isFunction(Ctor) ? baseCreate(getPrototype(object)) : {};
    }
    else {
      accumulator = {};
    }
  }
  (isArrLike ? arrayEach : baseForOwn)(object, function(value, index, object) {
    return iteratee(accumulator, value, index, object);
  });
  return accumulator;
}

module.exports = transform;


/***/ }),

/***/ "../../node_modules/lodash/union.js":
/*!******************************************!*\
  !*** ../../node_modules/lodash/union.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseFlatten = __webpack_require__(/*! ./_baseFlatten */ "../../node_modules/lodash/_baseFlatten.js"),
    baseRest = __webpack_require__(/*! ./_baseRest */ "../../node_modules/lodash/_baseRest.js"),
    baseUniq = __webpack_require__(/*! ./_baseUniq */ "../../node_modules/lodash/_baseUniq.js"),
    isArrayLikeObject = __webpack_require__(/*! ./isArrayLikeObject */ "../../node_modules/lodash/isArrayLikeObject.js");

/**
 * Creates an array of unique values, in order, from all given arrays using
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {...Array} [arrays] The arrays to inspect.
 * @returns {Array} Returns the new array of combined values.
 * @example
 *
 * _.union([2], [1, 2]);
 * // => [2, 1]
 */
var union = baseRest(function(arrays) {
  return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
});

module.exports = union;


/***/ }),

/***/ "../../node_modules/lodash/uniq.js":
/*!*****************************************!*\
  !*** ../../node_modules/lodash/uniq.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseUniq = __webpack_require__(/*! ./_baseUniq */ "../../node_modules/lodash/_baseUniq.js");

/**
 * Creates a duplicate-free version of an array, using
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons, in which only the first occurrence of each element
 * is kept. The order of result values is determined by the order they occur
 * in the array.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to inspect.
 * @returns {Array} Returns the new duplicate free array.
 * @example
 *
 * _.uniq([2, 1, 2]);
 * // => [2, 1]
 */
function uniq(array) {
  return (array && array.length) ? baseUniq(array) : [];
}

module.exports = uniq;


/***/ }),

/***/ "../../node_modules/lodash/uniqWith.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/uniqWith.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseUniq = __webpack_require__(/*! ./_baseUniq */ "../../node_modules/lodash/_baseUniq.js");

/**
 * This method is like `_.uniq` except that it accepts `comparator` which
 * is invoked to compare elements of `array`. The order of result values is
 * determined by the order they occur in the array.The comparator is invoked
 * with two arguments: (arrVal, othVal).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Array
 * @param {Array} array The array to inspect.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 * @example
 *
 * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 2 }];
 *
 * _.uniqWith(objects, _.isEqual);
 * // => [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]
 */
function uniqWith(array, comparator) {
  comparator = typeof comparator == 'function' ? comparator : undefined;
  return (array && array.length) ? baseUniq(array, undefined, comparator) : [];
}

module.exports = uniqWith;


/***/ }),

/***/ "../../node_modules/lodash/without.js":
/*!********************************************!*\
  !*** ../../node_modules/lodash/without.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseDifference = __webpack_require__(/*! ./_baseDifference */ "../../node_modules/lodash/_baseDifference.js"),
    baseRest = __webpack_require__(/*! ./_baseRest */ "../../node_modules/lodash/_baseRest.js"),
    isArrayLikeObject = __webpack_require__(/*! ./isArrayLikeObject */ "../../node_modules/lodash/isArrayLikeObject.js");

/**
 * Creates an array excluding all given values using
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * **Note:** Unlike `_.pull`, this method returns a new array.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to inspect.
 * @param {...*} [values] The values to exclude.
 * @returns {Array} Returns the new array of filtered values.
 * @see _.difference, _.xor
 * @example
 *
 * _.without([2, 1, 2, 3], 1, 2);
 * // => [3]
 */
var without = baseRest(function(array, values) {
  return isArrayLikeObject(array)
    ? baseDifference(array, values)
    : [];
});

module.exports = without;


/***/ }),

/***/ "../../node_modules/validate.io-array/lib/index.js":
/*!*********************************************************!*\
  !*** ../../node_modules/validate.io-array/lib/index.js ***!
  \*********************************************************/
/***/ ((module) => {

"use strict";


/**
* FUNCTION: isArray( value )
*	Validates if a value is an array.
*
* @param {*} value - value to be validated
* @returns {Boolean} boolean indicating whether value is an array
*/
function isArray( value ) {
	return Object.prototype.toString.call( value ) === '[object Array]';
} // end FUNCTION isArray()

// EXPORTS //

module.exports = Array.isArray || isArray;


/***/ }),

/***/ "../../node_modules/validate.io-function/lib/index.js":
/*!************************************************************!*\
  !*** ../../node_modules/validate.io-function/lib/index.js ***!
  \************************************************************/
/***/ ((module) => {

"use strict";
/**
*
*	VALIDATE: function
*
*
*	DESCRIPTION:
*		- Validates if a value is a function.
*
*
*	NOTES:
*		[1]
*
*
*	TODO:
*		[1]
*
*
*	LICENSE:
*		MIT
*
*	Copyright (c) 2014. Athan Reines.
*
*
*	AUTHOR:
*		Athan Reines. kgryte@gmail.com. 2014.
*
*/



/**
* FUNCTION: isFunction( value )
*	Validates if a value is a function.
*
* @param {*} value - value to be validated
* @returns {Boolean} boolean indicating whether value is a function
*/
function isFunction( value ) {
	return ( typeof value === 'function' );
} // end FUNCTION isFunction()


// EXPORTS //

module.exports = isFunction;


/***/ }),

/***/ "../../node_modules/validate.io-integer-array/lib/index.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/validate.io-integer-array/lib/index.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
*
*	VALIDATE: integer-array
*
*
*	DESCRIPTION:
*		- Validates if a value is an integer array.
*
*
*	NOTES:
*		[1]
*
*
*	TODO:
*		[1]
*
*
*	LICENSE:
*		MIT
*
*	Copyright (c) 2015. Athan Reines.
*
*
*	AUTHOR:
*		Athan Reines. kgryte@gmail.com. 2015.
*
*/



// MODULES //

var isArray = __webpack_require__( /*! validate.io-array */ "../../node_modules/validate.io-array/lib/index.js" ),
	isInteger = __webpack_require__( /*! validate.io-integer */ "../../node_modules/validate.io-integer/lib/index.js" );


// IS INTEGER ARRAY //

/**
* FUNCTION: isIntegerArray( value )
*	Validates if a value is an integer array.
*
* @param {*} value - value to be validated
* @returns {Boolean} boolean indicating if a value is an integer array
*/
function isIntegerArray( value ) {
	var len;
	if ( !isArray( value ) ) {
		return false;
	}
	len = value.length;
	if ( !len ) {
		return false;
	}
	for ( var i = 0; i < len; i++ ) {
		if ( !isInteger( value[i] ) ) {
			return false;
		}
	}
	return true;
} // end FUNCTION isIntegerArray()


// EXPORTS //

module.exports = isIntegerArray;


/***/ }),

/***/ "../../node_modules/validate.io-integer/lib/index.js":
/*!***********************************************************!*\
  !*** ../../node_modules/validate.io-integer/lib/index.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
*
*	VALIDATE: integer
*
*
*	DESCRIPTION:
*		- Validates if a value is an integer.
*
*
*	NOTES:
*		[1]
*
*
*	TODO:
*		[1]
*
*
*	LICENSE:
*		MIT
*
*	Copyright (c) 2014. Athan Reines.
*
*
*	AUTHOR:
*		Athan Reines. kgryte@gmail.com. 2014.
*
*/



// MODULES //

var isNumber = __webpack_require__( /*! validate.io-number */ "../../node_modules/validate.io-number/lib/index.js" );


// ISINTEGER //

/**
* FUNCTION: isInteger( value )
*	Validates if a value is an integer.
*
* @param {Number} value - value to be validated
* @returns {Boolean} boolean indicating whether value is an integer
*/
function isInteger( value ) {
	return isNumber( value ) && value%1 === 0;
} // end FUNCTION isInteger()


// EXPORTS //

module.exports = isInteger;


/***/ }),

/***/ "../../node_modules/validate.io-number/lib/index.js":
/*!**********************************************************!*\
  !*** ../../node_modules/validate.io-number/lib/index.js ***!
  \**********************************************************/
/***/ ((module) => {

"use strict";
/**
*
*	VALIDATE: number
*
*
*	DESCRIPTION:
*		- Validates if a value is a number.
*
*
*	NOTES:
*		[1]
*
*
*	TODO:
*		[1]
*
*
*	LICENSE:
*		MIT
*
*	Copyright (c) 2014. Athan Reines.
*
*
*	AUTHOR:
*		Athan Reines. kgryte@gmail.com. 2014.
*
*/



/**
* FUNCTION: isNumber( value )
*	Validates if a value is a number.
*
* @param {*} value - value to be validated
* @returns {Boolean} boolean indicating whether value is a number
*/
function isNumber( value ) {
	return ( typeof value === 'number' || Object.prototype.toString.call( value ) === '[object Number]' ) && value.valueOf() === value.valueOf();
} // end FUNCTION isNumber()


// EXPORTS //

module.exports = isNumber;


/***/ }),

/***/ "../../node_modules/fast-equals/dist/esm/index.mjs":
/*!*********************************************************!*\
  !*** ../../node_modules/fast-equals/dist/esm/index.mjs ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   circularDeepEqual: () => (/* binding */ circularDeepEqual),
/* harmony export */   circularShallowEqual: () => (/* binding */ circularShallowEqual),
/* harmony export */   createCustomEqual: () => (/* binding */ createCustomEqual),
/* harmony export */   deepEqual: () => (/* binding */ deepEqual),
/* harmony export */   sameValueZeroEqual: () => (/* binding */ sameValueZeroEqual),
/* harmony export */   shallowEqual: () => (/* binding */ shallowEqual),
/* harmony export */   strictCircularDeepEqual: () => (/* binding */ strictCircularDeepEqual),
/* harmony export */   strictCircularShallowEqual: () => (/* binding */ strictCircularShallowEqual),
/* harmony export */   strictDeepEqual: () => (/* binding */ strictDeepEqual),
/* harmony export */   strictShallowEqual: () => (/* binding */ strictShallowEqual)
/* harmony export */ });
var getOwnPropertyNames = Object.getOwnPropertyNames, getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
/**
 * Combine two comparators into a single comparators.
 */
function combineComparators(comparatorA, comparatorB) {
    return function isEqual(a, b, state) {
        return comparatorA(a, b, state) && comparatorB(a, b, state);
    };
}
/**
 * Wrap the provided `areItemsEqual` method to manage the circular state, allowing
 * for circular references to be safely included in the comparison without creating
 * stack overflows.
 */
function createIsCircular(areItemsEqual) {
    return function isCircular(a, b, state) {
        if (!a || !b || typeof a !== 'object' || typeof b !== 'object') {
            return areItemsEqual(a, b, state);
        }
        var cache = state.cache;
        var cachedA = cache.get(a);
        var cachedB = cache.get(b);
        if (cachedA && cachedB) {
            return cachedA === b && cachedB === a;
        }
        cache.set(a, b);
        cache.set(b, a);
        var result = areItemsEqual(a, b, state);
        cache.delete(a);
        cache.delete(b);
        return result;
    };
}
/**
 * Get the properties to strictly examine, which include both own properties that are
 * not enumerable and symbol properties.
 */
function getStrictProperties(object) {
    return getOwnPropertyNames(object).concat(getOwnPropertySymbols(object));
}
/**
 * Whether the object contains the property passed as an own property.
 */
var hasOwn = Object.hasOwn ||
    (function (object, property) {
        return hasOwnProperty.call(object, property);
    });
/**
 * Whether the values passed are strictly equal or both NaN.
 */
function sameValueZeroEqual(a, b) {
    return a || b ? a === b : a === b || (a !== a && b !== b);
}

var OWNER = '_owner';
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, keys = Object.keys;
/**
 * Whether the arrays are equal in value.
 */
function areArraysEqual(a, b, state) {
    var index = a.length;
    if (b.length !== index) {
        return false;
    }
    while (index-- > 0) {
        if (!state.equals(a[index], b[index], index, index, a, b, state)) {
            return false;
        }
    }
    return true;
}
/**
 * Whether the dates passed are equal in value.
 */
function areDatesEqual(a, b) {
    return sameValueZeroEqual(a.getTime(), b.getTime());
}
/**
 * Whether the `Map`s are equal in value.
 */
function areMapsEqual(a, b, state) {
    if (a.size !== b.size) {
        return false;
    }
    var matchedIndices = {};
    var aIterable = a.entries();
    var index = 0;
    var aResult;
    var bResult;
    while ((aResult = aIterable.next())) {
        if (aResult.done) {
            break;
        }
        var bIterable = b.entries();
        var hasMatch = false;
        var matchIndex = 0;
        while ((bResult = bIterable.next())) {
            if (bResult.done) {
                break;
            }
            var _a = aResult.value, aKey = _a[0], aValue = _a[1];
            var _b = bResult.value, bKey = _b[0], bValue = _b[1];
            if (!hasMatch &&
                !matchedIndices[matchIndex] &&
                (hasMatch =
                    state.equals(aKey, bKey, index, matchIndex, a, b, state) &&
                        state.equals(aValue, bValue, aKey, bKey, a, b, state))) {
                matchedIndices[matchIndex] = true;
            }
            matchIndex++;
        }
        if (!hasMatch) {
            return false;
        }
        index++;
    }
    return true;
}
/**
 * Whether the objects are equal in value.
 */
function areObjectsEqual(a, b, state) {
    var properties = keys(a);
    var index = properties.length;
    if (keys(b).length !== index) {
        return false;
    }
    var property;
    // Decrementing `while` showed faster results than either incrementing or
    // decrementing `for` loop and than an incrementing `while` loop. Declarative
    // methods like `some` / `every` were not used to avoid incurring the garbage
    // cost of anonymous callbacks.
    while (index-- > 0) {
        property = properties[index];
        if (property === OWNER &&
            (a.$$typeof || b.$$typeof) &&
            a.$$typeof !== b.$$typeof) {
            return false;
        }
        if (!hasOwn(b, property) ||
            !state.equals(a[property], b[property], property, property, a, b, state)) {
            return false;
        }
    }
    return true;
}
/**
 * Whether the objects are equal in value with strict property checking.
 */
function areObjectsEqualStrict(a, b, state) {
    var properties = getStrictProperties(a);
    var index = properties.length;
    if (getStrictProperties(b).length !== index) {
        return false;
    }
    var property;
    var descriptorA;
    var descriptorB;
    // Decrementing `while` showed faster results than either incrementing or
    // decrementing `for` loop and than an incrementing `while` loop. Declarative
    // methods like `some` / `every` were not used to avoid incurring the garbage
    // cost of anonymous callbacks.
    while (index-- > 0) {
        property = properties[index];
        if (property === OWNER &&
            (a.$$typeof || b.$$typeof) &&
            a.$$typeof !== b.$$typeof) {
            return false;
        }
        if (!hasOwn(b, property)) {
            return false;
        }
        if (!state.equals(a[property], b[property], property, property, a, b, state)) {
            return false;
        }
        descriptorA = getOwnPropertyDescriptor(a, property);
        descriptorB = getOwnPropertyDescriptor(b, property);
        if ((descriptorA || descriptorB) &&
            (!descriptorA ||
                !descriptorB ||
                descriptorA.configurable !== descriptorB.configurable ||
                descriptorA.enumerable !== descriptorB.enumerable ||
                descriptorA.writable !== descriptorB.writable)) {
            return false;
        }
    }
    return true;
}
/**
 * Whether the primitive wrappers passed are equal in value.
 */
function arePrimitiveWrappersEqual(a, b) {
    return sameValueZeroEqual(a.valueOf(), b.valueOf());
}
/**
 * Whether the regexps passed are equal in value.
 */
function areRegExpsEqual(a, b) {
    return a.source === b.source && a.flags === b.flags;
}
/**
 * Whether the `Set`s are equal in value.
 */
function areSetsEqual(a, b, state) {
    if (a.size !== b.size) {
        return false;
    }
    var matchedIndices = {};
    var aIterable = a.values();
    var aResult;
    var bResult;
    while ((aResult = aIterable.next())) {
        if (aResult.done) {
            break;
        }
        var bIterable = b.values();
        var hasMatch = false;
        var matchIndex = 0;
        while ((bResult = bIterable.next())) {
            if (bResult.done) {
                break;
            }
            if (!hasMatch &&
                !matchedIndices[matchIndex] &&
                (hasMatch = state.equals(aResult.value, bResult.value, aResult.value, bResult.value, a, b, state))) {
                matchedIndices[matchIndex] = true;
            }
            matchIndex++;
        }
        if (!hasMatch) {
            return false;
        }
    }
    return true;
}
/**
 * Whether the TypedArray instances are equal in value.
 */
function areTypedArraysEqual(a, b) {
    var index = a.length;
    if (b.length !== index) {
        return false;
    }
    while (index-- > 0) {
        if (a[index] !== b[index]) {
            return false;
        }
    }
    return true;
}

var ARGUMENTS_TAG = '[object Arguments]';
var BOOLEAN_TAG = '[object Boolean]';
var DATE_TAG = '[object Date]';
var MAP_TAG = '[object Map]';
var NUMBER_TAG = '[object Number]';
var OBJECT_TAG = '[object Object]';
var REG_EXP_TAG = '[object RegExp]';
var SET_TAG = '[object Set]';
var STRING_TAG = '[object String]';
var isArray = Array.isArray;
var isTypedArray = typeof ArrayBuffer === 'function' && ArrayBuffer.isView
    ? ArrayBuffer.isView
    : null;
var assign = Object.assign;
var getTag = Object.prototype.toString.call.bind(Object.prototype.toString);
/**
 * Create a comparator method based on the type-specific equality comparators passed.
 */
function createEqualityComparator(_a) {
    var areArraysEqual = _a.areArraysEqual, areDatesEqual = _a.areDatesEqual, areMapsEqual = _a.areMapsEqual, areObjectsEqual = _a.areObjectsEqual, arePrimitiveWrappersEqual = _a.arePrimitiveWrappersEqual, areRegExpsEqual = _a.areRegExpsEqual, areSetsEqual = _a.areSetsEqual, areTypedArraysEqual = _a.areTypedArraysEqual;
    /**
     * compare the value of the two objects and return true if they are equivalent in values
     */
    return function comparator(a, b, state) {
        // If the items are strictly equal, no need to do a value comparison.
        if (a === b) {
            return true;
        }
        // If the items are not non-nullish objects, then the only possibility
        // of them being equal but not strictly is if they are both `NaN`. Since
        // `NaN` is uniquely not equal to itself, we can use self-comparison of
        // both objects, which is faster than `isNaN()`.
        if (a == null ||
            b == null ||
            typeof a !== 'object' ||
            typeof b !== 'object') {
            return a !== a && b !== b;
        }
        var constructor = a.constructor;
        // Checks are listed in order of commonality of use-case:
        //   1. Common complex object types (plain object, array)
        //   2. Common data values (date, regexp)
        //   3. Less-common complex object types (map, set)
        //   4. Less-common data values (promise, primitive wrappers)
        // Inherently this is both subjective and assumptive, however
        // when reviewing comparable libraries in the wild this order
        // appears to be generally consistent.
        // Constructors should match, otherwise there is potential for false positives
        // between class and subclass or custom object and POJO.
        if (constructor !== b.constructor) {
            return false;
        }
        // `isPlainObject` only checks against the object's own realm. Cross-realm
        // comparisons are rare, and will be handled in the ultimate fallback, so
        // we can avoid capturing the string tag.
        if (constructor === Object) {
            return areObjectsEqual(a, b, state);
        }
        // `isArray()` works on subclasses and is cross-realm, so we can avoid capturing
        // the string tag or doing an `instanceof` check.
        if (isArray(a)) {
            return areArraysEqual(a, b, state);
        }
        // `isTypedArray()` works on all possible TypedArray classes, so we can avoid
        // capturing the string tag or comparing against all possible constructors.
        if (isTypedArray != null && isTypedArray(a)) {
            return areTypedArraysEqual(a, b, state);
        }
        // Try to fast-path equality checks for other complex object types in the
        // same realm to avoid capturing the string tag. Strict equality is used
        // instead of `instanceof` because it is more performant for the common
        // use-case. If someone is subclassing a native class, it will be handled
        // with the string tag comparison.
        if (constructor === Date) {
            return areDatesEqual(a, b, state);
        }
        if (constructor === RegExp) {
            return areRegExpsEqual(a, b, state);
        }
        if (constructor === Map) {
            return areMapsEqual(a, b, state);
        }
        if (constructor === Set) {
            return areSetsEqual(a, b, state);
        }
        // Since this is a custom object, capture the string tag to determing its type.
        // This is reasonably performant in modern environments like v8 and SpiderMonkey.
        var tag = getTag(a);
        if (tag === DATE_TAG) {
            return areDatesEqual(a, b, state);
        }
        if (tag === REG_EXP_TAG) {
            return areRegExpsEqual(a, b, state);
        }
        if (tag === MAP_TAG) {
            return areMapsEqual(a, b, state);
        }
        if (tag === SET_TAG) {
            return areSetsEqual(a, b, state);
        }
        if (tag === OBJECT_TAG) {
            // The exception for value comparison is custom `Promise`-like class instances. These should
            // be treated the same as standard `Promise` objects, which means strict equality, and if
            // it reaches this point then that strict equality comparison has already failed.
            return (typeof a.then !== 'function' &&
                typeof b.then !== 'function' &&
                areObjectsEqual(a, b, state));
        }
        // If an arguments tag, it should be treated as a standard object.
        if (tag === ARGUMENTS_TAG) {
            return areObjectsEqual(a, b, state);
        }
        // As the penultimate fallback, check if the values passed are primitive wrappers. This
        // is very rare in modern JS, which is why it is deprioritized compared to all other object
        // types.
        if (tag === BOOLEAN_TAG || tag === NUMBER_TAG || tag === STRING_TAG) {
            return arePrimitiveWrappersEqual(a, b, state);
        }
        // If not matching any tags that require a specific type of comparison, then we hard-code false because
        // the only thing remaining is strict equality, which has already been compared. This is for a few reasons:
        //   - Certain types that cannot be introspected (e.g., `WeakMap`). For these types, this is the only
        //     comparison that can be made.
        //   - For types that can be introspected, but rarely have requirements to be compared
        //     (`ArrayBuffer`, `DataView`, etc.), the cost is avoided to prioritize the common
        //     use-cases (may be included in a future release, if requested enough).
        //   - For types that can be introspected but do not have an objective definition of what
        //     equality is (`Error`, etc.), the subjective decision is to be conservative and strictly compare.
        // In all cases, these decisions should be reevaluated based on changes to the language and
        // common development practices.
        return false;
    };
}
/**
 * Create the configuration object used for building comparators.
 */
function createEqualityComparatorConfig(_a) {
    var circular = _a.circular, createCustomConfig = _a.createCustomConfig, strict = _a.strict;
    var config = {
        areArraysEqual: strict
            ? areObjectsEqualStrict
            : areArraysEqual,
        areDatesEqual: areDatesEqual,
        areMapsEqual: strict
            ? combineComparators(areMapsEqual, areObjectsEqualStrict)
            : areMapsEqual,
        areObjectsEqual: strict
            ? areObjectsEqualStrict
            : areObjectsEqual,
        arePrimitiveWrappersEqual: arePrimitiveWrappersEqual,
        areRegExpsEqual: areRegExpsEqual,
        areSetsEqual: strict
            ? combineComparators(areSetsEqual, areObjectsEqualStrict)
            : areSetsEqual,
        areTypedArraysEqual: strict
            ? areObjectsEqualStrict
            : areTypedArraysEqual,
    };
    if (createCustomConfig) {
        config = assign({}, config, createCustomConfig(config));
    }
    if (circular) {
        var areArraysEqual$1 = createIsCircular(config.areArraysEqual);
        var areMapsEqual$1 = createIsCircular(config.areMapsEqual);
        var areObjectsEqual$1 = createIsCircular(config.areObjectsEqual);
        var areSetsEqual$1 = createIsCircular(config.areSetsEqual);
        config = assign({}, config, {
            areArraysEqual: areArraysEqual$1,
            areMapsEqual: areMapsEqual$1,
            areObjectsEqual: areObjectsEqual$1,
            areSetsEqual: areSetsEqual$1,
        });
    }
    return config;
}
/**
 * Default equality comparator pass-through, used as the standard `isEqual` creator for
 * use inside the built comparator.
 */
function createInternalEqualityComparator(compare) {
    return function (a, b, _indexOrKeyA, _indexOrKeyB, _parentA, _parentB, state) {
        return compare(a, b, state);
    };
}
/**
 * Create the `isEqual` function used by the consuming application.
 */
function createIsEqual(_a) {
    var circular = _a.circular, comparator = _a.comparator, createState = _a.createState, equals = _a.equals, strict = _a.strict;
    if (createState) {
        return function isEqual(a, b) {
            var _a = createState(), _b = _a.cache, cache = _b === void 0 ? circular ? new WeakMap() : undefined : _b, meta = _a.meta;
            return comparator(a, b, {
                cache: cache,
                equals: equals,
                meta: meta,
                strict: strict,
            });
        };
    }
    if (circular) {
        return function isEqual(a, b) {
            return comparator(a, b, {
                cache: new WeakMap(),
                equals: equals,
                meta: undefined,
                strict: strict,
            });
        };
    }
    var state = {
        cache: undefined,
        equals: equals,
        meta: undefined,
        strict: strict,
    };
    return function isEqual(a, b) {
        return comparator(a, b, state);
    };
}

/**
 * Whether the items passed are deeply-equal in value.
 */
var deepEqual = createCustomEqual();
/**
 * Whether the items passed are deeply-equal in value based on strict comparison.
 */
var strictDeepEqual = createCustomEqual({ strict: true });
/**
 * Whether the items passed are deeply-equal in value, including circular references.
 */
var circularDeepEqual = createCustomEqual({ circular: true });
/**
 * Whether the items passed are deeply-equal in value, including circular references,
 * based on strict comparison.
 */
var strictCircularDeepEqual = createCustomEqual({
    circular: true,
    strict: true,
});
/**
 * Whether the items passed are shallowly-equal in value.
 */
var shallowEqual = createCustomEqual({
    createInternalComparator: function () { return sameValueZeroEqual; },
});
/**
 * Whether the items passed are shallowly-equal in value based on strict comparison
 */
var strictShallowEqual = createCustomEqual({
    strict: true,
    createInternalComparator: function () { return sameValueZeroEqual; },
});
/**
 * Whether the items passed are shallowly-equal in value, including circular references.
 */
var circularShallowEqual = createCustomEqual({
    circular: true,
    createInternalComparator: function () { return sameValueZeroEqual; },
});
/**
 * Whether the items passed are shallowly-equal in value, including circular references,
 * based on strict comparison.
 */
var strictCircularShallowEqual = createCustomEqual({
    circular: true,
    createInternalComparator: function () { return sameValueZeroEqual; },
    strict: true,
});
/**
 * Create a custom equality comparison method.
 *
 * This can be done to create very targeted comparisons in extreme hot-path scenarios
 * where the standard methods are not performant enough, but can also be used to provide
 * support for legacy environments that do not support expected features like
 * `RegExp.prototype.flags` out of the box.
 */
function createCustomEqual(options) {
    if (options === void 0) { options = {}; }
    var _a = options.circular, circular = _a === void 0 ? false : _a, createCustomInternalComparator = options.createInternalComparator, createState = options.createState, _b = options.strict, strict = _b === void 0 ? false : _b;
    var config = createEqualityComparatorConfig(options);
    var comparator = createEqualityComparator(config);
    var equals = createCustomInternalComparator
        ? createCustomInternalComparator(comparator)
        : createInternalEqualityComparator(comparator);
    return createIsEqual({ circular: circular, comparator: comparator, createState: createState, equals: equals, strict: strict });
}


//# sourceMappingURL=index.mjs.map


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_rjsf_utils_lib_index_js.b4c1295e129c122cbd5a.js.map