"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.YamlFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const YAML = require("yaml");
class YamlFile {
    constructor(filePath, options = {}) {
        this.filePath = filePath;
        this.obj = options.obj ?? {};
        // default value for commentAtTop
        this.commentAtTop = `AUTOMATICALLY GENERATED FILE, DO NOT EDIT MANUALLY.
Generated by @awlsring/cdktf-github-actions.`;
    }
    /**
     * Update the output object.
     */
    update(obj) {
        this.obj = obj;
    }
    /**
     * Returns the patched yaml file.
     */
    toYaml() {
        const obj = JSON.parse(JSON.stringify(this.obj));
        const yamlDoc = new YAML.Document(obj);
        yamlDoc.commentBefore = this.commentAtTop ?? null;
        return yamlDoc.toString({
            commentString: (comment) => comment.split('\n').map((x) => x == '' ? '' : `# ${x}`).join('\n'),
            indent: 2,
        });
    }
    /**
     * Write the patched yaml file to the specified location.
     */
    writeFile() {
        fs_1.writeFileSync(this.filePath, this.toYaml());
    }
}
exports.YamlFile = YamlFile;
_a = JSII_RTTI_SYMBOL_1;
YamlFile[_a] = { fqn: "@awlsring/cdktf-github-actions.YamlFile", version: "0.0.319" };
//# sourceMappingURL=data:application/json;base64,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