# Generated by Django 3.0 on 2019-12-04 06:25

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Post",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("subject", models.CharField(blank=True, max_length=250)),
                ("comment", models.TextField(max_length=2500)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "parent_thread",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="replies",
                        to="main.Post",
                    ),
                ),
            ],
            options={"db_table": "post"},
        ),
        migrations.AddConstraint(
            model_name="post",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        ("parent_thread__isnull", True),
                        models.Q(_negated=True, subject=""),
                    ),
                    models.Q(("parent_thread__isnull", False), ("subject", "")),
                    _connector="OR",
                ),
                name="has_subject_iff_is_thread",
            ),
        ),
    ]
