"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const iam = require("../lib");
describe('IAM grant', () => {
    test('Grant.drop() returns a no-op grant', () => {
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'poo');
        const grant = lib_1.Grant.drop(user, 'dropping me');
        expect(grant.success).toBeFalsy();
        expect(grant.principalStatement).toBeUndefined();
        expect(grant.resourceStatement).toBeUndefined();
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ3JhbnQudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImdyYW50LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQ0FBOEI7QUFDOUIsd0NBQXNDO0FBQ3RDLGdDQUErQjtBQUMvQiw4QkFBK0I7QUFFL0IsUUFBUSxDQUFDLFdBQVcsRUFBRSxHQUFHLEVBQUU7SUFDekIsSUFBSSxDQUFDLG9DQUFvQyxFQUFFLEdBQUcsRUFBRTtRQUM5QyxNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssRUFBRSxDQUFDO1FBQzFCLE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDeEMsTUFBTSxLQUFLLEdBQUcsV0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsYUFBYSxDQUFDLENBQUM7UUFFOUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUNsQyxNQUFNLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDakQsTUFBTSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2xELENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgJ0Bhd3MtY2RrL2Fzc2VydC9qZXN0JztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBHcmFudCB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgaWFtID0gcmVxdWlyZSgnLi4vbGliJyk7XG5cbmRlc2NyaWJlKCdJQU0gZ3JhbnQnLCAoKSA9PiB7XG4gIHRlc3QoJ0dyYW50LmRyb3AoKSByZXR1cm5zIGEgbm8tb3AgZ3JhbnQnLCAoKSA9PiB7XG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcbiAgICBjb25zdCB1c2VyID0gbmV3IGlhbS5Vc2VyKHN0YWNrLCAncG9vJyk7XG4gICAgY29uc3QgZ3JhbnQgPSBHcmFudC5kcm9wKHVzZXIsICdkcm9wcGluZyBtZScpO1xuXG4gICAgZXhwZWN0KGdyYW50LnN1Y2Nlc3MpLnRvQmVGYWxzeSgpO1xuICAgIGV4cGVjdChncmFudC5wcmluY2lwYWxTdGF0ZW1lbnQpLnRvQmVVbmRlZmluZWQoKTtcbiAgICBleHBlY3QoZ3JhbnQucmVzb3VyY2VTdGF0ZW1lbnQpLnRvQmVVbmRlZmluZWQoKTtcbiAgfSk7XG59KTtcbiJdfQ==