"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-iam-role-1');
const role = new lib_1.Role(stack, 'TestRole', {
    assumedBy: new lib_1.ServicePrincipal('sqs.amazonaws.com')
});
role.addToPolicy(new lib_1.PolicyStatement({ resources: ['*'], actions: ['sqs:SendMessage'] }));
const policy = new lib_1.Policy(stack, 'HelloPolicy', { policyName: 'Default' });
policy.addStatements(new lib_1.PolicyStatement({ actions: ['ec2:*'], resources: ['*'] }));
policy.attachToRole(role);
// Role with an external ID
new lib_1.Role(stack, 'TestRole2', {
    assumedBy: new lib_1.AccountRootPrincipal(),
    externalIds: ['supply-me'],
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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