/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.datetime;

import io.qameta.allure.datetime.DateTimeParser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDateTimeParser
implements DateTimeParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeDateTimeParser.class);
    private final List<DateTimeParser> parsers;

    public CompositeDateTimeParser(DateTimeParser ... parsers) {
        this(Arrays.asList(parsers));
    }

    public CompositeDateTimeParser(List<DateTimeParser> parsers) {
        this.parsers = parsers;
    }

    @Override
    public Optional<Long> getEpochMilli(String time) {
        for (DateTimeParser parser : this.parsers) {
            try {
                return parser.getEpochMilli(time);
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse time {} using parser {}", new Object[]{time, parser, e});
            }
        }
        return Optional.empty();
    }
}

