/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.core;

import io.qameta.allure.Aggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.Attachment;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;

public class AttachmentsPlugin
implements Aggregator {
    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) throws IOException {
        Path attachmentsFolder = Files.createDirectories(outputDirectory.resolve("data").resolve("attachments"), new FileAttribute[0]);
        for (LaunchResults launch : launchesResults) {
            for (Map.Entry entry : launch.getAttachments().entrySet()) {
                Path file = attachmentsFolder.resolve(((Attachment)entry.getValue()).getSource());
                Files.copy((Path)entry.getKey(), file, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

