# coding: utf-8

# flake8: noqa
"""
    Universal DDI Anycast API

    Anycast capability enables HA (High Availability) configuration of Universal DDI applications that run on equipment located on customer's premises (on-prem hosts). Anycast supports DNS, as well as DNS-forwarding services.  Anycast-enabled application setups use multiple on-premises installations for one particular application type. Multiple application instances are configured to use the same endpoint address. Anycast capability is collocated with such application instance, monitoring the local application instance and advertising to the upstream router (a customer equipment) a per-instance, local route to the common application endpoint address, as long as the local application instance is available. Depending on the type of the upstream router, the customer may configure local route advertisement via either BGP (Boarder Gateway Protocol) or OSPF (Open Shortest Path First) routing protocols. Both protocols may be enabled as well. Multiple routes to the common application service address provide redundancy without the need to reconfigure application clients.  Should an application instance become unavailable, the local route advertisements stop, resulting in withdrawal of the route (in the upstream router) to the application instance that has gone out of service and ensuring that subsequent application requests thus get routed to the remaining available application instances.  

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

# import models into model package
from anycast.models.anycast_config import AnycastConfig
from anycast.models.anycast_config_ref import AnycastConfigRef
from anycast.models.anycast_config_response import AnycastConfigResponse
from anycast.models.anycast_version import AnycastVersion
from anycast.models.bgp_config import BgpConfig
from anycast.models.bgp_neighbor import BgpNeighbor
from anycast.models.get_anycast_config_list_response import GetAnycastConfigListResponse
from anycast.models.onprem_host import OnpremHost
from anycast.models.onprem_host_ref import OnpremHostRef
from anycast.models.onprem_host_response import OnpremHostResponse
from anycast.models.ospf_config import OspfConfig
from anycast.models.ospfv3_config import Ospfv3Config
from anycast.models.protobuf_field_mask import ProtobufFieldMask
from anycast.models.service_config import ServiceConfig
from anycast.models.service_config_object import ServiceConfigObject
from anycast.models.service_status_code import ServiceStatusCode
from anycast.models.service_status_update_request import ServiceStatusUpdateRequest
