# coding: utf-8

"""
    Universal DDI Anycast API

    Anycast capability enables HA (High Availability) configuration of Universal DDI applications that run on equipment located on customer's premises (on-prem hosts). Anycast supports DNS, as well as DNS-forwarding services.  Anycast-enabled application setups use multiple on-premises installations for one particular application type. Multiple application instances are configured to use the same endpoint address. Anycast capability is collocated with such application instance, monitoring the local application instance and advertising to the upstream router (a customer equipment) a per-instance, local route to the common application endpoint address, as long as the local application instance is available. Depending on the type of the upstream router, the customer may configure local route advertisement via either BGP (Boarder Gateway Protocol) or OSPF (Open Shortest Path First) routing protocols. Both protocols may be enabled as well. Multiple routes to the common application service address provide redundancy without the need to reconfigure application clients.  Should an application instance become unavailable, the local route advertisements stop, resulting in withdrawal of the route (in the upstream router) to the application instance that has gone out of service and ensuring that subsequent application requests thus get routed to the remaining available application instances.  

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class ServiceStatusCode(str, Enum):
    """
    ServiceStatusCode
    """
    """
    allowed enum values
    """
    SUCCESS = 'SUCCESS'
    GENERAL_FAILURE = 'GENERAL_FAILURE'
    HASH_FAILURE = 'HASH_FAILURE'
    VALIDATION_FAILURE = 'VALIDATION_FAILURE'
    COPY_FAILURE = 'COPY_FAILURE'
    RELOAD_FAILIURE = 'RELOAD_FAILIURE'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ServiceStatusCode from a JSON string"""
        return cls(json.loads(json_str))
