# coding: utf-8

"""
    Discovery Configuration API V2

    The Discovery configuration service is a Universal DDI Service that provides configuration for accessing and syncing the Cloud assets   Base Paths:  1. provider: **/api/cloud_discovery/v2/**  

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class Account(BaseModel):
    """
    Source account information
    """

  # noqa: E501
    composite_status: Optional[StrictStr] = None
    composite_status_message: Optional[StrictStr] = Field(
        default=None, description="Status message of the sync operation.")
    created_at: Optional[datetime] = Field(
        default=None,
        description="Timestamp when the object has been created.")
    deleted_at: Optional[datetime] = Field(
        default=None,
        description="Timestamp when the object has been deleted.")
    dhcp_server_id: Optional[StrictStr] = None
    dns_server_id: Optional[StrictStr] = Field(default=None,
                                               description="DNS Server ID.")
    id: Optional[StrictStr] = Field(
        default=None,
        description="Auto-generated unique source account ID. Format BloxID.")
    last_successful_sync: Optional[datetime] = Field(
        default=None, description="Last successful sync timestamp.")
    last_sync: Optional[datetime] = Field(default=None,
                                          description="Last sync timestamp.")
    name: StrictStr = Field(description="Name of the source account.")
    parent_id: Optional[StrictStr] = Field(default=None,
                                           description="Parent ID.")
    percent_complete: Optional[StrictInt] = Field(
        default=None, description="Sync progress as a percentage.")
    provider_account_id: Optional[StrictStr] = None
    schedule_id: Optional[StrictStr] = Field(default=None,
                                             description="Schedule ID.")
    state: Optional[StrictStr] = None
    status: Optional[StrictStr] = Field(
        default=None, description="Status of the sync operation.")
    status_message: Optional[StrictStr] = Field(
        default=None, description="Status message of the sync operation.")
    updated_at: Optional[datetime] = Field(
        default=None,
        description="Timestamp when the object has been updated.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "composite_status", "composite_status_message", "created_at",
        "deleted_at", "dhcp_server_id", "dns_server_id", "id",
        "last_successful_sync", "last_sync", "name", "parent_id",
        "percent_complete", "provider_account_id", "schedule_id", "state",
        "status", "status_message", "updated_at"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Account from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "deleted_at",
            "dhcp_server_id",
            "dns_server_id",
            "id",
            "last_successful_sync",
            "last_sync",
            "percent_complete",
            "schedule_id",
            "state",
            "status",
            "status_message",
            "updated_at",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Account from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "composite_status":
            obj.get("composite_status"),
            "composite_status_message":
            obj.get("composite_status_message"),
            "created_at":
            obj.get("created_at"),
            "deleted_at":
            obj.get("deleted_at"),
            "dhcp_server_id":
            obj.get("dhcp_server_id"),
            "dns_server_id":
            obj.get("dns_server_id"),
            "id":
            obj.get("id"),
            "last_successful_sync":
            obj.get("last_successful_sync"),
            "last_sync":
            obj.get("last_sync"),
            "name":
            obj.get("name"),
            "parent_id":
            obj.get("parent_id"),
            "percent_complete":
            obj.get("percent_complete"),
            "provider_account_id":
            obj.get("provider_account_id"),
            "schedule_id":
            obj.get("schedule_id"),
            "state":
            obj.get("state"),
            "status":
            obj.get("status"),
            "status_message":
            obj.get("status_message"),
            "updated_at":
            obj.get("updated_at")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
