# coding: utf-8

"""
    DFP API

    Infoblox Cloud is a SaaS offering designed to provide protection to devices on and off-premises, including roaming, remote, and branch offices. It provides visibility into infected and compromised devices, prevents DNS-based data exfiltration, and automatically stops device communications with command-and-control servers (C&Cs) and botnets, in addition to providing recursive DNS services in the cloud. You can access the services by deploying the Infoblox Endpoint agent or the DNS forwarding proxy.  For remote office deployments or in cases where installing an endpoint agent is not desirable or possible, you can use the DNS forwarding proxy. It is a software that runs on bare-metal, VM infrastructures, or Infoblox NIOS appliances; and it embeds the client IPs in DNS queries before forwarding them to Infoblox Cloud. The communications are encrypted and client visibility is maintained. The proxy also provides DNS resolution to local DNS zones when you configure local resolvers. Once you set up a DNS forwarding proxy, it becomes the main DNS server for your remote site. It will also cache responses to speed resolution of future queries.  By implementing the DNS forwarding proxy, you can rest assured that Infoblox Cloud effectively enforces DNS client-based security policies at your remote sites. On-premises devices that send DNS queries reveal their actual client IP addresses (instead of their NAT IP address), which allows Infoblox Cloud to apply the security policies applicable to the respective endpoints and identify infected clients. 

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dfp.models.dfp_host import DfpHost
from dfp.models.resolver import Resolver
from typing import Optional, Set
from typing_extensions import Self


class DfpCreateOrUpdatePayload(BaseModel):
    """
    DNS Forwarding Proxy object.  For remote office deployments or in cases where installing an endpoint agent is not desirable or possible, you can use the DNS forwarding proxy. It is a software that runs on bare-metal, VM infrastructures, or Infoblox NIOS appliances; and it embeds the client IPs in DNS queries before forwarding them to Infoblox Cloud. The communications are encrypted and client visibility is maintained. The proxy also provides DNS resolution to local DNS zones when you configure local resolvers. Once you set up a DNS forwarding proxy, it becomes the main DNS server for your remote site. It will also cache responses to speed resolution of future queries.  Note that DNS Forwarding Proxy cannot be created (all information regarding DFP is synchronized from hostapp service).
    """ # noqa: E501
    forwarding_policy: Optional[StrictStr] = Field(
        default=None,
        description=
        "The type of DNS resolver as Forwarding Policy. It can hold values as ib_cloud_first, external_first or external_only The default value is ib_cloud_first. If empty string is sent then ib_cloud_first will be considered."
    )
    host: Optional[List[DfpHost]] = Field(
        default=None, description="host information. For internal Use only.")
    id: Optional[StrictInt] = Field(
        default=None,
        description="The DNS Forwarding Proxy object identifier.")
    internal_domain_lists: Optional[List[StrictInt]] = Field(
        default=None,
        description=
        "The list of internal domain list ids associated with this DFP (or resolvers)"
    )
    name: Optional[StrictStr] = Field(
        default=None, description="The name of the DNS Forwarding Proxy.")
    pop_region_id: Optional[StrictInt] = Field(
        default=None, description="Point of Presence (PoP) region")
    resolvers_all: Optional[List[Resolver]] = Field(
        default=None,
        description=
        "The DNS forwarding proxy additional resolvers used for fallback and local resolution. This field replaces resolvers and default_resolvers fields which are deprecated. Either deprecated fields or new field can be used, both can not be used at same time."
    )
    service_id: Optional[StrictStr] = Field(
        default=None,
        description="The DNS Forwarding Proxy Service ID object identifier.")
    service_name: Optional[StrictStr] = Field(
        default=None,
        description="The name of the DNS Forwarding Proxy Service.")
    site_id: Optional[StrictStr] = Field(
        default=None,
        description=
        "The DNS Forwarding Proxy site identifier that is appended to DNS queries originating from this DNS Forwarding Proxy and subsequently used for policy lookup purposes."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "forwarding_policy", "host", "id", "internal_domain_lists", "name",
        "pop_region_id", "resolvers_all", "service_id", "service_name",
        "site_id"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DfpCreateOrUpdatePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "id",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in host (list)
        _items = []
        if self.host:
            for _item in self.host:
                if _item:
                    _items.append(_item.to_dict())
            _dict['host'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in resolvers_all (list)
        _items = []
        if self.resolvers_all:
            for _item in self.resolvers_all:
                if _item:
                    _items.append(_item.to_dict())
            _dict['resolvers_all'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DfpCreateOrUpdatePayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "forwarding_policy":
            obj.get("forwarding_policy"),
            "host": [DfpHost.from_dict(_item) for _item in obj["host"]]
            if obj.get("host") is not None else None,
            "id":
            obj.get("id"),
            "internal_domain_lists":
            obj.get("internal_domain_lists"),
            "name":
            obj.get("name"),
            "pop_region_id":
            obj.get("pop_region_id"),
            "resolvers_all":
            [Resolver.from_dict(_item) for _item in obj["resolvers_all"]]
            if obj.get("resolvers_all") is not None else None,
            "service_id":
            obj.get("service_id"),
            "service_name":
            obj.get("service_name"),
            "site_id":
            obj.get("site_id")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
