# coding: utf-8

"""
    DNS Configuration API

    The DNS application is a Universal DDI service that provides cloud-based DNS configuration with on-prem host serving DNS protocol. It is part of the full-featured Universal DDI solution that enables customers the ability to deploy large numbers of protocol servers in the delivery of DNS and DHCP throughout their enterprise network.   

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dns_config.models.acl_item import ACLItem
from dns_config.models.auth_zone_external_provider import AuthZoneExternalProvider
from dns_config.models.auth_zone_inheritance import AuthZoneInheritance
from dns_config.models.external_primary import ExternalPrimary
from dns_config.models.external_secondary import ExternalSecondary
from dns_config.models.inheritance2_assigned_host import Inheritance2AssignedHost
from dns_config.models.internal_secondary import InternalSecondary
from dns_config.models.warning import Warning
from dns_config.models.zone_authority import ZoneAuthority
from typing import Optional, Set
from typing_extensions import Self


class AuthZone(BaseModel):
    """
    Authoritative zone.
    """

  # noqa: E501
    comment: Optional[StrictStr] = Field(
        default=None, description="Optional. Comment for zone configuration.")
    created_at: Optional[datetime] = Field(
        default=None, description="Time when the object has been created.")
    disabled: Optional[StrictBool] = Field(
        default=None,
        description=
        "Optional. _true_ to disable object. A disabled object is effectively non-existent when generating configuration."
    )
    external_primaries: Optional[List[ExternalPrimary]] = Field(
        default=None,
        description=
        "Optional. DNS primaries external to BloxOne DDI. Order is not significant."
    )
    external_providers: Optional[List[AuthZoneExternalProvider]] = Field(
        default=None,
        description="list of external providers for the auth zone.")
    external_secondaries: Optional[List[ExternalSecondary]] = Field(
        default=None,
        description=
        "DNS secondaries external to BloxOne DDI. Order is not significant.")
    fqdn: Optional[StrictStr] = Field(
        default=None,
        description=
        "Zone FQDN. The FQDN supplied at creation will be converted to canonical form.  Read-only after creation."
    )
    gss_tsig_enabled: Optional[StrictBool] = Field(
        default=None,
        description=
        "_gss_tsig_enabled_ enables/disables GSS-TSIG signed dynamic updates.  Defaults to _false_."
    )
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    inheritance_assigned_hosts: Optional[
        List[Inheritance2AssignedHost]] = Field(
            default=None,
            description=
            "The list of the inheritance assigned hosts of the object.")
    inheritance_sources: Optional[AuthZoneInheritance] = Field(
        default=None, description="Optional. Inheritance configuration.")
    initial_soa_serial: Optional[StrictInt] = Field(
        default=None,
        description=
        "On-create-only. SOA serial is allowed to be set when the authoritative zone is created."
    )
    internal_secondaries: Optional[List[InternalSecondary]] = Field(
        default=None,
        description=
        "Optional. BloxOne DDI hosts acting as internal secondaries. Order is not significant."
    )
    mapped_subnet: Optional[StrictStr] = Field(
        default=None,
        description=
        "Reverse zone network address in the following format: \"ip-address/cidr\". Defaults to empty."
    )
    mapping: Optional[StrictStr] = Field(
        default=None,
        description=
        "Zone mapping type. Allowed values:  * _forward_,  * _ipv4_reverse_.  * _ipv6_reverse_.  Defaults to forward."
    )
    notify: Optional[StrictBool] = Field(
        default=None,
        description=
        "Also notify all external secondary DNS servers if enabled.  Defaults to _false_."
    )
    nsgs: Optional[List[StrictStr]] = Field(
        default=None, description="The resource identifier.")
    parent: Optional[StrictStr] = Field(default=None,
                                        description="The resource identifier.")
    primary_type: Optional[StrictStr] = Field(
        default=None,
        description=
        "Primary type for an authoritative zone. Read only after creation. Allowed values:  * _external_: zone data owned by an external nameserver,  * _cloud_: zone data is owned by a BloxOne DDI host."
    )
    protocol_fqdn: Optional[StrictStr] = Field(
        default=None, description="Zone FQDN in punycode.")
    query_acl: Optional[List[ACLItem]] = Field(
        default=None,
        description=
        "Optional. Clients must match this ACL to make authoritative queries. Also used for recursive queries if that ACL is unset.  Defaults to empty."
    )
    tags: Optional[Dict[str, Any]] = Field(default=None,
                                           description="Tagging specifics.")
    transfer_acl: Optional[List[ACLItem]] = Field(
        default=None,
        description=
        "Optional. Clients must match this ACL to receive zone transfers.")
    update_acl: Optional[List[ACLItem]] = Field(
        default=None,
        description=
        "Optional. Specifies which hosts are allowed to submit Dynamic DNS updates for authoritative zones of _primary_type_ _cloud_.  Defaults to empty."
    )
    updated_at: Optional[datetime] = Field(
        default=None,
        description=
        "Time when the object has been updated. Equals to _created_at_ if not updated after creation."
    )
    use_forwarders_for_subzones: Optional[StrictBool] = Field(
        default=None,
        description=
        "Optional. Use default forwarders to resolve queries for subzones.  Defaults to _true_."
    )
    view: Optional[StrictStr] = Field(default=None,
                                      description="The resource identifier.")
    warnings: Optional[List[Warning]] = Field(
        default=None, description="The list of an auth zone warnings.")
    zone_authority: Optional[ZoneAuthority] = Field(
        default=None, description="Optional. ZoneAuthority.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "comment", "created_at", "disabled", "external_primaries",
        "external_providers", "external_secondaries", "fqdn",
        "gss_tsig_enabled", "id", "inheritance_assigned_hosts",
        "inheritance_sources", "initial_soa_serial", "internal_secondaries",
        "mapped_subnet", "mapping", "notify", "nsgs", "parent", "primary_type",
        "protocol_fqdn", "query_acl", "tags", "transfer_acl", "update_acl",
        "updated_at", "use_forwarders_for_subzones", "view", "warnings",
        "zone_authority"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthZone from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "external_providers",
            "id",
            "inheritance_assigned_hosts",
            "mapped_subnet",
            "mapping",
            "protocol_fqdn",
            "updated_at",
            "warnings",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in external_primaries (list)
        _items = []
        if self.external_primaries:
            for _item in self.external_primaries:
                if _item:
                    _items.append(_item.to_dict())
            _dict['external_primaries'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in external_providers (list)
        _items = []
        if self.external_providers:
            for _item in self.external_providers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['external_providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in external_secondaries (list)
        _items = []
        if self.external_secondaries:
            for _item in self.external_secondaries:
                if _item:
                    _items.append(_item.to_dict())
            _dict['external_secondaries'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in inheritance_assigned_hosts (list)
        _items = []
        if self.inheritance_assigned_hosts:
            for _item in self.inheritance_assigned_hosts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['inheritance_assigned_hosts'] = _items
        # override the default output from pydantic by calling `to_dict()` of inheritance_sources
        if self.inheritance_sources:
            _dict['inheritance_sources'] = self.inheritance_sources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in internal_secondaries (list)
        _items = []
        if self.internal_secondaries:
            for _item in self.internal_secondaries:
                if _item:
                    _items.append(_item.to_dict())
            _dict['internal_secondaries'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in query_acl (list)
        _items = []
        if self.query_acl:
            for _item in self.query_acl:
                if _item:
                    _items.append(_item.to_dict())
            _dict['query_acl'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transfer_acl (list)
        _items = []
        if self.transfer_acl:
            for _item in self.transfer_acl:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transfer_acl'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in update_acl (list)
        _items = []
        if self.update_acl:
            for _item in self.update_acl:
                if _item:
                    _items.append(_item.to_dict())
            _dict['update_acl'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['warnings'] = _items
        # override the default output from pydantic by calling `to_dict()` of zone_authority
        if self.zone_authority:
            _dict['zone_authority'] = self.zone_authority.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthZone from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "comment":
            obj.get("comment"),
            "created_at":
            obj.get("created_at"),
            "disabled":
            obj.get("disabled"),
            "external_primaries": [
                ExternalPrimary.from_dict(_item)
                for _item in obj["external_primaries"]
            ] if obj.get("external_primaries") is not None else None,
            "external_providers": [
                AuthZoneExternalProvider.from_dict(_item)
                for _item in obj["external_providers"]
            ] if obj.get("external_providers") is not None else None,
            "external_secondaries": [
                ExternalSecondary.from_dict(_item)
                for _item in obj["external_secondaries"]
            ] if obj.get("external_secondaries") is not None else None,
            "fqdn":
            obj.get("fqdn"),
            "gss_tsig_enabled":
            obj.get("gss_tsig_enabled"),
            "id":
            obj.get("id"),
            "inheritance_assigned_hosts": [
                Inheritance2AssignedHost.from_dict(_item)
                for _item in obj["inheritance_assigned_hosts"]
            ] if obj.get("inheritance_assigned_hosts") is not None else None,
            "inheritance_sources":
            AuthZoneInheritance.from_dict(obj["inheritance_sources"])
            if obj.get("inheritance_sources") is not None else None,
            "initial_soa_serial":
            obj.get("initial_soa_serial"),
            "internal_secondaries": [
                InternalSecondary.from_dict(_item)
                for _item in obj["internal_secondaries"]
            ] if obj.get("internal_secondaries") is not None else None,
            "mapped_subnet":
            obj.get("mapped_subnet"),
            "mapping":
            obj.get("mapping"),
            "notify":
            obj.get("notify"),
            "nsgs":
            obj.get("nsgs"),
            "parent":
            obj.get("parent"),
            "primary_type":
            obj.get("primary_type"),
            "protocol_fqdn":
            obj.get("protocol_fqdn"),
            "query_acl":
            [ACLItem.from_dict(_item) for _item in obj["query_acl"]]
            if obj.get("query_acl") is not None else None,
            "tags":
            obj.get("tags"),
            "transfer_acl":
            [ACLItem.from_dict(_item) for _item in obj["transfer_acl"]]
            if obj.get("transfer_acl") is not None else None,
            "update_acl":
            [ACLItem.from_dict(_item) for _item in obj["update_acl"]]
            if obj.get("update_acl") is not None else None,
            "updated_at":
            obj.get("updated_at"),
            "use_forwarders_for_subzones":
            obj.get("use_forwarders_for_subzones"),
            "view":
            obj.get("view"),
            "warnings":
            [Warning.from_dict(_item) for _item in obj["warnings"]]
            if obj.get("warnings") is not None else None,
            "zone_authority":
            ZoneAuthority.from_dict(obj["zone_authority"])
            if obj.get("zone_authority") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
