# coding: utf-8

"""
    DNS Configuration API

    The DNS application is a Universal DDI service that provides cloud-based DNS configuration with on-prem host serving DNS protocol. It is part of the full-featured Universal DDI solution that enables customers the ability to deploy large numbers of protocol servers in the delivery of DNS and DHCP throughout their enterprise network.   

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class CacheFlush(BaseModel):
    """
    The _dns/cache_flush_ API removes entries from the DNS cache on the on-prem host. The command will be forwarded to the on-prem host and executed asynchronously. The on-prem host must be available and running DNS for this to succeed.
    """ # noqa: E501
    flush_subdomains: Optional[StrictBool] = Field(
        default=None,
        description=
        "Optional. If _true_, all names below the given FQDN will also be removed from cache.  Defaults to _true_."
    )
    fqdn: Optional[StrictStr] = Field(
        default=None,
        description="Optional. The FQDN to remove.  Defaults to '.'")
    ophid: Optional[StrictStr] = Field(
        default=None,
        description=
        "The host to alter. Either _ophid_ or _service_id_ should be provided."
    )
    service_id: Optional[StrictStr] = Field(
        default=None,
        description=
        "Service Id. Either _ophid_ or _service_id_ should be provided.")
    ttl: Optional[StrictInt] = Field(
        default=None,
        description=
        "Optional. The time in seconds the command is valid for. Command is executed on the onprem host only if it takes less than this time for the command to be transmitted to the host. Otherwise the onprem host discards this command.  Defaults to 120 (2 min)."
    )
    view_name: Optional[StrictStr] = Field(
        default=None,
        description=
        "Optional, If provided, flushes the server's cache for a view.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "flush_subdomains", "fqdn", "ophid", "service_id", "ttl", "view_name"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CacheFlush from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CacheFlush from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "flush_subdomains":
            obj.get("flush_subdomains"),
            "fqdn":
            obj.get("fqdn"),
            "ophid":
            obj.get("ophid"),
            "service_id":
            obj.get("service_id"),
            "ttl":
            obj.get("ttl"),
            "view_name":
            obj.get("view_name")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
