# coding: utf-8

"""
    Infoblox FW API

    Infoblox Threat Defense Cloud is an extension of the Infoblox Suite that provides visibility into infected and compromised off-premises devices, roaming users, remote sites, and branch offices. You can subscribe to Infoblox Cloud and use its functionality to mitigate and control malware as well as provide unprecedented insight into your network security posture and enable timely action. Infoblox Cloud also offers unified policy management, reporting, and threat analytics across the entire spectrum. Using automated and high-quality threat intelligence feeds and unique behavioral analytics, it automatically stops device communications with C&Cs/botnets and prevents DNS based data exfiltration.  The mission-critical DNS infrastructure can become a vulnerable component in your network when it is inadequately protected by traditional security solutions and consequently used as an attack surface. Compromised DNS services can result in catastrophic network and system failures. To fully protect your network in today’s cyber security threat environment, Infoblox sets a new DNS security standard by offering scalable, enterprise-grade, and integrated protection for your DNS infrastructure.  Through the Infoblox Cloud Services Portal, you can view the status of your subscription and threat intelligence feeds, manage your network scope and roaming end users, and learn more about threats on your networks through the Infoblox Threat Lookup tool and predefined reports. 

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fw.models.application_criterion import ApplicationCriterion
from typing import Optional, Set
from typing_extensions import Self


class ApplicationFilter(BaseModel):
    """
    The Application Filter object.  Application filters are content application rules that Infoblox Cloud uses to detect and filter specific internet content.
    """ # noqa: E501
    created_time: Optional[datetime] = Field(
        default=None,
        description="The time when this Application Filter object was created."
    )
    criteria: Optional[List[ApplicationCriterion]] = Field(
        default=None,
        description=
        "The array of key-value pairs specifying criteria for the search.")
    description: Optional[StrictStr] = Field(
        default=None,
        description="The brief description for the application filter.")
    id: Optional[StrictInt] = Field(
        default=None, description="The Application Filter object identifier.")
    name: Optional[StrictStr] = Field(
        default=None, description="The name of the application filter.")
    policies: Optional[List[StrictStr]] = Field(
        default=None,
        description=
        "The list of security policy names with which the application filter is associated."
    )
    readonly: Optional[StrictBool] = Field(
        default=None,
        description="True if it is a predefined application filter")
    tags: Optional[Dict[str, Any]] = Field(
        default=None,
        description=
        "Enables tag support for resource where tags attribute contains user-defined key value pairs"
    )
    updated_time: Optional[datetime] = Field(
        default=None,
        description=
        "The time when this Application Filter object was last updated.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "created_time", "criteria", "description", "id", "name", "policies",
        "readonly", "tags", "updated_time"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "created_time",
            "id",
            "policies",
            "updated_time",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in criteria (list)
        _items = []
        if self.criteria:
            for _item in self.criteria:
                if _item:
                    _items.append(_item.to_dict())
            _dict['criteria'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_time":
            obj.get("created_time"),
            "criteria": [
                ApplicationCriterion.from_dict(_item)
                for _item in obj["criteria"]
            ] if obj.get("criteria") is not None else None,
            "description":
            obj.get("description"),
            "id":
            obj.get("id"),
            "name":
            obj.get("name"),
            "policies":
            obj.get("policies"),
            "readonly":
            obj.get("readonly"),
            "tags":
            obj.get("tags"),
            "updated_time":
            obj.get("updated_time")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
